/* valaarraytype.c generated by valac, the Vala compiler
 * generated from valaarraytype.vala, do not modify */

/* valaarraytype.vala
 *
 * Copyright (C) 2007-2012  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include <glib.h>
#include <glib-object.h>
#include "vala.h"
#include <stdlib.h>
#include <string.h>
#include <valagee.h>

#define _vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _vala_code_context_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_context_unref (var), NULL)))

struct _ValaArrayTypePrivate {
	gboolean _invalid_syntax;
	gboolean _inline_allocated;
	gboolean _fixed_length;
	gint _rank;
	ValaDataType* _element_type;
	ValaExpression* _length;
	ValaArrayLengthField* length_field;
	ValaArrayResizeMethod* resize_method;
	ValaArrayMoveMethod* move_method;
	ValaArrayCopyMethod* copy_method;
};


static gpointer vala_array_type_parent_class = NULL;

#define VALA_ARRAY_TYPE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_ARRAY_TYPE, ValaArrayTypePrivate))
static ValaSymbol* vala_array_type_real_get_member (ValaDataType* base, const gchar* member_name);
static ValaArrayLengthField* vala_array_type_get_length_field (ValaArrayType* self);
static ValaArrayMoveMethod* vala_array_type_get_move_method (ValaArrayType* self);
static ValaArrayResizeMethod* vala_array_type_get_resize_method (ValaArrayType* self);
static ValaArrayCopyMethod* vala_array_type_get_copy_method (ValaArrayType* self);
static ValaDataType* vala_array_type_real_copy (ValaDataType* base);
static gboolean vala_array_type_real_is_array (ValaDataType* base);
static gchar* vala_array_type_real_to_qualified_string (ValaDataType* base, ValaScope* scope);
static gboolean vala_array_type_real_compatible (ValaDataType* base, ValaDataType* target_type);
static gboolean vala_array_type_real_is_reference_type_or_type_parameter (ValaDataType* base);
static void vala_array_type_real_accept_children (ValaCodeNode* base, ValaCodeVisitor* visitor);
static void vala_array_type_real_replace_type (ValaCodeNode* base, ValaDataType* old_type, ValaDataType* new_type);
static gboolean vala_array_type_real_is_accessible (ValaDataType* base, ValaSymbol* sym);
static gboolean vala_array_type_real_check (ValaCodeNode* base, ValaCodeContext* context);
static ValaDataType* vala_array_type_real_get_actual_type (ValaDataType* base, ValaDataType* derived_instance_type, ValaList* method_type_arguments, ValaCodeNode* node_reference);
static ValaDataType* vala_array_type_real_infer_type_argument (ValaDataType* base, ValaTypeParameter* type_param, ValaDataType* value_type);
static gboolean vala_array_type_real_is_disposable (ValaDataType* base);
static void vala_array_type_finalize (ValaCodeNode * obj);


ValaArrayType* vala_array_type_construct (GType object_type, ValaDataType* element_type, gint rank, ValaSourceReference* source_reference) {
	ValaArrayType* self = NULL;
	ValaDataType* _tmp0_;
	gint _tmp1_;
	ValaSourceReference* _tmp2_;
	g_return_val_if_fail (element_type != NULL, NULL);
	self = (ValaArrayType*) vala_reference_type_construct (object_type);
	_tmp0_ = element_type;
	vala_array_type_set_element_type (self, _tmp0_);
	_tmp1_ = rank;
	vala_array_type_set_rank (self, _tmp1_);
	_tmp2_ = source_reference;
	vala_code_node_set_source_reference ((ValaCodeNode*) self, _tmp2_);
	return self;
}


ValaArrayType* vala_array_type_new (ValaDataType* element_type, gint rank, ValaSourceReference* source_reference) {
	return vala_array_type_construct (VALA_TYPE_ARRAY_TYPE, element_type, rank, source_reference);
}


static ValaSymbol* vala_array_type_real_get_member (ValaDataType* base, const gchar* member_name) {
	ValaArrayType * self;
	ValaSymbol* result = NULL;
	const gchar* _tmp0_;
	self = (ValaArrayType*) base;
	g_return_val_if_fail (member_name != NULL, NULL);
	_tmp0_ = member_name;
	if (g_strcmp0 (_tmp0_, "length") == 0) {
		ValaArrayLengthField* _tmp1_;
		_tmp1_ = vala_array_type_get_length_field (self);
		result = (ValaSymbol*) _tmp1_;
		return result;
	} else {
		const gchar* _tmp2_;
		_tmp2_ = member_name;
		if (g_strcmp0 (_tmp2_, "move") == 0) {
			ValaArrayMoveMethod* _tmp3_;
			_tmp3_ = vala_array_type_get_move_method (self);
			result = (ValaSymbol*) _tmp3_;
			return result;
		} else {
			const gchar* _tmp4_;
			_tmp4_ = member_name;
			if (g_strcmp0 (_tmp4_, "resize") == 0) {
				gint _tmp5_;
				ValaArrayResizeMethod* _tmp6_;
				_tmp5_ = self->priv->_rank;
				if (_tmp5_ > 1) {
					result = NULL;
					return result;
				}
				_tmp6_ = vala_array_type_get_resize_method (self);
				result = (ValaSymbol*) _tmp6_;
				return result;
			} else {
				const gchar* _tmp7_;
				_tmp7_ = member_name;
				if (g_strcmp0 (_tmp7_, "copy") == 0) {
					ValaArrayCopyMethod* _tmp8_;
					_tmp8_ = vala_array_type_get_copy_method (self);
					result = (ValaSymbol*) _tmp8_;
					return result;
				}
			}
		}
	}
	result = NULL;
	return result;
}


static gpointer _vala_code_node_ref0 (gpointer self) {
	return self ? vala_code_node_ref (self) : NULL;
}


static ValaArrayLengthField* vala_array_type_get_length_field (ValaArrayType* self) {
	ValaArrayLengthField* result = NULL;
	ValaArrayLengthField* _tmp0_;
	ValaArrayLengthField* _tmp36_;
	ValaArrayLengthField* _tmp37_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->length_field;
	if (_tmp0_ == NULL) {
		ValaSourceReference* _tmp1_;
		ValaSourceReference* _tmp2_;
		ValaArrayLengthField* _tmp3_;
		ValaArrayLengthField* _tmp4_;
		ValaNamespace* root_symbol = NULL;
		ValaSourceReference* _tmp5_;
		ValaSourceReference* _tmp6_;
		ValaSourceFile* _tmp7_;
		ValaSourceFile* _tmp8_;
		ValaCodeContext* _tmp9_;
		ValaCodeContext* _tmp10_;
		ValaNamespace* _tmp11_;
		ValaNamespace* _tmp12_;
		ValaNamespace* _tmp13_;
		gint _tmp14_;
		_tmp1_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp2_ = _tmp1_;
		_tmp3_ = vala_array_length_field_new (_tmp2_);
		_vala_code_node_unref0 (self->priv->length_field);
		self->priv->length_field = _tmp3_;
		_tmp4_ = self->priv->length_field;
		vala_symbol_set_access ((ValaSymbol*) _tmp4_, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
		_tmp5_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp6_ = _tmp5_;
		_tmp7_ = vala_source_reference_get_file (_tmp6_);
		_tmp8_ = _tmp7_;
		_tmp9_ = vala_source_file_get_context (_tmp8_);
		_tmp10_ = _tmp9_;
		_tmp11_ = vala_code_context_get_root (_tmp10_);
		_tmp12_ = _tmp11_;
		_tmp13_ = _vala_code_node_ref0 (_tmp12_);
		root_symbol = _tmp13_;
		_tmp14_ = self->priv->_rank;
		if (_tmp14_ > 1) {
			ValaValueType* integer = NULL;
			ValaNamespace* _tmp15_;
			ValaScope* _tmp16_;
			ValaScope* _tmp17_;
			ValaSymbol* _tmp18_;
			ValaStruct* _tmp19_;
			ValaIntegerType* _tmp20_;
			ValaValueType* _tmp21_;
			ValaArrayLengthField* _tmp22_;
			ValaValueType* _tmp23_;
			ValaSourceReference* _tmp24_;
			ValaSourceReference* _tmp25_;
			ValaArrayType* _tmp26_;
			ValaArrayType* _tmp27_;
			_tmp15_ = root_symbol;
			_tmp16_ = vala_symbol_get_scope ((ValaSymbol*) _tmp15_);
			_tmp17_ = _tmp16_;
			_tmp18_ = vala_scope_lookup (_tmp17_, "int");
			_tmp19_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp18_, VALA_TYPE_STRUCT, ValaStruct);
			_tmp20_ = vala_integer_type_new (_tmp19_, NULL, NULL);
			_tmp21_ = (ValaValueType*) _tmp20_;
			_vala_code_node_unref0 (_tmp19_);
			integer = _tmp21_;
			_tmp22_ = self->priv->length_field;
			_tmp23_ = integer;
			_tmp24_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp25_ = _tmp24_;
			_tmp26_ = vala_array_type_new ((ValaDataType*) _tmp23_, 1, _tmp25_);
			_tmp27_ = _tmp26_;
			vala_variable_set_variable_type ((ValaVariable*) _tmp22_, (ValaDataType*) _tmp27_);
			_vala_code_node_unref0 (_tmp27_);
			_vala_code_node_unref0 (integer);
		} else {
			ValaArrayLengthField* _tmp28_;
			ValaNamespace* _tmp29_;
			ValaScope* _tmp30_;
			ValaScope* _tmp31_;
			ValaSymbol* _tmp32_;
			ValaStruct* _tmp33_;
			ValaIntegerType* _tmp34_;
			ValaIntegerType* _tmp35_;
			_tmp28_ = self->priv->length_field;
			_tmp29_ = root_symbol;
			_tmp30_ = vala_symbol_get_scope ((ValaSymbol*) _tmp29_);
			_tmp31_ = _tmp30_;
			_tmp32_ = vala_scope_lookup (_tmp31_, "int");
			_tmp33_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp32_, VALA_TYPE_STRUCT, ValaStruct);
			_tmp34_ = vala_integer_type_new (_tmp33_, NULL, NULL);
			_tmp35_ = _tmp34_;
			vala_variable_set_variable_type ((ValaVariable*) _tmp28_, (ValaDataType*) _tmp35_);
			_vala_code_node_unref0 (_tmp35_);
			_vala_code_node_unref0 (_tmp33_);
		}
		_vala_code_node_unref0 (root_symbol);
	}
	_tmp36_ = self->priv->length_field;
	_tmp37_ = _vala_code_node_ref0 (_tmp36_);
	result = _tmp37_;
	return result;
}


static ValaArrayResizeMethod* vala_array_type_get_resize_method (ValaArrayType* self) {
	ValaArrayResizeMethod* result = NULL;
	ValaArrayResizeMethod* _tmp0_;
	ValaArrayResizeMethod* _tmp30_;
	ValaArrayResizeMethod* _tmp31_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->resize_method;
	if (_tmp0_ == NULL) {
		ValaSourceReference* _tmp1_;
		ValaSourceReference* _tmp2_;
		ValaArrayResizeMethod* _tmp3_;
		ValaArrayResizeMethod* _tmp4_;
		ValaVoidType* _tmp5_;
		ValaVoidType* _tmp6_;
		ValaArrayResizeMethod* _tmp7_;
		ValaArrayResizeMethod* _tmp8_;
		ValaNamespace* root_symbol = NULL;
		ValaSourceReference* _tmp9_;
		ValaSourceReference* _tmp10_;
		ValaSourceFile* _tmp11_;
		ValaSourceFile* _tmp12_;
		ValaCodeContext* _tmp13_;
		ValaCodeContext* _tmp14_;
		ValaNamespace* _tmp15_;
		ValaNamespace* _tmp16_;
		ValaNamespace* _tmp17_;
		ValaIntegerType* int_type = NULL;
		ValaNamespace* _tmp18_;
		ValaScope* _tmp19_;
		ValaScope* _tmp20_;
		ValaSymbol* _tmp21_;
		ValaStruct* _tmp22_;
		ValaIntegerType* _tmp23_;
		ValaIntegerType* _tmp24_;
		ValaArrayResizeMethod* _tmp25_;
		ValaIntegerType* _tmp26_;
		ValaParameter* _tmp27_;
		ValaParameter* _tmp28_;
		ValaArrayResizeMethod* _tmp29_;
		_tmp1_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp2_ = _tmp1_;
		_tmp3_ = vala_array_resize_method_new (_tmp2_);
		_vala_code_node_unref0 (self->priv->resize_method);
		self->priv->resize_method = _tmp3_;
		_tmp4_ = self->priv->resize_method;
		_tmp5_ = vala_void_type_new (NULL);
		_tmp6_ = _tmp5_;
		vala_callable_set_return_type ((ValaCallable*) _tmp4_, (ValaDataType*) _tmp6_);
		_vala_code_node_unref0 (_tmp6_);
		_tmp7_ = self->priv->resize_method;
		vala_symbol_set_access ((ValaSymbol*) _tmp7_, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
		_tmp8_ = self->priv->resize_method;
		vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp8_, "CCode", "cname", "g_renew", NULL);
		_tmp9_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp10_ = _tmp9_;
		_tmp11_ = vala_source_reference_get_file (_tmp10_);
		_tmp12_ = _tmp11_;
		_tmp13_ = vala_source_file_get_context (_tmp12_);
		_tmp14_ = _tmp13_;
		_tmp15_ = vala_code_context_get_root (_tmp14_);
		_tmp16_ = _tmp15_;
		_tmp17_ = _vala_code_node_ref0 (_tmp16_);
		root_symbol = _tmp17_;
		_tmp18_ = root_symbol;
		_tmp19_ = vala_symbol_get_scope ((ValaSymbol*) _tmp18_);
		_tmp20_ = _tmp19_;
		_tmp21_ = vala_scope_lookup (_tmp20_, "int");
		_tmp22_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp21_, VALA_TYPE_STRUCT, ValaStruct);
		_tmp23_ = vala_integer_type_new (_tmp22_, NULL, NULL);
		_tmp24_ = _tmp23_;
		_vala_code_node_unref0 (_tmp22_);
		int_type = _tmp24_;
		_tmp25_ = self->priv->resize_method;
		_tmp26_ = int_type;
		_tmp27_ = vala_parameter_new ("length", (ValaDataType*) _tmp26_, NULL);
		_tmp28_ = _tmp27_;
		vala_callable_add_parameter ((ValaCallable*) _tmp25_, _tmp28_);
		_vala_code_node_unref0 (_tmp28_);
		_tmp29_ = self->priv->resize_method;
		vala_method_set_returns_modified_pointer ((ValaMethod*) _tmp29_, TRUE);
		_vala_code_node_unref0 (int_type);
		_vala_code_node_unref0 (root_symbol);
	}
	_tmp30_ = self->priv->resize_method;
	_tmp31_ = _vala_code_node_ref0 (_tmp30_);
	result = _tmp31_;
	return result;
}


static ValaArrayMoveMethod* vala_array_type_get_move_method (ValaArrayType* self) {
	ValaArrayMoveMethod* result = NULL;
	ValaArrayMoveMethod* _tmp0_;
	ValaArrayMoveMethod* _tmp37_;
	ValaArrayMoveMethod* _tmp38_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->move_method;
	if (_tmp0_ == NULL) {
		ValaSourceReference* _tmp1_;
		ValaSourceReference* _tmp2_;
		ValaArrayMoveMethod* _tmp3_;
		ValaArrayMoveMethod* _tmp4_;
		ValaVoidType* _tmp5_;
		ValaVoidType* _tmp6_;
		ValaArrayMoveMethod* _tmp7_;
		ValaArrayMoveMethod* _tmp8_;
		ValaNamespace* root_symbol = NULL;
		ValaSourceReference* _tmp9_;
		ValaSourceReference* _tmp10_;
		ValaSourceFile* _tmp11_;
		ValaSourceFile* _tmp12_;
		ValaCodeContext* _tmp13_;
		ValaCodeContext* _tmp14_;
		ValaNamespace* _tmp15_;
		ValaNamespace* _tmp16_;
		ValaNamespace* _tmp17_;
		ValaIntegerType* int_type = NULL;
		ValaNamespace* _tmp18_;
		ValaScope* _tmp19_;
		ValaScope* _tmp20_;
		ValaSymbol* _tmp21_;
		ValaStruct* _tmp22_;
		ValaIntegerType* _tmp23_;
		ValaIntegerType* _tmp24_;
		ValaArrayMoveMethod* _tmp25_;
		ValaIntegerType* _tmp26_;
		ValaParameter* _tmp27_;
		ValaParameter* _tmp28_;
		ValaArrayMoveMethod* _tmp29_;
		ValaIntegerType* _tmp30_;
		ValaParameter* _tmp31_;
		ValaParameter* _tmp32_;
		ValaArrayMoveMethod* _tmp33_;
		ValaIntegerType* _tmp34_;
		ValaParameter* _tmp35_;
		ValaParameter* _tmp36_;
		_tmp1_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp2_ = _tmp1_;
		_tmp3_ = vala_array_move_method_new (_tmp2_);
		_vala_code_node_unref0 (self->priv->move_method);
		self->priv->move_method = _tmp3_;
		_tmp4_ = self->priv->move_method;
		_tmp5_ = vala_void_type_new (NULL);
		_tmp6_ = _tmp5_;
		vala_callable_set_return_type ((ValaCallable*) _tmp4_, (ValaDataType*) _tmp6_);
		_vala_code_node_unref0 (_tmp6_);
		_tmp7_ = self->priv->move_method;
		vala_symbol_set_access ((ValaSymbol*) _tmp7_, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
		_tmp8_ = self->priv->move_method;
		vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp8_, "CCode", "cname", "_vala_array_move", NULL);
		_tmp9_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp10_ = _tmp9_;
		_tmp11_ = vala_source_reference_get_file (_tmp10_);
		_tmp12_ = _tmp11_;
		_tmp13_ = vala_source_file_get_context (_tmp12_);
		_tmp14_ = _tmp13_;
		_tmp15_ = vala_code_context_get_root (_tmp14_);
		_tmp16_ = _tmp15_;
		_tmp17_ = _vala_code_node_ref0 (_tmp16_);
		root_symbol = _tmp17_;
		_tmp18_ = root_symbol;
		_tmp19_ = vala_symbol_get_scope ((ValaSymbol*) _tmp18_);
		_tmp20_ = _tmp19_;
		_tmp21_ = vala_scope_lookup (_tmp20_, "int");
		_tmp22_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp21_, VALA_TYPE_STRUCT, ValaStruct);
		_tmp23_ = vala_integer_type_new (_tmp22_, NULL, NULL);
		_tmp24_ = _tmp23_;
		_vala_code_node_unref0 (_tmp22_);
		int_type = _tmp24_;
		_tmp25_ = self->priv->move_method;
		_tmp26_ = int_type;
		_tmp27_ = vala_parameter_new ("src", (ValaDataType*) _tmp26_, NULL);
		_tmp28_ = _tmp27_;
		vala_callable_add_parameter ((ValaCallable*) _tmp25_, _tmp28_);
		_vala_code_node_unref0 (_tmp28_);
		_tmp29_ = self->priv->move_method;
		_tmp30_ = int_type;
		_tmp31_ = vala_parameter_new ("dest", (ValaDataType*) _tmp30_, NULL);
		_tmp32_ = _tmp31_;
		vala_callable_add_parameter ((ValaCallable*) _tmp29_, _tmp32_);
		_vala_code_node_unref0 (_tmp32_);
		_tmp33_ = self->priv->move_method;
		_tmp34_ = int_type;
		_tmp35_ = vala_parameter_new ("length", (ValaDataType*) _tmp34_, NULL);
		_tmp36_ = _tmp35_;
		vala_callable_add_parameter ((ValaCallable*) _tmp33_, _tmp36_);
		_vala_code_node_unref0 (_tmp36_);
		_vala_code_node_unref0 (int_type);
		_vala_code_node_unref0 (root_symbol);
	}
	_tmp37_ = self->priv->move_method;
	_tmp38_ = _vala_code_node_ref0 (_tmp37_);
	result = _tmp38_;
	return result;
}


static ValaArrayCopyMethod* vala_array_type_get_copy_method (ValaArrayType* self) {
	ValaArrayCopyMethod* result = NULL;
	ValaArrayCopyMethod* _tmp0_;
	ValaArrayCopyMethod* _tmp12_;
	ValaArrayCopyMethod* _tmp13_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->copy_method;
	if (_tmp0_ == NULL) {
		ValaSourceReference* _tmp1_;
		ValaSourceReference* _tmp2_;
		ValaArrayCopyMethod* _tmp3_;
		ValaArrayCopyMethod* _tmp4_;
		ValaDataType* _tmp5_;
		ValaDataType* _tmp6_;
		ValaArrayCopyMethod* _tmp7_;
		ValaDataType* _tmp8_;
		ValaDataType* _tmp9_;
		ValaArrayCopyMethod* _tmp10_;
		ValaArrayCopyMethod* _tmp11_;
		_tmp1_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp2_ = _tmp1_;
		_tmp3_ = vala_array_copy_method_new (_tmp2_);
		_vala_code_node_unref0 (self->priv->copy_method);
		self->priv->copy_method = _tmp3_;
		_tmp4_ = self->priv->copy_method;
		_tmp5_ = vala_data_type_copy ((ValaDataType*) self);
		_tmp6_ = _tmp5_;
		vala_callable_set_return_type ((ValaCallable*) _tmp4_, _tmp6_);
		_vala_code_node_unref0 (_tmp6_);
		_tmp7_ = self->priv->copy_method;
		_tmp8_ = vala_callable_get_return_type ((ValaCallable*) _tmp7_);
		_tmp9_ = _tmp8_;
		vala_data_type_set_value_owned (_tmp9_, TRUE);
		_tmp10_ = self->priv->copy_method;
		vala_symbol_set_access ((ValaSymbol*) _tmp10_, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
		_tmp11_ = self->priv->copy_method;
		vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp11_, "CCode", "cname", "_vala_array_copy", NULL);
	}
	_tmp12_ = self->priv->copy_method;
	_tmp13_ = _vala_code_node_ref0 (_tmp12_);
	result = _tmp13_;
	return result;
}


static ValaDataType* vala_array_type_real_copy (ValaDataType* base) {
	ValaArrayType * self;
	ValaDataType* result = NULL;
	ValaArrayType* _result_ = NULL;
	ValaDataType* _tmp0_;
	ValaDataType* _tmp1_;
	ValaDataType* _tmp2_;
	ValaDataType* _tmp3_;
	gint _tmp4_;
	ValaSourceReference* _tmp5_;
	ValaSourceReference* _tmp6_;
	ValaArrayType* _tmp7_;
	ValaArrayType* _tmp8_;
	ValaArrayType* _tmp9_;
	gboolean _tmp10_;
	gboolean _tmp11_;
	ValaArrayType* _tmp12_;
	gboolean _tmp13_;
	gboolean _tmp14_;
	ValaArrayType* _tmp15_;
	gboolean _tmp16_;
	gboolean _tmp17_;
	ValaArrayType* _tmp18_;
	gboolean _tmp19_;
	gboolean _tmp20_;
	self = (ValaArrayType*) base;
	_tmp0_ = vala_array_type_get_element_type (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = vala_data_type_copy (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = self->priv->_rank;
	_tmp5_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
	_tmp6_ = _tmp5_;
	_tmp7_ = vala_array_type_new (_tmp3_, _tmp4_, _tmp6_);
	_tmp8_ = _tmp7_;
	_vala_code_node_unref0 (_tmp3_);
	_result_ = _tmp8_;
	_tmp9_ = _result_;
	_tmp10_ = vala_data_type_get_value_owned ((ValaDataType*) self);
	_tmp11_ = _tmp10_;
	vala_data_type_set_value_owned ((ValaDataType*) _tmp9_, _tmp11_);
	_tmp12_ = _result_;
	_tmp13_ = vala_data_type_get_nullable ((ValaDataType*) self);
	_tmp14_ = _tmp13_;
	vala_data_type_set_nullable ((ValaDataType*) _tmp12_, _tmp14_);
	_tmp15_ = _result_;
	_tmp16_ = vala_data_type_get_floating_reference ((ValaDataType*) self);
	_tmp17_ = _tmp16_;
	vala_data_type_set_floating_reference ((ValaDataType*) _tmp15_, _tmp17_);
	_tmp18_ = _result_;
	_tmp19_ = self->priv->_inline_allocated;
	vala_array_type_set_inline_allocated (_tmp18_, _tmp19_);
	_tmp20_ = self->priv->_fixed_length;
	if (_tmp20_) {
		ValaArrayType* _tmp21_;
		ValaArrayType* _tmp22_;
		ValaExpression* _tmp23_;
		ValaExpression* _tmp24_;
		_tmp21_ = _result_;
		vala_array_type_set_fixed_length (_tmp21_, TRUE);
		_tmp22_ = _result_;
		_tmp23_ = vala_array_type_get_length (self);
		_tmp24_ = _tmp23_;
		vala_array_type_set_length (_tmp22_, _tmp24_);
	}
	result = (ValaDataType*) _result_;
	return result;
}


static gboolean vala_array_type_real_is_array (ValaDataType* base) {
	ValaArrayType * self;
	gboolean result = FALSE;
	self = (ValaArrayType*) base;
	result = TRUE;
	return result;
}


static gchar* vala_array_type_real_to_qualified_string (ValaDataType* base, ValaScope* scope) {
	ValaArrayType * self;
	gchar* result = NULL;
	gchar* elem_str = NULL;
	ValaDataType* _tmp0_;
	ValaDataType* _tmp1_;
	ValaScope* _tmp2_;
	gchar* _tmp3_;
	gboolean _tmp4_ = FALSE;
	ValaDataType* _tmp5_;
	ValaDataType* _tmp6_;
	gboolean _tmp7_;
	gboolean _tmp12_;
	self = (ValaArrayType*) base;
	_tmp0_ = vala_array_type_get_element_type (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = scope;
	_tmp3_ = vala_data_type_to_qualified_string (_tmp1_, _tmp2_);
	elem_str = _tmp3_;
	_tmp5_ = vala_array_type_get_element_type (self);
	_tmp6_ = _tmp5_;
	_tmp7_ = vala_data_type_is_weak (_tmp6_);
	if (_tmp7_) {
		ValaCodeNode* _tmp8_;
		ValaCodeNode* _tmp9_;
		_tmp8_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
		_tmp9_ = _tmp8_;
		_tmp4_ = !G_TYPE_CHECK_INSTANCE_TYPE (_tmp9_, VALA_TYPE_CONSTANT);
	} else {
		_tmp4_ = FALSE;
	}
	if (_tmp4_) {
		const gchar* _tmp10_;
		gchar* _tmp11_;
		_tmp10_ = elem_str;
		_tmp11_ = g_strdup_printf ("(unowned %s)", _tmp10_);
		_g_free0 (elem_str);
		elem_str = _tmp11_;
	}
	_tmp12_ = self->priv->_fixed_length;
	if (!_tmp12_) {
		const gchar* _tmp13_ = NULL;
		gboolean _tmp14_;
		gboolean _tmp15_;
		const gchar* _tmp16_;
		gint _tmp17_;
		gchar* _tmp18_;
		gchar* _tmp19_;
		gchar* _tmp20_;
		gchar* _tmp21_;
		_tmp14_ = vala_data_type_get_nullable ((ValaDataType*) self);
		_tmp15_ = _tmp14_;
		if (_tmp15_) {
			_tmp13_ = "?";
		} else {
			_tmp13_ = "";
		}
		_tmp16_ = elem_str;
		_tmp17_ = self->priv->_rank;
		_tmp18_ = g_strnfill ((gsize) (_tmp17_ - 1), ',');
		_tmp19_ = _tmp18_;
		_tmp20_ = g_strdup_printf ("%s[%s]%s", _tmp16_, _tmp19_, _tmp13_);
		_tmp21_ = _tmp20_;
		_g_free0 (_tmp19_);
		result = _tmp21_;
		_g_free0 (elem_str);
		return result;
	} else {
		result = elem_str;
		return result;
	}
	_g_free0 (elem_str);
}


static gboolean vala_array_type_real_compatible (ValaDataType* base, ValaDataType* target_type) {
	ValaArrayType * self;
	gboolean result = FALSE;
	ValaDataType* _tmp0_;
	ValaTypeSymbol* _tmp1_;
	ValaTypeSymbol* _tmp2_;
	gboolean _tmp40_ = FALSE;
	ValaDataType* _tmp41_;
	ValaDataType* _tmp51_;
	ValaTypeParameter* _tmp52_;
	ValaTypeParameter* _tmp53_;
	ValaArrayType* target_array_type = NULL;
	ValaDataType* _tmp54_;
	ValaArrayType* _tmp55_;
	ValaArrayType* _tmp56_;
	ValaArrayType* _tmp57_;
	gint _tmp58_;
	gint _tmp59_;
	gboolean _tmp60_ = FALSE;
	ValaDataType* _tmp61_;
	ValaDataType* _tmp62_;
	gboolean _tmp72_ = FALSE;
	ValaDataType* _tmp73_;
	ValaDataType* _tmp74_;
	ValaArrayType* _tmp75_;
	ValaDataType* _tmp76_;
	ValaDataType* _tmp77_;
	gboolean _tmp78_;
	self = (ValaArrayType*) base;
	g_return_val_if_fail (target_type != NULL, FALSE);
	_tmp0_ = target_type;
	_tmp1_ = vala_data_type_get_data_type (_tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_ != NULL) {
		gboolean _tmp3_ = FALSE;
		ValaDataType* _tmp4_;
		ValaTypeSymbol* _tmp5_;
		ValaTypeSymbol* _tmp6_;
		ValaCodeContext* _tmp7_;
		ValaCodeContext* _tmp8_;
		ValaSemanticAnalyzer* _tmp9_;
		ValaSemanticAnalyzer* _tmp10_;
		ValaStructValueType* _tmp11_;
		ValaTypeSymbol* _tmp12_;
		ValaTypeSymbol* _tmp13_;
		gboolean _tmp14_;
		gboolean _tmp15_;
		ValaDataType* _tmp28_;
		ValaTypeSymbol* _tmp29_;
		ValaTypeSymbol* _tmp30_;
		ValaCodeContext* _tmp31_;
		ValaCodeContext* _tmp32_;
		ValaSemanticAnalyzer* _tmp33_;
		ValaSemanticAnalyzer* _tmp34_;
		ValaObjectType* _tmp35_;
		ValaTypeSymbol* _tmp36_;
		ValaTypeSymbol* _tmp37_;
		gboolean _tmp38_;
		gboolean _tmp39_;
		_tmp4_ = target_type;
		_tmp5_ = vala_data_type_get_data_type (_tmp4_);
		_tmp6_ = _tmp5_;
		_tmp7_ = vala_code_context_get ();
		_tmp8_ = _tmp7_;
		_tmp9_ = vala_code_context_get_analyzer (_tmp8_);
		_tmp10_ = _tmp9_;
		_tmp11_ = _tmp10_->gvalue_type;
		_tmp12_ = vala_data_type_get_data_type ((ValaDataType*) _tmp11_);
		_tmp13_ = _tmp12_;
		_tmp14_ = vala_typesymbol_is_subtype_of (_tmp6_, _tmp13_);
		_tmp15_ = _tmp14_;
		_vala_code_context_unref0 (_tmp8_);
		if (_tmp15_) {
			ValaDataType* _tmp16_;
			ValaDataType* _tmp17_;
			ValaTypeSymbol* _tmp18_;
			ValaTypeSymbol* _tmp19_;
			ValaCodeContext* _tmp20_;
			ValaCodeContext* _tmp21_;
			ValaNamespace* _tmp22_;
			ValaNamespace* _tmp23_;
			ValaScope* _tmp24_;
			ValaScope* _tmp25_;
			ValaSymbol* _tmp26_;
			ValaSymbol* _tmp27_;
			_tmp16_ = vala_array_type_get_element_type (self);
			_tmp17_ = _tmp16_;
			_tmp18_ = vala_data_type_get_data_type (_tmp17_);
			_tmp19_ = _tmp18_;
			_tmp20_ = vala_code_context_get ();
			_tmp21_ = _tmp20_;
			_tmp22_ = vala_code_context_get_root (_tmp21_);
			_tmp23_ = _tmp22_;
			_tmp24_ = vala_symbol_get_scope ((ValaSymbol*) _tmp23_);
			_tmp25_ = _tmp24_;
			_tmp26_ = vala_scope_lookup (_tmp25_, "string");
			_tmp27_ = _tmp26_;
			_tmp3_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp19_, VALA_TYPE_SYMBOL, ValaSymbol) == _tmp27_;
			_vala_code_node_unref0 (_tmp27_);
			_vala_code_context_unref0 (_tmp21_);
		} else {
			_tmp3_ = FALSE;
		}
		if (_tmp3_) {
			result = TRUE;
			return result;
		}
		_tmp28_ = target_type;
		_tmp29_ = vala_data_type_get_data_type (_tmp28_);
		_tmp30_ = _tmp29_;
		_tmp31_ = vala_code_context_get ();
		_tmp32_ = _tmp31_;
		_tmp33_ = vala_code_context_get_analyzer (_tmp32_);
		_tmp34_ = _tmp33_;
		_tmp35_ = _tmp34_->gvariant_type;
		_tmp36_ = vala_data_type_get_data_type ((ValaDataType*) _tmp35_);
		_tmp37_ = _tmp36_;
		_tmp38_ = vala_typesymbol_is_subtype_of (_tmp30_, _tmp37_);
		_tmp39_ = _tmp38_;
		_vala_code_context_unref0 (_tmp32_);
		if (_tmp39_) {
			result = TRUE;
			return result;
		}
	}
	_tmp41_ = target_type;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp41_, VALA_TYPE_POINTER_TYPE)) {
		_tmp40_ = TRUE;
	} else {
		gboolean _tmp42_ = FALSE;
		ValaDataType* _tmp43_;
		ValaTypeSymbol* _tmp44_;
		ValaTypeSymbol* _tmp45_;
		_tmp43_ = target_type;
		_tmp44_ = vala_data_type_get_data_type (_tmp43_);
		_tmp45_ = _tmp44_;
		if (_tmp45_ != NULL) {
			ValaDataType* _tmp46_;
			ValaTypeSymbol* _tmp47_;
			ValaTypeSymbol* _tmp48_;
			ValaAttribute* _tmp49_;
			ValaAttribute* _tmp50_;
			_tmp46_ = target_type;
			_tmp47_ = vala_data_type_get_data_type (_tmp46_);
			_tmp48_ = _tmp47_;
			_tmp49_ = vala_code_node_get_attribute ((ValaCodeNode*) _tmp48_, "PointerType");
			_tmp50_ = _tmp49_;
			_tmp42_ = _tmp50_ != NULL;
			_vala_code_node_unref0 (_tmp50_);
		} else {
			_tmp42_ = FALSE;
		}
		_tmp40_ = _tmp42_;
	}
	if (_tmp40_) {
		result = TRUE;
		return result;
	}
	_tmp51_ = target_type;
	_tmp52_ = vala_data_type_get_type_parameter (_tmp51_);
	_tmp53_ = _tmp52_;
	if (_tmp53_ != NULL) {
		result = TRUE;
		return result;
	}
	_tmp54_ = target_type;
	_tmp55_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp54_, VALA_TYPE_ARRAY_TYPE) ? ((ValaArrayType*) _tmp54_) : NULL);
	target_array_type = _tmp55_;
	_tmp56_ = target_array_type;
	if (_tmp56_ == NULL) {
		result = FALSE;
		_vala_code_node_unref0 (target_array_type);
		return result;
	}
	_tmp57_ = target_array_type;
	_tmp58_ = _tmp57_->priv->_rank;
	_tmp59_ = self->priv->_rank;
	if (_tmp58_ != _tmp59_) {
		result = FALSE;
		_vala_code_node_unref0 (target_array_type);
		return result;
	}
	_tmp61_ = vala_array_type_get_element_type (self);
	_tmp62_ = _tmp61_;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp62_, VALA_TYPE_VALUE_TYPE)) {
		ValaDataType* _tmp63_;
		ValaDataType* _tmp64_;
		gboolean _tmp65_;
		gboolean _tmp66_;
		ValaArrayType* _tmp67_;
		ValaDataType* _tmp68_;
		ValaDataType* _tmp69_;
		gboolean _tmp70_;
		gboolean _tmp71_;
		_tmp63_ = vala_array_type_get_element_type (self);
		_tmp64_ = _tmp63_;
		_tmp65_ = vala_data_type_get_nullable (_tmp64_);
		_tmp66_ = _tmp65_;
		_tmp67_ = target_array_type;
		_tmp68_ = vala_array_type_get_element_type (_tmp67_);
		_tmp69_ = _tmp68_;
		_tmp70_ = vala_data_type_get_nullable (_tmp69_);
		_tmp71_ = _tmp70_;
		_tmp60_ = _tmp66_ != _tmp71_;
	} else {
		_tmp60_ = FALSE;
	}
	if (_tmp60_) {
		result = FALSE;
		_vala_code_node_unref0 (target_array_type);
		return result;
	}
	_tmp73_ = vala_array_type_get_element_type (self);
	_tmp74_ = _tmp73_;
	_tmp75_ = target_array_type;
	_tmp76_ = vala_array_type_get_element_type (_tmp75_);
	_tmp77_ = _tmp76_;
	_tmp78_ = vala_data_type_compatible (_tmp74_, _tmp77_);
	if (_tmp78_) {
		ValaArrayType* _tmp79_;
		ValaDataType* _tmp80_;
		ValaDataType* _tmp81_;
		ValaDataType* _tmp82_;
		ValaDataType* _tmp83_;
		gboolean _tmp84_;
		_tmp79_ = target_array_type;
		_tmp80_ = vala_array_type_get_element_type (_tmp79_);
		_tmp81_ = _tmp80_;
		_tmp82_ = vala_array_type_get_element_type (self);
		_tmp83_ = _tmp82_;
		_tmp84_ = vala_data_type_compatible (_tmp81_, _tmp83_);
		_tmp72_ = _tmp84_;
	} else {
		_tmp72_ = FALSE;
	}
	if (_tmp72_) {
		result = TRUE;
		_vala_code_node_unref0 (target_array_type);
		return result;
	}
	result = FALSE;
	_vala_code_node_unref0 (target_array_type);
	return result;
}


static gboolean vala_array_type_real_is_reference_type_or_type_parameter (ValaDataType* base) {
	ValaArrayType * self;
	gboolean result = FALSE;
	self = (ValaArrayType*) base;
	result = TRUE;
	return result;
}


static void vala_array_type_real_accept_children (ValaCodeNode* base, ValaCodeVisitor* visitor) {
	ValaArrayType * self;
	ValaDataType* _tmp0_;
	ValaDataType* _tmp1_;
	ValaCodeVisitor* _tmp2_;
	self = (ValaArrayType*) base;
	g_return_if_fail (visitor != NULL);
	_tmp0_ = vala_array_type_get_element_type (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = visitor;
	vala_code_node_accept ((ValaCodeNode*) _tmp1_, _tmp2_);
}


static void vala_array_type_real_replace_type (ValaCodeNode* base, ValaDataType* old_type, ValaDataType* new_type) {
	ValaArrayType * self;
	ValaDataType* _tmp0_;
	ValaDataType* _tmp1_;
	ValaDataType* _tmp2_;
	self = (ValaArrayType*) base;
	g_return_if_fail (old_type != NULL);
	g_return_if_fail (new_type != NULL);
	_tmp0_ = vala_array_type_get_element_type (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = old_type;
	if (_tmp1_ == _tmp2_) {
		ValaDataType* _tmp3_;
		_tmp3_ = new_type;
		vala_array_type_set_element_type (self, _tmp3_);
	}
}


static gboolean vala_array_type_real_is_accessible (ValaDataType* base, ValaSymbol* sym) {
	ValaArrayType * self;
	gboolean result = FALSE;
	ValaDataType* _tmp0_;
	ValaDataType* _tmp1_;
	ValaSymbol* _tmp2_;
	gboolean _tmp3_;
	self = (ValaArrayType*) base;
	g_return_val_if_fail (sym != NULL, FALSE);
	_tmp0_ = vala_array_type_get_element_type (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = sym;
	_tmp3_ = vala_data_type_is_accessible (_tmp1_, _tmp2_);
	result = _tmp3_;
	return result;
}


static gboolean vala_array_type_real_check (ValaCodeNode* base, ValaCodeContext* context) {
	ValaArrayType * self;
	gboolean result = FALSE;
	gboolean _tmp0_;
	gboolean _tmp3_ = FALSE;
	gboolean _tmp4_;
	ValaDataType* _tmp27_;
	ValaDataType* _tmp28_;
	ValaCodeContext* _tmp29_;
	gboolean _tmp30_;
	self = (ValaArrayType*) base;
	g_return_val_if_fail (context != NULL, FALSE);
	_tmp0_ = self->priv->_invalid_syntax;
	if (_tmp0_) {
		ValaSourceReference* _tmp1_;
		ValaSourceReference* _tmp2_;
		_tmp1_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp2_ = _tmp1_;
		vala_report_error (_tmp2_, "syntax error, no expression allowed between array brackets");
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		result = FALSE;
		return result;
	}
	_tmp4_ = self->priv->_fixed_length;
	if (_tmp4_) {
		ValaExpression* _tmp5_;
		ValaExpression* _tmp6_;
		_tmp5_ = vala_array_type_get_length (self);
		_tmp6_ = _tmp5_;
		_tmp3_ = _tmp6_ != NULL;
	} else {
		_tmp3_ = FALSE;
	}
	if (_tmp3_) {
		ValaExpression* _tmp7_;
		ValaExpression* _tmp8_;
		ValaCodeContext* _tmp9_;
		gboolean _tmp10_ = FALSE;
		gboolean _tmp11_ = FALSE;
		ValaExpression* _tmp12_;
		ValaExpression* _tmp13_;
		ValaDataType* _tmp14_;
		ValaDataType* _tmp15_;
		_tmp7_ = vala_array_type_get_length (self);
		_tmp8_ = _tmp7_;
		_tmp9_ = context;
		vala_code_node_check ((ValaCodeNode*) _tmp8_, _tmp9_);
		_tmp12_ = vala_array_type_get_length (self);
		_tmp13_ = _tmp12_;
		_tmp14_ = vala_expression_get_value_type (_tmp13_);
		_tmp15_ = _tmp14_;
		if (_tmp15_ == NULL) {
			_tmp11_ = TRUE;
		} else {
			ValaExpression* _tmp16_;
			ValaExpression* _tmp17_;
			ValaDataType* _tmp18_;
			ValaDataType* _tmp19_;
			_tmp16_ = vala_array_type_get_length (self);
			_tmp17_ = _tmp16_;
			_tmp18_ = vala_expression_get_value_type (_tmp17_);
			_tmp19_ = _tmp18_;
			_tmp11_ = !G_TYPE_CHECK_INSTANCE_TYPE (_tmp19_, VALA_TYPE_INTEGER_TYPE);
		}
		if (_tmp11_) {
			_tmp10_ = TRUE;
		} else {
			ValaExpression* _tmp20_;
			ValaExpression* _tmp21_;
			gboolean _tmp22_;
			_tmp20_ = vala_array_type_get_length (self);
			_tmp21_ = _tmp20_;
			_tmp22_ = vala_expression_is_constant (_tmp21_);
			_tmp10_ = !_tmp22_;
		}
		if (_tmp10_) {
			ValaExpression* _tmp23_;
			ValaExpression* _tmp24_;
			ValaSourceReference* _tmp25_;
			ValaSourceReference* _tmp26_;
			_tmp23_ = vala_array_type_get_length (self);
			_tmp24_ = _tmp23_;
			_tmp25_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp24_);
			_tmp26_ = _tmp25_;
			vala_report_error (_tmp26_, "Expression of constant integer type expected");
			result = FALSE;
			return result;
		}
	}
	_tmp27_ = vala_array_type_get_element_type (self);
	_tmp28_ = _tmp27_;
	_tmp29_ = context;
	_tmp30_ = vala_code_node_check ((ValaCodeNode*) _tmp28_, _tmp29_);
	result = _tmp30_;
	return result;
}


static ValaDataType* vala_array_type_real_get_actual_type (ValaDataType* base, ValaDataType* derived_instance_type, ValaList* method_type_arguments, ValaCodeNode* node_reference) {
	ValaArrayType * self;
	ValaDataType* result = NULL;
	ValaArrayType* _result_ = NULL;
	ValaDataType* _tmp0_;
	gboolean _tmp1_ = FALSE;
	ValaDataType* _tmp2_;
	gboolean _tmp4_ = FALSE;
	ValaDataType* _tmp5_;
	ValaDataType* _tmp6_;
	self = (ValaArrayType*) base;
	g_return_val_if_fail (node_reference != NULL, NULL);
	_tmp0_ = vala_data_type_copy ((ValaDataType*) self);
	_result_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, VALA_TYPE_ARRAY_TYPE, ValaArrayType);
	_tmp2_ = derived_instance_type;
	if (_tmp2_ == NULL) {
		ValaList* _tmp3_;
		_tmp3_ = method_type_arguments;
		_tmp1_ = _tmp3_ == NULL;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		result = (ValaDataType*) _result_;
		return result;
	}
	_tmp5_ = vala_array_type_get_element_type (self);
	_tmp6_ = _tmp5_;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp6_, VALA_TYPE_GENERIC_TYPE)) {
		_tmp4_ = TRUE;
	} else {
		ValaDataType* _tmp7_;
		ValaDataType* _tmp8_;
		gboolean _tmp9_;
		_tmp7_ = vala_array_type_get_element_type (self);
		_tmp8_ = _tmp7_;
		_tmp9_ = vala_data_type_has_type_arguments (_tmp8_);
		_tmp4_ = _tmp9_;
	}
	if (_tmp4_) {
		ValaArrayType* _tmp10_;
		ValaArrayType* _tmp11_;
		ValaDataType* _tmp12_;
		ValaDataType* _tmp13_;
		ValaDataType* _tmp14_;
		ValaList* _tmp15_;
		ValaCodeNode* _tmp16_;
		ValaDataType* _tmp17_;
		ValaDataType* _tmp18_;
		_tmp10_ = _result_;
		_tmp11_ = _result_;
		_tmp12_ = vala_array_type_get_element_type (_tmp11_);
		_tmp13_ = _tmp12_;
		_tmp14_ = derived_instance_type;
		_tmp15_ = method_type_arguments;
		_tmp16_ = node_reference;
		_tmp17_ = vala_data_type_get_actual_type (_tmp13_, _tmp14_, _tmp15_, _tmp16_);
		_tmp18_ = _tmp17_;
		vala_array_type_set_element_type (_tmp10_, _tmp18_);
		_vala_code_node_unref0 (_tmp18_);
	}
	result = (ValaDataType*) _result_;
	return result;
}


static ValaDataType* vala_array_type_real_infer_type_argument (ValaDataType* base, ValaTypeParameter* type_param, ValaDataType* value_type) {
	ValaArrayType * self;
	ValaDataType* result = NULL;
	ValaArrayType* array_type = NULL;
	ValaDataType* _tmp0_;
	ValaArrayType* _tmp1_;
	ValaArrayType* _tmp2_;
	self = (ValaArrayType*) base;
	g_return_val_if_fail (type_param != NULL, NULL);
	g_return_val_if_fail (value_type != NULL, NULL);
	_tmp0_ = value_type;
	_tmp1_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, VALA_TYPE_ARRAY_TYPE) ? ((ValaArrayType*) _tmp0_) : NULL);
	array_type = _tmp1_;
	_tmp2_ = array_type;
	if (_tmp2_ != NULL) {
		ValaDataType* _tmp3_;
		ValaDataType* _tmp4_;
		ValaTypeParameter* _tmp5_;
		ValaArrayType* _tmp6_;
		ValaDataType* _tmp7_;
		ValaDataType* _tmp8_;
		ValaDataType* _tmp9_;
		_tmp3_ = vala_array_type_get_element_type (self);
		_tmp4_ = _tmp3_;
		_tmp5_ = type_param;
		_tmp6_ = array_type;
		_tmp7_ = vala_array_type_get_element_type (_tmp6_);
		_tmp8_ = _tmp7_;
		_tmp9_ = vala_data_type_infer_type_argument (_tmp4_, _tmp5_, _tmp8_);
		result = _tmp9_;
		_vala_code_node_unref0 (array_type);
		return result;
	}
	result = NULL;
	_vala_code_node_unref0 (array_type);
	return result;
}


static gboolean vala_array_type_real_is_disposable (ValaDataType* base) {
	ValaArrayType * self;
	gboolean result = FALSE;
	gboolean _tmp0_;
	self = (ValaArrayType*) base;
	_tmp0_ = self->priv->_fixed_length;
	if (_tmp0_) {
		ValaDataType* _tmp1_;
		ValaDataType* _tmp2_;
		gboolean _tmp3_;
		_tmp1_ = vala_array_type_get_element_type (self);
		_tmp2_ = _tmp1_;
		_tmp3_ = vala_data_type_is_disposable (_tmp2_);
		result = _tmp3_;
		return result;
	} else {
		gboolean _tmp4_;
		_tmp4_ = VALA_DATA_TYPE_CLASS (vala_array_type_parent_class)->is_disposable ((ValaDataType*) G_TYPE_CHECK_INSTANCE_CAST (self, VALA_TYPE_REFERENCE_TYPE, ValaReferenceType));
		result = _tmp4_;
		return result;
	}
}


ValaDataType* vala_array_type_get_element_type (ValaArrayType* self) {
	ValaDataType* result;
	ValaDataType* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_element_type;
	result = _tmp0_;
	return result;
}


void vala_array_type_set_element_type (ValaArrayType* self, ValaDataType* value) {
	ValaDataType* _tmp0_;
	ValaDataType* _tmp1_;
	ValaDataType* _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = _vala_code_node_ref0 (_tmp0_);
	_vala_code_node_unref0 (self->priv->_element_type);
	self->priv->_element_type = _tmp1_;
	_tmp2_ = self->priv->_element_type;
	vala_code_node_set_parent_node ((ValaCodeNode*) _tmp2_, (ValaCodeNode*) self);
}


gboolean vala_array_type_get_invalid_syntax (ValaArrayType* self) {
	gboolean result;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_invalid_syntax;
	result = _tmp0_;
	return result;
}


void vala_array_type_set_invalid_syntax (ValaArrayType* self, gboolean value) {
	gboolean _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_invalid_syntax = _tmp0_;
}


gboolean vala_array_type_get_inline_allocated (ValaArrayType* self) {
	gboolean result;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_inline_allocated;
	result = _tmp0_;
	return result;
}


void vala_array_type_set_inline_allocated (ValaArrayType* self, gboolean value) {
	gboolean _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_inline_allocated = _tmp0_;
}


gboolean vala_array_type_get_fixed_length (ValaArrayType* self) {
	gboolean result;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_fixed_length;
	result = _tmp0_;
	return result;
}


void vala_array_type_set_fixed_length (ValaArrayType* self, gboolean value) {
	gboolean _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_fixed_length = _tmp0_;
}


ValaExpression* vala_array_type_get_length (ValaArrayType* self) {
	ValaExpression* result;
	ValaExpression* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_length;
	result = _tmp0_;
	return result;
}


void vala_array_type_set_length (ValaArrayType* self, ValaExpression* value) {
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	ValaExpression* _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = _vala_code_node_ref0 (_tmp0_);
	_vala_code_node_unref0 (self->priv->_length);
	self->priv->_length = _tmp1_;
	_tmp2_ = self->priv->_length;
	if (_tmp2_ != NULL) {
		ValaExpression* _tmp3_;
		_tmp3_ = self->priv->_length;
		vala_code_node_set_parent_node ((ValaCodeNode*) _tmp3_, (ValaCodeNode*) self);
	}
}


gint vala_array_type_get_rank (ValaArrayType* self) {
	gint result;
	gint _tmp0_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->_rank;
	result = _tmp0_;
	return result;
}


void vala_array_type_set_rank (ValaArrayType* self, gint value) {
	gint _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_rank = _tmp0_;
}


static void vala_array_type_class_init (ValaArrayTypeClass * klass) {
	vala_array_type_parent_class = g_type_class_peek_parent (klass);
	((ValaCodeNodeClass *) klass)->finalize = vala_array_type_finalize;
	g_type_class_add_private (klass, sizeof (ValaArrayTypePrivate));
	((ValaDataTypeClass *) klass)->get_member = (ValaSymbol* (*) (ValaDataType *, const gchar*)) vala_array_type_real_get_member;
	((ValaDataTypeClass *) klass)->copy = (ValaDataType* (*) (ValaDataType *)) vala_array_type_real_copy;
	((ValaDataTypeClass *) klass)->is_array = (gboolean (*) (ValaDataType *)) vala_array_type_real_is_array;
	((ValaDataTypeClass *) klass)->to_qualified_string = (gchar* (*) (ValaDataType *, ValaScope*)) vala_array_type_real_to_qualified_string;
	((ValaDataTypeClass *) klass)->compatible = (gboolean (*) (ValaDataType *, ValaDataType*)) vala_array_type_real_compatible;
	((ValaDataTypeClass *) klass)->is_reference_type_or_type_parameter = (gboolean (*) (ValaDataType *)) vala_array_type_real_is_reference_type_or_type_parameter;
	((ValaCodeNodeClass *) klass)->accept_children = (void (*) (ValaCodeNode *, ValaCodeVisitor*)) vala_array_type_real_accept_children;
	((ValaCodeNodeClass *) klass)->replace_type = (void (*) (ValaCodeNode *, ValaDataType*, ValaDataType*)) vala_array_type_real_replace_type;
	((ValaDataTypeClass *) klass)->is_accessible = (gboolean (*) (ValaDataType *, ValaSymbol*)) vala_array_type_real_is_accessible;
	((ValaCodeNodeClass *) klass)->check = (gboolean (*) (ValaCodeNode *, ValaCodeContext*)) vala_array_type_real_check;
	((ValaDataTypeClass *) klass)->get_actual_type = (ValaDataType* (*) (ValaDataType *, ValaDataType*, ValaList*, ValaCodeNode*)) vala_array_type_real_get_actual_type;
	((ValaDataTypeClass *) klass)->infer_type_argument = (ValaDataType* (*) (ValaDataType *, ValaTypeParameter*, ValaDataType*)) vala_array_type_real_infer_type_argument;
	((ValaDataTypeClass *) klass)->is_disposable = (gboolean (*) (ValaDataType *)) vala_array_type_real_is_disposable;
}


static void vala_array_type_instance_init (ValaArrayType * self) {
	self->priv = VALA_ARRAY_TYPE_GET_PRIVATE (self);
}


static void vala_array_type_finalize (ValaCodeNode * obj) {
	ValaArrayType * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALA_TYPE_ARRAY_TYPE, ValaArrayType);
	_vala_code_node_unref0 (self->priv->_element_type);
	_vala_code_node_unref0 (self->priv->_length);
	_vala_code_node_unref0 (self->priv->length_field);
	_vala_code_node_unref0 (self->priv->resize_method);
	_vala_code_node_unref0 (self->priv->move_method);
	_vala_code_node_unref0 (self->priv->copy_method);
	VALA_CODE_NODE_CLASS (vala_array_type_parent_class)->finalize (obj);
}


/**
 * An array type.
 */
GType vala_array_type_get_type (void) {
	static volatile gsize vala_array_type_type_id__volatile = 0;
	if (g_once_init_enter (&vala_array_type_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaArrayTypeClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_array_type_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaArrayType), 0, (GInstanceInitFunc) vala_array_type_instance_init, NULL };
		GType vala_array_type_type_id;
		vala_array_type_type_id = g_type_register_static (VALA_TYPE_REFERENCE_TYPE, "ValaArrayType", &g_define_type_info, 0);
		g_once_init_leave (&vala_array_type_type_id__volatile, vala_array_type_type_id);
	}
	return vala_array_type_type_id__volatile;
}



