/* arm.v4a-linux.elf-entry.h
   created from arm.v4a-linux.elf-entry.bin, 15357 (0x3bfd) bytes

   This file is part of the UPX executable compressor.

   Copyright (C) Markus Franz Xaver Johannes Oberhumer
   Copyright (C) Laszlo Molnar
   Copyright (C) John F. Reiser
   All Rights Reserved.

   UPX and the UCL library are free software; you can redistribute them
   and/or modify them under the terms of the GNU General Public License as
   published by the Free Software Foundation; either version 2 of
   the License, or (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; see the file COPYING.
   If not, write to the Free Software Foundation, Inc.,
   59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

   Markus F.X.J. Oberhumer              Laszlo Molnar
   <markus@oberhumer.com>               <ezerotven+github@gmail.com>

   John F. Reiser
   <jreiser@users.sourceforge.net>
 */

/* clang-format off */

#define STUB_ARM_V4A_LINUX_ELF_ENTRY_SIZE    15357
#define STUB_ARM_V4A_LINUX_ELF_ENTRY_ADLER32 0xa1c0d81a
#define STUB_ARM_V4A_LINUX_ELF_ENTRY_CRC32   0xf99cdcac

unsigned char stub_arm_v4a_linux_elf_entry[15357] = {
/* 0x0000 */ 127, 69, 76, 70,  1,  1,  1, 97,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0010 */   1,  0, 40,  0,  1,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0020 */ 136, 15,  0,  0,  0,  0,  0,  0, 52,  0,  0,  0,  0,  0, 40,  0,
/* 0x0030 */  21,  0, 18,  0,220,  0,  0,235, 14,  0,160,225,  4, 16,160,227,
/* 0x0040 */   0, 32,160,227,  0, 48,160,227,  0, 64,160,227, 31,  0, 45,233,
/* 0x0050 */   8, 48,160,227,  0, 32,160,227, 13, 16,160,225, 11,  0,160,227,
/* 0x0060 */  67,112,160,227,  0,  0,  0,239, 20,208,141,226, 20,  0,  0,235,
/* 0x0070 */   8, 48,160,227,  0, 32,160,227,  0, 16,160,227, 11,  0,160,227,
/* 0x0080 */  67,112,160,227,  0,  0,  0,239, 14,240,160,225, 12,224,141,229,
/* 0x0090 */  40,  0,141,226, 44,  1,  0,235, 44,  1,  0,235,  6,  0,176,232,
/* 0x00a0 */   6,  0, 81,227,  7,  0,  0, 10,  0,  0, 81,227,  1,  0,  0, 26,
/* 0x00b0 */   1, 42,160,227,  2, 32,224,225,  1, 32,130,226,  2,128,160,225,
/* 0x00c0 */ 128,  0,  0,235,  4,160,142,226,  0,112,154,229,  1, 12,160,227,
/* 0x00d0 */  49,  0,128,226,  0, 96,135,224, 20, 96,141,229, 13,176,160,225,
/* 0x00e0 */   0,208, 77,224,  7,208,205,227,  0,  0,160,227, 13, 16,160,225,
/* 0x00f0 */   1,  0,161,232, 11,  0, 81,225, 22,  0,  0, 58, 13, 32,160,225,
/* 0x0100 */   6, 16,160,225,  0,  0,160,227,254,255,255,235,  2, 11, 16,227,
/* 0x0110 */  32,  0,  0, 90,240,  1,240,231, 32, 22,160,225,  1, 22,160,225,
/* 0x0120 */   1,  0, 64,224,  1,  0, 64,226,  7, 32,129,224, 24, 32,130,226,
/* 0x0130 */   7, 32,194,227,  8,  0,189,232,  8,  0,162,232, 11,  0, 93,225,
/* 0x0140 */  39,  0,  0, 58, 16, 16,141,229,  0,176,160,225, 24, 64,135,226,
/* 0x0150 */  12, 80,157,229,  7, 64,196,227, 32, 48,157,229,  8, 32,160,225,
/* 0x0160 */  60,  0,129,232,128,  0, 45,233, 13, 48,160,225, 16, 32,129,226,
/* 0x0170 */   8,  0,218,229,  1,  0, 45,233,  4, 16,154,229, 12,  0,138,226,
/* 0x0180 */  48,  1,  0,235,  8,208,141,226, 20, 32,157,229, 16, 16,157,229,
/* 0x0190 */  11,  0,160,225,  4,112,160,227,  0,  0,  0,239,  0, 80,160,227,
/* 0x01a0 */  11, 64,160,225, 18, 48,160,227,  5, 32,160,227, 20, 16,157,229,
/* 0x01b0 */  16,  0,157,229,192,112,160,227,  0,  0,  0,239, 11,  0,160,225,
/* 0x01c0 */   6,112,160,227,  0,  0,  0,239,  8,  0,157,229,  4, 16, 26,229,
/* 0x01d0 */   1, 64,128,224,  2, 16,193,227,  1, 80, 73,224, 48,  0,141,232,
/* 0x01e0 */  16,192,157,229, 16,240,140,226, 47,112,114,111, 99, 47,115,101,
/* 0x01f0 */ 108,102, 47, 99,109,100,108,105,110,101,  0,  0,  0,  0,160,227,
/* 0x0200 */   6,112,160,227,  0,  0,  0,239,  0, 16,160,227,  0,  0,160,227,
/* 0x0210 */   3,  0, 45,233, 13,  0,160,225, 42,112,160,227,  0,  0,  0,239,
/* 0x0220 */  65,  0,189,232,252, 32,160,227,172, 16,143,226,  6,  0,160,225,
/* 0x0230 */   4,112,160,227,  0,  0,  0,239,  6,  0,160,225,  6,112,160,227,
/* 0x0240 */   0,  0,  0,239,  1,218, 77,226,  0, 32,160,227,108, 16, 79,226,
/* 0x0250 */   0,  0,224,227,  7,192,160,225, 66,112,160,227,  1,124,135,227,
/* 0x0260 */   0,  0,  0,239, 12,112,160,225,  0, 96,160,225, 13, 16,160,225,
/* 0x0270 */   1, 42,160,227,  3,112,160,227,  0,  0,  0,239,  6,  0,160,225,
/* 0x0280 */   6,112,160,227,  0,  0,  0,239, 64,112,160,227,  0,  0,  0,239,
/* 0x0290 */  16,208, 77,226,  0, 16,160,225, 13,  0,160,225,  7,  1,  0,235,
/* 0x02a0 */   0, 64,160,227, 13, 48,160,225, 16, 32,141,226, 24, 16,143,226,
/* 0x02b0 */  23,  0,143,226, 31,  0, 45,233,  0, 32,160,227, 13, 16,160,225,
/* 0x02c0 */  11,112,160,227,  0,  0,  0,239,140,  0,  0,234, 45,113,  0, 47,
/* 0x02d0 */ 117,115,114, 47, 98,105,110, 47,103,100, 98,  0,115,101,116, 32,
/* 0x02e0 */ 112,114,111,109,112,116, 10,105,110,102,111, 32,105,110,102,101,
/* 0x02f0 */ 114,105,111,114,115, 10,112,114,105,110,116, 32, 34,114, 48, 45,
/* 0x0300 */ 114, 55, 34, 10,120, 47, 56,120,119, 32, 36,115,112, 32, 43, 32,
/* 0x0310 */  48,120, 50, 56, 10,112,114,105,110,116, 32, 34,114, 56, 45,114,
/* 0x0320 */  49, 53, 34, 10,120, 47, 56,120,119, 10,115,101,116, 32, 36,112,
/* 0x0330 */  99, 32, 61, 32, 42, 40,105,110,116, 32, 42, 41, 40, 36,115,112,
/* 0x0340 */  32, 43, 32, 48,120, 54, 52, 41, 10,112,114,105,110,116, 32, 34,
/* 0x0350 */ 102, 97,117,108,116,105,110,103, 32,105,110,115,116,114, 34, 10,
/* 0x0360 */ 120, 47,105, 32, 36,112, 99, 10,112,114,105,110,116, 32, 34,102,
/* 0x0370 */  97,117,108,116, 32, 99,111,110,116,101,120,116, 34, 10,120, 47,
/* 0x0380 */  49, 53,105, 32, 36,112, 99, 32, 45, 32, 55, 42, 52, 10,115,101,
/* 0x0390 */ 116, 32, 36,115,112, 32, 61, 32, 42, 40,108,111,110,103, 32, 42,
/* 0x03a0 */  41, 40, 36,115,112, 32, 43, 32, 48,120, 53, 99, 41, 10,112,114,
/* 0x03b0 */ 105,110,116, 32, 34,117,115,101,114, 32,115,116, 97, 99,107, 34,
/* 0x03c0 */  10,120, 47, 54, 52,120,119, 32, 36,115,112, 10,107,105,108,108,
/* 0x03d0 */  10,113,117,105,116, 32, 49,  0,  0,  0,160,225, 47,112,114,111,
/* 0x03e0 */  99, 47,115,101,108,102, 47,109, 97,112,115,  0, 10, 10, 83, 73,
/* 0x03f0 */  71, 83, 69, 71, 86, 32, 97,100,100,114,101,115,115, 32,115,112,
/* 0x0400 */  97, 99,101, 58, 10,  0,  0,  0, 14,192,160,225, 15,224,160,225,
/* 0x0410 */  12,240,160,225,  6,  0, 45,233, 25, 32,160,227, 56, 16, 79,226,
/* 0x0420 */   2,  0,160,227,  4,112,160,227,  0,  0,  0,239,  0, 32,160,227,
/* 0x0430 */  92, 16, 79,226,  0,  0,224,227,  7,192,160,225, 66,112,160,227,
/* 0x0440 */   1,124,135,227,  0,  0,  0,239, 12,112,160,225,  0, 96,160,225,
/* 0x0450 */   1,218, 77,226,  1, 42,160,227, 13, 16,160,225,  6,  0,160,225,
/* 0x0460 */   3,112,160,227,  0,  0,  0,239,  0,  0, 80,227,252,  0,  0, 10,
/* 0x0470 */   0, 32,160,225, 13, 16,160,225,  2,  0,160,227,  4,112,160,227,
/* 0x0480 */   0,  0,  0,239,239,  0,  0,234,  1,218,141,226,  6,  0,160,225,
/* 0x0490 */   6,112,160,227,  0,  0,  0,239,  0,  0,160,227,  0, 16,160,227,
/* 0x04a0 */   2,112,160,227,  0,  0,  0,239,  0,  0, 80,227, 89,  0,  0, 10,
/* 0x04b0 */   6,  1,  0,234,  0, 32,160,227,  4, 64, 45,233, 13,  1,  0,235,
/* 0x04c0 */   4, 64,189,232,  0, 32,192,229, 14,240,160,225,  1,192,160,225,
/* 0x04d0 */   0, 32,160,227,  1, 48,160,225,129, 17,145,224,130, 33,162,224,
/* 0x04e0 */ 163, 46,130,224,  1, 48,160,225,  1, 18,145,224,  2, 34,162,224,
/* 0x04f0 */  35, 46,130,224,  1, 48,160,225,  1, 20,145,224,  2, 36,162,224,
/* 0x0500 */  35, 44,130,224,  1, 48,160,225,  1, 24,145,224,  2, 40,162,224,
/* 0x0510 */  35, 40,130,224,140, 31, 81,224,172, 32,194,224, 12, 16,145,224,
/* 0x0520 */   0, 16,178,226,  1, 33,129,224,130, 32, 76,224,  4, 64, 45,233,
/* 0x0530 */  40,  1,  0, 10, 13,  1,  0,235,  2, 64,189,232, 48, 16,129,226,
/* 0x0540 */   1, 16,192,228, 14,240,160,225,  4, 16,144,228,  0,  0, 81,227,
/* 0x0550 */  44,  1,  0, 26, 14,240,160,225,  0, 16,129,224, 62, 64, 45,233,
/* 0x0560 */   0, 80,224,227,  2, 65,160,227, 73,  1,  0,234, 26,  0,189,232,
/* 0x0570 */   1,  0, 64,224,  3, 32, 66,224,  0, 32,132,229, 48,128,189,232,
/* 0x0580 */   4, 64,148,224, 14,240,160, 17,  1, 64,208,228,  4, 64,164,224,
/* 0x0590 */   4, 76,176,225, 14,240,160,225,  1, 16,160,227, 14,192,160,225,
/* 0x05a0 */  58,  1,  0,235,  1, 16,177,224, 58,  1,  0,235, 66,  1,  0, 58,
/* 0x05b0 */  12,240,160,225,  1, 48,208,228,  1, 48,194,228, 58,  1,  0,235,
/* 0x05c0 */  71,  1,  0, 42, 64,  1,  0,235,  3, 48, 81,226,  0, 16,160,227,
/* 0x05d0 */  83,  1,  0, 58,  1, 80,208,228,  3, 84,133,225,  5, 80,240,225,
/* 0x05e0 */  53,  1,  0, 10, 58,  1,  0,235,  1, 16,177,224, 58,  1,  0,235,
/* 0x05f0 */   1, 16,177,224, 90,  1,  0, 26, 64,  1,  0,235,  2, 16,129,226,
/* 0x0600 */  13, 12,117,227,  1, 16,129, 50,  5, 48,210,231,  1, 16, 81,226,
/* 0x0610 */   1, 48,194,228, 92,  1,  0, 42, 73,  1,  0,234,  0,  0,224,227,
/* 0x0620 */   0,  6,160,225, 14,240,160,225,254,255,255,234,254,255,255,234,
/* 0x0630 */  63, 32,  0,226, 31, 48,  0,226, 26,  0, 83,227,  5,  0,  0,154,
/* 0x0640 */  32,  0, 16,227, 70, 32, 66, 18, 43, 32, 66,  2, 64,  0,130,226,
/* 0x0650 */  30,255, 47,225,  2,192,160,225, 17,  0,  0,234,  0, 32,208,229,
/* 0x0660 */  32, 32,130,227,  0, 48,209,229, 32, 48,131,227,  3, 32, 82,224,
/* 0x0670 */  21,  0,  0, 26,  1,  0,128,226,  1, 16,129,226,  1,192, 76,226,
/* 0x0680 */   1,  0,124,227,  9,  0,  0, 26,  0, 32,160,227,  2,  0,160,225,
/* 0x0690 */  30,255, 47,225,112, 64, 45,233, 64,208, 77,226,  0, 80,160,225,
/* 0x06a0 */   1, 96,160,225, 13,  0,160,225,255, 16,160,227, 64, 32,160,227,
/* 0x06b0 */ 254,255,255,235,  5,  0,160,225, 13, 16,160,225,254,255,255,235,
/* 0x06c0 */   0, 64, 80,226, 41,  0,  0,186,184, 48,221,225, 15, 58,  3,226,
/* 0x06d0 */   1,  9, 83,227,  0, 64,160,  3, 53,  0,  0,234,  2,  0,116,227,
/* 0x06e0 */  47,  0,  0, 26,  5,  0,160,225,  7, 29,160,227,254,255,255,235,
/* 0x06f0 */   0, 64,160,225,  0, 48, 86,226,  1, 48,160, 19,164, 63, 19,224,
/* 0x0700 */   5,  0,160, 17,  4, 16,160, 17,254,255,255, 27,  4,  0,160,225,
/* 0x0710 */  64,208,141,226,112,128,189,232,240, 65, 45,233,  0,112,160,225,
/* 0x0720 */   1, 96,160,225, 63,  0,  0,235, 47,100, 97,116, 97, 47,100, 97,
/* 0x0730 */ 116, 97, 47,  0, 14, 16,160,225, 11, 32,160,227,254,255,255,235,
/* 0x0740 */   0, 64,160,227,  0, 64,192,229,  7,  0,160,225,  1, 16,160,227,
/* 0x0750 */  23,  0,  0,235, 77,  0,  0,235, 47,112,114,111, 99, 47,115,101,
/* 0x0760 */ 108,102, 47, 99,109,100,108,105,110,101,  0,  0, 14,128,160,225,
/* 0x0770 */   8,  0,160,225,  4, 16,160,225,  4, 32,160,225,254,255,255,235,
/* 0x0780 */   0, 64,160,225,  6, 16,160,225,255, 46,160,227, 15, 32,130,226,
/* 0x0790 */ 254,255,255,235,  0, 80,160,225,  4,  0,160,225,254,255,255,235,
/* 0x07a0 */   0,  0, 85,227,  8,  0,160,177,254,255,255,187,  0, 48,160,227,
/* 0x07b0 */   5, 48,198,231,  0, 48,214,229,  0,  0, 83,227,  6, 16,160,  1,
/* 0x07c0 */ 139,  0,  0, 10,  6, 16,160,225,  1, 48,241,229,  0,  0, 83,227,
/* 0x07d0 */ 100,  0,  0, 26,139,  0,  0,234,  1, 48,116,229, 47,  0, 83,227,
/* 0x07e0 */ 104,  0,  0, 26,  1,128,100,224, 10,  0,135,226,  4, 16,160,225,
/* 0x07f0 */   8, 32,160,225,254,255,255,235,  0, 80,160,225,  0, 96,160,227,
/* 0x0800 */   0, 96,192,229,  7,  0,160,225,  6, 16,160,225, 23,  0,  0,235,
/* 0x0810 */  13,  0,112,227,141,  0,  0, 26,126,  0,  0,235, 99,111,109, 46,
/* 0x0820 */ 116,101,114,109,117,120, 47,102,105,108,101,115,  0,  0,  0,  0,
/* 0x0830 */  14, 16,160,225, 11,  0,135,226, 16, 32,160,227,254,255,255,235,
/* 0x0840 */   4, 16,160,225,  8, 32,160,225,254,255,255,235,  0, 80,160,225,
/* 0x0850 */   0, 96,192,229,  7,  0,160,225,  1, 16,160,227, 23,  0,  0,235,
/* 0x0860 */ 141,  0,  0,234,  1, 64,160,225,104,  0,  0,234,144,  0,  0,235,
/* 0x0870 */  47, 99, 97, 99,104,101,  0,  0, 14, 16,160,225,  5,  0,160,225,
/* 0x0880 */   6, 32,160,227,254,255,255,235,  0, 64,160,225,  0, 96,160,227,
/* 0x0890 */   0, 96,192,229,  7,  0,160,225,  1, 16,160,227, 23,  0,  0,235,
/* 0x08a0 */ 157,  0,  0,235, 47,117,112,120,  0,  0,  0,  0, 14, 16,160,225,
/* 0x08b0 */   4,  0,160,225,  4, 32,160,227,254,255,255,235,  0, 64,160,225,
/* 0x08c0 */ 254,255,255,235,  0, 80,160,225,254,255,255,235,  0,  0,196,229,
/* 0x08d0 */  37,  3,160,225,254,255,255,235,  1,  0,196,229, 37,  6,160,225,
/* 0x08e0 */ 254,255,255,235,  2,  0,196,229,  3, 96,196,229,  6,  0,160,225,
/* 0x08f0 */ 240,129,189,232,240, 65, 45,233,  1,218, 77,226, 12,208, 77,226,
/* 0x0900 */   0,112,160,225,  1,128,160,225,  2, 96,160,225,183,  0,  0,235,
/* 0x0910 */ 117,112,120,  0, 14, 64,160,225,  4,  0,160,225, 16, 16,160,227,
/* 0x0920 */ 254,255,255,235,  0, 80,160,225, 22,  0,112,227,194,  0,  0, 26,
/* 0x0930 */   4,  0,160,225,  0, 16,160,227,254,255,255,235,  0, 80,160,225,
/* 0x0940 */   0,  0, 85,227,215,  0,  0,170,200,  0,  0,235, 47,100,101,118,
/* 0x0950 */  47,115,104,109,  0,  0,  0,  0, 14,  0,160,225,  1, 25,160,227,
/* 0x0960 */   2, 16,129,226,  1, 21,129,227,  7, 45,160,227,254,255,255,235,
/* 0x0970 */   0, 80, 80,226,215,  0,  0,170,213,  0,  0,235,109,101,109,102,
/* 0x0980 */ 100, 95, 99,114,101, 97,116,101,  0,  0,  0,  0, 14,  0,160,225,
/* 0x0990 */ 254,255,255,235, 12, 64,141,226,  4,  0,160,225,254,255,255,235,
/* 0x09a0 */ 220,  0,  0,235, 97,110,100,  0, 14,  0,160,225,  4, 16,160,225,
/* 0x09b0 */   3, 32,160,227,  7,  0,  0,235,  0,  0, 80,227,238,  0,  0, 10,
/* 0x09c0 */ 228,  0,  0,235, 76,105,110,  0, 14,  0,160,225,  4, 16,160,225,
/* 0x09d0 */   3, 32,160,227,  7,  0,  0,235,  0,  0, 80,227,238,  0,  0, 26,
/* 0x09e0 */ 130, 48,212,229, 52,  0, 83,227,  1, 64,160,131, 16,  1,  0,138,
/* 0x09f0 */   0,  0, 86,227,247,  0,  0, 26,254,255,255,235,  0, 96, 80,226,
/* 0x0a00 */   2, 49,160,  3,  1, 42,141,  2, 12, 32,130,  2,195,105,194,  7,
/* 0x0a10 */  12, 96,141,  2, 38,  0,117,227, 15,  1,  0, 26,  0,  0, 86,227,
/* 0x0a20 */  15,  1,  0, 10,  0, 48,214,229,  0,  0, 83,227,  4,  1,  0, 26,
/* 0x0a30 */   6,  0,160,225,  2, 27,141,226, 12, 16,129,226, 56,  0,  0,235,
/* 0x0a40 */   0,  0, 80,227, 76,  1,  0,186,  6,  0,160,225,194, 16,160,227,
/* 0x0a50 */   7, 45,160,227,254,255,255,235,  0, 80, 80,226,  5,  0,160,177,
/* 0x0a60 */  76,  1,  0,186,  6,  0,160,225,254,255,255,235,  0, 64,160,227,
/* 0x0a70 */  16,  1,  0,234,  0, 64,160,227,  0,  0, 87,227, 23,  1,  0, 10,
/* 0x0a80 */ 254,255,255,235,  0,  0,224,225,  7,  0,  0,224,  7,112, 96,224,
/* 0x0a90 */   0,128,136,224,  0,  0, 88,227, 50,  1,  0, 10,  0,  0, 84,227,
/* 0x0aa0 */  33,  1,  0, 10,  5,  0,160,225,  8, 16,160,225,254,255,255,235,
/* 0x0ab0 */   0,  0, 80,227, 50,  1,  0,170, 76,  1,  0,234,  5,  0,160,225,
/* 0x0ac0 */   1, 16, 72,226,  0, 32,160,227,254,255,255,235,  1, 26,224,227,
/* 0x0ad0 */   0, 64,160,227,  1, 58,141,226, 12, 48,131,226,  1, 64,195,231,
/* 0x0ae0 */   5,  0,160,225,  1, 16,131,224,  1, 32,160,227,254,255,255,235,
/* 0x0af0 */   5,  0,160,225,  4, 16,160,225,  4, 32,160,225,254,255,255,235,
/* 0x0b00 */   0,  0, 87,227,  1,192,160,  3, 62,  1,  0, 10,254,255,255,235,
/* 0x0b10 */   0, 32,160,225,  0, 48,215,225, 74,  1,  0, 10,  5,  0,160,225,
/* 0x0b20 */   7, 16,160,225,  0, 32, 98,226,254,255,255,235, 74,  1,  0,234,
/* 0x0b30 */   0, 80,141,229,  0, 48,160,227,  4, 48,141,229,  7,  0,160,225,
/* 0x0b40 */   8, 16,160,225,  3, 32,160,227, 12, 48,160,225,254,255,255,235,
/* 0x0b50 */   1, 10,112,227,  1, 48,133,146,  3,  0,128,145, 76,  1,  0,234,
/* 0x0b60 */  17,192,160,227, 62,  1,  0,234, 12,208,141,226,  1,218,141,226,
/* 0x0b70 */ 240,129,189,232,240, 64, 45,233,  8,208, 77,226,  0,112,160,225,
/* 0x0b80 */   1, 96,160,225,  4,  0,  0,235,117,112,120,  0, 14, 64,160,225,
/* 0x0b90 */   4,  0,160,225, 16, 16,160,227,254,255,255,235,  0, 80,160,225,
/* 0x0ba0 */  22,  0,112,227, 15,  0,  0, 26,  4,  0,160,225,  0, 16,160,227,
/* 0x0bb0 */ 254,255,255,235,  0, 80,160,225,  0,  0, 85,227, 55,  0,  0,170,
/* 0x0bc0 */  21,  0,  0,235, 47,100,101,118, 47,115,104,109,  0,  0,  0,  0,
/* 0x0bd0 */  14,  0,160,225,  1, 25,160,227,  2, 16,129,226,  1, 21,129,227,
/* 0x0be0 */   7, 45,160,227,254,255,255,235,  0, 80, 80,226, 55,  0,  0,170,
/* 0x0bf0 */  21,  0,117,227,  5, 64,160, 17, 76,  0,  0, 26, 49,  0,  0,235,
/* 0x0c00 */  85, 80, 88, 45, 53, 46, 48, 32,119, 97,110,116,115, 32,109,101,
/* 0x0c10 */ 109,102,100, 95, 99,114,101, 97,116,101, 40, 41, 44, 32,111,114,
/* 0x0c20 */  32,110,101,101,100,115, 32, 47,100,101,118, 47,115,104,109, 40,
/* 0x0c30 */  44, 79, 95, 84, 77, 80, 70, 73, 76, 69, 44, 41, 10,  0,  0,  0,
/* 0x0c40 */  14, 16,160,225,  2,  0,160,227, 61, 32,160,227,254,255,255,235,
/* 0x0c50 */ 127,  0,160,227,254,255,255,235,  5,  0,160,225,  6, 16,160,225,
/* 0x0c60 */ 254,255,255,235,  0,  0, 80,227,  0, 64,160,177, 76,  0,  0,186,
/* 0x0c70 */   0, 80,141,229,  0, 48,160,227,  4, 48,141,229,  7,  0,160,225,
/* 0x0c80 */   6, 16,160,225,  3, 32,160,227,  3,  0, 87,225,  1, 48,160,  3,
/* 0x0c90 */  17, 48,160, 19,254,255,255,235,  0, 64,160,225,254,255,255,235,
/* 0x0ca0 */   4,  0, 80,225,  1, 48,132,130,  3, 64,133,128,  4,  0,160,225,
/* 0x0cb0 */   8,208,141,226,240,128,189,232,  0,  0,  0,  0, 16,144, 31,229,
/* 0x0cc0 */  16, 32, 31,229, 24, 48, 79,226,  9, 48, 67,224,  5,  0,  0,235,
/* 0x0cd0 */  14,240,160,225,  7,  0, 45,233,  8,208, 77,226, 11, 64, 45,233,
/* 0x0ce0 */ 240,  1,240,231, 14,240,160,225,  0,  0, 82,227,  7,  0,  0, 10,
/* 0x0cf0 */   0, 64,160,225,  1, 48,209,228,  1, 32, 66,226,  1, 48,192,228,
/* 0x0d00 */   3,  0,  0, 26,  4,  0,160,225, 14,240,160,225,  0,  0, 82,227,
/* 0x0d10 */  15,  0,  0, 10,  0, 48,160,225,  1, 16,192,228,  1, 32, 82,226,
/* 0x0d20 */  12,  0,  0, 26,  3,  0,160,225, 14,240,160,225,  0,  0, 82,227,
/* 0x0d30 */  23,  0,  0, 10,  1, 48,209,228,  1, 32, 82,226,  1, 48,192,228,
/* 0x0d40 */  19,  0,  0, 26, 14,240,160,225,  7,192,160,225,  7,192,160,225,
/* 0x0d50 */ 129,112,160,227,  1,124,135,227,  0,  0,  0,239, 12,112,160,225,
/* 0x0d60 */  12,112,160,225, 14,240,160,225,  7,192,160,225,  6,112,160,227,
/* 0x0d70 */   0,  0,  0,239, 12,112,160,225, 14,240,160,225,  7,192,160,225,
/* 0x0d80 */   1,112,160,227,  0,  0,  0,239, 12,112,160,225, 14,240,160,225,
/* 0x0d90 */   7,192,160,225,148,112,160,227,  0,  0,  0,239, 12,112,160,225,
/* 0x0da0 */  14,240,160,225,  7,192,160,225,118,112,160,227,  0,  0,  0,239,
/* 0x0db0 */  12,112,160,225, 14,240,160,225,  7,192,160,225, 93,112,160,227,
/* 0x0dc0 */   0,  0,  0,239, 12,112,160,225, 14,240,160,225,  7,192,160,225,
/* 0x0dd0 */  20,112,160,227,  0,  0,  0,239, 12,112,160,225, 14,240,160,225,
/* 0x0de0 */   7,192,160,225, 19,112,160,227,  0,  0,  0,239, 12,112,160,225,
/* 0x0df0 */  14,240,160,225,  7,192,160,225, 39,112,160,227,  0,  0,  0,239,
/* 0x0e00 */  12,112,160,225, 14,240,160,225,  7,192,160,225,  5,112,160,227,
/* 0x0e10 */   0,  0,  0,239, 12,112,160,225, 14,240,160,225,  7,192,160,225,
/* 0x0e20 */   3,112,160,227,  0,  0,  0,239, 12,112,160,225, 14,240,160,225,
/* 0x0e30 */   7,192,160,225,106,112,160,227,  0,  0,  0,239, 12,112,160,225,
/* 0x0e40 */  14,240,160,225,  7,192,160,225,122,112,160,227,  0,  0,  0,239,
/* 0x0e50 */  12,112,160,225, 14,240,160,225,  7,192,160,225, 10,112,160,227,
/* 0x0e60 */   0,  0,  0,239, 12,112,160,225, 14,240,160,225,  7,192,160,225,
/* 0x0e70 */   4,112,160,227,  0,  0,  0,239, 12,112,160,225, 14,240,160,225,
/* 0x0e80 */   0,112,160,227,  7,118,160,225,  0,112,199,225,  7,  0, 64,224,
/* 0x0e90 */   7, 16,129,224,  7,192,160,225,144,112,160,227,  0,  0,  0,239,
/* 0x0ea0 */  12,112,160,225, 14,240,160,225,240,  1,240,231, 14,240,160,225,
/* 0x0eb0 */  48, 64, 45,233, 16, 80,157,229, 12, 64,157,229, 37, 86,160,225,
/* 0x0ec0 */   0,192,224,227, 12,198,160,225, 12,192,192,225, 12,  0, 64,224,
/* 0x0ed0 */  12, 16,129,224,  7,192,160,225,192,112,160,227,  0,  0,  0,239,
/* 0x0ee0 */  12,112,160,225, 48,128,189,232, 14,192,160,225, 15,224,160,225,
/* 0x0ef0 */  12,240,160,225,  0,  0,  0,  0,  0, 46,115,121,109,116, 97, 98,
/* 0x0f00 */   0, 46,115,116,114,116, 97, 98,  0, 46,115,104,115,116,114,116,
/* 0x0f10 */  97, 98,  0, 46,114,101,108, 69, 76, 70, 83, 73, 71, 83, 69, 71,
/* 0x0f20 */  86,  0, 46,114,101,108, 69, 76, 70, 77, 65, 73, 78, 88, 50,  0,
/* 0x0f30 */  69, 76, 70, 77, 65, 73, 78, 89,  0, 46,114,101,108, 72, 85, 77,
/* 0x0f40 */  70, 95, 65,  0, 46,114,101,108, 72, 85, 77, 70, 95, 76,  0, 46,
/* 0x0f50 */ 114,101,108, 85, 77, 70, 95, 65, 78, 68, 82, 79, 73, 68,  0, 46,
/* 0x0f60 */ 114,101,108, 85, 77, 70, 95, 76, 73, 78, 85, 88,  0, 46,114,101,
/* 0x0f70 */ 108, 69, 76, 70, 77, 65, 73, 78, 88,  0, 46,114,101,108, 69, 76,
/* 0x0f80 */  70, 77, 65, 73, 78, 90,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0f90 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0fa0 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0fb0 */  31,  0,  0,  0,  1,  0,  0,  0,  6,  0,  0,  0,  0,  0,  0,  0,
/* 0x0fc0 */  52,  0,  0,  0, 92,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0fd0 */   1,  0,  0,  0,  0,  0,  0,  0, 27,  0,  0,  0,  9,  0,  0,  0,
/* 0x0fe0 */   0,  0,  0,  0,  0,  0,  0,  0,156, 22,  0,  0, 16,  0,  0,  0,
/* 0x0ff0 */  19,  0,  0,  0,  1,  0,  0,  0,  4,  0,  0,  0,  8,  0,  0,  0,
/* 0x1000 */  46,  0,  0,  0,  1,  0,  0,  0,  6,  0,  0,  0,  0,  0,  0,  0,
/* 0x1010 */ 144,  0,  0,  0,152,  5,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x1020 */   4,  0,  0,  0,  0,  0,  0,  0, 42,  0,  0,  0,  9,  0,  0,  0,
/* 0x1030 */   0,  0,  0,  0,  0,  0,  0,  0,172, 22,  0,  0, 24,  1,  0,  0,
/* 0x1040 */  19,  0,  0,  0,  3,  0,  0,  0,  4,  0,  0,  0,  8,  0,  0,  0,
/* 0x1050 */  56,  0,  0,  0,  1,  0,  0,  0,  6,  0,  0,  0,  0,  0,  0,  0,
/* 0x1060 */  40,  6,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x1070 */   1,  0,  0,  0,  0,  0,  0,  0, 69,  0,  0,  0,  1,  0,  0,  0,
/* 0x1080 */   6,  0,  0,  0,  0,  0,  0,  0, 40,  6,  0,  0,  4,  0,  0,  0,
/* 0x1090 */   0,  0,  0,  0,  0,  0,  0,  0,  1,  0,  0,  0,  0,  0,  0,  0,
/* 0x10a0 */  65,  0,  0,  0,  9,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x10b0 */ 196, 23,  0,  0,  8,  0,  0,  0, 19,  0,  0,  0,  6,  0,  0,  0,
/* 0x10c0 */   4,  0,  0,  0,  8,  0,  0,  0, 80,  0,  0,  0,  1,  0,  0,  0,
/* 0x10d0 */   6,  0,  0,  0,  0,  0,  0,  0, 44,  6,  0,  0,  4,  0,  0,  0,
/* 0x10e0 */   0,  0,  0,  0,  0,  0,  0,  0,  1,  0,  0,  0,  0,  0,  0,  0,
/* 0x10f0 */  76,  0,  0,  0,  9,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x1100 */ 204, 23,  0,  0,  8,  0,  0,  0, 19,  0,  0,  0,  8,  0,  0,  0,
/* 0x1110 */   4,  0,  0,  0,  8,  0,  0,  0, 91,  0,  0,  0,  1,  0,  0,  0,
/* 0x1120 */   6,  0,  0,  0,  0,  0,  0,  0, 48,  6,  0,  0, 68,  5,  0,  0,
/* 0x1130 */   0,  0,  0,  0,  0,  0,  0,  0,  4,  0,  0,  0,  0,  0,  0,  0,
/* 0x1140 */  87,  0,  0,  0,  9,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x1150 */ 212, 23,  0,  0,192,  2,  0,  0, 19,  0,  0,  0, 10,  0,  0,  0,
/* 0x1160 */   4,  0,  0,  0,  8,  0,  0,  0,107,  0,  0,  0,  1,  0,  0,  0,
/* 0x1170 */   6,  0,  0,  0,  0,  0,  0,  0,116, 11,  0,  0, 68,  1,  0,  0,
/* 0x1180 */   0,  0,  0,  0,  0,  0,  0,  0,  4,  0,  0,  0,  0,  0,  0,  0,
/* 0x1190 */ 103,  0,  0,  0,  9,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x11a0 */ 148, 26,  0,  0,128,  0,  0,  0, 19,  0,  0,  0, 12,  0,  0,  0,
/* 0x11b0 */   4,  0,  0,  0,  8,  0,  0,  0,121,  0,  0,  0,  1,  0,  0,  0,
/* 0x11c0 */   6,  0,  0,  0,  0,  0,  0,  0,184, 12,  0,  0, 40,  0,  0,  0,
/* 0x11d0 */   0,  0,  0,  0,  0,  0,  0,  0,  1,  0,  0,  0,  0,  0,  0,  0,
/* 0x11e0 */ 117,  0,  0,  0,  9,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x11f0 */  20, 27,  0,  0, 16,  0,  0,  0, 19,  0,  0,  0, 14,  0,  0,  0,
/* 0x1200 */   4,  0,  0,  0,  8,  0,  0,  0,134,  0,  0,  0,  1,  0,  0,  0,
/* 0x1210 */   6,  0,  0,  0, 40,  0,  0,  0,224, 12,  0,  0, 24,  2,  0,  0,
/* 0x1220 */   0,  0,  0,  0,  0,  0,  0,  0,  1,  0,  0,  0,  0,  0,  0,  0,
/* 0x1230 */ 130,  0,  0,  0,  9,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x1240 */  36, 27,  0,  0, 56,  0,  0,  0, 19,  0,  0,  0, 16,  0,  0,  0,
/* 0x1250 */   4,  0,  0,  0,  8,  0,  0,  0, 17,  0,  0,  0,  3,  0,  0,  0,
/* 0x1260 */   0,  0,  0,  0,  0,  0,  0,  0,248, 14,  0,  0,143,  0,  0,  0,
/* 0x1270 */   0,  0,  0,  0,  0,  0,  0,  0,  1,  0,  0,  0,  0,  0,  0,  0,
/* 0x1280 */   1,  0,  0,  0,  2,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x1290 */ 208, 18,  0,  0,160,  2,  0,  0, 20,  0,  0,  0, 10,  0,  0,  0,
/* 0x12a0 */   4,  0,  0,  0, 16,  0,  0,  0,  9,  0,  0,  0,  3,  0,  0,  0,
/* 0x12b0 */   0,  0,  0,  0,  0,  0,  0,  0,112, 21,  0,  0, 43,  1,  0,  0,
/* 0x12c0 */   0,  0,  0,  0,  0,  0,  0,  0,  1,  0,  0,  0,  0,  0,  0,  0,
/* 0x12d0 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x12e0 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  3,  0,  1,  0,
/* 0x12f0 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  3,  0,  3,  0,
/* 0x1300 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  3,  0, 10,  0,
/* 0x1310 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  3,  0, 12,  0,
/* 0x1320 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  3,  0, 14,  0,
/* 0x1330 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  3,  0, 16,  0,
/* 0x1340 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  3,  0,  5,  0,
/* 0x1350 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  3,  0,  6,  0,
/* 0x1360 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  3,  0,  8,  0,
/* 0x1370 */   1,  0,  0,  0,140,  5,  0,  0,  0,  0,  0,  0, 16,  0,  3,  0,
/* 0x1380 */  15,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 16,  0,  0,  0,
/* 0x1390 */  20,  0,  0,  0,236,  0,  0,  0,  0,  0,  0,  0, 16,  0, 16,  0,
/* 0x13a0 */  27,  0,  0,  0,152,  5,  0,  0,  0,  0,  0,  0, 16,  0,  3,  0,
/* 0x13b0 */  43,  0,  0,  0,  8,  0,  0,  0,  0,  0,  0,  0, 16,  0, 16,  0,
/* 0x13c0 */  50,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 16,  0,  0,  0,
/* 0x13d0 */  58,  0,  0,  0,160,  1,  0,  0,  0,  0,  0,  0, 16,  0, 16,  0,
/* 0x13e0 */  64,  0,  0,  0, 76,  0,  0,  0,  0,  0,  0,  0, 16,  0, 16,  0,
/* 0x13f0 */  72,  0,  0,  0,216,  0,  0,  0,  0,  0,  0,  0, 16,  0, 16,  0,
/* 0x1400 */  82,  0,  0,  0,  0,  1,  0,  0,  0,  0,  0,  0, 16,  0, 16,  0,
/* 0x1410 */  88,  0,  0,  0,196,  2,  0,  0,128,  2,  0,  0, 18,  0, 10,  0,
/* 0x1420 */ 112,  0,  0,  0,208,  1,  0,  0,  0,  0,  0,  0, 16,  0, 16,  0,
/* 0x1430 */ 117,  0,  0,  0,  0,  0,  0,  0, 68,  1,  0,  0, 18,  0, 12,  0,
/* 0x1440 */ 139,  0,  0,  0,100,  1,  0,  0,  0,  0,  0,  0, 16,  0, 16,  0,
/* 0x1450 */ 145,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 16,  0,  5,  0,
/* 0x1460 */ 160,  0,  0,  0,140,  1,  0,  0,  0,  0,  0,  0, 16,  0, 16,  0,
/* 0x1470 */ 166,  0,  0,  0,176,  0,  0,  0,  0,  0,  0,  0, 16,  0, 16,  0,
/* 0x1480 */ 176,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 16,  0, 16,  0,
/* 0x1490 */ 191,  0,  0,  0,104,  0,  0,  0,  0,  0,  0,  0, 16,  0, 16,  0,
/* 0x14a0 */ 204,  0,  0,  0,  4,  0,  0,  0,  0,  0,  0,  0, 16,  0, 14,  0,
/* 0x14b0 */ 211,  0,  0,  0, 60,  1,  0,  0,  0,  0,  0,  0, 16,  0, 16,  0,
/* 0x14c0 */ 216,  0,  0,  0,120,  1,  0,  0,  0,  0,  0,  0, 16,  0, 16,  0,
/* 0x14d0 */ 223,  0,  0,  0, 44,  0,  0,  0,  0,  0,  0,  0, 16,  0, 16,  0,
/* 0x14e0 */ 230,  0,  0,  0,200,  4,  0,  0,196,  0,  0,  0, 18,  0,  3,  0,
/* 0x14f0 */ 253,  0,  0,  0,200,  1,  0,  0,  0,  0,  0,  0, 16,  0, 16,  0,
/* 0x1500 */   5,  1,  0,  0,196,  0,  0,  0,  0,  0,  0,  0, 16,  0, 16,  0,
/* 0x1510 */  11,  1,  0,  0, 80,  1,  0,  0,  0,  0,  0,  0, 16,  0, 16,  0,
/* 0x1520 */  16,  1,  0,  0, 24,  2,  0,  0,  0,  0,  0,  0, 16,  0, 16,  0,
/* 0x1530 */  21,  1,  0,  0,156,  0,  0,  0,  0,  0,  0,  0, 16,  0, 16,  0,
/* 0x1540 */  26,  1,  0,  0, 40,  1,  0,  0,  0,  0,  0,  0, 16,  0, 16,  0,
/* 0x1550 */  31,  1,  0,  0, 20,  1,  0,  0,  0,  0,  0,  0, 16,  0, 16,  0,
/* 0x1560 */  37,  1,  0,  0,136,  0,  0,  0,  0,  0,  0,  0, 16,  0, 16,  0,
/* 0x1570 */   0,103,101,116, 95,112, 97,103,101, 95,109, 97,115,107,  0, 77,
/* 0x1580 */  70, 76, 71,  0,103,101,116,112,105,100,  0,117,112,120, 95,109,
/* 0x1590 */ 109, 97,112, 95, 97,110,100, 95,102,100,  0,109,101,109, 99,112,
/* 0x15a0 */ 121,  0, 79, 95, 66, 73, 78, 70, 79,  0, 80,115,121,110, 99,  0,
/* 0x15b0 */ 109,101,109,112, 99,112,121,  0,102,116,114,117,110, 99, 97,116,
/* 0x15c0 */ 101,  0,108,115,101,101,107,  0,117,112,120, 95,109,109, 97,112,
/* 0x15d0 */  95, 97,110,100, 95,102,100, 95, 97,110,100,114,111,105,100,  0,
/* 0x15e0 */ 109,109, 97,112,  0,117,112,120, 95,109,109, 97,112, 95, 97,110,
/* 0x15f0 */ 100, 95,102,100, 95,108,105,110,117,120,  0,117,110, 97,109,101,
/* 0x1600 */   0,101,110,100, 95,100,101, 99,111,109,112,114,101,115,115,  0,
/* 0x1610 */ 119,114,105,116,101,  0,102,100, 97,116, 97,115,121,110, 99,  0,
/* 0x1620 */ 103,101,116, 95,117,112,120,102,110, 95,112, 97,116,104,  0,109,
/* 0x1630 */ 101,109,102,100, 95, 99,114,101, 97,116,101,  0, 95,115,116, 97,
/* 0x1640 */ 114,116,  0,114,101, 97,100,  0,117,110,108,105,110,107,  0,109,
/* 0x1650 */ 101,109,115,101,116,  0,117, 99,108, 95,110,114,118, 50, 98, 95,
/* 0x1660 */ 100,101, 99,111,109,112,114,101,115,115, 95, 56,  0,109,121, 95,
/* 0x1670 */  98,107,112,116,  0,102,115,121,110, 99,  0,115,116, 97,116,  0,
/* 0x1680 */  99,112,114, 48,  0,101,120,105,116,  0,111,112,101,110,  0,109,
/* 0x1690 */ 107,100,105,114,  0, 99,108,111,115,101,  0,  0,  0,  0,  0,  0,
/* 0x16a0 */   1,  2,  0,  0, 56,  0,  0,  0,  1,  1,  0,  0,  4,  0,  0,  0,
/* 0x16b0 */   1,  2,  0,  0,  8,  0,  0,  0,  1,  2,  0,  0, 20,  0,  0,  0,
/* 0x16c0 */   1,  2,  0,  0, 28,  0,  0,  0,  1,  2,  0,  0, 48,  0,  0,  0,
/* 0x16d0 */   1,  6,  0,  0,104,  0,  0,  0,  1,  2,  0,  0,120,  0,  0,  0,
/* 0x16e0 */   1, 13,  0,  0,128,  0,  0,  0,  1,  2,  0,  0,176,  0,  0,  0,
/* 0x16f0 */   1,  2,  0,  0,240,  0,  0,  0,  1,  2,  0,  0, 12,  2,  0,  0,
/* 0x1700 */   1,  2,  0,  0, 56,  2,  0,  0,  1,  2,  0,  0,220,  3,  0,  0,
/* 0x1710 */   1,  2,  0,  0,244,  3,  0,  0,  1,  2,  0,  0, 28,  4,  0,  0,
/* 0x1720 */   1,  2,  0,  0, 32,  4,  0,  0,  1,  2,  0,  0, 44,  4,  0,  0,
/* 0x1730 */   1,  2,  0,  0,160,  4,  0,  0,  1,  2,  0,  0,164,  4,  0,  0,
/* 0x1740 */   1,  2,  0,  0,192,  4,  0,  0,  1,  2,  0,  0,216,  4,  0,  0,
/* 0x1750 */   1,  2,  0,  0, 16,  5,  0,  0,  1,  2,  0,  0, 24,  5,  0,  0,
/* 0x1760 */   1,  2,  0,  0, 28,  5,  0,  0,  1,  2,  0,  0, 44,  5,  0,  0,
/* 0x1770 */   1,  2,  0,  0, 48,  5,  0,  0,  1,  2,  0,  0, 52,  5,  0,  0,
/* 0x1780 */   1,  2,  0,  0, 64,  5,  0,  0,  1,  2,  0,  0, 80,  5,  0,  0,
/* 0x1790 */   1,  2,  0,  0, 84,  5,  0,  0,  1,  2,  0,  0, 92,  5,  0,  0,
/* 0x17a0 */   1,  2,  0,  0,100,  5,  0,  0,  1,  2,  0,  0,104,  5,  0,  0,
/* 0x17b0 */   1,  2,  0,  0,132,  5,  0,  0,  1,  2,  0,  0,136,  5,  0,  0,
/* 0x17c0 */   1,  2,  0,  0,  0,  0,  0,  0,  1, 20,  0,  0,  0,  0,  0,  0,
/* 0x17d0 */   1, 22,  0,  0, 12,  0,  0,  0,  1,  3,  0,  0, 40,  0,  0,  0,
/* 0x17e0 */   1,  3,  0,  0, 64,  0,  0,  0,  1,  3,  0,  0, 84,  0,  0,  0,
/* 0x17f0 */   1,  3,  0,  0,128,  0,  0,  0,  1, 32,  0,  0,140,  0,  0,  0,
/* 0x1800 */   1, 36,  0,  0,148,  0,  0,  0,  1,  3,  0,  0,168,  0,  0,  0,
/* 0x1810 */   1,  3,  0,  0,176,  0,  0,  0,  1,  3,  0,  0,188,  0,  0,  0,
/* 0x1820 */   1, 40,  0,  0,216,  0,  0,  0,  1, 34,  0,  0,244,  0,  0,  0,
/* 0x1830 */   1,  3,  0,  0, 12,  1,  0,  0,  1, 17,  0,  0, 32,  1,  0,  0,
/* 0x1840 */   1,  3,  0,  0, 36,  1,  0,  0,  1,  3,  0,  0, 76,  1,  0,  0,
/* 0x1850 */   1, 39,  0,  0, 96,  1,  0,  0,  1, 30,  0,  0,108,  1,  0,  0,
/* 0x1860 */   1, 41,  0,  0,120,  1,  0,  0,  1, 34,  0,  0,144,  1,  0,  0,
/* 0x1870 */   1,  3,  0,  0,160,  1,  0,  0,  1,  3,  0,  0,164,  1,  0,  0,
/* 0x1880 */   1,  3,  0,  0,176,  1,  0,  0,  1,  3,  0,  0,196,  1,  0,  0,
/* 0x1890 */   1, 17,  0,  0,220,  1,  0,  0,  1,  3,  0,  0,228,  1,  0,  0,
/* 0x18a0 */   1,  3,  0,  0,232,  1,  0,  0,  1,  3,  0,  0, 12,  2,  0,  0,
/* 0x18b0 */   1, 17,  0,  0, 24,  2,  0,  0,  1, 17,  0,  0, 44,  2,  0,  0,
/* 0x18c0 */   1,  3,  0,  0, 48,  2,  0,  0,  1,  3,  0,  0, 56,  2,  0,  0,
/* 0x18d0 */   1,  3,  0,  0, 60,  2,  0,  0,  1,  3,  0,  0, 84,  2,  0,  0,
/* 0x18e0 */   1, 17,  0,  0,108,  2,  0,  0,  1,  3,  0,  0,112,  2,  0,  0,
/* 0x18f0 */   1,  3,  0,  0,136,  2,  0,  0,  1, 17,  0,  0,144,  2,  0,  0,
/* 0x1900 */   1, 12,  0,  0,152,  2,  0,  0,  1,  3,  0,  0,164,  2,  0,  0,
/* 0x1910 */   1,  3,  0,  0,176,  2,  0,  0,  1,  3,  0,  0,220,  2,  0,  0,
/* 0x1920 */   1,  3,  0,  0,240,  2,  0,  0,  1, 28,  0,  0,252,  2,  0,  0,
/* 0x1930 */   1,  3,  0,  0,  8,  3,  0,  0,  1, 28,  0,  0, 20,  3,  0,  0,
/* 0x1940 */   1,  3,  0,  0, 24,  3,  0,  0,  1,  3,  0,  0, 60,  3,  0,  0,
/* 0x1950 */   1, 39,  0,  0, 68,  3,  0,  0,  1,  3,  0,  0, 72,  3,  0,  0,
/* 0x1960 */   1,  3,  0,  0, 96,  3,  0,  0,  1, 34,  0,  0,108,  3,  0,  0,
/* 0x1970 */   1, 23,  0,  0,112,  3,  0,  0,  1,  3,  0,  0,132,  3,  0,  0,
/* 0x1980 */   1,  3,  0,  0,140,  3,  0,  0,  1,  3,  0,  0,144,  3,  0,  0,
/* 0x1990 */   1,  3,  0,  0,164,  3,  0,  0,  1,  3,  0,  0,172,  3,  0,  0,
/* 0x19a0 */   1,  3,  0,  0,188,  3,  0,  0,  1,  3,  0,  0,196,  3,  0,  0,
/* 0x19b0 */   1,  3,  0,  0,200,  3,  0,  0,  1, 27,  0,  0,232,  3,  0,  0,
/* 0x19c0 */   1,  3,  0,  0,240,  3,  0,  0,  1,  3,  0,  0,252,  3,  0,  0,
/* 0x19d0 */   1,  3,  0,  0, 12,  4,  0,  0,  1,  3,  0,  0, 20,  4,  0,  0,
/* 0x19e0 */   1,  3,  0,  0, 36,  4,  0,  0,  1, 39,  0,  0, 48,  4,  0,  0,
/* 0x19f0 */   1,  3,  0,  0, 56,  4,  0,  0,  1, 31,  0,  0, 64,  4,  0,  0,
/* 0x1a00 */   1,  3,  0,  0, 76,  4,  0,  0,  1,  3,  0,  0, 80,  4,  0,  0,
/* 0x1a10 */   1, 10,  0,  0,104,  4,  0,  0,  1,  3,  0,  0,112,  4,  0,  0,
/* 0x1a20 */   1,  3,  0,  0,124,  4,  0,  0,  1, 18,  0,  0,132,  4,  0,  0,
/* 0x1a30 */   1,  3,  0,  0,136,  4,  0,  0,  1,  3,  0,  0,152,  4,  0,  0,
/* 0x1a40 */   1, 19,  0,  0,188,  4,  0,  0,  1, 25,  0,  0,204,  4,  0,  0,
/* 0x1a50 */   1, 19,  0,  0,216,  4,  0,  0,  1,  3,  0,  0,220,  4,  0,  0,
/* 0x1a60 */   1, 10,  0,  0,232,  4,  0,  0,  1,  3,  0,  0,248,  4,  0,  0,
/* 0x1a70 */   1, 25,  0,  0,252,  4,  0,  0,  1,  3,  0,  0, 28,  5,  0,  0,
/* 0x1a80 */   1, 21,  0,  0, 44,  5,  0,  0,  1,  3,  0,  0, 52,  5,  0,  0,
/* 0x1a90 */   1,  3,  0,  0, 16,  0,  0,  0,  1,  4,  0,  0, 36,  0,  0,  0,
/* 0x1aa0 */   1, 28,  0,  0, 48,  0,  0,  0,  1,  4,  0,  0, 60,  0,  0,  0,
/* 0x1ab0 */   1, 28,  0,  0, 72,  0,  0,  0,  1,  4,  0,  0, 76,  0,  0,  0,
/* 0x1ac0 */   1,  4,  0,  0,112,  0,  0,  0,  1, 39,  0,  0,120,  0,  0,  0,
/* 0x1ad0 */   1,  4,  0,  0,132,  0,  0,  0,  1,  4,  0,  0,136,  0,  0,  0,
/* 0x1ae0 */   1,  4,  0,  0,216,  0,  0,  0,  1, 25,  0,  0,224,  0,  0,  0,
/* 0x1af0 */   1, 38,  0,  0,236,  0,  0,  0,  1, 18,  0,  0,248,  0,  0,  0,
/* 0x1b00 */   1,  4,  0,  0, 32,  1,  0,  0,  1, 21,  0,  0, 40,  1,  0,  0,
/* 0x1b10 */   1, 10,  0,  0,  0,  0,  0,  0,  2, 11,  0,  0, 20,  0,  0,  0,
/* 0x1b20 */   1,  5,  0,  0, 12,  0,  0,  0,  1,  6,  0,  0, 32,  0,  0,  0,
/* 0x1b30 */   1,  6,  0,  0, 48,  0,  0,  0,  1,  6,  0,  0, 64,  0,  0,  0,
/* 0x1b40 */   1,  6,  0,  0, 80,  0,  0,  0,  1,  6,  0,  0, 96,  0,  0,  0,
/* 0x1b50 */   1,  6,  0,  0, 20,  2,  0,  0,  2, 15,  0,  0,102,105,108,101,
/* 0x1b60 */  32,102,111,114,109, 97,116, 32,101,108,102, 51, 50, 45,108,105,
/* 0x1b70 */ 116,116,108,101, 97,114,109, 10, 10, 83,101, 99,116,105,111,110,
/* 0x1b80 */ 115, 58, 10, 73,100,120, 32, 78, 97,109,101, 32, 32, 32, 32, 32,
/* 0x1b90 */  32, 32, 32, 32, 32, 83,105,122,101, 32, 32, 32, 32, 32, 32, 86,
/* 0x1ba0 */  77, 65, 32, 32, 32, 32, 32, 32, 32, 76, 77, 65, 32, 32, 32, 32,
/* 0x1bb0 */  32, 32, 32, 70,105,108,101, 32,111,102,102, 32, 32, 65,108,103,
/* 0x1bc0 */ 110, 32, 32, 70,108, 97,103,115, 10, 32, 32, 48, 32, 69, 76, 70,
/* 0x1bd0 */  83, 73, 71, 83, 69, 71, 86, 32, 32, 32, 32, 48, 53, 99, 32, 32,
/* 0x1be0 */  48, 32, 32, 48, 32, 32, 48, 51, 52, 32, 32, 50, 42, 42, 48, 32,
/* 0x1bf0 */  32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 32, 49, 32, 69, 76,
/* 0x1c00 */  70, 77, 65, 73, 78, 88, 50, 32, 32, 32, 32, 32, 48, 53, 57, 56,
/* 0x1c10 */  32, 32, 48, 32, 32, 48, 32, 32, 48, 57, 48, 32, 32, 50, 42, 42,
/* 0x1c20 */  50, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 32, 50, 32,
/* 0x1c30 */  69, 76, 70, 77, 65, 73, 78, 89, 32, 32, 32, 32, 32, 32, 48, 32,
/* 0x1c40 */  32, 48, 32, 32, 48, 32, 32, 48, 54, 50, 56, 32, 32, 50, 42, 42,
/* 0x1c50 */  48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 32, 51, 32,
/* 0x1c60 */  72, 85, 77, 70, 95, 65, 32, 32, 32, 32, 32, 32, 32, 32, 48, 52,
/* 0x1c70 */  32, 32, 48, 32, 32, 48, 32, 32, 48, 54, 50, 56, 32, 32, 50, 42,
/* 0x1c80 */  42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 32, 52,
/* 0x1c90 */  32, 72, 85, 77, 70, 95, 76, 32, 32, 32, 32, 32, 32, 32, 32, 48,
/* 0x1ca0 */  52, 32, 32, 48, 32, 32, 48, 32, 32, 48, 54, 50, 99, 32, 32, 50,
/* 0x1cb0 */  42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 32,
/* 0x1cc0 */  53, 32, 85, 77, 70, 95, 65, 78, 68, 82, 79, 73, 68, 32, 32, 32,
/* 0x1cd0 */  48, 53, 52, 52, 32, 32, 48, 32, 32, 48, 32, 32, 48, 54, 51, 48,
/* 0x1ce0 */  32, 32, 50, 42, 42, 50, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83,
/* 0x1cf0 */  10, 32, 32, 54, 32, 85, 77, 70, 95, 76, 73, 78, 85, 88, 32, 32,
/* 0x1d00 */  32, 32, 32, 48, 49, 52, 52, 32, 32, 48, 32, 32, 48, 32, 32, 48,
/* 0x1d10 */  98, 55, 52, 32, 32, 50, 42, 42, 50, 32, 32, 67, 79, 78, 84, 69,
/* 0x1d20 */  78, 84, 83, 10, 32, 32, 55, 32, 69, 76, 70, 77, 65, 73, 78, 88,
/* 0x1d30 */  32, 32, 32, 32, 32, 32, 48, 50, 56, 32, 32, 48, 32, 32, 48, 32,
/* 0x1d40 */  32, 48, 99, 98, 56, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78,
/* 0x1d50 */  84, 69, 78, 84, 83, 10, 32, 32, 56, 32, 69, 76, 70, 77, 65, 73,
/* 0x1d60 */  78, 90, 32, 32, 32, 32, 32, 32, 48, 50, 49, 56, 32, 32, 48, 50,
/* 0x1d70 */  56, 32, 32, 48, 50, 56, 32, 32, 48, 99,101, 48, 32, 32, 50, 42,
/* 0x1d80 */  42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 83, 89, 77,
/* 0x1d90 */  66, 79, 76, 32, 84, 65, 66, 76, 69, 58, 10, 48, 48, 48, 48, 48,
/* 0x1da0 */  48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 69, 76, 70, 83,
/* 0x1db0 */  73, 71, 83, 69, 71, 86, 32, 48, 32, 69, 76, 70, 83, 73, 71, 83,
/* 0x1dc0 */  69, 71, 86, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32,
/* 0x1dd0 */  32, 32,100, 32, 32, 69, 76, 70, 77, 65, 73, 78, 88, 50, 32, 48,
/* 0x1de0 */  32, 69, 76, 70, 77, 65, 73, 78, 88, 50, 10, 48, 48, 48, 48, 48,
/* 0x1df0 */  48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 85, 77, 70, 95,
/* 0x1e00 */  65, 78, 68, 82, 79, 73, 68, 32, 48, 32, 85, 77, 70, 95, 65, 78,
/* 0x1e10 */  68, 82, 79, 73, 68, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108,
/* 0x1e20 */  32, 32, 32, 32,100, 32, 32, 85, 77, 70, 95, 76, 73, 78, 85, 88,
/* 0x1e30 */  32, 48, 32, 85, 77, 70, 95, 76, 73, 78, 85, 88, 10, 48, 48, 48,
/* 0x1e40 */  48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 69, 76,
/* 0x1e50 */  70, 77, 65, 73, 78, 88, 32, 48, 32, 69, 76, 70, 77, 65, 73, 78,
/* 0x1e60 */  88, 10, 48, 48, 48, 48, 48, 48, 50, 56, 32,108, 32, 32, 32, 32,
/* 0x1e70 */ 100, 32, 32, 69, 76, 70, 77, 65, 73, 78, 90, 32, 48, 32, 69, 76,
/* 0x1e80 */  70, 77, 65, 73, 78, 90, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,
/* 0x1e90 */ 108, 32, 32, 32, 32,100, 32, 32, 69, 76, 70, 77, 65, 73, 78, 89,
/* 0x1ea0 */  32, 48, 32, 69, 76, 70, 77, 65, 73, 78, 89, 10, 48, 48, 48, 48,
/* 0x1eb0 */  48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 72, 85, 77,
/* 0x1ec0 */  70, 95, 65, 32, 48, 32, 72, 85, 77, 70, 95, 65, 10, 48, 48, 48,
/* 0x1ed0 */  48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 72, 85,
/* 0x1ee0 */  77, 70, 95, 76, 32, 48, 32, 72, 85, 77, 70, 95, 76, 10, 48, 48,
/* 0x1ef0 */  48, 48, 48, 53, 56, 99, 32,103, 32, 32, 32, 32, 32, 32, 32, 69,
/* 0x1f00 */  76, 70, 77, 65, 73, 78, 88, 50, 32, 48, 32,103,101,116, 95,112,
/* 0x1f10 */  97,103,101, 95,109, 97,115,107, 10, 48, 48, 48, 48, 48, 48, 48,
/* 0x1f20 */  48, 32, 32, 32, 32, 32, 32, 32, 32, 32, 42, 85, 78, 68, 42, 32,
/* 0x1f30 */  48, 32, 77, 70, 76, 71, 10, 48, 48, 48, 48, 48, 49, 49, 52, 32,
/* 0x1f40 */ 103, 32, 32, 32, 32, 32, 32, 32, 69, 76, 70, 77, 65, 73, 78, 90,
/* 0x1f50 */  32, 48, 32,103,101,116,112,105,100, 10, 48, 48, 48, 48, 48, 53,
/* 0x1f60 */  57, 56, 32,103, 32, 32, 32, 32, 32, 32, 32, 69, 76, 70, 77, 65,
/* 0x1f70 */  73, 78, 88, 50, 32, 48, 32,117,112,120, 95,109,109, 97,112, 95,
/* 0x1f80 */  97,110,100, 95,102,100, 10, 48, 48, 48, 48, 48, 48, 51, 48, 32,
/* 0x1f90 */ 103, 32, 32, 32, 32, 32, 32, 32, 69, 76, 70, 77, 65, 73, 78, 90,
/* 0x1fa0 */  32, 48, 32,109,101,109, 99,112,121, 10, 48, 48, 48, 48, 48, 48,
/* 0x1fb0 */  48, 48, 32, 32, 32, 32, 32, 32, 32, 32, 32, 42, 85, 78, 68, 42,
/* 0x1fc0 */  32, 48, 32, 79, 95, 66, 73, 78, 70, 79, 10, 48, 48, 48, 48, 48,
/* 0x1fd0 */  49, 99, 56, 32,103, 32, 32, 32, 32, 32, 32, 32, 69, 76, 70, 77,
/* 0x1fe0 */  65, 73, 78, 90, 32, 48, 32, 80,115,121,110, 99, 10, 48, 48, 48,
/* 0x1ff0 */  48, 48, 48, 55, 52, 32,103, 32, 32, 32, 32, 32, 32, 32, 69, 76,
/* 0x2000 */  70, 77, 65, 73, 78, 90, 32, 48, 32,109,101,109,112, 99,112,121,
/* 0x2010 */  10, 48, 48, 48, 48, 48, 49, 48, 48, 32,103, 32, 32, 32, 32, 32,
/* 0x2020 */  32, 32, 69, 76, 70, 77, 65, 73, 78, 90, 32, 48, 32,102,116,114,
/* 0x2030 */ 117,110, 99, 97,116,101, 10, 48, 48, 48, 48, 48, 49, 50, 56, 32,
/* 0x2040 */ 103, 32, 32, 32, 32, 32, 32, 32, 69, 76, 70, 77, 65, 73, 78, 90,
/* 0x2050 */  32, 48, 32,108,115,101,101,107, 10, 48, 48, 48, 48, 48, 50, 99,
/* 0x2060 */  52, 32,103, 32, 32, 32, 32, 32, 70, 32, 85, 77, 70, 95, 65, 78,
/* 0x2070 */  68, 82, 79, 73, 68, 32, 48, 50, 56, 48, 32,117,112,120, 95,109,
/* 0x2080 */ 109, 97,112, 95, 97,110,100, 95,102,100, 95, 97,110,100,114,111,
/* 0x2090 */ 105,100, 10, 48, 48, 48, 48, 48, 49,102, 56, 32,103, 32, 32, 32,
/* 0x20a0 */  32, 32, 32, 32, 69, 76, 70, 77, 65, 73, 78, 90, 32, 48, 32,109,
/* 0x20b0 */ 109, 97,112, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,103, 32, 32,
/* 0x20c0 */  32, 32, 32, 70, 32, 85, 77, 70, 95, 76, 73, 78, 85, 88, 32, 48,
/* 0x20d0 */  49, 52, 52, 32,117,112,120, 95,109,109, 97,112, 95, 97,110,100,
/* 0x20e0 */  95,102,100, 95,108,105,110,117,120, 10, 48, 48, 48, 48, 48, 49,
/* 0x20f0 */  56, 99, 32,103, 32, 32, 32, 32, 32, 32, 32, 69, 76, 70, 77, 65,
/* 0x2100 */  73, 78, 90, 32, 48, 32,117,110, 97,109,101, 10, 48, 48, 48, 48,
/* 0x2110 */  48, 48, 48, 48, 32,103, 32, 32, 32, 32, 32, 32, 32, 69, 76, 70,
/* 0x2120 */  77, 65, 73, 78, 89, 32, 48, 32,101,110,100, 95,100,101, 99,111,
/* 0x2130 */ 109,112,114,101,115,115, 10, 48, 48, 48, 48, 48, 49, 98, 52, 32,
/* 0x2140 */ 103, 32, 32, 32, 32, 32, 32, 32, 69, 76, 70, 77, 65, 73, 78, 90,
/* 0x2150 */  32, 48, 32,119,114,105,116,101, 10, 48, 48, 48, 48, 48, 48,100,
/* 0x2160 */  56, 32,103, 32, 32, 32, 32, 32, 32, 32, 69, 76, 70, 77, 65, 73,
/* 0x2170 */  78, 90, 32, 48, 32,102,100, 97,116, 97,115,121,110, 99, 10, 48,
/* 0x2180 */  48, 48, 48, 48, 48, 50, 56, 32,103, 32, 32, 32, 32, 32, 32, 32,
/* 0x2190 */  69, 76, 70, 77, 65, 73, 78, 90, 32, 48, 32,103,101,116, 95,117,
/* 0x21a0 */ 112,120,102,110, 95,112, 97,116,104, 10, 48, 48, 48, 48, 48, 48,
/* 0x21b0 */  57, 48, 32,103, 32, 32, 32, 32, 32, 32, 32, 69, 76, 70, 77, 65,
/* 0x21c0 */  73, 78, 90, 32, 48, 32,109,101,109,102,100, 95, 99,114,101, 97,
/* 0x21d0 */ 116,101, 10, 48, 48, 48, 48, 48, 48, 48, 52, 32,103, 32, 32, 32,
/* 0x21e0 */  32, 32, 32, 32, 69, 76, 70, 77, 65, 73, 78, 88, 32, 48, 32, 95,
/* 0x21f0 */ 115,116, 97,114,116, 10, 48, 48, 48, 48, 48, 49, 54, 52, 32,103,
/* 0x2200 */  32, 32, 32, 32, 32, 32, 32, 69, 76, 70, 77, 65, 73, 78, 90, 32,
/* 0x2210 */  48, 32,114,101, 97,100, 10, 48, 48, 48, 48, 48, 49, 97, 48, 32,
/* 0x2220 */ 103, 32, 32, 32, 32, 32, 32, 32, 69, 76, 70, 77, 65, 73, 78, 90,
/* 0x2230 */  32, 48, 32,117,110,108,105,110,107, 10, 48, 48, 48, 48, 48, 48,
/* 0x2240 */  53, 52, 32,103, 32, 32, 32, 32, 32, 32, 32, 69, 76, 70, 77, 65,
/* 0x2250 */  73, 78, 90, 32, 48, 32,109,101,109,115,101,116, 10, 48, 48, 48,
/* 0x2260 */  48, 48, 52, 99, 56, 32,103, 32, 32, 32, 32, 32, 70, 32, 69, 76,
/* 0x2270 */  70, 77, 65, 73, 78, 88, 50, 32, 48, 99, 52, 32,117, 99,108, 95,
/* 0x2280 */ 110,114,118, 50, 98, 95,100,101, 99,111,109,112,114,101,115,115,
/* 0x2290 */  95, 56, 10, 48, 48, 48, 48, 48, 49,102, 48, 32,103, 32, 32, 32,
/* 0x22a0 */  32, 32, 32, 32, 69, 76, 70, 77, 65, 73, 78, 90, 32, 48, 32,109,
/* 0x22b0 */ 121, 95, 98,107,112,116, 10, 48, 48, 48, 48, 48, 48,101, 99, 32,
/* 0x22c0 */ 103, 32, 32, 32, 32, 32, 32, 32, 69, 76, 70, 77, 65, 73, 78, 90,
/* 0x22d0 */  32, 48, 32,102,115,121,110, 99, 10, 48, 48, 48, 48, 48, 49, 55,
/* 0x22e0 */  56, 32,103, 32, 32, 32, 32, 32, 32, 32, 69, 76, 70, 77, 65, 73,
/* 0x22f0 */  78, 90, 32, 48, 32,115,116, 97,116, 10, 48, 48, 48, 48, 48, 50,
/* 0x2300 */  52, 48, 32,103, 32, 32, 32, 32, 32, 32, 32, 69, 76, 70, 77, 65,
/* 0x2310 */  73, 78, 90, 32, 48, 32, 99,112,114, 48, 10, 48, 48, 48, 48, 48,
/* 0x2320 */  48, 99, 52, 32,103, 32, 32, 32, 32, 32, 32, 32, 69, 76, 70, 77,
/* 0x2330 */  65, 73, 78, 90, 32, 48, 32,101,120,105,116, 10, 48, 48, 48, 48,
/* 0x2340 */  48, 49, 53, 48, 32,103, 32, 32, 32, 32, 32, 32, 32, 69, 76, 70,
/* 0x2350 */  77, 65, 73, 78, 90, 32, 48, 32,111,112,101,110, 10, 48, 48, 48,
/* 0x2360 */  48, 48, 49, 51, 99, 32,103, 32, 32, 32, 32, 32, 32, 32, 69, 76,
/* 0x2370 */  70, 77, 65, 73, 78, 90, 32, 48, 32,109,107,100,105,114, 10, 48,
/* 0x2380 */  48, 48, 48, 48, 48, 98, 48, 32,103, 32, 32, 32, 32, 32, 32, 32,
/* 0x2390 */  69, 76, 70, 77, 65, 73, 78, 90, 32, 48, 32, 99,108,111,115,101,
/* 0x23a0 */  10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67,
/* 0x23b0 */  79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 69, 76, 70, 83, 73, 71,
/* 0x23c0 */  83, 69, 71, 86, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32,
/* 0x23d0 */  84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x23e0 */  32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x23f0 */  32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32,
/* 0x2400 */  32, 32, 32, 69, 76, 70, 77, 65, 73, 78, 88, 50, 10, 48, 48, 48,
/* 0x2410 */  48, 48, 48, 51, 56, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52,
/* 0x2420 */  32, 32, 32, 32, 32, 32, 32, 32, 69, 76, 70, 83, 73, 71, 83, 69,
/* 0x2430 */  71, 86, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82,
/* 0x2440 */  69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 69, 76, 70, 77,
/* 0x2450 */  65, 73, 78, 88, 50, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32,
/* 0x2460 */  32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x2470 */  32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48,
/* 0x2480 */  52, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32,
/* 0x2490 */  32, 32, 32, 32, 69, 76, 70, 77, 65, 73, 78, 88, 50, 10, 48, 48,
/* 0x24a0 */  48, 48, 48, 48, 48, 56, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50,
/* 0x24b0 */  52, 32, 32, 32, 32, 32, 32, 32, 32, 69, 76, 70, 77, 65, 73, 78,
/* 0x24c0 */  88, 50, 10, 48, 48, 48, 48, 48, 48, 49, 52, 32, 82, 95, 65, 82,
/* 0x24d0 */  77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 69, 76,
/* 0x24e0 */  70, 77, 65, 73, 78, 88, 50, 10, 48, 48, 48, 48, 48, 48, 49, 99,
/* 0x24f0 */  32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32,
/* 0x2500 */  32, 32, 32, 69, 76, 70, 77, 65, 73, 78, 88, 50, 10, 48, 48, 48,
/* 0x2510 */  48, 48, 48, 51, 48, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52,
/* 0x2520 */  32, 32, 32, 32, 32, 32, 32, 32, 69, 76, 70, 77, 65, 73, 78, 90,
/* 0x2530 */  10, 48, 48, 48, 48, 48, 48, 54, 56, 32, 82, 95, 65, 82, 77, 95,
/* 0x2540 */  80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 69, 76, 70, 77,
/* 0x2550 */  65, 73, 78, 88, 50, 10, 48, 48, 48, 48, 48, 48, 55, 56, 32, 82,
/* 0x2560 */  95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32,
/* 0x2570 */  32,117,112,120, 95,109,109, 97,112, 95, 97,110,100, 95,102,100,
/* 0x2580 */  10, 48, 48, 48, 48, 48, 48, 56, 48, 32, 82, 95, 65, 82, 77, 95,
/* 0x2590 */  80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 69, 76, 70, 77,
/* 0x25a0 */  65, 73, 78, 88, 50, 10, 48, 48, 48, 48, 48, 48, 98, 48, 32, 82,
/* 0x25b0 */  95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32,
/* 0x25c0 */  32, 69, 76, 70, 77, 65, 73, 78, 88, 50, 10, 48, 48, 48, 48, 48,
/* 0x25d0 */  48,102, 48, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32,
/* 0x25e0 */  32, 32, 32, 32, 32, 32, 69, 76, 70, 77, 65, 73, 78, 88, 50, 10,
/* 0x25f0 */  48, 48, 48, 48, 48, 50, 48, 99, 32, 82, 95, 65, 82, 77, 95, 80,
/* 0x2600 */  67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 69, 76, 70, 77, 65,
/* 0x2610 */  73, 78, 88, 50, 10, 48, 48, 48, 48, 48, 50, 51, 56, 32, 82, 95,
/* 0x2620 */  65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x2630 */  69, 76, 70, 77, 65, 73, 78, 88, 50, 10, 48, 48, 48, 48, 48, 51,
/* 0x2640 */ 100, 99, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32,
/* 0x2650 */  32, 32, 32, 32, 32, 69, 76, 70, 77, 65, 73, 78, 88, 50, 10, 48,
/* 0x2660 */  48, 48, 48, 48, 51,102, 52, 32, 82, 95, 65, 82, 77, 95, 80, 67,
/* 0x2670 */  50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 69, 76, 70, 77, 65, 73,
/* 0x2680 */  78, 88, 50, 10, 48, 48, 48, 48, 48, 52, 49, 99, 32, 82, 95, 65,
/* 0x2690 */  82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 69,
/* 0x26a0 */  76, 70, 77, 65, 73, 78, 88, 50, 10, 48, 48, 48, 48, 48, 52, 50,
/* 0x26b0 */  48, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32,
/* 0x26c0 */  32, 32, 32, 32, 69, 76, 70, 77, 65, 73, 78, 88, 50, 10, 48, 48,
/* 0x26d0 */  48, 48, 48, 52, 50, 99, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50,
/* 0x26e0 */  52, 32, 32, 32, 32, 32, 32, 32, 32, 69, 76, 70, 77, 65, 73, 78,
/* 0x26f0 */  88, 50, 10, 48, 48, 48, 48, 48, 52, 97, 48, 32, 82, 95, 65, 82,
/* 0x2700 */  77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 69, 76,
/* 0x2710 */  70, 77, 65, 73, 78, 88, 50, 10, 48, 48, 48, 48, 48, 52, 97, 52,
/* 0x2720 */  32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32,
/* 0x2730 */  32, 32, 32, 69, 76, 70, 77, 65, 73, 78, 88, 50, 10, 48, 48, 48,
/* 0x2740 */  48, 48, 52, 99, 48, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52,
/* 0x2750 */  32, 32, 32, 32, 32, 32, 32, 32, 69, 76, 70, 77, 65, 73, 78, 88,
/* 0x2760 */  50, 10, 48, 48, 48, 48, 48, 52,100, 56, 32, 82, 95, 65, 82, 77,
/* 0x2770 */  95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 69, 76, 70,
/* 0x2780 */  77, 65, 73, 78, 88, 50, 10, 48, 48, 48, 48, 48, 53, 49, 48, 32,
/* 0x2790 */  82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32,
/* 0x27a0 */  32, 32, 69, 76, 70, 77, 65, 73, 78, 88, 50, 10, 48, 48, 48, 48,
/* 0x27b0 */  48, 53, 49, 56, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32,
/* 0x27c0 */  32, 32, 32, 32, 32, 32, 32, 69, 76, 70, 77, 65, 73, 78, 88, 50,
/* 0x27d0 */  10, 48, 48, 48, 48, 48, 53, 49, 99, 32, 82, 95, 65, 82, 77, 95,
/* 0x27e0 */  80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 69, 76, 70, 77,
/* 0x27f0 */  65, 73, 78, 88, 50, 10, 48, 48, 48, 48, 48, 53, 50, 99, 32, 82,
/* 0x2800 */  95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32,
/* 0x2810 */  32, 69, 76, 70, 77, 65, 73, 78, 88, 50, 10, 48, 48, 48, 48, 48,
/* 0x2820 */  53, 51, 48, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32,
/* 0x2830 */  32, 32, 32, 32, 32, 32, 69, 76, 70, 77, 65, 73, 78, 88, 50, 10,
/* 0x2840 */  48, 48, 48, 48, 48, 53, 51, 52, 32, 82, 95, 65, 82, 77, 95, 80,
/* 0x2850 */  67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 69, 76, 70, 77, 65,
/* 0x2860 */  73, 78, 88, 50, 10, 48, 48, 48, 48, 48, 53, 52, 48, 32, 82, 95,
/* 0x2870 */  65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x2880 */  69, 76, 70, 77, 65, 73, 78, 88, 50, 10, 48, 48, 48, 48, 48, 53,
/* 0x2890 */  53, 48, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32,
/* 0x28a0 */  32, 32, 32, 32, 32, 69, 76, 70, 77, 65, 73, 78, 88, 50, 10, 48,
/* 0x28b0 */  48, 48, 48, 48, 53, 53, 52, 32, 82, 95, 65, 82, 77, 95, 80, 67,
/* 0x28c0 */  50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 69, 76, 70, 77, 65, 73,
/* 0x28d0 */  78, 88, 50, 10, 48, 48, 48, 48, 48, 53, 53, 99, 32, 82, 95, 65,
/* 0x28e0 */  82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 69,
/* 0x28f0 */  76, 70, 77, 65, 73, 78, 88, 50, 10, 48, 48, 48, 48, 48, 53, 54,
/* 0x2900 */  52, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32,
/* 0x2910 */  32, 32, 32, 32, 69, 76, 70, 77, 65, 73, 78, 88, 50, 10, 48, 48,
/* 0x2920 */  48, 48, 48, 53, 54, 56, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50,
/* 0x2930 */  52, 32, 32, 32, 32, 32, 32, 32, 32, 69, 76, 70, 77, 65, 73, 78,
/* 0x2940 */  88, 50, 10, 48, 48, 48, 48, 48, 53, 56, 52, 32, 82, 95, 65, 82,
/* 0x2950 */  77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 69, 76,
/* 0x2960 */  70, 77, 65, 73, 78, 88, 50, 10, 48, 48, 48, 48, 48, 53, 56, 56,
/* 0x2970 */  32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32,
/* 0x2980 */  32, 32, 32, 69, 76, 70, 77, 65, 73, 78, 88, 50, 10, 10, 82, 69,
/* 0x2990 */  76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83,
/* 0x29a0 */  32, 70, 79, 82, 32, 91, 72, 85, 77, 70, 95, 65, 93, 58, 10, 79,
/* 0x29b0 */  70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32,
/* 0x29c0 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10,
/* 0x29d0 */  48, 48, 48, 48, 48, 48, 48, 48, 32, 82, 95, 65, 82, 77, 95, 80,
/* 0x29e0 */  67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32,117,112,120, 95,109,
/* 0x29f0 */ 109, 97,112, 95, 97,110,100, 95,102,100, 95, 97,110,100,114,111,
/* 0x2a00 */ 105,100, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82,
/* 0x2a10 */  69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 72, 85, 77, 70,
/* 0x2a20 */  95, 76, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89,
/* 0x2a30 */  80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x2a40 */  86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32, 82,
/* 0x2a50 */  95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32,
/* 0x2a60 */  32,117,112,120, 95,109,109, 97,112, 95, 97,110,100, 95,102,100,
/* 0x2a70 */  95,108,105,110,117,120, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73,
/* 0x2a80 */  79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91,
/* 0x2a90 */  85, 77, 70, 95, 65, 78, 68, 82, 79, 73, 68, 93, 58, 10, 79, 70,
/* 0x2aa0 */  70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32,
/* 0x2ab0 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48,
/* 0x2ac0 */  48, 48, 48, 48, 48, 48, 99, 32, 82, 95, 65, 82, 77, 95, 80, 67,
/* 0x2ad0 */  50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 85, 77, 70, 95, 65, 78,
/* 0x2ae0 */  68, 82, 79, 73, 68, 10, 48, 48, 48, 48, 48, 48, 50, 56, 32, 82,
/* 0x2af0 */  95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32,
/* 0x2b00 */  32, 85, 77, 70, 95, 65, 78, 68, 82, 79, 73, 68, 10, 48, 48, 48,
/* 0x2b10 */  48, 48, 48, 52, 48, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52,
/* 0x2b20 */  32, 32, 32, 32, 32, 32, 32, 32, 85, 77, 70, 95, 65, 78, 68, 82,
/* 0x2b30 */  79, 73, 68, 10, 48, 48, 48, 48, 48, 48, 53, 52, 32, 82, 95, 65,
/* 0x2b40 */  82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 85,
/* 0x2b50 */  77, 70, 95, 65, 78, 68, 82, 79, 73, 68, 10, 48, 48, 48, 48, 48,
/* 0x2b60 */  48, 56, 48, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32,
/* 0x2b70 */  32, 32, 32, 32, 32, 32,109,101,109,115,101,116, 10, 48, 48, 48,
/* 0x2b80 */  48, 48, 48, 56, 99, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52,
/* 0x2b90 */  32, 32, 32, 32, 32, 32, 32, 32,115,116, 97,116, 10, 48, 48, 48,
/* 0x2ba0 */  48, 48, 48, 57, 52, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52,
/* 0x2bb0 */  32, 32, 32, 32, 32, 32, 32, 32, 85, 77, 70, 95, 65, 78, 68, 82,
/* 0x2bc0 */  79, 73, 68, 10, 48, 48, 48, 48, 48, 48, 97, 56, 32, 82, 95, 65,
/* 0x2bd0 */  82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 85,
/* 0x2be0 */  77, 70, 95, 65, 78, 68, 82, 79, 73, 68, 10, 48, 48, 48, 48, 48,
/* 0x2bf0 */  48, 98, 48, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32,
/* 0x2c00 */  32, 32, 32, 32, 32, 32, 85, 77, 70, 95, 65, 78, 68, 82, 79, 73,
/* 0x2c10 */  68, 10, 48, 48, 48, 48, 48, 48, 98, 99, 32, 82, 95, 65, 82, 77,
/* 0x2c20 */  95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32,109,107,100,
/* 0x2c30 */ 105,114, 10, 48, 48, 48, 48, 48, 48,100, 56, 32, 82, 95, 65, 82,
/* 0x2c40 */  77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32,109,121,
/* 0x2c50 */  95, 98,107,112,116, 10, 48, 48, 48, 48, 48, 48,102, 52, 32, 82,
/* 0x2c60 */  95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32,
/* 0x2c70 */  32, 85, 77, 70, 95, 65, 78, 68, 82, 79, 73, 68, 10, 48, 48, 48,
/* 0x2c80 */  48, 48, 49, 48, 99, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52,
/* 0x2c90 */  32, 32, 32, 32, 32, 32, 32, 32,109,101,109,112, 99,112,121, 10,
/* 0x2ca0 */  48, 48, 48, 48, 48, 49, 50, 48, 32, 82, 95, 65, 82, 77, 95, 80,
/* 0x2cb0 */  67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 85, 77, 70, 95, 65,
/* 0x2cc0 */  78, 68, 82, 79, 73, 68, 10, 48, 48, 48, 48, 48, 49, 50, 52, 32,
/* 0x2cd0 */  82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32,
/* 0x2ce0 */  32, 32, 85, 77, 70, 95, 65, 78, 68, 82, 79, 73, 68, 10, 48, 48,
/* 0x2cf0 */  48, 48, 48, 49, 52, 99, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50,
/* 0x2d00 */  52, 32, 32, 32, 32, 32, 32, 32, 32,111,112,101,110, 10, 48, 48,
/* 0x2d10 */  48, 48, 48, 49, 54, 48, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50,
/* 0x2d20 */  52, 32, 32, 32, 32, 32, 32, 32, 32,114,101, 97,100, 10, 48, 48,
/* 0x2d30 */  48, 48, 48, 49, 54, 99, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50,
/* 0x2d40 */  52, 32, 32, 32, 32, 32, 32, 32, 32, 99,108,111,115,101, 10, 48,
/* 0x2d50 */  48, 48, 48, 48, 49, 55, 56, 32, 82, 95, 65, 82, 77, 95, 80, 67,
/* 0x2d60 */  50, 52, 32, 32, 32, 32, 32, 32, 32, 32,109,121, 95, 98,107,112,
/* 0x2d70 */ 116, 10, 48, 48, 48, 48, 48, 49, 57, 48, 32, 82, 95, 65, 82, 77,
/* 0x2d80 */  95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 85, 77, 70,
/* 0x2d90 */  95, 65, 78, 68, 82, 79, 73, 68, 10, 48, 48, 48, 48, 48, 49, 97,
/* 0x2da0 */  48, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32,
/* 0x2db0 */  32, 32, 32, 32, 85, 77, 70, 95, 65, 78, 68, 82, 79, 73, 68, 10,
/* 0x2dc0 */  48, 48, 48, 48, 48, 49, 97, 52, 32, 82, 95, 65, 82, 77, 95, 80,
/* 0x2dd0 */  67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 85, 77, 70, 95, 65,
/* 0x2de0 */  78, 68, 82, 79, 73, 68, 10, 48, 48, 48, 48, 48, 49, 98, 48, 32,
/* 0x2df0 */  82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32,
/* 0x2e00 */  32, 32, 85, 77, 70, 95, 65, 78, 68, 82, 79, 73, 68, 10, 48, 48,
/* 0x2e10 */  48, 48, 48, 49, 99, 52, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50,
/* 0x2e20 */  52, 32, 32, 32, 32, 32, 32, 32, 32,109,101,109,112, 99,112,121,
/* 0x2e30 */  10, 48, 48, 48, 48, 48, 49,100, 99, 32, 82, 95, 65, 82, 77, 95,
/* 0x2e40 */  80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 85, 77, 70, 95,
/* 0x2e50 */  65, 78, 68, 82, 79, 73, 68, 10, 48, 48, 48, 48, 48, 49,101, 52,
/* 0x2e60 */  32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32,
/* 0x2e70 */  32, 32, 32, 85, 77, 70, 95, 65, 78, 68, 82, 79, 73, 68, 10, 48,
/* 0x2e80 */  48, 48, 48, 48, 49,101, 56, 32, 82, 95, 65, 82, 77, 95, 80, 67,
/* 0x2e90 */  50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 85, 77, 70, 95, 65, 78,
/* 0x2ea0 */  68, 82, 79, 73, 68, 10, 48, 48, 48, 48, 48, 50, 48, 99, 32, 82,
/* 0x2eb0 */  95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32,
/* 0x2ec0 */  32,109,101,109,112, 99,112,121, 10, 48, 48, 48, 48, 48, 50, 49,
/* 0x2ed0 */  56, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32,
/* 0x2ee0 */  32, 32, 32, 32,109,101,109,112, 99,112,121, 10, 48, 48, 48, 48,
/* 0x2ef0 */  48, 50, 50, 99, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32,
/* 0x2f00 */  32, 32, 32, 32, 32, 32, 32, 85, 77, 70, 95, 65, 78, 68, 82, 79,
/* 0x2f10 */  73, 68, 10, 48, 48, 48, 48, 48, 50, 51, 48, 32, 82, 95, 65, 82,
/* 0x2f20 */  77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 85, 77,
/* 0x2f30 */  70, 95, 65, 78, 68, 82, 79, 73, 68, 10, 48, 48, 48, 48, 48, 50,
/* 0x2f40 */  51, 56, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32,
/* 0x2f50 */  32, 32, 32, 32, 32, 85, 77, 70, 95, 65, 78, 68, 82, 79, 73, 68,
/* 0x2f60 */  10, 48, 48, 48, 48, 48, 50, 51, 99, 32, 82, 95, 65, 82, 77, 95,
/* 0x2f70 */  80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 85, 77, 70, 95,
/* 0x2f80 */  65, 78, 68, 82, 79, 73, 68, 10, 48, 48, 48, 48, 48, 50, 53, 52,
/* 0x2f90 */  32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32,
/* 0x2fa0 */  32, 32, 32,109,101,109,112, 99,112,121, 10, 48, 48, 48, 48, 48,
/* 0x2fb0 */  50, 54, 99, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32,
/* 0x2fc0 */  32, 32, 32, 32, 32, 32, 85, 77, 70, 95, 65, 78, 68, 82, 79, 73,
/* 0x2fd0 */  68, 10, 48, 48, 48, 48, 48, 50, 55, 48, 32, 82, 95, 65, 82, 77,
/* 0x2fe0 */  95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 85, 77, 70,
/* 0x2ff0 */  95, 65, 78, 68, 82, 79, 73, 68, 10, 48, 48, 48, 48, 48, 50, 56,
/* 0x3000 */  56, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32,
/* 0x3010 */  32, 32, 32, 32,109,101,109,112, 99,112,121, 10, 48, 48, 48, 48,
/* 0x3020 */  48, 50, 57, 48, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32,
/* 0x3030 */  32, 32, 32, 32, 32, 32, 32,103,101,116,112,105,100, 10, 48, 48,
/* 0x3040 */  48, 48, 48, 50, 57, 56, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50,
/* 0x3050 */  52, 32, 32, 32, 32, 32, 32, 32, 32, 85, 77, 70, 95, 65, 78, 68,
/* 0x3060 */  82, 79, 73, 68, 10, 48, 48, 48, 48, 48, 50, 97, 52, 32, 82, 95,
/* 0x3070 */  65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x3080 */  85, 77, 70, 95, 65, 78, 68, 82, 79, 73, 68, 10, 48, 48, 48, 48,
/* 0x3090 */  48, 50, 98, 48, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32,
/* 0x30a0 */  32, 32, 32, 32, 32, 32, 32, 85, 77, 70, 95, 65, 78, 68, 82, 79,
/* 0x30b0 */  73, 68, 10, 48, 48, 48, 48, 48, 50,100, 99, 32, 82, 95, 65, 82,
/* 0x30c0 */  77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 85, 77,
/* 0x30d0 */  70, 95, 65, 78, 68, 82, 79, 73, 68, 10, 48, 48, 48, 48, 48, 50,
/* 0x30e0 */ 102, 48, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32,
/* 0x30f0 */  32, 32, 32, 32, 32,109,101,109,102,100, 95, 99,114,101, 97,116,
/* 0x3100 */ 101, 10, 48, 48, 48, 48, 48, 50,102, 99, 32, 82, 95, 65, 82, 77,
/* 0x3110 */  95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 85, 77, 70,
/* 0x3120 */  95, 65, 78, 68, 82, 79, 73, 68, 10, 48, 48, 48, 48, 48, 51, 48,
/* 0x3130 */  56, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32,
/* 0x3140 */  32, 32, 32, 32,109,101,109,102,100, 95, 99,114,101, 97,116,101,
/* 0x3150 */  10, 48, 48, 48, 48, 48, 51, 49, 52, 32, 82, 95, 65, 82, 77, 95,
/* 0x3160 */  80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 85, 77, 70, 95,
/* 0x3170 */  65, 78, 68, 82, 79, 73, 68, 10, 48, 48, 48, 48, 48, 51, 49, 56,
/* 0x3180 */  32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32,
/* 0x3190 */  32, 32, 32, 85, 77, 70, 95, 65, 78, 68, 82, 79, 73, 68, 10, 48,
/* 0x31a0 */  48, 48, 48, 48, 51, 51, 99, 32, 82, 95, 65, 82, 77, 95, 80, 67,
/* 0x31b0 */  50, 52, 32, 32, 32, 32, 32, 32, 32, 32,111,112,101,110, 10, 48,
/* 0x31c0 */  48, 48, 48, 48, 51, 52, 52, 32, 82, 95, 65, 82, 77, 95, 80, 67,
/* 0x31d0 */  50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 85, 77, 70, 95, 65, 78,
/* 0x31e0 */  68, 82, 79, 73, 68, 10, 48, 48, 48, 48, 48, 51, 52, 56, 32, 82,
/* 0x31f0 */  95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32,
/* 0x3200 */  32, 85, 77, 70, 95, 65, 78, 68, 82, 79, 73, 68, 10, 48, 48, 48,
/* 0x3210 */  48, 48, 51, 54, 48, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52,
/* 0x3220 */  32, 32, 32, 32, 32, 32, 32, 32,109,121, 95, 98,107,112,116, 10,
/* 0x3230 */  48, 48, 48, 48, 48, 51, 54, 99, 32, 82, 95, 65, 82, 77, 95, 80,
/* 0x3240 */  67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32,117,110, 97,109,101,
/* 0x3250 */  10, 48, 48, 48, 48, 48, 51, 55, 48, 32, 82, 95, 65, 82, 77, 95,
/* 0x3260 */  80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 85, 77, 70, 95,
/* 0x3270 */  65, 78, 68, 82, 79, 73, 68, 10, 48, 48, 48, 48, 48, 51, 56, 52,
/* 0x3280 */  32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32,
/* 0x3290 */  32, 32, 32, 85, 77, 70, 95, 65, 78, 68, 82, 79, 73, 68, 10, 48,
/* 0x32a0 */  48, 48, 48, 48, 51, 56, 99, 32, 82, 95, 65, 82, 77, 95, 80, 67,
/* 0x32b0 */  50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 85, 77, 70, 95, 65, 78,
/* 0x32c0 */  68, 82, 79, 73, 68, 10, 48, 48, 48, 48, 48, 51, 57, 48, 32, 82,
/* 0x32d0 */  95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32,
/* 0x32e0 */  32, 85, 77, 70, 95, 65, 78, 68, 82, 79, 73, 68, 10, 48, 48, 48,
/* 0x32f0 */  48, 48, 51, 97, 52, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52,
/* 0x3300 */  32, 32, 32, 32, 32, 32, 32, 32, 85, 77, 70, 95, 65, 78, 68, 82,
/* 0x3310 */  79, 73, 68, 10, 48, 48, 48, 48, 48, 51, 97, 99, 32, 82, 95, 65,
/* 0x3320 */  82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 85,
/* 0x3330 */  77, 70, 95, 65, 78, 68, 82, 79, 73, 68, 10, 48, 48, 48, 48, 48,
/* 0x3340 */  51, 98, 99, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32,
/* 0x3350 */  32, 32, 32, 32, 32, 32, 85, 77, 70, 95, 65, 78, 68, 82, 79, 73,
/* 0x3360 */  68, 10, 48, 48, 48, 48, 48, 51, 99, 52, 32, 82, 95, 65, 82, 77,
/* 0x3370 */  95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 85, 77, 70,
/* 0x3380 */  95, 65, 78, 68, 82, 79, 73, 68, 10, 48, 48, 48, 48, 48, 51, 99,
/* 0x3390 */  56, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32,
/* 0x33a0 */  32, 32, 32, 32,103,101,116, 95,117,112,120,102,110, 95,112, 97,
/* 0x33b0 */ 116,104, 10, 48, 48, 48, 48, 48, 51,101, 56, 32, 82, 95, 65, 82,
/* 0x33c0 */  77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 85, 77,
/* 0x33d0 */  70, 95, 65, 78, 68, 82, 79, 73, 68, 10, 48, 48, 48, 48, 48, 51,
/* 0x33e0 */ 102, 48, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32,
/* 0x33f0 */  32, 32, 32, 32, 32, 85, 77, 70, 95, 65, 78, 68, 82, 79, 73, 68,
/* 0x3400 */  10, 48, 48, 48, 48, 48, 51,102, 99, 32, 82, 95, 65, 82, 77, 95,
/* 0x3410 */  80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 85, 77, 70, 95,
/* 0x3420 */  65, 78, 68, 82, 79, 73, 68, 10, 48, 48, 48, 48, 48, 52, 48, 99,
/* 0x3430 */  32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32,
/* 0x3440 */  32, 32, 32, 85, 77, 70, 95, 65, 78, 68, 82, 79, 73, 68, 10, 48,
/* 0x3450 */  48, 48, 48, 48, 52, 49, 52, 32, 82, 95, 65, 82, 77, 95, 80, 67,
/* 0x3460 */  50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 85, 77, 70, 95, 65, 78,
/* 0x3470 */  68, 82, 79, 73, 68, 10, 48, 48, 48, 48, 48, 52, 50, 52, 32, 82,
/* 0x3480 */  95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32,
/* 0x3490 */  32,111,112,101,110, 10, 48, 48, 48, 48, 48, 52, 51, 48, 32, 82,
/* 0x34a0 */  95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32,
/* 0x34b0 */  32, 85, 77, 70, 95, 65, 78, 68, 82, 79, 73, 68, 10, 48, 48, 48,
/* 0x34c0 */  48, 48, 52, 51, 56, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52,
/* 0x34d0 */  32, 32, 32, 32, 32, 32, 32, 32,117,110,108,105,110,107, 10, 48,
/* 0x34e0 */  48, 48, 48, 48, 52, 52, 48, 32, 82, 95, 65, 82, 77, 95, 80, 67,
/* 0x34f0 */  50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 85, 77, 70, 95, 65, 78,
/* 0x3500 */  68, 82, 79, 73, 68, 10, 48, 48, 48, 48, 48, 52, 52, 99, 32, 82,
/* 0x3510 */  95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32,
/* 0x3520 */  32, 85, 77, 70, 95, 65, 78, 68, 82, 79, 73, 68, 10, 48, 48, 48,
/* 0x3530 */  48, 48, 52, 53, 48, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52,
/* 0x3540 */  32, 32, 32, 32, 32, 32, 32, 32,103,101,116, 95,112, 97,103,101,
/* 0x3550 */  95,109, 97,115,107, 10, 48, 48, 48, 48, 48, 52, 54, 56, 32, 82,
/* 0x3560 */  95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32,
/* 0x3570 */  32, 85, 77, 70, 95, 65, 78, 68, 82, 79, 73, 68, 10, 48, 48, 48,
/* 0x3580 */  48, 48, 52, 55, 48, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52,
/* 0x3590 */  32, 32, 32, 32, 32, 32, 32, 32, 85, 77, 70, 95, 65, 78, 68, 82,
/* 0x35a0 */  79, 73, 68, 10, 48, 48, 48, 48, 48, 52, 55, 99, 32, 82, 95, 65,
/* 0x35b0 */  82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32,102,
/* 0x35c0 */ 116,114,117,110, 99, 97,116,101, 10, 48, 48, 48, 48, 48, 52, 56,
/* 0x35d0 */  52, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32,
/* 0x35e0 */  32, 32, 32, 32, 85, 77, 70, 95, 65, 78, 68, 82, 79, 73, 68, 10,
/* 0x35f0 */  48, 48, 48, 48, 48, 52, 56, 56, 32, 82, 95, 65, 82, 77, 95, 80,
/* 0x3600 */  67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 85, 77, 70, 95, 65,
/* 0x3610 */  78, 68, 82, 79, 73, 68, 10, 48, 48, 48, 48, 48, 52, 57, 56, 32,
/* 0x3620 */  82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32,
/* 0x3630 */  32, 32,108,115,101,101,107, 10, 48, 48, 48, 48, 48, 52, 98, 99,
/* 0x3640 */  32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32,
/* 0x3650 */  32, 32, 32,119,114,105,116,101, 10, 48, 48, 48, 48, 48, 52, 99,
/* 0x3660 */  99, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32,
/* 0x3670 */  32, 32, 32, 32,108,115,101,101,107, 10, 48, 48, 48, 48, 48, 52,
/* 0x3680 */ 100, 56, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32,
/* 0x3690 */  32, 32, 32, 32, 32, 85, 77, 70, 95, 65, 78, 68, 82, 79, 73, 68,
/* 0x36a0 */  10, 48, 48, 48, 48, 48, 52,100, 99, 32, 82, 95, 65, 82, 77, 95,
/* 0x36b0 */  80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32,103,101,116, 95,
/* 0x36c0 */ 112, 97,103,101, 95,109, 97,115,107, 10, 48, 48, 48, 48, 48, 52,
/* 0x36d0 */ 101, 56, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32,
/* 0x36e0 */  32, 32, 32, 32, 32, 85, 77, 70, 95, 65, 78, 68, 82, 79, 73, 68,
/* 0x36f0 */  10, 48, 48, 48, 48, 48, 52,102, 56, 32, 82, 95, 65, 82, 77, 95,
/* 0x3700 */  80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32,119,114,105,116,
/* 0x3710 */ 101, 10, 48, 48, 48, 48, 48, 52,102, 99, 32, 82, 95, 65, 82, 77,
/* 0x3720 */  95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 85, 77, 70,
/* 0x3730 */  95, 65, 78, 68, 82, 79, 73, 68, 10, 48, 48, 48, 48, 48, 53, 49,
/* 0x3740 */  99, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32,
/* 0x3750 */  32, 32, 32, 32,109,109, 97,112, 10, 48, 48, 48, 48, 48, 53, 50,
/* 0x3760 */  99, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32,
/* 0x3770 */  32, 32, 32, 32, 85, 77, 70, 95, 65, 78, 68, 82, 79, 73, 68, 10,
/* 0x3780 */  48, 48, 48, 48, 48, 53, 51, 52, 32, 82, 95, 65, 82, 77, 95, 80,
/* 0x3790 */  67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 85, 77, 70, 95, 65,
/* 0x37a0 */  78, 68, 82, 79, 73, 68, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73,
/* 0x37b0 */  79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91,
/* 0x37c0 */  85, 77, 70, 95, 76, 73, 78, 85, 88, 93, 58, 10, 79, 70, 70, 83,
/* 0x37d0 */  69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32,
/* 0x37e0 */  32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48,
/* 0x37f0 */  48, 48, 48, 49, 48, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52,
/* 0x3800 */  32, 32, 32, 32, 32, 32, 32, 32, 85, 77, 70, 95, 76, 73, 78, 85,
/* 0x3810 */  88, 10, 48, 48, 48, 48, 48, 48, 50, 52, 32, 82, 95, 65, 82, 77,
/* 0x3820 */  95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32,109,101,109,
/* 0x3830 */ 102,100, 95, 99,114,101, 97,116,101, 10, 48, 48, 48, 48, 48, 48,
/* 0x3840 */  51, 48, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32,
/* 0x3850 */  32, 32, 32, 32, 32, 85, 77, 70, 95, 76, 73, 78, 85, 88, 10, 48,
/* 0x3860 */  48, 48, 48, 48, 48, 51, 99, 32, 82, 95, 65, 82, 77, 95, 80, 67,
/* 0x3870 */  50, 52, 32, 32, 32, 32, 32, 32, 32, 32,109,101,109,102,100, 95,
/* 0x3880 */  99,114,101, 97,116,101, 10, 48, 48, 48, 48, 48, 48, 52, 56, 32,
/* 0x3890 */  82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32,
/* 0x38a0 */  32, 32, 85, 77, 70, 95, 76, 73, 78, 85, 88, 10, 48, 48, 48, 48,
/* 0x38b0 */  48, 48, 52, 99, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32,
/* 0x38c0 */  32, 32, 32, 32, 32, 32, 32, 85, 77, 70, 95, 76, 73, 78, 85, 88,
/* 0x38d0 */  10, 48, 48, 48, 48, 48, 48, 55, 48, 32, 82, 95, 65, 82, 77, 95,
/* 0x38e0 */  80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32,111,112,101,110,
/* 0x38f0 */  10, 48, 48, 48, 48, 48, 48, 55, 56, 32, 82, 95, 65, 82, 77, 95,
/* 0x3900 */  80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 85, 77, 70, 95,
/* 0x3910 */  76, 73, 78, 85, 88, 10, 48, 48, 48, 48, 48, 48, 56, 52, 32, 82,
/* 0x3920 */  95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32,
/* 0x3930 */  32, 85, 77, 70, 95, 76, 73, 78, 85, 88, 10, 48, 48, 48, 48, 48,
/* 0x3940 */  48, 56, 56, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32,
/* 0x3950 */  32, 32, 32, 32, 32, 32, 85, 77, 70, 95, 76, 73, 78, 85, 88, 10,
/* 0x3960 */  48, 48, 48, 48, 48, 48,100, 56, 32, 82, 95, 65, 82, 77, 95, 80,
/* 0x3970 */  67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32,119,114,105,116,101,
/* 0x3980 */  10, 48, 48, 48, 48, 48, 48,101, 48, 32, 82, 95, 65, 82, 77, 95,
/* 0x3990 */  80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32,101,120,105,116,
/* 0x39a0 */  10, 48, 48, 48, 48, 48, 48,101, 99, 32, 82, 95, 65, 82, 77, 95,
/* 0x39b0 */  80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32,102,116,114,117,
/* 0x39c0 */ 110, 99, 97,116,101, 10, 48, 48, 48, 48, 48, 48,102, 56, 32, 82,
/* 0x39d0 */  95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32,
/* 0x39e0 */  32, 85, 77, 70, 95, 76, 73, 78, 85, 88, 10, 48, 48, 48, 48, 48,
/* 0x39f0 */  49, 50, 48, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32,
/* 0x3a00 */  32, 32, 32, 32, 32, 32,109,109, 97,112, 10, 48, 48, 48, 48, 48,
/* 0x3a10 */  49, 50, 56, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32,
/* 0x3a20 */  32, 32, 32, 32, 32, 32,103,101,116, 95,112, 97,103,101, 95,109,
/* 0x3a30 */  97,115,107, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32,
/* 0x3a40 */  82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 69, 76, 70,
/* 0x3a50 */  77, 65, 73, 78, 88, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32,
/* 0x3a60 */  32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x3a70 */  32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48,
/* 0x3a80 */  48, 32, 82, 95, 65, 82, 77, 95, 65, 66, 83, 51, 50, 32, 32, 32,
/* 0x3a90 */  32, 32, 32, 32, 77, 70, 76, 71, 10, 48, 48, 48, 48, 48, 48, 49,
/* 0x3aa0 */  52, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32,
/* 0x3ab0 */  32, 32, 32, 32, 69, 76, 70, 77, 65, 73, 78, 88, 10, 10, 82, 69,
/* 0x3ac0 */  76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83,
/* 0x3ad0 */  32, 70, 79, 82, 32, 91, 69, 76, 70, 77, 65, 73, 78, 90, 93, 58,
/* 0x3ae0 */  10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32,
/* 0x3af0 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85,
/* 0x3b00 */  69, 10, 48, 48, 48, 48, 48, 48, 48, 99, 32, 82, 95, 65, 82, 77,
/* 0x3b10 */  95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 69, 76, 70,
/* 0x3b20 */  77, 65, 73, 78, 90, 10, 48, 48, 48, 48, 48, 48, 50, 48, 32, 82,
/* 0x3b30 */  95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32,
/* 0x3b40 */  32, 69, 76, 70, 77, 65, 73, 78, 90, 10, 48, 48, 48, 48, 48, 48,
/* 0x3b50 */  51, 48, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32,
/* 0x3b60 */  32, 32, 32, 32, 32, 69, 76, 70, 77, 65, 73, 78, 90, 10, 48, 48,
/* 0x3b70 */  48, 48, 48, 48, 52, 48, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50,
/* 0x3b80 */  52, 32, 32, 32, 32, 32, 32, 32, 32, 69, 76, 70, 77, 65, 73, 78,
/* 0x3b90 */  90, 10, 48, 48, 48, 48, 48, 48, 53, 48, 32, 82, 95, 65, 82, 77,
/* 0x3ba0 */  95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 69, 76, 70,
/* 0x3bb0 */  77, 65, 73, 78, 90, 10, 48, 48, 48, 48, 48, 48, 54, 48, 32, 82,
/* 0x3bc0 */  95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32,
/* 0x3bd0 */  32, 69, 76, 70, 77, 65, 73, 78, 90, 10, 48, 48, 48, 48, 48, 50,
/* 0x3be0 */  49, 52, 32, 82, 95, 65, 82, 77, 95, 65, 66, 83, 51, 50, 32, 32,
/* 0x3bf0 */  32, 32, 32, 32, 32, 79, 95, 66, 73, 78, 70, 79, 10
};
