/* amd64-linux.elf-so_fold.h
   created from amd64-linux.elf-so_fold.bin, 21708 (0x54cc) bytes

   This file is part of the UPX executable compressor.

   Copyright (C) 1996-2025 Markus Franz Xaver Johannes Oberhumer
   Copyright (C) 1996-2025 Laszlo Molnar
   Copyright (C) 2000-2025 John F. Reiser
   All Rights Reserved.

   UPX and the UCL library are free software; you can redistribute them
   and/or modify them under the terms of the GNU General Public License as
   published by the Free Software Foundation; either version 2 of
   the License, or (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; see the file COPYING.
   If not, write to the Free Software Foundation, Inc.,
   59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

   Markus F.X.J. Oberhumer              Laszlo Molnar
   <markus@oberhumer.com>               <ezerotven+github@gmail.com>

   John F. Reiser
   <jreiser@users.sourceforge.net>
 */

/* clang-format off */

#define STUB_AMD64_LINUX_ELF_SO_FOLD_SIZE    21708
#define STUB_AMD64_LINUX_ELF_SO_FOLD_ADLER32 0x3c439f54
#define STUB_AMD64_LINUX_ELF_SO_FOLD_CRC32   0x7e1dfa07

unsigned char stub_amd64_linux_elf_so_fold[21708] = {
/* 0x0000 */ 127, 69, 76, 70,  2,  1,  1,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0010 */   1,  0, 62,  0,  1,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0020 */   0,  0,  0,  0,  0,  0,  0,  0,168, 35,  0,  0,  0,  0,  0,  0,
/* 0x0030 */   0,  0,  0,  0, 64,  0,  0,  0,  0,  0, 64,  0, 33,  0, 30,  0,
/* 0x0040 */ 233,  0,  0,  0,  0,233,  0,  0,  0,  0,  0,  0, 72,137, 92, 36,
/* 0x0050 */ 224, 72,137,108, 36,232, 76,137,100, 36,240, 76,137,108, 36,248,
/* 0x0060 */  72,131,236, 40, 73,137,252, 65,137,245, 72,141, 45,  0,  0,  0,
/* 0x0070 */   0,190, 16,  0,  0,  0, 72,137,239,232,  0,  0,  0,  0,137,195,
/* 0x0080 */ 131,248,234,117, 15,190,  0,  0,  0,  0, 72,137,239,232,  0,  0,
/* 0x0090 */   0,  0,137,195,133,219,121, 68, 72,141, 61,  0,  0,  0,  0,186,
/* 0x00a0 */ 192,  1,  0,  0,190,  2,  0, 65,  0,232,  0,  0,  0,  0,137,195,
/* 0x00b0 */ 133,192,121, 40, 72, 99,208,131,248,235,117,109, 72,141, 53,  0,
/* 0x00c0 */   0,  0,  0,186, 61,  0,  0,  0,191,  2,  0,  0,  0,232,  0,  0,
/* 0x00d0 */   0,  0,191,127,  0,  0,  0,232,  0,  0,  0,  0, 68,137,238,137,
/* 0x00e0 */ 223,232,  0,  0,  0,  0, 72, 99,208,133,192,120, 60, 73,131,252,
/* 0x00f0 */   1, 25,201,131,225,240,131,193, 17, 68,137,238, 65,185,  0,  0,
/* 0x0100 */   0,  0, 65,137,216,186,  3,  0,  0,  0, 76,137,231,232,  0,  0,
/* 0x0110 */   0,  0, 73,137,196,232,  0,  0,  0,  0, 76,137,226, 73, 57,196,
/* 0x0120 */ 115,  7,141, 67,  1, 74,141, 20, 32, 72,137,208, 72,139, 92, 36,
/* 0x0130 */   8, 72,139,108, 36, 16, 76,139,100, 36, 24, 76,139,108, 36, 32,
/* 0x0140 */  72,131,196, 40,195,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0150 */  72,131,236,  8, 72, 99,255,184,  0,  0,  0,  0,232,  0,  0,  0,
/* 0x0160 */   0,191,127,  0,  0,  0,232,  0,  0,  0,  0, 65, 85, 65, 84, 85,
/* 0x0170 */  83, 72,131,236,  8, 73,137,252, 73,137,213, 72,139,111,  8, 72,
/* 0x0180 */ 137,243, 72, 57, 23,115, 10,191,  8,  0,  0,  0,232,191,255,255,
/* 0x0190 */ 255, 73,141, 85,255, 72,131,250,255,116, 21, 15,182, 69,  0,136,
/* 0x01a0 */   3, 72,255,197, 72,255,195, 72,255,202, 72,131,250,255,117,235,
/* 0x01b0 */  77,  1,108, 36,  8, 77, 41, 44, 36, 72,131,196,  8, 91, 93, 65,
/* 0x01c0 */  92, 65, 93,195, 85, 83, 72,131,236, 40, 72,137,253, 72,137,243,
/* 0x01d0 */  72,131, 62,  0, 15,132,243,  0,  0,  0,186, 12,  0,  0,  0, 72,
/* 0x01e0 */ 141,116, 36, 16, 72,137,239,232,127,255,255,255,131,124, 36, 16,
/* 0x01f0 */   0,117, 50,129,124, 36, 20, 85, 80, 88, 33,116, 10,191,  2,  0,
/* 0x0200 */   0,  0,232, 73,255,255,255, 72,131,125,  0,  0, 15,132,187,  0,
/* 0x0210 */   0,  0,191,  3,  0,  0,  0,232, 52,255,255,255,102,102,102,144,
/* 0x0220 */ 233,168,  0,  0,  0,131,124, 36, 20,  0,117, 10,191,  4,  0,  0,
/* 0x0230 */   0,232, 26,255,255,255,139, 68, 36, 20, 59, 68, 36, 16,119,  9,
/* 0x0240 */ 139, 68, 36, 16, 72, 59,  3,118, 10,191,  5,  0,  0,  0,232,253,
/* 0x0250 */ 254,255,255,139, 68, 36, 20, 59, 68, 36, 16,115, 70,139, 68, 36,
/* 0x0260 */  16, 72,137, 68, 36,  8, 72,139,115,  8, 72,139,125,  8, 72,131,
/* 0x0270 */ 239, 12, 72,141, 84, 36,  8,232,  0,  0,  0,  0,133,192,117, 11,
/* 0x0280 */ 139, 68, 36, 16, 72, 59, 68, 36,  8,116, 10,191,  7,  0,  0,  0,
/* 0x0290 */ 232,187,254,255,255,139, 68, 36, 20, 72,  1, 69,  8, 72, 41, 69,
/* 0x02a0 */   0,235, 21, 72,131, 69,  0, 12,139, 84, 36, 20, 72,139,115,  8,
/* 0x02b0 */  72,137,239,232,179,254,255,255,139, 68, 36, 16, 72,  1, 67,  8,
/* 0x02c0 */  72, 41,  3, 72,131, 59,  0, 15,133, 13,255,255,255, 72,131,196,
/* 0x02d0 */  40, 91, 93,195, 72,137, 92, 36,240, 76,137,100, 36,248, 72,131,
/* 0x02e0 */ 236, 40,137,209, 65,188,  0,  0,  0,  0,199,  4, 36, 15,  5, 95,
/* 0x02f0 */  94,199, 68, 36,  4, 90, 88, 62,255,199, 68, 36,  8,224,144,144,
/* 0x0300 */ 144, 72,184,255,255,255,255,  1,  0,  0,  0, 72, 35,  7, 72,186,
/* 0x0310 */   1,  0,  0,  0,  1,  0,  0,  0, 72, 57,208, 15,133,144,  0,  0,
/* 0x0320 */   0, 72,139, 71, 40, 72, 43, 71, 32, 72,  1,198,137,240,247,216,
/* 0x0330 */  33,193,131,249, 11,118, 25, 73,137,244,199,  6, 15,  5, 95, 94,
/* 0x0340 */ 139, 68, 36,  4,137, 70,  4,139, 68, 36,  8,137, 70,  8,235, 97,
/* 0x0350 */ 186,  0,  0,  0,  0,190, 12,  0,  0,  0,191,  0,  0,  0,  0,232,
/* 0x0360 */   0,  0,  0,  0, 73,137,196,137,195,129,227,255, 15,  0,  0,255,
/* 0x0370 */ 203, 72,137,230,186, 12,  0,  0,  0,137,223,232,  0,  0,  0,  0,
/* 0x0380 */  76,137,231, 72,129,231,  0,240,255,255, 65,185,  0,  0,  0,  0,
/* 0x0390 */  65,137,216,185,  2,  0,  0,  0,186,  5,  0,  0,  0,190, 12,  0,
/* 0x03a0 */   0,  0,232,  0,  0,  0,  0, 73,137,196,137,223,232,  0,  0,  0,
/* 0x03b0 */   0, 76,137,224, 72,139, 92, 36, 24, 76,139,100, 36, 32, 72,131,
/* 0x03c0 */ 196, 40,195, 72,137, 92, 36,224, 72,137,108, 36,232, 76,137,100,
/* 0x03d0 */  36,240, 76,137,108, 36,248, 72,129,236,168,  2,  0,  0, 73,199,
/* 0x03e0 */ 197,  0,240,255,255,232, 16,  0,  0,  0, 47,112,114,111, 99, 47,
/* 0x03f0 */ 115,101,108,102, 47, 97,117,120,118,  0, 94,185,  0,  0,  0,  0,
/* 0x0400 */ 186,  0,  0,  0,  0,191,  0,  0,  0,  0,232,  0,  0,  0,  0,137,
/* 0x0410 */ 197,133,192,120, 67, 73,137,228,186,128,  2,  0,  0, 72,137,230,
/* 0x0420 */ 137,199,232,  0,  0,  0,  0, 72,131,224,240, 73,  1,196,137,239,
/* 0x0430 */ 232,  0,  0,  0,  0, 72,137,224, 76, 57,228,115, 27, 72,131, 56,
/* 0x0440 */   6,117, 12, 72,139, 64,  8, 73,137,197, 73,247,221,235,  9, 72,
/* 0x0450 */ 131,192, 16, 76, 57,224,114,229, 76,137,232, 72,139,156, 36,136,
/* 0x0460 */   2,  0,  0, 72,139,172, 36,144,  2,  0,  0, 76,139,164, 36,152,
/* 0x0470 */   2,  0,  0, 76,139,172, 36,160,  2,  0,  0, 72,129,196,168,  2,
/* 0x0480 */   0,  0,195, 72,137, 92, 36,216, 72,137,108, 36,224, 76,137,100,
/* 0x0490 */  36,232, 76,137,108, 36,240, 76,137,116, 36,248, 72,129,236, 40,
/* 0x04a0 */  64,  0,  0, 65,137,254, 73,137,245,137,213,247,213, 33,245,116,
/* 0x04b0 */  70,137,235, 73, 41,221, 72,137,218, 76,137,238, 72,137,231,232,
/* 0x04c0 */   0,  0,  0,  0, 66,141,116, 53,  0, 65,185,  0,  0,  0,  0, 65,
/* 0x04d0 */ 184,255,255,255,255,185, 50,  0,  0,  0,186,  3,  0,  0,  0, 76,
/* 0x04e0 */ 137,239,232,  0,  0,  0,  0, 72,137,218, 72,137,230, 76,137,239,
/* 0x04f0 */ 232,  0,  0,  0,  0,235, 35, 66,141,116, 53,  0, 65,185,  0,  0,
/* 0x0500 */   0,  0, 65,184,255,255,255,255,185, 50,  0,  0,  0,186,  3,  0,
/* 0x0510 */   0,  0, 76,137,239,232,  0,  0,  0,  0, 72,139,156, 36,  0, 64,
/* 0x0520 */   0,  0, 72,139,172, 36,  8, 64,  0,  0, 76,139,164, 36, 16, 64,
/* 0x0530 */   0,  0, 76,139,172, 36, 24, 64,  0,  0, 76,139,180, 36, 32, 64,
/* 0x0540 */   0,  0, 72,129,196, 40, 64,  0,  0,195,232,  9,  0,  0,  0, 64,
/* 0x0550 */   4,  2,  6,  1,  5,  3,  7,  0, 90,139, 71,  4,131,224,  7, 15,
/* 0x0560 */ 190,  4,  2,131,224,  7,195, 72,137, 92, 36,224, 72,137,108, 36,
/* 0x0570 */ 232, 76,137,100, 36,240, 76,137,108, 36,248, 72,131,236, 40, 73,
/* 0x0580 */ 137,244, 72,137,213, 65,137,205, 76,137,195,246, 66,  4,  1,116,
/* 0x0590 */  74,137,251,186,  4,  0,  0,  0, 72,137,222, 76,137,231,232,  0,
/* 0x05a0 */   0,  0,  0, 72,137,222, 76,137,231,232,  0,  0,  0,  0, 72,137,
/* 0x05b0 */ 239,232,  0,  0,  0,  0, 65,185,  0,  0,  0,  0, 69,137,232,185,
/* 0x05c0 */  18,  0,  0,  0,137,194, 72,137,222, 76,137,231,232,  0,  0,  0,
/* 0x05d0 */   0, 68,137,239,232,  0,  0,  0,  0,235, 26, 72,137,215,232,  0,
/* 0x05e0 */   0,  0,  0, 72,139,117, 40, 72,137,223, 72,  3,125, 16,137,194,
/* 0x05f0 */ 232,  0,  0,  0,  0,184,  0,  0,  0,  0, 72,139, 92, 36,  8, 72,
/* 0x0600 */ 139,108, 36, 16, 76,139,100, 36, 24, 76,139,108, 36, 32, 72,131,
/* 0x0610 */ 196, 40,195, 72,137, 92, 36,224, 72,137,108, 36,232, 76,137,100,
/* 0x0620 */  36,240, 76,137,108, 36,248, 72,129,236, 40, 64,  0,  0,137,253,
/* 0x0630 */  73,137,244, 72,137,211, 72, 33,243, 65,137,245, 65, 41,221,116,
/* 0x0640 */  14, 68,137,234, 72,137,231, 72,137,222,232,  0,  0,  0,  0, 65,
/* 0x0650 */ 141,116, 45,  0,186,  0,  0,  0,  0, 72,137,223,232,  0,  0,  0,
/* 0x0660 */   0, 72,137,198,137,197,129,229,255, 15,  0,  0,137,232, 72, 41,
/* 0x0670 */ 198,255,205, 72, 57,222,116, 24, 69,137,232, 76,137,225, 72,137,
/* 0x0680 */ 218,191, 98, 18,  0,  0,184,  0,  0,  0,  0,232,  0,  0,  0,  0,
/* 0x0690 */  69,133,237,116, 13, 68,137,234, 72,137,230,137,239,232,  0,  0,
/* 0x06a0 */   0,  0,137,232, 72,139,156, 36,  8, 64,  0,  0, 72,139,172, 36,
/* 0x06b0 */  16, 64,  0,  0, 76,139,164, 36, 24, 64,  0,  0, 76,139,172, 36,
/* 0x06c0 */  32, 64,  0,  0, 72,129,196, 40, 64,  0,  0,195, 65, 87, 65, 86,
/* 0x06d0 */  65, 85, 65, 84, 85, 83, 72,129,236,136,  0,  0,  0, 72,137,251,
/* 0x06e0 */  73,137,247, 73,137,213,232,216,252,255,255, 72,137, 68, 36, 40,
/* 0x06f0 */ 139,  3, 72,137,218, 72, 41,194, 72,137, 84, 36, 32, 72,139,  3,
/* 0x0700 */  72,137, 68, 36,112, 72,139, 67,  8, 72,137, 68, 36,120,139, 68,
/* 0x0710 */  36,120,137, 68, 36, 28, 68,139, 99, 12, 73,  1,212,137,218, 68,
/* 0x0720 */  41,226,137, 84, 36, 24, 68,139,115,  4, 76,  3,116, 36, 32,137,
/* 0x0730 */ 211, 65,185,  0,  0,  0,  0, 65,184,255,255,255,255,185, 34,  0,
/* 0x0740 */   0,  0,186,  3,  0,  0,  0, 72,137,222,191,  0,  0,  0,  0,232,
/* 0x0750 */   0,  0,  0,  0, 72,137,197, 72,137,218, 76,137,230, 72,137,199,
/* 0x0760 */ 232,  0,  0,  0,  0, 72,141, 85, 24,139, 69, 24, 72,137, 68, 36,
/* 0x0770 */  80, 76,137,108, 36, 88, 72,137, 68, 36, 96, 76,137,108, 36,104,
/* 0x0780 */ 139, 66,  4, 72,131,192, 12, 72,137, 68, 36, 64, 72,137, 84, 36,
/* 0x0790 */  72, 72,137, 68, 36, 80, 72,137, 84, 36, 88, 72,141,116, 36, 96,
/* 0x07a0 */  72,141,124, 36, 80,232, 26,250,255,255, 77,141,101, 64, 77, 15,
/* 0x07b0 */ 183,109, 56, 74,141,  4,237,  0,  0,  0,  0, 76, 41,232, 77,141,
/* 0x07c0 */  44,196, 72,199, 68, 36, 16,  0,  0,  0,  0, 72,199, 68, 36,  8,
/* 0x07d0 */   0,  0,  0,  0,199, 68, 36,  4,  0,  0,  0,  0, 77, 57,236, 15,
/* 0x07e0 */ 131, 77,  1,  0,  0, 65,131, 60, 36,  1, 15,133, 53,  1,  0,  0,
/* 0x07f0 */  65,246, 68, 36,  4,  2, 15,133, 41,  1,  0,  0, 72,131,124, 36,
/* 0x0800 */   8,  0,117, 15, 72,139, 68, 36, 32, 73, 43, 68, 36, 16, 72,137,
/* 0x0810 */  68, 36,  8, 73,139, 92, 36, 16, 65,  3, 92, 36, 32, 72,199, 68,
/* 0x0820 */  36, 80, 12,  0,  0,  0,186, 12,  0,  0,  0, 72,141,116, 36, 64,
/* 0x0830 */  72,141,124, 36, 80,232, 49,249,255,255, 72,131,108, 36, 88, 12,
/* 0x0840 */ 139, 84, 36, 68, 72,137, 84, 36, 80,139, 68, 36, 64, 72,137, 68,
/* 0x0850 */  36, 96,137,219, 72,  3, 92, 36,  8, 72, 41,195, 72,137, 92, 36,
/* 0x0860 */ 104, 73,139, 68, 36, 32, 73,  3, 68, 36,  8,139, 84, 36, 28, 72,
/* 0x0870 */  57,208,119, 20,131,124, 36,  4,  0,117, 13,199, 68, 36,  4,  1,
/* 0x0880 */   0,  0,  0,233,157,  0,  0,  0,187,  0,  0,  0,  0, 65,246, 68,
/* 0x0890 */  36,  4,  1,116, 23, 72,139,116, 36,104, 72,139, 84, 36, 40,139,
/* 0x08a0 */ 124, 36, 96,232,  0,  0,  0,  0,137,195,235, 18, 72,139,116, 36,
/* 0x08b0 */ 104,139, 84, 36, 40,139,124, 36, 96,232,197,251,255,255, 72,139,
/* 0x08c0 */  68, 36, 96, 72,137, 68, 36, 48, 72,139, 68, 36,104, 72,137, 68,
/* 0x08d0 */  36, 56, 72,141,116, 36, 96, 72,141,124, 36, 80,232,227,248,255,
/* 0x08e0 */ 255, 72,131,124, 36, 16,  0,117, 56, 65,246, 68, 36,  4,  1,116,
/* 0x08f0 */  48, 72,139,116, 36,104,139, 84, 36, 40,247,210, 76,137,231,232,
/* 0x0900 */   0,  0,  0,  0, 72,137, 68, 36, 16, 72,139,116, 36, 56, 76,139,
/* 0x0910 */  68, 36,  8,137,217, 76,137,226,139,124, 36, 48,232,  0,  0,  0,
/* 0x0920 */   0,255, 68, 36,  4, 73,131,196, 56, 77, 57,236, 15,130,179,254,
/* 0x0930 */ 255,255,139,116, 36, 24, 72,137,239,232,  0,  0,  0,  0, 73,139,
/* 0x0940 */  87, 16, 73,139,119,  8, 73,139, 63, 65,255,214, 72,139, 68, 36,
/* 0x0950 */  16, 72,129,196,136,  0,  0,  0, 91, 93, 65, 92, 65, 93, 65, 94,
/* 0x0960 */  65, 95,195,  0,240,255,255,255,255,255,255,  0,  0,  0,  0,  0,
/* 0x0970 */   0,  0,  0, 91, 93, 95, 72,141,116, 36, 16, 72,129,236,  0,  4,
/* 0x0980 */   0,  0, 72,137,226,232,  0,  0,  0,  0, 72,129,196,  0,  4,  0,
/* 0x0990 */   0, 85, 94, 83, 95, 93, 91, 80,104, 11,  0,  0,  0, 88,195, 72,
/* 0x09a0 */ 139,  5,189,255,255,255,195, 89, 72,137,240, 72, 41,200, 90, 72,
/* 0x09b0 */  41,215, 89,137, 57, 91, 93,195,204,195, 87,137,240,137,209,243,
/* 0x09c0 */ 170, 88,195, 87,137,208,131,224,  7, 72,137,209, 72,193,233,  3,
/* 0x09d0 */ 243, 72,165,145,243,164, 88,195, 72,139,  5,  0,  0,  0,  0,247,
/* 0x09e0 */ 208, 33,248, 72, 41,199, 72,  1,198,106, 26,235, 19, 72,139,  5,
/* 0x09f0 */   0,  0,  0,  0,247,208, 33,248, 72, 41,199, 72,  1,198,106, 10,
/* 0x0a00 */ 235, 74, 72,137,248, 37,255, 15,  0,  0, 72, 41,199, 72,  1,198,
/* 0x0a10 */ 106,  9, 73,137,202, 88, 80, 15,  5, 72, 61,  0,240,255,255,114,
/* 0x0a20 */   1,204, 72,131,196,  8,195, 72,137,209, 72,137,242, 72,137,254,
/* 0x0a30 */  72,199,199,156,255,255,255,233,  0,  0,  0,  0, 72,137,248, 37,
/* 0x0a40 */ 255, 15,  0,  0, 72, 41,199, 72,  1,198,106, 11,235,199,106, 60,
/* 0x0a50 */ 235,  2,106, 77,235,  5,104, 63,  1,  0,  0,235,  2,106,  3,235,
/* 0x0a60 */   5,104,  1,  1,  0,  0,235,  2,106,  1,235,  2,106,  0,235,165,
/* 0x0a70 */  85, 72,137,229, 83, 82, 86, 87,232,101,  0,  0,  0, 91, 95, 94,
/* 0x0a80 */  80, 15,182, 75,  9,133,201,116, 11, 15,182, 83, 10,139, 54,232,
/* 0x0a90 */   4,  0,  0,  0, 88, 91, 93,195,131,249, 73,117, 68, 83, 87, 72,
/* 0x0aa0 */ 141, 76, 55,253, 94, 86, 91,235, 47, 72, 57,206,115, 50, 86, 94,
/* 0x0ab0 */ 172, 60,128,114, 10, 60,143,119,  6,128,126,254, 15,116,  6, 44,
/* 0x0ac0 */ 232, 60,  1,119,228, 72, 57,206,115, 22, 86,173, 40,208,117,223,
/* 0x0ad0 */  95, 15,200, 41,248,  1,216,171, 72, 57,206,115,  3,172,235,223,
/* 0x0ae0 */  91,195, 82, 68, 15,182, 71,  8, 87, 86, 95, 94,139, 70,  4, 72,
/* 0x0af0 */ 131,198, 12, 72,  1,240, 80, 87, 49,219, 49,201, 72,131,205,255,
/* 0x0b00 */ 235, 86,139, 30, 72,131,238,252, 17,219, 15,182, 22,243,195,243,
/* 0x0b10 */  15, 30,250,  1,219,116,235,243,195, 72,141,  4, 47,131,249,  5,
/* 0x0b20 */  15,182, 16,118, 33,131,253,252,119, 28,131,233,  4,139, 16, 72,
/* 0x0b30 */ 131,192,  4,131,233,  4,137, 23, 72,141,127,  4,115,239,131,193,
/* 0x0b40 */   4, 15,182, 16,116, 16, 72,255,192,136, 23,255,201, 15,182, 16,
/* 0x0b50 */  72,141,127,  1,117,240,243,195,252, 65,131,248,  8, 15,133,222,
/* 0x0b60 */   0,  0,  0,235,  8, 72,255,198,136, 23, 72,255,199, 15,182, 22,
/* 0x0b70 */   1,219,117, 11,139, 30, 72,131,238,252, 17,219, 15,182, 22,114,
/* 0x0b80 */ 228,141, 65,  1,235, 19,255,200,  1,219,117, 11,139, 30, 72,131,
/* 0x0b90 */ 238,252, 17,219, 15,182, 22, 17,192,  1,219,117, 11,139, 30, 72,
/* 0x0ba0 */ 131,238,252, 17,219, 15,182, 22, 17,192,  1,219,117, 11,139, 30,
/* 0x0bb0 */  72,131,238,252, 17,219, 15,182, 22,115,203,131,232,  3,114, 26,
/* 0x0bc0 */ 193,224,  8, 72,255,198,  9,208,131,240,255, 15,132,  0,  0,  0,
/* 0x0bd0 */   0,209,248, 72, 99,232,114, 68,235, 14,  1,219,117,  8,139, 30,
/* 0x0be0 */  72,131,238,252, 17,219,114, 52,255,193,  1,219,117,  8,139, 30,
/* 0x0bf0 */  72,131,238,252, 17,219,114, 36,  1,219,117, 11,139, 30, 72,131,
/* 0x0c00 */ 238,252, 17,219, 15,182, 22, 17,201,  1,219,117,  8,139, 30, 72,
/* 0x0c10 */ 131,238,252, 17,219,115,225,131,193,  2,235, 17,  1,219,117, 11,
/* 0x0c20 */ 139, 30, 72,131,238,252, 17,219, 15,182, 22, 17,201, 72,129,253,
/* 0x0c30 */   0,251,255,255,131,209,  2,232,  0,  0,  0,  0,233, 44,255,255,
/* 0x0c40 */ 255, 65,131,248,  5, 15,133,209,  0,  0,  0,235,  8, 72,255,198,
/* 0x0c50 */ 136, 23, 72,255,199, 15,182, 22,  1,219,117, 11,139, 30, 72,131,
/* 0x0c60 */ 238,252, 17,219, 15,182, 22,114,228,141, 65,  1,235, 19,255,200,
/* 0x0c70 */   1,219,117, 11,139, 30, 72,131,238,252, 17,219, 15,182, 22, 17,
/* 0x0c80 */ 192,  1,219,117, 11,139, 30, 72,131,238,252, 17,219, 15,182, 22,
/* 0x0c90 */  17,192,  1,219,117, 11,139, 30, 72,131,238,252, 17,219, 15,182,
/* 0x0ca0 */  22,115,203,131,232,  3,114, 24,193,224,  8, 72,255,198,  9,208,
/* 0x0cb0 */ 131,240,255, 15,132,  0,  0,  0,  0,209,248, 72, 99,232,235, 15,
/* 0x0cc0 */   1,219,117, 11,139, 30, 72,131,238,252, 17,219, 15,182, 22, 17,
/* 0x0cd0 */ 201,  1,219,117, 11,139, 30, 72,131,238,252, 17,219, 15,182, 22,
/* 0x0ce0 */  17,201,117, 36,255,193,  1,219,117, 11,139, 30, 72,131,238,252,
/* 0x0cf0 */  17,219, 15,182, 22, 17,201,  1,219,117,  8,139, 30, 72,131,238,
/* 0x0d00 */ 252, 17,219,115,225,131,193,  2, 72,129,253,  0,251,255,255,131,
/* 0x0d10 */ 209,  1,232,  0,  0,  0,  0,233, 57,255,255,255, 65,131,248,  2,
/* 0x0d20 */  15,133,186,  0,  0,  0,235,  8, 72,255,198,136, 23, 72,255,199,
/* 0x0d30 */  15,182, 22,  1,219,117, 11,139, 30, 72,131,238,252, 17,219, 15,
/* 0x0d40 */ 182, 22,114,228,141, 65,  1,  1,219,117, 11,139, 30, 72,131,238,
/* 0x0d50 */ 252, 17,219, 15,182, 22, 17,192,  1,219,117, 11,139, 30, 72,131,
/* 0x0d60 */ 238,252, 17,219, 15,182, 22,115,222,131,232,  3,114, 20,193,224,
/* 0x0d70 */   8, 72,255,198,  9,208,131,240,255, 15,132,  0,  0,  0,  0, 72,
/* 0x0d80 */  99,232,141, 65,  1,  1,219,117, 11,139, 30, 72,131,238,252, 17,
/* 0x0d90 */ 219, 15,182, 22, 17,201,  1,219,117, 11,139, 30, 72,131,238,252,
/* 0x0da0 */  17,219, 15,182, 22, 17,201,117, 36,137,193,131,192,  2,  1,219,
/* 0x0db0 */ 117, 11,139, 30, 72,131,238,252, 17,219, 15,182, 22, 17,201,  1,
/* 0x0dc0 */ 219,117,  8,139, 30, 72,131,238,252, 17,219,115,225, 72,129,253,
/* 0x0dd0 */   0,243,255,255, 17,193,232,  0,  0,  0,  0,233, 80,255,255,255,
/* 0x0de0 */  65,131,248, 14, 15,133,  0,  0,  0,  0, 87, 86,139,118,248, 72,
/* 0x0df0 */ 137,209, 95, 90, 85, 72,137,229, 68,139,  9, 73,137,208, 72,137,
/* 0x0e00 */ 242, 72,141,119,  2, 86,138,  7,255,202,136,193, 36,  7,192,233,
/* 0x0e10 */   3, 72,199,195,  0,253,255,255, 72,211,227,136,193, 72,141,156,
/* 0x0e20 */  92,136,241,255,255, 72,131,227,192,106,  0, 72, 57,220,117,249,
/* 0x0e30 */  83, 72,141,123,  8,138, 78,255,255,202,136, 71,  2,136,200,192,
/* 0x0e40 */ 233,  4,136, 79,  1, 36, 15,136,  7, 72,141, 79,252,106, 90, 65,
/* 0x0e50 */  87, 72,141, 71,  4, 69, 49,255, 65, 86, 65,190,  1,  0,  0,  0,
/* 0x0e60 */  65, 85, 69, 49,237, 65, 84, 85, 83, 72,137, 76, 36,240, 72,137,
/* 0x0e70 */  68, 36,216,184,  1,  0,  0,  0, 72,137,116, 36,248, 76,137, 68,
/* 0x0e80 */  36,232,137,195, 68,137, 76, 36,228, 15,182, 79,  2,211,227,137,
/* 0x0e90 */ 217, 72,139, 92, 36, 56,255,201,137, 76, 36,212, 15,182, 79,  1,
/* 0x0ea0 */ 211,224, 72,139, 76, 36,240,255,200,137, 68, 36,208, 15,182,  7,
/* 0x0eb0 */ 199,  1,  0,  0,  0,  0,199, 68, 36,200,  0,  0,  0,  0,199, 68,
/* 0x0ec0 */  36,196,  1,  0,  0,  0,199, 68, 36,192,  1,  0,  0,  0,199, 68,
/* 0x0ed0 */  36,188,  1,  0,  0,  0,199,  3,  0,  0,  0,  0,137, 68, 36,204,
/* 0x0ee0 */  15,182, 79,  1,  1,193,184,  0,  3,  0,  0,211,224, 49,201,141,
/* 0x0ef0 */ 184, 54,  7,  0,  0, 65, 57,255,115, 19, 72,139, 92, 36,216,137,
/* 0x0f00 */ 200,255,193, 57,249,102,199,  4, 67,  0,  4,235,235, 72,139,124,
/* 0x0f10 */  36,248,137,208, 69, 49,210, 65,131,203,255, 49,210, 73,137,252,
/* 0x0f20 */  73,  1,196, 76, 57,231, 15,132,239,  8,  0,  0, 15,182,  7, 65,
/* 0x0f30 */ 193,226,  8,255,194, 72,255,199, 65,  9,194,131,250,  4,126,227,
/* 0x0f40 */  68, 59,124, 36,228, 15,131,218,  8,  0,  0,139, 68, 36,212, 72,
/* 0x0f50 */  99, 92, 36,200, 72,139, 84, 36,216, 68, 33,248,137, 68, 36,184,
/* 0x0f60 */  72, 99,108, 36,184, 72,137,216, 72,193,224,  4, 72,  1,232, 65,
/* 0x0f70 */ 129,251,255,255,255,  0, 76,141, 12, 66,119, 26, 76, 57,231, 15,
/* 0x0f80 */ 132,150,  8,  0,  0, 15,182,  7, 65,193,226,  8, 65,193,227,  8,
/* 0x0f90 */  72,255,199, 65,  9,194, 65, 15,183, 17, 68,137,216,193,232, 11,
/* 0x0fa0 */  15,183,202, 15,175,193, 65, 57,194, 15,131,197,  1,  0,  0, 65,
/* 0x0fb0 */ 137,195,184,  0,  8,  0,  0, 72,139, 92, 36,216, 41,200, 15,182,
/* 0x0fc0 */  76, 36,204,190,  1,  0,  0,  0,193,248,  5,141,  4,  2, 65, 15,
/* 0x0fd0 */ 182,213,102, 65,137,  1,139, 68, 36,208, 68, 33,248,211,224,185,
/* 0x0fe0 */   8,  0,  0,  0, 43, 76, 36,204,211,250,  1,208,105,192,  0,  3,
/* 0x0ff0 */   0,  0,131,124, 36,200,  6,137,192, 76,141,140, 67,108, 14,  0,
/* 0x1000 */   0, 15,142,184,  0,  0,  0, 72,139, 84, 36,232, 68,137,248, 68,
/* 0x1010 */  41,240, 15,182, 44,  2,  1,237, 72, 99,214,137,235,129,227,  0,
/* 0x1020 */   1,  0,  0, 65,129,251,255,255,255,  0, 72, 99,195, 73,141,  4,
/* 0x1030 */  65, 76,141,  4, 80,119, 26, 76, 57,231, 15,132,219,  7,  0,  0,
/* 0x1040 */  15,182,  7, 65,193,226,  8, 65,193,227,  8, 72,255,199, 65,  9,
/* 0x1050 */ 194, 65, 15,183,144,  0,  2,  0,  0, 68,137,216,193,232, 11, 15,
/* 0x1060 */ 183,202, 15,175,193, 65, 57,194,115, 32, 65,137,195,184,  0,  8,
/* 0x1070 */   0,  0,  1,246, 41,200,193,248,  5,133,219,141,  4,  2,102, 65,
/* 0x1080 */ 137,128,  0,  2,  0,  0,116, 33,235, 45, 65, 41,195, 65, 41,194,
/* 0x1090 */ 137,208,102,193,232,  5,141,116, 54,  1,102, 41,194,133,219,102,
/* 0x10a0 */  65,137,144,  0,  2,  0,  0,116, 14,129,254,255,  0,  0,  0, 15,
/* 0x10b0 */ 142, 97,255,255,255,235,120,129,254,255,  0,  0,  0,127,112, 72,
/* 0x10c0 */  99,198, 65,129,251,255,255,255,  0, 77,141,  4, 65,119, 26, 76,
/* 0x10d0 */  57,231, 15,132, 67,  7,  0,  0, 15,182,  7, 65,193,226,  8, 65,
/* 0x10e0 */ 193,227,  8, 72,255,199, 65,  9,194, 65, 15,183, 16, 68,137,216,
/* 0x10f0 */ 193,232, 11, 15,183,202, 15,175,193, 65, 57,194,115, 24, 65,137,
/* 0x1100 */ 195,184,  0,  8,  0,  0,  1,246, 41,200,193,248,  5,141,  4,  2,
/* 0x1110 */ 102, 65,137,  0,235,161, 65, 41,195, 65, 41,194,137,208,102,193,
/* 0x1120 */ 232,  5,141,116, 54,  1,102, 41,194,102, 65,137, 16,235,136, 72,
/* 0x1130 */ 139, 76, 36,232, 68,137,248, 65,255,199, 65,137,245, 64,136, 52,
/* 0x1140 */   1,131,124, 36,200,  3,127, 13,199, 68, 36,200,  0,  0,  0,  0,
/* 0x1150 */ 233,166,  6,  0,  0,139, 84, 36,200,139, 68, 36,200,131,234,  3,
/* 0x1160 */ 131,232,  6,131,124, 36,200,  9, 15, 79,208,137, 84, 36,200,233,
/* 0x1170 */ 135,  6,  0,  0, 65, 41,195, 65, 41,194,137,208,102,193,232,  5,
/* 0x1180 */ 102, 41,194, 72,139, 68, 36,216, 65,129,251,255,255,255,  0,102,
/* 0x1190 */  65,137, 17, 72,141, 52, 88,119, 26, 76, 57,231, 15,132,121,  6,
/* 0x11a0 */   0,  0, 15,182,  7, 65,193,226,  8, 65,193,227,  8, 72,255,199,
/* 0x11b0 */  65,  9,194, 15,183,150,128,  1,  0,  0, 68,137,216,193,232, 11,
/* 0x11c0 */  15,183,202, 15,175,193, 65, 57,194,115, 78, 65,137,195,184,  0,
/* 0x11d0 */   8,  0,  0, 76,139, 76, 36,216, 41,200,139, 76, 36,196, 68,137,
/* 0x11e0 */ 116, 36,196,193,248,  5,141,  4,  2,139, 84, 36,192,137, 76, 36,
/* 0x11f0 */ 192,102,137,134,128,  1,  0,  0, 49,192,131,124, 36,200,  6,137,
/* 0x1200 */  84, 36,188, 15,159,192, 73,129,193,100,  6,  0,  0,141,  4, 64,
/* 0x1210 */ 137, 68, 36,200,233, 84,  2,  0,  0, 65, 41,195, 65, 41,194,137,
/* 0x1220 */ 208,102,193,232,  5,102, 41,194, 65,129,251,255,255,255,  0,102,
/* 0x1230 */ 137,150,128,  1,  0,  0,119, 26, 76, 57,231, 15,132,218,  5,  0,
/* 0x1240 */   0, 15,182,  7, 65,193,226,  8, 65,193,227,  8, 72,255,199, 65,
/* 0x1250 */   9,194, 15,183,150,152,  1,  0,  0, 68,137,216,193,232, 11, 15,
/* 0x1260 */ 183,202, 15,175,193, 65, 57,194, 15,131,208,  0,  0,  0, 65,184,
/* 0x1270 */   0,  8,  0,  0, 65,137,195, 72,193,227,  5, 68,137,192, 41,200,
/* 0x1280 */ 193,248,  5,141,  4,  2,102,137,134,152,  1,  0,  0, 72,139, 68,
/* 0x1290 */  36,216, 72,  1,216, 65,129,251,255,255,255,  0, 72,141, 52,104,
/* 0x12a0 */ 119, 26, 76, 57,231, 15,132,112,  5,  0,  0, 15,182,  7, 65,193,
/* 0x12b0 */ 226,  8, 65,193,227,  8, 72,255,199, 65,  9,194, 15,183,150,224,
/* 0x12c0 */   1,  0,  0, 68,137,216,193,232, 11, 15,183,202, 15,175,193, 65,
/* 0x12d0 */  57,194,115, 79, 65, 41,200, 65,137,195, 65,193,248,  5, 69,133,
/* 0x12e0 */ 255, 66,141,  4,  2,102,137,134,224,  1,  0,  0, 15,132, 41,  5,
/* 0x12f0 */   0,  0, 49,192,131,124, 36,200,  6, 72,139, 92, 36,232, 15,159,
/* 0x1300 */ 192,141, 68,  0,  9,137, 68, 36,200, 68,137,248, 68, 41,240, 68,
/* 0x1310 */  15,182, 44,  3, 68,137,248, 65,255,199, 68,136, 44,  3,233,216,
/* 0x1320 */   4,  0,  0, 65, 41,195, 65, 41,194,137,208,102,193,232,  5,102,
/* 0x1330 */  41,194,102,137,150,224,  1,  0,  0,233, 17,  1,  0,  0, 65, 41,
/* 0x1340 */ 195, 65, 41,194,137,208,102,193,232,  5,102, 41,194, 65,129,251,
/* 0x1350 */ 255,255,255,  0,102,137,150,152,  1,  0,  0,119, 26, 76, 57,231,
/* 0x1360 */  15,132,181,  4,  0,  0, 15,182,  7, 65,193,226,  8, 65,193,227,
/* 0x1370 */   8, 72,255,199, 65,  9,194, 15,183,150,176,  1,  0,  0, 68,137,
/* 0x1380 */ 216,193,232, 11, 15,183,202, 15,175,193, 65, 57,194,115, 32, 65,
/* 0x1390 */ 137,195,184,  0,  8,  0,  0, 41,200,193,248,  5,141,  4,  2,102,
/* 0x13a0 */ 137,134,176,  1,  0,  0,139, 68, 36,196,233,152,  0,  0,  0, 65,
/* 0x13b0 */  41,195, 65, 41,194,137,208,102,193,232,  5,102, 41,194, 65,129,
/* 0x13c0 */ 251,255,255,255,  0,102,137,150,176,  1,  0,  0,119, 26, 76, 57,
/* 0x13d0 */ 231, 15,132, 68,  4,  0,  0, 15,182,  7, 65,193,226,  8, 65,193,
/* 0x13e0 */ 227,  8, 72,255,199, 65,  9,194, 15,183,150,200,  1,  0,  0, 68,
/* 0x13f0 */ 137,216,193,232, 11, 15,183,202, 15,175,193, 65, 57,194,115, 29,
/* 0x1400 */  65,137,195,184,  0,  8,  0,  0, 41,200,193,248,  5,141,  4,  2,
/* 0x1410 */ 102,137,134,200,  1,  0,  0,139, 68, 36,192,235, 34, 65, 41,195,
/* 0x1420 */  65, 41,194,137,208,102,193,232,  5,102, 41,194,139, 68, 36,188,
/* 0x1430 */ 102,137,150,200,  1,  0,  0,139, 84, 36,192,137, 84, 36,188,139,
/* 0x1440 */  76, 36,196,137, 76, 36,192, 68,137,116, 36,196, 65,137,198, 49,
/* 0x1450 */ 192,131,124, 36,200,  6, 76,139, 76, 36,216, 15,159,192, 73,129,
/* 0x1460 */ 193,104, 10,  0,  0,141, 68, 64,  8,137, 68, 36,200, 65,129,251,
/* 0x1470 */ 255,255,255,  0,119, 26, 76, 57,231, 15,132,156,  3,  0,  0, 15,
/* 0x1480 */ 182,  7, 65,193,226,  8, 65,193,227,  8, 72,255,199, 65,  9,194,
/* 0x1490 */  65, 15,183, 17, 68,137,216,193,232, 11, 15,183,202, 15,175,193,
/* 0x14a0 */  65, 57,194,115, 39, 65,137,195,184,  0,  8,  0,  0, 69, 49,237,
/* 0x14b0 */  41,200,193,248,  5,141,  4,  2,102, 65,137,  1, 72, 99, 68, 36,
/* 0x14c0 */ 184, 72,193,224,  4, 77,141, 68,  1,  4,235,120, 65, 41,195, 65,
/* 0x14d0 */  41,194,137,208,102,193,232,  5,102, 41,194, 65,129,251,255,255,
/* 0x14e0 */ 255,  0,102, 65,137, 17,119, 26, 76, 57,231, 15,132, 42,  3,  0,
/* 0x14f0 */   0, 15,182,  7, 65,193,226,  8, 65,193,227,  8, 72,255,199, 65,
/* 0x1500 */   9,194, 65, 15,183, 81,  2, 68,137,216,193,232, 11, 15,183,202,
/* 0x1510 */  15,175,193, 65, 57,194,115, 52, 65,137,195,184,  0,  8,  0,  0,
/* 0x1520 */  65,189,  8,  0,  0,  0, 41,200,193,248,  5,141,  4,  2,102, 65,
/* 0x1530 */ 137, 65,  2, 72, 99, 68, 36,184, 72,193,224,  4, 77,141,132,  1,
/* 0x1540 */   4,  1,  0,  0, 65,185,  3,  0,  0,  0,235, 39, 65, 41,195, 65,
/* 0x1550 */  41,194,137,208,102,193,232,  5, 77,141,129,  4,  2,  0,  0, 65,
/* 0x1560 */ 189, 16,  0,  0,  0,102, 41,194,102, 65,137, 81,  2, 65,185,  8,
/* 0x1570 */   0,  0,  0, 68,137,203,189,  1,  0,  0,  0, 72, 99,197, 65,129,
/* 0x1580 */ 251,255,255,255,  0, 73,141, 52, 64,119, 26, 76, 57,231, 15,132,
/* 0x1590 */ 135,  2,  0,  0, 15,182,  7, 65,193,226,  8, 65,193,227,  8, 72,
/* 0x15a0 */ 255,199, 65,  9,194, 15,183, 14, 68,137,216,193,232, 11, 15,183,
/* 0x15b0 */ 209, 15,175,194, 65, 57,194,115, 23, 65,137,195,184,  0,  8,  0,
/* 0x15c0 */   0,  1,237, 41,208,193,248,  5,141,  4,  1,102,137,  6,235, 22,
/* 0x15d0 */  65, 41,195, 65, 41,194,137,200,102,193,232,  5,141,108, 45,  1,
/* 0x15e0 */ 102, 41,193,102,137, 14,255,203,117,145,184,  1,  0,  0,  0, 68,
/* 0x15f0 */ 137,201,211,224, 41,197, 68,  1,237,131,124, 36,200,  3, 15,143,
/* 0x1600 */ 194,  1,  0,  0,131, 68, 36,200,  7,184,  3,  0,  0,  0,131,253,
/* 0x1610 */   4, 15, 76,197, 72,139, 92, 36,216, 65,184,  1,  0,  0,  0, 72,
/* 0x1620 */ 152, 72,193,224,  7, 76,141,140,  3, 96,  3,  0,  0,187,  6,  0,
/* 0x1630 */   0,  0, 73, 99,192, 65,129,251,255,255,255,  0, 73,141, 52, 65,
/* 0x1640 */ 119, 26, 76, 57,231, 15,132,208,  1,  0,  0, 15,182,  7, 65,193,
/* 0x1650 */ 226,  8, 65,193,227,  8, 72,255,199, 65,  9,194, 15,183, 22, 68,
/* 0x1660 */ 137,216,193,232, 11, 15,183,202, 15,175,193, 65, 57,194,115, 24,
/* 0x1670 */  65,137,195,184,  0,  8,  0,  0, 69,  1,192, 41,200,193,248,  5,
/* 0x1680 */ 141,  4,  2,102,137,  6,235, 23, 65, 41,195, 65, 41,194,137,208,
/* 0x1690 */ 102,193,232,  5, 71,141, 68,  0,  1,102, 41,194,102,137, 22,255,
/* 0x16a0 */ 203,117,143, 65,131,232, 64, 65,131,248,  3, 69,137,198, 15,142,
/* 0x16b0 */  13,  1,  0,  0, 65,131,230,  1, 68,137,192,209,248, 65,131,206,
/* 0x16c0 */   2, 65,131,248, 13,141,112,255,127, 35,137,241, 72,139, 92, 36,
/* 0x16d0 */ 216, 73, 99,192, 65,211,230, 72,  1,192, 68,137,242, 72,141, 20,
/* 0x16e0 */  83, 72, 41,194, 76,141,138, 94,  5,  0,  0,235, 81,141,112,251,
/* 0x16f0 */  65,129,251,255,255,255,  0,119, 26, 76, 57,231, 15,132, 25,  1,
/* 0x1700 */   0,  0, 15,182,  7, 65,193,226,  8, 65,193,227,  8, 72,255,199,
/* 0x1710 */  65,  9,194, 65,209,235, 69,  1,246, 69, 57,218,114,  7, 69, 41,
/* 0x1720 */ 218, 65,131,206,  1,255,206,117,199, 76,139, 76, 36,216, 65,193,
/* 0x1730 */ 230,  4,190,  4,  0,  0,  0, 73,129,193, 68,  6,  0,  0, 65,189,
/* 0x1740 */   1,  0,  0,  0,187,  1,  0,  0,  0, 72, 99,195, 65,129,251,255,
/* 0x1750 */ 255,255,  0, 77,141,  4, 65,119, 26, 76, 57,231, 15,132,185,  0,
/* 0x1760 */   0,  0, 15,182,  7, 65,193,226,  8, 65,193,227,  8, 72,255,199,
/* 0x1770 */  65,  9,194, 65, 15,183, 16, 68,137,216,193,232, 11, 15,183,202,
/* 0x1780 */  15,175,193, 65, 57,194,115, 24, 65,137,195,184,  0,  8,  0,  0,
/* 0x1790 */   1,219, 41,200,193,248,  5,141,  4,  2,102, 65,137,  0,235, 26,
/* 0x17a0 */  65, 41,195, 65, 41,194,137,208,102,193,232,  5,141, 92, 27,  1,
/* 0x17b0 */  69,  9,238,102, 41,194,102, 65,137, 16, 69,  1,237,255,206,117,
/* 0x17c0 */ 136, 65,255,198,116, 64,131,197,  2, 69, 57,254,119, 77, 72,139,
/* 0x17d0 */  84, 36,232, 68,137,248, 68, 41,240, 68, 15,182, 44,  2, 68,137,
/* 0x17e0 */ 248, 65,255,199,255,205, 68,136, 44,  2, 15,149,194, 49,192, 68,
/* 0x17f0 */  59,124, 36,228, 15,146,192,133,194,117,211, 68, 59,124, 36,228,
/* 0x1800 */  15,130, 69,247,255,255, 65,129,251,255,255,255,  0,119, 22, 76,
/* 0x1810 */  57,231,184,  1,  0,  0,  0,116, 35,235,  7,184,  1,  0,  0,  0,
/* 0x1820 */ 235, 26, 72,255,199,137,248, 43, 68, 36,248, 72,139, 76, 36,240,
/* 0x1830 */  72,139, 92, 36, 56,137,  1, 68,137, 59, 49,192, 91, 93, 65, 92,
/* 0x1840 */  65, 93, 65, 94, 65, 95, 65, 87, 72,141, 71,  4, 69, 49,255, 65,
/* 0x1850 */  86, 65,190,  1,  0,  0,  0, 65, 85, 69, 49,237, 65, 84, 85, 83,
/* 0x1860 */  72,137, 76, 36,240, 72,137, 68, 36,216,184,  1,  0,  0,  0, 72,
/* 0x1870 */ 137,116, 36,248, 76,137, 68, 36,232,137,195, 68,137, 76, 36,228,
/* 0x1880 */  15,182, 79,  2,211,227,137,217, 72,139, 92, 36, 56,255,201,137,
/* 0x1890 */  76, 36,212, 15,182, 79,  1,211,224, 72,139, 76, 36,240,255,200,
/* 0x18a0 */ 137, 68, 36,208, 15,182,  7,199,  1,  0,  0,  0,  0,199, 68, 36,
/* 0x18b0 */ 200,  0,  0,  0,  0,199, 68, 36,196,  1,  0,  0,  0,199, 68, 36,
/* 0x18c0 */ 192,  1,  0,  0,  0,199, 68, 36,188,  1,  0,  0,  0,199,  3,  0,
/* 0x18d0 */   0,  0,  0,137, 68, 36,204, 15,182, 79,  1,  1,193,184,  0,  3,
/* 0x18e0 */   0,  0,211,224, 49,201,141,184, 54,  7,  0,  0, 65, 57,255,115,
/* 0x18f0 */  19, 72,139, 92, 36,216,137,200,255,193, 57,249,102,199,  4, 67,
/* 0x1900 */   0,  4,235,235, 72,139,124, 36,248,137,208, 69, 49,210, 65,131,
/* 0x1910 */ 203,255, 49,210, 73,137,252, 73,  1,196, 76, 57,231, 15,132,239,
/* 0x1920 */   8,  0,  0, 15,182,  7, 65,193,226,  8,255,194, 72,255,199, 65,
/* 0x1930 */   9,194,131,250,  4,126,227, 68, 59,124, 36,228, 15,131,218,  8,
/* 0x1940 */   0,  0,139, 68, 36,212, 72, 99, 92, 36,200, 72,139, 84, 36,216,
/* 0x1950 */  68, 33,248,137, 68, 36,184, 72, 99,108, 36,184, 72,137,216, 72,
/* 0x1960 */ 193,224,  4, 72,  1,232, 65,129,251,255,255,255,  0, 76,141, 12,
/* 0x1970 */  66,119, 26, 76, 57,231, 15,132,150,  8,  0,  0, 15,182,  7, 65,
/* 0x1980 */ 193,226,  8, 65,193,227,  8, 72,255,199, 65,  9,194, 65, 15,183,
/* 0x1990 */  17, 68,137,216,193,232, 11, 15,183,202, 15,175,193, 65, 57,194,
/* 0x19a0 */  15,131,197,  1,  0,  0, 65,137,195,184,  0,  8,  0,  0, 72,139,
/* 0x19b0 */  92, 36,216, 41,200, 15,182, 76, 36,204,190,  1,  0,  0,  0,193,
/* 0x19c0 */ 248,  5,141,  4,  2, 65, 15,182,213,102, 65,137,  1,139, 68, 36,
/* 0x19d0 */ 208, 68, 33,248,211,224,185,  8,  0,  0,  0, 43, 76, 36,204,211,
/* 0x19e0 */ 250,  1,208,105,192,  0,  3,  0,  0,131,124, 36,200,  6,137,192,
/* 0x19f0 */  76,141,140, 67,108, 14,  0,  0, 15,142,184,  0,  0,  0, 72,139,
/* 0x1a00 */  84, 36,232, 68,137,248, 68, 41,240, 15,182, 44,  2,  1,237, 72,
/* 0x1a10 */  99,214,137,235,129,227,  0,  1,  0,  0, 65,129,251,255,255,255,
/* 0x1a20 */   0, 72, 99,195, 73,141,  4, 65, 76,141,  4, 80,119, 26, 76, 57,
/* 0x1a30 */ 231, 15,132,219,  7,  0,  0, 15,182,  7, 65,193,226,  8, 65,193,
/* 0x1a40 */ 227,  8, 72,255,199, 65,  9,194, 65, 15,183,144,  0,  2,  0,  0,
/* 0x1a50 */  68,137,216,193,232, 11, 15,183,202, 15,175,193, 65, 57,194,115,
/* 0x1a60 */  32, 65,137,195,184,  0,  8,  0,  0,  1,246, 41,200,193,248,  5,
/* 0x1a70 */ 133,219,141,  4,  2,102, 65,137,128,  0,  2,  0,  0,116, 33,235,
/* 0x1a80 */  45, 65, 41,195, 65, 41,194,137,208,102,193,232,  5,141,116, 54,
/* 0x1a90 */   1,102, 41,194,133,219,102, 65,137,144,  0,  2,  0,  0,116, 14,
/* 0x1aa0 */ 129,254,255,  0,  0,  0, 15,142, 97,255,255,255,235,120,129,254,
/* 0x1ab0 */ 255,  0,  0,  0,127,112, 72, 99,198, 65,129,251,255,255,255,  0,
/* 0x1ac0 */  77,141,  4, 65,119, 26, 76, 57,231, 15,132, 67,  7,  0,  0, 15,
/* 0x1ad0 */ 182,  7, 65,193,226,  8, 65,193,227,  8, 72,255,199, 65,  9,194,
/* 0x1ae0 */  65, 15,183, 16, 68,137,216,193,232, 11, 15,183,202, 15,175,193,
/* 0x1af0 */  65, 57,194,115, 24, 65,137,195,184,  0,  8,  0,  0,  1,246, 41,
/* 0x1b00 */ 200,193,248,  5,141,  4,  2,102, 65,137,  0,235,161, 65, 41,195,
/* 0x1b10 */  65, 41,194,137,208,102,193,232,  5,141,116, 54,  1,102, 41,194,
/* 0x1b20 */ 102, 65,137, 16,235,136, 72,139, 76, 36,232, 68,137,248, 65,255,
/* 0x1b30 */ 199, 65,137,245, 64,136, 52,  1,131,124, 36,200,  3,127, 13,199,
/* 0x1b40 */  68, 36,200,  0,  0,  0,  0,233,166,  6,  0,  0,139, 84, 36,200,
/* 0x1b50 */ 139, 68, 36,200,131,234,  3,131,232,  6,131,124, 36,200,  9, 15,
/* 0x1b60 */  79,208,137, 84, 36,200,233,135,  6,  0,  0, 65, 41,195, 65, 41,
/* 0x1b70 */ 194,137,208,102,193,232,  5,102, 41,194, 72,139, 68, 36,216, 65,
/* 0x1b80 */ 129,251,255,255,255,  0,102, 65,137, 17, 72,141, 52, 88,119, 26,
/* 0x1b90 */  76, 57,231, 15,132,121,  6,  0,  0, 15,182,  7, 65,193,226,  8,
/* 0x1ba0 */  65,193,227,  8, 72,255,199, 65,  9,194, 15,183,150,128,  1,  0,
/* 0x1bb0 */   0, 68,137,216,193,232, 11, 15,183,202, 15,175,193, 65, 57,194,
/* 0x1bc0 */ 115, 78, 65,137,195,184,  0,  8,  0,  0, 76,139, 76, 36,216, 41,
/* 0x1bd0 */ 200,139, 76, 36,196, 68,137,116, 36,196,193,248,  5,141,  4,  2,
/* 0x1be0 */ 139, 84, 36,192,137, 76, 36,192,102,137,134,128,  1,  0,  0, 49,
/* 0x1bf0 */ 192,131,124, 36,200,  6,137, 84, 36,188, 15,159,192, 73,129,193,
/* 0x1c00 */ 100,  6,  0,  0,141,  4, 64,137, 68, 36,200,233, 84,  2,  0,  0,
/* 0x1c10 */  65, 41,195, 65, 41,194,137,208,102,193,232,  5,102, 41,194, 65,
/* 0x1c20 */ 129,251,255,255,255,  0,102,137,150,128,  1,  0,  0,119, 26, 76,
/* 0x1c30 */  57,231, 15,132,218,  5,  0,  0, 15,182,  7, 65,193,226,  8, 65,
/* 0x1c40 */ 193,227,  8, 72,255,199, 65,  9,194, 15,183,150,152,  1,  0,  0,
/* 0x1c50 */  68,137,216,193,232, 11, 15,183,202, 15,175,193, 65, 57,194, 15,
/* 0x1c60 */ 131,208,  0,  0,  0, 65,184,  0,  8,  0,  0, 65,137,195, 72,193,
/* 0x1c70 */ 227,  5, 68,137,192, 41,200,193,248,  5,141,  4,  2,102,137,134,
/* 0x1c80 */ 152,  1,  0,  0, 72,139, 68, 36,216, 72,  1,216, 65,129,251,255,
/* 0x1c90 */ 255,255,  0, 72,141, 52,104,119, 26, 76, 57,231, 15,132,112,  5,
/* 0x1ca0 */   0,  0, 15,182,  7, 65,193,226,  8, 65,193,227,  8, 72,255,199,
/* 0x1cb0 */  65,  9,194, 15,183,150,224,  1,  0,  0, 68,137,216,193,232, 11,
/* 0x1cc0 */  15,183,202, 15,175,193, 65, 57,194,115, 79, 65, 41,200, 65,137,
/* 0x1cd0 */ 195, 65,193,248,  5, 69,133,255, 66,141,  4,  2,102,137,134,224,
/* 0x1ce0 */   1,  0,  0, 15,132, 41,  5,  0,  0, 49,192,131,124, 36,200,  6,
/* 0x1cf0 */  72,139, 92, 36,232, 15,159,192,141, 68,  0,  9,137, 68, 36,200,
/* 0x1d00 */  68,137,248, 68, 41,240, 68, 15,182, 44,  3, 68,137,248, 65,255,
/* 0x1d10 */ 199, 68,136, 44,  3,233,216,  4,  0,  0, 65, 41,195, 65, 41,194,
/* 0x1d20 */ 137,208,102,193,232,  5,102, 41,194,102,137,150,224,  1,  0,  0,
/* 0x1d30 */ 233, 17,  1,  0,  0, 65, 41,195, 65, 41,194,137,208,102,193,232,
/* 0x1d40 */   5,102, 41,194, 65,129,251,255,255,255,  0,102,137,150,152,  1,
/* 0x1d50 */   0,  0,119, 26, 76, 57,231, 15,132,181,  4,  0,  0, 15,182,  7,
/* 0x1d60 */  65,193,226,  8, 65,193,227,  8, 72,255,199, 65,  9,194, 15,183,
/* 0x1d70 */ 150,176,  1,  0,  0, 68,137,216,193,232, 11, 15,183,202, 15,175,
/* 0x1d80 */ 193, 65, 57,194,115, 32, 65,137,195,184,  0,  8,  0,  0, 41,200,
/* 0x1d90 */ 193,248,  5,141,  4,  2,102,137,134,176,  1,  0,  0,139, 68, 36,
/* 0x1da0 */ 196,233,152,  0,  0,  0, 65, 41,195, 65, 41,194,137,208,102,193,
/* 0x1db0 */ 232,  5,102, 41,194, 65,129,251,255,255,255,  0,102,137,150,176,
/* 0x1dc0 */   1,  0,  0,119, 26, 76, 57,231, 15,132, 68,  4,  0,  0, 15,182,
/* 0x1dd0 */   7, 65,193,226,  8, 65,193,227,  8, 72,255,199, 65,  9,194, 15,
/* 0x1de0 */ 183,150,200,  1,  0,  0, 68,137,216,193,232, 11, 15,183,202, 15,
/* 0x1df0 */ 175,193, 65, 57,194,115, 29, 65,137,195,184,  0,  8,  0,  0, 41,
/* 0x1e00 */ 200,193,248,  5,141,  4,  2,102,137,134,200,  1,  0,  0,139, 68,
/* 0x1e10 */  36,192,235, 34, 65, 41,195, 65, 41,194,137,208,102,193,232,  5,
/* 0x1e20 */ 102, 41,194,139, 68, 36,188,102,137,150,200,  1,  0,  0,139, 84,
/* 0x1e30 */  36,192,137, 84, 36,188,139, 76, 36,196,137, 76, 36,192, 68,137,
/* 0x1e40 */ 116, 36,196, 65,137,198, 49,192,131,124, 36,200,  6, 76,139, 76,
/* 0x1e50 */  36,216, 15,159,192, 73,129,193,104, 10,  0,  0,141, 68, 64,  8,
/* 0x1e60 */ 137, 68, 36,200, 65,129,251,255,255,255,  0,119, 26, 76, 57,231,
/* 0x1e70 */  15,132,156,  3,  0,  0, 15,182,  7, 65,193,226,  8, 65,193,227,
/* 0x1e80 */   8, 72,255,199, 65,  9,194, 65, 15,183, 17, 68,137,216,193,232,
/* 0x1e90 */  11, 15,183,202, 15,175,193, 65, 57,194,115, 39, 65,137,195,184,
/* 0x1ea0 */   0,  8,  0,  0, 69, 49,237, 41,200,193,248,  5,141,  4,  2,102,
/* 0x1eb0 */  65,137,  1, 72, 99, 68, 36,184, 72,193,224,  4, 77,141, 68,  1,
/* 0x1ec0 */   4,235,120, 65, 41,195, 65, 41,194,137,208,102,193,232,  5,102,
/* 0x1ed0 */  41,194, 65,129,251,255,255,255,  0,102, 65,137, 17,119, 26, 76,
/* 0x1ee0 */  57,231, 15,132, 42,  3,  0,  0, 15,182,  7, 65,193,226,  8, 65,
/* 0x1ef0 */ 193,227,  8, 72,255,199, 65,  9,194, 65, 15,183, 81,  2, 68,137,
/* 0x1f00 */ 216,193,232, 11, 15,183,202, 15,175,193, 65, 57,194,115, 52, 65,
/* 0x1f10 */ 137,195,184,  0,  8,  0,  0, 65,189,  8,  0,  0,  0, 41,200,193,
/* 0x1f20 */ 248,  5,141,  4,  2,102, 65,137, 65,  2, 72, 99, 68, 36,184, 72,
/* 0x1f30 */ 193,224,  4, 77,141,132,  1,  4,  1,  0,  0, 65,185,  3,  0,  0,
/* 0x1f40 */   0,235, 39, 65, 41,195, 65, 41,194,137,208,102,193,232,  5, 77,
/* 0x1f50 */ 141,129,  4,  2,  0,  0, 65,189, 16,  0,  0,  0,102, 41,194,102,
/* 0x1f60 */  65,137, 81,  2, 65,185,  8,  0,  0,  0, 68,137,203,189,  1,  0,
/* 0x1f70 */   0,  0, 72, 99,197, 65,129,251,255,255,255,  0, 73,141, 52, 64,
/* 0x1f80 */ 119, 26, 76, 57,231, 15,132,135,  2,  0,  0, 15,182,  7, 65,193,
/* 0x1f90 */ 226,  8, 65,193,227,  8, 72,255,199, 65,  9,194, 15,183, 14, 68,
/* 0x1fa0 */ 137,216,193,232, 11, 15,183,209, 15,175,194, 65, 57,194,115, 23,
/* 0x1fb0 */  65,137,195,184,  0,  8,  0,  0,  1,237, 41,208,193,248,  5,141,
/* 0x1fc0 */   4,  1,102,137,  6,235, 22, 65, 41,195, 65, 41,194,137,200,102,
/* 0x1fd0 */ 193,232,  5,141,108, 45,  1,102, 41,193,102,137, 14,255,203,117,
/* 0x1fe0 */ 145,184,  1,  0,  0,  0, 68,137,201,211,224, 41,197, 68,  1,237,
/* 0x1ff0 */ 131,124, 36,200,  3, 15,143,194,  1,  0,  0,131, 68, 36,200,  7,
/* 0x2000 */ 184,  3,  0,  0,  0,131,253,  4, 15, 76,197, 72,139, 92, 36,216,
/* 0x2010 */  65,184,  1,  0,  0,  0, 72,152, 72,193,224,  7, 76,141,140,  3,
/* 0x2020 */  96,  3,  0,  0,187,  6,  0,  0,  0, 73, 99,192, 65,129,251,255,
/* 0x2030 */ 255,255,  0, 73,141, 52, 65,119, 26, 76, 57,231, 15,132,208,  1,
/* 0x2040 */   0,  0, 15,182,  7, 65,193,226,  8, 65,193,227,  8, 72,255,199,
/* 0x2050 */  65,  9,194, 15,183, 22, 68,137,216,193,232, 11, 15,183,202, 15,
/* 0x2060 */ 175,193, 65, 57,194,115, 24, 65,137,195,184,  0,  8,  0,  0, 69,
/* 0x2070 */   1,192, 41,200,193,248,  5,141,  4,  2,102,137,  6,235, 23, 65,
/* 0x2080 */  41,195, 65, 41,194,137,208,102,193,232,  5, 71,141, 68,  0,  1,
/* 0x2090 */ 102, 41,194,102,137, 22,255,203,117,143, 65,131,232, 64, 65,131,
/* 0x20a0 */ 248,  3, 69,137,198, 15,142, 13,  1,  0,  0, 65,131,230,  1, 68,
/* 0x20b0 */ 137,192,209,248, 65,131,206,  2, 65,131,248, 13,141,112,255,127,
/* 0x20c0 */  35,137,241, 72,139, 92, 36,216, 73, 99,192, 65,211,230, 72,  1,
/* 0x20d0 */ 192, 68,137,242, 72,141, 20, 83, 72, 41,194, 76,141,138, 94,  5,
/* 0x20e0 */   0,  0,235, 81,141,112,251, 65,129,251,255,255,255,  0,119, 26,
/* 0x20f0 */  76, 57,231, 15,132, 25,  1,  0,  0, 15,182,  7, 65,193,226,  8,
/* 0x2100 */  65,193,227,  8, 72,255,199, 65,  9,194, 65,209,235, 69,  1,246,
/* 0x2110 */  69, 57,218,114,  7, 69, 41,218, 65,131,206,  1,255,206,117,199,
/* 0x2120 */  76,139, 76, 36,216, 65,193,230,  4,190,  4,  0,  0,  0, 73,129,
/* 0x2130 */ 193, 68,  6,  0,  0, 65,189,  1,  0,  0,  0,187,  1,  0,  0,  0,
/* 0x2140 */  72, 99,195, 65,129,251,255,255,255,  0, 77,141,  4, 65,119, 26,
/* 0x2150 */  76, 57,231, 15,132,185,  0,  0,  0, 15,182,  7, 65,193,226,  8,
/* 0x2160 */  65,193,227,  8, 72,255,199, 65,  9,194, 65, 15,183, 16, 68,137,
/* 0x2170 */ 216,193,232, 11, 15,183,202, 15,175,193, 65, 57,194,115, 24, 65,
/* 0x2180 */ 137,195,184,  0,  8,  0,  0,  1,219, 41,200,193,248,  5,141,  4,
/* 0x2190 */   2,102, 65,137,  0,235, 26, 65, 41,195, 65, 41,194,137,208,102,
/* 0x21a0 */ 193,232,  5,141, 92, 27,  1, 69,  9,238,102, 41,194,102, 65,137,
/* 0x21b0 */  16, 69,  1,237,255,206,117,136, 65,255,198,116, 64,131,197,  2,
/* 0x21c0 */  69, 57,254,119, 77, 72,139, 84, 36,232, 68,137,248, 68, 41,240,
/* 0x21d0 */  68, 15,182, 44,  2, 68,137,248, 65,255,199,255,205, 68,136, 44,
/* 0x21e0 */   2, 15,149,194, 49,192, 68, 59,124, 36,228, 15,146,192,133,194,
/* 0x21f0 */ 117,211, 68, 59,124, 36,228, 15,130, 69,247,255,255, 65,129,251,
/* 0x2200 */ 255,255,255,  0,119, 22, 76, 57,231,184,  1,  0,  0,  0,116, 35,
/* 0x2210 */ 235,  7,184,  1,  0,  0,  0,235, 26, 72,255,199,137,248, 43, 68,
/* 0x2220 */  36,248, 72,139, 76, 36,240, 72,139, 92, 36, 56,137,  1, 68,137,
/* 0x2230 */  59, 49,192, 91, 93, 65, 92, 65, 93, 65, 94, 65, 95, 72,139,117,
/* 0x2240 */ 248, 72,139,125,  8,139, 75,  4, 72,  1,206,139, 19, 72,  1,215,
/* 0x2250 */ 201,233,  0,  0,  0,  0,  0,  0, 68,137,193,131,200,255,204,244,
/* 0x2260 */  88, 72, 41,199, 88, 89,137, 57, 72, 41,240,195,117,112,120,  0,
/* 0x2270 */  47,100,101,118, 47,115,104,109,  0, 85, 80, 88, 45, 53, 46, 48,
/* 0x2280 */  32,119, 97,110,116,115, 32,109,101,109,102,100, 95, 99,114,101,
/* 0x2290 */  97,116,101, 40, 41, 44, 32,111,114, 32,110,101,101,100,115, 32,
/* 0x22a0 */  47,100,101,118, 47,115,104,109, 40, 44, 79, 95, 84, 77, 80, 70,
/* 0x22b0 */  73, 76, 69, 44, 41, 10,  0,  0, 46,115,121,109,116, 97, 98,  0,
/* 0x22c0 */  46,115,116,114,116, 97, 98,  0, 46,115,104,115,116,114,116, 97,
/* 0x22d0 */  98,  0, 46,114,101,108, 97, 72, 85, 77, 70, 95, 65,  0, 46,114,
/* 0x22e0 */ 101,108, 97, 72, 85, 77, 70, 95, 76,  0, 46,114,101,108, 97, 85,
/* 0x22f0 */  77, 70, 95, 76, 73, 78, 85, 88,  0, 46,114,101,108, 97, 83, 79,
/* 0x2300 */  95, 77, 65, 73, 78,  0, 46,114,101,108, 97, 83, 79, 95, 72, 69,
/* 0x2310 */  65, 68,  0,112,116,114, 95, 78, 69, 88, 84,  0, 46,114,101,108,
/* 0x2320 */  97, 83, 79, 95, 84, 65, 73, 76,  0, 69, 88, 80, 95, 72, 69, 65,
/* 0x2330 */  68,  0, 46,114,101,108, 97, 78, 82, 86, 50, 69,  0, 46,114,101,
/* 0x2340 */ 108, 97, 78, 82, 86, 50, 68,  0, 46,114,101,108, 97, 78, 82, 86,
/* 0x2350 */  50, 66,  0, 46,114,101,108, 97, 76, 90, 77, 65, 95, 68, 65, 73,
/* 0x2360 */  83, 89,  0, 76, 90, 77, 65, 95, 69, 76, 70, 48, 48,  0, 76, 90,
/* 0x2370 */  77, 65, 95, 68, 69, 67, 49, 48,  0, 76, 90, 77, 65, 95, 68, 69,
/* 0x2380 */  67, 50, 48,  0, 46,114,101,108, 97, 76, 90, 77, 65, 95, 68, 69,
/* 0x2390 */  67, 51, 48,  0, 69, 88, 80, 95, 84, 65, 73, 76,  0, 83, 84, 82,
/* 0x23a0 */  67, 79, 78,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x23b0 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x23c0 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x23d0 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x23e0 */   0,  0,  0,  0,  0,  0,  0,  0, 32,  0,  0,  0,  1,  0,  0,  0,
/* 0x23f0 */   6,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x2400 */  64,  0,  0,  0,  0,  0,  0,  0,  5,  0,  0,  0,  0,  0,  0,  0,
/* 0x2410 */   0,  0,  0,  0,  0,  0,  0,  0,  1,  0,  0,  0,  0,  0,  0,  0,
/* 0x2420 */   0,  0,  0,  0,  0,  0,  0,  0, 27,  0,  0,  0,  4,  0,  0,  0,
/* 0x2430 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x2440 */ 224, 49,  0,  0,  0,  0,  0,  0, 24,  0,  0,  0,  0,  0,  0,  0,
/* 0x2450 */  31,  0,  0,  0,  1,  0,  0,  0,  8,  0,  0,  0,  0,  0,  0,  0,
/* 0x2460 */  24,  0,  0,  0,  0,  0,  0,  0, 44,  0,  0,  0,  1,  0,  0,  0,
/* 0x2470 */   6,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x2480 */  69,  0,  0,  0,  0,  0,  0,  0,  5,  0,  0,  0,  0,  0,  0,  0,
/* 0x2490 */   0,  0,  0,  0,  0,  0,  0,  0,  1,  0,  0,  0,  0,  0,  0,  0,
/* 0x24a0 */   0,  0,  0,  0,  0,  0,  0,  0, 39,  0,  0,  0,  4,  0,  0,  0,
/* 0x24b0 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x24c0 */ 248, 49,  0,  0,  0,  0,  0,  0, 24,  0,  0,  0,  0,  0,  0,  0,
/* 0x24d0 */  31,  0,  0,  0,  3,  0,  0,  0,  8,  0,  0,  0,  0,  0,  0,  0,
/* 0x24e0 */  24,  0,  0,  0,  0,  0,  0,  0, 56,  0,  0,  0,  1,  0,  0,  0,
/* 0x24f0 */   6,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x2500 */  76,  0,  0,  0,  0,  0,  0,  0,249,  0,  0,  0,  0,  0,  0,  0,
/* 0x2510 */   0,  0,  0,  0,  0,  0,  0,  0,  4,  0,  0,  0,  0,  0,  0,  0,
/* 0x2520 */   0,  0,  0,  0,  0,  0,  0,  0, 51,  0,  0,  0,  4,  0,  0,  0,
/* 0x2530 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x2540 */  16, 50,  0,  0,  0,  0,  0,  0,  8,  1,  0,  0,  0,  0,  0,  0,
/* 0x2550 */  31,  0,  0,  0,  5,  0,  0,  0,  8,  0,  0,  0,  0,  0,  0,  0,
/* 0x2560 */  24,  0,  0,  0,  0,  0,  0,  0, 71,  0,  0,  0,  1,  0,  0,  0,
/* 0x2570 */   6,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x2580 */  80,  1,  0,  0,  0,  0,  0,  0, 19,  8,  0,  0,  0,  0,  0,  0,
/* 0x2590 */   0,  0,  0,  0,  0,  0,  0,  0, 16,  0,  0,  0,  0,  0,  0,  0,
/* 0x25a0 */   0,  0,  0,  0,  0,  0,  0,  0, 66,  0,  0,  0,  4,  0,  0,  0,
/* 0x25b0 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x25c0 */  24, 51,  0,  0,  0,  0,  0,  0,232,  2,  0,  0,  0,  0,  0,  0,
/* 0x25d0 */  31,  0,  0,  0,  7,  0,  0,  0,  8,  0,  0,  0,  0,  0,  0,  0,
/* 0x25e0 */  24,  0,  0,  0,  0,  0,  0,  0, 84,  0,  0,  0,  1,  0,  0,  0,
/* 0x25f0 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x2600 */  99,  9,  0,  0,  0,  0,  0,  0, 68,  0,  0,  0,  0,  0,  0,  0,
/* 0x2610 */   0,  0,  0,  0,  0,  0,  0,  0,  1,  0,  0,  0,  0,  0,  0,  0,
/* 0x2620 */   0,  0,  0,  0,  0,  0,  0,  0, 79,  0,  0,  0,  4,  0,  0,  0,
/* 0x2630 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x2640 */   0, 54,  0,  0,  0,  0,  0,  0, 24,  0,  0,  0,  0,  0,  0,  0,
/* 0x2650 */  31,  0,  0,  0,  9,  0,  0,  0,  8,  0,  0,  0,  0,  0,  0,  0,
/* 0x2660 */  24,  0,  0,  0,  0,  0,  0,  0, 92,  0,  0,  0,  1,  0,  0,  0,
/* 0x2670 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x2680 */ 167,  9,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x2690 */   0,  0,  0,  0,  0,  0,  0,  0,  1,  0,  0,  0,  0,  0,  0,  0,
/* 0x26a0 */   0,  0,  0,  0,  0,  0,  0,  0,106,  0,  0,  0,  1,  0,  0,  0,
/* 0x26b0 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x26c0 */ 167,  9,  0,  0,  0,  0,  0,  0,201,  0,  0,  0,  0,  0,  0,  0,
/* 0x26d0 */   0,  0,  0,  0,  0,  0,  0,  0,  1,  0,  0,  0,  0,  0,  0,  0,
/* 0x26e0 */   0,  0,  0,  0,  0,  0,  0,  0,101,  0,  0,  0,  4,  0,  0,  0,
/* 0x26f0 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x2700 */  24, 54,  0,  0,  0,  0,  0,  0, 72,  0,  0,  0,  0,  0,  0,  0,
/* 0x2710 */  31,  0,  0,  0, 12,  0,  0,  0,  8,  0,  0,  0,  0,  0,  0,  0,
/* 0x2720 */  24,  0,  0,  0,  0,  0,  0,  0,114,  0,  0,  0,  1,  0,  0,  0,
/* 0x2730 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x2740 */ 112, 10,  0,  0,  0,  0,  0,  0,233,  0,  0,  0,  0,  0,  0,  0,
/* 0x2750 */   0,  0,  0,  0,  0,  0,  0,  0,  1,  0,  0,  0,  0,  0,  0,  0,
/* 0x2760 */   0,  0,  0,  0,  0,  0,  0,  0,128,  0,  0,  0,  1,  0,  0,  0,
/* 0x2770 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x2780 */  89, 11,  0,  0,  0,  0,  0,  0,232,  0,  0,  0,  0,  0,  0,  0,
/* 0x2790 */   0,  0,  0,  0,  0,  0,  0,  0,  1,  0,  0,  0,  0,  0,  0,  0,
/* 0x27a0 */   0,  0,  0,  0,  0,  0,  0,  0,123,  0,  0,  0,  4,  0,  0,  0,
/* 0x27b0 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x27c0 */  96, 54,  0,  0,  0,  0,  0,  0, 48,  0,  0,  0,  0,  0,  0,  0,
/* 0x27d0 */  31,  0,  0,  0, 15,  0,  0,  0,  8,  0,  0,  0,  0,  0,  0,  0,
/* 0x27e0 */  24,  0,  0,  0,  0,  0,  0,  0,139,  0,  0,  0,  1,  0,  0,  0,
/* 0x27f0 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x2800 */  65, 12,  0,  0,  0,  0,  0,  0,219,  0,  0,  0,  0,  0,  0,  0,
/* 0x2810 */   0,  0,  0,  0,  0,  0,  0,  0,  1,  0,  0,  0,  0,  0,  0,  0,
/* 0x2820 */   0,  0,  0,  0,  0,  0,  0,  0,134,  0,  0,  0,  4,  0,  0,  0,
/* 0x2830 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x2840 */ 144, 54,  0,  0,  0,  0,  0,  0, 48,  0,  0,  0,  0,  0,  0,  0,
/* 0x2850 */  31,  0,  0,  0, 17,  0,  0,  0,  8,  0,  0,  0,  0,  0,  0,  0,
/* 0x2860 */  24,  0,  0,  0,  0,  0,  0,  0,150,  0,  0,  0,  1,  0,  0,  0,
/* 0x2870 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x2880 */  28, 13,  0,  0,  0,  0,  0,  0,196,  0,  0,  0,  0,  0,  0,  0,
/* 0x2890 */   0,  0,  0,  0,  0,  0,  0,  0,  1,  0,  0,  0,  0,  0,  0,  0,
/* 0x28a0 */   0,  0,  0,  0,  0,  0,  0,  0,145,  0,  0,  0,  4,  0,  0,  0,
/* 0x28b0 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x28c0 */ 192, 54,  0,  0,  0,  0,  0,  0, 48,  0,  0,  0,  0,  0,  0,  0,
/* 0x28d0 */  31,  0,  0,  0, 19,  0,  0,  0,  8,  0,  0,  0,  0,  0,  0,  0,
/* 0x28e0 */  24,  0,  0,  0,  0,  0,  0,  0,161,  0,  0,  0,  1,  0,  0,  0,
/* 0x28f0 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x2900 */ 224, 13,  0,  0,  0,  0,  0,  0, 10,  0,  0,  0,  0,  0,  0,  0,
/* 0x2910 */   0,  0,  0,  0,  0,  0,  0,  0,  1,  0,  0,  0,  0,  0,  0,  0,
/* 0x2920 */   0,  0,  0,  0,  0,  0,  0,  0,156,  0,  0,  0,  4,  0,  0,  0,
/* 0x2930 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x2940 */ 240, 54,  0,  0,  0,  0,  0,  0, 24,  0,  0,  0,  0,  0,  0,  0,
/* 0x2950 */  31,  0,  0,  0, 21,  0,  0,  0,  8,  0,  0,  0,  0,  0,  0,  0,
/* 0x2960 */  24,  0,  0,  0,  0,  0,  0,  0,172,  0,  0,  0,  1,  0,  0,  0,
/* 0x2970 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x2980 */ 234, 13,  0,  0,  0,  0,  0,  0,101,  0,  0,  0,  0,  0,  0,  0,
/* 0x2990 */   0,  0,  0,  0,  0,  0,  0,  0,  1,  0,  0,  0,  0,  0,  0,  0,
/* 0x29a0 */   0,  0,  0,  0,  0,  0,  0,  0,183,  0,  0,  0,  1,  0,  0,  0,
/* 0x29b0 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x29c0 */  79, 14,  0,  0,  0,  0,  0,  0,247,  9,  0,  0,  0,  0,  0,  0,
/* 0x29d0 */   0,  0,  0,  0,  0,  0,  0,  0,  1,  0,  0,  0,  0,  0,  0,  0,
/* 0x29e0 */   0,  0,  0,  0,  0,  0,  0,  0,194,  0,  0,  0,  1,  0,  0,  0,
/* 0x29f0 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x2a00 */  70, 24,  0,  0,  0,  0,  0,  0,247,  9,  0,  0,  0,  0,  0,  0,
/* 0x2a10 */   0,  0,  0,  0,  0,  0,  0,  0,  1,  0,  0,  0,  0,  0,  0,  0,
/* 0x2a20 */   0,  0,  0,  0,  0,  0,  0,  0,210,  0,  0,  0,  1,  0,  0,  0,
/* 0x2a30 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x2a40 */  61, 34,  0,  0,  0,  0,  0,  0, 25,  0,  0,  0,  0,  0,  0,  0,
/* 0x2a50 */   0,  0,  0,  0,  0,  0,  0,  0,  1,  0,  0,  0,  0,  0,  0,  0,
/* 0x2a60 */   0,  0,  0,  0,  0,  0,  0,  0,205,  0,  0,  0,  4,  0,  0,  0,
/* 0x2a70 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x2a80 */   8, 55,  0,  0,  0,  0,  0,  0, 24,  0,  0,  0,  0,  0,  0,  0,
/* 0x2a90 */  31,  0,  0,  0, 26,  0,  0,  0,  8,  0,  0,  0,  0,  0,  0,  0,
/* 0x2aa0 */  24,  0,  0,  0,  0,  0,  0,  0,221,  0,  0,  0,  1,  0,  0,  0,
/* 0x2ab0 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x2ac0 */  88, 34,  0,  0,  0,  0,  0,  0, 20,  0,  0,  0,  0,  0,  0,  0,
/* 0x2ad0 */   0,  0,  0,  0,  0,  0,  0,  0,  4,  0,  0,  0,  0,  0,  0,  0,
/* 0x2ae0 */   0,  0,  0,  0,  0,  0,  0,  0,230,  0,  0,  0,  1,  0,  0,  0,
/* 0x2af0 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x2b00 */ 108, 34,  0,  0,  0,  0,  0,  0, 75,  0,  0,  0,  0,  0,  0,  0,
/* 0x2b10 */   0,  0,  0,  0,  0,  0,  0,  0,  1,  0,  0,  0,  0,  0,  0,  0,
/* 0x2b20 */   0,  0,  0,  0,  0,  0,  0,  0, 17,  0,  0,  0,  3,  0,  0,  0,
/* 0x2b30 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x2b40 */ 183, 34,  0,  0,  0,  0,  0,  0,237,  0,  0,  0,  0,  0,  0,  0,
/* 0x2b50 */   0,  0,  0,  0,  0,  0,  0,  0,  1,  0,  0,  0,  0,  0,  0,  0,
/* 0x2b60 */   0,  0,  0,  0,  0,  0,  0,  0,  1,  0,  0,  0,  2,  0,  0,  0,
/* 0x2b70 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x2b80 */ 232, 43,  0,  0,  0,  0,  0,  0,200,  4,  0,  0,  0,  0,  0,  0,
/* 0x2b90 */  32,  0,  0,  0, 19,  0,  0,  0,  8,  0,  0,  0,  0,  0,  0,  0,
/* 0x2ba0 */  24,  0,  0,  0,  0,  0,  0,  0,  9,  0,  0,  0,  3,  0,  0,  0,
/* 0x2bb0 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x2bc0 */ 176, 48,  0,  0,  0,  0,  0,  0, 42,  1,  0,  0,  0,  0,  0,  0,
/* 0x2bd0 */   0,  0,  0,  0,  0,  0,  0,  0,  1,  0,  0,  0,  0,  0,  0,  0,
/* 0x2be0 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x2bf0 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x2c00 */   0,  0,  0,  0,  3,  0,  9,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x2c10 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  3,  0, 14,  0,
/* 0x2c20 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x2c30 */   0,  0,  0,  0,  3,  0, 26,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x2c40 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  3,  0, 28,  0,
/* 0x2c50 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x2c60 */   0,  0,  0,  0,  3,  0, 29,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x2c70 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  3,  0,  1,  0,
/* 0x2c80 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x2c90 */   0,  0,  0,  0,  3,  0,  3,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x2ca0 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  3,  0,  5,  0,
/* 0x2cb0 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x2cc0 */   0,  0,  0,  0,  3,  0,  7,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x2cd0 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  3,  0, 11,  0,
/* 0x2ce0 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x2cf0 */   0,  0,  0,  0,  3,  0, 12,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x2d00 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  3,  0, 15,  0,
/* 0x2d10 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x2d20 */   0,  0,  0,  0,  3,  0, 17,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x2d30 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  3,  0, 19,  0,
/* 0x2d40 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x2d50 */   0,  0,  0,  0,  3,  0, 21,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x2d60 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  3,  0, 23,  0,
/* 0x2d70 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x2d80 */   0,  0,  0,  0,  3,  0, 24,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x2d90 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  3,  0, 25,  0,
/* 0x2da0 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x2db0 */   1,  0,  0,  0, 16,  0, 12,  0, 91,  0,  0,  0,  0,  0,  0,  0,
/* 0x2dc0 */   0,  0,  0,  0,  0,  0,  0,  0,  6,  0,  0,  0, 16,  0, 14,  0,
/* 0x2dd0 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x2de0 */  15,  0,  0,  0, 16,  0,  9,  0, 60,  0,  0,  0,  0,  0,  0,  0,
/* 0x2df0 */   0,  0,  0,  0,  0,  0,  0,  0, 29,  0,  0,  0, 16,  0, 12,  0,
/* 0x2e00 */ 163,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x2e10 */  36,  0,  0,  0, 16,  0, 28,  0, 20,  0,  0,  0,  0,  0,  0,  0,
/* 0x2e20 */   0,  0,  0,  0,  0,  0,  0,  0, 52,  0,  0,  0, 18,  0,  7,  0,
/* 0x2e30 */  23,  4,  0,  0,  0,  0,  0,  0,172,  0,  0,  0,  0,  0,  0,  0,
/* 0x2e40 */  65,  0,  0,  0, 16,  0, 12,  0, 28,  0,  0,  0,  0,  0,  0,  0,
/* 0x2e50 */   0,  0,  0,  0,  0,  0,  0,  0, 72,  0,  0,  0, 16,  0, 12,  0,
/* 0x2e60 */  49,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x2e70 */  80,  0,  0,  0, 16,  0, 12,  0, 49,  0,  0,  0,  0,  0,  0,  0,
/* 0x2e80 */   0,  0,  0,  0,  0,  0,  0,  0, 86,  0,  0,  0, 16,  0, 12,  0,
/* 0x2e90 */ 171,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x2ea0 */  96,  0,  0,  0, 16,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x2eb0 */   0,  0,  0,  0,  0,  0,  0,  0,120,  0,  0,  0, 16,  0, 12,  0,
/* 0x2ec0 */ 105,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x2ed0 */ 125,  0,  0,  0, 18,  0,  5,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x2ee0 */ 249,  0,  0,  0,  0,  0,  0,  0,147,  0,  0,  0, 18,  0, 12,  0,
/* 0x2ef0 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x2f00 */ 151,  0,  0,  0, 18,  0,  7,  0,195,  4,  0,  0,  0,  0,  0,  0,
/* 0x2f10 */ 185,  0,  0,  0,  0,  0,  0,  0,164,  0,  0,  0, 16,  0, 12,  0,
/* 0x2f20 */ 193,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x2f30 */ 170,  0,  0,  0, 18,  0,  7,  0,250,  3,  0,  0,  0,  0,  0,  0,
/* 0x2f40 */  29,  0,  0,  0,  0,  0,  0,  0,181,  0,  0,  0, 16,  0, 12,  0,
/* 0x2f50 */ 175,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x2f60 */ 194,  0,  0,  0, 16,  0, 12,  0,197,  0,  0,  0,  0,  0,  0,  0,
/* 0x2f70 */   0,  0,  0,  0,  0,  0,  0,  0,199,  0,  0,  0, 18,  0,  7,  0,
/* 0x2f80 */ 132,  1,  0,  0,  0,  0,  0,  0,239,  0,  0,  0,  0,  0,  0,  0,
/* 0x2f90 */ 210,  0,  0,  0, 16,  0, 12,  0, 19,  0,  0,  0,  0,  0,  0,  0,
/* 0x2fa0 */   0,  0,  0,  0,  0,  0,  0,  0,217,  0,  0,  0, 16,  0, 12,  0,
/* 0x2fb0 */  66,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x2fc0 */ 223,  0,  0,  0, 16,  0, 12,  0, 17,  0,  0,  0,  0,  0,  0,  0,
/* 0x2fd0 */   0,  0,  0,  0,  0,  0,  0,  0,231,  0,  0,  0, 16,  0, 12,  0,
/* 0x2fe0 */  70,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x2ff0 */ 240,  0,  0,  0, 16,  0, 12,  0,193,  0,  0,  0,  0,  0,  0,  0,
/* 0x3000 */   0,  0,  0,  0,  0,  0,  0,  0,247,  0,  0,  0, 16,  0, 12,  0,
/* 0x3010 */ 149,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x3020 */ 254,  0,  0,  0, 16,  0, 12,  0,167,  0,  0,  0,  0,  0,  0,  0,
/* 0x3030 */   0,  0,  0,  0,  0,  0,  0,  0,  3,  1,  0,  0, 16,  0, 12,  0,
/* 0x3040 */ 186,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x3050 */  10,  1,  0,  0, 16,  0, 12,  0,128,  0,  0,  0,  0,  0,  0,  0,
/* 0x3060 */   0,  0,  0,  0,  0,  0,  0,  0, 15,  1,  0,  0, 16,  0, 12,  0,
/* 0x3070 */  87,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x3080 */  24,  1,  0,  0, 16,  0, 12,  0,182,  0,  0,  0,  0,  0,  0,  0,
/* 0x3090 */   0,  0,  0,  0,  0,  0,  0,  0, 30,  1,  0,  0, 18,  0,  7,  0,
/* 0x30a0 */ 124,  5,  0,  0,  0,  0,  0,  0,151,  2,  0,  0,  0,  0,  0,  0,
/* 0x30b0 */   0, 80,109, 97,112,  0,102, 95,101,120,112, 97,110,100,  0,103,
/* 0x30c0 */ 101,116, 95,112, 97,103,101, 95,109, 97,115,107,  0,109,117,110,
/* 0x30d0 */ 109, 97,112,  0,117,112,120, 95,109,109, 97,112, 95, 97,110,100,
/* 0x30e0 */  95,102,100,  0,102,105,110,105, 95, 83, 69, 76,105,110,117,120,
/* 0x30f0 */   0,109,101,109, 99,112,121,  0, 79, 95, 66, 73, 78, 70, 79,  0,
/* 0x3100 */  80,115,121,110, 99,  0,102,116,114,117,110, 99, 97,116,101,  0,
/* 0x3110 */ 117,112,120, 95,109,109, 97,112, 95, 97,110,100, 95,102,100, 95,
/* 0x3120 */  97,110,100,114,111,105,100,  0,109,109, 97,112,  0,117,112,120,
/* 0x3130 */  95,109,109, 97,112, 95, 97,110,100, 95,102,100, 95,108,105,110,
/* 0x3140 */ 117,120,  0,101,111,102,  0,112,114,101,112, 95, 83, 69, 76,105,
/* 0x3150 */ 110,117,120,  0,119,114,105,116,101,  0, 80, 70, 95,116,111, 95,
/* 0x3160 */  80, 82, 79, 84,  0,109,101,109,102,100, 95, 99,114,101, 97,116,
/* 0x3170 */ 101,  0,114,101, 97,100,  0,109, 97,107,101, 95,104, 97,116, 99,
/* 0x3180 */ 104,  0,109,101,109,115,101,116,  0,109,115,121,110, 99,  0,109,
/* 0x3190 */ 121, 95, 98,107,112,116,  0, 80,112,114,111,116,101, 99,116,  0,
/* 0x31a0 */  80,119,114,105,116,101,  0, 80,117,110,109, 97,112,  0,101,120,
/* 0x31b0 */ 105,116,  0,111,112,101,110, 97,116,  0,111,112,101,110,  0,109,
/* 0x31c0 */ 112,114,111,116,101, 99,116,  0, 99,108,111,115,101,  0,117,112,
/* 0x31d0 */ 120, 95,115,111, 95,109, 97,105,110,  0,  0,  0,  0,  0,  0,  0,
/* 0x31e0 */   1,  0,  0,  0,  0,  0,  0,  0,  2,  0,  0,  0, 29,  0,  0,  0,
/* 0x31f0 */ 252,255,255,255,255,255,255,255,  1,  0,  0,  0,  0,  0,  0,  0,
/* 0x3200 */   2,  0,  0,  0, 31,  0,  0,  0,252,255,255,255,255,255,255,255,
/* 0x3210 */  33,  0,  0,  0,  0,  0,  0,  0,  2,  0,  0,  0,  5,  0,  0,  0,
/* 0x3220 */ 252,255,255,255,255,255,255,255, 46,  0,  0,  0,  0,  0,  0,  0,
/* 0x3230 */   4,  0,  0,  0, 36,  0,  0,  0,252,255,255,255,255,255,255,255,
/* 0x3240 */  66,  0,  0,  0,  0,  0,  0,  0,  4,  0,  0,  0, 36,  0,  0,  0,
/* 0x3250 */ 252,255,255,255,255,255,255,255, 79,  0,  0,  0,  0,  0,  0,  0,
/* 0x3260 */   2,  0,  0,  0,  5,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x3270 */  94,  0,  0,  0,  0,  0,  0,  0,  4,  0,  0,  0, 47,  0,  0,  0,
/* 0x3280 */ 252,255,255,255,255,255,255,255,115,  0,  0,  0,  0,  0,  0,  0,
/* 0x3290 */   2,  0,  0,  0,  5,  0,  0,  0,  9,  0,  0,  0,  0,  0,  0,  0,
/* 0x32a0 */ 130,  0,  0,  0,  0,  0,  0,  0,  4,  0,  0,  0, 34,  0,  0,  0,
/* 0x32b0 */ 252,255,255,255,255,255,255,255,140,  0,  0,  0,  0,  0,  0,  0,
/* 0x32c0 */   4,  0,  0,  0, 45,  0,  0,  0,252,255,255,255,255,255,255,255,
/* 0x32d0 */ 150,  0,  0,  0,  0,  0,  0,  0,  4,  0,  0,  0, 28,  0,  0,  0,
/* 0x32e0 */ 252,255,255,255,255,255,255,255,194,  0,  0,  0,  0,  0,  0,  0,
/* 0x32f0 */   4,  0,  0,  0, 30,  0,  0,  0,252,255,255,255,255,255,255,255,
/* 0x3300 */ 202,  0,  0,  0,  0,  0,  0,  0,  4,  0,  0,  0, 21,  0,  0,  0,
/* 0x3310 */ 252,255,255,255,255,255,255,255, 13,  0,  0,  0,  0,  0,  0,  0,
/* 0x3320 */   4,  0,  0,  0, 41,  0,  0,  0,252,255,255,255,255,255,255,255,
/* 0x3330 */  23,  0,  0,  0,  0,  0,  0,  0,  4,  0,  0,  0, 45,  0,  0,  0,
/* 0x3340 */ 252,255,255,255,255,255,255,255, 40,  1,  0,  0,  0,  0,  0,  0,
/* 0x3350 */   4,  0,  0,  0, 20,  0,  0,  0,252,255,255,255,255,255,255,255,
/* 0x3360 */  16,  2,  0,  0,  0,  0,  0,  0,  4,  0,  0,  0, 23,  0,  0,  0,
/* 0x3370 */ 252,255,255,255,255,255,255,255, 44,  2,  0,  0,  0,  0,  0,  0,
/* 0x3380 */   4,  0,  0,  0, 34,  0,  0,  0,252,255,255,255,255,255,255,255,
/* 0x3390 */  83,  2,  0,  0,  0,  0,  0,  0,  4,  0,  0,  0, 30,  0,  0,  0,
/* 0x33a0 */ 252,255,255,255,255,255,255,255, 93,  2,  0,  0,  0,  0,  0,  0,
/* 0x33b0 */   4,  0,  0,  0, 49,  0,  0,  0,252,255,255,255,255,255,255,255,
/* 0x33c0 */ 187,  2,  0,  0,  0,  0,  0,  0,  4,  0,  0,  0, 46,  0,  0,  0,
/* 0x33d0 */ 252,255,255,255,255,255,255,255,211,  2,  0,  0,  0,  0,  0,  0,
/* 0x33e0 */   4,  0,  0,  0, 37,  0,  0,  0,252,255,255,255,255,255,255,255,
/* 0x33f0 */ 225,  2,  0,  0,  0,  0,  0,  0,  4,  0,  0,  0, 49,  0,  0,  0,
/* 0x3400 */ 252,255,255,255,255,255,255,255,112,  3,  0,  0,  0,  0,  0,  0,
/* 0x3410 */   4,  0,  0,  0, 25,  0,  0,  0,252,255,255,255,255,255,255,255,
/* 0x3420 */ 147,  3,  0,  0,  0,  0,  0,  0,  4,  0,  0,  0, 30,  0,  0,  0,
/* 0x3430 */ 252,255,255,255,255,255,255,255,161,  3,  0,  0,  0,  0,  0,  0,
/* 0x3440 */   4,  0,  0,  0, 25,  0,  0,  0,252,255,255,255,255,255,255,255,
/* 0x3450 */ 198,  3,  0,  0,  0,  0,  0,  0,  4,  0,  0,  0, 30,  0,  0,  0,
/* 0x3460 */ 252,255,255,255,255,255,255,255, 79,  4,  0,  0,  0,  0,  0,  0,
/* 0x3470 */   4,  0,  0,  0, 27,  0,  0,  0,252,255,255,255,255,255,255,255,
/* 0x3480 */  90,  4,  0,  0,  0,  0,  0,  0,  4,  0,  0,  0, 44,  0,  0,  0,
/* 0x3490 */ 252,255,255,255,255,255,255,255, 98,  4,  0,  0,  0,  0,  0,  0,
/* 0x34a0 */   4,  0,  0,  0, 35,  0,  0,  0,252,255,255,255,255,255,255,255,
/* 0x34b0 */ 125,  4,  0,  0,  0,  0,  0,  0,  4,  0,  0,  0, 19,  0,  0,  0,
/* 0x34c0 */ 252,255,255,255,255,255,255,255,133,  4,  0,  0,  0,  0,  0,  0,
/* 0x34d0 */   4,  0,  0,  0, 49,  0,  0,  0,252,255,255,255,255,255,255,255,
/* 0x34e0 */ 143,  4,  0,  0,  0,  0,  0,  0,  4,  0,  0,  0, 35,  0,  0,  0,
/* 0x34f0 */ 252,255,255,255,255,255,255,255,161,  4,  0,  0,  0,  0,  0,  0,
/* 0x3500 */   4,  0,  0,  0, 42,  0,  0,  0,252,255,255,255,255,255,255,255,
/* 0x3510 */ 251,  4,  0,  0,  0,  0,  0,  0,  4,  0,  0,  0, 25,  0,  0,  0,
/* 0x3520 */ 252,255,255,255,255,255,255,255, 13,  5,  0,  0,  0,  0,  0,  0,
/* 0x3530 */   4,  0,  0,  0, 23,  0,  0,  0,252,255,255,255,255,255,255,255,
/* 0x3540 */  60,  5,  0,  0,  0,  0,  0,  0,  4,  0,  0,  0, 41,  0,  0,  0,
/* 0x3550 */ 252,255,255,255,255,255,255,255, 78,  5,  0,  0,  0,  0,  0,  0,
/* 0x3560 */   4,  0,  0,  0, 34,  0,  0,  0,252,255,255,255,255,255,255,255,
/* 0x3570 */   0,  6,  0,  0,  0,  0,  0,  0,  4,  0,  0,  0, 30,  0,  0,  0,
/* 0x3580 */ 252,255,255,255,255,255,255,255, 17,  6,  0,  0,  0,  0,  0,  0,
/* 0x3590 */   4,  0,  0,  0, 25,  0,  0,  0,252,255,255,255,255,255,255,255,
/* 0x35a0 */  84,  7,  0,  0,  0,  0,  0,  0,  4,  0,  0,  0, 33,  0,  0,  0,
/* 0x35b0 */ 252,255,255,255,255,255,255,255,176,  7,  0,  0,  0,  0,  0,  0,
/* 0x35c0 */   4,  0,  0,  0, 38,  0,  0,  0,252,255,255,255,255,255,255,255,
/* 0x35d0 */ 205,  7,  0,  0,  0,  0,  0,  0,  4,  0,  0,  0, 24,  0,  0,  0,
/* 0x35e0 */ 252,255,255,255,255,255,255,255,234,  7,  0,  0,  0,  0,  0,  0,
/* 0x35f0 */   4,  0,  0,  0, 44,  0,  0,  0,252,255,255,255,255,255,255,255,
/* 0x3600 */  35,  0,  0,  0,  0,  0,  0,  0,  2,  0,  0,  0, 50,  0,  0,  0,
/* 0x3610 */ 252,255,255,255,255,255,255,255, 52,  0,  0,  0,  0,  0,  0,  0,
/* 0x3620 */   2,  0,  0,  0,  1,  0,  0,  0,252,255,255,255,255,255,255,255,
/* 0x3630 */  73,  0,  0,  0,  0,  0,  0,  0,  2,  0,  0,  0,  1,  0,  0,  0,
/* 0x3640 */ 252,255,255,255,255,255,255,255,145,  0,  0,  0,  0,  0,  0,  0,
/* 0x3650 */   2,  0,  0,  0, 46,  0,  0,  0,252,255,255,255,255,255,255,255,
/* 0x3660 */ 223,  0,  0,  0,  0,  0,  0,  0,  2,  0,  0,  0,  2,  0,  0,  0,
/* 0x3670 */ 165,  0,  0,  0,  0,  0,  0,  0,116,  0,  0,  0,  0,  0,  0,  0,
/* 0x3680 */   2,  0,  0,  0,  4,  0,  0,  0,  4,  0,  0,  0,  0,  0,  0,  0,
/* 0x3690 */ 210,  0,  0,  0,  0,  0,  0,  0,  2,  0,  0,  0,  2,  0,  0,  0,
/* 0x36a0 */ 165,  0,  0,  0,  0,  0,  0,  0,116,  0,  0,  0,  0,  0,  0,  0,
/* 0x36b0 */   2,  0,  0,  0,  4,  0,  0,  0,  4,  0,  0,  0,  0,  0,  0,  0,
/* 0x36c0 */ 187,  0,  0,  0,  0,  0,  0,  0,  2,  0,  0,  0,  2,  0,  0,  0,
/* 0x36d0 */ 165,  0,  0,  0,  0,  0,  0,  0, 95,  0,  0,  0,  0,  0,  0,  0,
/* 0x36e0 */   2,  0,  0,  0,  4,  0,  0,  0,  4,  0,  0,  0,  0,  0,  0,  0,
/* 0x36f0 */   6,  0,  0,  0,  0,  0,  0,  0,  2,  0,  0,  0,  3,  0,  0,  0,
/* 0x3700 */  21,  0,  0,  0,  0,  0,  0,  0, 21,  0,  0,  0,  0,  0,  0,  0,
/* 0x3710 */   2,  0,  0,  0,  4,  0,  0,  0,  4,  0,  0,  0,  0,  0,  0,  0,
/* 0x3720 */ 102,105,108,101, 32,102,111,114,109, 97,116, 32,101,108,102, 54,
/* 0x3730 */  52, 45,120, 56, 54, 45, 54, 52, 10, 10, 83,101, 99,116,105,111,
/* 0x3740 */ 110,115, 58, 10, 73,100,120, 32, 78, 97,109,101, 32, 32, 32, 32,
/* 0x3750 */  32, 32, 32, 32, 32, 32, 83,105,122,101, 32, 32, 32, 32, 32, 32,
/* 0x3760 */  86, 77, 65, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x3770 */  32, 32, 76, 77, 65, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x3780 */  32, 32, 32, 32, 70,105,108,101, 32,111,102,102, 32, 32, 65,108,
/* 0x3790 */ 103,110, 32, 32, 70,108, 97,103,115, 10, 32, 32, 48, 32, 72, 85,
/* 0x37a0 */  77, 70, 95, 65, 32, 32, 32, 32, 32, 32, 32, 32, 48, 53, 32, 32,
/* 0x37b0 */  48, 32, 32, 48, 32, 32, 48, 52, 48, 32, 32, 50, 42, 42, 48, 32,
/* 0x37c0 */  32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 32, 49, 32, 72, 85,
/* 0x37d0 */  77, 70, 95, 76, 32, 32, 32, 32, 32, 32, 32, 32, 48, 53, 32, 32,
/* 0x37e0 */  48, 32, 32, 48, 32, 32, 48, 52, 53, 32, 32, 50, 42, 42, 48, 32,
/* 0x37f0 */  32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 32, 50, 32, 85, 77,
/* 0x3800 */  70, 95, 76, 73, 78, 85, 88, 32, 32, 32, 32, 32, 48,102, 57, 32,
/* 0x3810 */  32, 48, 32, 32, 48, 32, 32, 48, 52, 99, 32, 32, 50, 42, 42, 50,
/* 0x3820 */  32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 32, 51, 32, 83,
/* 0x3830 */  79, 95, 77, 65, 73, 78, 32, 32, 32, 32, 32, 32, 32, 48, 56, 49,
/* 0x3840 */  51, 32, 32, 48, 32, 32, 48, 32, 32, 48, 49, 53, 48, 32, 32, 50,
/* 0x3850 */  42, 42, 52, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 32,
/* 0x3860 */  52, 32, 83, 79, 95, 72, 69, 65, 68, 32, 32, 32, 32, 32, 32, 32,
/* 0x3870 */  48, 52, 52, 32, 32, 48, 32, 32, 48, 32, 32, 48, 57, 54, 51, 32,
/* 0x3880 */  32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10,
/* 0x3890 */  32, 32, 53, 32,112,116,114, 95, 78, 69, 88, 84, 32, 32, 32, 32,
/* 0x38a0 */  32, 32, 48, 32, 32, 48, 32, 32, 48, 32, 32, 48, 57, 97, 55, 32,
/* 0x38b0 */  32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10,
/* 0x38c0 */  32, 32, 54, 32, 83, 79, 95, 84, 65, 73, 76, 32, 32, 32, 32, 32,
/* 0x38d0 */  32, 32, 48, 99, 57, 32, 32, 48, 32, 32, 48, 32, 32, 48, 57, 97,
/* 0x38e0 */  55, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84,
/* 0x38f0 */  83, 10, 32, 32, 55, 32, 69, 88, 80, 95, 72, 69, 65, 68, 32, 32,
/* 0x3900 */  32, 32, 32, 32, 48,101, 57, 32, 32, 48, 32, 32, 48, 32, 32, 48,
/* 0x3910 */  97, 55, 48, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69,
/* 0x3920 */  78, 84, 83, 10, 32, 32, 56, 32, 78, 82, 86, 50, 69, 32, 32, 32,
/* 0x3930 */  32, 32, 32, 32, 32, 32, 48,101, 56, 32, 32, 48, 32, 32, 48, 32,
/* 0x3940 */  32, 48, 98, 53, 57, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78,
/* 0x3950 */  84, 69, 78, 84, 83, 10, 32, 32, 57, 32, 78, 82, 86, 50, 68, 32,
/* 0x3960 */  32, 32, 32, 32, 32, 32, 32, 32, 48,100, 98, 32, 32, 48, 32, 32,
/* 0x3970 */  48, 32, 32, 48, 99, 52, 49, 32, 32, 50, 42, 42, 48, 32, 32, 67,
/* 0x3980 */  79, 78, 84, 69, 78, 84, 83, 10, 32, 49, 48, 32, 78, 82, 86, 50,
/* 0x3990 */  66, 32, 32, 32, 32, 32, 32, 32, 32, 32, 48, 99, 52, 32, 32, 48,
/* 0x39a0 */  32, 32, 48, 32, 32, 48,100, 49, 99, 32, 32, 50, 42, 42, 48, 32,
/* 0x39b0 */  32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 49, 49, 32, 76, 90,
/* 0x39c0 */  77, 65, 95, 68, 65, 73, 83, 89, 32, 32, 32, 32, 48, 97, 32, 32,
/* 0x39d0 */  48, 32, 32, 48, 32, 32, 48,100,101, 48, 32, 32, 50, 42, 42, 48,
/* 0x39e0 */  32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 49, 50, 32, 76,
/* 0x39f0 */  90, 77, 65, 95, 69, 76, 70, 48, 48, 32, 32, 32, 32, 48, 54, 53,
/* 0x3a00 */  32, 32, 48, 32, 32, 48, 32, 32, 48,100,101, 97, 32, 32, 50, 42,
/* 0x3a10 */  42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 49, 51,
/* 0x3a20 */  32, 76, 90, 77, 65, 95, 68, 69, 67, 49, 48, 32, 32, 32, 32, 48,
/* 0x3a30 */  57,102, 55, 32, 32, 48, 32, 32, 48, 32, 32, 48,101, 52,102, 32,
/* 0x3a40 */  32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10,
/* 0x3a50 */  32, 49, 52, 32, 76, 90, 77, 65, 95, 68, 69, 67, 50, 48, 32, 32,
/* 0x3a60 */  32, 32, 48, 57,102, 55, 32, 32, 48, 32, 32, 48, 32, 32, 48, 49,
/* 0x3a70 */  56, 52, 54, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69,
/* 0x3a80 */  78, 84, 83, 10, 32, 49, 53, 32, 76, 90, 77, 65, 95, 68, 69, 67,
/* 0x3a90 */  51, 48, 32, 32, 32, 32, 48, 49, 57, 32, 32, 48, 32, 32, 48, 32,
/* 0x3aa0 */  32, 48, 50, 50, 51,100, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79,
/* 0x3ab0 */  78, 84, 69, 78, 84, 83, 10, 32, 49, 54, 32, 69, 88, 80, 95, 84,
/* 0x3ac0 */  65, 73, 76, 32, 32, 32, 32, 32, 32, 48, 49, 52, 32, 32, 48, 32,
/* 0x3ad0 */  32, 48, 32, 32, 48, 50, 50, 53, 56, 32, 32, 50, 42, 42, 50, 32,
/* 0x3ae0 */  32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 49, 55, 32, 83, 84,
/* 0x3af0 */  82, 67, 79, 78, 32, 32, 32, 32, 32, 32, 32, 32, 48, 52, 98, 32,
/* 0x3b00 */  32, 48, 32, 32, 48, 32, 32, 48, 50, 50, 54, 99, 32, 32, 50, 42,
/* 0x3b10 */  42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 83, 89, 77,
/* 0x3b20 */  66, 79, 76, 32, 84, 65, 66, 76, 69, 58, 10, 48, 48, 48, 48, 48,
/* 0x3b30 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32,
/* 0x3b40 */  32,100, 32, 32, 83, 79, 95, 72, 69, 65, 68, 32, 48, 32, 83, 79,
/* 0x3b50 */  95, 72, 69, 65, 68, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x3b60 */  48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 69,
/* 0x3b70 */  88, 80, 95, 72, 69, 65, 68, 32, 48, 32, 69, 88, 80, 95, 72, 69,
/* 0x3b80 */  65, 68, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x3b90 */  48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 76, 90, 77, 65,
/* 0x3ba0 */  95, 68, 69, 67, 51, 48, 32, 48, 32, 76, 90, 77, 65, 95, 68, 69,
/* 0x3bb0 */  67, 51, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x3bc0 */  48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 69, 88, 80,
/* 0x3bd0 */  95, 84, 65, 73, 76, 32, 48, 32, 69, 88, 80, 95, 84, 65, 73, 76,
/* 0x3be0 */  10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x3bf0 */  48, 32,108, 32, 32, 32, 32,100, 32, 32, 83, 84, 82, 67, 79, 78,
/* 0x3c00 */  32, 48, 32, 83, 84, 82, 67, 79, 78, 10, 48, 48, 48, 48, 48, 48,
/* 0x3c10 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,
/* 0x3c20 */ 100, 32, 32, 72, 85, 77, 70, 95, 65, 32, 48, 32, 72, 85, 77, 70,
/* 0x3c30 */  95, 65, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x3c40 */  48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 72, 85, 77, 70,
/* 0x3c50 */  95, 76, 32, 48, 32, 72, 85, 77, 70, 95, 76, 10, 48, 48, 48, 48,
/* 0x3c60 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32,
/* 0x3c70 */  32, 32,100, 32, 32, 85, 77, 70, 95, 76, 73, 78, 85, 88, 32, 48,
/* 0x3c80 */  32, 85, 77, 70, 95, 76, 73, 78, 85, 88, 10, 48, 48, 48, 48, 48,
/* 0x3c90 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32,
/* 0x3ca0 */  32,100, 32, 32, 83, 79, 95, 77, 65, 73, 78, 32, 48, 32, 83, 79,
/* 0x3cb0 */  95, 77, 65, 73, 78, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x3cc0 */  48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32,112,
/* 0x3cd0 */ 116,114, 95, 78, 69, 88, 84, 32, 48, 32,112,116,114, 95, 78, 69,
/* 0x3ce0 */  88, 84, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x3cf0 */  48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 83, 79, 95, 84,
/* 0x3d00 */  65, 73, 76, 32, 48, 32, 83, 79, 95, 84, 65, 73, 76, 10, 48, 48,
/* 0x3d10 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32,108,
/* 0x3d20 */  32, 32, 32, 32,100, 32, 32, 78, 82, 86, 50, 69, 32, 48, 32, 78,
/* 0x3d30 */  82, 86, 50, 69, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x3d40 */  48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 78, 82,
/* 0x3d50 */  86, 50, 68, 32, 48, 32, 78, 82, 86, 50, 68, 10, 48, 48, 48, 48,
/* 0x3d60 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32,
/* 0x3d70 */  32, 32,100, 32, 32, 78, 82, 86, 50, 66, 32, 48, 32, 78, 82, 86,
/* 0x3d80 */  50, 66, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x3d90 */  48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 76, 90, 77, 65,
/* 0x3da0 */  95, 68, 65, 73, 83, 89, 32, 48, 32, 76, 90, 77, 65, 95, 68, 65,
/* 0x3db0 */  73, 83, 89, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x3dc0 */  48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 76, 90, 77,
/* 0x3dd0 */  65, 95, 69, 76, 70, 48, 48, 32, 48, 32, 76, 90, 77, 65, 95, 69,
/* 0x3de0 */  76, 70, 48, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x3df0 */  48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 76, 90,
/* 0x3e00 */  77, 65, 95, 68, 69, 67, 49, 48, 32, 48, 32, 76, 90, 77, 65, 95,
/* 0x3e10 */  68, 69, 67, 49, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x3e20 */  48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 76,
/* 0x3e30 */  90, 77, 65, 95, 68, 69, 67, 50, 48, 32, 48, 32, 76, 90, 77, 65,
/* 0x3e40 */  95, 68, 69, 67, 50, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x3e50 */  48, 48, 48, 48, 48, 53, 98, 32,103, 32, 32, 32, 32, 32, 32, 32,
/* 0x3e60 */  83, 79, 95, 84, 65, 73, 76, 32, 48, 32, 80,109, 97,112, 10, 48,
/* 0x3e70 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32,
/* 0x3e80 */ 103, 32, 32, 32, 32, 32, 32, 32, 69, 88, 80, 95, 72, 69, 65, 68,
/* 0x3e90 */  32, 48, 32,102, 95,101,120,112, 97,110,100, 10, 48, 48, 48, 48,
/* 0x3ea0 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 51, 99, 32,103, 32, 32,
/* 0x3eb0 */  32, 32, 32, 32, 32, 83, 79, 95, 72, 69, 65, 68, 32, 48, 32,103,
/* 0x3ec0 */ 101,116, 95,112, 97,103,101, 95,109, 97,115,107, 10, 48, 48, 48,
/* 0x3ed0 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 97, 51, 32,103, 32,
/* 0x3ee0 */  32, 32, 32, 32, 32, 32, 83, 79, 95, 84, 65, 73, 76, 32, 48, 32,
/* 0x3ef0 */ 109,117,110,109, 97,112, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x3f00 */  48, 48, 48, 48, 48, 49, 52, 32,103, 32, 32, 32, 32, 32, 32, 32,
/* 0x3f10 */  69, 88, 80, 95, 84, 65, 73, 76, 32, 48, 32,117,112,120, 95,109,
/* 0x3f20 */ 109, 97,112, 95, 97,110,100, 95,102,100, 10, 48, 48, 48, 48, 48,
/* 0x3f30 */  48, 48, 48, 48, 48, 48, 48, 48, 52, 49, 55, 32,103, 32, 32, 32,
/* 0x3f40 */  32, 32, 70, 32, 83, 79, 95, 77, 65, 73, 78, 32, 48, 97, 99, 32,
/* 0x3f50 */ 102,105,110,105, 95, 83, 69, 76,105,110,117,120, 10, 48, 48, 48,
/* 0x3f60 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 49, 99, 32,103, 32,
/* 0x3f70 */  32, 32, 32, 32, 32, 32, 83, 79, 95, 84, 65, 73, 76, 32, 48, 32,
/* 0x3f80 */ 109,101,109, 99,112,121, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x3f90 */  48, 48, 48, 48, 48, 51, 49, 32,103, 32, 32, 32, 32, 32, 32, 32,
/* 0x3fa0 */  83, 79, 95, 84, 65, 73, 76, 32, 48, 32, 79, 95, 66, 73, 78, 70,
/* 0x3fb0 */  79, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x3fc0 */  51, 49, 32,103, 32, 32, 32, 32, 32, 32, 32, 83, 79, 95, 84, 65,
/* 0x3fd0 */  73, 76, 32, 48, 32, 80,115,121,110, 99, 10, 48, 48, 48, 48, 48,
/* 0x3fe0 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 97, 98, 32,103, 32, 32, 32,
/* 0x3ff0 */  32, 32, 32, 32, 83, 79, 95, 84, 65, 73, 76, 32, 48, 32,102,116,
/* 0x4000 */ 114,117,110, 99, 97,116,101, 10, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x4010 */  48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x4020 */  32, 42, 85, 78, 68, 42, 32, 48, 32,117,112,120, 95,109,109, 97,
/* 0x4030 */ 112, 95, 97,110,100, 95,102,100, 95, 97,110,100,114,111,105,100,
/* 0x4040 */  10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 54,
/* 0x4050 */  57, 32,103, 32, 32, 32, 32, 32, 32, 32, 83, 79, 95, 84, 65, 73,
/* 0x4060 */  76, 32, 48, 32,109,109, 97,112, 10, 48, 48, 48, 48, 48, 48, 48,
/* 0x4070 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 32,103, 32, 32, 32, 32, 32,
/* 0x4080 */  70, 32, 85, 77, 70, 95, 76, 73, 78, 85, 88, 32, 48,102, 57, 32,
/* 0x4090 */ 117,112,120, 95,109,109, 97,112, 95, 97,110,100, 95,102,100, 95,
/* 0x40a0 */ 108,105,110,117,120, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x40b0 */  48, 48, 48, 48, 48, 48, 32,103, 32, 32, 32, 32, 32, 70, 32, 83,
/* 0x40c0 */  79, 95, 84, 65, 73, 76, 32, 48, 32,101,111,102, 10, 48, 48, 48,
/* 0x40d0 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 52, 99, 51, 32,103, 32,
/* 0x40e0 */  32, 32, 32, 32, 70, 32, 83, 79, 95, 77, 65, 73, 78, 32, 48, 98,
/* 0x40f0 */  57, 32,112,114,101,112, 95, 83, 69, 76,105,110,117,120, 10, 48,
/* 0x4100 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 99, 49, 32,
/* 0x4110 */ 103, 32, 32, 32, 32, 32, 32, 32, 83, 79, 95, 84, 65, 73, 76, 32,
/* 0x4120 */  48, 32,119,114,105,116,101, 10, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x4130 */  48, 48, 48, 48, 48, 51,102, 97, 32,103, 32, 32, 32, 32, 32, 70,
/* 0x4140 */  32, 83, 79, 95, 77, 65, 73, 78, 32, 48, 49,100, 32, 80, 70, 95,
/* 0x4150 */ 116,111, 95, 80, 82, 79, 84, 10, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x4160 */  48, 48, 48, 48, 48, 48, 97,102, 32,103, 32, 32, 32, 32, 32, 32,
/* 0x4170 */  32, 83, 79, 95, 84, 65, 73, 76, 32, 48, 32,109,101,109,102,100,
/* 0x4180 */  95, 99,114,101, 97,116,101, 10, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x4190 */  48, 48, 48, 48, 48, 48, 99, 53, 32,103, 32, 32, 32, 32, 32, 32,
/* 0x41a0 */  32, 83, 79, 95, 84, 65, 73, 76, 32, 48, 32,114,101, 97,100, 10,
/* 0x41b0 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 49, 56, 52,
/* 0x41c0 */  32,103, 32, 32, 32, 32, 32, 70, 32, 83, 79, 95, 77, 65, 73, 78,
/* 0x41d0 */  32, 48,101,102, 32,109, 97,107,101, 95,104, 97,116, 99,104, 10,
/* 0x41e0 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 49, 51,
/* 0x41f0 */  32,103, 32, 32, 32, 32, 32, 32, 32, 83, 79, 95, 84, 65, 73, 76,
/* 0x4200 */  32, 48, 32,109,101,109,115,101,116, 10, 48, 48, 48, 48, 48, 48,
/* 0x4210 */  48, 48, 48, 48, 48, 48, 48, 48, 52, 50, 32,103, 32, 32, 32, 32,
/* 0x4220 */  32, 32, 32, 83, 79, 95, 84, 65, 73, 76, 32, 48, 32,109,115,121,
/* 0x4230 */ 110, 99, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x4240 */  48, 49, 49, 32,103, 32, 32, 32, 32, 32, 32, 32, 83, 79, 95, 84,
/* 0x4250 */  65, 73, 76, 32, 48, 32,109,121, 95, 98,107,112,116, 10, 48, 48,
/* 0x4260 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 52, 54, 32,103,
/* 0x4270 */  32, 32, 32, 32, 32, 32, 32, 83, 79, 95, 84, 65, 73, 76, 32, 48,
/* 0x4280 */  32, 80,112,114,111,116,101, 99,116, 10, 48, 48, 48, 48, 48, 48,
/* 0x4290 */  48, 48, 48, 48, 48, 48, 48, 48, 99, 49, 32,103, 32, 32, 32, 32,
/* 0x42a0 */  32, 32, 32, 83, 79, 95, 84, 65, 73, 76, 32, 48, 32, 80,119,114,
/* 0x42b0 */ 105,116,101, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x42c0 */  48, 48, 57, 53, 32,103, 32, 32, 32, 32, 32, 32, 32, 83, 79, 95,
/* 0x42d0 */  84, 65, 73, 76, 32, 48, 32, 80,117,110,109, 97,112, 10, 48, 48,
/* 0x42e0 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 97, 55, 32,103,
/* 0x42f0 */  32, 32, 32, 32, 32, 32, 32, 83, 79, 95, 84, 65, 73, 76, 32, 48,
/* 0x4300 */  32,101,120,105,116, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x4310 */  48, 48, 48, 48, 98, 97, 32,103, 32, 32, 32, 32, 32, 32, 32, 83,
/* 0x4320 */  79, 95, 84, 65, 73, 76, 32, 48, 32,111,112,101,110, 97,116, 10,
/* 0x4330 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 56, 48,
/* 0x4340 */  32,103, 32, 32, 32, 32, 32, 32, 32, 83, 79, 95, 84, 65, 73, 76,
/* 0x4350 */  32, 48, 32,111,112,101,110, 10, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x4360 */  48, 48, 48, 48, 48, 48, 53, 55, 32,103, 32, 32, 32, 32, 32, 32,
/* 0x4370 */  32, 83, 79, 95, 84, 65, 73, 76, 32, 48, 32,109,112,114,111,116,
/* 0x4380 */ 101, 99,116, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x4390 */  48, 48, 98, 54, 32,103, 32, 32, 32, 32, 32, 32, 32, 83, 79, 95,
/* 0x43a0 */  84, 65, 73, 76, 32, 48, 32, 99,108,111,115,101, 10, 48, 48, 48,
/* 0x43b0 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 53, 55, 99, 32,103, 32,
/* 0x43c0 */  32, 32, 32, 32, 70, 32, 83, 79, 95, 77, 65, 73, 78, 32, 48, 50,
/* 0x43d0 */  57, 55, 32,117,112,120, 95,115,111, 95,109, 97,105,110, 10, 10,
/* 0x43e0 */  82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82,
/* 0x43f0 */  68, 83, 32, 70, 79, 82, 32, 91, 72, 85, 77, 70, 95, 65, 93, 58,
/* 0x4400 */  10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x4410 */  32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x4420 */  32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48,
/* 0x4430 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 49, 32, 82, 95, 88, 56, 54,
/* 0x4440 */  95, 54, 52, 95, 80, 67, 51, 50, 32, 32, 32, 32, 32,117,112,120,
/* 0x4450 */  95,109,109, 97,112, 95, 97,110,100, 95,102,100, 95, 97,110,100,
/* 0x4460 */ 114,111,105,100, 43, 48,120,102,102,102,102,102,102,102,102,102,
/* 0x4470 */ 102,102,102,102,102,102, 99, 10, 10, 82, 69, 76, 79, 67, 65, 84,
/* 0x4480 */  73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32,
/* 0x4490 */  91, 72, 85, 77, 70, 95, 76, 93, 58, 10, 79, 70, 70, 83, 69, 84,
/* 0x44a0 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 84, 89, 80, 69, 32,
/* 0x44b0 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76,
/* 0x44c0 */  85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x44d0 */  48, 48, 49, 32, 82, 95, 88, 56, 54, 95, 54, 52, 95, 80, 67, 51,
/* 0x44e0 */  50, 32, 32, 32, 32, 32,117,112,120, 95,109,109, 97,112, 95, 97,
/* 0x44f0 */ 110,100, 95,102,100, 95,108,105,110,117,120, 43, 48,120,102,102,
/* 0x4500 */ 102,102,102,102,102,102,102,102,102,102,102,102,102, 99, 10, 10,
/* 0x4510 */  82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82,
/* 0x4520 */  68, 83, 32, 70, 79, 82, 32, 91, 85, 77, 70, 95, 76, 73, 78, 85,
/* 0x4530 */  88, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 32, 32, 32,
/* 0x4540 */  32, 32, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32,
/* 0x4550 */  32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48,
/* 0x4560 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 50, 49, 32, 82, 95,
/* 0x4570 */  88, 56, 54, 95, 54, 52, 95, 80, 67, 51, 50, 32, 32, 32, 32, 32,
/* 0x4580 */  83, 84, 82, 67, 79, 78, 43, 48,120,102,102,102,102,102,102,102,
/* 0x4590 */ 102,102,102,102,102,102,102,102, 99, 10, 48, 48, 48, 48, 48, 48,
/* 0x45a0 */  48, 48, 48, 48, 48, 48, 48, 48, 50,101, 32, 82, 95, 88, 56, 54,
/* 0x45b0 */  95, 54, 52, 95, 80, 76, 84, 51, 50, 32, 32, 32, 32,109,101,109,
/* 0x45c0 */ 102,100, 95, 99,114,101, 97,116,101, 43, 48,120,102,102,102,102,
/* 0x45d0 */ 102,102,102,102,102,102,102,102,102,102,102, 99, 10, 48, 48, 48,
/* 0x45e0 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 52, 50, 32, 82, 95,
/* 0x45f0 */  88, 56, 54, 95, 54, 52, 95, 80, 76, 84, 51, 50, 32, 32, 32, 32,
/* 0x4600 */ 109,101,109,102,100, 95, 99,114,101, 97,116,101, 43, 48,120,102,
/* 0x4610 */ 102,102,102,102,102,102,102,102,102,102,102,102,102,102, 99, 10,
/* 0x4620 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 52,102,
/* 0x4630 */  32, 82, 95, 88, 56, 54, 95, 54, 52, 95, 80, 67, 51, 50, 32, 32,
/* 0x4640 */  32, 32, 32, 83, 84, 82, 67, 79, 78, 10, 48, 48, 48, 48, 48, 48,
/* 0x4650 */  48, 48, 48, 48, 48, 48, 48, 48, 53,101, 32, 82, 95, 88, 56, 54,
/* 0x4660 */  95, 54, 52, 95, 80, 76, 84, 51, 50, 32, 32, 32, 32,111,112,101,
/* 0x4670 */ 110, 43, 48,120,102,102,102,102,102,102,102,102,102,102,102,102,
/* 0x4680 */ 102,102,102, 99, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x4690 */  48, 48, 48, 55, 51, 32, 82, 95, 88, 56, 54, 95, 54, 52, 95, 80,
/* 0x46a0 */  67, 51, 50, 32, 32, 32, 32, 32, 83, 84, 82, 67, 79, 78, 43, 48,
/* 0x46b0 */ 120, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x46c0 */  57, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x46d0 */  56, 50, 32, 82, 95, 88, 56, 54, 95, 54, 52, 95, 80, 76, 84, 51,
/* 0x46e0 */  50, 32, 32, 32, 32,119,114,105,116,101, 43, 48,120,102,102,102,
/* 0x46f0 */ 102,102,102,102,102,102,102,102,102,102,102,102, 99, 10, 48, 48,
/* 0x4700 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 56, 99, 32, 82,
/* 0x4710 */  95, 88, 56, 54, 95, 54, 52, 95, 80, 76, 84, 51, 50, 32, 32, 32,
/* 0x4720 */  32,101,120,105,116, 43, 48,120,102,102,102,102,102,102,102,102,
/* 0x4730 */ 102,102,102,102,102,102,102, 99, 10, 48, 48, 48, 48, 48, 48, 48,
/* 0x4740 */  48, 48, 48, 48, 48, 48, 48, 57, 54, 32, 82, 95, 88, 56, 54, 95,
/* 0x4750 */  54, 52, 95, 80, 76, 84, 51, 50, 32, 32, 32, 32,102,116,114,117,
/* 0x4760 */ 110, 99, 97,116,101, 43, 48,120,102,102,102,102,102,102,102,102,
/* 0x4770 */ 102,102,102,102,102,102,102, 99, 10, 48, 48, 48, 48, 48, 48, 48,
/* 0x4780 */  48, 48, 48, 48, 48, 48, 48, 99, 50, 32, 82, 95, 88, 56, 54, 95,
/* 0x4790 */  54, 52, 95, 80, 76, 84, 51, 50, 32, 32, 32, 32,109,109, 97,112,
/* 0x47a0 */  43, 48,120,102,102,102,102,102,102,102,102,102,102,102,102,102,
/* 0x47b0 */ 102,102, 99, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x47c0 */  48, 48, 99, 97, 32, 82, 95, 88, 56, 54, 95, 54, 52, 95, 80, 76,
/* 0x47d0 */  84, 51, 50, 32, 32, 32, 32,103,101,116, 95,112, 97,103,101, 95,
/* 0x47e0 */ 109, 97,115,107, 43, 48,120,102,102,102,102,102,102,102,102,102,
/* 0x47f0 */ 102,102,102,102,102,102, 99, 10, 10, 82, 69, 76, 79, 67, 65, 84,
/* 0x4800 */  73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32,
/* 0x4810 */  91, 83, 79, 95, 77, 65, 73, 78, 93, 58, 10, 79, 70, 70, 83, 69,
/* 0x4820 */  84, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 84, 89, 80, 69,
/* 0x4830 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65,
/* 0x4840 */  76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x4850 */  48, 48, 48,100, 32, 82, 95, 88, 56, 54, 95, 54, 52, 95, 80, 76,
/* 0x4860 */  84, 51, 50, 32, 32, 32, 32,109,121, 95, 98,107,112,116, 43, 48,
/* 0x4870 */ 120,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,
/* 0x4880 */  99, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x4890 */  49, 55, 32, 82, 95, 88, 56, 54, 95, 54, 52, 95, 80, 76, 84, 51,
/* 0x48a0 */  50, 32, 32, 32, 32,101,120,105,116, 43, 48,120,102,102,102,102,
/* 0x48b0 */ 102,102,102,102,102,102,102,102,102,102,102, 99, 10, 48, 48, 48,
/* 0x48c0 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 49, 50, 56, 32, 82, 95,
/* 0x48d0 */  88, 56, 54, 95, 54, 52, 95, 80, 76, 84, 51, 50, 32, 32, 32, 32,
/* 0x48e0 */ 102, 95,101,120,112, 97,110,100, 43, 48,120,102,102,102,102,102,
/* 0x48f0 */ 102,102,102,102,102,102,102,102,102,102, 99, 10, 48, 48, 48, 48,
/* 0x4900 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 50, 49, 48, 32, 82, 95, 88,
/* 0x4910 */  56, 54, 95, 54, 52, 95, 80, 76, 84, 51, 50, 32, 32, 32, 32,117,
/* 0x4920 */ 112,120, 95,109,109, 97,112, 95, 97,110,100, 95,102,100, 43, 48,
/* 0x4930 */ 120,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,
/* 0x4940 */  99, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 50,
/* 0x4950 */  50, 99, 32, 82, 95, 88, 56, 54, 95, 54, 52, 95, 80, 76, 84, 51,
/* 0x4960 */  50, 32, 32, 32, 32,119,114,105,116,101, 43, 48,120,102,102,102,
/* 0x4970 */ 102,102,102,102,102,102,102,102,102,102,102,102, 99, 10, 48, 48,
/* 0x4980 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 50, 53, 51, 32, 82,
/* 0x4990 */  95, 88, 56, 54, 95, 54, 52, 95, 80, 76, 84, 51, 50, 32, 32, 32,
/* 0x49a0 */  32,109,109, 97,112, 43, 48,120,102,102,102,102,102,102,102,102,
/* 0x49b0 */ 102,102,102,102,102,102,102, 99, 10, 48, 48, 48, 48, 48, 48, 48,
/* 0x49c0 */  48, 48, 48, 48, 48, 48, 50, 53,100, 32, 82, 95, 88, 56, 54, 95,
/* 0x49d0 */  54, 52, 95, 80, 76, 84, 51, 50, 32, 32, 32, 32, 99,108,111,115,
/* 0x49e0 */ 101, 43, 48,120,102,102,102,102,102,102,102,102,102,102,102,102,
/* 0x49f0 */ 102,102,102, 99, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x4a00 */  48, 48, 50, 98, 98, 32, 82, 95, 88, 56, 54, 95, 54, 52, 95, 80,
/* 0x4a10 */  76, 84, 51, 50, 32, 32, 32, 32,111,112,101,110, 97,116, 43, 48,
/* 0x4a20 */ 120,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,
/* 0x4a30 */  99, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 50,
/* 0x4a40 */ 100, 51, 32, 82, 95, 88, 56, 54, 95, 54, 52, 95, 80, 76, 84, 51,
/* 0x4a50 */  50, 32, 32, 32, 32,114,101, 97,100, 43, 48,120,102,102,102,102,
/* 0x4a60 */ 102,102,102,102,102,102,102,102,102,102,102, 99, 10, 48, 48, 48,
/* 0x4a70 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 50,101, 49, 32, 82, 95,
/* 0x4a80 */  88, 56, 54, 95, 54, 52, 95, 80, 76, 84, 51, 50, 32, 32, 32, 32,
/* 0x4a90 */  99,108,111,115,101, 43, 48,120,102,102,102,102,102,102,102,102,
/* 0x4aa0 */ 102,102,102,102,102,102,102, 99, 10, 48, 48, 48, 48, 48, 48, 48,
/* 0x4ab0 */  48, 48, 48, 48, 48, 48, 51, 55, 48, 32, 82, 95, 88, 56, 54, 95,
/* 0x4ac0 */  54, 52, 95, 80, 76, 84, 51, 50, 32, 32, 32, 32,109,101,109, 99,
/* 0x4ad0 */ 112,121, 43, 48,120,102,102,102,102,102,102,102,102,102,102,102,
/* 0x4ae0 */ 102,102,102,102, 99, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x4af0 */  48, 48, 48, 51, 57, 51, 32, 82, 95, 88, 56, 54, 95, 54, 52, 95,
/* 0x4b00 */  80, 76, 84, 51, 50, 32, 32, 32, 32,109,109, 97,112, 43, 48,120,
/* 0x4b10 */ 102,102,102,102,102,102,102,102,102,102,102,102,102,102,102, 99,
/* 0x4b20 */  10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 51, 97,
/* 0x4b30 */  49, 32, 82, 95, 88, 56, 54, 95, 54, 52, 95, 80, 76, 84, 51, 50,
/* 0x4b40 */  32, 32, 32, 32,109,101,109, 99,112,121, 43, 48,120,102,102,102,
/* 0x4b50 */ 102,102,102,102,102,102,102,102,102,102,102,102, 99, 10, 48, 48,
/* 0x4b60 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 51, 99, 54, 32, 82,
/* 0x4b70 */  95, 88, 56, 54, 95, 54, 52, 95, 80, 76, 84, 51, 50, 32, 32, 32,
/* 0x4b80 */  32,109,109, 97,112, 43, 48,120,102,102,102,102,102,102,102,102,
/* 0x4b90 */ 102,102,102,102,102,102,102, 99, 10, 48, 48, 48, 48, 48, 48, 48,
/* 0x4ba0 */  48, 48, 48, 48, 48, 48, 52, 52,102, 32, 82, 95, 88, 56, 54, 95,
/* 0x4bb0 */  54, 52, 95, 80, 76, 84, 51, 50, 32, 32, 32, 32, 80,115,121,110,
/* 0x4bc0 */  99, 43, 48,120,102,102,102,102,102,102,102,102,102,102,102,102,
/* 0x4bd0 */ 102,102,102, 99, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x4be0 */  48, 48, 52, 53, 97, 32, 82, 95, 88, 56, 54, 95, 54, 52, 95, 80,
/* 0x4bf0 */  76, 84, 51, 50, 32, 32, 32, 32, 80,117,110,109, 97,112, 43, 48,
/* 0x4c00 */ 120,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,
/* 0x4c10 */  99, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 52,
/* 0x4c20 */  54, 50, 32, 82, 95, 88, 56, 54, 95, 54, 52, 95, 80, 76, 84, 51,
/* 0x4c30 */  50, 32, 32, 32, 32, 80, 70, 95,116,111, 95, 80, 82, 79, 84, 43,
/* 0x4c40 */  48,120,102,102,102,102,102,102,102,102,102,102,102,102,102,102,
/* 0x4c50 */ 102, 99, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x4c60 */  52, 55,100, 32, 82, 95, 88, 56, 54, 95, 54, 52, 95, 80, 76, 84,
/* 0x4c70 */  51, 50, 32, 32, 32, 32, 80,109, 97,112, 43, 48,120,102,102,102,
/* 0x4c80 */ 102,102,102,102,102,102,102,102,102,102,102,102, 99, 10, 48, 48,
/* 0x4c90 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 52, 56, 53, 32, 82,
/* 0x4ca0 */  95, 88, 56, 54, 95, 54, 52, 95, 80, 76, 84, 51, 50, 32, 32, 32,
/* 0x4cb0 */  32, 99,108,111,115,101, 43, 48,120,102,102,102,102,102,102,102,
/* 0x4cc0 */ 102,102,102,102,102,102,102,102, 99, 10, 48, 48, 48, 48, 48, 48,
/* 0x4cd0 */  48, 48, 48, 48, 48, 48, 48, 52, 56,102, 32, 82, 95, 88, 56, 54,
/* 0x4ce0 */  95, 54, 52, 95, 80, 76, 84, 51, 50, 32, 32, 32, 32, 80, 70, 95,
/* 0x4cf0 */ 116,111, 95, 80, 82, 79, 84, 43, 48,120,102,102,102,102,102,102,
/* 0x4d00 */ 102,102,102,102,102,102,102,102,102, 99, 10, 48, 48, 48, 48, 48,
/* 0x4d10 */  48, 48, 48, 48, 48, 48, 48, 48, 52, 97, 49, 32, 82, 95, 88, 56,
/* 0x4d20 */  54, 95, 54, 52, 95, 80, 76, 84, 51, 50, 32, 32, 32, 32, 80,112,
/* 0x4d30 */ 114,111,116,101, 99,116, 43, 48,120,102,102,102,102,102,102,102,
/* 0x4d40 */ 102,102,102,102,102,102,102,102, 99, 10, 48, 48, 48, 48, 48, 48,
/* 0x4d50 */  48, 48, 48, 48, 48, 48, 48, 52,102, 98, 32, 82, 95, 88, 56, 54,
/* 0x4d60 */  95, 54, 52, 95, 80, 76, 84, 51, 50, 32, 32, 32, 32,109,101,109,
/* 0x4d70 */  99,112,121, 43, 48,120,102,102,102,102,102,102,102,102,102,102,
/* 0x4d80 */ 102,102,102,102,102, 99, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x4d90 */  48, 48, 48, 48, 53, 48,100, 32, 82, 95, 88, 56, 54, 95, 54, 52,
/* 0x4da0 */  95, 80, 76, 84, 51, 50, 32, 32, 32, 32,117,112,120, 95,109,109,
/* 0x4db0 */  97,112, 95, 97,110,100, 95,102,100, 43, 48,120,102,102,102,102,
/* 0x4dc0 */ 102,102,102,102,102,102,102,102,102,102,102, 99, 10, 48, 48, 48,
/* 0x4dd0 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 53, 51, 99, 32, 82, 95,
/* 0x4de0 */  88, 56, 54, 95, 54, 52, 95, 80, 76, 84, 51, 50, 32, 32, 32, 32,
/* 0x4df0 */ 109,121, 95, 98,107,112,116, 43, 48,120,102,102,102,102,102,102,
/* 0x4e00 */ 102,102,102,102,102,102,102,102,102, 99, 10, 48, 48, 48, 48, 48,
/* 0x4e10 */  48, 48, 48, 48, 48, 48, 48, 48, 53, 52,101, 32, 82, 95, 88, 56,
/* 0x4e20 */  54, 95, 54, 52, 95, 80, 76, 84, 51, 50, 32, 32, 32, 32,119,114,
/* 0x4e30 */ 105,116,101, 43, 48,120,102,102,102,102,102,102,102,102,102,102,
/* 0x4e40 */ 102,102,102,102,102, 99, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x4e50 */  48, 48, 48, 48, 54, 48, 48, 32, 82, 95, 88, 56, 54, 95, 54, 52,
/* 0x4e60 */  95, 80, 76, 84, 51, 50, 32, 32, 32, 32,109,109, 97,112, 43, 48,
/* 0x4e70 */ 120,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,
/* 0x4e80 */  99, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 54,
/* 0x4e90 */  49, 49, 32, 82, 95, 88, 56, 54, 95, 54, 52, 95, 80, 76, 84, 51,
/* 0x4ea0 */  50, 32, 32, 32, 32,109,101,109, 99,112,121, 43, 48,120,102,102,
/* 0x4eb0 */ 102,102,102,102,102,102,102,102,102,102,102,102,102, 99, 10, 48,
/* 0x4ec0 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 55, 53, 52, 32,
/* 0x4ed0 */  82, 95, 88, 56, 54, 95, 54, 52, 95, 80, 76, 84, 51, 50, 32, 32,
/* 0x4ee0 */  32, 32,112,114,101,112, 95, 83, 69, 76,105,110,117,120, 43, 48,
/* 0x4ef0 */ 120,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,
/* 0x4f00 */  99, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 55,
/* 0x4f10 */  98, 48, 32, 82, 95, 88, 56, 54, 95, 54, 52, 95, 80, 76, 84, 51,
/* 0x4f20 */  50, 32, 32, 32, 32,109, 97,107,101, 95,104, 97,116, 99,104, 43,
/* 0x4f30 */  48,120,102,102,102,102,102,102,102,102,102,102,102,102,102,102,
/* 0x4f40 */ 102, 99, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x4f50 */  55, 99,100, 32, 82, 95, 88, 56, 54, 95, 54, 52, 95, 80, 76, 84,
/* 0x4f60 */  51, 50, 32, 32, 32, 32,102,105,110,105, 95, 83, 69, 76,105,110,
/* 0x4f70 */ 117,120, 43, 48,120,102,102,102,102,102,102,102,102,102,102,102,
/* 0x4f80 */ 102,102,102,102, 99, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x4f90 */  48, 48, 48, 55,101, 97, 32, 82, 95, 88, 56, 54, 95, 54, 52, 95,
/* 0x4fa0 */  80, 76, 84, 51, 50, 32, 32, 32, 32, 80,117,110,109, 97,112, 43,
/* 0x4fb0 */  48,120,102,102,102,102,102,102,102,102,102,102,102,102,102,102,
/* 0x4fc0 */ 102, 99, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82,
/* 0x4fd0 */  69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 83, 79, 95, 72,
/* 0x4fe0 */  69, 65, 68, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 32,
/* 0x4ff0 */  32, 32, 32, 32, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32,
/* 0x5000 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48,
/* 0x5010 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 50, 51, 32,
/* 0x5020 */  82, 95, 88, 56, 54, 95, 54, 52, 95, 80, 67, 51, 50, 32, 32, 32,
/* 0x5030 */  32, 32,117,112,120, 95,115,111, 95,109, 97,105,110, 43, 48,120,
/* 0x5040 */ 102,102,102,102,102,102,102,102,102,102,102,102,102,102,102, 99,
/* 0x5050 */  10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67,
/* 0x5060 */  79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 83, 79, 95, 84, 65, 73,
/* 0x5070 */  76, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 32, 32, 32,
/* 0x5080 */  32, 32, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32,
/* 0x5090 */  32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48,
/* 0x50a0 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 51, 52, 32, 82, 95,
/* 0x50b0 */  88, 56, 54, 95, 54, 52, 95, 80, 67, 51, 50, 32, 32, 32, 32, 32,
/* 0x50c0 */  83, 79, 95, 72, 69, 65, 68, 43, 48,120,102,102,102,102,102,102,
/* 0x50d0 */ 102,102,102,102,102,102,102,102,102, 99, 10, 48, 48, 48, 48, 48,
/* 0x50e0 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 52, 57, 32, 82, 95, 88, 56,
/* 0x50f0 */  54, 95, 54, 52, 95, 80, 67, 51, 50, 32, 32, 32, 32, 32, 83, 79,
/* 0x5100 */  95, 72, 69, 65, 68, 43, 48,120,102,102,102,102,102,102,102,102,
/* 0x5110 */ 102,102,102,102,102,102,102, 99, 10, 48, 48, 48, 48, 48, 48, 48,
/* 0x5120 */  48, 48, 48, 48, 48, 48, 48, 57, 49, 32, 82, 95, 88, 56, 54, 95,
/* 0x5130 */  54, 52, 95, 80, 67, 51, 50, 32, 32, 32, 32, 32,111,112,101,110,
/* 0x5140 */  97,116, 43, 48,120,102,102,102,102,102,102,102,102,102,102,102,
/* 0x5150 */ 102,102,102,102, 99, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79,
/* 0x5160 */  78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 78,
/* 0x5170 */  82, 86, 50, 69, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32,
/* 0x5180 */  32, 32, 32, 32, 32, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32,
/* 0x5190 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10,
/* 0x51a0 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,100,102,
/* 0x51b0 */  32, 82, 95, 88, 56, 54, 95, 54, 52, 95, 80, 67, 51, 50, 32, 32,
/* 0x51c0 */  32, 32, 32, 69, 88, 80, 95, 72, 69, 65, 68, 43, 48,120, 48, 48,
/* 0x51d0 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 97, 53, 10, 48,
/* 0x51e0 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 55, 52, 32,
/* 0x51f0 */  82, 95, 88, 56, 54, 95, 54, 52, 95, 80, 67, 51, 50, 32, 32, 32,
/* 0x5200 */  32, 32, 69, 88, 80, 95, 84, 65, 73, 76, 43, 48,120, 48, 48, 48,
/* 0x5210 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 52, 10, 10, 82,
/* 0x5220 */  69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68,
/* 0x5230 */  83, 32, 70, 79, 82, 32, 91, 78, 82, 86, 50, 68, 93, 58, 10, 79,
/* 0x5240 */  70, 70, 83, 69, 84, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x5250 */  84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x5260 */  32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x5270 */  48, 48, 48, 48, 48, 48,100, 50, 32, 82, 95, 88, 56, 54, 95, 54,
/* 0x5280 */  52, 95, 80, 67, 51, 50, 32, 32, 32, 32, 32, 69, 88, 80, 95, 72,
/* 0x5290 */  69, 65, 68, 43, 48,120, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x52a0 */  48, 48, 48, 48, 97, 53, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x52b0 */  48, 48, 48, 48, 48, 55, 52, 32, 82, 95, 88, 56, 54, 95, 54, 52,
/* 0x52c0 */  95, 80, 67, 51, 50, 32, 32, 32, 32, 32, 69, 88, 80, 95, 84, 65,
/* 0x52d0 */  73, 76, 43, 48,120, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x52e0 */  48, 48, 48, 48, 52, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79,
/* 0x52f0 */  78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 78,
/* 0x5300 */  82, 86, 50, 66, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32,
/* 0x5310 */  32, 32, 32, 32, 32, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32,
/* 0x5320 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10,
/* 0x5330 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 98, 98,
/* 0x5340 */  32, 82, 95, 88, 56, 54, 95, 54, 52, 95, 80, 67, 51, 50, 32, 32,
/* 0x5350 */  32, 32, 32, 69, 88, 80, 95, 72, 69, 65, 68, 43, 48,120, 48, 48,
/* 0x5360 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 97, 53, 10, 48,
/* 0x5370 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 53,102, 32,
/* 0x5380 */  82, 95, 88, 56, 54, 95, 54, 52, 95, 80, 67, 51, 50, 32, 32, 32,
/* 0x5390 */  32, 32, 69, 88, 80, 95, 84, 65, 73, 76, 43, 48,120, 48, 48, 48,
/* 0x53a0 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 52, 10, 10, 82,
/* 0x53b0 */  69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68,
/* 0x53c0 */  83, 32, 70, 79, 82, 32, 91, 76, 90, 77, 65, 95, 68, 65, 73, 83,
/* 0x53d0 */  89, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 32, 32, 32,
/* 0x53e0 */  32, 32, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32,
/* 0x53f0 */  32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48,
/* 0x5400 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 54, 32, 82, 95,
/* 0x5410 */  88, 56, 54, 95, 54, 52, 95, 80, 67, 51, 50, 32, 32, 32, 32, 32,
/* 0x5420 */  76, 90, 77, 65, 95, 68, 69, 67, 51, 48, 43, 48,120, 48, 48, 48,
/* 0x5430 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 49, 53, 10, 10, 82,
/* 0x5440 */  69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68,
/* 0x5450 */  83, 32, 70, 79, 82, 32, 91, 76, 90, 77, 65, 95, 68, 69, 67, 51,
/* 0x5460 */  48, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 32, 32, 32,
/* 0x5470 */  32, 32, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32,
/* 0x5480 */  32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48,
/* 0x5490 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 49, 53, 32, 82, 95,
/* 0x54a0 */  88, 56, 54, 95, 54, 52, 95, 80, 67, 51, 50, 32, 32, 32, 32, 32,
/* 0x54b0 */  69, 88, 80, 95, 84, 65, 73, 76, 43, 48,120, 48, 48, 48, 48, 48,
/* 0x54c0 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 52, 10
};
