/* amd64-linux.elf-fold.h
   created from amd64-linux.elf-fold.bin, 21038 (0x522e) bytes

   This file is part of the UPX executable compressor.

   Copyright (C) 1996-2025 Markus Franz Xaver Johannes Oberhumer
   Copyright (C) 1996-2025 Laszlo Molnar
   Copyright (C) 2000-2025 John F. Reiser
   All Rights Reserved.

   UPX and the UCL library are free software; you can redistribute them
   and/or modify them under the terms of the GNU General Public License as
   published by the Free Software Foundation; either version 2 of
   the License, or (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; see the file COPYING.
   If not, write to the Free Software Foundation, Inc.,
   59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

   Markus F.X.J. Oberhumer              Laszlo Molnar
   <markus@oberhumer.com>               <ezerotven+github@gmail.com>

   John F. Reiser
   <jreiser@users.sourceforge.net>
 */

/* clang-format off */

#define STUB_AMD64_LINUX_ELF_FOLD_SIZE    21038
#define STUB_AMD64_LINUX_ELF_FOLD_ADLER32 0x9590fb2b
#define STUB_AMD64_LINUX_ELF_FOLD_CRC32   0x8a98d9c6

unsigned char stub_amd64_linux_elf_fold[21038] = {
/* 0x0000 */ 127, 69, 76, 70,  2,  1,  1,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0010 */   1,  0, 62,  0,  1,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0020 */   0,  0,  0,  0,  0,  0,  0,  0,248, 36,  0,  0,  0,  0,  0,  0,
/* 0x0030 */   0,  0,  0,  0, 64,  0,  0,  0,  0,  0, 64,  0, 26,  0, 23,  0,
/* 0x0040 */   0,240,255,255,255,255,255,255,243, 15, 30,250, 76,137,109, 48,
/* 0x0050 */  76,137,232,131,224,  1,  9, 69, 16, 72,137,230,246, 69, 48,  2,
/* 0x0060 */ 117,  7, 72,129,236,  0, 16,  0,  0, 72,137,231,106,  8, 89,243,
/* 0x0070 */  72,165, 72,131, 62,  0, 72,165,117,248, 73,137,254,246, 69, 48,
/* 0x0080 */   2,117,  2, 72,171, 72,131, 62,  0, 72,165,117,248, 73,137,252,
/* 0x0090 */  72,137,249, 72,131, 62,  0, 72,165, 72,165,117,246, 73,137,255,
/* 0x00a0 */  73,137,245, 73, 41,252,246, 69, 48,  2,116,  8,131,205,255, 73,
/* 0x00b0 */ 137,254,235,114, 87, 72,141, 61,  0,  0,  0,  0, 41,246,232,  0,
/* 0x00c0 */   0,  0,  0,137,197, 94,186,255, 15,  0,  0,106, 89, 88, 15,  5,
/* 0x00d0 */ 133,192,121,  5, 87, 94,106, 15, 88,145,253, 73,141,125,255,176,
/* 0x00e0 */   0,170, 72,141,116, 14,255,243,164, 72,131,239,  3,199,  7, 32,
/* 0x00f0 */  32, 32, 61, 73,137, 62, 72,131,231,248, 76,137,249, 72, 41,225,
/* 0x0100 */  72,131,239,  8, 73,141,119,248,137,248, 49,240,131,224,  8, 72,
/* 0x0110 */  41,199, 73,137,254, 72,193,233,  3,243, 72,165, 72,141,103,  8,
/* 0x0120 */ 252, 75,141, 76, 38,  8, 95, 94, 72,131,231,252, 65, 88, 68,137,
/* 0x0130 */ 192,131,224,  1, 72,  9,193, 73, 41,192, 77,137,197, 72,129,236,
/* 0x0140 */   0,  8,  0,  0, 72,137,226,232,  0,  0,  0,  0, 72,129,196,  0,
/* 0x0150 */   8,  0,  0,137,235, 72,137, 68, 36, 24, 73,139,181,160,  0,  0,
/* 0x0160 */   0, 76,137,239,232,  0,  0,  0,  0, 76,137,239,232,  0,  0,  0,
/* 0x0170 */   0,133,219,120, 31, 77, 41,201, 65,137,216,106,  2, 89,106,  1,
/* 0x0180 */  90,190,  0, 16,  0,  0, 41,255,232,  0,  0,  0,  0,137,223,232,
/* 0x0190 */   0,  0,  0,  0, 95, 94,106, 11, 88, 62, 65,255, 38, 72,139,  5,
/* 0x01a0 */ 156,254,255,255,195,  0,  0,  0, 81, 72, 57, 23, 76,139, 71,  8,
/* 0x01b0 */  72,141, 74,255,115, 10,191,127,  0,  0,  0,232,  0,  0,  0,  0,
/* 0x01c0 */  72,131,249,255,116, 17, 65, 15,182,  0, 72,255,201, 73,255,192,
/* 0x01d0 */ 136,  6, 72,255,198,235,233, 72,  1, 87,  8, 72, 41, 23, 88,195,
/* 0x01e0 */  85, 72,137,245, 83, 72,137,251, 72,131,236, 40, 72,131, 62,  0,
/* 0x01f0 */  15,132,176,  0,  0,  0, 72,141,116, 36, 16,186, 12,  0,  0,  0,
/* 0x0200 */  72,137,223,232,160,255,255,255,139, 68, 36, 16,139, 84, 36, 20,
/* 0x0210 */ 133,192,117, 20,129,250, 85, 80, 88, 33,117, 16, 72,131, 59,  0,
/* 0x0220 */  15,132,128,  0,  0,  0,235,  4,133,210,117, 10,191,127,  0,  0,
/* 0x0230 */   0,232,  0,  0,  0,  0, 57,194,119,242,137,193, 72, 59, 77,  0,
/* 0x0240 */ 119,234, 57,194, 72,139,117,  8,115, 51, 72,139,123,  8, 72,141,
/* 0x0250 */  84, 36,  8, 72,137, 76, 36,  8, 72,131,239, 12,232,  0,  0,  0,
/* 0x0260 */   0,133,192,117,199,139, 68, 36, 16, 72, 57, 68, 36,  8,117,188,
/* 0x0270 */ 139, 68, 36, 20, 72,  1, 67,  8, 72, 41,  3,235, 14, 72,131,  3,
/* 0x0280 */  12,137,210, 72,137,223,232, 29,255,255,255,139, 84, 36, 16, 72,
/* 0x0290 */ 139, 69,  0, 72,  1, 85,  8, 72, 41,208, 72,133,192, 72,137, 69,
/* 0x02a0 */   0,233, 74,255,255,255, 72,131,196, 40, 91, 93,195, 72,133,255,
/* 0x02b0 */  65, 80,116, 80, 64,246,199,  1,117, 74, 69, 49,192, 49,201, 72,
/* 0x02c0 */ 139,  7, 65,137,241, 76, 57,200,117,  8,255,193, 72,137, 87,  8,
/* 0x02d0 */ 235, 11, 72,131,248,  1,117,  5, 73,137,248,235, 33, 72,133,192,
/* 0x02e0 */ 117, 28,133,201,117, 30, 77,133,192,116,  9, 77,137,  8, 73,137,
/* 0x02f0 */  80,  8,235, 16,191,127,  0,  0,  0,232,  0,  0,  0,  0, 72,131,
/* 0x0300 */ 199, 16,235,187, 94,195, 65, 84, 65,137,248, 73,137,244,252, 83,
/* 0x0310 */ 137,211, 69, 49,201, 72,137,217,186,  3,  0,  0,  0, 72,129,236,
/* 0x0320 */   8, 16,  0,  0, 72,137,231,243,164, 68,137,198, 76,137,231, 65,
/* 0x0330 */ 131,200,255,177, 50,232,  0,  0,  0,  0, 72,137,230, 76,137,231,
/* 0x0340 */  72,137,217,252,243,164, 72,129,196,  8, 16,  0,  0, 91, 65, 92,
/* 0x0350 */ 195, 65, 87, 65, 86, 73,137,254, 65, 85, 65, 84, 85, 83, 72,129,
/* 0x0360 */ 236,152,  0,  0,  0, 76,  3,119, 32, 72,133,246, 76,137, 68, 36,
/* 0x0370 */  64, 72,137,124, 36, 96, 72,137,116, 36, 88,137, 84, 36, 84, 72,
/* 0x0380 */ 137, 76, 36, 72, 72,199, 68, 36,104,  0,  0,  0,  0, 72,199, 68,
/* 0x0390 */  36, 56,  0,  0,  0,  0, 68, 15,183, 71, 16,116, 63, 72,139, 84,
/* 0x03a0 */  36, 64, 72,139, 10, 72,141, 81, 64, 72,139,122, 16, 72,139,114,
/* 0x03b0 */  40, 72,141,  4, 57, 72,  1,240,102, 65,131,248,  3, 72,137, 68,
/* 0x03c0 */  36,104,117,  9, 72, 43, 74, 72, 72,137, 76, 36, 56, 72,  3,124,
/* 0x03d0 */  36, 56,232,  0,  0,  0,  0,233, 45,  1,  0,  0,102, 65,131,248,
/* 0x03e0 */   3,184,  0,  0,  0,  0, 65,186, 16,  0,  0,  0, 68, 15, 68,208,
/* 0x03f0 */  72,139, 68, 36, 96, 72,199, 68, 36, 48,  0, 16,  0,  0, 68,137,
/* 0x0400 */  84, 36,  8, 73,131,207,255, 69, 49,228, 76,137,243, 15,183,104,
/* 0x0410 */  56,232,  0,  0,  0,  0, 68,139, 84, 36,  8, 72,137,193,255,205,
/* 0x0420 */ 120, 64,131, 59,  1,117, 51, 72,139, 83, 40, 72,133,210,116, 42,
/* 0x0430 */  72,139, 67, 16, 76, 57,248, 76, 15, 66,248, 72,141,  4,  2, 73,
/* 0x0440 */  57,196, 76, 15, 66,224, 72,139, 67, 48, 72, 57, 68, 36, 48, 72,
/* 0x0450 */  15, 67, 68, 36, 48, 72,137, 68, 36, 48, 72,131,195, 56,255,205,
/* 0x0460 */ 235,190, 73, 33,207, 72,137,202, 73,137,205, 72,247,218, 77, 41,
/* 0x0470 */ 252,187,  1,  0,  0,  0, 73,141, 68, 20,255, 73, 33,197, 72, 59,
/* 0x0480 */  84, 36, 48,115, 15,  1,219,137,216, 72, 15,175,194, 72, 59, 68,
/* 0x0490 */  36, 48,235,239,255,203, 65,131,202, 34, 69, 49,201,137,216, 65,
/* 0x04a0 */ 131,200,255, 68,137,209, 15,175,194, 76,137,255, 49,210, 70,141,
/* 0x04b0 */  36, 40, 68,137,230,232,  0,  0,  0,  0,133,219, 72,137,197,116,
/* 0x04c0 */  54, 72,139, 84, 36, 48, 72,247,216, 72,255,202, 72,137,211, 72,
/* 0x04d0 */  33,195,116, 17, 72,137,239, 72,137,222, 72,  1,221, 65, 41,220,
/* 0x04e0 */ 232,  0,  0,  0,  0, 69, 41,236,116, 13, 74,141,124, 45,  0, 68,
/* 0x04f0 */ 137,230,232,  0,  0,  0,  0, 73,141, 68, 45,  0, 76, 41,253, 72,
/* 0x0500 */ 137,108, 36, 56, 72,137, 68, 36,104,232,  0,  0,  0,  0, 72,139,
/* 0x0510 */  84, 36, 96, 72,137, 68, 36, 40,199, 68, 36, 36,  0,  0,  0,  0,
/* 0x0520 */ 102,131,122, 56,  0, 15,132,115,  3,  0,  0, 72,131,124, 36, 88,
/* 0x0530 */   0,116, 35, 65,131, 62,  6,117, 29, 72,139, 84, 36, 56, 73,  3,
/* 0x0540 */  86, 16,190,  3,  0,  0,  0, 72,139,124, 36, 72,232, 92,253,255,
/* 0x0550 */ 255,233, 45,  3,  0,  0, 65,131, 62,  1, 15,133, 35,  3,  0,  0,
/* 0x0560 */  73,131,126, 40,  0, 15,132, 24,  3,  0,  0, 65,139, 78,  4,199,
/* 0x0570 */  68, 36, 32, 64, 98, 81,115,131,225,  7,193,225,  2,211,108, 36,
/* 0x0580 */  32,131,100, 36, 32,  7, 72,131,124, 36, 88,  0,116, 90, 73,131,
/* 0x0590 */ 126,  8,  0,117, 83, 72,139, 68, 36, 96, 72,139, 84, 36, 56,190,
/* 0x05a0 */   3,  0,  0,  0, 73,  3, 86, 16, 72,139,124, 36, 72, 72,  3, 80,
/* 0x05b0 */  32,232,247,252,255,255, 72,139, 68, 36, 96, 72,139,124, 36, 72,
/* 0x05c0 */ 190,  5,  0,  0,  0, 72, 15,183, 80, 56,232,222,252,255,255, 72,
/* 0x05d0 */ 139, 68, 36, 96, 72,139,124, 36, 72,190,  4,  0,  0,  0, 72, 15,
/* 0x05e0 */ 183, 80, 54,232,197,252,255,255, 72,139,124, 36, 56, 72,139, 68,
/* 0x05f0 */  36, 40, 73,  3,126, 16, 73,139,118, 32, 73,139, 86, 40,199, 68,
/* 0x0600 */  36, 20,  0,  0,  0,  0, 72,247,208, 73,137,245, 72,137,180, 36,
/* 0x0610 */ 128,  0,  0,  0, 72, 33,248, 73,137,252, 72,  1,250, 73,  1,197,
/* 0x0620 */  73, 41,196, 72,131,124, 36, 88,  0, 72,137,188, 36,136,  0,  0,
/* 0x0630 */   0, 72,137, 84, 36, 24, 76,141, 60, 55,116,109, 65,246, 70,  4,
/* 0x0640 */   1,116, 51,190, 16,  0,  0,  0, 72,141, 61,  0,  0,  0,  0,232,
/* 0x0650 */   0,  0,  0,  0, 76,137,238,137,199,137, 68, 36, 20,232,  0,  0,
/* 0x0660 */   0,  0, 68,139, 68, 36, 20, 69, 49,201,185, 17,  0,  0,  0,186,
/* 0x0670 */   3,  0,  0,  0,235, 30, 72,131,124, 36, 88,  0,116, 43,139, 84,
/* 0x0680 */  36, 32, 69, 49,201, 65,131,200,255,185, 50,  0,  0,  0,131,202,
/* 0x0690 */   2,131,226,251, 76,137,238, 76,137,231,232,  0,  0,  0,  0, 73,
/* 0x06a0 */  57,196,116, 48,233,162,  1,  0,  0, 77,139, 78,  8, 68,139, 68,
/* 0x06b0 */  36, 84,185, 18,  0,  0,  0,139, 84, 36, 32, 76,137,238, 76,137,
/* 0x06c0 */ 231, 73, 41,193,232,  0,  0,  0,  0, 73, 57,196, 15,133,121,  1,
/* 0x06d0 */   0,  0,235, 26, 72,131,124, 36, 88,  0,116, 18, 72,139,124, 36,
/* 0x06e0 */  88, 72,141,180, 36,128,  0,  0,  0,232,242,250,255,255,246, 68,
/* 0x06f0 */  36, 32,  2,116, 24,139, 68, 36, 40, 68,137,249, 76,137,255,247,
/* 0x0700 */ 217,252,247,208, 33,193, 49,192,243,170, 73,137,255, 72,131,124,
/* 0x0710 */  36, 88,  0, 15,132, 24,  1,  0,  0, 65,246, 70,  4,  1, 15,132,
/* 0x0720 */  13,  1,  0,  0,199, 68, 36,112,243, 15, 30,250,199, 68, 36,116,
/* 0x0730 */  15,  5, 90, 88, 72,184,255,255,255,255,  1,  0,  0,  0,199, 68,
/* 0x0740 */  36,120, 62,255,224,144, 73, 35,  6, 72,186,  1,  0,  0,  0,  1,
/* 0x0750 */   0,  0,  0,139, 76, 36, 40, 72,139,172, 36,136,  0,  0,  0, 72,
/* 0x0760 */  57,208,247,209,117,108,137,232,247,216, 33,193,131,249, 11,118,
/* 0x0770 */  23,199, 69,  0,243, 15, 30,250,139, 68, 36,116,137, 69,  4,139,
/* 0x0780 */  68, 36,120,137, 69,  8,235, 74,190, 16,  0,  0,  0, 72,141, 61,
/* 0x0790 */   0,  0,  0,  0,232,  0,  0,  0,  0, 72,141,116, 36,112,137,195,
/* 0x07a0 */ 186, 12,  0,  0,  0,137,199,232,  0,  0,  0,  0, 49,255, 69, 49,
/* 0x07b0 */ 201, 65,137,216,185,  1,  0,  0,  0,186,  5,  0,  0,  0,190, 12,
/* 0x07c0 */   0,  0,  0,232,  0,  0,  0,  0,137,223, 72,137,197,232,  0,  0,
/* 0x07d0 */   0,  0, 72,133,237,116, 19, 72,139,124, 36, 72, 72,137,234, 49,
/* 0x07e0 */ 246, 72,131,231,254,232,195,250,255,255,186,  4,  0,  0,  0, 76,
/* 0x07f0 */ 137,238, 76,137,231,232,  0,  0,  0,  0, 76,137,238, 76,137,231,
/* 0x0800 */ 232,  0,  0,  0,  0, 68,139, 68, 36, 20,139, 84, 36, 32, 69, 49,
/* 0x0810 */ 201,185, 17,  0,  0,  0, 76,137,238, 76,137,231,232,  0,  0,  0,
/* 0x0820 */   0, 73, 57,196,117, 37,139,124, 36, 20,232,  0,  0,  0,  0,235,
/* 0x0830 */  36,131,124, 36, 32,  3,116, 29,139, 84, 36, 32, 76,137,238, 76,
/* 0x0840 */ 137,231,232,  0,  0,  0,  0,133,192,116, 10,191,127,  0,  0,  0,
/* 0x0850 */ 232,  0,  0,  0,  0, 76, 59,124, 36, 24,115, 39, 76, 41,124, 36,
/* 0x0860 */  24,139, 84, 36, 32, 69, 49,201, 72,139,116, 36, 24, 65,131,200,
/* 0x0870 */ 255,185, 50,  0,  0,  0, 76,137,255,232,  0,  0,  0,  0, 73, 57,
/* 0x0880 */ 199,117,200, 72,139, 84, 36, 96,255, 68, 36, 36, 73,131,198, 56,
/* 0x0890 */  15,183, 66, 56, 57, 68, 36, 36, 15,140,141,252,255,255, 72,131,
/* 0x08a0 */ 124, 36, 64,  0,116, 13, 72,139, 84, 36, 56, 72,139, 68, 36, 64,
/* 0x08b0 */  72,137, 16, 72,139, 68, 36, 96, 72,139, 64, 24, 72,  1, 68, 36,
/* 0x08c0 */  56, 72,139, 68, 36, 56, 72,129,196,152,  0,  0,  0, 91, 93, 65,
/* 0x08d0 */  92, 65, 93, 65, 94, 65, 95,195, 65, 87, 65, 86, 73,137,206, 65,
/* 0x08e0 */  85, 65, 84, 73,137,212, 77,141,108, 36, 64, 85, 83, 72,131,236,
/* 0x08f0 */  72,139,  7, 72,137,124, 36, 24, 72,137,124, 36, 40, 76,141,124,
/* 0x0900 */  36,  8, 72,137,116, 36, 32, 72,141,116, 36, 48, 76,137, 68, 36,
/* 0x0910 */   8, 72,137, 84, 36, 56, 72,137, 68, 36, 48,139, 71,  4, 72,141,
/* 0x0920 */ 124, 36, 16, 72,131,192, 12, 72,137, 68, 36, 16,232,175,248,255,
/* 0x0930 */ 255,232,  0,  0,  0,  0, 72,141,116, 36, 32, 49,210, 77,137,248,
/* 0x0940 */  76,137,241, 76,137,231,232,  6,250,255,255,190,  9,  0,  0,  0,
/* 0x0950 */  72,137,194, 76,137,247, 72,137,197,232, 79,249,255,255,102, 65,
/* 0x0960 */ 131,124, 36, 56,  0,199, 68, 36,  4,  0,  0,  0,  0, 15,132,136,
/* 0x0970 */   0,  0,  0, 65,131,125,  0,  3,117,105, 73,139, 63, 73,  3,125,
/* 0x0980 */  16, 49,210, 49,246,232,  0,  0,  0,  0,133,192,137,195,120, 23,
/* 0x0990 */ 186,  0,  4,  0,  0, 76,137,230,137,199,232,  0,  0,  0,  0, 72,
/* 0x09a0 */  61,  0,  4,  0,  0,116, 10,191,127,  0,  0,  0,232,  0,  0,  0,
/* 0x09b0 */   0, 77,137,248, 49,201,137,218, 49,246, 76,137,231, 73,199,  7,
/* 0x09c0 */   0,  0,  0,  0,232,136,249,255,255, 73,139, 23, 76,137,247,190,
/* 0x09d0 */   7,  0,  0,  0, 72,137,197,232,209,248,255,255,137,223,232,  0,
/* 0x09e0 */   0,  0,  0,255, 68, 36,  4, 65, 15,183, 68, 36, 56, 73,131,197,
/* 0x09f0 */  56, 57, 68, 36,  4, 15,130,120,255,255,255, 72,131,196, 72, 72,
/* 0x0a00 */ 137,232, 91, 93, 65, 92, 65, 93, 65, 94, 65, 95,195,  0,  0,  0,
/* 0x0a10 */  72,137, 92, 36,224, 72,137,108, 36,232, 76,137,100, 36,240, 76,
/* 0x0a20 */ 137,108, 36,248, 72,131,236, 40, 73,137,252, 65,137,245, 72,141,
/* 0x0a30 */  45,  0,  0,  0,  0,190, 16,  0,  0,  0, 72,137,239,232,  0,  0,
/* 0x0a40 */   0,  0,137,195,131,248,234,117, 15,190,  0,  0,  0,  0, 72,137,
/* 0x0a50 */ 239,232,  0,  0,  0,  0,137,195,133,219,121, 68, 72,141, 61,  0,
/* 0x0a60 */   0,  0,  0,186,192,  1,  0,  0,190,  2,  0, 65,  0,232,  0,  0,
/* 0x0a70 */   0,  0,137,195,133,192,121, 40, 72, 99,208,131,248,235,117,109,
/* 0x0a80 */  72,141, 53,  0,  0,  0,  0,186, 61,  0,  0,  0,191,  2,  0,  0,
/* 0x0a90 */   0,232,  0,  0,  0,  0,191,127,  0,  0,  0,232,  0,  0,  0,  0,
/* 0x0aa0 */  68,137,238,137,223,232,  0,  0,  0,  0, 72, 99,208,133,192,120,
/* 0x0ab0 */  60, 73,131,252,  1, 25,201,131,225,240,131,193, 17, 68,137,238,
/* 0x0ac0 */  65,185,  0,  0,  0,  0, 65,137,216,186,  3,  0,  0,  0, 76,137,
/* 0x0ad0 */ 231,232,  0,  0,  0,  0, 73,137,196,232,  0,  0,  0,  0, 76,137,
/* 0x0ae0 */ 226, 73, 57,196,115,  7,141, 67,  1, 74,141, 20, 32, 72,137,208,
/* 0x0af0 */  72,139, 92, 36,  8, 72,139,108, 36, 16, 76,139,100, 36, 24, 76,
/* 0x0b00 */ 139,108, 36, 32, 72,131,196, 40,195,204,195, 47,112,114,111, 99,
/* 0x0b10 */  47,115,101,108,102, 47,101,120,101,  0,184, 63,  1,  0,  0, 15,
/* 0x0b20 */   5,133,192,121, 45,133,246,116,  4, 49,246,235,237,232, 17,  0,
/* 0x0b30 */   0,  0,192,  1,  0,  0,  2,  0, 65,  0, 47,100,101,118, 47,115,
/* 0x0b40 */ 104,109,  0, 94,173,146,173, 86,150, 95,106,  2, 88,232, 26,  0,
/* 0x0b50 */   0,  0,195, 72,139,  5,  0,  0,  0,  0,247,208, 33,248, 72, 41,
/* 0x0b60 */ 199, 72,  1,198,176,  9, 73,137,202, 15,182,192, 80, 15,  5, 89,
/* 0x0b70 */  72, 61,  0,240,255,255,114,  6,131,249,  2,116,  1,204,195,139,
/* 0x0b80 */   5,  0,  0,  0,  0,247,208,176, 26,235, 52, 33,248, 72, 41,199,
/* 0x0b90 */  72,  1,198,233,  0,  0,  0,  0,139,  5,  0,  0,  0,  0,247,208,
/* 0x0ba0 */  33,248, 72, 41,199, 72,  1,198,233,  0,  0,  0,  0,139,  5,  0,
/* 0x0bb0 */   0,  0,  0,247,208, 33,248, 72, 41,199, 72,  1,198,176, 11,235,
/* 0x0bc0 */   2,176, 60,235,  2,176, 12,235,  2,176,  3,235,  2,176, 77,235,
/* 0x0bd0 */   2,176,  2,235,  2,176, 10,235,  2,176, 26,235,  2,176,  1,235,
/* 0x0be0 */   2,176,  0,235,132, 85, 72,137,229, 83, 82, 86, 87,232,101,  0,
/* 0x0bf0 */   0,  0, 91, 95, 94, 80, 15,182, 75,  9,133,201,116, 11, 15,182,
/* 0x0c00 */  83, 10,139, 54,232,  4,  0,  0,  0, 88, 91, 93,195,131,249, 73,
/* 0x0c10 */ 117, 68, 83, 87, 72,141, 76, 55,253, 94, 86, 91,235, 47, 72, 57,
/* 0x0c20 */ 206,115, 50, 86, 94,172, 60,128,114, 10, 60,143,119,  6,128,126,
/* 0x0c30 */ 254, 15,116,  6, 44,232, 60,  1,119,228, 72, 57,206,115, 22, 86,
/* 0x0c40 */ 173, 40,208,117,223, 95, 15,200, 41,248,  1,216,171, 72, 57,206,
/* 0x0c50 */ 115,  3,172,235,223, 91,195, 82, 68, 15,182, 71,  8, 87, 86, 95,
/* 0x0c60 */  94,139, 70,  4, 72,131,198, 12, 72,  1,240, 80, 87, 49,219, 49,
/* 0x0c70 */ 201, 72,131,205,255,235, 86,139, 30, 72,131,238,252, 17,219, 15,
/* 0x0c80 */ 182, 22,243,195,243, 15, 30,250,  1,219,116,235,243,195, 72,141,
/* 0x0c90 */   4, 47,131,249,  5, 15,182, 16,118, 33,131,253,252,119, 28,131,
/* 0x0ca0 */ 233,  4,139, 16, 72,131,192,  4,131,233,  4,137, 23, 72,141,127,
/* 0x0cb0 */   4,115,239,131,193,  4, 15,182, 16,116, 16, 72,255,192,136, 23,
/* 0x0cc0 */ 255,201, 15,182, 16, 72,141,127,  1,117,240,243,195,252, 65,131,
/* 0x0cd0 */ 248,  8, 15,133,222,  0,  0,  0,235,  8, 72,255,198,136, 23, 72,
/* 0x0ce0 */ 255,199, 15,182, 22,  1,219,117, 11,139, 30, 72,131,238,252, 17,
/* 0x0cf0 */ 219, 15,182, 22,114,228,141, 65,  1,235, 19,255,200,  1,219,117,
/* 0x0d00 */  11,139, 30, 72,131,238,252, 17,219, 15,182, 22, 17,192,  1,219,
/* 0x0d10 */ 117, 11,139, 30, 72,131,238,252, 17,219, 15,182, 22, 17,192,  1,
/* 0x0d20 */ 219,117, 11,139, 30, 72,131,238,252, 17,219, 15,182, 22,115,203,
/* 0x0d30 */ 131,232,  3,114, 26,193,224,  8, 72,255,198,  9,208,131,240,255,
/* 0x0d40 */  15,132,  0,  0,  0,  0,209,248, 72, 99,232,114, 68,235, 14,  1,
/* 0x0d50 */ 219,117,  8,139, 30, 72,131,238,252, 17,219,114, 52,255,193,  1,
/* 0x0d60 */ 219,117,  8,139, 30, 72,131,238,252, 17,219,114, 36,  1,219,117,
/* 0x0d70 */  11,139, 30, 72,131,238,252, 17,219, 15,182, 22, 17,201,  1,219,
/* 0x0d80 */ 117,  8,139, 30, 72,131,238,252, 17,219,115,225,131,193,  2,235,
/* 0x0d90 */  17,  1,219,117, 11,139, 30, 72,131,238,252, 17,219, 15,182, 22,
/* 0x0da0 */  17,201, 72,129,253,  0,251,255,255,131,209,  2,232,  0,  0,  0,
/* 0x0db0 */   0,233, 44,255,255,255, 65,131,248,  5, 15,133,209,  0,  0,  0,
/* 0x0dc0 */ 235,  8, 72,255,198,136, 23, 72,255,199, 15,182, 22,  1,219,117,
/* 0x0dd0 */  11,139, 30, 72,131,238,252, 17,219, 15,182, 22,114,228,141, 65,
/* 0x0de0 */   1,235, 19,255,200,  1,219,117, 11,139, 30, 72,131,238,252, 17,
/* 0x0df0 */ 219, 15,182, 22, 17,192,  1,219,117, 11,139, 30, 72,131,238,252,
/* 0x0e00 */  17,219, 15,182, 22, 17,192,  1,219,117, 11,139, 30, 72,131,238,
/* 0x0e10 */ 252, 17,219, 15,182, 22,115,203,131,232,  3,114, 24,193,224,  8,
/* 0x0e20 */  72,255,198,  9,208,131,240,255, 15,132,  0,  0,  0,  0,209,248,
/* 0x0e30 */  72, 99,232,235, 15,  1,219,117, 11,139, 30, 72,131,238,252, 17,
/* 0x0e40 */ 219, 15,182, 22, 17,201,  1,219,117, 11,139, 30, 72,131,238,252,
/* 0x0e50 */  17,219, 15,182, 22, 17,201,117, 36,255,193,  1,219,117, 11,139,
/* 0x0e60 */  30, 72,131,238,252, 17,219, 15,182, 22, 17,201,  1,219,117,  8,
/* 0x0e70 */ 139, 30, 72,131,238,252, 17,219,115,225,131,193,  2, 72,129,253,
/* 0x0e80 */   0,251,255,255,131,209,  1,232,  0,  0,  0,  0,233, 57,255,255,
/* 0x0e90 */ 255, 65,131,248,  2, 15,133,186,  0,  0,  0,235,  8, 72,255,198,
/* 0x0ea0 */ 136, 23, 72,255,199, 15,182, 22,  1,219,117, 11,139, 30, 72,131,
/* 0x0eb0 */ 238,252, 17,219, 15,182, 22,114,228,141, 65,  1,  1,219,117, 11,
/* 0x0ec0 */ 139, 30, 72,131,238,252, 17,219, 15,182, 22, 17,192,  1,219,117,
/* 0x0ed0 */  11,139, 30, 72,131,238,252, 17,219, 15,182, 22,115,222,131,232,
/* 0x0ee0 */   3,114, 20,193,224,  8, 72,255,198,  9,208,131,240,255, 15,132,
/* 0x0ef0 */   0,  0,  0,  0, 72, 99,232,141, 65,  1,  1,219,117, 11,139, 30,
/* 0x0f00 */  72,131,238,252, 17,219, 15,182, 22, 17,201,  1,219,117, 11,139,
/* 0x0f10 */  30, 72,131,238,252, 17,219, 15,182, 22, 17,201,117, 36,137,193,
/* 0x0f20 */ 131,192,  2,  1,219,117, 11,139, 30, 72,131,238,252, 17,219, 15,
/* 0x0f30 */ 182, 22, 17,201,  1,219,117,  8,139, 30, 72,131,238,252, 17,219,
/* 0x0f40 */ 115,225, 72,129,253,  0,243,255,255, 17,193,232,  0,  0,  0,  0,
/* 0x0f50 */ 233, 80,255,255,255, 65,131,248, 14, 15,133,  0,  0,  0,  0, 87,
/* 0x0f60 */  86,139,118,248, 72,137,209, 95, 90, 85, 72,137,229, 68,139,  9,
/* 0x0f70 */  73,137,208, 72,137,242, 72,141,119,  2, 86,138,  7,255,202,136,
/* 0x0f80 */ 193, 36,  7,192,233,  3, 72,199,195,  0,253,255,255, 72,211,227,
/* 0x0f90 */ 136,193, 72,141,156, 92,136,241,255,255, 72,131,227,192,106,  0,
/* 0x0fa0 */  72, 57,220,117,249, 83, 72,141,123,  8,138, 78,255,255,202,136,
/* 0x0fb0 */  71,  2,136,200,192,233,  4,136, 79,  1, 36, 15,136,  7, 72,141,
/* 0x0fc0 */  79,252,106, 90, 65, 87, 72,141, 71,  4, 69, 49,255, 65, 86, 65,
/* 0x0fd0 */ 190,  1,  0,  0,  0, 65, 85, 69, 49,237, 65, 84, 85, 83, 72,137,
/* 0x0fe0 */  76, 36,240, 72,137, 68, 36,216,184,  1,  0,  0,  0, 72,137,116,
/* 0x0ff0 */  36,248, 76,137, 68, 36,232,137,195, 68,137, 76, 36,228, 15,182,
/* 0x1000 */  79,  2,211,227,137,217, 72,139, 92, 36, 56,255,201,137, 76, 36,
/* 0x1010 */ 212, 15,182, 79,  1,211,224, 72,139, 76, 36,240,255,200,137, 68,
/* 0x1020 */  36,208, 15,182,  7,199,  1,  0,  0,  0,  0,199, 68, 36,200,  0,
/* 0x1030 */   0,  0,  0,199, 68, 36,196,  1,  0,  0,  0,199, 68, 36,192,  1,
/* 0x1040 */   0,  0,  0,199, 68, 36,188,  1,  0,  0,  0,199,  3,  0,  0,  0,
/* 0x1050 */   0,137, 68, 36,204, 15,182, 79,  1,  1,193,184,  0,  3,  0,  0,
/* 0x1060 */ 211,224, 49,201,141,184, 54,  7,  0,  0, 65, 57,255,115, 19, 72,
/* 0x1070 */ 139, 92, 36,216,137,200,255,193, 57,249,102,199,  4, 67,  0,  4,
/* 0x1080 */ 235,235, 72,139,124, 36,248,137,208, 69, 49,210, 65,131,203,255,
/* 0x1090 */  49,210, 73,137,252, 73,  1,196, 76, 57,231, 15,132,239,  8,  0,
/* 0x10a0 */   0, 15,182,  7, 65,193,226,  8,255,194, 72,255,199, 65,  9,194,
/* 0x10b0 */ 131,250,  4,126,227, 68, 59,124, 36,228, 15,131,218,  8,  0,  0,
/* 0x10c0 */ 139, 68, 36,212, 72, 99, 92, 36,200, 72,139, 84, 36,216, 68, 33,
/* 0x10d0 */ 248,137, 68, 36,184, 72, 99,108, 36,184, 72,137,216, 72,193,224,
/* 0x10e0 */   4, 72,  1,232, 65,129,251,255,255,255,  0, 76,141, 12, 66,119,
/* 0x10f0 */  26, 76, 57,231, 15,132,150,  8,  0,  0, 15,182,  7, 65,193,226,
/* 0x1100 */   8, 65,193,227,  8, 72,255,199, 65,  9,194, 65, 15,183, 17, 68,
/* 0x1110 */ 137,216,193,232, 11, 15,183,202, 15,175,193, 65, 57,194, 15,131,
/* 0x1120 */ 197,  1,  0,  0, 65,137,195,184,  0,  8,  0,  0, 72,139, 92, 36,
/* 0x1130 */ 216, 41,200, 15,182, 76, 36,204,190,  1,  0,  0,  0,193,248,  5,
/* 0x1140 */ 141,  4,  2, 65, 15,182,213,102, 65,137,  1,139, 68, 36,208, 68,
/* 0x1150 */  33,248,211,224,185,  8,  0,  0,  0, 43, 76, 36,204,211,250,  1,
/* 0x1160 */ 208,105,192,  0,  3,  0,  0,131,124, 36,200,  6,137,192, 76,141,
/* 0x1170 */ 140, 67,108, 14,  0,  0, 15,142,184,  0,  0,  0, 72,139, 84, 36,
/* 0x1180 */ 232, 68,137,248, 68, 41,240, 15,182, 44,  2,  1,237, 72, 99,214,
/* 0x1190 */ 137,235,129,227,  0,  1,  0,  0, 65,129,251,255,255,255,  0, 72,
/* 0x11a0 */  99,195, 73,141,  4, 65, 76,141,  4, 80,119, 26, 76, 57,231, 15,
/* 0x11b0 */ 132,219,  7,  0,  0, 15,182,  7, 65,193,226,  8, 65,193,227,  8,
/* 0x11c0 */  72,255,199, 65,  9,194, 65, 15,183,144,  0,  2,  0,  0, 68,137,
/* 0x11d0 */ 216,193,232, 11, 15,183,202, 15,175,193, 65, 57,194,115, 32, 65,
/* 0x11e0 */ 137,195,184,  0,  8,  0,  0,  1,246, 41,200,193,248,  5,133,219,
/* 0x11f0 */ 141,  4,  2,102, 65,137,128,  0,  2,  0,  0,116, 33,235, 45, 65,
/* 0x1200 */  41,195, 65, 41,194,137,208,102,193,232,  5,141,116, 54,  1,102,
/* 0x1210 */  41,194,133,219,102, 65,137,144,  0,  2,  0,  0,116, 14,129,254,
/* 0x1220 */ 255,  0,  0,  0, 15,142, 97,255,255,255,235,120,129,254,255,  0,
/* 0x1230 */   0,  0,127,112, 72, 99,198, 65,129,251,255,255,255,  0, 77,141,
/* 0x1240 */   4, 65,119, 26, 76, 57,231, 15,132, 67,  7,  0,  0, 15,182,  7,
/* 0x1250 */  65,193,226,  8, 65,193,227,  8, 72,255,199, 65,  9,194, 65, 15,
/* 0x1260 */ 183, 16, 68,137,216,193,232, 11, 15,183,202, 15,175,193, 65, 57,
/* 0x1270 */ 194,115, 24, 65,137,195,184,  0,  8,  0,  0,  1,246, 41,200,193,
/* 0x1280 */ 248,  5,141,  4,  2,102, 65,137,  0,235,161, 65, 41,195, 65, 41,
/* 0x1290 */ 194,137,208,102,193,232,  5,141,116, 54,  1,102, 41,194,102, 65,
/* 0x12a0 */ 137, 16,235,136, 72,139, 76, 36,232, 68,137,248, 65,255,199, 65,
/* 0x12b0 */ 137,245, 64,136, 52,  1,131,124, 36,200,  3,127, 13,199, 68, 36,
/* 0x12c0 */ 200,  0,  0,  0,  0,233,166,  6,  0,  0,139, 84, 36,200,139, 68,
/* 0x12d0 */  36,200,131,234,  3,131,232,  6,131,124, 36,200,  9, 15, 79,208,
/* 0x12e0 */ 137, 84, 36,200,233,135,  6,  0,  0, 65, 41,195, 65, 41,194,137,
/* 0x12f0 */ 208,102,193,232,  5,102, 41,194, 72,139, 68, 36,216, 65,129,251,
/* 0x1300 */ 255,255,255,  0,102, 65,137, 17, 72,141, 52, 88,119, 26, 76, 57,
/* 0x1310 */ 231, 15,132,121,  6,  0,  0, 15,182,  7, 65,193,226,  8, 65,193,
/* 0x1320 */ 227,  8, 72,255,199, 65,  9,194, 15,183,150,128,  1,  0,  0, 68,
/* 0x1330 */ 137,216,193,232, 11, 15,183,202, 15,175,193, 65, 57,194,115, 78,
/* 0x1340 */  65,137,195,184,  0,  8,  0,  0, 76,139, 76, 36,216, 41,200,139,
/* 0x1350 */  76, 36,196, 68,137,116, 36,196,193,248,  5,141,  4,  2,139, 84,
/* 0x1360 */  36,192,137, 76, 36,192,102,137,134,128,  1,  0,  0, 49,192,131,
/* 0x1370 */ 124, 36,200,  6,137, 84, 36,188, 15,159,192, 73,129,193,100,  6,
/* 0x1380 */   0,  0,141,  4, 64,137, 68, 36,200,233, 84,  2,  0,  0, 65, 41,
/* 0x1390 */ 195, 65, 41,194,137,208,102,193,232,  5,102, 41,194, 65,129,251,
/* 0x13a0 */ 255,255,255,  0,102,137,150,128,  1,  0,  0,119, 26, 76, 57,231,
/* 0x13b0 */  15,132,218,  5,  0,  0, 15,182,  7, 65,193,226,  8, 65,193,227,
/* 0x13c0 */   8, 72,255,199, 65,  9,194, 15,183,150,152,  1,  0,  0, 68,137,
/* 0x13d0 */ 216,193,232, 11, 15,183,202, 15,175,193, 65, 57,194, 15,131,208,
/* 0x13e0 */   0,  0,  0, 65,184,  0,  8,  0,  0, 65,137,195, 72,193,227,  5,
/* 0x13f0 */  68,137,192, 41,200,193,248,  5,141,  4,  2,102,137,134,152,  1,
/* 0x1400 */   0,  0, 72,139, 68, 36,216, 72,  1,216, 65,129,251,255,255,255,
/* 0x1410 */   0, 72,141, 52,104,119, 26, 76, 57,231, 15,132,112,  5,  0,  0,
/* 0x1420 */  15,182,  7, 65,193,226,  8, 65,193,227,  8, 72,255,199, 65,  9,
/* 0x1430 */ 194, 15,183,150,224,  1,  0,  0, 68,137,216,193,232, 11, 15,183,
/* 0x1440 */ 202, 15,175,193, 65, 57,194,115, 79, 65, 41,200, 65,137,195, 65,
/* 0x1450 */ 193,248,  5, 69,133,255, 66,141,  4,  2,102,137,134,224,  1,  0,
/* 0x1460 */   0, 15,132, 41,  5,  0,  0, 49,192,131,124, 36,200,  6, 72,139,
/* 0x1470 */  92, 36,232, 15,159,192,141, 68,  0,  9,137, 68, 36,200, 68,137,
/* 0x1480 */ 248, 68, 41,240, 68, 15,182, 44,  3, 68,137,248, 65,255,199, 68,
/* 0x1490 */ 136, 44,  3,233,216,  4,  0,  0, 65, 41,195, 65, 41,194,137,208,
/* 0x14a0 */ 102,193,232,  5,102, 41,194,102,137,150,224,  1,  0,  0,233, 17,
/* 0x14b0 */   1,  0,  0, 65, 41,195, 65, 41,194,137,208,102,193,232,  5,102,
/* 0x14c0 */  41,194, 65,129,251,255,255,255,  0,102,137,150,152,  1,  0,  0,
/* 0x14d0 */ 119, 26, 76, 57,231, 15,132,181,  4,  0,  0, 15,182,  7, 65,193,
/* 0x14e0 */ 226,  8, 65,193,227,  8, 72,255,199, 65,  9,194, 15,183,150,176,
/* 0x14f0 */   1,  0,  0, 68,137,216,193,232, 11, 15,183,202, 15,175,193, 65,
/* 0x1500 */  57,194,115, 32, 65,137,195,184,  0,  8,  0,  0, 41,200,193,248,
/* 0x1510 */   5,141,  4,  2,102,137,134,176,  1,  0,  0,139, 68, 36,196,233,
/* 0x1520 */ 152,  0,  0,  0, 65, 41,195, 65, 41,194,137,208,102,193,232,  5,
/* 0x1530 */ 102, 41,194, 65,129,251,255,255,255,  0,102,137,150,176,  1,  0,
/* 0x1540 */   0,119, 26, 76, 57,231, 15,132, 68,  4,  0,  0, 15,182,  7, 65,
/* 0x1550 */ 193,226,  8, 65,193,227,  8, 72,255,199, 65,  9,194, 15,183,150,
/* 0x1560 */ 200,  1,  0,  0, 68,137,216,193,232, 11, 15,183,202, 15,175,193,
/* 0x1570 */  65, 57,194,115, 29, 65,137,195,184,  0,  8,  0,  0, 41,200,193,
/* 0x1580 */ 248,  5,141,  4,  2,102,137,134,200,  1,  0,  0,139, 68, 36,192,
/* 0x1590 */ 235, 34, 65, 41,195, 65, 41,194,137,208,102,193,232,  5,102, 41,
/* 0x15a0 */ 194,139, 68, 36,188,102,137,150,200,  1,  0,  0,139, 84, 36,192,
/* 0x15b0 */ 137, 84, 36,188,139, 76, 36,196,137, 76, 36,192, 68,137,116, 36,
/* 0x15c0 */ 196, 65,137,198, 49,192,131,124, 36,200,  6, 76,139, 76, 36,216,
/* 0x15d0 */  15,159,192, 73,129,193,104, 10,  0,  0,141, 68, 64,  8,137, 68,
/* 0x15e0 */  36,200, 65,129,251,255,255,255,  0,119, 26, 76, 57,231, 15,132,
/* 0x15f0 */ 156,  3,  0,  0, 15,182,  7, 65,193,226,  8, 65,193,227,  8, 72,
/* 0x1600 */ 255,199, 65,  9,194, 65, 15,183, 17, 68,137,216,193,232, 11, 15,
/* 0x1610 */ 183,202, 15,175,193, 65, 57,194,115, 39, 65,137,195,184,  0,  8,
/* 0x1620 */   0,  0, 69, 49,237, 41,200,193,248,  5,141,  4,  2,102, 65,137,
/* 0x1630 */   1, 72, 99, 68, 36,184, 72,193,224,  4, 77,141, 68,  1,  4,235,
/* 0x1640 */ 120, 65, 41,195, 65, 41,194,137,208,102,193,232,  5,102, 41,194,
/* 0x1650 */  65,129,251,255,255,255,  0,102, 65,137, 17,119, 26, 76, 57,231,
/* 0x1660 */  15,132, 42,  3,  0,  0, 15,182,  7, 65,193,226,  8, 65,193,227,
/* 0x1670 */   8, 72,255,199, 65,  9,194, 65, 15,183, 81,  2, 68,137,216,193,
/* 0x1680 */ 232, 11, 15,183,202, 15,175,193, 65, 57,194,115, 52, 65,137,195,
/* 0x1690 */ 184,  0,  8,  0,  0, 65,189,  8,  0,  0,  0, 41,200,193,248,  5,
/* 0x16a0 */ 141,  4,  2,102, 65,137, 65,  2, 72, 99, 68, 36,184, 72,193,224,
/* 0x16b0 */   4, 77,141,132,  1,  4,  1,  0,  0, 65,185,  3,  0,  0,  0,235,
/* 0x16c0 */  39, 65, 41,195, 65, 41,194,137,208,102,193,232,  5, 77,141,129,
/* 0x16d0 */   4,  2,  0,  0, 65,189, 16,  0,  0,  0,102, 41,194,102, 65,137,
/* 0x16e0 */  81,  2, 65,185,  8,  0,  0,  0, 68,137,203,189,  1,  0,  0,  0,
/* 0x16f0 */  72, 99,197, 65,129,251,255,255,255,  0, 73,141, 52, 64,119, 26,
/* 0x1700 */  76, 57,231, 15,132,135,  2,  0,  0, 15,182,  7, 65,193,226,  8,
/* 0x1710 */  65,193,227,  8, 72,255,199, 65,  9,194, 15,183, 14, 68,137,216,
/* 0x1720 */ 193,232, 11, 15,183,209, 15,175,194, 65, 57,194,115, 23, 65,137,
/* 0x1730 */ 195,184,  0,  8,  0,  0,  1,237, 41,208,193,248,  5,141,  4,  1,
/* 0x1740 */ 102,137,  6,235, 22, 65, 41,195, 65, 41,194,137,200,102,193,232,
/* 0x1750 */   5,141,108, 45,  1,102, 41,193,102,137, 14,255,203,117,145,184,
/* 0x1760 */   1,  0,  0,  0, 68,137,201,211,224, 41,197, 68,  1,237,131,124,
/* 0x1770 */  36,200,  3, 15,143,194,  1,  0,  0,131, 68, 36,200,  7,184,  3,
/* 0x1780 */   0,  0,  0,131,253,  4, 15, 76,197, 72,139, 92, 36,216, 65,184,
/* 0x1790 */   1,  0,  0,  0, 72,152, 72,193,224,  7, 76,141,140,  3, 96,  3,
/* 0x17a0 */   0,  0,187,  6,  0,  0,  0, 73, 99,192, 65,129,251,255,255,255,
/* 0x17b0 */   0, 73,141, 52, 65,119, 26, 76, 57,231, 15,132,208,  1,  0,  0,
/* 0x17c0 */  15,182,  7, 65,193,226,  8, 65,193,227,  8, 72,255,199, 65,  9,
/* 0x17d0 */ 194, 15,183, 22, 68,137,216,193,232, 11, 15,183,202, 15,175,193,
/* 0x17e0 */  65, 57,194,115, 24, 65,137,195,184,  0,  8,  0,  0, 69,  1,192,
/* 0x17f0 */  41,200,193,248,  5,141,  4,  2,102,137,  6,235, 23, 65, 41,195,
/* 0x1800 */  65, 41,194,137,208,102,193,232,  5, 71,141, 68,  0,  1,102, 41,
/* 0x1810 */ 194,102,137, 22,255,203,117,143, 65,131,232, 64, 65,131,248,  3,
/* 0x1820 */  69,137,198, 15,142, 13,  1,  0,  0, 65,131,230,  1, 68,137,192,
/* 0x1830 */ 209,248, 65,131,206,  2, 65,131,248, 13,141,112,255,127, 35,137,
/* 0x1840 */ 241, 72,139, 92, 36,216, 73, 99,192, 65,211,230, 72,  1,192, 68,
/* 0x1850 */ 137,242, 72,141, 20, 83, 72, 41,194, 76,141,138, 94,  5,  0,  0,
/* 0x1860 */ 235, 81,141,112,251, 65,129,251,255,255,255,  0,119, 26, 76, 57,
/* 0x1870 */ 231, 15,132, 25,  1,  0,  0, 15,182,  7, 65,193,226,  8, 65,193,
/* 0x1880 */ 227,  8, 72,255,199, 65,  9,194, 65,209,235, 69,  1,246, 69, 57,
/* 0x1890 */ 218,114,  7, 69, 41,218, 65,131,206,  1,255,206,117,199, 76,139,
/* 0x18a0 */  76, 36,216, 65,193,230,  4,190,  4,  0,  0,  0, 73,129,193, 68,
/* 0x18b0 */   6,  0,  0, 65,189,  1,  0,  0,  0,187,  1,  0,  0,  0, 72, 99,
/* 0x18c0 */ 195, 65,129,251,255,255,255,  0, 77,141,  4, 65,119, 26, 76, 57,
/* 0x18d0 */ 231, 15,132,185,  0,  0,  0, 15,182,  7, 65,193,226,  8, 65,193,
/* 0x18e0 */ 227,  8, 72,255,199, 65,  9,194, 65, 15,183, 16, 68,137,216,193,
/* 0x18f0 */ 232, 11, 15,183,202, 15,175,193, 65, 57,194,115, 24, 65,137,195,
/* 0x1900 */ 184,  0,  8,  0,  0,  1,219, 41,200,193,248,  5,141,  4,  2,102,
/* 0x1910 */  65,137,  0,235, 26, 65, 41,195, 65, 41,194,137,208,102,193,232,
/* 0x1920 */   5,141, 92, 27,  1, 69,  9,238,102, 41,194,102, 65,137, 16, 69,
/* 0x1930 */   1,237,255,206,117,136, 65,255,198,116, 64,131,197,  2, 69, 57,
/* 0x1940 */ 254,119, 77, 72,139, 84, 36,232, 68,137,248, 68, 41,240, 68, 15,
/* 0x1950 */ 182, 44,  2, 68,137,248, 65,255,199,255,205, 68,136, 44,  2, 15,
/* 0x1960 */ 149,194, 49,192, 68, 59,124, 36,228, 15,146,192,133,194,117,211,
/* 0x1970 */  68, 59,124, 36,228, 15,130, 69,247,255,255, 65,129,251,255,255,
/* 0x1980 */ 255,  0,119, 22, 76, 57,231,184,  1,  0,  0,  0,116, 35,235,  7,
/* 0x1990 */ 184,  1,  0,  0,  0,235, 26, 72,255,199,137,248, 43, 68, 36,248,
/* 0x19a0 */  72,139, 76, 36,240, 72,139, 92, 36, 56,137,  1, 68,137, 59, 49,
/* 0x19b0 */ 192, 91, 93, 65, 92, 65, 93, 65, 94, 65, 95, 65, 87, 72,141, 71,
/* 0x19c0 */   4, 69, 49,255, 65, 86, 65,190,  1,  0,  0,  0, 65, 85, 69, 49,
/* 0x19d0 */ 237, 65, 84, 85, 83, 72,137, 76, 36,240, 72,137, 68, 36,216,184,
/* 0x19e0 */   1,  0,  0,  0, 72,137,116, 36,248, 76,137, 68, 36,232,137,195,
/* 0x19f0 */  68,137, 76, 36,228, 15,182, 79,  2,211,227,137,217, 72,139, 92,
/* 0x1a00 */  36, 56,255,201,137, 76, 36,212, 15,182, 79,  1,211,224, 72,139,
/* 0x1a10 */  76, 36,240,255,200,137, 68, 36,208, 15,182,  7,199,  1,  0,  0,
/* 0x1a20 */   0,  0,199, 68, 36,200,  0,  0,  0,  0,199, 68, 36,196,  1,  0,
/* 0x1a30 */   0,  0,199, 68, 36,192,  1,  0,  0,  0,199, 68, 36,188,  1,  0,
/* 0x1a40 */   0,  0,199,  3,  0,  0,  0,  0,137, 68, 36,204, 15,182, 79,  1,
/* 0x1a50 */   1,193,184,  0,  3,  0,  0,211,224, 49,201,141,184, 54,  7,  0,
/* 0x1a60 */   0, 65, 57,255,115, 19, 72,139, 92, 36,216,137,200,255,193, 57,
/* 0x1a70 */ 249,102,199,  4, 67,  0,  4,235,235, 72,139,124, 36,248,137,208,
/* 0x1a80 */  69, 49,210, 65,131,203,255, 49,210, 73,137,252, 73,  1,196, 76,
/* 0x1a90 */  57,231, 15,132,239,  8,  0,  0, 15,182,  7, 65,193,226,  8,255,
/* 0x1aa0 */ 194, 72,255,199, 65,  9,194,131,250,  4,126,227, 68, 59,124, 36,
/* 0x1ab0 */ 228, 15,131,218,  8,  0,  0,139, 68, 36,212, 72, 99, 92, 36,200,
/* 0x1ac0 */  72,139, 84, 36,216, 68, 33,248,137, 68, 36,184, 72, 99,108, 36,
/* 0x1ad0 */ 184, 72,137,216, 72,193,224,  4, 72,  1,232, 65,129,251,255,255,
/* 0x1ae0 */ 255,  0, 76,141, 12, 66,119, 26, 76, 57,231, 15,132,150,  8,  0,
/* 0x1af0 */   0, 15,182,  7, 65,193,226,  8, 65,193,227,  8, 72,255,199, 65,
/* 0x1b00 */   9,194, 65, 15,183, 17, 68,137,216,193,232, 11, 15,183,202, 15,
/* 0x1b10 */ 175,193, 65, 57,194, 15,131,197,  1,  0,  0, 65,137,195,184,  0,
/* 0x1b20 */   8,  0,  0, 72,139, 92, 36,216, 41,200, 15,182, 76, 36,204,190,
/* 0x1b30 */   1,  0,  0,  0,193,248,  5,141,  4,  2, 65, 15,182,213,102, 65,
/* 0x1b40 */ 137,  1,139, 68, 36,208, 68, 33,248,211,224,185,  8,  0,  0,  0,
/* 0x1b50 */  43, 76, 36,204,211,250,  1,208,105,192,  0,  3,  0,  0,131,124,
/* 0x1b60 */  36,200,  6,137,192, 76,141,140, 67,108, 14,  0,  0, 15,142,184,
/* 0x1b70 */   0,  0,  0, 72,139, 84, 36,232, 68,137,248, 68, 41,240, 15,182,
/* 0x1b80 */  44,  2,  1,237, 72, 99,214,137,235,129,227,  0,  1,  0,  0, 65,
/* 0x1b90 */ 129,251,255,255,255,  0, 72, 99,195, 73,141,  4, 65, 76,141,  4,
/* 0x1ba0 */  80,119, 26, 76, 57,231, 15,132,219,  7,  0,  0, 15,182,  7, 65,
/* 0x1bb0 */ 193,226,  8, 65,193,227,  8, 72,255,199, 65,  9,194, 65, 15,183,
/* 0x1bc0 */ 144,  0,  2,  0,  0, 68,137,216,193,232, 11, 15,183,202, 15,175,
/* 0x1bd0 */ 193, 65, 57,194,115, 32, 65,137,195,184,  0,  8,  0,  0,  1,246,
/* 0x1be0 */  41,200,193,248,  5,133,219,141,  4,  2,102, 65,137,128,  0,  2,
/* 0x1bf0 */   0,  0,116, 33,235, 45, 65, 41,195, 65, 41,194,137,208,102,193,
/* 0x1c00 */ 232,  5,141,116, 54,  1,102, 41,194,133,219,102, 65,137,144,  0,
/* 0x1c10 */   2,  0,  0,116, 14,129,254,255,  0,  0,  0, 15,142, 97,255,255,
/* 0x1c20 */ 255,235,120,129,254,255,  0,  0,  0,127,112, 72, 99,198, 65,129,
/* 0x1c30 */ 251,255,255,255,  0, 77,141,  4, 65,119, 26, 76, 57,231, 15,132,
/* 0x1c40 */  67,  7,  0,  0, 15,182,  7, 65,193,226,  8, 65,193,227,  8, 72,
/* 0x1c50 */ 255,199, 65,  9,194, 65, 15,183, 16, 68,137,216,193,232, 11, 15,
/* 0x1c60 */ 183,202, 15,175,193, 65, 57,194,115, 24, 65,137,195,184,  0,  8,
/* 0x1c70 */   0,  0,  1,246, 41,200,193,248,  5,141,  4,  2,102, 65,137,  0,
/* 0x1c80 */ 235,161, 65, 41,195, 65, 41,194,137,208,102,193,232,  5,141,116,
/* 0x1c90 */  54,  1,102, 41,194,102, 65,137, 16,235,136, 72,139, 76, 36,232,
/* 0x1ca0 */  68,137,248, 65,255,199, 65,137,245, 64,136, 52,  1,131,124, 36,
/* 0x1cb0 */ 200,  3,127, 13,199, 68, 36,200,  0,  0,  0,  0,233,166,  6,  0,
/* 0x1cc0 */   0,139, 84, 36,200,139, 68, 36,200,131,234,  3,131,232,  6,131,
/* 0x1cd0 */ 124, 36,200,  9, 15, 79,208,137, 84, 36,200,233,135,  6,  0,  0,
/* 0x1ce0 */  65, 41,195, 65, 41,194,137,208,102,193,232,  5,102, 41,194, 72,
/* 0x1cf0 */ 139, 68, 36,216, 65,129,251,255,255,255,  0,102, 65,137, 17, 72,
/* 0x1d00 */ 141, 52, 88,119, 26, 76, 57,231, 15,132,121,  6,  0,  0, 15,182,
/* 0x1d10 */   7, 65,193,226,  8, 65,193,227,  8, 72,255,199, 65,  9,194, 15,
/* 0x1d20 */ 183,150,128,  1,  0,  0, 68,137,216,193,232, 11, 15,183,202, 15,
/* 0x1d30 */ 175,193, 65, 57,194,115, 78, 65,137,195,184,  0,  8,  0,  0, 76,
/* 0x1d40 */ 139, 76, 36,216, 41,200,139, 76, 36,196, 68,137,116, 36,196,193,
/* 0x1d50 */ 248,  5,141,  4,  2,139, 84, 36,192,137, 76, 36,192,102,137,134,
/* 0x1d60 */ 128,  1,  0,  0, 49,192,131,124, 36,200,  6,137, 84, 36,188, 15,
/* 0x1d70 */ 159,192, 73,129,193,100,  6,  0,  0,141,  4, 64,137, 68, 36,200,
/* 0x1d80 */ 233, 84,  2,  0,  0, 65, 41,195, 65, 41,194,137,208,102,193,232,
/* 0x1d90 */   5,102, 41,194, 65,129,251,255,255,255,  0,102,137,150,128,  1,
/* 0x1da0 */   0,  0,119, 26, 76, 57,231, 15,132,218,  5,  0,  0, 15,182,  7,
/* 0x1db0 */  65,193,226,  8, 65,193,227,  8, 72,255,199, 65,  9,194, 15,183,
/* 0x1dc0 */ 150,152,  1,  0,  0, 68,137,216,193,232, 11, 15,183,202, 15,175,
/* 0x1dd0 */ 193, 65, 57,194, 15,131,208,  0,  0,  0, 65,184,  0,  8,  0,  0,
/* 0x1de0 */  65,137,195, 72,193,227,  5, 68,137,192, 41,200,193,248,  5,141,
/* 0x1df0 */   4,  2,102,137,134,152,  1,  0,  0, 72,139, 68, 36,216, 72,  1,
/* 0x1e00 */ 216, 65,129,251,255,255,255,  0, 72,141, 52,104,119, 26, 76, 57,
/* 0x1e10 */ 231, 15,132,112,  5,  0,  0, 15,182,  7, 65,193,226,  8, 65,193,
/* 0x1e20 */ 227,  8, 72,255,199, 65,  9,194, 15,183,150,224,  1,  0,  0, 68,
/* 0x1e30 */ 137,216,193,232, 11, 15,183,202, 15,175,193, 65, 57,194,115, 79,
/* 0x1e40 */  65, 41,200, 65,137,195, 65,193,248,  5, 69,133,255, 66,141,  4,
/* 0x1e50 */   2,102,137,134,224,  1,  0,  0, 15,132, 41,  5,  0,  0, 49,192,
/* 0x1e60 */ 131,124, 36,200,  6, 72,139, 92, 36,232, 15,159,192,141, 68,  0,
/* 0x1e70 */   9,137, 68, 36,200, 68,137,248, 68, 41,240, 68, 15,182, 44,  3,
/* 0x1e80 */  68,137,248, 65,255,199, 68,136, 44,  3,233,216,  4,  0,  0, 65,
/* 0x1e90 */  41,195, 65, 41,194,137,208,102,193,232,  5,102, 41,194,102,137,
/* 0x1ea0 */ 150,224,  1,  0,  0,233, 17,  1,  0,  0, 65, 41,195, 65, 41,194,
/* 0x1eb0 */ 137,208,102,193,232,  5,102, 41,194, 65,129,251,255,255,255,  0,
/* 0x1ec0 */ 102,137,150,152,  1,  0,  0,119, 26, 76, 57,231, 15,132,181,  4,
/* 0x1ed0 */   0,  0, 15,182,  7, 65,193,226,  8, 65,193,227,  8, 72,255,199,
/* 0x1ee0 */  65,  9,194, 15,183,150,176,  1,  0,  0, 68,137,216,193,232, 11,
/* 0x1ef0 */  15,183,202, 15,175,193, 65, 57,194,115, 32, 65,137,195,184,  0,
/* 0x1f00 */   8,  0,  0, 41,200,193,248,  5,141,  4,  2,102,137,134,176,  1,
/* 0x1f10 */   0,  0,139, 68, 36,196,233,152,  0,  0,  0, 65, 41,195, 65, 41,
/* 0x1f20 */ 194,137,208,102,193,232,  5,102, 41,194, 65,129,251,255,255,255,
/* 0x1f30 */   0,102,137,150,176,  1,  0,  0,119, 26, 76, 57,231, 15,132, 68,
/* 0x1f40 */   4,  0,  0, 15,182,  7, 65,193,226,  8, 65,193,227,  8, 72,255,
/* 0x1f50 */ 199, 65,  9,194, 15,183,150,200,  1,  0,  0, 68,137,216,193,232,
/* 0x1f60 */  11, 15,183,202, 15,175,193, 65, 57,194,115, 29, 65,137,195,184,
/* 0x1f70 */   0,  8,  0,  0, 41,200,193,248,  5,141,  4,  2,102,137,134,200,
/* 0x1f80 */   1,  0,  0,139, 68, 36,192,235, 34, 65, 41,195, 65, 41,194,137,
/* 0x1f90 */ 208,102,193,232,  5,102, 41,194,139, 68, 36,188,102,137,150,200,
/* 0x1fa0 */   1,  0,  0,139, 84, 36,192,137, 84, 36,188,139, 76, 36,196,137,
/* 0x1fb0 */  76, 36,192, 68,137,116, 36,196, 65,137,198, 49,192,131,124, 36,
/* 0x1fc0 */ 200,  6, 76,139, 76, 36,216, 15,159,192, 73,129,193,104, 10,  0,
/* 0x1fd0 */   0,141, 68, 64,  8,137, 68, 36,200, 65,129,251,255,255,255,  0,
/* 0x1fe0 */ 119, 26, 76, 57,231, 15,132,156,  3,  0,  0, 15,182,  7, 65,193,
/* 0x1ff0 */ 226,  8, 65,193,227,  8, 72,255,199, 65,  9,194, 65, 15,183, 17,
/* 0x2000 */  68,137,216,193,232, 11, 15,183,202, 15,175,193, 65, 57,194,115,
/* 0x2010 */  39, 65,137,195,184,  0,  8,  0,  0, 69, 49,237, 41,200,193,248,
/* 0x2020 */   5,141,  4,  2,102, 65,137,  1, 72, 99, 68, 36,184, 72,193,224,
/* 0x2030 */   4, 77,141, 68,  1,  4,235,120, 65, 41,195, 65, 41,194,137,208,
/* 0x2040 */ 102,193,232,  5,102, 41,194, 65,129,251,255,255,255,  0,102, 65,
/* 0x2050 */ 137, 17,119, 26, 76, 57,231, 15,132, 42,  3,  0,  0, 15,182,  7,
/* 0x2060 */  65,193,226,  8, 65,193,227,  8, 72,255,199, 65,  9,194, 65, 15,
/* 0x2070 */ 183, 81,  2, 68,137,216,193,232, 11, 15,183,202, 15,175,193, 65,
/* 0x2080 */  57,194,115, 52, 65,137,195,184,  0,  8,  0,  0, 65,189,  8,  0,
/* 0x2090 */   0,  0, 41,200,193,248,  5,141,  4,  2,102, 65,137, 65,  2, 72,
/* 0x20a0 */  99, 68, 36,184, 72,193,224,  4, 77,141,132,  1,  4,  1,  0,  0,
/* 0x20b0 */  65,185,  3,  0,  0,  0,235, 39, 65, 41,195, 65, 41,194,137,208,
/* 0x20c0 */ 102,193,232,  5, 77,141,129,  4,  2,  0,  0, 65,189, 16,  0,  0,
/* 0x20d0 */   0,102, 41,194,102, 65,137, 81,  2, 65,185,  8,  0,  0,  0, 68,
/* 0x20e0 */ 137,203,189,  1,  0,  0,  0, 72, 99,197, 65,129,251,255,255,255,
/* 0x20f0 */   0, 73,141, 52, 64,119, 26, 76, 57,231, 15,132,135,  2,  0,  0,
/* 0x2100 */  15,182,  7, 65,193,226,  8, 65,193,227,  8, 72,255,199, 65,  9,
/* 0x2110 */ 194, 15,183, 14, 68,137,216,193,232, 11, 15,183,209, 15,175,194,
/* 0x2120 */  65, 57,194,115, 23, 65,137,195,184,  0,  8,  0,  0,  1,237, 41,
/* 0x2130 */ 208,193,248,  5,141,  4,  1,102,137,  6,235, 22, 65, 41,195, 65,
/* 0x2140 */  41,194,137,200,102,193,232,  5,141,108, 45,  1,102, 41,193,102,
/* 0x2150 */ 137, 14,255,203,117,145,184,  1,  0,  0,  0, 68,137,201,211,224,
/* 0x2160 */  41,197, 68,  1,237,131,124, 36,200,  3, 15,143,194,  1,  0,  0,
/* 0x2170 */ 131, 68, 36,200,  7,184,  3,  0,  0,  0,131,253,  4, 15, 76,197,
/* 0x2180 */  72,139, 92, 36,216, 65,184,  1,  0,  0,  0, 72,152, 72,193,224,
/* 0x2190 */   7, 76,141,140,  3, 96,  3,  0,  0,187,  6,  0,  0,  0, 73, 99,
/* 0x21a0 */ 192, 65,129,251,255,255,255,  0, 73,141, 52, 65,119, 26, 76, 57,
/* 0x21b0 */ 231, 15,132,208,  1,  0,  0, 15,182,  7, 65,193,226,  8, 65,193,
/* 0x21c0 */ 227,  8, 72,255,199, 65,  9,194, 15,183, 22, 68,137,216,193,232,
/* 0x21d0 */  11, 15,183,202, 15,175,193, 65, 57,194,115, 24, 65,137,195,184,
/* 0x21e0 */   0,  8,  0,  0, 69,  1,192, 41,200,193,248,  5,141,  4,  2,102,
/* 0x21f0 */ 137,  6,235, 23, 65, 41,195, 65, 41,194,137,208,102,193,232,  5,
/* 0x2200 */  71,141, 68,  0,  1,102, 41,194,102,137, 22,255,203,117,143, 65,
/* 0x2210 */ 131,232, 64, 65,131,248,  3, 69,137,198, 15,142, 13,  1,  0,  0,
/* 0x2220 */  65,131,230,  1, 68,137,192,209,248, 65,131,206,  2, 65,131,248,
/* 0x2230 */  13,141,112,255,127, 35,137,241, 72,139, 92, 36,216, 73, 99,192,
/* 0x2240 */  65,211,230, 72,  1,192, 68,137,242, 72,141, 20, 83, 72, 41,194,
/* 0x2250 */  76,141,138, 94,  5,  0,  0,235, 81,141,112,251, 65,129,251,255,
/* 0x2260 */ 255,255,  0,119, 26, 76, 57,231, 15,132, 25,  1,  0,  0, 15,182,
/* 0x2270 */   7, 65,193,226,  8, 65,193,227,  8, 72,255,199, 65,  9,194, 65,
/* 0x2280 */ 209,235, 69,  1,246, 69, 57,218,114,  7, 69, 41,218, 65,131,206,
/* 0x2290 */   1,255,206,117,199, 76,139, 76, 36,216, 65,193,230,  4,190,  4,
/* 0x22a0 */   0,  0,  0, 73,129,193, 68,  6,  0,  0, 65,189,  1,  0,  0,  0,
/* 0x22b0 */ 187,  1,  0,  0,  0, 72, 99,195, 65,129,251,255,255,255,  0, 77,
/* 0x22c0 */ 141,  4, 65,119, 26, 76, 57,231, 15,132,185,  0,  0,  0, 15,182,
/* 0x22d0 */   7, 65,193,226,  8, 65,193,227,  8, 72,255,199, 65,  9,194, 65,
/* 0x22e0 */  15,183, 16, 68,137,216,193,232, 11, 15,183,202, 15,175,193, 65,
/* 0x22f0 */  57,194,115, 24, 65,137,195,184,  0,  8,  0,  0,  1,219, 41,200,
/* 0x2300 */ 193,248,  5,141,  4,  2,102, 65,137,  0,235, 26, 65, 41,195, 65,
/* 0x2310 */  41,194,137,208,102,193,232,  5,141, 92, 27,  1, 69,  9,238,102,
/* 0x2320 */  41,194,102, 65,137, 16, 69,  1,237,255,206,117,136, 65,255,198,
/* 0x2330 */ 116, 64,131,197,  2, 69, 57,254,119, 77, 72,139, 84, 36,232, 68,
/* 0x2340 */ 137,248, 68, 41,240, 68, 15,182, 44,  2, 68,137,248, 65,255,199,
/* 0x2350 */ 255,205, 68,136, 44,  2, 15,149,194, 49,192, 68, 59,124, 36,228,
/* 0x2360 */  15,146,192,133,194,117,211, 68, 59,124, 36,228, 15,130, 69,247,
/* 0x2370 */ 255,255, 65,129,251,255,255,255,  0,119, 22, 76, 57,231,184,  1,
/* 0x2380 */   0,  0,  0,116, 35,235,  7,184,  1,  0,  0,  0,235, 26, 72,255,
/* 0x2390 */ 199,137,248, 43, 68, 36,248, 72,139, 76, 36,240, 72,139, 92, 36,
/* 0x23a0 */  56,137,  1, 68,137, 59, 49,192, 91, 93, 65, 92, 65, 93, 65, 94,
/* 0x23b0 */  65, 95, 72,139,117,248, 72,139,125,  8,139, 75,  4, 72,  1,206,
/* 0x23c0 */ 139, 19, 72,  1,215,201,233,  0,  0,  0,  0,  0, 68,137,193,131,
/* 0x23d0 */ 200,255,204,244, 88, 72, 41,199, 88, 89,137, 57, 72, 41,240,195,
/* 0x23e0 */ 117,112,120,  0, 47,100,101,118, 47,115,104,109,  0, 85, 80, 88,
/* 0x23f0 */  45, 53, 46, 48, 32,119, 97,110,116,115, 32,109,101,109,102,100,
/* 0x2400 */  95, 99,114,101, 97,116,101, 40, 41, 44, 32,111,114, 32,110,101,
/* 0x2410 */ 101,100,115, 32, 47,100,101,118, 47,115,104,109, 40, 44, 79, 95,
/* 0x2420 */  84, 77, 80, 70, 73, 76, 69, 44, 41, 10,  0,117,112,120,  0,117,
/* 0x2430 */ 112,120,  0,  0, 46,115,121,109,116, 97, 98,  0, 46,115,116,114,
/* 0x2440 */ 116, 97, 98,  0, 46,115,104,115,116,114,116, 97, 98,  0, 46,114,
/* 0x2450 */ 101,108, 97, 46,116,101,120,116,  0, 46,114,101,108, 97, 85, 77,
/* 0x2460 */  70, 95, 76, 73, 78, 85, 88,  0, 46,114,101,108, 97, 83, 89, 83,
/* 0x2470 */  67, 65, 76, 76, 83,  0, 69, 88, 80, 95, 72, 69, 65, 68,  0, 46,
/* 0x2480 */ 114,101,108, 97, 78, 82, 86, 50, 69,  0, 46,114,101,108, 97, 78,
/* 0x2490 */  82, 86, 50, 68,  0, 46,114,101,108, 97, 78, 82, 86, 50, 66,  0,
/* 0x24a0 */  46,114,101,108, 97, 76, 90, 77, 65, 95, 68, 65, 73, 83, 89,  0,
/* 0x24b0 */  76, 90, 77, 65, 95, 69, 76, 70, 48, 48,  0, 76, 90, 77, 65, 95,
/* 0x24c0 */  68, 69, 67, 49, 48,  0, 76, 90, 77, 65, 95, 68, 69, 67, 50, 48,
/* 0x24d0 */   0, 46,114,101,108, 97, 76, 90, 77, 65, 95, 68, 69, 67, 51, 48,
/* 0x24e0 */   0, 69, 88, 80, 95, 84, 65, 73, 76,  0, 83, 84, 82, 67, 79, 78,
/* 0x24f0 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x2500 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x2510 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x2520 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x2530 */   0,  0,  0,  0,  0,  0,  0,  0, 32,  0,  0,  0,  1,  0,  0,  0,
/* 0x2540 */   6,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x2550 */  64,  0,  0,  0,  0,  0,  0,  0,205,  9,  0,  0,  0,  0,  0,  0,
/* 0x2560 */   0,  0,  0,  0,  0,  0,  0,  0,  8,  0,  0,  0,  0,  0,  0,  0,
/* 0x2570 */   0,  0,  0,  0,  0,  0,  0,  0, 27,  0,  0,  0,  4,  0,  0,  0,
/* 0x2580 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x2590 */  24, 48,  0,  0,  0,  0,  0,  0,192,  3,  0,  0,  0,  0,  0,  0,
/* 0x25a0 */  24,  0,  0,  0,  1,  0,  0,  0,  8,  0,  0,  0,  0,  0,  0,  0,
/* 0x25b0 */  24,  0,  0,  0,  0,  0,  0,  0, 43,  0,  0,  0,  1,  0,  0,  0,
/* 0x25c0 */   6,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x25d0 */  16, 10,  0,  0,  0,  0,  0,  0,249,  0,  0,  0,  0,  0,  0,  0,
/* 0x25e0 */   0,  0,  0,  0,  0,  0,  0,  0,  4,  0,  0,  0,  0,  0,  0,  0,
/* 0x25f0 */   0,  0,  0,  0,  0,  0,  0,  0, 38,  0,  0,  0,  4,  0,  0,  0,
/* 0x2600 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x2610 */ 216, 51,  0,  0,  0,  0,  0,  0,  8,  1,  0,  0,  0,  0,  0,  0,
/* 0x2620 */  24,  0,  0,  0,  3,  0,  0,  0,  8,  0,  0,  0,  0,  0,  0,  0,
/* 0x2630 */  24,  0,  0,  0,  0,  0,  0,  0, 58,  0,  0,  0,  1,  0,  0,  0,
/* 0x2640 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x2650 */   9, 11,  0,  0,  0,  0,  0,  0,220,  0,  0,  0,  0,  0,  0,  0,
/* 0x2660 */   0,  0,  0,  0,  0,  0,  0,  0,  1,  0,  0,  0,  0,  0,  0,  0,
/* 0x2670 */   0,  0,  0,  0,  0,  0,  0,  0, 53,  0,  0,  0,  4,  0,  0,  0,
/* 0x2680 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x2690 */ 224, 52,  0,  0,  0,  0,  0,  0,144,  0,  0,  0,  0,  0,  0,  0,
/* 0x26a0 */  24,  0,  0,  0,  5,  0,  0,  0,  8,  0,  0,  0,  0,  0,  0,  0,
/* 0x26b0 */  24,  0,  0,  0,  0,  0,  0,  0, 67,  0,  0,  0,  1,  0,  0,  0,
/* 0x26c0 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x26d0 */ 229, 11,  0,  0,  0,  0,  0,  0,233,  0,  0,  0,  0,  0,  0,  0,
/* 0x26e0 */   0,  0,  0,  0,  0,  0,  0,  0,  1,  0,  0,  0,  0,  0,  0,  0,
/* 0x26f0 */   0,  0,  0,  0,  0,  0,  0,  0, 81,  0,  0,  0,  1,  0,  0,  0,
/* 0x2700 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x2710 */ 206, 12,  0,  0,  0,  0,  0,  0,232,  0,  0,  0,  0,  0,  0,  0,
/* 0x2720 */   0,  0,  0,  0,  0,  0,  0,  0,  1,  0,  0,  0,  0,  0,  0,  0,
/* 0x2730 */   0,  0,  0,  0,  0,  0,  0,  0, 76,  0,  0,  0,  4,  0,  0,  0,
/* 0x2740 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x2750 */ 112, 53,  0,  0,  0,  0,  0,  0, 48,  0,  0,  0,  0,  0,  0,  0,
/* 0x2760 */  24,  0,  0,  0,  8,  0,  0,  0,  8,  0,  0,  0,  0,  0,  0,  0,
/* 0x2770 */  24,  0,  0,  0,  0,  0,  0,  0, 92,  0,  0,  0,  1,  0,  0,  0,
/* 0x2780 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x2790 */ 182, 13,  0,  0,  0,  0,  0,  0,219,  0,  0,  0,  0,  0,  0,  0,
/* 0x27a0 */   0,  0,  0,  0,  0,  0,  0,  0,  1,  0,  0,  0,  0,  0,  0,  0,
/* 0x27b0 */   0,  0,  0,  0,  0,  0,  0,  0, 87,  0,  0,  0,  4,  0,  0,  0,
/* 0x27c0 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x27d0 */ 160, 53,  0,  0,  0,  0,  0,  0, 48,  0,  0,  0,  0,  0,  0,  0,
/* 0x27e0 */  24,  0,  0,  0, 10,  0,  0,  0,  8,  0,  0,  0,  0,  0,  0,  0,
/* 0x27f0 */  24,  0,  0,  0,  0,  0,  0,  0,103,  0,  0,  0,  1,  0,  0,  0,
/* 0x2800 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x2810 */ 145, 14,  0,  0,  0,  0,  0,  0,196,  0,  0,  0,  0,  0,  0,  0,
/* 0x2820 */   0,  0,  0,  0,  0,  0,  0,  0,  1,  0,  0,  0,  0,  0,  0,  0,
/* 0x2830 */   0,  0,  0,  0,  0,  0,  0,  0, 98,  0,  0,  0,  4,  0,  0,  0,
/* 0x2840 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x2850 */ 208, 53,  0,  0,  0,  0,  0,  0, 48,  0,  0,  0,  0,  0,  0,  0,
/* 0x2860 */  24,  0,  0,  0, 12,  0,  0,  0,  8,  0,  0,  0,  0,  0,  0,  0,
/* 0x2870 */  24,  0,  0,  0,  0,  0,  0,  0,114,  0,  0,  0,  1,  0,  0,  0,
/* 0x2880 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x2890 */  85, 15,  0,  0,  0,  0,  0,  0, 10,  0,  0,  0,  0,  0,  0,  0,
/* 0x28a0 */   0,  0,  0,  0,  0,  0,  0,  0,  1,  0,  0,  0,  0,  0,  0,  0,
/* 0x28b0 */   0,  0,  0,  0,  0,  0,  0,  0,109,  0,  0,  0,  4,  0,  0,  0,
/* 0x28c0 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x28d0 */   0, 54,  0,  0,  0,  0,  0,  0, 24,  0,  0,  0,  0,  0,  0,  0,
/* 0x28e0 */  24,  0,  0,  0, 14,  0,  0,  0,  8,  0,  0,  0,  0,  0,  0,  0,
/* 0x28f0 */  24,  0,  0,  0,  0,  0,  0,  0,125,  0,  0,  0,  1,  0,  0,  0,
/* 0x2900 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x2910 */  95, 15,  0,  0,  0,  0,  0,  0,101,  0,  0,  0,  0,  0,  0,  0,
/* 0x2920 */   0,  0,  0,  0,  0,  0,  0,  0,  1,  0,  0,  0,  0,  0,  0,  0,
/* 0x2930 */   0,  0,  0,  0,  0,  0,  0,  0,136,  0,  0,  0,  1,  0,  0,  0,
/* 0x2940 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x2950 */ 196, 15,  0,  0,  0,  0,  0,  0,247,  9,  0,  0,  0,  0,  0,  0,
/* 0x2960 */   0,  0,  0,  0,  0,  0,  0,  0,  1,  0,  0,  0,  0,  0,  0,  0,
/* 0x2970 */   0,  0,  0,  0,  0,  0,  0,  0,147,  0,  0,  0,  1,  0,  0,  0,
/* 0x2980 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x2990 */ 187, 25,  0,  0,  0,  0,  0,  0,247,  9,  0,  0,  0,  0,  0,  0,
/* 0x29a0 */   0,  0,  0,  0,  0,  0,  0,  0,  1,  0,  0,  0,  0,  0,  0,  0,
/* 0x29b0 */   0,  0,  0,  0,  0,  0,  0,  0,163,  0,  0,  0,  1,  0,  0,  0,
/* 0x29c0 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x29d0 */ 178, 35,  0,  0,  0,  0,  0,  0, 25,  0,  0,  0,  0,  0,  0,  0,
/* 0x29e0 */   0,  0,  0,  0,  0,  0,  0,  0,  1,  0,  0,  0,  0,  0,  0,  0,
/* 0x29f0 */   0,  0,  0,  0,  0,  0,  0,  0,158,  0,  0,  0,  4,  0,  0,  0,
/* 0x2a00 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x2a10 */  24, 54,  0,  0,  0,  0,  0,  0, 24,  0,  0,  0,  0,  0,  0,  0,
/* 0x2a20 */  24,  0,  0,  0, 19,  0,  0,  0,  8,  0,  0,  0,  0,  0,  0,  0,
/* 0x2a30 */  24,  0,  0,  0,  0,  0,  0,  0,174,  0,  0,  0,  1,  0,  0,  0,
/* 0x2a40 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x2a50 */ 204, 35,  0,  0,  0,  0,  0,  0, 20,  0,  0,  0,  0,  0,  0,  0,
/* 0x2a60 */   0,  0,  0,  0,  0,  0,  0,  0,  4,  0,  0,  0,  0,  0,  0,  0,
/* 0x2a70 */   0,  0,  0,  0,  0,  0,  0,  0,183,  0,  0,  0,  1,  0,  0,  0,
/* 0x2a80 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x2a90 */ 224, 35,  0,  0,  0,  0,  0,  0, 83,  0,  0,  0,  0,  0,  0,  0,
/* 0x2aa0 */   0,  0,  0,  0,  0,  0,  0,  0,  1,  0,  0,  0,  0,  0,  0,  0,
/* 0x2ab0 */   0,  0,  0,  0,  0,  0,  0,  0, 17,  0,  0,  0,  3,  0,  0,  0,
/* 0x2ac0 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x2ad0 */  51, 36,  0,  0,  0,  0,  0,  0,190,  0,  0,  0,  0,  0,  0,  0,
/* 0x2ae0 */   0,  0,  0,  0,  0,  0,  0,  0,  1,  0,  0,  0,  0,  0,  0,  0,
/* 0x2af0 */   0,  0,  0,  0,  0,  0,  0,  0,  1,  0,  0,  0,  2,  0,  0,  0,
/* 0x2b00 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x2b10 */ 120, 43,  0,  0,  0,  0,  0,  0,192,  3,  0,  0,  0,  0,  0,  0,
/* 0x2b20 */  25,  0,  0,  0, 15,  0,  0,  0,  8,  0,  0,  0,  0,  0,  0,  0,
/* 0x2b30 */  24,  0,  0,  0,  0,  0,  0,  0,  9,  0,  0,  0,  3,  0,  0,  0,
/* 0x2b40 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x2b50 */  56, 47,  0,  0,  0,  0,  0,  0,217,  0,  0,  0,  0,  0,  0,  0,
/* 0x2b60 */   0,  0,  0,  0,  0,  0,  0,  0,  1,  0,  0,  0,  0,  0,  0,  0,
/* 0x2b70 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x2b80 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x2b90 */   0,  0,  0,  0,  3,  0,  1,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x2ba0 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  3,  0,  5,  0,
/* 0x2bb0 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x2bc0 */   0,  0,  0,  0,  3,  0,  7,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x2bd0 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  3,  0, 19,  0,
/* 0x2be0 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x2bf0 */   0,  0,  0,  0,  3,  0, 21,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x2c00 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  3,  0, 22,  0,
/* 0x2c10 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x2c20 */   0,  0,  0,  0,  3,  0,  3,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x2c30 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  3,  0,  8,  0,
/* 0x2c40 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x2c50 */   0,  0,  0,  0,  3,  0, 10,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x2c60 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  3,  0, 12,  0,
/* 0x2c70 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x2c80 */   0,  0,  0,  0,  3,  0, 14,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x2c90 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  3,  0, 16,  0,
/* 0x2ca0 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x2cb0 */   0,  0,  0,  0,  3,  0, 17,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x2cc0 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  3,  0, 18,  0,
/* 0x2cd0 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x2ce0 */   1,  0,  0,  0, 16,  0,  5,  0, 74,  0,  0,  0,  0,  0,  0,  0,
/* 0x2cf0 */   0,  0,  0,  0,  0,  0,  0,  0,  6,  0,  0,  0, 16,  0,  7,  0,
/* 0x2d00 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x2d10 */  15,  0,  0,  0, 16,  0,  1,  0, 93,  1,  0,  0,  0,  0,  0,  0,
/* 0x2d20 */   0,  0,  0,  0,  0,  0,  0,  0, 29,  0,  0,  0, 16,  0,  5,  0,
/* 0x2d30 */ 180,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x2d40 */  36,  0,  0,  0, 16,  0, 21,  0, 20,  0,  0,  0,  0,  0,  0,  0,
/* 0x2d50 */   0,  0,  0,  0,  0,  0,  0,  0, 52,  0,  0,  0, 16,  0,  5,  0,
/* 0x2d60 */ 118,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x2d70 */  58,  0,  0,  0, 16,  0,  5,  0,196,  0,  0,  0,  0,  0,  0,  0,
/* 0x2d80 */   0,  0,  0,  0,  0,  0,  0,  0, 68,  0,  0,  0, 16,  0,  5,  0,
/* 0x2d90 */  91,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x2da0 */  73,  0,  0,  0, 18,  0,  3,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x2db0 */ 249,  0,  0,  0,  0,  0,  0,  0, 95,  0,  0,  0, 16,  0,  5,  0,
/* 0x2dc0 */ 212,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x2dd0 */ 101,  0,  0,  0, 18,  0,  1,  0,152,  8,  0,  0,  0,  0,  0,  0,
/* 0x2de0 */  53,  1,  0,  0,  0,  0,  0,  0,111,  0,  0,  0, 16,  0,  0,  0,
/* 0x2df0 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x2e00 */ 124,  0,  0,  0, 16,  0,  5,  0,216,  0,  0,  0,  0,  0,  0,  0,
/* 0x2e10 */   0,  0,  0,  0,  0,  0,  0,  0,129,  0,  0,  0, 18,  0,  1,  0,
/* 0x2e20 */ 198,  2,  0,  0,  0,  0,  0,  0, 75,  0,  0,  0,  0,  0,  0,  0,
/* 0x2e30 */ 138,  0,  0,  0, 16,  0,  5,  0,208,  0,  0,  0,  0,  0,  0,  0,
/* 0x2e40 */   0,  0,  0,  0,  0,  0,  0,  0,144,  0,  0,  0, 16,  0,  5,  0,
/* 0x2e50 */  17,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x2e60 */ 157,  0,  0,  0, 16,  0,  5,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x2e70 */   0,  0,  0,  0,  0,  0,  0,  0,165,  0,  0,  0, 16,  0,  5,  0,
/* 0x2e80 */ 143,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x2e90 */ 174,  0,  0,  0, 16,  0,  5,  0,212,  0,  0,  0,  0,  0,  0,  0,
/* 0x2ea0 */   0,  0,  0,  0,  0,  0,  0,  0,181,  0,  0,  0, 16,  0,  5,  0,
/* 0x2eb0 */ 164,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x2ec0 */ 188,  0,  0,  0, 16,  0,  5,  0,184,  0,  0,  0,  0,  0,  0,  0,
/* 0x2ed0 */   0,  0,  0,  0,  0,  0,  0,  0,193,  0,  0,  0, 16,  0,  5,  0,
/* 0x2ee0 */ 188,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x2ef0 */ 197,  0,  0,  0, 16,  0,  5,  0,200,  0,  0,  0,  0,  0,  0,  0,
/* 0x2f00 */   0,  0,  0,  0,  0,  0,  0,  0,202,  0,  0,  0, 16,  0,  5,  0,
/* 0x2f10 */ 204,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x2f20 */ 211,  0,  0,  0, 16,  0,  5,  0,192,  0,  0,  0,  0,  0,  0,  0,
/* 0x2f30 */   0,  0,  0,  0,  0,  0,  0,  0,  0, 80,109, 97,112,  0,102, 95,
/* 0x2f40 */ 101,120,112, 97,110,100,  0,103,101,116, 95,112, 97,103,101, 95,
/* 0x2f50 */ 109, 97,115,107,  0,109,117,110,109, 97,112,  0,117,112,120, 95,
/* 0x2f60 */ 109,109, 97,112, 95, 97,110,100, 95,102,100,  0, 80,115,121,110,
/* 0x2f70 */  99,  0,102,116,114,117,110, 99, 97,116,101,  0,109,109, 97,112,
/* 0x2f80 */   0,117,112,120, 95,109,109, 97,112, 95, 97,110,100, 95,102,100,
/* 0x2f90 */  95,108,105,110,117,120,  0,119,114,105,116,101,  0,117,112,120,
/* 0x2fa0 */  95,109, 97,105,110, 50,  0,109,101,109,102,100, 95, 99,114,101,
/* 0x2fb0 */  97,116,101,  0,114,101, 97,100,  0,117,110,100,101,114,108, 97,
/* 0x2fc0 */ 121,  0,109,115,121,110, 99,  0,117,112,120,102,100, 95, 99,114,
/* 0x2fd0 */ 101, 97,116,101,  0,109,121, 95, 98,107,112,116,  0, 80,112,114,
/* 0x2fe0 */ 111,116,101, 99,116,  0, 80,119,114,105,116,101,  0, 80,117,110,
/* 0x2ff0 */ 109, 97,112,  0,101,120,105,116,  0, 98,114,107,  0,111,112,101,
/* 0x3000 */ 110,  0,109,112,114,111,116,101, 99,116,  0, 99,108,111,115,101,
/* 0x3010 */   0,  0,  0,  0,  0,  0,  0,  0,120,  0,  0,  0,  0,  0,  0,  0,
/* 0x3020 */   2,  0,  0,  0,  2,  0,  0,  0,254,255,255,255,255,255,255,255,
/* 0x3030 */ 127,  0,  0,  0,  0,  0,  0,  0,  2,  0,  0,  0, 37,  0,  0,  0,
/* 0x3040 */ 252,255,255,255,255,255,255,255,  8,  1,  0,  0,  0,  0,  0,  0,
/* 0x3050 */   2,  0,  0,  0, 25,  0,  0,  0,252,255,255,255,255,255,255,255,
/* 0x3060 */  37,  1,  0,  0,  0,  0,  0,  0,  2,  0,  0,  0, 36,  0,  0,  0,
/* 0x3070 */ 252,255,255,255,255,255,255,255, 45,  1,  0,  0,  0,  0,  0,  0,
/* 0x3080 */   2,  0,  0,  0, 18,  0,  0,  0,252,255,255,255,255,255,255,255,
/* 0x3090 */  73,  1,  0,  0,  0,  0,  0,  0,  2,  0,  0,  0, 22,  0,  0,  0,
/* 0x30a0 */ 252,255,255,255,255,255,255,255, 80,  1,  0,  0,  0,  0,  0,  0,
/* 0x30b0 */   2,  0,  0,  0, 39,  0,  0,  0,252,255,255,255,255,255,255,255,
/* 0x30c0 */ 124,  1,  0,  0,  0,  0,  0,  0,  4,  0,  0,  0, 35,  0,  0,  0,
/* 0x30d0 */ 252,255,255,255,255,255,255,255,242,  1,  0,  0,  0,  0,  0,  0,
/* 0x30e0 */   4,  0,  0,  0, 35,  0,  0,  0,252,255,255,255,255,255,255,255,
/* 0x30f0 */  29,  2,  0,  0,  0,  0,  0,  0,  4,  0,  0,  0, 16,  0,  0,  0,
/* 0x3100 */ 252,255,255,255,255,255,255,255,186,  2,  0,  0,  0,  0,  0,  0,
/* 0x3110 */   4,  0,  0,  0, 35,  0,  0,  0,252,255,255,255,255,255,255,255,
/* 0x3120 */ 246,  2,  0,  0,  0,  0,  0,  0,  4,  0,  0,  0, 22,  0,  0,  0,
/* 0x3130 */ 252,255,255,255,255,255,255,255,147,  3,  0,  0,  0,  0,  0,  0,
/* 0x3140 */   4,  0,  0,  0, 18,  0,  0,  0,252,255,255,255,255,255,255,255,
/* 0x3150 */ 210,  3,  0,  0,  0,  0,  0,  0,  4,  0,  0,  0, 17,  0,  0,  0,
/* 0x3160 */ 252,255,255,255,255,255,255,255,118,  4,  0,  0,  0,  0,  0,  0,
/* 0x3170 */   4,  0,  0,  0, 22,  0,  0,  0,252,255,255,255,255,255,255,255,
/* 0x3180 */ 161,  4,  0,  0,  0,  0,  0,  0,  4,  0,  0,  0, 18,  0,  0,  0,
/* 0x3190 */ 252,255,255,255,255,255,255,255,179,  4,  0,  0,  0,  0,  0,  0,
/* 0x31a0 */   4,  0,  0,  0, 18,  0,  0,  0,252,255,255,255,255,255,255,255,
/* 0x31b0 */ 202,  4,  0,  0,  0,  0,  0,  0,  4,  0,  0,  0, 17,  0,  0,  0,
/* 0x31c0 */ 252,255,255,255,255,255,255,255, 11,  6,  0,  0,  0,  0,  0,  0,
/* 0x31d0 */   2,  0,  0,  0,  6,  0,  0,  0, 71,  0,  0,  0,  0,  0,  0,  0,
/* 0x31e0 */  16,  6,  0,  0,  0,  0,  0,  0,  4,  0,  0,  0, 30,  0,  0,  0,
/* 0x31f0 */ 252,255,255,255,255,255,255,255, 30,  6,  0,  0,  0,  0,  0,  0,
/* 0x3200 */   4,  0,  0,  0, 21,  0,  0,  0,252,255,255,255,255,255,255,255,
/* 0x3210 */  91,  6,  0,  0,  0,  0,  0,  0,  4,  0,  0,  0, 22,  0,  0,  0,
/* 0x3220 */ 252,255,255,255,255,255,255,255,133,  6,  0,  0,  0,  0,  0,  0,
/* 0x3230 */   4,  0,  0,  0, 22,  0,  0,  0,252,255,255,255,255,255,255,255,
/* 0x3240 */  80,  7,  0,  0,  0,  0,  0,  0,  2,  0,  0,  0,  6,  0,  0,  0,
/* 0x3250 */  75,  0,  0,  0,  0,  0,  0,  0, 85,  7,  0,  0,  0,  0,  0,  0,
/* 0x3260 */   4,  0,  0,  0, 30,  0,  0,  0,252,255,255,255,255,255,255,255,
/* 0x3270 */ 104,  7,  0,  0,  0,  0,  0,  0,  4,  0,  0,  0, 24,  0,  0,  0,
/* 0x3280 */ 252,255,255,255,255,255,255,255,132,  7,  0,  0,  0,  0,  0,  0,
/* 0x3290 */   4,  0,  0,  0, 22,  0,  0,  0,252,255,255,255,255,255,255,255,
/* 0x32a0 */ 142,  7,  0,  0,  0,  0,  0,  0,  4,  0,  0,  0, 39,  0,  0,  0,
/* 0x32b0 */ 252,255,255,255,255,255,255,255,182,  7,  0,  0,  0,  0,  0,  0,
/* 0x32c0 */   4,  0,  0,  0, 20,  0,  0,  0,252,255,255,255,255,255,255,255,
/* 0x32d0 */ 193,  7,  0,  0,  0,  0,  0,  0,  4,  0,  0,  0, 18,  0,  0,  0,
/* 0x32e0 */ 252,255,255,255,255,255,255,255,221,  7,  0,  0,  0,  0,  0,  0,
/* 0x32f0 */   4,  0,  0,  0, 22,  0,  0,  0,252,255,255,255,255,255,255,255,
/* 0x3300 */ 235,  7,  0,  0,  0,  0,  0,  0,  4,  0,  0,  0, 39,  0,  0,  0,
/* 0x3310 */ 252,255,255,255,255,255,255,255,  3,  8,  0,  0,  0,  0,  0,  0,
/* 0x3320 */   4,  0,  0,  0, 32,  0,  0,  0,252,255,255,255,255,255,255,255,
/* 0x3330 */  17,  8,  0,  0,  0,  0,  0,  0,  4,  0,  0,  0, 35,  0,  0,  0,
/* 0x3340 */ 252,255,255,255,255,255,255,255, 58,  8,  0,  0,  0,  0,  0,  0,
/* 0x3350 */   4,  0,  0,  0, 22,  0,  0,  0,252,255,255,255,255,255,255,255,
/* 0x3360 */ 242,  8,  0,  0,  0,  0,  0,  0,  4,  0,  0,  0, 17,  0,  0,  0,
/* 0x3370 */ 252,255,255,255,255,255,255,255, 70,  9,  0,  0,  0,  0,  0,  0,
/* 0x3380 */   4,  0,  0,  0, 37,  0,  0,  0,252,255,255,255,255,255,255,255,
/* 0x3390 */  91,  9,  0,  0,  0,  0,  0,  0,  4,  0,  0,  0, 27,  0,  0,  0,
/* 0x33a0 */ 252,255,255,255,255,255,255,255,109,  9,  0,  0,  0,  0,  0,  0,
/* 0x33b0 */   4,  0,  0,  0, 35,  0,  0,  0,252,255,255,255,255,255,255,255,
/* 0x33c0 */ 159,  9,  0,  0,  0,  0,  0,  0,  4,  0,  0,  0, 39,  0,  0,  0,
/* 0x33d0 */ 252,255,255,255,255,255,255,255, 33,  0,  0,  0,  0,  0,  0,  0,
/* 0x33e0 */   2,  0,  0,  0,  6,  0,  0,  0,252,255,255,255,255,255,255,255,
/* 0x33f0 */  46,  0,  0,  0,  0,  0,  0,  0,  4,  0,  0,  0, 26,  0,  0,  0,
/* 0x3400 */ 252,255,255,255,255,255,255,255, 66,  0,  0,  0,  0,  0,  0,  0,
/* 0x3410 */   4,  0,  0,  0, 26,  0,  0,  0,252,255,255,255,255,255,255,255,
/* 0x3420 */  79,  0,  0,  0,  0,  0,  0,  0,  2,  0,  0,  0,  6,  0,  0,  0,
/* 0x3430 */   0,  0,  0,  0,  0,  0,  0,  0, 94,  0,  0,  0,  0,  0,  0,  0,
/* 0x3440 */   4,  0,  0,  0, 37,  0,  0,  0,252,255,255,255,255,255,255,255,
/* 0x3450 */ 115,  0,  0,  0,  0,  0,  0,  0,  2,  0,  0,  0,  6,  0,  0,  0,
/* 0x3460 */   9,  0,  0,  0,  0,  0,  0,  0,130,  0,  0,  0,  0,  0,  0,  0,
/* 0x3470 */   4,  0,  0,  0, 24,  0,  0,  0,252,255,255,255,255,255,255,255,
/* 0x3480 */ 140,  0,  0,  0,  0,  0,  0,  0,  4,  0,  0,  0, 35,  0,  0,  0,
/* 0x3490 */ 252,255,255,255,255,255,255,255,150,  0,  0,  0,  0,  0,  0,  0,
/* 0x34a0 */   4,  0,  0,  0, 21,  0,  0,  0,252,255,255,255,255,255,255,255,
/* 0x34b0 */ 194,  0,  0,  0,  0,  0,  0,  0,  4,  0,  0,  0, 22,  0,  0,  0,
/* 0x34c0 */ 252,255,255,255,255,255,255,255,202,  0,  0,  0,  0,  0,  0,  0,
/* 0x34d0 */   4,  0,  0,  0, 17,  0,  0,  0,252,255,255,255,255,255,255,255,
/* 0x34e0 */  77,  0,  0,  0,  0,  0,  0,  0,  2,  0,  0,  0,  1,  0,  0,  0,
/* 0x34f0 */ 252,255,255,255,255,255,255,255,120,  0,  0,  0,  0,  0,  0,  0,
/* 0x3500 */   2,  0,  0,  0,  1,  0,  0,  0,252,255,255,255,255,255,255,255,
/* 0x3510 */ 145,  0,  0,  0,  0,  0,  0,  0,  2,  0,  0,  0,  1,  0,  0,  0,
/* 0x3520 */ 252,255,255,255,255,255,255,255,166,  0,  0,  0,  0,  0,  0,  0,
/* 0x3530 */   2,  0,  0,  0,  1,  0,  0,  0,252,255,255,255,255,255,255,255,
/* 0x3540 */ 139,  0,  0,  0,  0,  0,  0,  0,  2,  0,  0,  0, 29,  0,  0,  0,
/* 0x3550 */ 252,255,255,255,255,255,255,255,160,  0,  0,  0,  0,  0,  0,  0,
/* 0x3560 */   2,  0,  0,  0, 38,  0,  0,  0,252,255,255,255,255,255,255,255,
/* 0x3570 */ 223,  0,  0,  0,  0,  0,  0,  0,  2,  0,  0,  0,  3,  0,  0,  0,
/* 0x3580 */ 165,  0,  0,  0,  0,  0,  0,  0,116,  0,  0,  0,  0,  0,  0,  0,
/* 0x3590 */   2,  0,  0,  0,  5,  0,  0,  0,  4,  0,  0,  0,  0,  0,  0,  0,
/* 0x35a0 */ 210,  0,  0,  0,  0,  0,  0,  0,  2,  0,  0,  0,  3,  0,  0,  0,
/* 0x35b0 */ 165,  0,  0,  0,  0,  0,  0,  0,116,  0,  0,  0,  0,  0,  0,  0,
/* 0x35c0 */   2,  0,  0,  0,  5,  0,  0,  0,  4,  0,  0,  0,  0,  0,  0,  0,
/* 0x35d0 */ 187,  0,  0,  0,  0,  0,  0,  0,  2,  0,  0,  0,  3,  0,  0,  0,
/* 0x35e0 */ 165,  0,  0,  0,  0,  0,  0,  0, 95,  0,  0,  0,  0,  0,  0,  0,
/* 0x35f0 */   2,  0,  0,  0,  5,  0,  0,  0,  4,  0,  0,  0,  0,  0,  0,  0,
/* 0x3600 */   6,  0,  0,  0,  0,  0,  0,  0,  2,  0,  0,  0,  4,  0,  0,  0,
/* 0x3610 */  21,  0,  0,  0,  0,  0,  0,  0, 21,  0,  0,  0,  0,  0,  0,  0,
/* 0x3620 */   2,  0,  0,  0,  5,  0,  0,  0,  4,  0,  0,  0,  0,  0,  0,  0,
/* 0x3630 */ 102,105,108,101, 32,102,111,114,109, 97,116, 32,101,108,102, 54,
/* 0x3640 */  52, 45,120, 56, 54, 45, 54, 52, 10, 10, 83,101, 99,116,105,111,
/* 0x3650 */ 110,115, 58, 10, 73,100,120, 32, 78, 97,109,101, 32, 32, 32, 32,
/* 0x3660 */  32, 32, 32, 32, 32, 32, 83,105,122,101, 32, 32, 32, 32, 32, 32,
/* 0x3670 */  86, 77, 65, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x3680 */  32, 32, 76, 77, 65, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x3690 */  32, 32, 32, 32, 70,105,108,101, 32,111,102,102, 32, 32, 65,108,
/* 0x36a0 */ 103,110, 32, 32, 70,108, 97,103,115, 10, 32, 32, 48, 32, 46,116,
/* 0x36b0 */ 101,120,116, 32, 32, 32, 32, 32, 32, 32, 32, 32, 48, 57, 99,100,
/* 0x36c0 */  32, 32, 48, 32, 32, 48, 32, 32, 48, 52, 48, 32, 32, 50, 42, 42,
/* 0x36d0 */  51, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 32, 49, 32,
/* 0x36e0 */  85, 77, 70, 95, 76, 73, 78, 85, 88, 32, 32, 32, 32, 32, 48,102,
/* 0x36f0 */  57, 32, 32, 48, 32, 32, 48, 32, 32, 48, 97, 49, 48, 32, 32, 50,
/* 0x3700 */  42, 42, 50, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 32,
/* 0x3710 */  50, 32, 83, 89, 83, 67, 65, 76, 76, 83, 32, 32, 32, 32, 32, 32,
/* 0x3720 */  48,100, 99, 32, 32, 48, 32, 32, 48, 32, 32, 48, 98, 48, 57, 32,
/* 0x3730 */  32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10,
/* 0x3740 */  32, 32, 51, 32, 69, 88, 80, 95, 72, 69, 65, 68, 32, 32, 32, 32,
/* 0x3750 */  32, 32, 48,101, 57, 32, 32, 48, 32, 32, 48, 32, 32, 48, 98,101,
/* 0x3760 */  53, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84,
/* 0x3770 */  83, 10, 32, 32, 52, 32, 78, 82, 86, 50, 69, 32, 32, 32, 32, 32,
/* 0x3780 */  32, 32, 32, 32, 48,101, 56, 32, 32, 48, 32, 32, 48, 32, 32, 48,
/* 0x3790 */  99, 99,101, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69,
/* 0x37a0 */  78, 84, 83, 10, 32, 32, 53, 32, 78, 82, 86, 50, 68, 32, 32, 32,
/* 0x37b0 */  32, 32, 32, 32, 32, 32, 48,100, 98, 32, 32, 48, 32, 32, 48, 32,
/* 0x37c0 */  32, 48,100, 98, 54, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78,
/* 0x37d0 */  84, 69, 78, 84, 83, 10, 32, 32, 54, 32, 78, 82, 86, 50, 66, 32,
/* 0x37e0 */  32, 32, 32, 32, 32, 32, 32, 32, 48, 99, 52, 32, 32, 48, 32, 32,
/* 0x37f0 */  48, 32, 32, 48,101, 57, 49, 32, 32, 50, 42, 42, 48, 32, 32, 67,
/* 0x3800 */  79, 78, 84, 69, 78, 84, 83, 10, 32, 32, 55, 32, 76, 90, 77, 65,
/* 0x3810 */  95, 68, 65, 73, 83, 89, 32, 32, 32, 32, 48, 97, 32, 32, 48, 32,
/* 0x3820 */  32, 48, 32, 32, 48,102, 53, 53, 32, 32, 50, 42, 42, 48, 32, 32,
/* 0x3830 */  67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 32, 56, 32, 76, 90, 77,
/* 0x3840 */  65, 95, 69, 76, 70, 48, 48, 32, 32, 32, 32, 48, 54, 53, 32, 32,
/* 0x3850 */  48, 32, 32, 48, 32, 32, 48,102, 53,102, 32, 32, 50, 42, 42, 48,
/* 0x3860 */  32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 32, 57, 32, 76,
/* 0x3870 */  90, 77, 65, 95, 68, 69, 67, 49, 48, 32, 32, 32, 32, 48, 57,102,
/* 0x3880 */  55, 32, 32, 48, 32, 32, 48, 32, 32, 48,102, 99, 52, 32, 32, 50,
/* 0x3890 */  42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 49,
/* 0x38a0 */  48, 32, 76, 90, 77, 65, 95, 68, 69, 67, 50, 48, 32, 32, 32, 32,
/* 0x38b0 */  48, 57,102, 55, 32, 32, 48, 32, 32, 48, 32, 32, 48, 49, 57, 98,
/* 0x38c0 */  98, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84,
/* 0x38d0 */  83, 10, 32, 49, 49, 32, 76, 90, 77, 65, 95, 68, 69, 67, 51, 48,
/* 0x38e0 */  32, 32, 32, 32, 48, 49, 57, 32, 32, 48, 32, 32, 48, 32, 32, 48,
/* 0x38f0 */  50, 51, 98, 50, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84,
/* 0x3900 */  69, 78, 84, 83, 10, 32, 49, 50, 32, 69, 88, 80, 95, 84, 65, 73,
/* 0x3910 */  76, 32, 32, 32, 32, 32, 32, 48, 49, 52, 32, 32, 48, 32, 32, 48,
/* 0x3920 */  32, 32, 48, 50, 51, 99, 99, 32, 32, 50, 42, 42, 50, 32, 32, 67,
/* 0x3930 */  79, 78, 84, 69, 78, 84, 83, 10, 32, 49, 51, 32, 83, 84, 82, 67,
/* 0x3940 */  79, 78, 32, 32, 32, 32, 32, 32, 32, 32, 48, 53, 51, 32, 32, 48,
/* 0x3950 */  32, 32, 48, 32, 32, 48, 50, 51,101, 48, 32, 32, 50, 42, 42, 48,
/* 0x3960 */  32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 83, 89, 77, 66, 79,
/* 0x3970 */  76, 32, 84, 65, 66, 76, 69, 58, 10, 48, 48, 48, 48, 48, 48, 48,
/* 0x3980 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100,
/* 0x3990 */  32, 32, 46,116,101,120,116, 32, 48, 32, 46,116,101,120,116, 10,
/* 0x39a0 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x39b0 */  32,108, 32, 32, 32, 32,100, 32, 32, 83, 89, 83, 67, 65, 76, 76,
/* 0x39c0 */  83, 32, 48, 32, 83, 89, 83, 67, 65, 76, 76, 83, 10, 48, 48, 48,
/* 0x39d0 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32,
/* 0x39e0 */  32, 32, 32,100, 32, 32, 69, 88, 80, 95, 72, 69, 65, 68, 32, 48,
/* 0x39f0 */  32, 69, 88, 80, 95, 72, 69, 65, 68, 10, 48, 48, 48, 48, 48, 48,
/* 0x3a00 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,
/* 0x3a10 */ 100, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 51, 48, 32, 48, 32,
/* 0x3a20 */  76, 90, 77, 65, 95, 68, 69, 67, 51, 48, 10, 48, 48, 48, 48, 48,
/* 0x3a30 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32,
/* 0x3a40 */  32,100, 32, 32, 69, 88, 80, 95, 84, 65, 73, 76, 32, 48, 32, 69,
/* 0x3a50 */  88, 80, 95, 84, 65, 73, 76, 10, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x3a60 */  48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32,
/* 0x3a70 */  32, 83, 84, 82, 67, 79, 78, 32, 48, 32, 83, 84, 82, 67, 79, 78,
/* 0x3a80 */  10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x3a90 */  48, 32,108, 32, 32, 32, 32,100, 32, 32, 85, 77, 70, 95, 76, 73,
/* 0x3aa0 */  78, 85, 88, 32, 48, 32, 85, 77, 70, 95, 76, 73, 78, 85, 88, 10,
/* 0x3ab0 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x3ac0 */  32,108, 32, 32, 32, 32,100, 32, 32, 78, 82, 86, 50, 69, 32, 48,
/* 0x3ad0 */  32, 78, 82, 86, 50, 69, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x3ae0 */  48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32,
/* 0x3af0 */  78, 82, 86, 50, 68, 32, 48, 32, 78, 82, 86, 50, 68, 10, 48, 48,
/* 0x3b00 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32,108,
/* 0x3b10 */  32, 32, 32, 32,100, 32, 32, 78, 82, 86, 50, 66, 32, 48, 32, 78,
/* 0x3b20 */  82, 86, 50, 66, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x3b30 */  48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 76, 90,
/* 0x3b40 */  77, 65, 95, 68, 65, 73, 83, 89, 32, 48, 32, 76, 90, 77, 65, 95,
/* 0x3b50 */  68, 65, 73, 83, 89, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x3b60 */  48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 76,
/* 0x3b70 */  90, 77, 65, 95, 69, 76, 70, 48, 48, 32, 48, 32, 76, 90, 77, 65,
/* 0x3b80 */  95, 69, 76, 70, 48, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x3b90 */  48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32,
/* 0x3ba0 */  76, 90, 77, 65, 95, 68, 69, 67, 49, 48, 32, 48, 32, 76, 90, 77,
/* 0x3bb0 */  65, 95, 68, 69, 67, 49, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x3bc0 */  48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32,
/* 0x3bd0 */  32, 76, 90, 77, 65, 95, 68, 69, 67, 50, 48, 32, 48, 32, 76, 90,
/* 0x3be0 */  77, 65, 95, 68, 69, 67, 50, 48, 10, 48, 48, 48, 48, 48, 48, 48,
/* 0x3bf0 */  48, 48, 48, 48, 48, 48, 48, 52, 97, 32,103, 32, 32, 32, 32, 32,
/* 0x3c00 */  32, 32, 83, 89, 83, 67, 65, 76, 76, 83, 32, 48, 32, 80,109, 97,
/* 0x3c10 */ 112, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x3c20 */  48, 48, 32,103, 32, 32, 32, 32, 32, 32, 32, 69, 88, 80, 95, 72,
/* 0x3c30 */  69, 65, 68, 32, 48, 32,102, 95,101,120,112, 97,110,100, 10, 48,
/* 0x3c40 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 49, 53,100, 32,
/* 0x3c50 */ 103, 32, 32, 32, 32, 32, 32, 32, 46,116,101,120,116, 32, 48, 32,
/* 0x3c60 */ 103,101,116, 95,112, 97,103,101, 95,109, 97,115,107, 10, 48, 48,
/* 0x3c70 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 98, 52, 32,103,
/* 0x3c80 */  32, 32, 32, 32, 32, 32, 32, 83, 89, 83, 67, 65, 76, 76, 83, 32,
/* 0x3c90 */  48, 32,109,117,110,109, 97,112, 10, 48, 48, 48, 48, 48, 48, 48,
/* 0x3ca0 */  48, 48, 48, 48, 48, 48, 48, 49, 52, 32,103, 32, 32, 32, 32, 32,
/* 0x3cb0 */  32, 32, 69, 88, 80, 95, 84, 65, 73, 76, 32, 48, 32,117,112,120,
/* 0x3cc0 */  95,109,109, 97,112, 95, 97,110,100, 95,102,100, 10, 48, 48, 48,
/* 0x3cd0 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 55, 54, 32,103, 32,
/* 0x3ce0 */  32, 32, 32, 32, 32, 32, 83, 89, 83, 67, 65, 76, 76, 83, 32, 48,
/* 0x3cf0 */  32, 80,115,121,110, 99, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x3d00 */  48, 48, 48, 48, 48, 99, 52, 32,103, 32, 32, 32, 32, 32, 32, 32,
/* 0x3d10 */  83, 89, 83, 67, 65, 76, 76, 83, 32, 48, 32,102,116,114,117,110,
/* 0x3d20 */  99, 97,116,101, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x3d30 */  48, 48, 48, 53, 98, 32,103, 32, 32, 32, 32, 32, 32, 32, 83, 89,
/* 0x3d40 */  83, 67, 65, 76, 76, 83, 32, 48, 32,109,109, 97,112, 10, 48, 48,
/* 0x3d50 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32,103,
/* 0x3d60 */  32, 32, 32, 32, 32, 70, 32, 85, 77, 70, 95, 76, 73, 78, 85, 88,
/* 0x3d70 */  32, 48,102, 57, 32,117,112,120, 95,109,109, 97,112, 95, 97,110,
/* 0x3d80 */ 100, 95,102,100, 95,108,105,110,117,120, 10, 48, 48, 48, 48, 48,
/* 0x3d90 */  48, 48, 48, 48, 48, 48, 48, 48, 48,100, 52, 32,103, 32, 32, 32,
/* 0x3da0 */  32, 32, 32, 32, 83, 89, 83, 67, 65, 76, 76, 83, 32, 48, 32,119,
/* 0x3db0 */ 114,105,116,101, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x3dc0 */  48, 48, 56, 57, 56, 32,103, 32, 32, 32, 32, 32, 70, 32, 46,116,
/* 0x3dd0 */ 101,120,116, 32, 48, 49, 51, 53, 32,117,112,120, 95,109, 97,105,
/* 0x3de0 */ 110, 50, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x3df0 */  48, 48, 48, 32, 32, 32, 32, 32, 32, 32, 32, 32, 42, 85, 78, 68,
/* 0x3e00 */  42, 32, 48, 32,109,101,109,102,100, 95, 99,114,101, 97,116,101,
/* 0x3e10 */  10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,100,
/* 0x3e20 */  56, 32,103, 32, 32, 32, 32, 32, 32, 32, 83, 89, 83, 67, 65, 76,
/* 0x3e30 */  76, 83, 32, 48, 32,114,101, 97,100, 10, 48, 48, 48, 48, 48, 48,
/* 0x3e40 */  48, 48, 48, 48, 48, 48, 48, 50, 99, 54, 32,103, 32, 32, 32, 32,
/* 0x3e50 */  32, 70, 32, 46,116,101,120,116, 32, 48, 52, 98, 32,117,110,100,
/* 0x3e60 */ 101,114,108, 97,121, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x3e70 */  48, 48, 48, 48,100, 48, 32,103, 32, 32, 32, 32, 32, 32, 32, 83,
/* 0x3e80 */  89, 83, 67, 65, 76, 76, 83, 32, 48, 32,109,115,121,110, 99, 10,
/* 0x3e90 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 49, 49,
/* 0x3ea0 */  32,103, 32, 32, 32, 32, 32, 32, 32, 83, 89, 83, 67, 65, 76, 76,
/* 0x3eb0 */  83, 32, 48, 32,117,112,120,102,100, 95, 99,114,101, 97,116,101,
/* 0x3ec0 */  10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x3ed0 */  48, 32,103, 32, 32, 32, 32, 32, 32, 32, 83, 89, 83, 67, 65, 76,
/* 0x3ee0 */  76, 83, 32, 48, 32,109,121, 95, 98,107,112,116, 10, 48, 48, 48,
/* 0x3ef0 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 56,102, 32,103, 32,
/* 0x3f00 */  32, 32, 32, 32, 32, 32, 83, 89, 83, 67, 65, 76, 76, 83, 32, 48,
/* 0x3f10 */  32, 80,112,114,111,116,101, 99,116, 10, 48, 48, 48, 48, 48, 48,
/* 0x3f20 */  48, 48, 48, 48, 48, 48, 48, 48,100, 52, 32,103, 32, 32, 32, 32,
/* 0x3f30 */  32, 32, 32, 83, 89, 83, 67, 65, 76, 76, 83, 32, 48, 32, 80,119,
/* 0x3f40 */ 114,105,116,101, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x3f50 */  48, 48, 48, 97, 52, 32,103, 32, 32, 32, 32, 32, 32, 32, 83, 89,
/* 0x3f60 */  83, 67, 65, 76, 76, 83, 32, 48, 32, 80,117,110,109, 97,112, 10,
/* 0x3f70 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 98, 56,
/* 0x3f80 */  32,103, 32, 32, 32, 32, 32, 32, 32, 83, 89, 83, 67, 65, 76, 76,
/* 0x3f90 */  83, 32, 48, 32,101,120,105,116, 10, 48, 48, 48, 48, 48, 48, 48,
/* 0x3fa0 */  48, 48, 48, 48, 48, 48, 48, 98, 99, 32,103, 32, 32, 32, 32, 32,
/* 0x3fb0 */  32, 32, 83, 89, 83, 67, 65, 76, 76, 83, 32, 48, 32, 98,114,107,
/* 0x3fc0 */  10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 99,
/* 0x3fd0 */  56, 32,103, 32, 32, 32, 32, 32, 32, 32, 83, 89, 83, 67, 65, 76,
/* 0x3fe0 */  76, 83, 32, 48, 32,111,112,101,110, 10, 48, 48, 48, 48, 48, 48,
/* 0x3ff0 */  48, 48, 48, 48, 48, 48, 48, 48, 99, 99, 32,103, 32, 32, 32, 32,
/* 0x4000 */  32, 32, 32, 83, 89, 83, 67, 65, 76, 76, 83, 32, 48, 32,109,112,
/* 0x4010 */ 114,111,116,101, 99,116, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x4020 */  48, 48, 48, 48, 48, 99, 48, 32,103, 32, 32, 32, 32, 32, 32, 32,
/* 0x4030 */  83, 89, 83, 67, 65, 76, 76, 83, 32, 48, 32, 99,108,111,115,101,
/* 0x4040 */  10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67,
/* 0x4050 */  79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 46,116,101,120,116, 93,
/* 0x4060 */  58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x4070 */  32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x4080 */  32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48,
/* 0x4090 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 55, 56, 32, 82, 95, 88, 56,
/* 0x40a0 */  54, 95, 54, 52, 95, 80, 67, 51, 50, 32, 32, 32, 32, 32, 83, 89,
/* 0x40b0 */  83, 67, 65, 76, 76, 83, 43, 48,120,102,102,102,102,102,102,102,
/* 0x40c0 */ 102,102,102,102,102,102,102,102,101, 10, 48, 48, 48, 48, 48, 48,
/* 0x40d0 */  48, 48, 48, 48, 48, 48, 48, 48, 55,102, 32, 82, 95, 88, 56, 54,
/* 0x40e0 */  95, 54, 52, 95, 80, 67, 51, 50, 32, 32, 32, 32, 32,111,112,101,
/* 0x40f0 */ 110, 43, 48,120,102,102,102,102,102,102,102,102,102,102,102,102,
/* 0x4100 */ 102,102,102, 99, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x4110 */  48, 48, 49, 48, 56, 32, 82, 95, 88, 56, 54, 95, 54, 52, 95, 80,
/* 0x4120 */  67, 51, 50, 32, 32, 32, 32, 32,117,112,120, 95,109, 97,105,110,
/* 0x4130 */  50, 43, 48,120,102,102,102,102,102,102,102,102,102,102,102,102,
/* 0x4140 */ 102,102,102, 99, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x4150 */  48, 48, 49, 50, 53, 32, 82, 95, 88, 56, 54, 95, 54, 52, 95, 80,
/* 0x4160 */  67, 51, 50, 32, 32, 32, 32, 32, 98,114,107, 43, 48,120,102,102,
/* 0x4170 */ 102,102,102,102,102,102,102,102,102,102,102,102,102, 99, 10, 48,
/* 0x4180 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 49, 50,100, 32,
/* 0x4190 */  82, 95, 88, 56, 54, 95, 54, 52, 95, 80, 67, 51, 50, 32, 32, 32,
/* 0x41a0 */  32, 32,109,117,110,109, 97,112, 43, 48,120,102,102,102,102,102,
/* 0x41b0 */ 102,102,102,102,102,102,102,102,102,102, 99, 10, 48, 48, 48, 48,
/* 0x41c0 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 49, 52, 57, 32, 82, 95, 88,
/* 0x41d0 */  56, 54, 95, 54, 52, 95, 80, 67, 51, 50, 32, 32, 32, 32, 32,109,
/* 0x41e0 */ 109, 97,112, 43, 48,120,102,102,102,102,102,102,102,102,102,102,
/* 0x41f0 */ 102,102,102,102,102, 99, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x4200 */  48, 48, 48, 48, 49, 53, 48, 32, 82, 95, 88, 56, 54, 95, 54, 52,
/* 0x4210 */  95, 80, 67, 51, 50, 32, 32, 32, 32, 32, 99,108,111,115,101, 43,
/* 0x4220 */  48,120,102,102,102,102,102,102,102,102,102,102,102,102,102,102,
/* 0x4230 */ 102, 99, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x4240 */  49, 55, 99, 32, 82, 95, 88, 56, 54, 95, 54, 52, 95, 80, 76, 84,
/* 0x4250 */  51, 50, 32, 32, 32, 32,101,120,105,116, 43, 48,120,102,102,102,
/* 0x4260 */ 102,102,102,102,102,102,102,102,102,102,102,102, 99, 10, 48, 48,
/* 0x4270 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 49,102, 50, 32, 82,
/* 0x4280 */  95, 88, 56, 54, 95, 54, 52, 95, 80, 76, 84, 51, 50, 32, 32, 32,
/* 0x4290 */  32,101,120,105,116, 43, 48,120,102,102,102,102,102,102,102,102,
/* 0x42a0 */ 102,102,102,102,102,102,102, 99, 10, 48, 48, 48, 48, 48, 48, 48,
/* 0x42b0 */  48, 48, 48, 48, 48, 48, 50, 49,100, 32, 82, 95, 88, 56, 54, 95,
/* 0x42c0 */  54, 52, 95, 80, 76, 84, 51, 50, 32, 32, 32, 32,102, 95,101,120,
/* 0x42d0 */ 112, 97,110,100, 43, 48,120,102,102,102,102,102,102,102,102,102,
/* 0x42e0 */ 102,102,102,102,102,102, 99, 10, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x42f0 */  48, 48, 48, 48, 48, 50, 98, 97, 32, 82, 95, 88, 56, 54, 95, 54,
/* 0x4300 */  52, 95, 80, 76, 84, 51, 50, 32, 32, 32, 32,101,120,105,116, 43,
/* 0x4310 */  48,120,102,102,102,102,102,102,102,102,102,102,102,102,102,102,
/* 0x4320 */ 102, 99, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x4330 */  50,102, 54, 32, 82, 95, 88, 56, 54, 95, 54, 52, 95, 80, 76, 84,
/* 0x4340 */  51, 50, 32, 32, 32, 32,109,109, 97,112, 43, 48,120,102,102,102,
/* 0x4350 */ 102,102,102,102,102,102,102,102,102,102,102,102, 99, 10, 48, 48,
/* 0x4360 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 51, 57, 51, 32, 82,
/* 0x4370 */  95, 88, 56, 54, 95, 54, 52, 95, 80, 76, 84, 51, 50, 32, 32, 32,
/* 0x4380 */  32,109,117,110,109, 97,112, 43, 48,120,102,102,102,102,102,102,
/* 0x4390 */ 102,102,102,102,102,102,102,102,102, 99, 10, 48, 48, 48, 48, 48,
/* 0x43a0 */  48, 48, 48, 48, 48, 48, 48, 48, 51,100, 50, 32, 82, 95, 88, 56,
/* 0x43b0 */  54, 95, 54, 52, 95, 80, 76, 84, 51, 50, 32, 32, 32, 32,103,101,
/* 0x43c0 */ 116, 95,112, 97,103,101, 95,109, 97,115,107, 43, 48,120,102,102,
/* 0x43d0 */ 102,102,102,102,102,102,102,102,102,102,102,102,102, 99, 10, 48,
/* 0x43e0 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 52, 55, 54, 32,
/* 0x43f0 */  82, 95, 88, 56, 54, 95, 54, 52, 95, 80, 76, 84, 51, 50, 32, 32,
/* 0x4400 */  32, 32,109,109, 97,112, 43, 48,120,102,102,102,102,102,102,102,
/* 0x4410 */ 102,102,102,102,102,102,102,102, 99, 10, 48, 48, 48, 48, 48, 48,
/* 0x4420 */  48, 48, 48, 48, 48, 48, 48, 52, 97, 49, 32, 82, 95, 88, 56, 54,
/* 0x4430 */  95, 54, 52, 95, 80, 76, 84, 51, 50, 32, 32, 32, 32,109,117,110,
/* 0x4440 */ 109, 97,112, 43, 48,120,102,102,102,102,102,102,102,102,102,102,
/* 0x4450 */ 102,102,102,102,102, 99, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x4460 */  48, 48, 48, 48, 52, 98, 51, 32, 82, 95, 88, 56, 54, 95, 54, 52,
/* 0x4470 */  95, 80, 76, 84, 51, 50, 32, 32, 32, 32,109,117,110,109, 97,112,
/* 0x4480 */  43, 48,120,102,102,102,102,102,102,102,102,102,102,102,102,102,
/* 0x4490 */ 102,102, 99, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x44a0 */  48, 52, 99, 97, 32, 82, 95, 88, 56, 54, 95, 54, 52, 95, 80, 76,
/* 0x44b0 */  84, 51, 50, 32, 32, 32, 32,103,101,116, 95,112, 97,103,101, 95,
/* 0x44c0 */ 109, 97,115,107, 43, 48,120,102,102,102,102,102,102,102,102,102,
/* 0x44d0 */ 102,102,102,102,102,102, 99, 10, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x44e0 */  48, 48, 48, 48, 48, 54, 48, 98, 32, 82, 95, 88, 56, 54, 95, 54,
/* 0x44f0 */  52, 95, 80, 67, 51, 50, 32, 32, 32, 32, 32, 83, 84, 82, 67, 79,
/* 0x4500 */  78, 43, 48,120, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x4510 */  48, 48, 52, 55, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x4520 */  48, 48, 54, 49, 48, 32, 82, 95, 88, 56, 54, 95, 54, 52, 95, 80,
/* 0x4530 */  76, 84, 51, 50, 32, 32, 32, 32,117,112,120,102,100, 95, 99,114,
/* 0x4540 */ 101, 97,116,101, 43, 48,120,102,102,102,102,102,102,102,102,102,
/* 0x4550 */ 102,102,102,102,102,102, 99, 10, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x4560 */  48, 48, 48, 48, 48, 54, 49,101, 32, 82, 95, 88, 56, 54, 95, 54,
/* 0x4570 */  52, 95, 80, 76, 84, 51, 50, 32, 32, 32, 32,102,116,114,117,110,
/* 0x4580 */  99, 97,116,101, 43, 48,120,102,102,102,102,102,102,102,102,102,
/* 0x4590 */ 102,102,102,102,102,102, 99, 10, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x45a0 */  48, 48, 48, 48, 48, 54, 53, 98, 32, 82, 95, 88, 56, 54, 95, 54,
/* 0x45b0 */  52, 95, 80, 76, 84, 51, 50, 32, 32, 32, 32,109,109, 97,112, 43,
/* 0x45c0 */  48,120,102,102,102,102,102,102,102,102,102,102,102,102,102,102,
/* 0x45d0 */ 102, 99, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x45e0 */  54, 56, 53, 32, 82, 95, 88, 56, 54, 95, 54, 52, 95, 80, 76, 84,
/* 0x45f0 */  51, 50, 32, 32, 32, 32,109,109, 97,112, 43, 48,120,102,102,102,
/* 0x4600 */ 102,102,102,102,102,102,102,102,102,102,102,102, 99, 10, 48, 48,
/* 0x4610 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 55, 53, 48, 32, 82,
/* 0x4620 */  95, 88, 56, 54, 95, 54, 52, 95, 80, 67, 51, 50, 32, 32, 32, 32,
/* 0x4630 */  32, 83, 84, 82, 67, 79, 78, 43, 48,120, 48, 48, 48, 48, 48, 48,
/* 0x4640 */  48, 48, 48, 48, 48, 48, 48, 48, 52, 98, 10, 48, 48, 48, 48, 48,
/* 0x4650 */  48, 48, 48, 48, 48, 48, 48, 48, 55, 53, 53, 32, 82, 95, 88, 56,
/* 0x4660 */  54, 95, 54, 52, 95, 80, 76, 84, 51, 50, 32, 32, 32, 32,117,112,
/* 0x4670 */ 120,102,100, 95, 99,114,101, 97,116,101, 43, 48,120,102,102,102,
/* 0x4680 */ 102,102,102,102,102,102,102,102,102,102,102,102, 99, 10, 48, 48,
/* 0x4690 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 55, 54, 56, 32, 82,
/* 0x46a0 */  95, 88, 56, 54, 95, 54, 52, 95, 80, 76, 84, 51, 50, 32, 32, 32,
/* 0x46b0 */  32,119,114,105,116,101, 43, 48,120,102,102,102,102,102,102,102,
/* 0x46c0 */ 102,102,102,102,102,102,102,102, 99, 10, 48, 48, 48, 48, 48, 48,
/* 0x46d0 */  48, 48, 48, 48, 48, 48, 48, 55, 56, 52, 32, 82, 95, 88, 56, 54,
/* 0x46e0 */  95, 54, 52, 95, 80, 76, 84, 51, 50, 32, 32, 32, 32,109,109, 97,
/* 0x46f0 */ 112, 43, 48,120,102,102,102,102,102,102,102,102,102,102,102,102,
/* 0x4700 */ 102,102,102, 99, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x4710 */  48, 48, 55, 56,101, 32, 82, 95, 88, 56, 54, 95, 54, 52, 95, 80,
/* 0x4720 */  76, 84, 51, 50, 32, 32, 32, 32, 99,108,111,115,101, 43, 48,120,
/* 0x4730 */ 102,102,102,102,102,102,102,102,102,102,102,102,102,102,102, 99,
/* 0x4740 */  10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 55, 98,
/* 0x4750 */  54, 32, 82, 95, 88, 56, 54, 95, 54, 52, 95, 80, 76, 84, 51, 50,
/* 0x4760 */  32, 32, 32, 32, 80,115,121,110, 99, 43, 48,120,102,102,102,102,
/* 0x4770 */ 102,102,102,102,102,102,102,102,102,102,102, 99, 10, 48, 48, 48,
/* 0x4780 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 55, 99, 49, 32, 82, 95,
/* 0x4790 */  88, 56, 54, 95, 54, 52, 95, 80, 76, 84, 51, 50, 32, 32, 32, 32,
/* 0x47a0 */ 109,117,110,109, 97,112, 43, 48,120,102,102,102,102,102,102,102,
/* 0x47b0 */ 102,102,102,102,102,102,102,102, 99, 10, 48, 48, 48, 48, 48, 48,
/* 0x47c0 */  48, 48, 48, 48, 48, 48, 48, 55,100,100, 32, 82, 95, 88, 56, 54,
/* 0x47d0 */  95, 54, 52, 95, 80, 76, 84, 51, 50, 32, 32, 32, 32,109,109, 97,
/* 0x47e0 */ 112, 43, 48,120,102,102,102,102,102,102,102,102,102,102,102,102,
/* 0x47f0 */ 102,102,102, 99, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x4800 */  48, 48, 55,101, 98, 32, 82, 95, 88, 56, 54, 95, 54, 52, 95, 80,
/* 0x4810 */  76, 84, 51, 50, 32, 32, 32, 32, 99,108,111,115,101, 43, 48,120,
/* 0x4820 */ 102,102,102,102,102,102,102,102,102,102,102,102,102,102,102, 99,
/* 0x4830 */  10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 56, 48,
/* 0x4840 */  51, 32, 82, 95, 88, 56, 54, 95, 54, 52, 95, 80, 76, 84, 51, 50,
/* 0x4850 */  32, 32, 32, 32, 80,112,114,111,116,101, 99,116, 43, 48,120,102,
/* 0x4860 */ 102,102,102,102,102,102,102,102,102,102,102,102,102,102, 99, 10,
/* 0x4870 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 56, 49, 49,
/* 0x4880 */  32, 82, 95, 88, 56, 54, 95, 54, 52, 95, 80, 76, 84, 51, 50, 32,
/* 0x4890 */  32, 32, 32,101,120,105,116, 43, 48,120,102,102,102,102,102,102,
/* 0x48a0 */ 102,102,102,102,102,102,102,102,102, 99, 10, 48, 48, 48, 48, 48,
/* 0x48b0 */  48, 48, 48, 48, 48, 48, 48, 48, 56, 51, 97, 32, 82, 95, 88, 56,
/* 0x48c0 */  54, 95, 54, 52, 95, 80, 76, 84, 51, 50, 32, 32, 32, 32,109,109,
/* 0x48d0 */  97,112, 43, 48,120,102,102,102,102,102,102,102,102,102,102,102,
/* 0x48e0 */ 102,102,102,102, 99, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x48f0 */  48, 48, 48, 56,102, 50, 32, 82, 95, 88, 56, 54, 95, 54, 52, 95,
/* 0x4900 */  80, 76, 84, 51, 50, 32, 32, 32, 32,103,101,116, 95,112, 97,103,
/* 0x4910 */ 101, 95,109, 97,115,107, 43, 48,120,102,102,102,102,102,102,102,
/* 0x4920 */ 102,102,102,102,102,102,102,102, 99, 10, 48, 48, 48, 48, 48, 48,
/* 0x4930 */  48, 48, 48, 48, 48, 48, 48, 57, 52, 54, 32, 82, 95, 88, 56, 54,
/* 0x4940 */  95, 54, 52, 95, 80, 76, 84, 51, 50, 32, 32, 32, 32,111,112,101,
/* 0x4950 */ 110, 43, 48,120,102,102,102,102,102,102,102,102,102,102,102,102,
/* 0x4960 */ 102,102,102, 99, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x4970 */  48, 48, 57, 53, 98, 32, 82, 95, 88, 56, 54, 95, 54, 52, 95, 80,
/* 0x4980 */  76, 84, 51, 50, 32, 32, 32, 32,114,101, 97,100, 43, 48,120,102,
/* 0x4990 */ 102,102,102,102,102,102,102,102,102,102,102,102,102,102, 99, 10,
/* 0x49a0 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 57, 54,100,
/* 0x49b0 */  32, 82, 95, 88, 56, 54, 95, 54, 52, 95, 80, 76, 84, 51, 50, 32,
/* 0x49c0 */  32, 32, 32,101,120,105,116, 43, 48,120,102,102,102,102,102,102,
/* 0x49d0 */ 102,102,102,102,102,102,102,102,102, 99, 10, 48, 48, 48, 48, 48,
/* 0x49e0 */  48, 48, 48, 48, 48, 48, 48, 48, 57, 57,102, 32, 82, 95, 88, 56,
/* 0x49f0 */  54, 95, 54, 52, 95, 80, 76, 84, 51, 50, 32, 32, 32, 32, 99,108,
/* 0x4a00 */ 111,115,101, 43, 48,120,102,102,102,102,102,102,102,102,102,102,
/* 0x4a10 */ 102,102,102,102,102, 99, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73,
/* 0x4a20 */  79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91,
/* 0x4a30 */  85, 77, 70, 95, 76, 73, 78, 85, 88, 93, 58, 10, 79, 70, 70, 83,
/* 0x4a40 */  69, 84, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 84, 89, 80,
/* 0x4a50 */  69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86,
/* 0x4a60 */  65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x4a70 */  48, 48, 48, 50, 49, 32, 82, 95, 88, 56, 54, 95, 54, 52, 95, 80,
/* 0x4a80 */  67, 51, 50, 32, 32, 32, 32, 32, 83, 84, 82, 67, 79, 78, 43, 48,
/* 0x4a90 */ 120,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,
/* 0x4aa0 */  99, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x4ab0 */  50,101, 32, 82, 95, 88, 56, 54, 95, 54, 52, 95, 80, 76, 84, 51,
/* 0x4ac0 */  50, 32, 32, 32, 32,109,101,109,102,100, 95, 99,114,101, 97,116,
/* 0x4ad0 */ 101, 43, 48,120,102,102,102,102,102,102,102,102,102,102,102,102,
/* 0x4ae0 */ 102,102,102, 99, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x4af0 */  48, 48, 48, 52, 50, 32, 82, 95, 88, 56, 54, 95, 54, 52, 95, 80,
/* 0x4b00 */  76, 84, 51, 50, 32, 32, 32, 32,109,101,109,102,100, 95, 99,114,
/* 0x4b10 */ 101, 97,116,101, 43, 48,120,102,102,102,102,102,102,102,102,102,
/* 0x4b20 */ 102,102,102,102,102,102, 99, 10, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x4b30 */  48, 48, 48, 48, 48, 48, 52,102, 32, 82, 95, 88, 56, 54, 95, 54,
/* 0x4b40 */  52, 95, 80, 67, 51, 50, 32, 32, 32, 32, 32, 83, 84, 82, 67, 79,
/* 0x4b50 */  78, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x4b60 */  53,101, 32, 82, 95, 88, 56, 54, 95, 54, 52, 95, 80, 76, 84, 51,
/* 0x4b70 */  50, 32, 32, 32, 32,111,112,101,110, 43, 48,120,102,102,102,102,
/* 0x4b80 */ 102,102,102,102,102,102,102,102,102,102,102, 99, 10, 48, 48, 48,
/* 0x4b90 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 55, 51, 32, 82, 95,
/* 0x4ba0 */  88, 56, 54, 95, 54, 52, 95, 80, 67, 51, 50, 32, 32, 32, 32, 32,
/* 0x4bb0 */  83, 84, 82, 67, 79, 78, 43, 48,120, 48, 48, 48, 48, 48, 48, 48,
/* 0x4bc0 */  48, 48, 48, 48, 48, 48, 48, 48, 57, 10, 48, 48, 48, 48, 48, 48,
/* 0x4bd0 */  48, 48, 48, 48, 48, 48, 48, 48, 56, 50, 32, 82, 95, 88, 56, 54,
/* 0x4be0 */  95, 54, 52, 95, 80, 76, 84, 51, 50, 32, 32, 32, 32,119,114,105,
/* 0x4bf0 */ 116,101, 43, 48,120,102,102,102,102,102,102,102,102,102,102,102,
/* 0x4c00 */ 102,102,102,102, 99, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x4c10 */  48, 48, 48, 48, 56, 99, 32, 82, 95, 88, 56, 54, 95, 54, 52, 95,
/* 0x4c20 */  80, 76, 84, 51, 50, 32, 32, 32, 32,101,120,105,116, 43, 48,120,
/* 0x4c30 */ 102,102,102,102,102,102,102,102,102,102,102,102,102,102,102, 99,
/* 0x4c40 */  10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 57,
/* 0x4c50 */  54, 32, 82, 95, 88, 56, 54, 95, 54, 52, 95, 80, 76, 84, 51, 50,
/* 0x4c60 */  32, 32, 32, 32,102,116,114,117,110, 99, 97,116,101, 43, 48,120,
/* 0x4c70 */ 102,102,102,102,102,102,102,102,102,102,102,102,102,102,102, 99,
/* 0x4c80 */  10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 99,
/* 0x4c90 */  50, 32, 82, 95, 88, 56, 54, 95, 54, 52, 95, 80, 76, 84, 51, 50,
/* 0x4ca0 */  32, 32, 32, 32,109,109, 97,112, 43, 48,120,102,102,102,102,102,
/* 0x4cb0 */ 102,102,102,102,102,102,102,102,102,102, 99, 10, 48, 48, 48, 48,
/* 0x4cc0 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 99, 97, 32, 82, 95, 88,
/* 0x4cd0 */  56, 54, 95, 54, 52, 95, 80, 76, 84, 51, 50, 32, 32, 32, 32,103,
/* 0x4ce0 */ 101,116, 95,112, 97,103,101, 95,109, 97,115,107, 43, 48,120,102,
/* 0x4cf0 */ 102,102,102,102,102,102,102,102,102,102,102,102,102,102, 99, 10,
/* 0x4d00 */  10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79,
/* 0x4d10 */  82, 68, 83, 32, 70, 79, 82, 32, 91, 83, 89, 83, 67, 65, 76, 76,
/* 0x4d20 */  83, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 32, 32, 32,
/* 0x4d30 */  32, 32, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32,
/* 0x4d40 */  32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48,
/* 0x4d50 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 52,100, 32, 82, 95,
/* 0x4d60 */  88, 56, 54, 95, 54, 52, 95, 80, 67, 51, 50, 32, 32, 32, 32, 32,
/* 0x4d70 */  46,116,101,120,116, 43, 48,120,102,102,102,102,102,102,102,102,
/* 0x4d80 */ 102,102,102,102,102,102,102, 99, 10, 48, 48, 48, 48, 48, 48, 48,
/* 0x4d90 */  48, 48, 48, 48, 48, 48, 48, 55, 56, 32, 82, 95, 88, 56, 54, 95,
/* 0x4da0 */  54, 52, 95, 80, 67, 51, 50, 32, 32, 32, 32, 32, 46,116,101,120,
/* 0x4db0 */ 116, 43, 48,120,102,102,102,102,102,102,102,102,102,102,102,102,
/* 0x4dc0 */ 102,102,102, 99, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x4dd0 */  48, 48, 48, 57, 49, 32, 82, 95, 88, 56, 54, 95, 54, 52, 95, 80,
/* 0x4de0 */  67, 51, 50, 32, 32, 32, 32, 32, 46,116,101,120,116, 43, 48,120,
/* 0x4df0 */ 102,102,102,102,102,102,102,102,102,102,102,102,102,102,102, 99,
/* 0x4e00 */  10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 97,
/* 0x4e10 */  54, 32, 82, 95, 88, 56, 54, 95, 54, 52, 95, 80, 67, 51, 50, 32,
/* 0x4e20 */  32, 32, 32, 32, 46,116,101,120,116, 43, 48,120,102,102,102,102,
/* 0x4e30 */ 102,102,102,102,102,102,102,102,102,102,102, 99, 10, 48, 48, 48,
/* 0x4e40 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 56, 98, 32, 82, 95,
/* 0x4e50 */  88, 56, 54, 95, 54, 52, 95, 80, 67, 51, 50, 32, 32, 32, 32, 32,
/* 0x4e60 */ 109,115,121,110, 99, 43, 48,120,102,102,102,102,102,102,102,102,
/* 0x4e70 */ 102,102,102,102,102,102,102, 99, 10, 48, 48, 48, 48, 48, 48, 48,
/* 0x4e80 */  48, 48, 48, 48, 48, 48, 48, 97, 48, 32, 82, 95, 88, 56, 54, 95,
/* 0x4e90 */  54, 52, 95, 80, 67, 51, 50, 32, 32, 32, 32, 32,109,112,114,111,
/* 0x4ea0 */ 116,101, 99,116, 43, 48,120,102,102,102,102,102,102,102,102,102,
/* 0x4eb0 */ 102,102,102,102,102,102, 99, 10, 10, 82, 69, 76, 79, 67, 65, 84,
/* 0x4ec0 */  73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32,
/* 0x4ed0 */  91, 78, 82, 86, 50, 69, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32,
/* 0x4ee0 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 84, 89, 80, 69, 32, 32,
/* 0x4ef0 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85,
/* 0x4f00 */  69, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x4f10 */ 100,102, 32, 82, 95, 88, 56, 54, 95, 54, 52, 95, 80, 67, 51, 50,
/* 0x4f20 */  32, 32, 32, 32, 32, 69, 88, 80, 95, 72, 69, 65, 68, 43, 48,120,
/* 0x4f30 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 97, 53,
/* 0x4f40 */  10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 55,
/* 0x4f50 */  52, 32, 82, 95, 88, 56, 54, 95, 54, 52, 95, 80, 67, 51, 50, 32,
/* 0x4f60 */  32, 32, 32, 32, 69, 88, 80, 95, 84, 65, 73, 76, 43, 48,120, 48,
/* 0x4f70 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 52, 10,
/* 0x4f80 */  10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79,
/* 0x4f90 */  82, 68, 83, 32, 70, 79, 82, 32, 91, 78, 82, 86, 50, 68, 93, 58,
/* 0x4fa0 */  10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x4fb0 */  32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x4fc0 */  32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48,
/* 0x4fd0 */  48, 48, 48, 48, 48, 48, 48, 48,100, 50, 32, 82, 95, 88, 56, 54,
/* 0x4fe0 */  95, 54, 52, 95, 80, 67, 51, 50, 32, 32, 32, 32, 32, 69, 88, 80,
/* 0x4ff0 */  95, 72, 69, 65, 68, 43, 48,120, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x5000 */  48, 48, 48, 48, 48, 48, 97, 53, 10, 48, 48, 48, 48, 48, 48, 48,
/* 0x5010 */  48, 48, 48, 48, 48, 48, 48, 55, 52, 32, 82, 95, 88, 56, 54, 95,
/* 0x5020 */  54, 52, 95, 80, 67, 51, 50, 32, 32, 32, 32, 32, 69, 88, 80, 95,
/* 0x5030 */  84, 65, 73, 76, 43, 48,120, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x5040 */  48, 48, 48, 48, 48, 48, 52, 10, 10, 82, 69, 76, 79, 67, 65, 84,
/* 0x5050 */  73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32,
/* 0x5060 */  91, 78, 82, 86, 50, 66, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32,
/* 0x5070 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 84, 89, 80, 69, 32, 32,
/* 0x5080 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85,
/* 0x5090 */  69, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x50a0 */  98, 98, 32, 82, 95, 88, 56, 54, 95, 54, 52, 95, 80, 67, 51, 50,
/* 0x50b0 */  32, 32, 32, 32, 32, 69, 88, 80, 95, 72, 69, 65, 68, 43, 48,120,
/* 0x50c0 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 97, 53,
/* 0x50d0 */  10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 53,
/* 0x50e0 */ 102, 32, 82, 95, 88, 56, 54, 95, 54, 52, 95, 80, 67, 51, 50, 32,
/* 0x50f0 */  32, 32, 32, 32, 69, 88, 80, 95, 84, 65, 73, 76, 43, 48,120, 48,
/* 0x5100 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 52, 10,
/* 0x5110 */  10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79,
/* 0x5120 */  82, 68, 83, 32, 70, 79, 82, 32, 91, 76, 90, 77, 65, 95, 68, 65,
/* 0x5130 */  73, 83, 89, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 32,
/* 0x5140 */  32, 32, 32, 32, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32,
/* 0x5150 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48,
/* 0x5160 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 54, 32,
/* 0x5170 */  82, 95, 88, 56, 54, 95, 54, 52, 95, 80, 67, 51, 50, 32, 32, 32,
/* 0x5180 */  32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 51, 48, 43, 48,120, 48,
/* 0x5190 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 49, 53, 10,
/* 0x51a0 */  10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79,
/* 0x51b0 */  82, 68, 83, 32, 70, 79, 82, 32, 91, 76, 90, 77, 65, 95, 68, 69,
/* 0x51c0 */  67, 51, 48, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 32,
/* 0x51d0 */  32, 32, 32, 32, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32,
/* 0x51e0 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48,
/* 0x51f0 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 49, 53, 32,
/* 0x5200 */  82, 95, 88, 56, 54, 95, 54, 52, 95, 80, 67, 51, 50, 32, 32, 32,
/* 0x5210 */  32, 32, 69, 88, 80, 95, 84, 65, 73, 76, 43, 48,120, 48, 48, 48,
/* 0x5220 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 52, 10
};
