/*
 * This file was generated automatically by ExtUtils::ParseXS version 3.44 from the
 * contents of DateTime.xs. Do not edit this file, edit DateTime.xs instead.
 *
 *    ANY CHANGES MADE HERE WILL BE LOST!
 *
 */

#line 1 "DateTime.xs"
#include "EXTERN.h"
#include "perl.h"
#include "XSUB.h"
#include "ppport.h"

#include <stdlib.h>

/* This file is generated by tools/leap_seconds_header.pl */
#include "leap_seconds.h"

# if defined(WIN32) || defined(PERL_DARWIN)
#   if PERL_VERSION_GE(5, 22, 0)
#     define dt_isfinite Perl_isfinite
#   endif
# else
#   define dt_isfinite Perl_isfinite
# endif

#define DAYS_PER_400_YEARS  146097
#define DAYS_PER_4_YEARS    1461
#define MARCH_1             306

#define SECONDS_PER_DAY     86400

const int PREVIOUS_MONTH_DOY[12] =  { 0,
                                      31,
                                      59,
                                      90,
                                      120,
                                      151,
                                      181,
                                      212,
                                      243,
                                      273,
                                      304,
                                      334 };

const int PREVIOUS_MONTH_DOLY[12] = { 0,
                                      31,
                                      60,
                                      91,
                                      121,
                                      152,
                                      182,
                                      213,
                                      244,
                                      274,
                                      305,
                                      335 };


IV
_real_is_leap_year(IV y) {
    /* See http://www.perlmonks.org/?node_id=274247 for where this silliness
       comes from */
    return (y % 4) ? 0 : (y % 100) ? 1 : (y % 400) ? 0 : 1;
}


#line 70 "DateTime.c"
#ifndef PERL_UNUSED_VAR
#  define PERL_UNUSED_VAR(var) if (0) var = var
#endif

#ifndef dVAR
#  define dVAR		dNOOP
#endif


/* This stuff is not part of the API! You have been warned. */
#ifndef PERL_VERSION_DECIMAL
#  define PERL_VERSION_DECIMAL(r,v,s) (r*1000000 + v*1000 + s)
#endif
#ifndef PERL_DECIMAL_VERSION
#  define PERL_DECIMAL_VERSION \
	  PERL_VERSION_DECIMAL(PERL_REVISION,PERL_VERSION,PERL_SUBVERSION)
#endif
#ifndef PERL_VERSION_GE
#  define PERL_VERSION_GE(r,v,s) \
	  (PERL_DECIMAL_VERSION >= PERL_VERSION_DECIMAL(r,v,s))
#endif
#ifndef PERL_VERSION_LE
#  define PERL_VERSION_LE(r,v,s) \
	  (PERL_DECIMAL_VERSION <= PERL_VERSION_DECIMAL(r,v,s))
#endif

/* XS_INTERNAL is the explicit static-linkage variant of the default
 * XS macro.
 *
 * XS_EXTERNAL is the same as XS_INTERNAL except it does not include
 * "STATIC", ie. it exports XSUB symbols. You probably don't want that
 * for anything but the BOOT XSUB.
 *
 * See XSUB.h in core!
 */


/* TODO: This might be compatible further back than 5.10.0. */
#if PERL_VERSION_GE(5, 10, 0) && PERL_VERSION_LE(5, 15, 1)
#  undef XS_EXTERNAL
#  undef XS_INTERNAL
#  if defined(__CYGWIN__) && defined(USE_DYNAMIC_LOADING)
#    define XS_EXTERNAL(name) __declspec(dllexport) XSPROTO(name)
#    define XS_INTERNAL(name) STATIC XSPROTO(name)
#  endif
#  if defined(__SYMBIAN32__)
#    define XS_EXTERNAL(name) EXPORT_C XSPROTO(name)
#    define XS_INTERNAL(name) EXPORT_C STATIC XSPROTO(name)
#  endif
#  ifndef XS_EXTERNAL
#    if defined(HASATTRIBUTE_UNUSED) && !defined(__cplusplus)
#      define XS_EXTERNAL(name) void name(pTHX_ CV* cv __attribute__unused__)
#      define XS_INTERNAL(name) STATIC void name(pTHX_ CV* cv __attribute__unused__)
#    else
#      ifdef __cplusplus
#        define XS_EXTERNAL(name) extern "C" XSPROTO(name)
#        define XS_INTERNAL(name) static XSPROTO(name)
#      else
#        define XS_EXTERNAL(name) XSPROTO(name)
#        define XS_INTERNAL(name) STATIC XSPROTO(name)
#      endif
#    endif
#  endif
#endif

/* perl >= 5.10.0 && perl <= 5.15.1 */


/* The XS_EXTERNAL macro is used for functions that must not be static
 * like the boot XSUB of a module. If perl didn't have an XS_EXTERNAL
 * macro defined, the best we can do is assume XS is the same.
 * Dito for XS_INTERNAL.
 */
#ifndef XS_EXTERNAL
#  define XS_EXTERNAL(name) XS(name)
#endif
#ifndef XS_INTERNAL
#  define XS_INTERNAL(name) XS(name)
#endif

/* Now, finally, after all this mess, we want an ExtUtils::ParseXS
 * internal macro that we're free to redefine for varying linkage due
 * to the EXPORT_XSUB_SYMBOLS XS keyword. This is internal, use
 * XS_EXTERNAL(name) or XS_INTERNAL(name) in your code if you need to!
 */

#undef XS_EUPXS
#if defined(PERL_EUPXS_ALWAYS_EXPORT)
#  define XS_EUPXS(name) XS_EXTERNAL(name)
#else
   /* default to internal */
#  define XS_EUPXS(name) XS_INTERNAL(name)
#endif

#ifndef PERL_ARGS_ASSERT_CROAK_XS_USAGE
#define PERL_ARGS_ASSERT_CROAK_XS_USAGE assert(cv); assert(params)

/* prototype to pass -Wmissing-prototypes */
STATIC void
S_croak_xs_usage(const CV *const cv, const char *const params);

STATIC void
S_croak_xs_usage(const CV *const cv, const char *const params)
{
    const GV *const gv = CvGV(cv);

    PERL_ARGS_ASSERT_CROAK_XS_USAGE;

    if (gv) {
        const char *const gvname = GvNAME(gv);
        const HV *const stash = GvSTASH(gv);
        const char *const hvname = stash ? HvNAME(stash) : NULL;

        if (hvname)
	    Perl_croak_nocontext("Usage: %s::%s(%s)", hvname, gvname, params);
        else
	    Perl_croak_nocontext("Usage: %s(%s)", gvname, params);
    } else {
        /* Pants. I don't think that it should be possible to get here. */
	Perl_croak_nocontext("Usage: CODE(0x%" UVxf ")(%s)", PTR2UV(cv), params);
    }
}
#undef  PERL_ARGS_ASSERT_CROAK_XS_USAGE

#define croak_xs_usage        S_croak_xs_usage

#endif

/* NOTE: the prototype of newXSproto() is different in versions of perls,
 * so we define a portable version of newXSproto()
 */
#ifdef newXS_flags
#define newXSproto_portable(name, c_impl, file, proto) newXS_flags(name, c_impl, file, proto, 0)
#else
#define newXSproto_portable(name, c_impl, file, proto) (PL_Sv=(SV*)newXS(name, c_impl, file), sv_setpv(PL_Sv, proto), (CV*)PL_Sv)
#endif /* !defined(newXS_flags) */

#if PERL_VERSION_LE(5, 21, 5)
#  define newXS_deffile(a,b) Perl_newXS(aTHX_ a,b,file)
#else
#  define newXS_deffile(a,b) Perl_newXS_deffile(aTHX_ a,b)
#endif

#line 214 "DateTime.c"

XS_EUPXS(XS_DateTime__rd2ymd); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_DateTime__rd2ymd)
{
    dVAR; dXSARGS;
    if (items < 2 || items > 3)
       croak_xs_usage(cv,  "self, d, extra = 0");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
	IV	d = (IV)SvIV(ST(1))
;
	IV	extra;
#line 70 "DateTime.xs"
        IV y, m;
        IV c;
        IV quarter;
        IV yadj = 0;
        IV dow, doy, doq;
        IV rd_days;

#line 236 "DateTime.c"

	if (items < 3)
	    extra = 0;
	else {
	    extra = (IV)SvIV(ST(2))
;
	}
#line 78 "DateTime.xs"
        rd_days = d;

        d += MARCH_1;

        if (d <= 0) {
            yadj = -1 * (((-1 * d) / DAYS_PER_400_YEARS) + 1);
            d -= yadj * DAYS_PER_400_YEARS;
        }

        /* c is century */
        c =  ((d * 4) - 1) / DAYS_PER_400_YEARS;
        d -= c * DAYS_PER_400_YEARS / 4;
        y =  ((d * 4) - 1) / DAYS_PER_4_YEARS;
        d -= y * DAYS_PER_4_YEARS / 4;
        m =  ((d * 12) + 1093) / 367;
        d -= ((m * 367) - 1094) / 12;
        y += (c * 100) + (yadj * 400);

        if (m > 12) {
            ++y;
            m -= 12;
        }

        EXTEND(SP, extra ? 7 : 3);
        mPUSHi(y);
        mPUSHi(m);
        mPUSHi(d);

        if (extra) {
            quarter = ( ( 1.0 / 3.1 ) * m ) + 1;

            dow = rd_days % 7;
            if ( dow <= 0 ) {
                dow += 7;
            }

            mPUSHi(dow);

            if (_real_is_leap_year(y)) {
                doy = PREVIOUS_MONTH_DOLY[m - 1] + d;
                doq = doy - PREVIOUS_MONTH_DOLY[ (3 * quarter) - 3 ];
            } else {
                doy = PREVIOUS_MONTH_DOY[m - 1] + d;
                doq = doy - PREVIOUS_MONTH_DOY[ (3 * quarter ) - 3 ];
            }

            mPUSHi(doy);
            mPUSHi(quarter);
            mPUSHi(doq);
        }
#line 295 "DateTime.c"
	PUTBACK;
	return;
    }
}


XS_EUPXS(XS_DateTime__ymd2rd); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_DateTime__ymd2rd)
{
    dVAR; dXSARGS;
    if (items != 4)
       croak_xs_usage(cv,  "self, y, m, d");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
	IV	y = (IV)SvIV(ST(1))
;
	IV	m = (IV)SvIV(ST(2))
;
	IV	d = (IV)SvIV(ST(3))
;
#line 136 "DateTime.xs"
        IV adj;

#line 320 "DateTime.c"
#line 139 "DateTime.xs"
        if (m <= 2) {
            adj = (14 - m) / 12;
            y -= adj;
            m += 12 * adj;
        } else if (m > 14) {
            adj = (m - 3) / 12;
            y += adj;
            m -= 12 * adj;
        }

        if (y < 0) {
            adj = (399 - y) / 400;
            d -= DAYS_PER_400_YEARS * adj;
            y += 400 * adj;
        }

        d += (m * 367 - 1094) /
            12 + y % 100 * DAYS_PER_4_YEARS /
            4 + (y / 100 * 36524 + y / 400) - MARCH_1;

        EXTEND(SP, 1);
        mPUSHi(d);
#line 344 "DateTime.c"
	PUTBACK;
	return;
    }
}


XS_EUPXS(XS_DateTime__seconds_as_components); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_DateTime__seconds_as_components)
{
    dVAR; dXSARGS;
    if (items < 2 || items > 4)
       croak_xs_usage(cv,  "self, secs, utc_secs = 0, secs_modifier = 0");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
	IV	secs = (IV)SvIV(ST(1))
;
	IV	utc_secs;
	IV	secs_modifier;
#line 169 "DateTime.xs"
        IV h, m, s;

#line 367 "DateTime.c"

	if (items < 3)
	    utc_secs = 0;
	else {
	    utc_secs = (IV)SvIV(ST(2))
;
	}

	if (items < 4)
	    secs_modifier = 0;
	else {
	    secs_modifier = (IV)SvIV(ST(3))
;
	}
#line 172 "DateTime.xs"
        secs -= secs_modifier;

        h = secs / 3600;
        secs -= h * 3600;

        m = secs / 60;

        s = secs - (m * 60);

        if (utc_secs >= SECONDS_PER_DAY) {
            if (utc_secs >= SECONDS_PER_DAY + 1) {
                /* If we just use %d and the IV, we get a warning that IV is
                   not an int. */
                croak("Invalid UTC RD seconds value: %s", SvPV_nolen(newSViv(utc_secs)));
            }

            s += (utc_secs - SECONDS_PER_DAY) + 60;
            m = 59;
            h--;

            if (h < 0) {
                h = 23;
            }
        }

        EXTEND(SP, 3);
        mPUSHi(h);
        mPUSHi(m);
        mPUSHi(s);
#line 412 "DateTime.c"
	PUTBACK;
	return;
    }
}

#ifdef dt_isfinite
#define XSubPPtmpAAAA 1


XS_EUPXS(XS_DateTime__normalize_tai_seconds); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_DateTime__normalize_tai_seconds)
{
    dVAR; dXSARGS;
    if (items != 3)
       croak_xs_usage(cv,  "self, days, secs");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
	SV*	days = ST(1)
;
	SV*	secs = ST(2)
;
#line 209 "DateTime.xs"
        if (dt_isfinite(SvNV(days)) && dt_isfinite(SvNV(secs))) {
            IV d = SvIV(days);
            IV s = SvIV(secs);
            IV adj;

            if (s < 0) {
                adj = (s - (SECONDS_PER_DAY - 1)) / SECONDS_PER_DAY;
            } else {
                adj = s / SECONDS_PER_DAY;
            }

            d += adj;
            s -= adj * SECONDS_PER_DAY;

            sv_setiv(days, (IV) d);
            sv_setiv(secs, (IV) s);
        }
#line 453 "DateTime.c"
	PUTBACK;
	return;
    }
}


XS_EUPXS(XS_DateTime__normalize_leap_seconds); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_DateTime__normalize_leap_seconds)
{
    dVAR; dXSARGS;
    if (items != 3)
       croak_xs_usage(cv,  "self, days, secs");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
	SV*	days = ST(1)
;
	SV*	secs = ST(2)
;
#line 233 "DateTime.xs"
        if (dt_isfinite(SvNV(days)) && dt_isfinite(SvNV(secs))) {
            IV d = SvIV(days);
            IV s = SvIV(secs);
            IV day_length;

            while (s < 0) {
                SET_DAY_LENGTH(d - 1, day_length);

                s += day_length;
                d--;
            }

            SET_DAY_LENGTH(d, day_length);

            while (s > day_length - 1) {
                s -= day_length;
                d++;
                SET_DAY_LENGTH(d, day_length);
            }

            sv_setiv(days, (IV) d);
            sv_setiv(secs, (IV) s);
        }
#line 497 "DateTime.c"
	PUTBACK;
	return;
    }
}

#endif /* ifdef dt_isfinite */

XS_EUPXS(XS_DateTime__time_as_seconds); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_DateTime__time_as_seconds)
{
    dVAR; dXSARGS;
    if (items != 4)
       croak_xs_usage(cv,  "self, h, m, s");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
	IV	h = (IV)SvIV(ST(1))
;
	IV	m = (IV)SvIV(ST(2))
;
	IV	s = (IV)SvIV(ST(3))
;
#line 266 "DateTime.xs"
        EXTEND(SP, 1);
        mPUSHi(h * 3600 + m * 60 + s);
#line 523 "DateTime.c"
	PUTBACK;
	return;
    }
}


XS_EUPXS(XS_DateTime__is_leap_year); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_DateTime__is_leap_year)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "self, y");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
	IV	y = (IV)SvIV(ST(1))
;
#line 274 "DateTime.xs"
        EXTEND(SP, 1);
        mPUSHi(_real_is_leap_year(y));
#line 544 "DateTime.c"
	PUTBACK;
	return;
    }
}


XS_EUPXS(XS_DateTime__day_length); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_DateTime__day_length)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "self, utc_rd");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
	IV	utc_rd = (IV)SvIV(ST(1))
;
#line 282 "DateTime.xs"
        IV day_length;
        SET_DAY_LENGTH(utc_rd, day_length);

        EXTEND(SP, 1);
        mPUSHi(day_length);
#line 568 "DateTime.c"
	PUTBACK;
	return;
    }
}


XS_EUPXS(XS_DateTime__day_has_leap_second); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_DateTime__day_has_leap_second)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "self, utc_rd");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
	IV	utc_rd = (IV)SvIV(ST(1))
;
#line 293 "DateTime.xs"
        IV day_length;
        SET_DAY_LENGTH(utc_rd, day_length);

        EXTEND(SP, 1);
        mPUSHi(day_length > 86400 ? 1 : 0);
#line 592 "DateTime.c"
	PUTBACK;
	return;
    }
}


XS_EUPXS(XS_DateTime__accumulated_leap_seconds); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_DateTime__accumulated_leap_seconds)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "self, utc_rd");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
	IV	utc_rd = (IV)SvIV(ST(1))
;
#line 304 "DateTime.xs"
        IV leap_seconds;
        SET_LEAP_SECONDS(utc_rd, leap_seconds);

        EXTEND(SP, 1);
        mPUSHi(leap_seconds);
#line 616 "DateTime.c"
	PUTBACK;
	return;
    }
}

#ifdef __cplusplus
extern "C"
#endif
XS_EXTERNAL(boot_DateTime); /* prototype to pass -Wmissing-prototypes */
XS_EXTERNAL(boot_DateTime)
{
#if PERL_VERSION_LE(5, 21, 5)
    dVAR; dXSARGS;
#else
    dVAR; dXSBOOTARGSXSAPIVERCHK;
#endif
#if PERL_VERSION_LE(5, 8, 999) /* PERL_VERSION_LT is 5.33+ */
    char* file = __FILE__;
#else
    const char* file = __FILE__;
#endif

    PERL_UNUSED_VAR(file);

    PERL_UNUSED_VAR(cv); /* -W */
    PERL_UNUSED_VAR(items); /* -W */
#if PERL_VERSION_LE(5, 21, 5)
    XS_VERSION_BOOTCHECK;
#  ifdef XS_APIVERSION_BOOTCHECK
    XS_APIVERSION_BOOTCHECK;
#  endif
#endif

        (void)newXSproto_portable("DateTime::_rd2ymd", XS_DateTime__rd2ymd, file, "$$;$");
        (void)newXSproto_portable("DateTime::_ymd2rd", XS_DateTime__ymd2rd, file, "$$$$");
        (void)newXSproto_portable("DateTime::_seconds_as_components", XS_DateTime__seconds_as_components, file, "$$;$$");
#if XSubPPtmpAAAA
        (void)newXSproto_portable("DateTime::_normalize_tai_seconds", XS_DateTime__normalize_tai_seconds, file, "$$$");
        (void)newXSproto_portable("DateTime::_normalize_leap_seconds", XS_DateTime__normalize_leap_seconds, file, "$$$");
#endif
        (void)newXSproto_portable("DateTime::_time_as_seconds", XS_DateTime__time_as_seconds, file, "$$$$");
        (void)newXSproto_portable("DateTime::_is_leap_year", XS_DateTime__is_leap_year, file, "$$");
        (void)newXSproto_portable("DateTime::_day_length", XS_DateTime__day_length, file, "$$");
        (void)newXSproto_portable("DateTime::_day_has_leap_second", XS_DateTime__day_has_leap_second, file, "$$");
        (void)newXSproto_portable("DateTime::_accumulated_leap_seconds", XS_DateTime__accumulated_leap_seconds, file, "$$");

    /* Initialisation Section */

#if XSubPPtmpAAAA
#endif
#line 667 "DateTime.c"

    /* End of Initialisation Section */

#if PERL_VERSION_LE(5, 21, 5)
#  if PERL_VERSION_GE(5, 9, 0)
    if (PL_unitcheckav)
        call_list(PL_scopestack_ix, PL_unitcheckav);
#  endif
    XSRETURN_YES;
#else
    Perl_xs_boot_epilog(aTHX_ ax);
#endif
}

