; NOTE: Assertions have been autogenerated by utils/update_test_checks.py UTC_ARGS: --check-globals all --version 5
; RUN: opt < %s -passes=amdgpu-sw-lower-lds -amdgpu-asan-instrument-lds=false -S -mtriple=amdgcn-amd-amdhsa | FileCheck %s

; Test to check if LDS is not lowered when a non-kernel with sanitize_address attr and with LDS accesses is called from 
; kernel which doesn't have sanitize_address attr.
@lds_1 = internal addrspace(3) global [1 x i8] poison, align 1
@lds_2 = internal addrspace(3) global [1 x i32] poison, align 2
@lds_3 = external addrspace(3) global [3 x i8], align 4
@lds_4 = external addrspace(3) global [4 x i8], align 8

;.
; CHECK: @lds_1 = internal addrspace(3) global [1 x i8] poison, align 1
; CHECK: @lds_2 = internal addrspace(3) global [1 x i32] poison, align 2
; CHECK: @lds_3 = external addrspace(3) global [3 x i8], align 4
; CHECK: @lds_4 = external addrspace(3) global [4 x i8], align 8
;.
define void @use_variables() sanitize_address {
; CHECK-LABEL: define void @use_variables(
; CHECK-SAME: ) #[[ATTR0:[0-9]+]] {
; CHECK-NEXT:    [[X:%.*]] = addrspacecast ptr addrspace(3) @lds_3 to ptr
; CHECK-NEXT:    [[TMP1:%.*]] = addrspacecast ptr addrspace(3) @lds_3 to ptr
; CHECK-NEXT:    store i8 3, ptr [[TMP1]], align 4
; CHECK-NEXT:    store i8 3, ptr addrspace(3) @lds_4, align 8
; CHECK-NEXT:    ret void
;
  %X = addrspacecast ptr addrspace(3) @lds_3 to ptr
  store i8 3, ptr addrspacecast( ptr addrspace(3) @lds_3 to ptr), align 4
  store i8 3, ptr addrspace(3) @lds_4, align 8
  ret void
}

define amdgpu_kernel void @k0() {
; CHECK-LABEL: define amdgpu_kernel void @k0() {
; CHECK-NEXT:    call void @use_variables()
; CHECK-NEXT:    store i8 7, ptr addrspace(3) @lds_1, align 1
; CHECK-NEXT:    store i32 8, ptr addrspace(3) @lds_2, align 2
; CHECK-NEXT:    ret void
;
  call void @use_variables()
  store i8 7, ptr addrspace(3) @lds_1, align 1
  store i32 8, ptr addrspace(3) @lds_2, align 2
  ret void
}

!llvm.module.flags = !{!0}
!0 = !{i32 4, !"nosanitize_address", i32 1}
;.
; CHECK: attributes #[[ATTR0]] = { sanitize_address }
;.
; CHECK: [[META0:![0-9]+]] = !{i32 4, !"nosanitize_address", i32 1}
;.
