; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -mtriple=x86_64-linux-gnu | FileCheck %s --check-prefix=X64
; RUN: llc < %s -mtriple=x86_64-linux-gnux32 | FileCheck %s --check-prefix=X32
; RUN: llc < %s -mtriple=i386-linux-gnu | FileCheck %s --check-prefix=X86

declare ptr @llvm.thread.pointer()

define ptr @thread_pointer() nounwind {
; X64-LABEL: thread_pointer:
; X64:       # %bb.0:
; X64-NEXT:    movq %fs:0, %rax
; X64-NEXT:    retq
;
; X32-LABEL: thread_pointer:
; X32:       # %bb.0:
; X32-NEXT:    movl %fs:0, %eax
; X32-NEXT:    retq
;
; X86-LABEL: thread_pointer:
; X86:       # %bb.0:
; X86-NEXT:    movl %gs:0, %eax
; X86-NEXT:    retl
  %1 = tail call ptr @llvm.thread.pointer()
  ret ptr %1
}

define i32 @thread_pointer2(i32 %i) nounwind {
; X64-LABEL: thread_pointer2:
; X64:       # %bb.0: # %entry
; X64-NEXT:    movslq %edi, %rax
; X64-NEXT:    movl %fs:(,%rax,4), %eax
; X64-NEXT:    retq
;
; X32-LABEL: thread_pointer2:
; X32:       # %bb.0: # %entry
; X32-NEXT:    movl %fs:0, %eax
; X32-NEXT:    movl (%eax,%edi,4), %eax
; X32-NEXT:    retq
;
; X86-LABEL: thread_pointer2:
; X86:       # %bb.0: # %entry
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    movl %gs:(,%eax,4), %eax
; X86-NEXT:    retl
entry:
  %0 = tail call ptr @llvm.thread.pointer()
  %arrayidx = getelementptr inbounds i32, ptr %0, i32 %i
  %1 = load i32, ptr %arrayidx, align 4
  ret i32 %1
}
