; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -verify-machineinstrs -mtriple=powerpc64le-unknown-linux-gnu \
; RUN:   -mcpu=pwr10 -ppc-asm-full-reg-names -ppc-vsr-nums-as-vr < %s \
; RUN:   | FileCheck %s --check-prefix=LE
; RUN: llc -verify-machineinstrs -target-abi=elfv2 -mtriple=powerpc64-- \
; RUN:   -mcpu=pwr10 -ppc-asm-full-reg-names -ppc-vsr-nums-as-vr < %s \
; RUN:   | FileCheck %s --check-prefix=BE


%struct.Struct = type { i8, i16, i32 }

@valChar = external local_unnamed_addr global i8, align 1
@valShort = external local_unnamed_addr global i16, align 2
@valInt = external global i32, align 4
@valUnsigned = external local_unnamed_addr global i32, align 4
@valLong = external local_unnamed_addr global i64, align 8
@ptr = external local_unnamed_addr global ptr, align 8
@array = external local_unnamed_addr global [10 x i32], align 4
@structure = external local_unnamed_addr global %struct.Struct, align 4
@ptrfunc = external local_unnamed_addr global ptr, align 8

define dso_local signext i32 @ReadGlobalVarChar() local_unnamed_addr  {
; LE-LABEL: ReadGlobalVarChar:
; LE:       # %bb.0: # %entry
; LE-NEXT:    pld r3, valChar@got@pcrel(0), 1
; LE-NEXT:  .Lpcrel0:
; LE-NEXT:    .reloc .Lpcrel0-8,R_PPC64_PCREL_OPT,.-(.Lpcrel0-8)
; LE-NEXT:    lbz r3, 0(r3)
; LE-NEXT:    blr
;
; BE-LABEL: ReadGlobalVarChar:
; BE:       # %bb.0: # %entry
; BE-NEXT:    pld r3, valChar@got@pcrel(0), 1
; BE-NEXT:  .Lpcrel0:
; BE-NEXT:    .reloc .Lpcrel0-8,R_PPC64_PCREL_OPT,.-(.Lpcrel0-8)
; BE-NEXT:    lbz r3, 0(r3)
; BE-NEXT:    blr
entry:
  %0 = load i8, ptr @valChar, align 1
  %conv = zext i8 %0 to i32
  ret i32 %conv
}

define dso_local void @WriteGlobalVarChar() local_unnamed_addr  {
; LE-LABEL: WriteGlobalVarChar:
; LE:       # %bb.0: # %entry
; LE-NEXT:    pld r3, valChar@got@pcrel(0), 1
; LE-NEXT:    li r4, 3
; LE-NEXT:    stb r4, 0(r3)
; LE-NEXT:    blr
;
; BE-LABEL: WriteGlobalVarChar:
; BE:       # %bb.0: # %entry
; BE-NEXT:    pld r3, valChar@got@pcrel(0), 1
; BE-NEXT:    li r4, 3
; BE-NEXT:    stb r4, 0(r3)
; BE-NEXT:    blr
entry:
  store i8 3, ptr @valChar, align 1
  ret void
}

define dso_local signext i32 @ReadGlobalVarShort() local_unnamed_addr  {
; LE-LABEL: ReadGlobalVarShort:
; LE:       # %bb.0: # %entry
; LE-NEXT:    pld r3, valShort@got@pcrel(0), 1
; LE-NEXT:  .Lpcrel1:
; LE-NEXT:    .reloc .Lpcrel1-8,R_PPC64_PCREL_OPT,.-(.Lpcrel1-8)
; LE-NEXT:    lha r3, 0(r3)
; LE-NEXT:    blr
;
; BE-LABEL: ReadGlobalVarShort:
; BE:       # %bb.0: # %entry
; BE-NEXT:    pld r3, valShort@got@pcrel(0), 1
; BE-NEXT:  .Lpcrel1:
; BE-NEXT:    .reloc .Lpcrel1-8,R_PPC64_PCREL_OPT,.-(.Lpcrel1-8)
; BE-NEXT:    lha r3, 0(r3)
; BE-NEXT:    blr
entry:
  %0 = load i16, ptr @valShort, align 2
  %conv = sext i16 %0 to i32
  ret i32 %conv
}

define dso_local void @WriteGlobalVarShort() local_unnamed_addr  {
; LE-LABEL: WriteGlobalVarShort:
; LE:       # %bb.0: # %entry
; LE-NEXT:    pld r3, valShort@got@pcrel(0), 1
; LE-NEXT:    li r4, 3
; LE-NEXT:    sth r4, 0(r3)
; LE-NEXT:    blr
;
; BE-LABEL: WriteGlobalVarShort:
; BE:       # %bb.0: # %entry
; BE-NEXT:    pld r3, valShort@got@pcrel(0), 1
; BE-NEXT:    li r4, 3
; BE-NEXT:    sth r4, 0(r3)
; BE-NEXT:    blr
entry:
  store i16 3, ptr @valShort, align 2
  ret void
}

define dso_local signext i32 @ReadGlobalVarInt() local_unnamed_addr  {
; LE-LABEL: ReadGlobalVarInt:
; LE:       # %bb.0: # %entry
; LE-NEXT:    pld r3, valInt@got@pcrel(0), 1
; LE-NEXT:  .Lpcrel2:
; LE-NEXT:    .reloc .Lpcrel2-8,R_PPC64_PCREL_OPT,.-(.Lpcrel2-8)
; LE-NEXT:    lwa r3, 0(r3)
; LE-NEXT:    blr
;
; BE-LABEL: ReadGlobalVarInt:
; BE:       # %bb.0: # %entry
; BE-NEXT:    pld r3, valInt@got@pcrel(0), 1
; BE-NEXT:  .Lpcrel2:
; BE-NEXT:    .reloc .Lpcrel2-8,R_PPC64_PCREL_OPT,.-(.Lpcrel2-8)
; BE-NEXT:    lwa r3, 0(r3)
; BE-NEXT:    blr
entry:
  %0 = load i32, ptr @valInt, align 4
  ret i32 %0
}

define dso_local void @WriteGlobalVarInt() local_unnamed_addr  {
; LE-LABEL: WriteGlobalVarInt:
; LE:       # %bb.0: # %entry
; LE-NEXT:    pld r3, valInt@got@pcrel(0), 1
; LE-NEXT:    li r4, 33
; LE-NEXT:    stw r4, 0(r3)
; LE-NEXT:    blr
;
; BE-LABEL: WriteGlobalVarInt:
; BE:       # %bb.0: # %entry
; BE-NEXT:    pld r3, valInt@got@pcrel(0), 1
; BE-NEXT:    li r4, 33
; BE-NEXT:    stw r4, 0(r3)
; BE-NEXT:    blr
entry:
  store i32 33, ptr @valInt, align 4
  ret void
}

define dso_local signext i32 @ReadGlobalVarUnsigned() local_unnamed_addr  {
; LE-LABEL: ReadGlobalVarUnsigned:
; LE:       # %bb.0: # %entry
; LE-NEXT:    pld r3, valUnsigned@got@pcrel(0), 1
; LE-NEXT:  .Lpcrel3:
; LE-NEXT:    .reloc .Lpcrel3-8,R_PPC64_PCREL_OPT,.-(.Lpcrel3-8)
; LE-NEXT:    lwa r3, 0(r3)
; LE-NEXT:    blr
;
; BE-LABEL: ReadGlobalVarUnsigned:
; BE:       # %bb.0: # %entry
; BE-NEXT:    pld r3, valUnsigned@got@pcrel(0), 1
; BE-NEXT:  .Lpcrel3:
; BE-NEXT:    .reloc .Lpcrel3-8,R_PPC64_PCREL_OPT,.-(.Lpcrel3-8)
; BE-NEXT:    lwa r3, 0(r3)
; BE-NEXT:    blr
entry:
  %0 = load i32, ptr @valUnsigned, align 4
  ret i32 %0
}

define dso_local void @WriteGlobalVarUnsigned() local_unnamed_addr  {
; LE-LABEL: WriteGlobalVarUnsigned:
; LE:       # %bb.0: # %entry
; LE-NEXT:    pld r3, valUnsigned@got@pcrel(0), 1
; LE-NEXT:    li r4, 33
; LE-NEXT:    stw r4, 0(r3)
; LE-NEXT:    blr
;
; BE-LABEL: WriteGlobalVarUnsigned:
; BE:       # %bb.0: # %entry
; BE-NEXT:    pld r3, valUnsigned@got@pcrel(0), 1
; BE-NEXT:    li r4, 33
; BE-NEXT:    stw r4, 0(r3)
; BE-NEXT:    blr
entry:
  store i32 33, ptr @valUnsigned, align 4
  ret void
}

define dso_local signext i32 @ReadGlobalVarLong() local_unnamed_addr  {
; LE-LABEL: ReadGlobalVarLong:
; LE:       # %bb.0: # %entry
; LE-NEXT:    pld r3, valLong@got@pcrel(0), 1
; LE-NEXT:  .Lpcrel4:
; LE-NEXT:    .reloc .Lpcrel4-8,R_PPC64_PCREL_OPT,.-(.Lpcrel4-8)
; LE-NEXT:    lwa r3, 0(r3)
; LE-NEXT:    blr
;
; BE-LABEL: ReadGlobalVarLong:
; BE:       # %bb.0: # %entry
; BE-NEXT:    pld r3, valLong@got@pcrel(0), 1
; BE-NEXT:  .Lpcrel4:
; BE-NEXT:    .reloc .Lpcrel4-8,R_PPC64_PCREL_OPT,.-(.Lpcrel4-8)
; BE-NEXT:    lwa r3, 4(r3)
; BE-NEXT:    blr
entry:
  %0 = load i64, ptr @valLong, align 8
  %conv = trunc i64 %0 to i32
  ret i32 %conv
}

define dso_local void @WriteGlobalVarLong() local_unnamed_addr  {
; LE-LABEL: WriteGlobalVarLong:
; LE:       # %bb.0: # %entry
; LE-NEXT:    pld r3, valLong@got@pcrel(0), 1
; LE-NEXT:    li r4, 3333
; LE-NEXT:    std r4, 0(r3)
; LE-NEXT:    blr
;
; BE-LABEL: WriteGlobalVarLong:
; BE:       # %bb.0: # %entry
; BE-NEXT:    pld r3, valLong@got@pcrel(0), 1
; BE-NEXT:    li r4, 3333
; BE-NEXT:    std r4, 0(r3)
; BE-NEXT:    blr
entry:
  store i64 3333, ptr @valLong, align 8
  ret void
}

define dso_local ptr @ReadGlobalPtr() local_unnamed_addr  {
; LE-LABEL: ReadGlobalPtr:
; LE:       # %bb.0: # %entry
; LE-NEXT:    pld r3, ptr@got@pcrel(0), 1
; LE-NEXT:  .Lpcrel5:
; LE-NEXT:    .reloc .Lpcrel5-8,R_PPC64_PCREL_OPT,.-(.Lpcrel5-8)
; LE-NEXT:    ld r3, 0(r3)
; LE-NEXT:    blr
;
; BE-LABEL: ReadGlobalPtr:
; BE:       # %bb.0: # %entry
; BE-NEXT:    pld r3, ptr@got@pcrel(0), 1
; BE-NEXT:  .Lpcrel5:
; BE-NEXT:    .reloc .Lpcrel5-8,R_PPC64_PCREL_OPT,.-(.Lpcrel5-8)
; BE-NEXT:    ld r3, 0(r3)
; BE-NEXT:    blr
entry:
  %0 = load ptr, ptr @ptr, align 8
  ret ptr %0
}

define dso_local void @WriteGlobalPtr() local_unnamed_addr  {
; LE-LABEL: WriteGlobalPtr:
; LE:       # %bb.0: # %entry
; LE-NEXT:    pld r3, ptr@got@pcrel(0), 1
; LE-NEXT:  .Lpcrel6:
; LE-NEXT:    li r4, 3
; LE-NEXT:    .reloc .Lpcrel6-8,R_PPC64_PCREL_OPT,.-(.Lpcrel6-8)
; LE-NEXT:    ld r3, 0(r3)
; LE-NEXT:    stw r4, 0(r3)
; LE-NEXT:    blr
;
; BE-LABEL: WriteGlobalPtr:
; BE:       # %bb.0: # %entry
; BE-NEXT:    pld r3, ptr@got@pcrel(0), 1
; BE-NEXT:  .Lpcrel6:
; BE-NEXT:    li r4, 3
; BE-NEXT:    .reloc .Lpcrel6-8,R_PPC64_PCREL_OPT,.-(.Lpcrel6-8)
; BE-NEXT:    ld r3, 0(r3)
; BE-NEXT:    stw r4, 0(r3)
; BE-NEXT:    blr
entry:
  %0 = load ptr, ptr @ptr, align 8
  store i32 3, ptr %0, align 4
  ret void
}

define dso_local nonnull ptr @GlobalVarAddr() local_unnamed_addr  {
; LE-LABEL: GlobalVarAddr:
; LE:       # %bb.0: # %entry
; LE-NEXT:    pld r3, valInt@got@pcrel(0), 1
; LE-NEXT:    blr
;
; BE-LABEL: GlobalVarAddr:
; BE:       # %bb.0: # %entry
; BE-NEXT:    pld r3, valInt@got@pcrel(0), 1
; BE-NEXT:    blr
entry:
  ret ptr @valInt
}

define dso_local signext i32 @ReadGlobalArray() local_unnamed_addr  {
; LE-LABEL: ReadGlobalArray:
; LE:       # %bb.0: # %entry
; LE-NEXT:    pld r3, array@got@pcrel(0), 1
; LE-NEXT:  .Lpcrel7:
; LE-NEXT:    .reloc .Lpcrel7-8,R_PPC64_PCREL_OPT,.-(.Lpcrel7-8)
; LE-NEXT:    lwa r3, 12(r3)
; LE-NEXT:    blr
;
; BE-LABEL: ReadGlobalArray:
; BE:       # %bb.0: # %entry
; BE-NEXT:    pld r3, array@got@pcrel(0), 1
; BE-NEXT:  .Lpcrel7:
; BE-NEXT:    .reloc .Lpcrel7-8,R_PPC64_PCREL_OPT,.-(.Lpcrel7-8)
; BE-NEXT:    lwa r3, 12(r3)
; BE-NEXT:    blr
entry:
  %0 = load i32, ptr getelementptr inbounds ([10 x i32], ptr @array, i64 0, i64 3), align 4
  ret i32 %0
}

define dso_local void @WriteGlobalArray() local_unnamed_addr  {
; LE-LABEL: WriteGlobalArray:
; LE:       # %bb.0: # %entry
; LE-NEXT:    pld r3, array@got@pcrel(0), 1
; LE-NEXT:    li r4, 5
; LE-NEXT:    stw r4, 12(r3)
; LE-NEXT:    blr
;
; BE-LABEL: WriteGlobalArray:
; BE:       # %bb.0: # %entry
; BE-NEXT:    pld r3, array@got@pcrel(0), 1
; BE-NEXT:    li r4, 5
; BE-NEXT:    stw r4, 12(r3)
; BE-NEXT:    blr
entry:
  store i32 5, ptr getelementptr inbounds ([10 x i32], ptr @array, i64 0, i64 3), align 4
  ret void
}

define dso_local signext i32 @ReadGlobalStruct() local_unnamed_addr  {
; LE-LABEL: ReadGlobalStruct:
; LE:       # %bb.0: # %entry
; LE-NEXT:    pld r3, structure@got@pcrel(0), 1
; LE-NEXT:  .Lpcrel8:
; LE-NEXT:    .reloc .Lpcrel8-8,R_PPC64_PCREL_OPT,.-(.Lpcrel8-8)
; LE-NEXT:    lwa r3, 4(r3)
; LE-NEXT:    blr
;
; BE-LABEL: ReadGlobalStruct:
; BE:       # %bb.0: # %entry
; BE-NEXT:    pld r3, structure@got@pcrel(0), 1
; BE-NEXT:  .Lpcrel8:
; BE-NEXT:    .reloc .Lpcrel8-8,R_PPC64_PCREL_OPT,.-(.Lpcrel8-8)
; BE-NEXT:    lwa r3, 4(r3)
; BE-NEXT:    blr
entry:
  %0 = load i32, ptr getelementptr inbounds (%struct.Struct, ptr @structure, i64 0, i32 2), align 4
  ret i32 %0
}

define dso_local void @WriteGlobalStruct() local_unnamed_addr  {
; LE-LABEL: WriteGlobalStruct:
; LE:       # %bb.0: # %entry
; LE-NEXT:    pld r3, structure@got@pcrel(0), 1
; LE-NEXT:    li r4, 3
; LE-NEXT:    stw r4, 4(r3)
; LE-NEXT:    blr
;
; BE-LABEL: WriteGlobalStruct:
; BE:       # %bb.0: # %entry
; BE-NEXT:    pld r3, structure@got@pcrel(0), 1
; BE-NEXT:    li r4, 3
; BE-NEXT:    stw r4, 4(r3)
; BE-NEXT:    blr
entry:
  store i32 3, ptr getelementptr inbounds (%struct.Struct, ptr @structure, i64 0, i32 2), align 4
  ret void
}

define dso_local void @ReadFuncPtr() local_unnamed_addr  {
; LE-LABEL: ReadFuncPtr:
; LE:         .localentry ReadFuncPtr, 1
; LE-NEXT:  # %bb.0: # %entry
; LE-NEXT:    pld r3, ptrfunc@got@pcrel(0), 1
; LE-NEXT:  .Lpcrel9:
; LE-NEXT:    .reloc .Lpcrel9-8,R_PPC64_PCREL_OPT,.-(.Lpcrel9-8)
; LE-NEXT:    ld r12, 0(r3)
; LE-NEXT:    mtctr r12
; LE-NEXT:    bctr
; LE-NEXT:    #TC_RETURNr8 ctr 0
;
; BE-LABEL: ReadFuncPtr:
; BE:         .localentry ReadFuncPtr, 1
; BE-NEXT:  # %bb.0: # %entry
; BE-NEXT:    pld r3, ptrfunc@got@pcrel(0), 1
; BE-NEXT:  .Lpcrel9:
; BE-NEXT:    .reloc .Lpcrel9-8,R_PPC64_PCREL_OPT,.-(.Lpcrel9-8)
; BE-NEXT:    ld r12, 0(r3)
; BE-NEXT:    mtctr r12
; BE-NEXT:    bctr
; BE-NEXT:    #TC_RETURNr8 ctr 0
entry:
  %0 = load ptr, ptr @ptrfunc, align 8
  tail call void %0()
  ret void
}

define dso_local void @WriteFuncPtr() local_unnamed_addr  {
; LE-LABEL: WriteFuncPtr:
; LE:       # %bb.0: # %entry
; LE-NEXT:    pld r3, ptrfunc@got@pcrel(0), 1
; LE-NEXT:    pld r4, function@got@pcrel(0), 1
; LE-NEXT:    std r4, 0(r3)
; LE-NEXT:    blr
;
; BE-LABEL: WriteFuncPtr:
; BE:       # %bb.0: # %entry
; BE-NEXT:    pld r3, ptrfunc@got@pcrel(0), 1
; BE-NEXT:    pld r4, function@got@pcrel(0), 1
; BE-NEXT:    std r4, 0(r3)
; BE-NEXT:    blr
entry:
  store ptr @function, ptr @ptrfunc, align 8
  ret void
}

declare void @function(...)

