; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 4
; RUN: llc -mtriple=aarch64-linux -mattr=+neon,+fp8 < %s | FileCheck %s

define <8 x bfloat> @test_vbfcvtl1_low(<8 x i8> %vn) {
; CHECK-LABEL: test_vbfcvtl1_low:
; CHECK:       // %bb.0:
; CHECK-NEXT:    bf1cvtl v0.8h, v0.8b
; CHECK-NEXT:    ret
  %res = call <8 x bfloat> @llvm.aarch64.neon.fp8.cvtl1.v8bf16.v8i8(<8 x i8> %vn)
  ret <8 x bfloat> %res
}

define <8 x bfloat> @test_vbfcvtl1_high(<16 x i8> %vn) {
; CHECK-LABEL: test_vbfcvtl1_high:
; CHECK:       // %bb.0:
; CHECK-NEXT:    bf1cvtl2 v0.8h, v0.16b
; CHECK-NEXT:    ret
  %res = call <8 x bfloat> @llvm.aarch64.neon.fp8.cvtl1.v8bf16.v16i8(<16 x i8> %vn)
  ret <8 x bfloat> %res
}

define <8 x bfloat> @test_vbfcvtl2_low(<8 x i8> %vn) {
; CHECK-LABEL: test_vbfcvtl2_low:
; CHECK:       // %bb.0:
; CHECK-NEXT:    bf2cvtl v0.8h, v0.8b
; CHECK-NEXT:    ret
  %res = call <8 x bfloat> @llvm.aarch64.neon.fp8.cvtl2.v8bf16.v8i8(<8 x i8> %vn)
  ret <8 x bfloat> %res
}

define <8 x bfloat> @test_vbfcvtl2_high(<16 x i8> %vn) {
; CHECK-LABEL: test_vbfcvtl2_high:
; CHECK:       // %bb.0:
; CHECK-NEXT:    bf2cvtl2 v0.8h, v0.16b
; CHECK-NEXT:    ret
  %res = call <8 x bfloat> @llvm.aarch64.neon.fp8.cvtl2.v8bf16.v16i8(<16 x i8> %vn)
  ret <8 x bfloat> %res
}


define <8 x half> @test_vfcvtl1_low(<8 x i8> %vn) {
; CHECK-LABEL: test_vfcvtl1_low:
; CHECK:       // %bb.0:
; CHECK-NEXT:    f1cvtl v0.8h, v0.8b
; CHECK-NEXT:    ret
   %res = call <8 x half> @llvm.aarch64.neon.fp8.cvtl1.v8f16.v8i8(<8 x i8> %vn)
  ret <8 x half> %res
}

define <8 x half> @test_vfcvtl1_high(<16 x i8> %vn) {
; CHECK-LABEL: test_vfcvtl1_high:
; CHECK:       // %bb.0:
; CHECK-NEXT:    f1cvtl2 v0.8h, v0.16b
; CHECK-NEXT:    ret
  %res = call <8 x half> @llvm.aarch64.neon.fp8.cvtl1.v8f16.v16i8(<16 x i8> %vn)
  ret <8 x half> %res
}

define <8 x half> @test_vfcvtl2_low(<8 x i8> %vn) {
; CHECK-LABEL: test_vfcvtl2_low:
; CHECK:       // %bb.0:
; CHECK-NEXT:    f2cvtl v0.8h, v0.8b
; CHECK-NEXT:    ret
  %res = call <8 x half> @llvm.aarch64.neon.fp8.cvtl2.v8f16.v8i8(<8 x i8> %vn)
  ret <8 x half> %res
}

define <8 x half> @test_vfcvtl2_high(<16 x i8> %vn) {
; CHECK-LABEL: test_vfcvtl2_high:
; CHECK:       // %bb.0:
; CHECK-NEXT:    f2cvtl2 v0.8h, v0.16b
; CHECK-NEXT:    ret
  %res = call <8 x half> @llvm.aarch64.neon.fp8.cvtl2.v8f16.v16i8(<16 x i8> %vn)
  ret <8 x half> %res
}

define <8 x i8> @test_vcvtn_low_f8_f32(<4 x float> %vn, <4 x float> %vm) {
; CHECK-LABEL: test_vcvtn_low_f8_f32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    fcvtn v0.8b, v0.4s, v1.4s
; CHECK-NEXT:    ret
  %res = call <8 x i8> @llvm.aarch64.neon.fp8.fcvtn.v8i8.v4f32(<4 x float> %vn, <4 x float> %vm)
  ret <8 x i8> %res
}

define <16 x i8> @test_vcvtn_high_f8_f32(<16 x i8> %vd, <4 x float> %vn, <4 x float> %vm) {
; CHECK-LABEL: test_vcvtn_high_f8_f32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    fcvtn2 v0.16b, v1.4s, v2.4s
; CHECK-NEXT:    ret
  %res = call <16 x i8> @llvm.aarch64.neon.fp8.fcvtn2.v16i8.v4f32(<16 x i8> %vd, <4 x float> %vn, <4 x float> %vm)
  ret <16 x i8> %res
}


define <8 x i8> @test_vcvtn_f8_f16(<4 x half> %vn, <4 x half> %vm) {
; CHECK-LABEL: test_vcvtn_f8_f16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    fcvtn v0.8b, v0.4h, v1.4h
; CHECK-NEXT:    ret
  %res = call <8 x i8> @llvm.aarch64.neon.fp8.fcvtn.v8i8.v4f16(<4 x half> %vn, <4 x half> %vm)
  ret <8 x i8> %res
}

define <16 x i8> @test_vcvtn2_f8_f16(<8 x half> %vn, <8 x half> %vm) {
; CHECK-LABEL: test_vcvtn2_f8_f16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    fcvtn v0.16b, v0.8h, v1.8h
; CHECK-NEXT:    ret
  %res = call <16 x i8> @llvm.aarch64.neon.fp8.fcvtn.v16i8.v8f16(<8 x half> %vn, <8 x half> %vm)
  ret <16 x i8> %res
}
