; NOTE: Assertions have been autogenerated by utils/update_analyze_test_checks.py UTC_ARGS: --version 2
; RUN: opt -passes='print<scalar-evolution>' -disable-output %s 2>&1 | FileCheck %s

define ptr @f() {
; CHECK-LABEL: 'f'
; CHECK-NEXT:  Classifying expressions for: @f
; CHECK-NEXT:    %alloc = tail call dereferenceable(64) ptr @malloc(i64 64)
; CHECK-NEXT:    --> %alloc U: [1,-64) S: full-set
; CHECK-NEXT:  Determining loop execution counts for: @f
;
  %alloc = tail call dereferenceable(64) ptr @malloc(i64 64)
  ret ptr %alloc
}

define ptr @f2() {
; CHECK-LABEL: 'f2'
; CHECK-NEXT:  Classifying expressions for: @f2
; CHECK-NEXT:    %alloc = tail call dereferenceable_or_null(64) ptr @malloc(i64 64)
; CHECK-NEXT:    --> %alloc U: [0,-64) S: full-set
; CHECK-NEXT:  Determining loop execution counts for: @f2
;
  %alloc = tail call dereferenceable_or_null(64) ptr @malloc(i64 64)
  ret ptr %alloc
}

define ptr @undefined_max() {
; CHECK-LABEL: 'undefined_max'
; CHECK-NEXT:  Classifying expressions for: @undefined_max
; CHECK-NEXT:    %alloc = call nonnull ptr @malloc(i64 -1)
; CHECK-NEXT:    --> %alloc U: full-set S: full-set
; CHECK-NEXT:  Determining loop execution counts for: @undefined_max
;
  %alloc = call nonnull ptr @malloc(i64 -1)
  ret ptr %alloc
}

declare noalias noundef ptr @malloc(i64 noundef) allockind("alloc,uninitialized") allocsize(0)
