/*############################################################################
  # Copyright (C) 2020-2022 Intel Corporation
  #
  # SPDX-License-Identifier: MIT
  ############################################################################*/

#include <stddef.h>
#include <stdio.h>

#include "./mfx.h"
#include "./mfxcamera.h"

/* .cpp instead of .h to avoid changing of include files dependencies graph
    and not to include unnecessary includes into libmfx library             */

/*  VC's IntelliSense calculates sizeof(object*) wrongly and marks several expressions by red lines. This is IntelliSense bug not ours*/

#define MSDK_STATIC_ASSERT(COND, MSG)  static_assert(COND, MSG);
#define MSDK_STATIC_ASSERT_STRUCT_SIZE(STRUCT, SIZE) MSDK_STATIC_ASSERT(sizeof(STRUCT) == SIZE, "struct size violation: sizeof "#STRUCT" was fixed to "#SIZE);
#define MSDK_STATIC_ASSERT_STRUCT_OFFSET(STRUCT, FIELD, OFFSET) MSDK_STATIC_ASSERT(offsetof(STRUCT, FIELD) == OFFSET, "struct's field offset violation: offsetof "#STRUCT"::"#FIELD" was fixed to "#OFFSET);
#define MSDK_STATIC_COMPARE(CMP1, CMP2)  MSDK_STATIC_ASSERT(CMP1 == CMP2, "value violation:"#CMP1"was equal to"#CMP2);

//mfxcommon.h
#if defined(_x86_64)
    MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxExtBuffer              ,8    )
    MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxVersion                ,4    )
    MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxBitstream              ,72   )
    MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxInitParam              ,80   )
    MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxExtThreadsParam        ,132  )
    MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxPlatform               ,32   )
#elif defined(_x86)
    MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxExtBuffer              ,8    )
    MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxVersion                ,4    )
    MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxBitstream              ,64   )
    MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxInitParam              ,68   )
    MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxExtThreadsParam        ,132  )
    MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxPlatform               ,32   )
#endif

//mfxdefs.h
#if defined(_x86_64)
    MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxI16Pair                ,4    )
    MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxHDLPair                ,16   )
    MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxStatus                 ,4    )
    MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxGUID                   ,16   )
#elif defined(_x86)
    MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxI16Pair                ,4    )
    MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxHDLPair                ,8    )
    MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxStatus                 ,4    )
    MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxGUID                   ,16   )
#endif

//mfxjpeg.h
#if defined(_x86_64)
    MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxExtJPEGQuantTables      ,536  )
    MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxExtJPEGHuffmanTables    ,840  )
#elif defined(_x86)
    MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxExtJPEGQuantTables      ,536  )
    MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxExtJPEGHuffmanTables    ,840  )
#endif

//mfxmvc.h
#if defined(_x86_64)
    MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxMVCViewDependency       ,138  )
    MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxMVCOperationPoint       ,16   )
    MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxExtMVCSeqDesc           ,128  )
    MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxExtMVCTargetViews       ,2064 )
#elif defined(_x86)
    MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxMVCViewDependency       ,138  )
    MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxMVCOperationPoint       ,12   )
    MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxExtMVCSeqDesc           ,112  )
    MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxExtMVCTargetViews       ,2064 )
#endif

//mfxstructures.h
#if defined(_x86_64)
    MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxFrameId                   ,8   )
    MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxFrameInfo                 ,68  )
    MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxY410                      ,4   )
    MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxY416                      ,8   )
    MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxA2RGB10                   ,4   )
#ifdef ONEVPL_EXPERIMENTAL
    MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxABGR16FP                  ,8   )
#endif
    MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxFrameData                 ,96  )
    MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxFrameSurface1             ,184 )
    MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxInfoMFX                   ,136 )
    MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxInfoVPP                   ,168 )
    MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxVideoParam                ,208 ) //IntelliSense wrongly marks this line
    MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxExtCodingOption           ,64  )
    MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxExtCodingOption2          ,68  )
    MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxExtCodingOption3          ,512 )
    MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxExtVPPDoNotUse            ,24  )
    MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxExtVPPDenoise             ,12  )
    MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxExtVPPDenoise2            ,44  )
    MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxChannel                   ,32  )
    MSDK_STATIC_ASSERT_STRUCT_SIZE(mfx3DLutSystemBuffer         ,128 )
    MSDK_STATIC_ASSERT_STRUCT_SIZE(mfx3DLutVideoBuffer          ,48  )
    MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxExtVPP3DLut               ,160 )
    MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxExtVPPDetail              ,12  )
    MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxExtVPPProcAmp             ,40  )
    MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxEncodeStat                ,88  )
    MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxDecodeStat                ,80  )
    MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxVPPStat                   ,72  )
    MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxExtVppAuxData             ,20  )
    MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxPayload                   ,32  )
    MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxEncodeCtrl                ,56  )
    MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxFrameAllocRequest         ,92  )
    MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxFrameAllocResponse        ,32  )
    MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxExtCodingOptionSPSPPS     ,32  )
    MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxExtCodingOptionVPS        ,32  )
    MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxExtVideoSignalInfo        ,20  )
    MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxExtVPPDoUse               ,24  )
    MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxExtAVCRefListCtrl         ,1068)
    MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxExtVPPFrameRateConversion ,72  )
    MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxExtVPPImageStab           ,32  )
    MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxExtMasteringDisplayColourVolume,64   )
    MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxExtContentLightLevelInfo       ,32   )
    MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxExtPictureTimingSEI       ,160 )
    MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxExtAvcTemporalLayers      ,92  )
    MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxExtEncoderCapability      ,128 )
    MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxExtEncoderResetOption     ,32  )
    MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxExtAVCEncodedFrameInfo    ,1056)
    MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxVPPCompInputStream        ,64  )
    MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxExtVPPComposite           ,72   )
    MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxExtVPPVideoSignalInfo     ,48  )
    MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxExtEncoderROI             ,8224)
    MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxExtVPPDeinterlacing       ,32  )
    MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxExtAVCRefLists            ,1040 )
    MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxExtVPPFieldProcessing     ,64   )
    MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxExtDecVideoProcessing     ,132  )
    MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxExtChromaLocInfo          ,32   )
    MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxExtMBQP                   ,64   )
    MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxQPandMode                 ,4    )
    MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxExtInsertHeaders          ,28   )
    MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxExtEncoderIPCMArea        ,40   )
    MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxExtEncoderIPCMArea::area  ,32   ) 
    MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxExtMBForceIntra           ,64   )
    MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxExtHEVCTiles              ,160  )
    MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxExtMBDisableSkipMap       ,64   )
    MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxExtHEVCParam              ,256  )
    MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxExtDecodeErrorReport      ,32   )
    MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxExtDecodedFrameInfo       ,128  )
    MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxExtTimeCode               ,32   )
    MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxExtHEVCRegion             ,64   )
    MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxExtPredWeightTable        ,1152 )
    MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxExtAVCRoundingOffset      ,64   )
    MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxExtDirtyRect              ,8224 )
    MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxExtMoveRect               ,8224 )
    MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxExtVPPRotation            ,32   )
    MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxExtEncodedSlicesInfo      ,64   )
    MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxExtVPPScaling             ,32   )
    MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxExtVPPMirroring           ,32   )
    MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxExtMVOverPicBoundaries    ,32   )
    MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxExtVPPColorFill           ,32   )
    MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxExtColorConversion        ,64   )
    MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxVP9SegmentParam           ,32   )
    MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxExtVP9Segmentation        ,384  )
    MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxVP9TemporalLayer          ,32   )
    MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxExtVP9TemporalLayers      ,384  )
    MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxExtVP9Param               ,256  )
    MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxEncodedUnitInfo           ,32   )
    MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxExtEncodedUnitsInfo       ,64   )
    MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxExtVppMctf                ,64   )
    MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxAV1FilmGrainPoint         ,2    )
    MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxExtAV1FilmGrainParam      ,256  )
    MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxComponentInfo             ,224  )
    MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxAdapterInfo               ,64   )
    MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxAdaptersInfo              ,24   )
    MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxExtPartialBitstreamParam  ,32   )
#ifdef ONEVPL_EXPERIMENTAL
    MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxMemoryInterface            ,152 )

    MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxSurfaceInterface           ,184 )
    MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxSurfaceHeader              , 48 )
    MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxSurfaceD3D11Tex2D          ,248 )
    MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxSurfaceD3D12Tex2D          ,248 )
    MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxSurfaceVAAPI               ,248 )
    MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxSurfaceOpenCLImg2D         ,304 )
    MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxSurfaceVulkanImg2D         ,304 )

    MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxSurfaceTypesSupported                      ,32 )
    MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxSurfaceTypesSupported::surftype            ,40 )
    MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxSurfaceTypesSupported::surftype::surfcomp  ,36 )

    MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxExtSurfaceOpenCLImg2DExportDescription,  88 )
    MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxExtSurfaceD3D12Tex2DExportDescription,  88 )
    MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxExtSurfaceVulkanImg2DExportDescription,  88 )
#endif
    MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxExtVPPAISuperResolution, 112)
    MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxExtVPPAIFrameInterpolation, 176)

#elif defined(_x86)
    MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxFrameId                   ,8   )
    MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxFrameInfo                 ,68  )
    MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxY410                      ,4   )
    MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxA2RGB10                   ,4   )
    MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxFrameData                 ,72  )
    MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxFrameSurface1             ,160 )
    MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxInfoMFX                   ,136 )
    MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxInfoVPP                   ,168 )
    MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxVideoParam                ,196 )
    MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxExtCodingOption           ,64  )
    MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxExtCodingOption2          ,68  )
    MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxExtCodingOption3          ,512 )
    MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxExtVPPDoNotUse            ,16  )
    MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxExtVPPDenoise             ,12  )
    MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxExtVPPDenoise2            ,44  )
    MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxChannel                   ,28  )
    MSDK_STATIC_ASSERT_STRUCT_SIZE(mfx3DLutSystemBuffer         ,116 )
    MSDK_STATIC_ASSERT_STRUCT_SIZE(mfx3DLutVideoBuffer          ,44  )
    MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxExtVPP3DLut               ,148 )
    MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxExtVPPDetail              ,12  )
    MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxExtVPPProcAmp             ,40  )
    MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxEncodeStat                ,88  )
    MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxDecodeStat                ,80  )
    MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxVPPStat                   ,72  )
    MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxExtVppAuxData             ,20  )
    MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxPayload                   ,28  )
    MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxEncodeCtrl                ,48  )
    MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxFrameAllocRequest         ,92  )
    MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxFrameAllocResponse        ,24  )
    MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxExtCodingOptionSPSPPS     ,24  )
    MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxExtCodingOptionVPS        ,32  )
    MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxExtVideoSignalInfo        ,20  )
    MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxExtVPPDoUse               ,16  )
    MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxExtAVCRefListCtrl         ,1068)
    MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxExtVPPFrameRateConversion ,72  )
    MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxExtVPPImageStab           ,32  )
    MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxExtMasteringDisplayColourVolume ,64   )
    MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxExtContentLightLevelInfo        ,32   )
    MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxExtPictureTimingSEI       ,160 )
    MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxExtAvcTemporalLayers      ,92  )
    MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxExtEncoderCapability      ,128 )
    MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxExtEncoderResetOption     ,32  )
    MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxExtAVCEncodedFrameInfo    ,1056)
    MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxVPPCompInputStream        ,64  )
    MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxExtVPPComposite           ,68   )
    MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxExtVPPVideoSignalInfo     ,48  )
    MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxExtEncoderROI             ,8224)
    MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxExtVPPDeinterlacing       ,32  )
    MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxExtAVCRefLists            ,1040 )
    MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxExtVPPFieldProcessing     ,64   )
    MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxExtDecVideoProcessing     ,132  )
    MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxExtChromaLocInfo          ,32   )
    MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxExtMBQP                   ,64   )
    MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxExtMBForceIntra           ,64   )
    MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxExtHEVCTiles              ,160  )
    MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxExtMBDisableSkipMap       ,64   )
    MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxExtHEVCParam              ,256  )
    MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxExtDecodeErrorReport      ,32   )
    MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxExtDecodedFrameInfo       ,128  )
    MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxExtTimeCode               ,32   )
    MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxExtHEVCRegion             ,64   )
    MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxExtPredWeightTable        ,1152 )
    MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxExtAVCRoundingOffset      ,64   )
    MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxExtDirtyRect              ,8224 )
    MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxExtMoveRect               ,8224 )
    MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxExtVPPRotation            ,32   )
    MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxExtEncodedSlicesInfo      ,64   )
    MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxExtVPPScaling             ,32   )
    MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxExtVPPMirroring           ,32   )
    MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxExtMVOverPicBoundaries    ,32   )
    MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxExtVPPColorFill           ,32   )
    MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxExtColorConversion        ,64   )
    MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxVP9SegmentParam           ,32   )
    MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxExtVP9Segmentation        ,384  )
    MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxVP9TemporalLayer          ,32   )
    MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxExtVP9TemporalLayers      ,384  )
    MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxExtVP9Param               ,256  )
    MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxEncodedUnitInfo           ,32  )
    MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxExtEncodedUnitsInfo       ,64  )
    MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxExtVppMctf                ,64  )
    MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxAV1FilmGrainPoint         ,2    )
    MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxExtAV1FilmGrainParam      ,256  )
    MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxComponentInfo             ,208 )
    MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxAdapterInfo               ,64  )
    MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxAdaptersInfo              ,20  )
    MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxExtPartialBitstreamParam  ,32  )

#ifdef ONEVPL_EXPERIMENTAL
    MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxMemoryInterface            , 76 )

    MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxSurfaceInterface           ,112 )
    MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxSurfaceHeader              , 44 )
    MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxSurfaceD3D11Tex2D          ,144 )
    MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxSurfaceD3D12Tex2D          ,144 )
    MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxSurfaceVAAPI               ,148 )
    MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxSurfaceOpenCLImg2D         ,172 )
    MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxSurfaceVulkanImg2D         ,172 )

    MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxSurfaceTypesSupported                      ,24 )
    MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxSurfaceTypesSupported::surftype            ,36 )
    MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxSurfaceTypesSupported::surftype::surfcomp  ,36 )

    MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxExtSurfaceOpenCLImg2DExportDescription,  48 )
    MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxExtSurfaceD3D12Tex2DExportDescription,  48 )
    MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxExtSurfaceVulkanImg2DExportDescription,  48 )
#endif
    MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxExtVPPAISuperResolution, 92)
    MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxExtVPPAIFrameInterpolation, 144)
#endif

//mfxvideo.h
#if defined(_x86_64)
    MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxFrameAllocator  ,64)
#elif defined(_x86)
    MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxFrameAllocator  ,40)
#endif

//mfxvp8.h
#if defined(_x86_64)
    MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxExtVP8CodingOption        ,516  )
#elif defined(_x86)
    MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxExtVP8CodingOption        ,516  )
#endif


//mfxbrc.h
#if defined(_x86_64)
    MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxBRCFrameParam             ,128  )
    MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxBRCFrameCtrl              ,64   )
    MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxBRCFrameStatus            ,64   )
    MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxExtBRC                    ,192  )
#elif defined(_x86)
    MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxBRCFrameParam             ,124  )
    MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxBRCFrameCtrl              ,60   )
    MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxBRCFrameStatus            ,60   )
    MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxExtBRC                    ,128  )
#endif

//mfxpcp.h
#if defined(_x86_64)
    MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxExtCencParam              ,72   )
#elif defined(_x86)
    MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxExtCencParam              ,72   )
#endif

// Offsets
//mfxcommon.h
#if defined(_x86_64)
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtBuffer                       ,BufferId                      ,0    )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtBuffer                       ,BufferSz                      ,4    )

    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxVersion                         ,Minor                         ,0    )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxVersion                         ,Major                         ,2    )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxVersion                         ,Version                       ,0    )

    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxBitstream                       ,EncryptedData                 ,0    )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxBitstream                       ,ExtParam                      ,8    )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxBitstream                       ,NumExtParam                   ,16   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxBitstream                       ,CodecId                       ,20   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxBitstream                       ,DecodeTimeStamp               ,24   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxBitstream                       ,TimeStamp                     ,32   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxBitstream                       ,Data                          ,40   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxBitstream                       ,DataOffset                    ,48   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxBitstream                       ,DataLength                    ,52   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxBitstream                       ,MaxLength                     ,56   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxBitstream                       ,PicStruct                     ,60   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxBitstream                       ,FrameType                     ,62   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxBitstream                       ,DataFlag                      ,64   )

    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxInitParam                       ,Implementation                ,0    )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxInitParam                       ,Version                       ,4    )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxInitParam                       ,ExternalThreads               ,8    )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxInitParam                       ,ExtParam                      ,16   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxInitParam                       ,NumExtParam                   ,24   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxInitParam                       ,GPUCopy                       ,32   )

    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtThreadsParam                 ,Header                        ,0    )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtThreadsParam                 ,NumThread                     ,8    )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtThreadsParam                 ,SchedulingType                ,12   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtThreadsParam                 ,Priority                      ,16   )

    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxPlatform                        ,CodeName                      ,0    )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxPlatform                        ,DeviceId                      ,2    )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxPlatform                        ,MediaAdapterType              ,4    )
#elif defined(_x86)
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtBuffer                       ,BufferId                      ,0    )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtBuffer                       ,BufferSz                      ,4    )

    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxVersion                         ,Minor                         ,0    )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxVersion                         ,Major                         ,2    )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxVersion                         ,Version                       ,0    )

    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxBitstream                       ,EncryptedData                 ,0    )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxBitstream                       ,ExtParam                      ,4    )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxBitstream                       ,NumExtParam                   ,8    )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxBitstream                       ,CodecId                       ,12   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxBitstream                       ,DecodeTimeStamp               ,24   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxBitstream                       ,TimeStamp                     ,32   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxBitstream                       ,Data                          ,40   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxBitstream                       ,DataOffset                    ,44   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxBitstream                       ,DataLength                    ,48   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxBitstream                       ,MaxLength                     ,52   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxBitstream                       ,PicStruct                     ,56   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxBitstream                       ,FrameType                     ,58   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxBitstream                       ,DataFlag                      ,60   )

    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxInitParam                       ,Implementation                ,0    )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxInitParam                       ,Version                       ,4    )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxInitParam                       ,ExternalThreads               ,8    )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxInitParam                       ,ExtParam                      ,12   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxInitParam                       ,NumExtParam                   ,16   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxInitParam                       ,GPUCopy                       ,24   )

    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtThreadsParam                 ,Header                        ,0    )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtThreadsParam                 ,NumThread                     ,8    )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtThreadsParam                 ,SchedulingType                ,12   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtThreadsParam                 ,Priority                      ,16   )

    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxPlatform                        ,CodeName                      ,0    )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxPlatform                        ,DeviceId                      ,2    )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxPlatform                        ,MediaAdapterType              ,4    )
#endif

//mfxdefs.h
#if defined(_x86_64)
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxI16Pair                         ,x                             ,0    )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxI16Pair                         ,y                             ,2    )

    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxHDLPair                         ,first                         ,0    )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxHDLPair                         ,second                        ,8    )

    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxGUID                            ,Data                          ,0    )
#elif defined(_x86)
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxI16Pair                         ,x                             ,0    )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxI16Pair                         ,y                             ,2    )

    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxHDLPair                         ,first                         ,0    )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxHDLPair                         ,second                        ,4    )
        
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxGUID                            ,Data                         ,0    )
#endif
    MSDK_STATIC_COMPARE(MFX_DATA_TYPE_UNSET                             , 0)
    MSDK_STATIC_COMPARE(MFX_DATA_TYPE_U8                                , 1)
    MSDK_STATIC_COMPARE(MFX_DATA_TYPE_I8                                , 2)
    MSDK_STATIC_COMPARE(MFX_DATA_TYPE_U16                               , 3)
    MSDK_STATIC_COMPARE(MFX_DATA_TYPE_I16                               , 4)
    MSDK_STATIC_COMPARE(MFX_DATA_TYPE_U32                               , 5)
    MSDK_STATIC_COMPARE(MFX_DATA_TYPE_I32                               , 6)
    MSDK_STATIC_COMPARE(MFX_DATA_TYPE_U64                               , 7)
    MSDK_STATIC_COMPARE(MFX_DATA_TYPE_I64                               , 8)
    MSDK_STATIC_COMPARE(MFX_DATA_TYPE_F32                               , 9)
    MSDK_STATIC_COMPARE(MFX_DATA_TYPE_F64                               , 10)
    MSDK_STATIC_COMPARE(MFX_DATA_TYPE_PTR                               , 11)
#ifdef ONEVPL_EXPERIMENTAL
    MSDK_STATIC_COMPARE(MFX_DATA_TYPE_FP16                              , 12)
#endif
    MSDK_STATIC_COMPARE(MFX_VARIANT_TYPE_UNSET                          , 0)
    MSDK_STATIC_COMPARE(MFX_VARIANT_TYPE_U8                             , 1)
    MSDK_STATIC_COMPARE(MFX_VARIANT_TYPE_I8                             , 2)
    MSDK_STATIC_COMPARE(MFX_VARIANT_TYPE_U16                            , 3)
    MSDK_STATIC_COMPARE(MFX_VARIANT_TYPE_I16                            , 4)
    MSDK_STATIC_COMPARE(MFX_VARIANT_TYPE_U32                            , 5)
    MSDK_STATIC_COMPARE(MFX_VARIANT_TYPE_I32                            , 6)
    MSDK_STATIC_COMPARE(MFX_VARIANT_TYPE_U64                            , 7)
    MSDK_STATIC_COMPARE(MFX_VARIANT_TYPE_I64                            , 8)
    MSDK_STATIC_COMPARE(MFX_VARIANT_TYPE_F32                            , 9)
    MSDK_STATIC_COMPARE(MFX_VARIANT_TYPE_F64                            , 10)
    MSDK_STATIC_COMPARE(MFX_VARIANT_TYPE_PTR                            , 11)
#ifdef ONEVPL_EXPERIMENTAL
    MSDK_STATIC_COMPARE(MFX_VARIANT_TYPE_FP16                           , 12)
#endif

//mfxstructures.h
#if defined(_x86_64)
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxFrameId                         ,TemporalId                    ,0    )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxFrameId                         ,PriorityId                    ,2    )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxFrameId                         ,DependencyId                  ,4    )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxFrameId                         ,QualityId                     ,6    )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxFrameId                         ,ViewId                        ,4    )

    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxFrameInfo                       ,BitDepthLuma                  ,18   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxFrameInfo                       ,BitDepthChroma                ,20   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxFrameInfo                       ,Shift                         ,22   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxFrameInfo                       ,FrameId                       ,24   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxFrameInfo                       ,FourCC                        ,32   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxFrameInfo                       ,Width                         ,36   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxFrameInfo                       ,Height                        ,38   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxFrameInfo                       ,CropX                         ,40   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxFrameInfo                       ,CropY                         ,42   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxFrameInfo                       ,CropW                         ,44   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxFrameInfo                       ,CropH                         ,46   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxFrameInfo                       ,BufferSize                    ,36   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxFrameInfo                       ,FrameRateExtN                 ,48   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxFrameInfo                       ,FrameRateExtD                 ,52   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxFrameInfo                       ,AspectRatioW                  ,58   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxFrameInfo                       ,AspectRatioH                  ,60   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxFrameInfo                       ,PicStruct                     ,62   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxFrameInfo                       ,ChromaFormat                  ,64   )

    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxFrameData                       ,ExtParam                      ,0    )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxFrameData                       ,NumExtParam                   ,8    )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxFrameData                       ,MemType                       ,28   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxFrameData                       ,PitchHigh                     ,30   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxFrameData                       ,TimeStamp                     ,32   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxFrameData                       ,FrameOrder                    ,40   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxFrameData                       ,Locked                        ,44   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxFrameData                       ,Pitch                         ,46   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxFrameData                       ,PitchLow                      ,46   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxFrameData                       ,Y                             ,48   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxFrameData                       ,Y16                           ,48   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxFrameData                       ,R                             ,48   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxFrameData                       ,UV                            ,56   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxFrameData                       ,VU                            ,56   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxFrameData                       ,CbCr                          ,56   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxFrameData                       ,CrCb                          ,56   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxFrameData                       ,Cb                            ,56   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxFrameData                       ,U                             ,56   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxFrameData                       ,U16                           ,56   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxFrameData                       ,G                             ,56   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxFrameData                       ,Y410                          ,56   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxFrameData                       ,Y416                          ,56   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxFrameData                       ,Cr                            ,64   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxFrameData                       ,V                             ,64   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxFrameData                       ,V16                           ,64   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxFrameData                       ,B                             ,64   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxFrameData                       ,A2RGB10                       ,64   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxFrameData                       ,A                             ,72   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxFrameData                       ,MemId                         ,80   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxFrameData                       ,Corrupted                     ,88   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxFrameData                       ,DataFlag                      ,90   )

    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxFrameSurface1                   ,Info                          ,16   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxFrameSurface1                   ,Data                          ,88   )

    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxInfoMFX                         ,LowPower                      ,28   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxInfoMFX                         ,BRCParamMultiplier            ,30   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxInfoMFX                         ,FrameInfo                     ,32   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxInfoMFX                         ,CodecId                       ,100  )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxInfoMFX                         ,CodecProfile                  ,104  )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxInfoMFX                         ,CodecLevel                    ,106  )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxInfoMFX                         ,NumThread                     ,108  )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxInfoMFX                         ,TargetUsage                   ,110  )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxInfoMFX                         ,GopPicSize                    ,112  )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxInfoMFX                         ,GopRefDist                    ,114  )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxInfoMFX                         ,GopOptFlag                    ,116  )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxInfoMFX                         ,IdrInterval                   ,118  )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxInfoMFX                         ,RateControlMethod             ,120  )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxInfoMFX                         ,InitialDelayInKB              ,122  )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxInfoMFX                         ,QPI                           ,122  )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxInfoMFX                         ,Accuracy                      ,122  )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxInfoMFX                         ,BufferSizeInKB                ,124  )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxInfoMFX                         ,TargetKbps                    ,126  )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxInfoMFX                         ,QPP                           ,126  )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxInfoMFX                         ,ICQQuality                    ,126  )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxInfoMFX                         ,MaxKbps                       ,128  )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxInfoMFX                         ,QPB                           ,128  )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxInfoMFX                         ,Convergence                   ,128  )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxInfoMFX                         ,NumSlice                      ,130  )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxInfoMFX                         ,NumRefFrame                   ,132  )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxInfoMFX                         ,EncodedOrder                  ,134  )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxInfoMFX                         ,DecodedOrder                  ,110  )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxInfoMFX                         ,ExtendedPicStruct             ,112  )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxInfoMFX                         ,TimeStampCalc                 ,114  )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxInfoMFX                         ,SliceGroupsPresent            ,116  )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxInfoMFX                         ,MaxDecFrameBuffering          ,118  )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxInfoMFX                         ,EnableReallocRequest          ,120  )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxInfoMFX                         ,FilmGrain                     ,122  )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxInfoMFX                         ,IgnoreLevelConstrain          ,124  )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxInfoMFX                         ,JPEGChromaFormat              ,110  )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxInfoMFX                         ,Rotation                      ,112  )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxInfoMFX                         ,JPEGColorFormat               ,114  )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxInfoMFX                         ,InterleavedDec                ,116  )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxInfoMFX                         ,SamplingFactorH               ,118  )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxInfoMFX                         ,SamplingFactorV               ,122  )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxInfoMFX                         ,Interleaved                   ,110  )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxInfoMFX                         ,Quality                       ,112  )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxInfoMFX                         ,RestartInterval               ,114  )

    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxInfoVPP                         ,In                            ,32   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxInfoVPP                         ,Out                           ,100  )

    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxVideoParam                      ,AllocId                       ,0    )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxVideoParam                      ,AsyncDepth                    ,14   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxVideoParam                      ,mfx                           ,16   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxVideoParam                      ,vpp                           ,16   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxVideoParam                      ,Protected                     ,184  )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxVideoParam                      ,IOPattern                     ,186  )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxVideoParam                      ,ExtParam                      ,192  )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxVideoParam                      ,NumExtParam                   ,200  )

    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtCodingOption                 ,Header                        ,0    )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtCodingOption                 ,RateDistortionOpt             ,10   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtCodingOption                 ,MECostType                    ,12   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtCodingOption                 ,MESearchType                  ,14   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtCodingOption                 ,MVSearchWindow                ,16   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtCodingOption                 ,EndOfSequence                 ,20   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtCodingOption                 ,FramePicture                  ,22   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtCodingOption                 ,CAVLC                         ,24   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtCodingOption                 ,RecoveryPointSEI              ,30   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtCodingOption                 ,ViewOutput                    ,32   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtCodingOption                 ,NalHrdConformance             ,34   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtCodingOption                 ,SingleSeiNalUnit              ,36   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtCodingOption                 ,VuiVclHrdParameters           ,38   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtCodingOption                 ,RefPicListReordering          ,40   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtCodingOption                 ,ResetRefList                  ,42   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtCodingOption                 ,RefPicMarkRep                 ,44   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtCodingOption                 ,FieldOutput                   ,46   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtCodingOption                 ,IntraPredBlockSize            ,48   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtCodingOption                 ,InterPredBlockSize            ,50   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtCodingOption                 ,MVPrecision                   ,52   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtCodingOption                 ,MaxDecFrameBuffering          ,54   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtCodingOption                 ,AUDelimiter                   ,56   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtCodingOption                 ,EndOfStream                   ,58   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtCodingOption                 ,PicTimingSEI                  ,60   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtCodingOption                 ,VuiNalHrdParameters           ,62   )

    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtCodingOption2                ,Header                        ,0    )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtCodingOption2                ,IntRefType                    ,8    )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtCodingOption2                ,IntRefCycleSize               ,10   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtCodingOption2                ,IntRefQPDelta                 ,12   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtCodingOption2                ,MaxFrameSize                  ,16   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtCodingOption2                ,MaxSliceSize                  ,20   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtCodingOption2                ,BitrateLimit                  ,24   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtCodingOption2                ,MBBRC                         ,26   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtCodingOption2                ,ExtBRC                        ,28   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtCodingOption2                ,LookAheadDepth                ,30   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtCodingOption2                ,Trellis                       ,32   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtCodingOption2                ,RepeatPPS                     ,34   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtCodingOption2                ,BRefType                      ,36   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtCodingOption2                ,AdaptiveI                     ,38   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtCodingOption2                ,AdaptiveB                     ,40   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtCodingOption2                ,LookAheadDS                   ,42   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtCodingOption2                ,NumMbPerSlice                 ,44   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtCodingOption2                ,SkipFrame                     ,46   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtCodingOption2                ,MinQPI                        ,48   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtCodingOption2                ,MaxQPI                        ,49   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtCodingOption2                ,MinQPP                        ,50   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtCodingOption2                ,MaxQPP                        ,51   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtCodingOption2                ,MinQPB                        ,52   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtCodingOption2                ,MaxQPB                        ,53   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtCodingOption2                ,FixedFrameRate                ,54   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtCodingOption2                ,DisableDeblockingIdc          ,56   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtCodingOption2                ,DisableVUI                    ,58   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtCodingOption2                ,BufferingPeriodSEI            ,60   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtCodingOption2                ,EnableMAD                     ,62   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtCodingOption2                ,UseRawRef                     ,64   )

    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtCodingOption3                ,Header                        ,0    )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtCodingOption3                ,NumSliceI                     ,8    )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtCodingOption3                ,NumSliceP                     ,10   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtCodingOption3                ,NumSliceB                     ,12   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtCodingOption3                ,WinBRCMaxAvgKbps              ,14   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtCodingOption3                ,WinBRCSize                    ,16   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtCodingOption3                ,QVBRQuality                   ,18   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtCodingOption3                ,EnableMBQP                    ,20   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtCodingOption3                ,IntRefCycleDist               ,22   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtCodingOption3                ,DirectBiasAdjustment          ,24   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtCodingOption3                ,GlobalMotionBiasAdjustment    ,26   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtCodingOption3                ,MVCostScalingFactor           ,28   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtCodingOption3                ,MBDisableSkipMap              ,30   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtCodingOption3                ,WeightedPred                  ,32   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtCodingOption3                ,WeightedBiPred                ,34   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtCodingOption3                ,AspectRatioInfoPresent        ,36   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtCodingOption3                ,OverscanInfoPresent           ,38   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtCodingOption3                ,OverscanAppropriate           ,40   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtCodingOption3                ,TimingInfoPresent             ,42   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtCodingOption3                ,BitstreamRestriction          ,44   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtCodingOption3                ,LowDelayHrd                   ,46   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtCodingOption3                ,MotionVectorsOverPicBoundaries,48   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtCodingOption3                ,ScenarioInfo                  ,54   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtCodingOption3                ,ContentInfo                   ,56   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtCodingOption3                ,PRefType                      ,58   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtCodingOption3                ,FadeDetection                 ,60   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtCodingOption3                ,GPB                           ,66   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtCodingOption3                ,MaxFrameSizeI                 ,68   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtCodingOption3                ,MaxFrameSizeP                 ,72   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtCodingOption3                ,EnableQPOffset                ,88   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtCodingOption3                ,QPOffset                      ,90   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtCodingOption3                ,NumRefActiveP                 ,106  )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtCodingOption3                ,NumRefActiveBL0               ,122  )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtCodingOption3                ,NumRefActiveBL1               ,138  )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtCodingOption3                ,TransformSkip                 ,156  )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtCodingOption3                ,BRCPanicMode                  ,164  )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtCodingOption3                ,LowDelayBRC                   ,166  )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtCodingOption3                ,EnableMBForceIntra            ,168  )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtCodingOption3                ,AdaptiveMaxFrameSize          ,170  )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtCodingOption3                ,RepartitionCheckEnable        ,172  )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtCodingOption3                ,EncodedUnitsInfo              ,180  )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtCodingOption3                ,EnableNalUnitType             ,182  )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtCodingOption3                ,ExtBrcAdaptiveLTR             ,184  )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtCodingOption3                ,AdaptiveLTR                   ,184  )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtCodingOption3                ,AdaptiveCQM                   ,186  )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtCodingOption3                ,AdaptiveRef                   ,188  )

    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtVPPDoNotUse                  ,Header                        ,0    )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtVPPDoNotUse                  ,NumAlg                        ,8    )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtVPPDoNotUse                  ,AlgList                       ,16   )

    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtVPPDenoise                   ,Header                        ,0    )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtVPPDenoise                   ,DenoiseFactor                 ,8    )

    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtVPPDenoise2                  ,Header                        ,0    )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtVPPDenoise2                  ,Mode                          ,8    )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtVPPDenoise2                  ,Strength                      ,12   )

    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxChannel                         ,DataType                      ,0    )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxChannel                         ,Size                          ,4    )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxChannel                         ,Data                          ,8    )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxChannel                         ,Data16                        ,8    )

    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfx3DLutSystemBuffer               ,Channel                       ,0    )

    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfx3DLutVideoBuffer                ,DataType                      ,0    )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfx3DLutVideoBuffer                ,MemLayout                     ,4    )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfx3DLutVideoBuffer                ,MemId                         ,8    )

    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtVPP3DLut                     ,Header                        ,0    )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtVPP3DLut                     ,ChannelMapping                ,8    )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtVPP3DLut                     ,BufferType                    ,12    )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtVPP3DLut                     ,SystemBuffer                  ,16   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtVPP3DLut                     ,VideoBuffer                   ,16   )
#ifdef ONEVPL_EXPERIMENTAL
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtVPP3DLut                     ,InterpolationMethod           ,144  )
#endif

    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtVPPDetail                    ,Header                        ,0    )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtVPPDetail                    ,DetailFactor                  ,8    )

    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtVPPProcAmp                   ,Header                        ,0    )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtVPPProcAmp                   ,Brightness                    ,8    )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtVPPProcAmp                   ,Contrast                      ,16   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtVPPProcAmp                   ,Hue                           ,24   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtVPPProcAmp                   ,Saturation                    ,32   )

    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxEncodeStat                      ,NumFrame                      ,64   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxEncodeStat                      ,NumBit                        ,72   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxEncodeStat                      ,NumCachedFrame                ,80   )

    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxDecodeStat                      ,NumFrame                      ,64   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxDecodeStat                      ,NumSkippedFrame               ,68   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxDecodeStat                      ,NumError                      ,72   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxDecodeStat                      ,NumCachedFrame                ,76   )

    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxVPPStat                         ,NumFrame                      ,64   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxVPPStat                         ,NumCachedFrame                ,68   )

    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtVppAuxData                   ,Header                        ,0    )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtVppAuxData                   ,SpatialComplexity             ,8    )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtVppAuxData                   ,TemporalComplexity            ,12   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtVppAuxData                   ,PicStruct                     ,8    )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtVppAuxData                   ,SceneChangeRate               ,16   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtVppAuxData                   ,RepeatedFrame                 ,18   )

    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxPayload                         ,CtrlFlags                     ,0    )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxPayload                         ,Data                          ,16   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxPayload                         ,NumBit                        ,24   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxPayload                         ,Type                          ,28   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxPayload                         ,BufSize                       ,30   )

    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxEncodeCtrl                      ,Header                        ,0    )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxEncodeCtrl                      ,MfxNalUnitType                ,26   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxEncodeCtrl                      ,SkipFrame                     ,28   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxEncodeCtrl                      ,QP                            ,30   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxEncodeCtrl                      ,FrameType                     ,32   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxEncodeCtrl                      ,NumExtParam                   ,34   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxEncodeCtrl                      ,NumPayload                    ,36   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxEncodeCtrl                      ,ExtParam                      ,40   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxEncodeCtrl                      ,Payload                       ,48   )

    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxFrameAllocRequest               ,AllocId                       ,0    )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxFrameAllocRequest               ,Info                          ,16   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxFrameAllocRequest               ,Type                          ,84   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxFrameAllocRequest               ,NumFrameMin                   ,86   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxFrameAllocRequest               ,NumFrameSuggested             ,88   )

    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxFrameAllocResponse              ,AllocId                       ,0    )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxFrameAllocResponse              ,mids                          ,16   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxFrameAllocResponse              ,NumFrameActual                ,24   )

    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtCodingOptionSPSPPS           ,Header                        ,0    )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtCodingOptionSPSPPS           ,SPSBuffer                     ,8    )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtCodingOptionSPSPPS           ,PPSBuffer                     ,16   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtCodingOptionSPSPPS           ,SPSBufSize                    ,24   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtCodingOptionSPSPPS           ,PPSBufSize                    ,26   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtCodingOptionSPSPPS           ,SPSId                         ,28   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtCodingOptionSPSPPS           ,PPSId                         ,30   )

    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtCodingOptionVPS              ,Header                        ,0    )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtCodingOptionVPS              ,VPSBuffer                     ,8    )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtCodingOptionVPS              ,VPSBufSize                    ,16   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtCodingOptionVPS              ,VPSId                         ,18   )

    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtVideoSignalInfo              ,Header                        ,0    )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtVideoSignalInfo              ,VideoFormat                   ,8    )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtVideoSignalInfo              ,VideoFullRange                ,10   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtVideoSignalInfo              ,ColourDescriptionPresent      ,12   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtVideoSignalInfo              ,ColourPrimaries               ,14   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtVideoSignalInfo              ,TransferCharacteristics       ,16   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtVideoSignalInfo              ,MatrixCoefficients            ,18   )

    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtVPPDoUse                     ,Header                        ,0    )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtVPPDoUse                     ,NumAlg                        ,8    )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtVPPDoUse                     ,AlgList                       ,16   )

    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtAVCRefListCtrl               ,Header                         ,0    )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtAVCRefListCtrl               ,NumRefIdxL0Active              ,8    )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtAVCRefListCtrl               ,NumRefIdxL1Active              ,10   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtAVCRefListCtrl               ,PreferredRefList               ,12   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtAVCRefListCtrl               ,PreferredRefList[0].FrameOrder ,12   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtAVCRefListCtrl               ,PreferredRefList[0].PicStruct  ,16   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtAVCRefListCtrl               ,PreferredRefList[0].ViewId     ,18   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtAVCRefListCtrl               ,PreferredRefList[0].LongTermIdx,20   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtAVCRefListCtrl               ,RejectedRefList                ,524  )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtAVCRefListCtrl               ,RejectedRefList[0].FrameOrder  ,524  )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtAVCRefListCtrl               ,RejectedRefList[0].PicStruct   ,528  )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtAVCRefListCtrl               ,RejectedRefList[0].ViewId      ,530  )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtAVCRefListCtrl               ,RejectedRefList[0].LongTermIdx ,532  )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtAVCRefListCtrl               ,LongTermRefList                ,780  )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtAVCRefListCtrl               ,LongTermRefList[0].FrameOrder  ,780  )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtAVCRefListCtrl               ,LongTermRefList[0].PicStruct   ,784  )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtAVCRefListCtrl               ,LongTermRefList[0].ViewId      ,786  )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtAVCRefListCtrl               ,LongTermRefList[0].LongTermIdx ,788  )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtAVCRefListCtrl               ,ApplyLongTermIdx               ,1036 )

    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtVPPFrameRateConversion       ,Header                        ,0    )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtVPPFrameRateConversion       ,Algorithm                     ,8    )

    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtVPPImageStab                 ,Header                        ,0    )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtVPPImageStab                 ,Mode                          ,8    )

    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtMasteringDisplayColourVolume ,Header                       ,0    )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtMasteringDisplayColourVolume ,InsertPayloadToggle          ,38   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtMasteringDisplayColourVolume ,DisplayPrimariesX            ,40   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtMasteringDisplayColourVolume ,DisplayPrimariesY            ,46   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtMasteringDisplayColourVolume ,WhitePointX                  ,52   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtMasteringDisplayColourVolume ,WhitePointY                  ,54   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtMasteringDisplayColourVolume ,MaxDisplayMasteringLuminance ,56   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtMasteringDisplayColourVolume ,MinDisplayMasteringLuminance ,60   )

    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtContentLightLevelInfo        ,Header                       ,0    )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtContentLightLevelInfo        ,InsertPayloadToggle          ,26   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtContentLightLevelInfo        ,MaxContentLightLevel         ,28   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtContentLightLevelInfo        ,MaxPicAverageLightLevel      ,30   )

    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtPictureTimingSEI             ,Header                          ,0    )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtPictureTimingSEI             ,TimeStamp                       ,64   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtPictureTimingSEI             ,TimeStamp[0].ClockTimestampFlag ,64   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtPictureTimingSEI             ,TimeStamp[0].CtType             ,66   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtPictureTimingSEI             ,TimeStamp[0].NuitFieldBasedFlag ,68   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtPictureTimingSEI             ,TimeStamp[0].CountingType       ,70   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtPictureTimingSEI             ,TimeStamp[0].FullTimestampFlag  ,72   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtPictureTimingSEI             ,TimeStamp[0].DiscontinuityFlag  ,74   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtPictureTimingSEI             ,TimeStamp[0].CntDroppedFlag     ,76   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtPictureTimingSEI             ,TimeStamp[0].NFrames            ,78   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtPictureTimingSEI             ,TimeStamp[0].SecondsFlag        ,80   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtPictureTimingSEI             ,TimeStamp[0].MinutesFlag        ,82   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtPictureTimingSEI             ,TimeStamp[0].HoursFlag          ,84   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtPictureTimingSEI             ,TimeStamp[0].SecondsValue       ,86   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtPictureTimingSEI             ,TimeStamp[0].MinutesValue       ,88   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtPictureTimingSEI             ,TimeStamp[0].HoursValue         ,90   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtPictureTimingSEI             ,TimeStamp[0].TimeOffset         ,92   )

    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtAvcTemporalLayers            ,Header                        ,0    )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtAvcTemporalLayers            ,BaseLayerPID                  ,26   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtAvcTemporalLayers            ,Layer                         ,28   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtAvcTemporalLayers            ,Layer[0].Scale                ,28   )

    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtEncoderCapability            ,Header                        ,0    )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtEncoderCapability            ,MBPerSec                      ,8    )

    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtEncoderResetOption           ,Header                        ,0    )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtEncoderResetOption           ,StartNewSequence              ,8    )

    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtAVCEncodedFrameInfo          ,Header                        ,0    )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtAVCEncodedFrameInfo          ,FrameOrder                    ,8    )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtAVCEncodedFrameInfo          ,PicStruct                     ,12   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtAVCEncodedFrameInfo          ,LongTermIdx                   ,14   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtAVCEncodedFrameInfo          ,MAD                           ,16   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtAVCEncodedFrameInfo          ,BRCPanicMode                  ,20   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtAVCEncodedFrameInfo          ,QP                            ,22   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtAVCEncodedFrameInfo          ,SecondFieldOffset             ,24   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtAVCEncodedFrameInfo          ,UsedRefListL0                 ,32   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtAVCEncodedFrameInfo          ,UsedRefListL0[0].FrameOrder   ,32   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtAVCEncodedFrameInfo          ,UsedRefListL0[0].PicStruct    ,36   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtAVCEncodedFrameInfo          ,UsedRefListL0[0].LongTermIdx  ,38   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtAVCEncodedFrameInfo          ,UsedRefListL1                 ,544  )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtAVCEncodedFrameInfo          ,UsedRefListL1[0].FrameOrder   ,544  )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtAVCEncodedFrameInfo          ,UsedRefListL1[0].PicStruct    ,548  )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtAVCEncodedFrameInfo          ,UsedRefListL1[0].LongTermIdx  ,550  )

    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxVPPCompInputStream              ,DstX                          ,0    )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxVPPCompInputStream              ,DstY                          ,4    )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxVPPCompInputStream              ,DstW                          ,8    )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxVPPCompInputStream              ,DstH                          ,12   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxVPPCompInputStream              ,LumaKeyEnable                 ,16   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxVPPCompInputStream              ,LumaKeyMin                    ,18   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxVPPCompInputStream              ,LumaKeyMax                    ,20   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxVPPCompInputStream              ,GlobalAlphaEnable             ,22   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxVPPCompInputStream              ,GlobalAlpha                   ,24   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxVPPCompInputStream              ,PixelAlphaEnable              ,26   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxVPPCompInputStream              ,TileId                        ,28   )

    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtVPPComposite                 ,Header                        ,0    )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtVPPComposite                 ,Y                             ,8    )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtVPPComposite                 ,U                             ,10   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtVPPComposite                 ,V                             ,12   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtVPPComposite                 ,R                             ,8    )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtVPPComposite                 ,G                             ,10   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtVPPComposite                 ,B                             ,12   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtVPPComposite                 ,NumTiles                      ,14   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtVPPComposite                 ,NumInputStream                ,62   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtVPPComposite                 ,InputStream                   ,64   )

    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtVPPVideoSignalInfo           ,Header                        ,0    )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtVPPVideoSignalInfo           ,In                            ,16   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtVPPVideoSignalInfo           ,In.TransferMatrix             ,16   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtVPPVideoSignalInfo           ,In.NominalRange               ,18   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtVPPVideoSignalInfo           ,Out                           ,32   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtVPPVideoSignalInfo           ,Out.TransferMatrix            ,32   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtVPPVideoSignalInfo           ,Out.NominalRange              ,34   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtVPPVideoSignalInfo           ,TransferMatrix                ,16   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtVPPVideoSignalInfo           ,NominalRange                  ,18   )

    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtEncoderROI                   ,Header                        ,0    )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtEncoderROI                   ,NumROI                        ,8    )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtEncoderROI                   ,ROIMode                       ,10   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtEncoderROI                   ,ROI                           ,32   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtEncoderROI                   ,ROI[0].Left                   ,32   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtEncoderROI                   ,ROI[0].Top                    ,36   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtEncoderROI                   ,ROI[0].Right                  ,40   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtEncoderROI                   ,ROI[0].Bottom                 ,44   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtEncoderROI                   ,ROI[0].Priority               ,48   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtEncoderROI                   ,ROI[0].DeltaQP                ,48   )

    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtVPPDeinterlacing             ,Header                        ,0    )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtVPPDeinterlacing             ,Mode                          ,8    )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtVPPDeinterlacing             ,TelecinePattern               ,10   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtVPPDeinterlacing             ,TelecineLocation              ,12   )

    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtAVCRefLists                  ,Header                        ,0    )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtAVCRefLists                  ,NumRefIdxL0Active             ,8    )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtAVCRefLists                  ,NumRefIdxL1Active             ,10   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtAVCRefLists                  ,RefPicList0                   ,16   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtAVCRefLists                  ,RefPicList0[0].FrameOrder     ,16   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtAVCRefLists                  ,RefPicList0[0].PicStruct      ,20   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtAVCRefLists                  ,RefPicList1                   ,528  )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtAVCRefLists                  ,RefPicList1[0].FrameOrder     ,528  )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtAVCRefLists                  ,RefPicList1[0].PicStruct      ,532  )

    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtVPPFieldProcessing           ,Header                        ,0    )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtVPPFieldProcessing           ,Mode                          ,8    )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtVPPFieldProcessing           ,InField                       ,10   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtVPPFieldProcessing           ,OutField                      ,12   )

    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtDecVideoProcessing           ,Header                        ,0    )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtDecVideoProcessing           ,In.CropX                      ,8    )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtDecVideoProcessing           ,In.CropY                      ,10   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtDecVideoProcessing           ,In.CropW                      ,12   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtDecVideoProcessing           ,In.CropH                      ,14   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtDecVideoProcessing           ,Out.FourCC                    ,40   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtDecVideoProcessing           ,Out.ChromaFormat              ,44   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtDecVideoProcessing           ,Out.Width                     ,48   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtDecVideoProcessing           ,Out.Height                    ,50   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtDecVideoProcessing           ,Out.CropX                     ,52   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtDecVideoProcessing           ,Out.CropY                     ,54   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtDecVideoProcessing           ,Out.CropW                     ,56   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtDecVideoProcessing           ,Out.CropH                     ,58   )

    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtChromaLocInfo                ,Header                        ,0    )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtChromaLocInfo                ,ChromaLocInfoPresentFlag      ,8    )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtChromaLocInfo                ,ChromaSampleLocTypeTopField   ,10   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtChromaLocInfo                ,ChromaSampleLocTypeBottomField,12   )

    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtMBQP                         ,Header                        ,0    )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtMBQP                         ,Pitch                         ,44   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtMBQP                         ,Mode                          ,48   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtMBQP                         ,BlockSize                     ,50   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtMBQP                         ,NumQPAlloc                    ,52   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtMBQP                         ,QP                            ,56   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtMBQP                         ,DeltaQP                       ,56   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtMBQP                         ,QPmode                        ,56   )


    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxQPandMode                       ,QP                            ,0    )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxQPandMode                       ,DeltaQP                       ,0    )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxQPandMode                       ,Mode                          ,2    )

    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtInsertHeaders                ,Header                        ,0    )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtInsertHeaders                ,SPS                           ,8    )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtInsertHeaders                ,PPS                           ,10   )

    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtEncoderIPCMArea              ,Header                        ,0    )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtEncoderIPCMArea              ,NumArea                       ,28   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtEncoderIPCMArea              ,Areas                         ,32   )

    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtEncoderIPCMArea::area        ,Left                          ,0    )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtEncoderIPCMArea::area        ,Top                           ,4    )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtEncoderIPCMArea::area        ,Right                         ,8    )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtEncoderIPCMArea::area        ,Bottom                        ,12   )

    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtMBForceIntra                 ,Header                        ,0    )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtMBForceIntra                 ,MapSize                       ,52   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtMBForceIntra                 ,Map                           ,56   )

    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtHEVCTiles                    ,Header                        ,0    )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtHEVCTiles                    ,NumTileRows                   ,8    )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtHEVCTiles                    ,NumTileColumns                ,10   )

    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtMBDisableSkipMap             ,Header                        ,0    )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtMBDisableSkipMap             ,MapSize                       ,52   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtMBDisableSkipMap             ,Map                           ,56   )

    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtHEVCParam                    ,Header                        ,0    )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtHEVCParam                    ,PicWidthInLumaSamples         ,8    )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtHEVCParam                    ,PicHeightInLumaSamples        ,10   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtHEVCParam                    ,GeneralConstraintFlags        ,12   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtHEVCParam                    ,SampleAdaptiveOffset          ,20   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtHEVCParam                    ,LCUSize                       ,22   )

    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtDecodeErrorReport            ,Header                        ,0    )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtDecodeErrorReport            ,ErrorTypes                    ,8    )

    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtDecodedFrameInfo             ,Header                        ,0    )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtDecodedFrameInfo             ,FrameType                     ,8    )

    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtTimeCode                     ,Header                        ,0    )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtTimeCode                     ,DropFrameFlag                 ,8    )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtTimeCode                     ,TimeCodeHours                 ,10   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtTimeCode                     ,TimeCodeMinutes               ,12   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtTimeCode                     ,TimeCodeSeconds               ,14   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtTimeCode                     ,TimeCodePictures              ,16   )

    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtHEVCRegion                   ,Header                        ,0    )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtHEVCRegion                   ,RegionId                      ,8    )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtHEVCRegion                   ,RegionType                    ,12   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtHEVCRegion                   ,RegionEncoding                ,14   )

    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtPredWeightTable              ,Header                        ,0    )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtPredWeightTable              ,LumaLog2WeightDenom           ,8    )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtPredWeightTable              ,ChromaLog2WeightDenom         ,10   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtPredWeightTable              ,LumaWeightFlag                ,12   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtPredWeightTable              ,ChromaWeightFlag              ,140  )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtPredWeightTable              ,Weights                       ,268  )

    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtAVCRoundingOffset            ,Header                        ,0    )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtAVCRoundingOffset            ,EnableRoundingIntra           ,8    )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtAVCRoundingOffset            ,RoundingOffsetIntra           ,10   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtAVCRoundingOffset            ,EnableRoundingInter           ,12   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtAVCRoundingOffset            ,RoundingOffsetInter           ,14   )

    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtDirtyRect                    ,Header                        ,0    )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtDirtyRect                    ,NumRect                       ,8    )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtDirtyRect                    ,Rect                          ,32   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtDirtyRect                    ,Rect[0].Left                  ,32   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtDirtyRect                    ,Rect[0].Top                   ,36   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtDirtyRect                    ,Rect[0].Right                 ,40   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtDirtyRect                    ,Rect[0].Bottom                ,44   )

    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtMoveRect                     ,Header                        ,0    )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtMoveRect                     ,NumRect                       ,8    )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtMoveRect                     ,Rect                          ,32   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtMoveRect                     ,Rect[0].DestLeft              ,32   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtMoveRect                     ,Rect[0].DestTop               ,36   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtMoveRect                     ,Rect[0].DestRight             ,40   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtMoveRect                     ,Rect[0].DestBottom            ,44   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtMoveRect                     ,Rect[0].SourceLeft            ,48   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtMoveRect                     ,Rect[0].SourceTop             ,52   )

    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtVPPRotation                  ,Header                        ,0    )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtVPPRotation                  ,Angle                         ,8    )

    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtEncodedSlicesInfo            ,Header                        ,0    )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtEncodedSlicesInfo            ,SliceSizeOverflow             ,8    )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtEncodedSlicesInfo            ,NumSliceNonCopliant           ,10   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtEncodedSlicesInfo            ,NumEncodedSlice               ,12   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtEncodedSlicesInfo            ,NumSliceSizeAlloc             ,14   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtEncodedSlicesInfo            ,SliceSize                     ,16   )

    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtVPPScaling                   ,Header                        ,0    )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtVPPScaling                   ,ScalingMode                   ,8    )

    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtVPPMirroring                 ,Header                        ,0    )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtVPPMirroring                 ,Type                          ,8    )

    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtMVOverPicBoundaries          ,Header                        ,0    )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtMVOverPicBoundaries          ,StickTop                      ,8    )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtMVOverPicBoundaries          ,StickBottom                   ,10   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtMVOverPicBoundaries          ,StickLeft                     ,12   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtMVOverPicBoundaries          ,StickRight                    ,14   )

    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtVPPColorFill                 ,Header                        ,0    )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtVPPColorFill                 ,Enable                        ,8    )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtColorConversion              ,Header                        ,0    )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtColorConversion              ,ChromaSiting                  ,8    )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxVP9SegmentParam                 ,FeatureEnabled                ,0    )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxVP9SegmentParam                 ,QIndexDelta                   ,2    )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxVP9SegmentParam                 ,LoopFilterLevelDelta          ,4    )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxVP9SegmentParam                 ,ReferenceFrame                ,6    )

    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtVP9Segmentation              ,Header                        ,0    )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtVP9Segmentation              ,NumSegments                   ,8    )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtVP9Segmentation              ,Segment                       ,10   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtVP9Segmentation              ,SegmentIdBlockSize            ,266  )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtVP9Segmentation              ,NumSegmentIdAlloc             ,268  )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtVP9Segmentation              ,SegmentId                     ,272  )

    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxVP9TemporalLayer                ,FrameRateScale                ,0    )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxVP9TemporalLayer                ,TargetKbps                    ,2    )

    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtVP9TemporalLayers            ,Header                        ,0    )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtVP9TemporalLayers            ,Layer                         ,8    )

    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtVP9Param                     ,Header                        ,0    )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtVP9Param                     ,FrameWidth                    ,8    )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtVP9Param                     ,FrameHeight                   ,10   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtVP9Param                     ,WriteIVFHeaders               ,12   )

    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtVP9Param                     ,QIndexDeltaLumaDC             ,26   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtVP9Param                     ,QIndexDeltaChromaAC           ,28   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtVP9Param                     ,QIndexDeltaChromaDC           ,30   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtVP9Param                     ,NumTileRows                   ,32   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtVP9Param                     ,NumTileColumns                ,34   )

    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxEncodedUnitInfo                 ,Type                          ,0    )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxEncodedUnitInfo                 ,Offset                        ,4    )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxEncodedUnitInfo                 ,Size                          ,8    )

    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtEncodedUnitsInfo             ,Header                        ,0    )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtEncodedUnitsInfo             ,UnitInfo                      ,8    )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtEncodedUnitsInfo             ,NumUnitsAlloc                 ,16   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtEncodedUnitsInfo             ,NumUnitsEncoded               ,18   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtVppMctf                      ,Header                        ,0    )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtVppMctf                      ,FilterStrength                ,8    )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxAV1FilmGrainPoint               ,Value                         ,0    )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxAV1FilmGrainPoint               ,Scaling                       ,1    )

    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtAV1FilmGrainParam            ,Header                        ,0    )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtAV1FilmGrainParam            ,FilmGrainFlags                ,8    )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtAV1FilmGrainParam            ,GrainSeed                     ,10   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtAV1FilmGrainParam            ,RefIdx                        ,12   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtAV1FilmGrainParam            ,NumYPoints                    ,13   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtAV1FilmGrainParam            ,NumCbPoints                   ,14   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtAV1FilmGrainParam            ,NumCrPoints                   ,15   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtAV1FilmGrainParam            ,PointY                        ,16   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtAV1FilmGrainParam            ,PointCb                       ,44   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtAV1FilmGrainParam            ,PointCr                       ,64   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtAV1FilmGrainParam            ,GrainScalingMinus8            ,84   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtAV1FilmGrainParam            ,ArCoeffLag                    ,85   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtAV1FilmGrainParam            ,ArCoeffsYPlus128              ,86   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtAV1FilmGrainParam            ,ArCoeffsCbPlus128             ,110  )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtAV1FilmGrainParam            ,ArCoeffsCrPlus128             ,135  )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtAV1FilmGrainParam            ,ArCoeffShiftMinus6            ,160  )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtAV1FilmGrainParam            ,GrainScaleShift               ,161  )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtAV1FilmGrainParam            ,CbMult                        ,162  )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtAV1FilmGrainParam            ,CbLumaMult                    ,163  )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtAV1FilmGrainParam            ,CbOffset                      ,164  )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtAV1FilmGrainParam            ,CrMult                        ,166  )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtAV1FilmGrainParam            ,CrLumaMult                    ,167  )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtAV1FilmGrainParam            ,CrOffset                      ,168  )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxComponentInfo                   ,Type                          ,0    )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxComponentInfo                   ,Requirements                  ,8    )

    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxAdapterInfo                     ,Platform                      ,0    )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxAdapterInfo                     ,Number                        ,32   )

    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxAdaptersInfo                    ,Adapters                      ,0    )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxAdaptersInfo                    ,NumAlloc                      ,8    )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxAdaptersInfo                    ,NumActual                     ,12   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtPartialBitstreamParam        ,Header                          ,0  )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtPartialBitstreamParam        ,BlockSize                       ,8  )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtPartialBitstreamParam        ,Granularity                    ,12  )

#ifdef ONEVPL_EXPERIMENTAL
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxMemoryInterface              ,Context                        ,  0 )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxMemoryInterface              ,Version                        ,  8 )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxMemoryInterface              ,ImportFrameSurface             , 16 )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxMemoryInterface              ,reserved                       , 24 )

    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxSurfaceInterface             ,Header                         ,  0 )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxSurfaceInterface             ,Version                        , 48 )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxSurfaceInterface             ,Context                        , 56 )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxSurfaceInterface             ,AddRef                         , 64 )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxSurfaceInterface             ,Release                        , 72 )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxSurfaceInterface             ,GetRefCounter                  , 80 )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxSurfaceInterface             ,Synchronize                    , 88 )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxSurfaceInterface             ,reserved                       , 96 )

    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxSurfaceHeader                ,SurfaceType                    ,  0 )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxSurfaceHeader                ,SurfaceFlags                   ,  4 )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxSurfaceHeader                ,StructSize                     ,  8 )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxSurfaceHeader                ,NumExtParam                    , 12 )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxSurfaceHeader                ,ExtParam                       , 16 )

    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxSurfaceD3D11Tex2D            ,SurfaceInterface               ,  0 )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxSurfaceD3D11Tex2D            ,texture2D                      ,184 )

    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxSurfaceD3D12Tex2D            ,SurfaceInterface               ,  0 )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxSurfaceD3D12Tex2D            ,texture2D                      ,184 )

    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxSurfaceVAAPI                 ,SurfaceInterface               ,  0 )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxSurfaceVAAPI                 ,vaDisplay                      ,184 )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxSurfaceVAAPI                 ,vaSurfaceID                    ,192 )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxSurfaceVAAPI                 ,reserved1                      ,196 )

    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxSurfaceOpenCLImg2D           ,SurfaceInterface               ,  0 )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxSurfaceOpenCLImg2D           ,ocl_context                    ,184 )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxSurfaceOpenCLImg2D           ,ocl_command_queue              ,192 )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxSurfaceOpenCLImg2D           ,ocl_image                      ,200 )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxSurfaceOpenCLImg2D           ,ocl_image_num                  ,232 )

    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxSurfaceVulkanImg2D           ,SurfaceInterface               ,  0 )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxSurfaceVulkanImg2D           ,instance                       ,184 )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxSurfaceVulkanImg2D           ,physicalDevice                 ,192 )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxSurfaceVulkanImg2D           ,device                         ,200 )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxSurfaceVulkanImg2D           ,image2D                        ,208 )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxSurfaceVulkanImg2D           ,image2DMemory                  ,216 )

    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxSurfaceTypesSupported        ,Version                         ,0  )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxSurfaceTypesSupported        ,NumSurfaceTypes                 ,2  )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxSurfaceTypesSupported        ,SurfaceTypes                    ,8  )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxSurfaceTypesSupported        ,reserved                        ,16 )

    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxSurfaceTypesSupported::surftype    ,SurfaceType                  , 0 )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxSurfaceTypesSupported::surftype    ,reserved                     , 4 )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxSurfaceTypesSupported::surftype    ,NumSurfaceComponents         ,28 )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxSurfaceTypesSupported::surftype    ,SurfaceComponents            ,32 )
             
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxSurfaceTypesSupported::surftype::surfcomp    ,SurfaceComponent      , 0 )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxSurfaceTypesSupported::surftype::surfcomp    ,SurfaceFlags          , 4 )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxSurfaceTypesSupported::surftype::surfcomp    ,reserved              , 8 )

    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtSurfaceOpenCLImg2DExportDescription    ,Header            ,  0 )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtSurfaceOpenCLImg2DExportDescription    ,ocl_context       ,  8 )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtSurfaceOpenCLImg2DExportDescription    ,ocl_command_queue , 16 )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtSurfaceOpenCLImg2DExportDescription    ,reserved          , 24 )

    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtSurfaceD3D12Tex2DExportDescription    ,Header            ,  0 )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtSurfaceD3D12Tex2DExportDescription    ,d3d12Device       ,  8 )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtSurfaceD3D12Tex2DExportDescription    ,reserved          , 16 )

    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtSurfaceVulkanImg2DExportDescription    ,Header           ,  0 )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtSurfaceVulkanImg2DExportDescription    ,instance         ,  8 )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtSurfaceVulkanImg2DExportDescription    ,physicalDevice   , 16 )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtSurfaceVulkanImg2DExportDescription    ,device           , 24 )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtSurfaceVulkanImg2DExportDescription    ,reserved         , 32 )

#endif

    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtVPPAISuperResolution         ,Header                        ,0    )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtVPPAISuperResolution         ,SRMode                        ,8    )
#ifdef ONEVPL_EXPERIMENTAL
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtVPPAISuperResolution         ,SRAlgorithm                   ,12   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtVPPAISuperResolution         ,reserved1                     ,16   )
#else
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtVPPAISuperResolution         ,reserved1                     ,12   )
#endif
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtVPPAISuperResolution         ,reserved2                     ,80   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtVPPAIFrameInterpolation      ,Header                        ,0    )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtVPPAIFrameInterpolation      ,FIMode                        ,8    )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtVPPAIFrameInterpolation      ,EnableScd                     ,12   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtVPPAIFrameInterpolation      ,reserved1                     ,16   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtVPPAIFrameInterpolation      ,reserved2                     ,112  )

#elif defined(_x86)
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxFrameId                         ,TemporalId                    ,0    )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxFrameId                         ,PriorityId                    ,2    )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxFrameId                         ,DependencyId                  ,4    )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxFrameId                         ,QualityId                     ,6    )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxFrameId                         ,ViewId                        ,4    )

    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxFrameInfo                       ,BitDepthLuma                  ,18   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxFrameInfo                       ,BitDepthChroma                ,20   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxFrameInfo                       ,Shift                         ,22   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxFrameInfo                       ,FrameId                       ,24   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxFrameInfo                       ,FourCC                        ,32   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxFrameInfo                       ,Width                         ,36   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxFrameInfo                       ,Height                        ,38   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxFrameInfo                       ,CropX                         ,40   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxFrameInfo                       ,CropY                         ,42   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxFrameInfo                       ,CropW                         ,44   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxFrameInfo                       ,CropH                         ,46   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxFrameInfo                       ,BufferSize                    ,36   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxFrameInfo                       ,FrameRateExtN                 ,48   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxFrameInfo                       ,FrameRateExtD                 ,52   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxFrameInfo                       ,AspectRatioW                  ,58   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxFrameInfo                       ,AspectRatioH                  ,60   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxFrameInfo                       ,PicStruct                     ,62   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxFrameInfo                       ,ChromaFormat                  ,64   )

    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxFrameData                       ,ExtParam                      ,0    )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxFrameData                       ,NumExtParam                   ,8    )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxFrameData                       ,MemType                       ,28   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxFrameData                       ,PitchHigh                     ,30   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxFrameData                       ,TimeStamp                     ,32   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxFrameData                       ,FrameOrder                    ,40   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxFrameData                       ,Locked                        ,44   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxFrameData                       ,Pitch                         ,46   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxFrameData                       ,PitchLow                      ,46   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxFrameData                       ,Y                             ,48   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxFrameData                       ,Y16                           ,48   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxFrameData                       ,R                             ,48   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxFrameData                       ,UV                            ,52   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxFrameData                       ,VU                            ,52   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxFrameData                       ,CbCr                          ,52   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxFrameData                       ,CrCb                          ,52   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxFrameData                       ,Cb                            ,52   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxFrameData                       ,U                             ,52   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxFrameData                       ,U16                           ,52   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxFrameData                       ,G                             ,52   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxFrameData                       ,Y410                          ,52   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxFrameData                       ,Cr                            ,56   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxFrameData                       ,V                             ,56   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxFrameData                       ,V16                           ,56   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxFrameData                       ,B                             ,56   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxFrameData                       ,A2RGB10                       ,56   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxFrameData                       ,A                             ,60   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxFrameData                       ,MemId                         ,64   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxFrameData                       ,Corrupted                     ,68   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxFrameData                       ,DataFlag                      ,70   )

    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxFrameSurface1                   ,Info                          ,16   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxFrameSurface1                   ,Data                          ,88   )

    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxInfoMFX                         ,LowPower                      ,28   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxInfoMFX                         ,BRCParamMultiplier            ,30   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxInfoMFX                         ,FrameInfo                     ,32   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxInfoMFX                         ,CodecId                       ,100  )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxInfoMFX                         ,CodecProfile                  ,104  )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxInfoMFX                         ,CodecLevel                    ,106  )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxInfoMFX                         ,NumThread                     ,108  )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxInfoMFX                         ,TargetUsage                   ,110  )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxInfoMFX                         ,GopPicSize                    ,112  )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxInfoMFX                         ,GopRefDist                    ,114  )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxInfoMFX                         ,GopOptFlag                    ,116  )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxInfoMFX                         ,IdrInterval                   ,118  )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxInfoMFX                         ,RateControlMethod             ,120  )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxInfoMFX                         ,InitialDelayInKB              ,122  )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxInfoMFX                         ,QPI                           ,122  )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxInfoMFX                         ,Accuracy                      ,122  )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxInfoMFX                         ,BufferSizeInKB                ,124  )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxInfoMFX                         ,TargetKbps                    ,126  )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxInfoMFX                         ,QPP                           ,126  )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxInfoMFX                         ,ICQQuality                    ,126  )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxInfoMFX                         ,MaxKbps                       ,128  )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxInfoMFX                         ,QPB                           ,128  )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxInfoMFX                         ,Convergence                   ,128  )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxInfoMFX                         ,NumSlice                      ,130  )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxInfoMFX                         ,NumRefFrame                   ,132  )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxInfoMFX                         ,EncodedOrder                  ,134  )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxInfoMFX                         ,DecodedOrder                  ,110  )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxInfoMFX                         ,ExtendedPicStruct             ,112  )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxInfoMFX                         ,TimeStampCalc                 ,114  )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxInfoMFX                         ,SliceGroupsPresent            ,116  )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxInfoMFX                         ,MaxDecFrameBuffering          ,118  )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxInfoMFX                         ,EnableReallocRequest          ,120  )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxInfoMFX                         ,JPEGChromaFormat              ,110  )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxInfoMFX                         ,Rotation                      ,112  )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxInfoMFX                         ,JPEGColorFormat               ,114  )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxInfoMFX                         ,InterleavedDec                ,116  )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxInfoMFX                         ,SamplingFactorH               ,118  )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxInfoMFX                         ,SamplingFactorV               ,122  )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxInfoMFX                         ,Interleaved                   ,110  )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxInfoMFX                         ,Quality                       ,112  )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxInfoMFX                         ,RestartInterval               ,114  )

    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxInfoVPP                         ,In                            ,32   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxInfoVPP                         ,Out                           ,100  )

    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxVideoParam                      ,AllocId                       ,0    )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxVideoParam                      ,AsyncDepth                    ,14   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxVideoParam                      ,mfx                           ,16   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxVideoParam                      ,vpp                           ,16   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxVideoParam                      ,Protected                     ,184  )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxVideoParam                      ,IOPattern                     ,186  )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxVideoParam                      ,ExtParam                      ,188  )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxVideoParam                      ,NumExtParam                   ,192  )

    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtCodingOption                 ,Header                        ,0    )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtCodingOption                 ,RateDistortionOpt             ,10   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtCodingOption                 ,MECostType                    ,12   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtCodingOption                 ,MESearchType                  ,14   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtCodingOption                 ,MVSearchWindow                ,16   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtCodingOption                 ,EndOfSequence                 ,20   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtCodingOption                 ,FramePicture                  ,22   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtCodingOption                 ,CAVLC                         ,24   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtCodingOption                 ,RecoveryPointSEI              ,30   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtCodingOption                 ,ViewOutput                    ,32   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtCodingOption                 ,NalHrdConformance             ,34   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtCodingOption                 ,SingleSeiNalUnit              ,36   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtCodingOption                 ,VuiVclHrdParameters           ,38   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtCodingOption                 ,RefPicListReordering          ,40   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtCodingOption                 ,ResetRefList                  ,42   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtCodingOption                 ,RefPicMarkRep                 ,44   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtCodingOption                 ,FieldOutput                   ,46   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtCodingOption                 ,IntraPredBlockSize            ,48   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtCodingOption                 ,InterPredBlockSize            ,50   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtCodingOption                 ,MVPrecision                   ,52   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtCodingOption                 ,MaxDecFrameBuffering          ,54   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtCodingOption                 ,AUDelimiter                   ,56   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtCodingOption                 ,EndOfStream                   ,58   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtCodingOption                 ,PicTimingSEI                  ,60   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtCodingOption                 ,VuiNalHrdParameters           ,62   )

    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtCodingOption2                ,Header                        ,0    )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtCodingOption2                ,IntRefType                    ,8    )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtCodingOption2                ,IntRefCycleSize               ,10   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtCodingOption2                ,IntRefQPDelta                 ,12   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtCodingOption2                ,MaxFrameSize                  ,16   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtCodingOption2                ,MaxSliceSize                  ,20   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtCodingOption2                ,BitrateLimit                  ,24   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtCodingOption2                ,MBBRC                         ,26   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtCodingOption2                ,ExtBRC                        ,28   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtCodingOption2                ,LookAheadDepth                ,30   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtCodingOption2                ,Trellis                       ,32   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtCodingOption2                ,RepeatPPS                     ,34   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtCodingOption2                ,BRefType                      ,36   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtCodingOption2                ,AdaptiveI                     ,38   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtCodingOption2                ,AdaptiveB                     ,40   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtCodingOption2                ,LookAheadDS                   ,42   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtCodingOption2                ,NumMbPerSlice                 ,44   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtCodingOption2                ,SkipFrame                     ,46   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtCodingOption2                ,MinQPI                        ,48   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtCodingOption2                ,MaxQPI                        ,49   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtCodingOption2                ,MinQPP                        ,50   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtCodingOption2                ,MaxQPP                        ,51   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtCodingOption2                ,MinQPB                        ,52   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtCodingOption2                ,MaxQPB                        ,53   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtCodingOption2                ,FixedFrameRate                ,54   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtCodingOption2                ,DisableDeblockingIdc          ,56   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtCodingOption2                ,DisableVUI                    ,58   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtCodingOption2                ,BufferingPeriodSEI            ,60   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtCodingOption2                ,EnableMAD                     ,62   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtCodingOption2                ,UseRawRef                     ,64   )

    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtCodingOption3                ,Header                        ,0    )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtCodingOption3                ,NumSliceI                     ,8    )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtCodingOption3                ,NumSliceP                     ,10   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtCodingOption3                ,NumSliceB                     ,12   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtCodingOption3                ,WinBRCMaxAvgKbps              ,14   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtCodingOption3                ,WinBRCSize                    ,16   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtCodingOption3                ,QVBRQuality                   ,18   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtCodingOption3                ,EnableMBQP                    ,20   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtCodingOption3                ,IntRefCycleDist               ,22   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtCodingOption3                ,DirectBiasAdjustment          ,24   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtCodingOption3                ,GlobalMotionBiasAdjustment    ,26   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtCodingOption3                ,MVCostScalingFactor           ,28   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtCodingOption3                ,MBDisableSkipMap              ,30   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtCodingOption3                ,WeightedPred                  ,32   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtCodingOption3                ,WeightedBiPred                ,34   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtCodingOption3                ,AspectRatioInfoPresent        ,36   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtCodingOption3                ,OverscanInfoPresent           ,38   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtCodingOption3                ,OverscanAppropriate           ,40   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtCodingOption3                ,TimingInfoPresent             ,42   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtCodingOption3                ,BitstreamRestriction          ,44   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtCodingOption3                ,LowDelayHrd                   ,46   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtCodingOption3                ,MotionVectorsOverPicBoundaries,48   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtCodingOption3                ,ScenarioInfo                  ,54   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtCodingOption3                ,ContentInfo                   ,56   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtCodingOption3                ,PRefType                      ,58   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtCodingOption3                ,FadeDetection                 ,60   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtCodingOption3                ,GPB                           ,66   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtCodingOption3                ,MaxFrameSizeI                 ,68   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtCodingOption3                ,MaxFrameSizeP                 ,72   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtCodingOption3                ,EnableQPOffset                ,88   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtCodingOption3                ,QPOffset                      ,90   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtCodingOption3                ,NumRefActiveP                 ,106  )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtCodingOption3                ,NumRefActiveBL0               ,122  )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtCodingOption3                ,NumRefActiveBL1               ,138  )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtCodingOption3                ,TransformSkip                 ,156  )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtCodingOption3                ,TargetChromaFormatPlus1       ,158  )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtCodingOption3                ,TargetBitDepthLuma            ,160  )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtCodingOption3                ,TargetBitDepthChroma          ,162  )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtCodingOption3                ,BRCPanicMode                  ,164  )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtCodingOption3                ,LowDelayBRC                   ,166  )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtCodingOption3                ,EnableMBForceIntra            ,168  )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtCodingOption3                ,AdaptiveMaxFrameSize          ,170  )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtCodingOption3                ,RepartitionCheckEnable        ,172  )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtCodingOption3                ,EncodedUnitsInfo              ,180  )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtCodingOption3                ,EnableNalUnitType             ,182  )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtCodingOption3                ,ExtBrcAdaptiveLTR             ,184  )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtCodingOption3                ,AdaptiveCQM                   ,186  )

    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtVPPDoNotUse                  ,Header                        ,0    )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtVPPDoNotUse                  ,NumAlg                        ,8    )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtVPPDoNotUse                  ,AlgList                       ,12   )

    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtVPPDenoise                   ,Header                        ,0    )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtVPPDenoise                   ,DenoiseFactor                 ,8    )

    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtVPPDenoise2                  ,Header                        ,0	 )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtVPPDenoise2                  ,Mode                          ,8	 )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtVPPDenoise2                  ,Strength                      ,12   )

    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxChannel                         ,DataType                      ,0    )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxChannel                         ,Size                          ,4    )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxChannel                         ,Data                          ,8    )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxChannel                         ,Data16                        ,8    )

    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfx3DLutSystemBuffer               ,Channel                       ,0    )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfx3DLutVideoBuffer                ,DataType                      ,0    )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfx3DLutVideoBuffer                ,MemLayout                     ,4    )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfx3DLutVideoBuffer                ,MemId                         ,8    )

    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtVPP3DLut                     ,Header                        ,0    )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtVPP3DLut                     ,ChannelMapping                ,8    )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtVPP3DLut                     ,BufferType                    ,12   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtVPP3DLut                     ,SystemBuffer                  ,16   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtVPP3DLut                     ,VideoBuffer                   ,16   )
#ifdef ONEVPL_EXPERIMENTAL
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtVPP3DLut                     ,InterpolationMethod           ,132  )
#endif

    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtVPPDetail                    ,Header                        ,0    )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtVPPDetail                    ,DetailFactor                  ,8    )

    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtVPPProcAmp                   ,Header                        ,0    )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtVPPProcAmp                   ,Brightness                    ,8    )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtVPPProcAmp                   ,Contrast                      ,16   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtVPPProcAmp                   ,Hue                           ,24   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtVPPProcAmp                   ,Saturation                    ,32   )

    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxEncodeStat                      ,NumFrame                      ,64   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxEncodeStat                      ,NumBit                        ,72   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxEncodeStat                      ,NumCachedFrame                ,80   )

    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxDecodeStat                      ,NumFrame                      ,64   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxDecodeStat                      ,NumSkippedFrame               ,68   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxDecodeStat                      ,NumError                      ,72   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxDecodeStat                      ,NumCachedFrame                ,76   )

    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxVPPStat                         ,NumFrame                      ,64   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxVPPStat                         ,NumCachedFrame                ,68   )

    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtVppAuxData                   ,Header                        ,0    )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtVppAuxData                   ,SpatialComplexity             ,8    )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtVppAuxData                   ,TemporalComplexity            ,12   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtVppAuxData                   ,PicStruct                     ,8    )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtVppAuxData                   ,SceneChangeRate               ,16   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtVppAuxData                   ,RepeatedFrame                 ,18   )

    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxPayload                         ,CtrlFlags                     ,0    )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxPayload                         ,Data                          ,16   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxPayload                         ,NumBit                        ,20   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxPayload                         ,Type                          ,24   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxPayload                         ,BufSize                       ,26   )

    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxEncodeCtrl                      ,Header                        ,0    )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxEncodeCtrl                      ,MfxNalUnitType                ,26   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxEncodeCtrl                      ,SkipFrame                     ,28   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxEncodeCtrl                      ,QP                            ,30   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxEncodeCtrl                      ,FrameType                     ,32   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxEncodeCtrl                      ,NumExtParam                   ,34   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxEncodeCtrl                      ,NumPayload                    ,36   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxEncodeCtrl                      ,ExtParam                      ,40   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxEncodeCtrl                      ,Payload                       ,44   )

    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxFrameAllocRequest               ,AllocId                       ,0    )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxFrameAllocRequest               ,Info                          ,16   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxFrameAllocRequest               ,Type                          ,84   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxFrameAllocRequest               ,NumFrameMin                   ,86   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxFrameAllocRequest               ,NumFrameSuggested             ,88   )

    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxFrameAllocResponse              ,AllocId                       ,0    )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxFrameAllocResponse              ,mids                          ,16   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxFrameAllocResponse              ,NumFrameActual                ,20   )

    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtCodingOptionSPSPPS           ,Header                        ,0    )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtCodingOptionSPSPPS           ,SPSBuffer                     ,8    )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtCodingOptionSPSPPS           ,PPSBuffer                     ,12   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtCodingOptionSPSPPS           ,SPSBufSize                    ,16   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtCodingOptionSPSPPS           ,PPSBufSize                    ,18   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtCodingOptionSPSPPS           ,SPSId                         ,20   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtCodingOptionSPSPPS           ,PPSId                         ,22   )

    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtCodingOptionVPS              ,Header                        ,0    )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtCodingOptionVPS              ,VPSBuffer                     ,8    )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtCodingOptionVPS              ,VPSBufSize                    ,16   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtCodingOptionVPS              ,VPSId                         ,18   )

    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtVideoSignalInfo              ,Header                        ,0    )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtVideoSignalInfo              ,VideoFormat                   ,8    )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtVideoSignalInfo              ,VideoFullRange                ,10   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtVideoSignalInfo              ,ColourDescriptionPresent      ,12   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtVideoSignalInfo              ,ColourPrimaries               ,14   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtVideoSignalInfo              ,TransferCharacteristics       ,16   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtVideoSignalInfo              ,MatrixCoefficients            ,18   )

    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtVPPDoUse                     ,Header                        ,0    )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtVPPDoUse                     ,NumAlg                        ,8    )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtVPPDoUse                     ,AlgList                       ,12   )

    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtAVCRefListCtrl               ,Header                         ,0    )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtAVCRefListCtrl               ,NumRefIdxL0Active              ,8    )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtAVCRefListCtrl               ,NumRefIdxL1Active              ,10   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtAVCRefListCtrl               ,PreferredRefList               ,12   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtAVCRefListCtrl               ,PreferredRefList[0].FrameOrder ,12   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtAVCRefListCtrl               ,PreferredRefList[0].PicStruct  ,16   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtAVCRefListCtrl               ,PreferredRefList[0].ViewId     ,18   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtAVCRefListCtrl               ,PreferredRefList[0].LongTermIdx,20   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtAVCRefListCtrl               ,RejectedRefList                ,524  )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtAVCRefListCtrl               ,RejectedRefList[0].FrameOrder  ,524  )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtAVCRefListCtrl               ,RejectedRefList[0].PicStruct   ,528  )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtAVCRefListCtrl               ,RejectedRefList[0].ViewId      ,530  )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtAVCRefListCtrl               ,RejectedRefList[0].LongTermIdx ,532  )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtAVCRefListCtrl               ,LongTermRefList                ,780  )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtAVCRefListCtrl               ,LongTermRefList[0].FrameOrder  ,780  )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtAVCRefListCtrl               ,LongTermRefList[0].PicStruct   ,784  )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtAVCRefListCtrl               ,LongTermRefList[0].ViewId      ,786  )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtAVCRefListCtrl               ,LongTermRefList[0].LongTermIdx ,788  )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtAVCRefListCtrl               ,ApplyLongTermIdx               ,1036 )

    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtVPPFrameRateConversion       ,Header                        ,0    )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtVPPFrameRateConversion       ,Algorithm                     ,8    )

    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtVPPImageStab                 ,Header                        ,0    )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtVPPImageStab                 ,Mode                          ,8    )

    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtMasteringDisplayColourVolume ,Header                        ,0    )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtMasteringDisplayColourVolume ,InsertPayloadToggle           ,38   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtMasteringDisplayColourVolume ,DisplayPrimariesX             ,40   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtMasteringDisplayColourVolume ,DisplayPrimariesY             ,46   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtMasteringDisplayColourVolume ,WhitePointX                   ,52   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtMasteringDisplayColourVolume ,WhitePointY                   ,54   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtMasteringDisplayColourVolume ,MaxDisplayMasteringLuminance  ,56   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtMasteringDisplayColourVolume ,MinDisplayMasteringLuminance  ,60   )

    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtContentLightLevelInfo        ,Header                        ,0    )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtContentLightLevelInfo        ,InsertPayloadToggle           ,26   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtContentLightLevelInfo        ,MaxContentLightLevel          ,28   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtContentLightLevelInfo        ,MaxPicAverageLightLevel       ,30   )

    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtPictureTimingSEI             ,Header                          ,0    )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtPictureTimingSEI             ,TimeStamp                       ,64   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtPictureTimingSEI             ,TimeStamp[0].ClockTimestampFlag ,64   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtPictureTimingSEI             ,TimeStamp[0].CtType             ,66   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtPictureTimingSEI             ,TimeStamp[0].NuitFieldBasedFlag ,68   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtPictureTimingSEI             ,TimeStamp[0].CountingType       ,70   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtPictureTimingSEI             ,TimeStamp[0].FullTimestampFlag  ,72   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtPictureTimingSEI             ,TimeStamp[0].DiscontinuityFlag  ,74   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtPictureTimingSEI             ,TimeStamp[0].CntDroppedFlag     ,76   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtPictureTimingSEI             ,TimeStamp[0].NFrames            ,78   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtPictureTimingSEI             ,TimeStamp[0].SecondsFlag        ,80   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtPictureTimingSEI             ,TimeStamp[0].MinutesFlag        ,82   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtPictureTimingSEI             ,TimeStamp[0].HoursFlag          ,84   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtPictureTimingSEI             ,TimeStamp[0].SecondsValue       ,86   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtPictureTimingSEI             ,TimeStamp[0].MinutesValue       ,88   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtPictureTimingSEI             ,TimeStamp[0].HoursValue         ,90   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtPictureTimingSEI             ,TimeStamp[0].TimeOffset         ,92   )

    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtAvcTemporalLayers            ,Header                        ,0    )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtAvcTemporalLayers            ,BaseLayerPID                  ,26   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtAvcTemporalLayers            ,Layer                         ,28   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtAvcTemporalLayers            ,Layer[0].Scale                ,28   )

    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtEncoderCapability            ,Header                        ,0    )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtEncoderCapability            ,MBPerSec                      ,8    )

    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtEncoderResetOption           ,Header                        ,0    )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtEncoderResetOption           ,StartNewSequence              ,8    )

    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtAVCEncodedFrameInfo          ,Header                        ,0    )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtAVCEncodedFrameInfo          ,FrameOrder                    ,8    )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtAVCEncodedFrameInfo          ,PicStruct                     ,12   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtAVCEncodedFrameInfo          ,LongTermIdx                   ,14   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtAVCEncodedFrameInfo          ,MAD                           ,16   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtAVCEncodedFrameInfo          ,BRCPanicMode                  ,20   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtAVCEncodedFrameInfo          ,QP                            ,22   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtAVCEncodedFrameInfo          ,SecondFieldOffset             ,24   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtAVCEncodedFrameInfo          ,UsedRefListL0                 ,32   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtAVCEncodedFrameInfo          ,UsedRefListL0[0].FrameOrder   ,32   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtAVCEncodedFrameInfo          ,UsedRefListL0[0].PicStruct    ,36   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtAVCEncodedFrameInfo          ,UsedRefListL0[0].LongTermIdx  ,38   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtAVCEncodedFrameInfo          ,UsedRefListL1                 ,544  )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtAVCEncodedFrameInfo          ,UsedRefListL1[0].FrameOrder   ,544  )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtAVCEncodedFrameInfo          ,UsedRefListL1[0].PicStruct    ,548  )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtAVCEncodedFrameInfo          ,UsedRefListL1[0].LongTermIdx  ,550  )

    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxVPPCompInputStream              ,DstX                          ,0    )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxVPPCompInputStream              ,DstY                          ,4    )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxVPPCompInputStream              ,DstW                          ,8    )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxVPPCompInputStream              ,DstH                          ,12   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxVPPCompInputStream              ,LumaKeyEnable                 ,16   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxVPPCompInputStream              ,LumaKeyMin                    ,18   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxVPPCompInputStream              ,LumaKeyMax                    ,20   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxVPPCompInputStream              ,GlobalAlphaEnable             ,22   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxVPPCompInputStream              ,GlobalAlpha                   ,24   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxVPPCompInputStream              ,PixelAlphaEnable              ,26   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxVPPCompInputStream              ,TileId                        ,28   )

    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtVPPComposite                 ,Header                        ,0    )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtVPPComposite                 ,Y                             ,8    )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtVPPComposite                 ,U                             ,10   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtVPPComposite                 ,V                             ,12   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtVPPComposite                 ,R                             ,8    )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtVPPComposite                 ,G                             ,10   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtVPPComposite                 ,B                             ,12   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtVPPComposite                 ,NumTiles                      ,14   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtVPPComposite                 ,NumInputStream                ,62   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtVPPComposite                 ,InputStream                   ,64   )

    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtVPPVideoSignalInfo           ,Header                        ,0    )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtVPPVideoSignalInfo           ,In                            ,16   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtVPPVideoSignalInfo           ,In.TransferMatrix             ,16   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtVPPVideoSignalInfo           ,In.NominalRange               ,18   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtVPPVideoSignalInfo           ,Out                           ,32   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtVPPVideoSignalInfo           ,Out.TransferMatrix            ,32   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtVPPVideoSignalInfo           ,Out.NominalRange              ,34   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtVPPVideoSignalInfo           ,TransferMatrix                ,16   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtVPPVideoSignalInfo           ,NominalRange                  ,18   )

    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtEncoderROI                   ,Header                        ,0    )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtEncoderROI                   ,NumROI                        ,8    )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtEncoderROI                   ,ROIMode                       ,10   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtEncoderROI                   ,ROI                           ,32   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtEncoderROI                   ,ROI[0].Left                   ,32   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtEncoderROI                   ,ROI[0].Top                    ,36   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtEncoderROI                   ,ROI[0].Right                  ,40   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtEncoderROI                   ,ROI[0].Bottom                 ,44   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtEncoderROI                   ,ROI[0].Priority               ,48   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtEncoderROI                   ,ROI[0].DeltaQP                ,48   )

    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtVPPDeinterlacing             ,Header                        ,0    )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtVPPDeinterlacing             ,Mode                          ,8    )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtVPPDeinterlacing             ,TelecinePattern               ,10   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtVPPDeinterlacing             ,TelecineLocation              ,12   )

    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtAVCRefLists                  ,Header                        ,0    )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtAVCRefLists                  ,NumRefIdxL0Active             ,8    )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtAVCRefLists                  ,NumRefIdxL1Active             ,10   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtAVCRefLists                  ,RefPicList0                   ,16   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtAVCRefLists                  ,RefPicList0[0].FrameOrder     ,16   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtAVCRefLists                  ,RefPicList0[0].PicStruct      ,20   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtAVCRefLists                  ,RefPicList1                   ,528  )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtAVCRefLists                  ,RefPicList1[0].FrameOrder     ,528  )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtAVCRefLists                  ,RefPicList1[0].PicStruct      ,532  )

    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtVPPFieldProcessing           ,Header                        ,0    )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtVPPFieldProcessing           ,Mode                          ,8    )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtVPPFieldProcessing           ,InField                       ,10   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtVPPFieldProcessing           ,OutField                      ,12   )

    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtDecVideoProcessing           ,Header                        ,0    )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtDecVideoProcessing           ,In.CropX                      ,8    )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtDecVideoProcessing           ,In.CropY                      ,10   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtDecVideoProcessing           ,In.CropW                      ,12   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtDecVideoProcessing           ,In.CropH                      ,14   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtDecVideoProcessing           ,Out.FourCC                    ,40   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtDecVideoProcessing           ,Out.ChromaFormat              ,44   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtDecVideoProcessing           ,Out.Width                     ,48   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtDecVideoProcessing           ,Out.Height                    ,50   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtDecVideoProcessing           ,Out.CropX                     ,52   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtDecVideoProcessing           ,Out.CropY                     ,54   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtDecVideoProcessing           ,Out.CropW                     ,56   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtDecVideoProcessing           ,Out.CropH                     ,58   )

    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtChromaLocInfo                ,Header                        ,0    )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtChromaLocInfo                ,ChromaLocInfoPresentFlag      ,8    )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtChromaLocInfo                ,ChromaSampleLocTypeTopField   ,10   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtChromaLocInfo                ,ChromaSampleLocTypeBottomField,12   )

    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtMBQP                         ,Header                        ,0    )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtMBQP                         ,Pitch                         ,44   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtMBQP                         ,Mode                          ,48   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtMBQP                         ,BlockSize                     ,50   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtMBQP                         ,NumQPAlloc                    ,52   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtMBQP                         ,QP                            ,56   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtMBQP                         ,DeltaQP                       ,56   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtMBQP                         ,QPmode                        ,56   )

    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxQPandMode                       ,QP                            ,0    )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxQPandMode                       ,DeltaQP                       ,0    )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxQPandMode                       ,Mode                          ,2    )

    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtInsertHeaders                ,Header                        ,0    )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtInsertHeaders                ,SPS                           ,8    )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtInsertHeaders                ,PPS                           ,10   )

    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtEncoderIPCMArea              ,Header                        ,0    )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtEncoderIPCMArea              ,NumArea                       ,28   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtEncoderIPCMArea              ,Areas                         ,32   )

    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtEncoderIPCMArea::area        ,Left                          ,0    )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtEncoderIPCMArea::area        ,Top                           ,4    )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtEncoderIPCMArea::area        ,Right                         ,8    )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtEncoderIPCMArea::area        ,Bottom                        ,12   )

    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtMBForceIntra                 ,Header                        ,0    )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtMBForceIntra                 ,MapSize                       ,52   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtMBForceIntra                 ,Map                           ,56   )

    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtHEVCTiles                    ,Header                        ,0    )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtHEVCTiles                    ,NumTileRows                   ,8    )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtHEVCTiles                    ,NumTileColumns                ,10   )

    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtMBDisableSkipMap             ,Header                        ,0    )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtMBDisableSkipMap             ,MapSize                       ,52   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtMBDisableSkipMap             ,Map                           ,56   )


    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtHEVCParam                    ,Header                        ,0    )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtHEVCParam                    ,PicWidthInLumaSamples         ,8    )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtHEVCParam                    ,PicHeightInLumaSamples        ,10   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtHEVCParam                    ,GeneralConstraintFlags        ,12   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtHEVCParam                    ,SampleAdaptiveOffset          ,20   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtHEVCParam                    ,LCUSize                       ,22   )

    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtDecodeErrorReport            ,Header                        ,0    )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtDecodeErrorReport            ,ErrorTypes                    ,8    )

    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtDecodedFrameInfo             ,Header                        ,0    )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtDecodedFrameInfo             ,FrameType                     ,8    )

    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtTimeCode                     ,Header                        ,0    )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtTimeCode                     ,DropFrameFlag                 ,8    )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtTimeCode                     ,TimeCodeHours                 ,10   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtTimeCode                     ,TimeCodeMinutes               ,12   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtTimeCode                     ,TimeCodeSeconds               ,14   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtTimeCode                     ,TimeCodePictures              ,16   )

    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtHEVCRegion                   ,Header                        ,0    )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtHEVCRegion                   ,RegionId                      ,8    )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtHEVCRegion                   ,RegionType                    ,12   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtHEVCRegion                   ,RegionEncoding                ,14   )

    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtPredWeightTable              ,Header                        ,0    )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtPredWeightTable              ,LumaLog2WeightDenom           ,8    )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtPredWeightTable              ,ChromaLog2WeightDenom         ,10   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtPredWeightTable              ,LumaWeightFlag                ,12   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtPredWeightTable              ,ChromaWeightFlag              ,140  )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtPredWeightTable              ,Weights                       ,268  )

    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtAVCRoundingOffset            ,Header                        ,0    )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtAVCRoundingOffset            ,EnableRoundingIntra           ,8    )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtAVCRoundingOffset            ,RoundingOffsetIntra           ,10   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtAVCRoundingOffset            ,EnableRoundingInter           ,12   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtAVCRoundingOffset            ,RoundingOffsetInter           ,14   )

    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtDirtyRect                    ,Header                        ,0    )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtDirtyRect                    ,NumRect                       ,8    )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtDirtyRect                    ,Rect                          ,32   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtDirtyRect                    ,Rect[0].Left                  ,32   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtDirtyRect                    ,Rect[0].Top                   ,36   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtDirtyRect                    ,Rect[0].Right                 ,40   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtDirtyRect                    ,Rect[0].Bottom                ,44   )

    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtMoveRect                     ,Header                        ,0    )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtMoveRect                     ,NumRect                       ,8    )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtMoveRect                     ,Rect                          ,32   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtMoveRect                     ,Rect[0].DestLeft              ,32   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtMoveRect                     ,Rect[0].DestTop               ,36   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtMoveRect                     ,Rect[0].DestRight             ,40   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtMoveRect                     ,Rect[0].DestBottom            ,44   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtMoveRect                     ,Rect[0].SourceLeft            ,48   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtMoveRect                     ,Rect[0].SourceTop             ,52   )

    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtVPPRotation                  ,Header                        ,0    )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtVPPRotation                  ,Angle                         ,8    )

    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtEncodedSlicesInfo            ,Header                        ,0    )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtEncodedSlicesInfo            ,SliceSizeOverflow             ,8    )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtEncodedSlicesInfo            ,NumSliceNonCopliant           ,10   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtEncodedSlicesInfo            ,NumEncodedSlice               ,12   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtEncodedSlicesInfo            ,NumSliceSizeAlloc             ,14   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtEncodedSlicesInfo            ,SliceSize                     ,16   )

    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtVPPScaling                   ,Header                        ,0    )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtVPPScaling                   ,ScalingMode                   ,8    )

    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtVPPMirroring                 ,Header                        ,0    )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtVPPMirroring                 ,Type                          ,8    )

    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtMVOverPicBoundaries          ,Header                        ,0    )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtMVOverPicBoundaries          ,StickTop                      ,8    )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtMVOverPicBoundaries          ,StickBottom                   ,10   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtMVOverPicBoundaries          ,StickLeft                     ,12   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtMVOverPicBoundaries          ,StickRight                    ,14   )

    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtVPPColorFill                 ,Header                        ,0    )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtVPPColorFill                 ,Enable                        ,8    )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtColorConversion              ,Header                        ,0    )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtColorConversion              ,ChromaSiting                  ,8    )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxVP9SegmentParam                 ,FeatureEnabled                ,0    )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxVP9SegmentParam                 ,QIndexDelta                   ,2    )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxVP9SegmentParam                 ,LoopFilterLevelDelta          ,4    )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxVP9SegmentParam                 ,ReferenceFrame                ,6    )

    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtVP9Segmentation              ,Header                        ,0    )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtVP9Segmentation              ,NumSegments                   ,8    )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtVP9Segmentation              ,Segment                       ,10   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtVP9Segmentation              ,SegmentIdBlockSize            ,266  )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtVP9Segmentation              ,NumSegmentIdAlloc             ,268  )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtVP9Segmentation              ,SegmentId                     ,272  )

    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxVP9TemporalLayer                ,FrameRateScale                ,0    )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxVP9TemporalLayer                ,TargetKbps                    ,2    )

    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtVP9TemporalLayers            ,Header                        ,0    )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtVP9TemporalLayers            ,Layer                         ,8    )

    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtVP9Param                     ,Header                        ,0    )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtVP9Param                     ,FrameWidth                    ,8    )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtVP9Param                     ,FrameHeight                   ,10   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtVP9Param                     ,WriteIVFHeaders               ,12   )

    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtVP9Param                     ,QIndexDeltaLumaDC             ,26   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtVP9Param                     ,QIndexDeltaChromaAC           ,28   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtVP9Param                     ,QIndexDeltaChromaDC           ,30   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtVP9Param                     ,NumTileRows                   ,32   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtVP9Param                     ,NumTileColumns                ,34   )

    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxEncodedUnitInfo                 ,Type                          ,0    )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxEncodedUnitInfo                 ,Offset                        ,4    )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxEncodedUnitInfo                 ,Size                          ,8    )

    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtEncodedUnitsInfo             ,Header                        ,0    )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtEncodedUnitsInfo             ,UnitInfo                      ,8    )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtEncodedUnitsInfo             ,NumUnitsAlloc                 ,16   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtEncodedUnitsInfo             ,NumUnitsEncoded               ,18   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtVppMctf                      ,Header                        ,0    )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtVppMctf                      ,FilterStrength                ,8    )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxAV1FilmGrainPoint               ,Value                         ,0    )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxAV1FilmGrainPoint               ,Scaling                       ,1    )

    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtAV1FilmGrainParam            ,Header                        ,0    )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtAV1FilmGrainParam            ,FilmGrainFlags                ,8    )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtAV1FilmGrainParam            ,GrainSeed                     ,10   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtAV1FilmGrainParam            ,RefIdx                        ,12   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtAV1FilmGrainParam            ,NumYPoints                    ,13   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtAV1FilmGrainParam            ,NumCbPoints                   ,14   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtAV1FilmGrainParam            ,NumCrPoints                   ,15   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtAV1FilmGrainParam            ,PointY                        ,16   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtAV1FilmGrainParam            ,PointCb                       ,44   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtAV1FilmGrainParam            ,PointCr                       ,64   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtAV1FilmGrainParam            ,GrainScalingMinus8            ,84   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtAV1FilmGrainParam            ,ArCoeffLag                    ,85   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtAV1FilmGrainParam            ,ArCoeffsYPlus128              ,86   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtAV1FilmGrainParam            ,ArCoeffsCbPlus128             ,110  )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtAV1FilmGrainParam            ,ArCoeffsCrPlus128             ,135  )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtAV1FilmGrainParam            ,ArCoeffShiftMinus6            ,160  )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtAV1FilmGrainParam            ,GrainScaleShift               ,161  )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtAV1FilmGrainParam            ,CbMult                        ,162  )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtAV1FilmGrainParam            ,CbLumaMult                    ,163  )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtAV1FilmGrainParam            ,CbOffset                      ,164  )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtAV1FilmGrainParam            ,CrMult                        ,166  )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtAV1FilmGrainParam            ,CrLumaMult                    ,167  )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtAV1FilmGrainParam            ,CrOffset                      ,168  )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxComponentInfo                   ,Type                          ,0    )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxComponentInfo                   ,Requirements                  ,4    )

    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxAdapterInfo                     ,Platform                      ,0    )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxAdapterInfo                     ,Number                        ,32   )

    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxAdaptersInfo                    ,Adapters                      ,0    )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxAdaptersInfo                    ,NumAlloc                      ,4    )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxAdaptersInfo                    ,NumActual                     ,8    )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtPartialBitstreamParam        ,Header                          ,0  )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtPartialBitstreamParam        ,BlockSize                       ,8  )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtPartialBitstreamParam        ,Granularity                    ,12  )

#ifdef ONEVPL_EXPERIMENTAL
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxMemoryInterface              ,Context                        ,  0 )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxMemoryInterface              ,Version                        ,  4 )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxMemoryInterface              ,ImportFrameSurface             ,  8 )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxMemoryInterface              ,reserved                       , 12 )

    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxSurfaceInterface             ,Header                         ,  0 )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxSurfaceInterface             ,Version                        , 44 )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxSurfaceInterface             ,Context                        , 48 )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxSurfaceInterface             ,AddRef                         , 52 )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxSurfaceInterface             ,Release                        , 56 )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxSurfaceInterface             ,GetRefCounter                  , 60 )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxSurfaceInterface             ,Synchronize                    , 64 )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxSurfaceInterface             ,reserved                       , 68 )

    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxSurfaceHeader                ,SurfaceType                    ,  0 )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxSurfaceHeader                ,SurfaceFlags                   ,  4 )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxSurfaceHeader                ,StructSize                     ,  8 )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxSurfaceHeader                ,NumExtParam                    , 12 )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxSurfaceHeader                ,ExtParam                       , 16 )

    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxSurfaceD3D11Tex2D            ,SurfaceInterface               ,  0 )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxSurfaceD3D11Tex2D            ,texture2D                      ,112 )

    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxSurfaceD3D12Tex2D            ,SurfaceInterface               ,  0 )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxSurfaceD3D12Tex2D            ,texture2D                      ,112 )

    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxSurfaceVAAPI                 ,SurfaceInterface               ,  0 )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxSurfaceVAAPI                 ,vaDisplay                      ,112 )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxSurfaceVAAPI                 ,vaSurfaceID                    ,116 )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxSurfaceVAAPI                 ,reserved1                      ,120 )

    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxSurfaceOpenCLImg2D           ,SurfaceInterface               ,  0 )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxSurfaceOpenCLImg2D           ,ocl_context                    ,112 )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxSurfaceOpenCLImg2D           ,ocl_command_queue              ,116 )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxSurfaceOpenCLImg2D           ,ocl_image                      ,120 )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxSurfaceOpenCLImg2D           ,ocl_image_num                  ,136 )

    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxSurfaceVulkanImg2D           ,SurfaceInterface               ,  0 )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxSurfaceVulkanImg2D           ,instance                       ,112 )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxSurfaceVulkanImg2D           ,physicalDevice                 ,116 )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxSurfaceVulkanImg2D           ,device                         ,120 )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxSurfaceVulkanImg2D           ,image2D                        ,124 )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxSurfaceVulkanImg2D           ,image2DMemory                  ,128 )

    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxSurfaceTypesSupported        ,Version                         ,0  )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxSurfaceTypesSupported        ,NumSurfaceTypes                 ,2  )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxSurfaceTypesSupported        ,SurfaceTypes                    ,4  )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxSurfaceTypesSupported        ,reserved                        ,8  )

    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxSurfaceTypesSupported::surftype    ,SurfaceType                  , 0 )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxSurfaceTypesSupported::surftype    ,reserved                     , 4 )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxSurfaceTypesSupported::surftype    ,NumSurfaceComponents         ,28 )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxSurfaceTypesSupported::surftype    ,SurfaceComponents            ,32 )

    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxSurfaceTypesSupported::surftype::surfcomp    ,SurfaceComponent      , 0 )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxSurfaceTypesSupported::surftype::surfcomp    ,SurfaceFlags          , 4 )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxSurfaceTypesSupported::surftype::surfcomp    ,reserved              , 8 )

    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtSurfaceOpenCLImg2DExportDescription    ,Header            ,  0 )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtSurfaceOpenCLImg2DExportDescription    ,ocl_context       ,  8 )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtSurfaceOpenCLImg2DExportDescription    ,ocl_command_queue , 12 )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtSurfaceOpenCLImg2DExportDescription    ,reserved          , 16 )

    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtSurfaceD3D12Tex2DExportDescription    ,Header            ,  0 )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtSurfaceD3D12Tex2DExportDescription    ,d3d12Device       ,  8 )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtSurfaceD3D12Tex2DExportDescription    ,reserved          , 12 )

    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtSurfaceVulkanImg2DExportDescription    ,Header           ,  0 )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtSurfaceVulkanImg2DExportDescription    ,instance         ,  8 )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtSurfaceVulkanImg2DExportDescription    ,physicalDevice   , 12 )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtSurfaceVulkanImg2DExportDescription    ,device           , 16 )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtSurfaceVulkanImg2DExportDescription    ,reserved         , 20 )

#endif

    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtVPPAISuperResolution         ,Header                        ,0    )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtVPPAISuperResolution         ,SRMode                        ,8    )
#ifdef ONEVPL_EXPERIMENTAL
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtVPPAISuperResolution         ,SRAlgorithm                   ,12   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtVPPAISuperResolution         ,reserved1                     ,16   )
#else
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtVPPAISuperResolution         ,reserved1                     ,12   )
#endif
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtVPPAISuperResolution         ,reserved2                     ,76   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtVPPAIFrameInterpolation      ,Header                         ,0      )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtVPPAIFrameInterpolation      ,FIMode                         ,8      )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtVPPAIFrameInterpolation      ,EnableScd                      ,12     )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtVPPAIFrameInterpolation      ,reserved1                      ,16     )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtVPPAIFrameInterpolation      ,reserved2                      ,112     )
#endif

#ifdef ONEVPL_EXPERIMENTAL
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxABGR16FP                        ,R                               ,0  )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxABGR16FP                        ,G                               ,2  )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxABGR16FP                        ,B                               ,4  )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxABGR16FP                        ,A                               ,6  )
#endif

//mfxvideo.h
#if defined(_x86_64)
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxFrameAllocator                  ,pthis                        ,16   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxFrameAllocator                  ,Alloc                        ,24   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxFrameAllocator                  ,Lock                         ,32   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxFrameAllocator                  ,Unlock                       ,40   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxFrameAllocator                  ,GetHDL                       ,48   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxFrameAllocator                  ,Free                         ,56   )
#elif defined(_x86)

    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxFrameAllocator                  ,pthis                        ,16   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxFrameAllocator                  ,Alloc                        ,20   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxFrameAllocator                  ,Lock                         ,24   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxFrameAllocator                  ,Unlock                       ,28   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxFrameAllocator                  ,GetHDL                       ,32   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxFrameAllocator                  ,Free                         ,36   )
#endif

//mfxjpeg.h
#if defined(_x86_64)
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtJPEGQuantTables              ,Header                        ,0    )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtJPEGQuantTables              ,NumTable                      ,22   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtJPEGQuantTables              ,Qm                            ,24   )

    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtJPEGHuffmanTables            ,Header                        ,0    )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtJPEGHuffmanTables            ,NumDCTable                    ,12   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtJPEGHuffmanTables            ,NumACTable                    ,14   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtJPEGHuffmanTables            ,DCTables[0].Bits              ,16   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtJPEGHuffmanTables            ,DCTables[0].Values            ,32   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtJPEGHuffmanTables            ,ACTables[0].Bits              ,128  )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtJPEGHuffmanTables            ,ACTables[0].Values            ,144  )
#elif defined(_x86)
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtJPEGQuantTables              ,Header                        ,0    )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtJPEGQuantTables              ,NumTable                      ,22   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtJPEGQuantTables              ,Qm                            ,24   )

    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtJPEGHuffmanTables            ,Header                        ,0    )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtJPEGHuffmanTables            ,NumDCTable                    ,12   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtJPEGHuffmanTables            ,NumACTable                    ,14   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtJPEGHuffmanTables            ,DCTables[0].Bits              ,16   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtJPEGHuffmanTables            ,DCTables[0].Values            ,32   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtJPEGHuffmanTables            ,ACTables[0].Bits              ,128  )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtJPEGHuffmanTables            ,ACTables[0].Values            ,144  )
#endif

//mfxmvc.h
#if defined(_x86_64)
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxMVCViewDependency               ,ViewId                        ,0    )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxMVCViewDependency               ,NumAnchorRefsL0               ,2    )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxMVCViewDependency               ,NumAnchorRefsL1               ,4    )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxMVCViewDependency               ,AnchorRefL0                   ,6    )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxMVCViewDependency               ,AnchorRefL1                   ,38   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxMVCViewDependency               ,NumNonAnchorRefsL0            ,70   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxMVCViewDependency               ,NumNonAnchorRefsL1            ,72   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxMVCViewDependency               ,NonAnchorRefL0                ,74   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxMVCViewDependency               ,NonAnchorRefL1                ,106  )

    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxMVCOperationPoint               ,TemporalId                    ,0    )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxMVCOperationPoint               ,LevelIdc                      ,2    )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxMVCOperationPoint               ,NumViews                      ,4    )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxMVCOperationPoint               ,NumTargetViews                ,6    )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxMVCOperationPoint               ,TargetViewId                  ,8    )

    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtMVCSeqDesc                   ,Header                        ,0    )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtMVCSeqDesc                   ,NumView                       ,8    )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtMVCSeqDesc                   ,NumViewAlloc                  ,12   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtMVCSeqDesc                   ,View                          ,16   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtMVCSeqDesc                   ,NumViewId                     ,24   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtMVCSeqDesc                   ,NumViewIdAlloc                ,28   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtMVCSeqDesc                   ,ViewId                        ,32   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtMVCSeqDesc                   ,NumOP                         ,40   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtMVCSeqDesc                   ,NumOPAlloc                    ,44   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtMVCSeqDesc                   ,OP                            ,48   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtMVCSeqDesc                   ,NumRefsTotal                  ,56   )

    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtMVCTargetViews               ,Header                        ,0    )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtMVCTargetViews               ,TemporalId                    ,8    )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtMVCTargetViews               ,NumView                       ,12   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtMVCTargetViews               ,ViewId                        ,16   )
#elif defined(_x86)
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxMVCViewDependency               ,ViewId                        ,0    )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxMVCViewDependency               ,NumAnchorRefsL0               ,2    )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxMVCViewDependency               ,NumAnchorRefsL1               ,4    )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxMVCViewDependency               ,AnchorRefL0                   ,6    )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxMVCViewDependency               ,AnchorRefL1                   ,38   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxMVCViewDependency               ,NumNonAnchorRefsL0            ,70   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxMVCViewDependency               ,NumNonAnchorRefsL1            ,72   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxMVCViewDependency               ,NonAnchorRefL0                ,74   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxMVCViewDependency               ,NonAnchorRefL1                ,106  )

    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxMVCOperationPoint               ,TemporalId                    ,0    )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxMVCOperationPoint               ,LevelIdc                      ,2    )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxMVCOperationPoint               ,NumViews                      ,4    )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxMVCOperationPoint               ,NumTargetViews                ,6    )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxMVCOperationPoint               ,TargetViewId                  ,8    )

    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtMVCSeqDesc                   ,Header                        ,0    )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtMVCSeqDesc                   ,NumView                       ,8    )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtMVCSeqDesc                   ,NumViewAlloc                  ,12   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtMVCSeqDesc                   ,View                          ,16   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtMVCSeqDesc                   ,NumViewId                     ,20   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtMVCSeqDesc                   ,NumViewIdAlloc                ,24   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtMVCSeqDesc                   ,ViewId                        ,28   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtMVCSeqDesc                   ,NumOP                         ,32   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtMVCSeqDesc                   ,NumOPAlloc                    ,36   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtMVCSeqDesc                   ,OP                            ,40   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtMVCSeqDesc                   ,NumRefsTotal                  ,44   )

    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtMVCTargetViews               ,Header                        ,0    )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtMVCTargetViews               ,TemporalId                    ,8    )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtMVCTargetViews               ,NumView                       ,12   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtMVCTargetViews               ,ViewId                        ,16   )
#endif

//mfxvp8.h
#if defined(_x86_64)
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtVP8CodingOption              ,Header                        ,0    )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtVP8CodingOption              ,Version                       ,8    )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtVP8CodingOption              ,EnableMultipleSegments        ,10   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtVP8CodingOption              ,LoopFilterType                ,12   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtVP8CodingOption              ,LoopFilterLevel               ,14   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtVP8CodingOption              ,SharpnessLevel                ,22   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtVP8CodingOption              ,NumTokenPartitions            ,24   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtVP8CodingOption              ,LoopFilterRefTypeDelta        ,26   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtVP8CodingOption              ,LoopFilterMbModeDelta         ,34   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtVP8CodingOption              ,SegmentQPDelta                ,42   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtVP8CodingOption              ,CoeffTypeQPDelta              ,50   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtVP8CodingOption              ,WriteIVFHeaders               ,60   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtVP8CodingOption              ,NumFramesForIVFHeader         ,64   )
#elif defined(_x86)
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtVP8CodingOption              ,Header                        ,0    )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtVP8CodingOption              ,Version                       ,8    )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtVP8CodingOption              ,EnableMultipleSegments        ,10   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtVP8CodingOption              ,LoopFilterType                ,12   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtVP8CodingOption              ,LoopFilterLevel               ,14   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtVP8CodingOption              ,SharpnessLevel                ,22   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtVP8CodingOption              ,NumTokenPartitions            ,24   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtVP8CodingOption              ,LoopFilterRefTypeDelta        ,26   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtVP8CodingOption              ,LoopFilterMbModeDelta         ,34   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtVP8CodingOption              ,SegmentQPDelta                ,42   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtVP8CodingOption              ,CoeffTypeQPDelta              ,50   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtVP8CodingOption              ,WriteIVFHeaders               ,60   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtVP8CodingOption              ,NumFramesForIVFHeader         ,64   )
#endif


//mfxbrc.h
#if defined(_x86_64)
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxBRCFrameParam                   ,SceneChange                   ,92   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxBRCFrameParam                   ,LongTerm                      ,94   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxBRCFrameParam                   ,FrameCmplx                    ,96   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxBRCFrameParam                   ,EncodedOrder                  ,100  )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxBRCFrameParam                   ,DisplayOrder                  ,104  )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxBRCFrameParam                   ,CodedFrameSize                ,108  )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxBRCFrameParam                   ,FrameType                     ,112  )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxBRCFrameParam                   ,PyramidLayer                  ,114  )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxBRCFrameParam                   ,NumRecode                     ,116  )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxBRCFrameParam                   ,NumExtParam                   ,118  )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxBRCFrameParam                   ,ExtParam                      ,120  )

    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxBRCFrameCtrl                    ,QpY                           ,0    )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxBRCFrameCtrl                    ,InitialCpbRemovalDelay        ,4    )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxBRCFrameCtrl                    ,InitialCpbRemovalOffset       ,8    )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxBRCFrameCtrl                    ,MaxFrameSize                  ,40   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxBRCFrameCtrl                    ,DeltaQP                       ,44   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxBRCFrameCtrl                    ,MaxNumRepak                   ,52   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxBRCFrameCtrl                    ,NumExtParam                   ,54   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxBRCFrameCtrl                    ,ExtParam                      ,56   )

    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxBRCFrameStatus                  ,MinFrameSize                  ,0    )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxBRCFrameStatus                  ,BRCStatus                     ,4    )

    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtBRC                          ,Header                        ,0    )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtBRC                          ,pthis                         ,64   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtBRC                          ,Init                          ,72   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtBRC                          ,Reset                         ,80   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtBRC                          ,Close                         ,88   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtBRC                          ,GetFrameCtrl                  ,96   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtBRC                          ,Update                        ,104  )

#elif defined(_x86)
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxBRCFrameParam                   ,SceneChange                   ,92   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxBRCFrameParam                   ,LongTerm                      ,94   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxBRCFrameParam                   ,FrameCmplx                    ,96   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxBRCFrameParam                   ,EncodedOrder                  ,100  )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxBRCFrameParam                   ,DisplayOrder                  ,104  )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxBRCFrameParam                   ,CodedFrameSize                ,108  )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxBRCFrameParam                   ,FrameType                     ,112  )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxBRCFrameParam                   ,PyramidLayer                  ,114  )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxBRCFrameParam                   ,NumRecode                     ,116  )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxBRCFrameParam                   ,NumExtParam                   ,118  )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxBRCFrameParam                   ,ExtParam                      ,120  )

    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxBRCFrameCtrl                    ,QpY                           ,0    )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxBRCFrameCtrl                    ,InitialCpbRemovalDelay        ,4    )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxBRCFrameCtrl                    ,InitialCpbRemovalOffset       ,8    )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxBRCFrameCtrl                    ,MaxFrameSize                  ,40   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxBRCFrameCtrl                    ,DeltaQP                       ,44   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxBRCFrameCtrl                    ,MaxNumRepak                   ,52   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxBRCFrameCtrl                    ,NumExtParam                   ,54   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxBRCFrameCtrl                    ,ExtParam                      ,56   )

    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxBRCFrameStatus                  ,MinFrameSize                  ,0    )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxBRCFrameStatus                  ,BRCStatus                     ,4    )

    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtBRC                          ,Header                        ,0    )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtBRC                          ,pthis                         ,64   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtBRC                          ,Init                          ,68   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtBRC                          ,Reset                         ,72   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtBRC                          ,Close                         ,76   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtBRC                          ,GetFrameCtrl                  ,80   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtBRC                          ,Update                        ,84   )
#endif

//mfxpcp.h
#if defined (__MFXPCP_H__)
#if defined(_x86_64)
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtCencParam                    ,Header                        ,0    )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtCencParam                    ,StatusReportIndex             ,8    )
#elif defined(_x86)
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtCencParam                    ,Header                        ,0    )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtCencParam                    ,StatusReportIndex             ,8    )
#endif
#endif //defined (__MFXPCP_H__)

// API version 2.1

// mfxdefs.h
MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxVariant ,16)
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxVariant, Version  ,0)
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxVariant, Type  ,4)
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxVariant, Data ,8)

MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxRange32U ,12)
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxRange32U, Min  ,0)
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxRange32U, Max  ,4)
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxRange32U, Step ,8)

// mfxcommon.h

#if defined(_x86_64)
#ifdef ONEVPL_EXPERIMENTAL
MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxDecExtDescription, 40)
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxDecExtDescription, Version, 0)
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxDecExtDescription, NumExtBufferIDs, 30)
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxDecExtDescription, ExtBufferIDs, 32)

MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxDecMemExtDescription, 40)
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxDecMemExtDescription, Version, 0)
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxDecMemExtDescription, MaxBitDepth, 28)
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxDecMemExtDescription, NumChromaSubsamplings, 30)
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxDecMemExtDescription, ChromaSubsamplings, 32)
#endif

MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxDecoderDescription              ,32    )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxDecoderDescription, Version  ,0)
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxDecoderDescription, NumCodecs  ,16)
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxDecoderDescription, Codecs ,24)

MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxDecoderDescription::decoder              ,32    )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxDecoderDescription::decoder, CodecID  ,0)
#ifdef ONEVPL_EXPERIMENTAL
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxDecoderDescription::decoder, DecExtDesc  ,8)
#endif
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxDecoderDescription::decoder, MaxcodecLevel  ,20)
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxDecoderDescription::decoder, NumProfiles ,22)
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxDecoderDescription::decoder, Profiles ,24)

MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxDecoderDescription::decoder::decprofile             ,32    )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxDecoderDescription::decoder::decprofile, Profile ,0)
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxDecoderDescription::decoder::decprofile, NumMemTypes ,18)
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxDecoderDescription::decoder::decprofile, MemDesc ,24)

MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxDecoderDescription::decoder::decprofile::decmemdesc              ,56    )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxDecoderDescription::decoder::decprofile::decmemdesc, MemHandleType  ,0)
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxDecoderDescription::decoder::decprofile::decmemdesc, Width  ,4)
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxDecoderDescription::decoder::decprofile::decmemdesc, Height ,16)
#ifdef ONEVPL_EXPERIMENTAL
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxDecoderDescription::decoder::decprofile::decmemdesc, MemExtDesc ,32)
#endif
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxDecoderDescription::decoder::decprofile::decmemdesc, NumColorFormats ,42)
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxDecoderDescription::decoder::decprofile::decmemdesc, ColorFormats ,48)
#elif defined(_x86)
#ifdef ONEVPL_EXPERIMENTAL
MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxDecExtDescription, 36)
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxDecExtDescription, Version, 0)
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxDecExtDescription, NumExtBufferIDs, 30)
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxDecExtDescription, ExtBufferIDs, 32)

MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxDecMemExtDescription, 36)
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxDecMemExtDescription, Version, 0)
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxDecMemExtDescription, MaxBitDepth, 28)
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxDecMemExtDescription, NumChromaSubsamplings, 30)
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxDecMemExtDescription, ChromaSubsamplings, 32)
#endif

MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxDecoderDescription              ,24    )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxDecoderDescription, Version  ,0)
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxDecoderDescription, NumCodecs  ,16)
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxDecoderDescription, Codecs ,20)

MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxDecoderDescription::decoder              ,28    )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxDecoderDescription::decoder, CodecID  ,0)
#ifdef ONEVPL_EXPERIMENTAL
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxDecoderDescription::decoder, DecExtDesc  ,8)
#endif
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxDecoderDescription::decoder, MaxcodecLevel  ,20)
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxDecoderDescription::decoder, NumProfiles ,22)
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxDecoderDescription::decoder, Profiles ,24)

MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxDecoderDescription::decoder::decprofile             ,24    )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxDecoderDescription::decoder::decprofile, Profile ,0)
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxDecoderDescription::decoder::decprofile, NumMemTypes ,18)
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxDecoderDescription::decoder::decprofile, MemDesc ,20)

MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxDecoderDescription::decoder::decprofile::decmemdesc              ,48    )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxDecoderDescription::decoder::decprofile::decmemdesc, MemHandleType  ,0)
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxDecoderDescription::decoder::decprofile::decmemdesc, Width  ,4)
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxDecoderDescription::decoder::decprofile::decmemdesc, Height ,16)
#ifdef ONEVPL_EXPERIMENTAL
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxDecoderDescription::decoder::decprofile::decmemdesc, MemExtDesc ,32)
#endif
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxDecoderDescription::decoder::decprofile::decmemdesc, NumColorFormats ,42)
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxDecoderDescription::decoder::decprofile::decmemdesc, ColorFormats ,44)
#endif

#if defined(_x86_64)
#ifdef ONEVPL_EXPERIMENTAL
MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxEncExtDescription, 64)
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxEncExtDescription, Version, 0)
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxEncExtDescription, NumRateControlMethods, 22)
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxEncExtDescription, RateControlMethods, 24)
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxEncExtDescription, NumExtBufferIDs, 54)
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxEncExtDescription, ExtBufferIDs, 56)

MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxEncMemExtDescription, 40)
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxEncMemExtDescription, Version, 0)
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxEncMemExtDescription, TargetMaxBitDepth, 28)
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxEncMemExtDescription, NumTargetChromaSubsamplings, 30)
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxEncMemExtDescription, TargetChromaSubsamplings, 32)
#endif

MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxEncoderDescription              ,32    )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxEncoderDescription, Version  ,0)
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxEncoderDescription, NumCodecs  ,16)
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxEncoderDescription, Codecs ,24)

MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxEncoderDescription::encoder              ,32    )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxEncoderDescription::encoder, CodecID  ,0)
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxEncoderDescription::encoder, MaxcodecLevel  ,4)
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxEncoderDescription::encoder, BiDirectionalPrediction  ,6)
#ifdef ONEVPL_EXPERIMENTAL
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxEncoderDescription::encoder, EncExtDesc  ,8)
#endif
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxEncoderDescription::encoder, NumProfiles ,22)
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxEncoderDescription::encoder, Profiles ,24)

MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxEncoderDescription::encoder::encprofile             ,32    )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxEncoderDescription::encoder::encprofile, Profile ,0)
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxEncoderDescription::encoder::encprofile, NumMemTypes ,18)
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxEncoderDescription::encoder::encprofile, MemDesc ,24)

MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxEncoderDescription::encoder::encprofile::encmemdesc              ,56    )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxEncoderDescription::encoder::encprofile::encmemdesc, MemHandleType  ,0)
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxEncoderDescription::encoder::encprofile::encmemdesc, Width  ,4)
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxEncoderDescription::encoder::encprofile::encmemdesc, Height ,16)
#ifdef ONEVPL_EXPERIMENTAL
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxEncoderDescription::encoder::encprofile::encmemdesc, MemExtDesc ,32)
#endif
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxEncoderDescription::encoder::encprofile::encmemdesc, NumColorFormats ,42)
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxEncoderDescription::encoder::encprofile::encmemdesc, ColorFormats ,48)
#elif defined(_x86)
#ifdef ONEVPL_EXPERIMENTAL
MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxEncExtDescription, 56)
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxEncExtDescription, Version, 0)
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxEncExtDescription, NumRateControlMethods, 22)
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxEncExtDescription, RateControlMethods, 24)
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxEncExtDescription, NumExtBufferIDs, 50)
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxEncExtDescription, ExtBufferIDs, 52)

MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxEncMemExtDescription, 36)
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxEncMemExtDescription, Version, 0)
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxEncMemExtDescription, TargetMaxBitDepth, 28)
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxEncMemExtDescription, NumTargetChromaSubsamplings, 30)
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxEncMemExtDescription, TargetChromaSubsamplings, 32)
#endif
MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxEncoderDescription              ,24    )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxEncoderDescription, Version  ,0)
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxEncoderDescription, NumCodecs  ,16)
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxEncoderDescription, Codecs ,20)

MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxEncoderDescription::encoder              ,28    )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxEncoderDescription::encoder, CodecID  ,0)
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxEncoderDescription::encoder, MaxcodecLevel  ,4)
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxEncoderDescription::encoder, BiDirectionalPrediction  ,6)
#ifdef ONEVPL_EXPERIMENTAL
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxEncoderDescription::encoder, EncExtDesc  ,8)
#endif
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxEncoderDescription::encoder, NumProfiles ,22)
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxEncoderDescription::encoder, Profiles ,24)

MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxEncoderDescription::encoder::encprofile             ,24    )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxEncoderDescription::encoder::encprofile, Profile ,0)
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxEncoderDescription::encoder::encprofile, NumMemTypes ,18)
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxEncoderDescription::encoder::encprofile, MemDesc ,20)

MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxEncoderDescription::encoder::encprofile::encmemdesc              ,48    )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxEncoderDescription::encoder::encprofile::encmemdesc, MemHandleType  ,0)
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxEncoderDescription::encoder::encprofile::encmemdesc, Width  ,4)
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxEncoderDescription::encoder::encprofile::encmemdesc, Height ,16)
#ifdef ONEVPL_EXPERIMENTAL
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxEncoderDescription::encoder::encprofile::encmemdesc, MemExtDesc ,32)
#endif
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxEncoderDescription::encoder::encprofile::encmemdesc, NumColorFormats ,42)
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxEncoderDescription::encoder::encprofile::encmemdesc, ColorFormats ,44)
#endif

#if defined(_x86_64)
MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxVPPDescription              ,32    )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxVPPDescription, Version  ,0)
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxVPPDescription, NumFilters  ,16)
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxVPPDescription, Filters ,24)

MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxVPPDescription::filter              ,32    )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxVPPDescription::filter, FilterFourCC  ,0)
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxVPPDescription::filter, MaxDelayInFrames  ,4)
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxVPPDescription::filter, NumMemTypes  ,20)
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxVPPDescription::filter, MemDesc ,24)

MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxVPPDescription::filter::memdesc     ,56    )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxVPPDescription::filter::memdesc, MemHandleType  ,0)
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxVPPDescription::filter::memdesc, Width  ,4)
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxVPPDescription::filter::memdesc, Height  ,16)
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxVPPDescription::filter::memdesc, NumInFormats  ,42)
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxVPPDescription::filter::memdesc, Formats  ,48)

MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxVPPDescription::filter::memdesc::format     ,24    )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxVPPDescription::filter::memdesc::format, InFormat  ,0)
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxVPPDescription::filter::memdesc::format, NumOutFormat  ,14)
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxVPPDescription::filter::memdesc::format, OutFormats  ,16)
#elif defined(_x86)
MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxVPPDescription              ,24    )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxVPPDescription, Version  ,0)
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxVPPDescription, NumFilters  ,16)
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxVPPDescription, Filters ,20)

MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxVPPDescription::filter              ,28    )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxVPPDescription::filter, FilterFourCC  ,0)
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxVPPDescription::filter, MaxDelayInFrames  ,4)
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxVPPDescription::filter, NumMemTypes  ,20)
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxVPPDescription::filter, MemDesc ,24)

MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxVPPDescription::filter::memdesc     ,48    )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxVPPDescription::filter::memdesc, MemHandleType  ,0)
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxVPPDescription::filter::memdesc, Width  ,4)
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxVPPDescription::filter::memdesc, Height  ,16)
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxVPPDescription::filter::memdesc, NumInFormats  ,42)
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxVPPDescription::filter::memdesc, Formats  ,44)

MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxVPPDescription::filter::memdesc::format     ,20    )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxVPPDescription::filter::memdesc::format, InFormat  ,0)
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxVPPDescription::filter::memdesc::format, NumOutFormat  ,14)
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxVPPDescription::filter::memdesc::format, OutFormats  ,16)
#endif

#if defined(_x86_64)
MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxDeviceDescription              ,160    )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxDeviceDescription, Version  ,0)
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxDeviceDescription, MediaAdapterType , 14)
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxDeviceDescription, DeviceID  ,16)
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxDeviceDescription, NumSubDevices ,144)
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxDeviceDescription, SubDevices ,152)

MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxDeviceDescription::subdevices              ,160    )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxDeviceDescription::subdevices, Index  ,0)
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxDeviceDescription::subdevices, SubDeviceID  ,4)

MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxAccelerationModeDescription              ,16    )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxAccelerationModeDescription, Version  ,0)
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxAccelerationModeDescription, NumAccelerationModes  ,6)
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxAccelerationModeDescription, Mode ,8)

MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxPoolPolicyDescription              ,16    )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxPoolPolicyDescription, Version  ,0)
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxPoolPolicyDescription, NumPoolPolicies  ,6)
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxPoolPolicyDescription, Policy ,8)
#elif defined(_x86)
MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxDeviceDescription              ,152    )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxDeviceDescription, Version  ,0)
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxDeviceDescription, MediaAdapterType , 14)
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxDeviceDescription, DeviceID  ,16)
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxDeviceDescription, NumSubDevices ,144)
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxDeviceDescription, SubDevices ,148)

MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxDeviceDescription::subdevices              ,160    )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxDeviceDescription::subdevices, Index  ,0)
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxDeviceDescription::subdevices, SubDeviceID  ,4)

MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxAccelerationModeDescription              ,12    )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxAccelerationModeDescription, Version  ,0)
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxAccelerationModeDescription, NumAccelerationModes  ,6)
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxAccelerationModeDescription, Mode ,8)

MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxPoolPolicyDescription              ,12    )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxPoolPolicyDescription, Version  ,0)
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxPoolPolicyDescription, NumPoolPolicies  ,6)
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxPoolPolicyDescription, Policy ,8)
#endif

#if defined(_x86_64)
MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxImplDescription              ,648    )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxImplDescription, Version  ,0)
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxImplDescription, Impl  ,4)
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxImplDescription, AccelerationMode  ,8)
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxImplDescription, ApiVersion  ,12)
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxImplDescription, ImplName  ,16)
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxImplDescription, License  ,48)
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxImplDescription, Keywords  ,176)
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxImplDescription, VendorID  ,304)
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxImplDescription, VendorImplID  ,308)
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxImplDescription, Dev  ,312)
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxImplDescription, Dec  ,472)
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxImplDescription, Enc  ,504)
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxImplDescription, VPP  ,536)
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxImplDescription, AccelerationModeDescription  ,568)
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxImplDescription, PoolPolicies, 584)
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxImplDescription, NumExtParam  ,632)
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxImplDescription, ExtParams  ,640)

MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxInitializationParam ,40)
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxInitializationParam, AccelerationMode, 0)
#ifdef ONEVPL_EXPERIMENTAL
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxInitializationParam, DeviceCopy,       4)
#endif
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxInitializationParam, NumExtParam,     10)
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxInitializationParam, ExtParam,        16)
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxInitializationParam, VendorImplID,    24)

#ifdef ONEVPL_EXPERIMENTAL
MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxQueryProperty       ,24)
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxQueryProperty, PropName, 0)
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxQueryProperty, PropVar,  8)
#endif
#elif defined(_x86)
MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxImplDescription              ,608    )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxImplDescription, Version  ,0)
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxImplDescription, Impl  ,4)
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxImplDescription, AccelerationMode  ,8)
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxImplDescription, ApiVersion  ,12)
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxImplDescription, ImplName  ,16)
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxImplDescription, License  ,48)
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxImplDescription, Keywords  ,176)
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxImplDescription, VendorID  ,304)
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxImplDescription, VendorImplID  ,308)
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxImplDescription, Dev  ,312)
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxImplDescription, Dec  ,464)
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxImplDescription, Enc  ,488)
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxImplDescription, VPP  ,512)
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxImplDescription, AccelerationModeDescription  ,536)
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxImplDescription, PoolPolicies, 552)
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxImplDescription, NumExtParam  ,596)
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxImplDescription, ExtParams  ,600)

MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxInitializationParam ,32)
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxInitializationParam, AccelerationMode, 0)
#ifdef ONEVPL_EXPERIMENTAL
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxInitializationParam, DeviceCopy,       4)
#endif
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxInitializationParam, NumExtParam,     10)
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxInitializationParam, ExtParam,        12)
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxInitializationParam, VendorImplID,    16)

#ifdef ONEVPL_EXPERIMENTAL
MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxQueryProperty       ,20)
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxQueryProperty, PropName, 0)
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxQueryProperty, PropVar,  4)
#endif
#endif

// mfxstructures.h

#if defined(_x86_64)
MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxFrameSurfaceInterface ,112)
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxFrameSurfaceInterface, Context  ,0)
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxFrameSurfaceInterface, Version  ,8)
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxFrameSurfaceInterface, AddRef ,16)
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxFrameSurfaceInterface, Release ,24)
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxFrameSurfaceInterface, GetRefCounter ,32)
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxFrameSurfaceInterface, Map ,40)
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxFrameSurfaceInterface, Unmap ,48)
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxFrameSurfaceInterface, GetNativeHandle ,56)
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxFrameSurfaceInterface, GetDeviceHandle ,64)
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxFrameSurfaceInterface, Synchronize ,72)
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxFrameSurfaceInterface, OnComplete ,80)
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxFrameSurfaceInterface, QueryInterface ,88)
#ifdef ONEVPL_EXPERIMENTAL
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxFrameSurfaceInterface, Export ,96)
#endif
#elif defined(_x86)
MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxFrameSurfaceInterface ,60)
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxFrameSurfaceInterface, Context  ,0)
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxFrameSurfaceInterface, Version  ,4)
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxFrameSurfaceInterface, AddRef ,12)
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxFrameSurfaceInterface, Release ,16)
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxFrameSurfaceInterface, GetRefCounter ,20)
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxFrameSurfaceInterface, Map ,24)
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxFrameSurfaceInterface, Unmap ,28)
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxFrameSurfaceInterface, GetNativeHandle ,32)
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxFrameSurfaceInterface, GetDeviceHandle ,36)
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxFrameSurfaceInterface, Synchronize ,40)
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxFrameSurfaceInterface, OnComplete ,44)
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxFrameSurfaceInterface, QueryInterface ,48)
#ifdef ONEVPL_EXPERIMENTAL
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxFrameSurfaceInterface, Export ,52)
#endif
#endif

#if defined(_x86_64)
MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxExtDeviceAffinityMask ,168)
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtDeviceAffinityMask, Header  ,0)
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtDeviceAffinityMask, DeviceID  ,8)
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtDeviceAffinityMask, NumSubDevices ,136)
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtDeviceAffinityMask, Mask ,144)

MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxSurfaceArray ,56)
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxSurfaceArray, Context  ,0)
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxSurfaceArray, Version  ,8)
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxSurfaceArray, AddRef ,16)
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxSurfaceArray, Release ,24)
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxSurfaceArray, GetRefCounter ,32)
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxSurfaceArray, Surfaces ,40)
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxSurfaceArray, NumSurfaces ,48)

MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxVideoChannelParam ,96)
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxVideoChannelParam, VPP  ,0)
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxVideoChannelParam, Protected  ,68)
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxVideoChannelParam, IOPattern ,70)
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxVideoChannelParam, ExtParam ,72)
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxVideoChannelParam, NumExtParam ,80)
#elif defined(_x86)
MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxExtDeviceAffinityMask ,160)
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtDeviceAffinityMask, Header  ,0)
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtDeviceAffinityMask, DeviceID  ,8)
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtDeviceAffinityMask, NumSubDevices ,136)
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtDeviceAffinityMask, Mask ,140)

MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxSurfaceArray ,36)
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxSurfaceArray, Context  ,0)
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxSurfaceArray, Version  ,4)
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxSurfaceArray, AddRef ,12)
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxSurfaceArray, Release ,16)
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxSurfaceArray, GetRefCounter ,20)
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxSurfaceArray, Surfaces ,24)
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxSurfaceArray, NumSurfaces ,28)

MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxVideoChannelParam ,92)
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxVideoChannelParam, VPP  ,0)
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxVideoChannelParam, Protected  ,68)
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxVideoChannelParam, IOPattern ,70)
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxVideoChannelParam, ExtParam ,72)
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxVideoChannelParam, NumExtParam ,76)
#endif

MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxRect ,8)
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxRect, Left  ,0)
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxRect, Top  ,2)
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxRect, Right ,4)
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxRect, Bottom ,6)

MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxExtInCrops ,32)
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtInCrops, Header  ,0)
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtInCrops, Crops  ,8)

#if defined(_x86_64)
MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxImplementedFunctions, 16)
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxImplementedFunctions, NumFunctions, 0)
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxImplementedFunctions, FunctionsName, 8)
#elif defined(_x86)
MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxImplementedFunctions, 8)
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxImplementedFunctions, NumFunctions, 0)
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxImplementedFunctions, FunctionsName, 4)
#endif

MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxExtHyperModeParam, 52)
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtHyperModeParam, Header, 0)
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtHyperModeParam, Mode, 8)

MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxExtAllocationHints ,44)
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtAllocationHints, Header  ,0)
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtAllocationHints, AllocationPolicy  ,8)
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtAllocationHints, NumberToPreAllocate ,12)
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtAllocationHints, DeltaToAllocateOnTheFly ,16)
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtAllocationHints, VPPPoolType ,20)
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtAllocationHints, Wait ,24)

#if defined(_x86_64)
MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxSurfacePoolInterface ,104)
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxSurfacePoolInterface, Context  ,0)
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxSurfacePoolInterface, AddRef  ,8)
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxSurfacePoolInterface, Release ,16)
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxSurfacePoolInterface, GetRefCounter ,24)
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxSurfacePoolInterface, SetNumSurfaces ,32)
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxSurfacePoolInterface, RevokeSurfaces ,40)
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxSurfacePoolInterface, GetAllocationPolicy ,48)
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxSurfacePoolInterface, GetMaximumPoolSize ,56)
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxSurfacePoolInterface, GetCurrentPoolSize ,64)
#elif defined(_x86)
MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxSurfacePoolInterface ,52)
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxSurfacePoolInterface, Context  ,0)
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxSurfacePoolInterface, AddRef  ,4)
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxSurfacePoolInterface, Release ,8)
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxSurfacePoolInterface, GetRefCounter ,12)
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxSurfacePoolInterface, SetNumSurfaces ,16)
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxSurfacePoolInterface, RevokeSurfaces ,20)
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxSurfacePoolInterface, GetAllocationPolicy ,24)
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxSurfacePoolInterface, GetMaximumPoolSize ,28)
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxSurfacePoolInterface, GetCurrentPoolSize ,32)
#endif

MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxExtAV1BitstreamParam, 72)
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtAV1BitstreamParam, Header         , 0)
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtAV1BitstreamParam, WriteIVFHeaders, 8)

MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxExtAV1ResolutionParam, 40)
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtAV1ResolutionParam, Header     , 0)
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtAV1ResolutionParam, FrameWidth , 8)
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtAV1ResolutionParam, FrameHeight, 12)

MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxExtAV1TileParam, 24)
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtAV1TileParam, Header        , 0)
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtAV1TileParam, NumTileRows   , 8)
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtAV1TileParam, NumTileColumns, 10)
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtAV1TileParam, NumTileGroups , 12)

MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxTemporalLayer ,96)
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxTemporalLayer, FrameRateScale     , 0)
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxTemporalLayer, InitialDelayInKB   , 8)
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxTemporalLayer, BufferSizeInKB     , 12)
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxTemporalLayer, TargetKbps         , 16)
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxTemporalLayer, MaxKbps            , 20)
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxTemporalLayer, QPI                , 8)
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxTemporalLayer, QPP                , 12)
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxTemporalLayer, QPB                , 16)

#if defined(_x86_64)
MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxExtTemporalLayers         ,40)
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtTemporalLayers, Header       , 0)
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtTemporalLayers, NumLayers    , 8)
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtTemporalLayers, BaseLayerPID , 10)
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtTemporalLayers, Layers       , 16)

MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxAV1SegmentParam, 64)
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxAV1SegmentParam, FeatureEnabled, 0)
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxAV1SegmentParam, AltQIndex     , 2)

MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxExtAV1Segmentation, 616)
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtAV1Segmentation, Header            , 0)
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtAV1Segmentation, NumSegments       , 8)
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtAV1Segmentation, Segment           , 12)
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtAV1Segmentation, SegmentIdBlockSize, 524)
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtAV1Segmentation, NumSegmentIdAlloc , 528)
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtAV1Segmentation, SegmentIds        , 536)
#elif defined(_x86)
MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxExtTemporalLayers         ,36)
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtTemporalLayers, Header       , 0)
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtTemporalLayers, NumLayers    , 8)
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtTemporalLayers, BaseLayerPID , 10)
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtTemporalLayers, Layers       , 16)

MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxAV1SegmentParam, 64)
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxAV1SegmentParam, FeatureEnabled, 0)
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxAV1SegmentParam, AltQIndex     , 2)

MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxExtAV1Segmentation, 608)
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtAV1Segmentation, Header            , 0)
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtAV1Segmentation, NumSegments       , 8)
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtAV1Segmentation, Segment           , 12)
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtAV1Segmentation, SegmentIdBlockSize, 524)
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtAV1Segmentation, NumSegmentIdAlloc , 528)
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtAV1Segmentation, SegmentIds        , 532)
#endif

#ifdef ONEVPL_EXPERIMENTAL
MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxExtendedDeviceId, 196)
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtendedDeviceId, Version,             0)
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtendedDeviceId, VendorID,            2)
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtendedDeviceId, DeviceID,            4)
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtendedDeviceId, PCIDomain,           8)
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtendedDeviceId, PCIBus,             12)
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtendedDeviceId, PCIDevice,          16)
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtendedDeviceId, PCIFunction,        20)
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtendedDeviceId, DeviceLUID,         24)
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtendedDeviceId, LUIDDeviceNodeMask, 32)
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtendedDeviceId, LUIDValid,          36)
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtendedDeviceId, DRMRenderNodeNum,   40)
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtendedDeviceId, DRMPrimaryNodeNum,  44)
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtendedDeviceId, RevisionID,         48)
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtendedDeviceId, DeviceName,         68)

MSDK_STATIC_ASSERT_STRUCT_SIZE(extDeviceUUID, 16)
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(extDeviceUUID, vendor_id,                   0)
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(extDeviceUUID, device_id,                   2)
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(extDeviceUUID, revision_id,                 4)
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(extDeviceUUID, pci_domain,                  6)
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(extDeviceUUID, pci_bus,                     8)
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(extDeviceUUID, pci_dev,                     9)
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(extDeviceUUID, pci_func,                   10)
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(extDeviceUUID, sub_device_id,              15)


MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxCTUHeader, 12)
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxCTUHeader, dword0,         0)
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxCTUHeader, CurrXAddr,      4)
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxCTUHeader, CurrYAddr,      6)

MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxCUInfo, 76)
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxCUInfo, dword0,         0)
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxCUInfo, dword1,         4)
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxCUInfo, QP,             8)
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxCUInfo, SAD,            12)
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxCUInfo, MV,             16)
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxCUInfo, dword8,         32)

MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxCTUInfo, 4880)
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxCTUInfo, CtuHeader,      0)
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxCTUInfo, CuInfo,         12)

MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxMBInfo, 24)
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxMBInfo, dword0,      0)
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxMBInfo, SAD,         4)
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxMBInfo, Qp,          8)
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxMBInfo, LumaIntraMode, 12)


#if defined(_x86_64)
MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxEncodeBlkStats, 48)
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxEncodeBlkStats, NumMB,      0)
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxEncodeBlkStats, NumCTU,     0)
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxEncodeBlkStats, HEVCCTUArray,          8)
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxEncodeBlkStats, AVCMBArray,            8)


MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxEncodeHighLevelStats, 80)     
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxEncodeHighLevelStats, PSNRLuma,      0)
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxEncodeHighLevelStats, PSNRCb,     4)
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxEncodeHighLevelStats, PSNRCr,          8)
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxEncodeHighLevelStats, SADLuma,            16)
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxEncodeHighLevelStats, Qp,       24)
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxEncodeHighLevelStats, NumMB,    28)
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxEncodeHighLevelStats, NumCTU,   28)
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxEncodeHighLevelStats, BlockSize,  32)
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxEncodeHighLevelStats, NumIntraBlock,       36)
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxEncodeHighLevelStats, NumInterBlock,    40)
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxEncodeHighLevelStats, NumSkippedBlock,   44)

MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxEncodeSliceStats , 48)
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxEncodeSliceStats, NumElements,                 0)
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxEncodeSliceStats, HighLevelStatsArray,         8)

MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxEncodeStatsContainer, 208)
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxEncodeStatsContainer, Version,      0)
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxEncodeStatsContainer, RefInterface,    8)
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxEncodeStatsContainer, SynchronizeStatistics,          80)
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxEncodeStatsContainer, SynchronizeBitstream,           88)
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxEncodeStatsContainer, DisplayOrder,                   136)
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxEncodeStatsContainer, MemLayout,                      140)
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxEncodeStatsContainer, EncodeBlkStats,           144)
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxEncodeStatsContainer, EncodeSliceStats,         152)
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxEncodeStatsContainer, EncodeTileStats,          160)
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxEncodeStatsContainer, EncodeFrameStats,         168)
 
MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxRefInterface , 72)
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxRefInterface, Context,         0)
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxRefInterface, Version,         8)
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxRefInterface, AddRef,          16)
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxRefInterface, Release,         24)
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxRefInterface, GetRefCounter,   32)
 
#elif defined(_x86)
MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxEncodeBlkStats, 40)
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxEncodeBlkStats, NumMB,      0)
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxEncodeBlkStats, NumCTU,     0)
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxEncodeBlkStats, HEVCCTUArray,          4)
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxEncodeBlkStats, AVCMBArray,            4)

MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxEncodeHighLevelStats, 80)     
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxEncodeHighLevelStats, PSNRLuma,      0)
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxEncodeHighLevelStats, PSNRCb,     4)
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxEncodeHighLevelStats, PSNRCr,          8)
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxEncodeHighLevelStats, SADLuma,            16)
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxEncodeHighLevelStats, Qp,       24)
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxEncodeHighLevelStats, NumMB,    28)
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxEncodeHighLevelStats, NumCTU,   28)
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxEncodeHighLevelStats, BlockSize,  32)
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxEncodeHighLevelStats, NumIntraBlock,       36)
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxEncodeHighLevelStats, NumInterBlock,    40)
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxEncodeHighLevelStats, NumSkippedBlock,   44)

MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxEncodeSliceStats , 40)
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxEncodeSliceStats, NumElements,                 0)
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxEncodeSliceStats, HighLevelStatsArray,         4)

MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxEncodeStatsContainer, 128)
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxEncodeStatsContainer, Version,      0)
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxEncodeStatsContainer, RefInterface,    4)
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxEncodeStatsContainer, SynchronizeStatistics,          40)
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxEncodeStatsContainer, SynchronizeBitstream,           44)
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxEncodeStatsContainer, DisplayOrder,                   72)
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxEncodeStatsContainer, MemLayout,                      76)
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxEncodeStatsContainer, EncodeBlkStats,           80)
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxEncodeStatsContainer, EncodeSliceStats,         84)
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxEncodeStatsContainer, EncodeTileStats,          88)
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxEncodeStatsContainer, EncodeFrameStats,         92)

MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxRefInterface , 36)
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxRefInterface, Context,         0)
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxRefInterface, Version,         4)
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxRefInterface, AddRef,          8)
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxRefInterface, Release,         12)
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxRefInterface, GetRefCounter,   16)
 
#endif

#endif

#ifdef ONEVPL_EXPERIMENTAL

#if defined(_x86_64)
MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxExtEncodeStatsOutput, 56)
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtEncodeStatsOutput, Header, 0)
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtEncodeStatsOutput, EncodeStatsFlags, 8)
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtEncodeStatsOutput, Mode, 12)
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtEncodeStatsOutput, EncodeStatsContainer, 16)
#elif defined(_x86)
MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxExtEncodeStatsOutput, 52)
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtEncodeStatsOutput, Header, 0)
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtEncodeStatsOutput, EncodeStatsFlags, 8)
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtEncodeStatsOutput, Mode, 12)
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtEncodeStatsOutput, EncodeStatsContainer, 16)
#endif

#endif

#ifdef ONEVPL_EXPERIMENTAL
MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxExtVPPPercEncPrefilter, 512)
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtVPPPercEncPrefilter, Header, 0)
#endif

#ifdef ONEVPL_EXPERIMENTAL
#if defined(_x86_64)
MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxExtTuneEncodeQuality, 48)
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtTuneEncodeQuality, Header,          0)
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtTuneEncodeQuality, TuneQuality,     8)
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtTuneEncodeQuality, ExtParam,       16)
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtTuneEncodeQuality, NumExtParam,    24)
#elif defined(_x86)
MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxExtTuneEncodeQuality, 40)
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtTuneEncodeQuality, Header,          0)
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtTuneEncodeQuality, TuneQuality,     8)
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtTuneEncodeQuality, ExtParam,       12)
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtTuneEncodeQuality, NumExtParam,    16)
#endif
#endif

#if defined(_x86_64)
MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxConfigInterface, 152)
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxConfigInterface, Context,                        0)
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxConfigInterface, Version,                        8)
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxConfigInterface, SetParameter,                  16)
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxConfigInterface, reserved,                      24)
#elif defined(_x86)
MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxConfigInterface, 76)
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxConfigInterface, Context,                        0)
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxConfigInterface, Version,                        4)
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxConfigInterface, SetParameter,                   8)
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxConfigInterface, reserved,                      12)
#endif

MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxExtQualityInfoMode, 32)
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtQualityInfoMode, Header,                      0)
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtQualityInfoMode, QualityInfoMode,             8)
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtQualityInfoMode, reserved,                    12)
#if defined(_x86_64)
MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxExtQualityInfoOutput, 256)
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtQualityInfoOutput, Header,                    0)
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtQualityInfoOutput, FrameOrder,                8)
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtQualityInfoOutput, MSE,                       12)
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtQualityInfoOutput, reserved1,                 24)
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtQualityInfoOutput, reserved2,                 224)
#elif defined(_x86)
MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxExtQualityInfoOutput, 240)
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtQualityInfoOutput, Header,                    0)
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtQualityInfoOutput, FrameOrder,                8)
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtQualityInfoOutput, MSE,                       12)
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtQualityInfoOutput, reserved1,                 24)
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtQualityInfoOutput, reserved2,                 224)
#endif

MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxExtAV1ScreenContentTools, 32)
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtAV1ScreenContentTools, Header,                0)
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtAV1ScreenContentTools, Palette,               8)
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtAV1ScreenContentTools, IntraBlockCopy,        10)
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtAV1ScreenContentTools, reserved,              12)

MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxExtAlphaChannelEncCtrl, 32)
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtAlphaChannelEncCtrl, Header,                     0)
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtAlphaChannelEncCtrl, EnableAlphaChannelEncoding, 8)
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtAlphaChannelEncCtrl, AlphaChannelMode,           10)
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtAlphaChannelEncCtrl, AlphaChannelBitrateRatio,   12)
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtAlphaChannelEncCtrl, reserved,                   14)
#if defined(_x86_64)
MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxExtAlphaChannelSurface, 32)
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtAlphaChannelSurface, Header,                     0)
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtAlphaChannelSurface, AlphaSurface,               8)
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtAlphaChannelSurface, reserved,                   16)
#elif defined(_x86)
MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxExtAlphaChannelSurface, 28)
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtAlphaChannelSurface, Header,                     0)
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtAlphaChannelSurface, AlphaSurface,               8)
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtAlphaChannelSurface, reserved,                   12)
#endif

#ifdef ONEVPL_EXPERIMENTAL
MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxExtAIEncCtrl, 64)
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtAIEncCtrl, Header,               0)
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtAIEncCtrl, SaliencyEncoder,      8)
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtAIEncCtrl, AdaptiveTargetUsage,  10)
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtAIEncCtrl, reserved,             12)
#endif

#ifdef ONEVPL_EXPERIMENTAL
// The solution for compiler-time check of bitfields. Requires C++20 and supported only by latest MSVC. 
// Disabled for now.
#if (_MSC_VER >= 1929) && defined(MFX_ASSERT_BITFIELD_CMPL_TIME)
#include <bit>

#define MSDK_STATIC_ASSERT_STRUCT_BITFIELD(STRUCT, BITFIELD, PATTERN) \
constexpr STRUCT var = [](){ \
    STRUCT var;              \
    var.BITFIELD = 0xFFFFFFFF;     \
    return var;
}(); \
MSDK_STATIC_ASSERT(std::bit_cast<uint32_t>(var) == PATTERN, "ABI violation in "#STRUCT"."#BITFIELD" "); 
#endif 

#define MSDK_BITFIELD_ASSERT_CHECK(STRUCT, BITFIELD, DWORD, PATTERN, STS) \
        { \
           STRUCT var = {0}; \
           var.BITFIELD = 0xFFFFFFFF; \
           if (var.DWORD != PATTERN) { \
               printf(" ABI violation in "#STRUCT"."#BITFIELD", current pattern is %x \n", var.DWORD);\
               STS |= 1; \
           } \
        }

#endif

// API version 2.8
// mfxcamera.h
#ifdef ONEVPL_EXPERIMENTAL
MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxExtCamWhiteBalance                     ,76    )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtCamWhiteBalance, Header, 0  )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtCamWhiteBalance, Mode,   8  )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtCamWhiteBalance, R,      12 )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtCamWhiteBalance, G0,     20)
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtCamWhiteBalance, B,      28)
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtCamWhiteBalance, G1,     36)
MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxExtCamTotalColorControl                ,32    )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtCamTotalColorControl, Header, 0  )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtCamTotalColorControl, R,      8  )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtCamTotalColorControl, G,      10 )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtCamTotalColorControl, B,      12 )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtCamTotalColorControl, C,      14 )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtCamTotalColorControl, M,      16 )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtCamTotalColorControl, Y,      18 )
MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxExtCamCscYuvRgb                        ,128   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtCamCscYuvRgb, Header, 0  )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtCamCscYuvRgb, PreOffset[0],   8  )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtCamCscYuvRgb, Matrix[0],      20 )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtCamCscYuvRgb, PostOffset[0],  56 ) // 9*4 + 20
MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxExtCamHotPixelRemoval                  ,76    )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtCamHotPixelRemoval, Header, 0  )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtCamHotPixelRemoval, PixelThresholdDifference,   8  )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtCamHotPixelRemoval, PixelCountThreshold,        10 ) //12+64
MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxExtCamBlackLevelCorrection             ,32    )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtCamBlackLevelCorrection, Header, 0  )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtCamBlackLevelCorrection, R,      8  )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtCamBlackLevelCorrection, G0,     10 )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtCamBlackLevelCorrection, B,      12 )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtCamBlackLevelCorrection, G1,     14 )
MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxCamVignetteCorrectionElement           ,8     )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxCamVignetteCorrectionElement, integer, 0)
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxCamVignetteCorrectionElement, mantissa,1)
MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxCamVignetteCorrectionParam             ,48    )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxCamVignetteCorrectionParam, R,  0)
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxCamVignetteCorrectionParam, G0, 8)
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxCamVignetteCorrectionParam, B,  16)
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxCamVignetteCorrectionParam, G1, 24)
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxCamVignetteCorrectionParam, reserved, 32) // 32+4*4
MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxExtCamVignetteCorrection, 56)
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtCamVignetteCorrection, Header, 0)
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtCamVignetteCorrection, Width, 8)
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtCamVignetteCorrection, Height, 12)
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtCamVignetteCorrection, Pitch,  16)  // 20 + 28
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtCamVignetteCorrection, CorrectionMap,  48)
MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxExtCamBayerDenoise                     ,64    )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtCamBayerDenoise, Header, 0)
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtCamBayerDenoise, Threshold, 8)
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtCamBayerDenoise, reserved, 10) // 27*2 + 10
MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxExtCamColorCorrection3x3               ,172   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtCamColorCorrection3x3, Header, 0)
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtCamColorCorrection3x3, CCM,    8)
MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxExtCamPadding                          ,32    )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtCamPadding, Header, 0)
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtCamPadding, Top,    8)
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtCamPadding, Bottom, 10)
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtCamPadding, Left,   12)
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtCamPadding, Right,  14)
MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxExtCamPipeControl                     ,32    )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtCamPipeControl, Header,    0)
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtCamPipeControl, RawFormat, 8)
MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxCamFwdGammaSegment                     ,8     )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxCamFwdGammaSegment, Pixel, 0)
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxCamFwdGammaSegment, Red,   2)
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxCamFwdGammaSegment, Green, 4)
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxCamFwdGammaSegment, Blue,  6)
MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxExtCamFwdGamma                         ,56    )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtCamFwdGamma, Header,   0)
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtCamFwdGamma, reserved, 8)
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtCamFwdGamma, NumSegments, 46) // 8+19*2
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtCamFwdGamma, Segment, 48)
MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxExtCamLensGeomDistCorrection           ,128   )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtCamLensGeomDistCorrection, Header, 0)
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtCamLensGeomDistCorrection, a[0], 8)
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtCamLensGeomDistCorrection, b[0], 20)
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtCamLensGeomDistCorrection, c[0], 32)
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtCamLensGeomDistCorrection, d[0], 44)
MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxCam3DLutEntry                          ,8     )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxCam3DLutEntry, R, 0)
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxCam3DLutEntry, G, 2)
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxCam3DLutEntry, B, 4)
MSDK_STATIC_ASSERT_STRUCT_SIZE(mfxExtCam3DLut                            ,40    )
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtCam3DLut, Header, 0)
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtCam3DLut, reserved, 8)
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtCam3DLut, Size, 28)
    MSDK_STATIC_ASSERT_STRUCT_OFFSET(mfxExtCam3DLut, Table, 32)
#endif

int main()
{
    printf("Test of API has been started.\n");
#ifdef ONEVPL_EXPERIMENTAL
    int sts = 0;
    /* mfxCTUHeader. */
    MSDK_BITFIELD_ASSERT_CHECK(mfxCTUHeader, bitfields0.CUcountminus1, dword0, 0x3F, sts);
    MSDK_BITFIELD_ASSERT_CHECK(mfxCTUHeader, bitfields0.MaxDepth, dword0, 0xC0, sts);

    /* mfxCUInfo. */
    MSDK_BITFIELD_ASSERT_CHECK(mfxCUInfo, bitfields0.CU_Size, dword0, 0x3, sts);
    MSDK_BITFIELD_ASSERT_CHECK(mfxCUInfo, bitfields0.CU_pred_mode, dword0, 0x4, sts);
    MSDK_BITFIELD_ASSERT_CHECK(mfxCUInfo, bitfields0.CU_part_mode, dword0, 0x38, sts);
    MSDK_BITFIELD_ASSERT_CHECK(mfxCUInfo, bitfields0.InterPred_IDC_MV0, dword0, 0xC0, sts);
    MSDK_BITFIELD_ASSERT_CHECK(mfxCUInfo, bitfields0.InterPred_IDC_MV1, dword0, 0x300, sts);
    MSDK_BITFIELD_ASSERT_CHECK(mfxCUInfo, bitfields0.LumaIntraMode, dword0, 0xFC00, sts);
    MSDK_BITFIELD_ASSERT_CHECK(mfxCUInfo, bitfields0.ChromaIntraMode, dword0, 0x70000, sts);

    MSDK_BITFIELD_ASSERT_CHECK(mfxCUInfo, bitfields1.LumaIntraMode4x4_1, dword1, 0x3F, sts);
    MSDK_BITFIELD_ASSERT_CHECK(mfxCUInfo, bitfields1.LumaIntraMode4x4_2, dword1, 0xFC0, sts);
    MSDK_BITFIELD_ASSERT_CHECK(mfxCUInfo, bitfields1.LumaIntraMode4x4_3, dword1, 0x3F000, sts);

    MSDK_BITFIELD_ASSERT_CHECK(mfxCUInfo, bitfields8.L0_MV0_RefID, dword8, 0xF, sts);
    MSDK_BITFIELD_ASSERT_CHECK(mfxCUInfo, bitfields8.L0_MV1_RefID, dword8, 0xF0, sts);
    MSDK_BITFIELD_ASSERT_CHECK(mfxCUInfo, bitfields8.L1_MV0_RefID, dword8, 0xF00, sts);
    MSDK_BITFIELD_ASSERT_CHECK(mfxCUInfo, bitfields8.L1_MV1_RefID, dword8, 0xF000, sts);

    /* mfxMBInfo. */
    MSDK_BITFIELD_ASSERT_CHECK(mfxMBInfo, bitfields0.MBType, dword0, 0x1F, sts);
    MSDK_BITFIELD_ASSERT_CHECK(mfxMBInfo, bitfields0.InterMBMode, dword0, 0x60, sts);
    MSDK_BITFIELD_ASSERT_CHECK(mfxMBInfo, bitfields0.IntraMBMode, dword0, 0x180, sts);
    MSDK_BITFIELD_ASSERT_CHECK(mfxMBInfo, bitfields0.IntraMBFlag, dword0, 0x200, sts);
    MSDK_BITFIELD_ASSERT_CHECK(mfxMBInfo, bitfields0.SubMBShapes, dword0, 0x3FC00, sts);
    MSDK_BITFIELD_ASSERT_CHECK(mfxMBInfo, bitfields0.SubMBShapeMode, dword0, 0x3FC0000, sts);
    MSDK_BITFIELD_ASSERT_CHECK(mfxMBInfo, bitfields0.ChromaIntraPredMode, dword0, 0xC000000, sts);

    printf("...Done with experimental API.\n");

    return sts;


#endif

    printf("...Done without experimental API.\n");

    return 0;
}
