/* map-file.c generated by valac 0.40.8, the Vala compiler
 * generated from map-file.vala, do not modify */

/*
 * Copyright (C) 2011-2018 Daiki Ueno <ueno@gnu.org>
 * Copyright (C) 2011-2018 Red Hat, Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */


#include <glib.h>
#include <glib-object.h>
#include <gee.h>
#include <stdlib.h>
#include <string.h>
#include <json-glib/json-glib.h>


#define SKK_TYPE_MAP_FILE (skk_map_file_get_type ())
#define SKK_MAP_FILE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SKK_TYPE_MAP_FILE, SkkMapFile))
#define SKK_MAP_FILE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SKK_TYPE_MAP_FILE, SkkMapFileClass))
#define SKK_IS_MAP_FILE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SKK_TYPE_MAP_FILE))
#define SKK_IS_MAP_FILE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SKK_TYPE_MAP_FILE))
#define SKK_MAP_FILE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SKK_TYPE_MAP_FILE, SkkMapFileClass))

typedef struct _SkkMapFile SkkMapFile;
typedef struct _SkkMapFileClass SkkMapFileClass;
typedef struct _SkkMapFilePrivate SkkMapFilePrivate;
enum  {
	SKK_MAP_FILE_0_PROPERTY,
	SKK_MAP_FILE_NUM_PROPERTIES
};
static GParamSpec* skk_map_file_properties[SKK_MAP_FILE_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define __vala_JsonNode_free0(var) ((var == NULL) ? NULL : (var = (_vala_JsonNode_free (var), NULL)))

#define SKK_TYPE_RULE_METADATA (skk_rule_metadata_get_type ())
typedef struct _SkkRuleMetadata SkkRuleMetadata;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _json_object_unref0(var) ((var == NULL) ? NULL : (var = (json_object_unref (var), NULL)))
#define _skk_rule_metadata_free0(var) ((var == NULL) ? NULL : (var = (skk_rule_metadata_free (var), NULL)))
#define _json_array_unref0(var) ((var == NULL) ? NULL : (var = (json_array_unref (var), NULL)))

struct _SkkMapFile {
	GObject parent_instance;
	SkkMapFilePrivate * priv;
};

struct _SkkMapFileClass {
	GObjectClass parent_class;
};

struct _SkkMapFilePrivate {
	GeeMap* maps;
};

struct _SkkRuleMetadata {
	gchar* base_dir;
	gchar* name;
	gchar* label;
	gchar* description;
	gchar* filter;
};

typedef enum  {
	SKK_RULE_PARSE_ERROR_FAILED
} SkkRuleParseError;
#define SKK_RULE_PARSE_ERROR skk_rule_parse_error_quark ()

static gpointer skk_map_file_parent_class = NULL;

GType skk_map_file_get_type (void) G_GNUC_CONST;
#define SKK_MAP_FILE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), SKK_TYPE_MAP_FILE, SkkMapFilePrivate))
static void skk_map_file_load_map (SkkMapFile* self,
                            GeeMap* map,
                            JsonObject* object);
static JsonNode* _vala_JsonNode_copy (JsonNode* self);
static void _vala_JsonNode_free (JsonNode* self);
GType skk_rule_metadata_get_type (void) G_GNUC_CONST;
SkkRuleMetadata* skk_rule_metadata_dup (const SkkRuleMetadata* self);
void skk_rule_metadata_free (SkkRuleMetadata* self);
void skk_rule_metadata_copy (const SkkRuleMetadata* self,
                             SkkRuleMetadata* dest);
void skk_rule_metadata_destroy (SkkRuleMetadata* self);
GQuark skk_rule_parse_error_quark (void);
static void skk_map_file_load (SkkMapFile* self,
                        SkkRuleMetadata* metadata,
                        const gchar* type,
                        const gchar* name,
                        GeeSet* included,
                        GError** error);
gchar* skk_rule_metadata_locate_map_file (SkkRuleMetadata *self,
                                          const gchar* type,
                                          const gchar* name);
SkkRuleMetadata* skk_rule_find_rule (const gchar* name);
SkkMapFile* skk_map_file_construct (GType object_type,
                                    SkkRuleMetadata* metadata,
                                    const gchar* type,
                                    const gchar* name,
                                    GError** error);
gboolean skk_map_file_has_map (SkkMapFile* self,
                               const gchar* name);
GeeMap* skk_map_file_get (SkkMapFile* self,
                          const gchar* name);
static void skk_map_file_finalize (GObject * obj);


static JsonNode*
_vala_JsonNode_copy (JsonNode* self)
{
	return g_boxed_copy (json_node_get_type (), self);
}


static gpointer
__vala_JsonNode_copy0 (gpointer self)
{
	return self ? _vala_JsonNode_copy (self) : NULL;
}


static void
_vala_JsonNode_free (JsonNode* self)
{
	g_boxed_free (json_node_get_type (), self);
}


static void
skk_map_file_load_map (SkkMapFile* self,
                       GeeMap* map,
                       JsonObject* object)
{
	GList* keys = NULL;
	GList* _tmp0_;
	GList* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (map != NULL);
	g_return_if_fail (object != NULL);
	_tmp0_ = json_object_get_members (object);
	keys = _tmp0_;
	_tmp1_ = keys;
	{
		GList* key_collection = NULL;
		GList* key_it = NULL;
		key_collection = _tmp1_;
		for (key_it = key_collection; key_it != NULL; key_it = key_it->next) {
			const gchar* key = NULL;
			key = (const gchar*) key_it->data;
			{
				JsonNode* value = NULL;
				const gchar* _tmp2_;
				JsonNode* _tmp3_;
				JsonNode* _tmp4_;
				JsonNode* _tmp5_;
				_tmp2_ = key;
				_tmp3_ = json_object_get_member (object, _tmp2_);
				_tmp4_ = __vala_JsonNode_copy0 (_tmp3_);
				value = _tmp4_;
				_tmp5_ = value;
				if (json_node_get_node_type (_tmp5_) == JSON_NODE_NULL) {
					const gchar* _tmp6_;
					_tmp6_ = key;
					gee_map_unset (map, _tmp6_, NULL);
				} else {
					const gchar* _tmp7_;
					JsonNode* _tmp8_;
					_tmp7_ = key;
					_tmp8_ = value;
					gee_map_set (map, _tmp7_, _tmp8_);
				}
				__vala_JsonNode_free0 (value);
			}
		}
	}
	(keys == NULL) ? NULL : (keys = (g_list_free (keys), NULL));
}


static gpointer
_json_object_ref0 (gpointer self)
{
	return self ? json_object_ref (self) : NULL;
}


static gpointer
_json_array_ref0 (gpointer self)
{
	return self ? json_array_ref (self) : NULL;
}


static gint
string_index_of (const gchar* self,
                 const gchar* needle,
                 gint start_index)
{
	gint result = 0;
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (needle != NULL, 0);
	_tmp0_ = strstr (((gchar*) self) + start_index, (gchar*) needle);
	_result_ = _tmp0_;
	_tmp1_ = _result_;
	if (_tmp1_ != NULL) {
		gchar* _tmp2_;
		_tmp2_ = _result_;
		result = (gint) (_tmp2_ - ((gchar*) self));
		return result;
	} else {
		result = -1;
		return result;
	}
}


static gchar*
string_slice (const gchar* self,
              glong start,
              glong end)
{
	gchar* result = NULL;
	glong string_length = 0L;
	gint _tmp0_;
	gint _tmp1_;
	gboolean _tmp4_ = FALSE;
	gboolean _tmp6_ = FALSE;
	gchar* _tmp8_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = strlen (self);
	_tmp1_ = _tmp0_;
	string_length = (glong) _tmp1_;
	if (start < ((glong) 0)) {
		glong _tmp2_;
		_tmp2_ = string_length;
		start = _tmp2_ + start;
	}
	if (end < ((glong) 0)) {
		glong _tmp3_;
		_tmp3_ = string_length;
		end = _tmp3_ + end;
	}
	if (start >= ((glong) 0)) {
		glong _tmp5_;
		_tmp5_ = string_length;
		_tmp4_ = start <= _tmp5_;
	} else {
		_tmp4_ = FALSE;
	}
	g_return_val_if_fail (_tmp4_, NULL);
	if (end >= ((glong) 0)) {
		glong _tmp7_;
		_tmp7_ = string_length;
		_tmp6_ = end <= _tmp7_;
	} else {
		_tmp6_ = FALSE;
	}
	g_return_val_if_fail (_tmp6_, NULL);
	g_return_val_if_fail (start <= end, NULL);
	_tmp8_ = g_strndup (((gchar*) self) + start, (gsize) (end - start));
	result = _tmp8_;
	return result;
}


static void
skk_map_file_load (SkkMapFile* self,
                   SkkRuleMetadata* metadata,
                   const gchar* type,
                   const gchar* name,
                   GeeSet* included,
                   GError** error)
{
	gchar* filename = NULL;
	gchar* _tmp0_;
	const gchar* _tmp1_;
	JsonParser* parser = NULL;
	JsonParser* _tmp4_;
	JsonNode* root = NULL;
	JsonParser* _tmp16_;
	JsonNode* _tmp17_;
	JsonNode* _tmp18_;
	JsonNode* _tmp19_;
	JsonObject* object = NULL;
	JsonNode* _tmp21_;
	JsonObject* _tmp22_;
	JsonObject* _tmp23_;
	JsonNode* member = NULL;
	JsonObject* _tmp24_;
	JsonObject* _tmp65_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (metadata != NULL);
	g_return_if_fail (type != NULL);
	g_return_if_fail (name != NULL);
	g_return_if_fail (included != NULL);
	_tmp0_ = skk_rule_metadata_locate_map_file (metadata, type, name);
	filename = _tmp0_;
	_tmp1_ = filename;
	if (_tmp1_ == NULL) {
		const gchar* _tmp2_;
		GError* _tmp3_;
		_tmp2_ = filename;
		_tmp3_ = g_error_new (SKK_RULE_PARSE_ERROR, SKK_RULE_PARSE_ERROR_FAILED, "no such file %s", _tmp2_);
		_inner_error_ = _tmp3_;
		if (_inner_error_->domain == SKK_RULE_PARSE_ERROR) {
			g_propagate_error (error, _inner_error_);
			_g_free0 (filename);
			return;
		} else {
			_g_free0 (filename);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	_tmp4_ = json_parser_new ();
	parser = _tmp4_;
	{
		gboolean _tmp5_ = FALSE;
		JsonParser* _tmp6_;
		const gchar* _tmp7_;
		_tmp6_ = parser;
		_tmp7_ = filename;
		_tmp5_ = json_parser_load_from_file (_tmp6_, _tmp7_, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch28_g_error;
		}
		if (!_tmp5_) {
			GError* _tmp8_;
			_tmp8_ = g_error_new_literal (SKK_RULE_PARSE_ERROR, SKK_RULE_PARSE_ERROR_FAILED, "");
			_inner_error_ = _tmp8_;
			goto __catch28_g_error;
		}
	}
	goto __finally28;
	__catch28_g_error:
	{
		GError* e = NULL;
		const gchar* _tmp9_;
		GError* _tmp10_;
		const gchar* _tmp11_;
		gchar* _tmp12_;
		gchar* _tmp13_;
		GError* _tmp14_;
		GError* _tmp15_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp9_ = filename;
		_tmp10_ = e;
		_tmp11_ = _tmp10_->message;
		_tmp12_ = g_strdup_printf ("can't load %s: %s", _tmp9_, _tmp11_);
		_tmp13_ = _tmp12_;
		_tmp14_ = g_error_new_literal (SKK_RULE_PARSE_ERROR, SKK_RULE_PARSE_ERROR_FAILED, _tmp13_);
		_tmp15_ = _tmp14_;
		_g_free0 (_tmp13_);
		_inner_error_ = _tmp15_;
		_g_error_free0 (e);
		goto __finally28;
	}
	__finally28:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		if (_inner_error_->domain == SKK_RULE_PARSE_ERROR) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (parser);
			_g_free0 (filename);
			return;
		} else {
			_g_object_unref0 (parser);
			_g_free0 (filename);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	_tmp16_ = parser;
	_tmp17_ = json_parser_get_root (_tmp16_);
	_tmp18_ = __vala_JsonNode_copy0 (_tmp17_);
	root = _tmp18_;
	_tmp19_ = root;
	if (json_node_get_node_type (_tmp19_) != JSON_NODE_OBJECT) {
		GError* _tmp20_;
		_tmp20_ = g_error_new_literal (SKK_RULE_PARSE_ERROR, SKK_RULE_PARSE_ERROR_FAILED, "root element must be an object");
		_inner_error_ = _tmp20_;
		if (_inner_error_->domain == SKK_RULE_PARSE_ERROR) {
			g_propagate_error (error, _inner_error_);
			__vala_JsonNode_free0 (root);
			_g_object_unref0 (parser);
			_g_free0 (filename);
			return;
		} else {
			__vala_JsonNode_free0 (root);
			_g_object_unref0 (parser);
			_g_free0 (filename);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	_tmp21_ = root;
	_tmp22_ = json_node_get_object (_tmp21_);
	_tmp23_ = _json_object_ref0 (_tmp22_);
	object = _tmp23_;
	_tmp24_ = object;
	if (json_object_has_member (_tmp24_, "include")) {
		JsonObject* _tmp25_;
		JsonNode* _tmp26_;
		JsonNode* _tmp27_;
		JsonNode* _tmp28_;
		JsonArray* include = NULL;
		JsonNode* _tmp30_;
		JsonArray* _tmp31_;
		JsonArray* _tmp32_;
		GList* elements = NULL;
		JsonArray* _tmp33_;
		GList* _tmp34_;
		GList* _tmp35_;
		_tmp25_ = object;
		_tmp26_ = json_object_get_member (_tmp25_, "include");
		_tmp27_ = __vala_JsonNode_copy0 (_tmp26_);
		__vala_JsonNode_free0 (member);
		member = _tmp27_;
		_tmp28_ = member;
		if (json_node_get_node_type (_tmp28_) != JSON_NODE_ARRAY) {
			GError* _tmp29_;
			_tmp29_ = g_error_new_literal (SKK_RULE_PARSE_ERROR, SKK_RULE_PARSE_ERROR_FAILED, "\"include\" element must be an array");
			_inner_error_ = _tmp29_;
			if (_inner_error_->domain == SKK_RULE_PARSE_ERROR) {
				g_propagate_error (error, _inner_error_);
				__vala_JsonNode_free0 (member);
				_json_object_unref0 (object);
				__vala_JsonNode_free0 (root);
				_g_object_unref0 (parser);
				_g_free0 (filename);
				return;
			} else {
				__vala_JsonNode_free0 (member);
				_json_object_unref0 (object);
				__vala_JsonNode_free0 (root);
				_g_object_unref0 (parser);
				_g_free0 (filename);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
		}
		_tmp30_ = member;
		_tmp31_ = json_node_get_array (_tmp30_);
		_tmp32_ = _json_array_ref0 (_tmp31_);
		include = _tmp32_;
		_tmp33_ = include;
		_tmp34_ = json_array_get_elements (_tmp33_);
		elements = _tmp34_;
		_tmp35_ = elements;
		{
			GList* element_collection = NULL;
			GList* element_it = NULL;
			element_collection = _tmp35_;
			for (element_it = element_collection; element_it != NULL; element_it = element_it->next) {
				JsonNode* element = NULL;
				element = (JsonNode*) element_it->data;
				{
					gchar* parent = NULL;
					JsonNode* _tmp36_;
					const gchar* _tmp37_;
					gchar* _tmp38_;
					const gchar* _tmp39_;
					gchar* parent_rule = NULL;
					gchar* parent_name = NULL;
					gint index = 0;
					const gchar* _tmp40_;
					gint _tmp41_;
					SkkRuleMetadata* parent_metadata = NULL;
					const gchar* _tmp56_;
					SkkRuleMetadata* _tmp57_;
					SkkRuleMetadata* _tmp58_;
					SkkRuleMetadata* _tmp61_;
					const gchar* _tmp62_;
					SkkRuleMetadata _tmp63_;
					const gchar* _tmp64_;
					_tmp36_ = element;
					_tmp37_ = json_node_get_string (_tmp36_);
					_tmp38_ = g_strdup (_tmp37_);
					parent = _tmp38_;
					_tmp39_ = parent;
					if (gee_collection_contains ((GeeCollection*) included, _tmp39_)) {
						_g_free0 (parent);
						continue;
					}
					_tmp40_ = parent;
					index = string_index_of (_tmp40_, "/", 0);
					_tmp41_ = index;
					if (_tmp41_ < 0) {
						SkkRuleMetadata _tmp42_;
						const gchar* _tmp43_;
						gchar* _tmp44_;
						const gchar* _tmp45_;
						gchar* _tmp46_;
						_tmp42_ = *metadata;
						_tmp43_ = _tmp42_.name;
						_tmp44_ = g_strdup (_tmp43_);
						_g_free0 (parent_rule);
						parent_rule = _tmp44_;
						_tmp45_ = parent;
						_tmp46_ = g_strdup (_tmp45_);
						_g_free0 (parent_name);
						parent_name = _tmp46_;
					} else {
						const gchar* _tmp47_;
						gint _tmp48_;
						gchar* _tmp49_;
						const gchar* _tmp50_;
						gint _tmp51_;
						const gchar* _tmp52_;
						gint _tmp53_;
						gint _tmp54_;
						gchar* _tmp55_;
						_tmp47_ = parent;
						_tmp48_ = index;
						_tmp49_ = string_slice (_tmp47_, (glong) 0, (glong) _tmp48_);
						_g_free0 (parent_rule);
						parent_rule = _tmp49_;
						_tmp50_ = parent;
						_tmp51_ = index;
						_tmp52_ = parent;
						_tmp53_ = strlen (_tmp52_);
						_tmp54_ = _tmp53_;
						_tmp55_ = string_slice (_tmp50_, (glong) (_tmp51_ + 1), (glong) _tmp54_);
						_g_free0 (parent_name);
						parent_name = _tmp55_;
					}
					_tmp56_ = parent_rule;
					_tmp57_ = skk_rule_find_rule (_tmp56_);
					parent_metadata = _tmp57_;
					_tmp58_ = parent_metadata;
					if (_tmp58_ == NULL) {
						const gchar* _tmp59_;
						GError* _tmp60_;
						_tmp59_ = parent_rule;
						_tmp60_ = g_error_new (SKK_RULE_PARSE_ERROR, SKK_RULE_PARSE_ERROR_FAILED, "can't find rule %s", _tmp59_);
						_inner_error_ = _tmp60_;
						if (_inner_error_->domain == SKK_RULE_PARSE_ERROR) {
							g_propagate_error (error, _inner_error_);
							_skk_rule_metadata_free0 (parent_metadata);
							_g_free0 (parent_name);
							_g_free0 (parent_rule);
							_g_free0 (parent);
							(elements == NULL) ? NULL : (elements = (g_list_free (elements), NULL));
							_json_array_unref0 (include);
							__vala_JsonNode_free0 (member);
							_json_object_unref0 (object);
							__vala_JsonNode_free0 (root);
							_g_object_unref0 (parser);
							_g_free0 (filename);
							return;
						} else {
							_skk_rule_metadata_free0 (parent_metadata);
							_g_free0 (parent_name);
							_g_free0 (parent_rule);
							_g_free0 (parent);
							(elements == NULL) ? NULL : (elements = (g_list_free (elements), NULL));
							_json_array_unref0 (include);
							__vala_JsonNode_free0 (member);
							_json_object_unref0 (object);
							__vala_JsonNode_free0 (root);
							_g_object_unref0 (parser);
							_g_free0 (filename);
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
							g_clear_error (&_inner_error_);
							return;
						}
					}
					_tmp61_ = parent_metadata;
					_tmp62_ = parent_name;
					_tmp63_ = *_tmp61_;
					skk_map_file_load (self, &_tmp63_, type, _tmp62_, included, &_inner_error_);
					if (G_UNLIKELY (_inner_error_ != NULL)) {
						if (_inner_error_->domain == SKK_RULE_PARSE_ERROR) {
							g_propagate_error (error, _inner_error_);
							_skk_rule_metadata_free0 (parent_metadata);
							_g_free0 (parent_name);
							_g_free0 (parent_rule);
							_g_free0 (parent);
							(elements == NULL) ? NULL : (elements = (g_list_free (elements), NULL));
							_json_array_unref0 (include);
							__vala_JsonNode_free0 (member);
							_json_object_unref0 (object);
							__vala_JsonNode_free0 (root);
							_g_object_unref0 (parser);
							_g_free0 (filename);
							return;
						} else {
							_skk_rule_metadata_free0 (parent_metadata);
							_g_free0 (parent_name);
							_g_free0 (parent_rule);
							_g_free0 (parent);
							(elements == NULL) ? NULL : (elements = (g_list_free (elements), NULL));
							_json_array_unref0 (include);
							__vala_JsonNode_free0 (member);
							_json_object_unref0 (object);
							__vala_JsonNode_free0 (root);
							_g_object_unref0 (parser);
							_g_free0 (filename);
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
							g_clear_error (&_inner_error_);
							return;
						}
					}
					_tmp64_ = parent;
					gee_collection_add ((GeeCollection*) included, _tmp64_);
					_skk_rule_metadata_free0 (parent_metadata);
					_g_free0 (parent_name);
					_g_free0 (parent_rule);
					_g_free0 (parent);
				}
			}
		}
		(elements == NULL) ? NULL : (elements = (g_list_free (elements), NULL));
		_json_array_unref0 (include);
	}
	_tmp65_ = object;
	if (json_object_has_member (_tmp65_, "define")) {
		JsonObject* _tmp66_;
		JsonNode* _tmp67_;
		JsonNode* _tmp68_;
		JsonNode* _tmp69_;
		JsonObject* define = NULL;
		JsonNode* _tmp71_;
		JsonObject* _tmp72_;
		JsonObject* _tmp73_;
		GList* keys = NULL;
		JsonObject* _tmp74_;
		GList* _tmp75_;
		GList* _tmp76_;
		_tmp66_ = object;
		_tmp67_ = json_object_get_member (_tmp66_, "define");
		_tmp68_ = __vala_JsonNode_copy0 (_tmp67_);
		__vala_JsonNode_free0 (member);
		member = _tmp68_;
		_tmp69_ = member;
		if (json_node_get_node_type (_tmp69_) != JSON_NODE_OBJECT) {
			GError* _tmp70_;
			_tmp70_ = g_error_new_literal (SKK_RULE_PARSE_ERROR, SKK_RULE_PARSE_ERROR_FAILED, "\"define\" element must be an object");
			_inner_error_ = _tmp70_;
			if (_inner_error_->domain == SKK_RULE_PARSE_ERROR) {
				g_propagate_error (error, _inner_error_);
				__vala_JsonNode_free0 (member);
				_json_object_unref0 (object);
				__vala_JsonNode_free0 (root);
				_g_object_unref0 (parser);
				_g_free0 (filename);
				return;
			} else {
				__vala_JsonNode_free0 (member);
				_json_object_unref0 (object);
				__vala_JsonNode_free0 (root);
				_g_object_unref0 (parser);
				_g_free0 (filename);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
		}
		_tmp71_ = member;
		_tmp72_ = json_node_get_object (_tmp71_);
		_tmp73_ = _json_object_ref0 (_tmp72_);
		define = _tmp73_;
		_tmp74_ = define;
		_tmp75_ = json_object_get_members (_tmp74_);
		keys = _tmp75_;
		_tmp76_ = keys;
		{
			GList* key_collection = NULL;
			GList* key_it = NULL;
			key_collection = _tmp76_;
			for (key_it = key_collection; key_it != NULL; key_it = key_it->next) {
				const gchar* key = NULL;
				key = (const gchar*) key_it->data;
				{
					GeeMap* _tmp77_;
					const gchar* _tmp78_;
					JsonObject* _tmp83_;
					const gchar* _tmp84_;
					JsonNode* _tmp85_;
					JsonNode* _tmp86_;
					JsonNode* _tmp87_;
					GeeMap* _tmp89_;
					const gchar* _tmp90_;
					gpointer _tmp91_;
					GeeMap* _tmp92_;
					JsonNode* _tmp93_;
					JsonObject* _tmp94_;
					_tmp77_ = self->priv->maps;
					_tmp78_ = key;
					if (!gee_map_has_key (_tmp77_, _tmp78_)) {
						GeeHashMap* map = NULL;
						GeeHashMap* _tmp79_;
						GeeMap* _tmp80_;
						const gchar* _tmp81_;
						GeeHashMap* _tmp82_;
						_tmp79_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, json_node_get_type (), (GBoxedCopyFunc) _vala_JsonNode_copy, (GDestroyNotify) _vala_JsonNode_free, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
						map = _tmp79_;
						_tmp80_ = self->priv->maps;
						_tmp81_ = key;
						_tmp82_ = map;
						gee_map_set (_tmp80_, _tmp81_, (GeeMap*) _tmp82_);
						_g_object_unref0 (map);
					}
					_tmp83_ = define;
					_tmp84_ = key;
					_tmp85_ = json_object_get_member (_tmp83_, _tmp84_);
					_tmp86_ = __vala_JsonNode_copy0 (_tmp85_);
					__vala_JsonNode_free0 (member);
					member = _tmp86_;
					_tmp87_ = member;
					if (json_node_get_node_type (_tmp87_) != JSON_NODE_OBJECT) {
						GError* _tmp88_;
						_tmp88_ = g_error_new_literal (SKK_RULE_PARSE_ERROR, SKK_RULE_PARSE_ERROR_FAILED, "map element must be an object");
						_inner_error_ = _tmp88_;
						if (_inner_error_->domain == SKK_RULE_PARSE_ERROR) {
							g_propagate_error (error, _inner_error_);
							(keys == NULL) ? NULL : (keys = (g_list_free (keys), NULL));
							_json_object_unref0 (define);
							__vala_JsonNode_free0 (member);
							_json_object_unref0 (object);
							__vala_JsonNode_free0 (root);
							_g_object_unref0 (parser);
							_g_free0 (filename);
							return;
						} else {
							(keys == NULL) ? NULL : (keys = (g_list_free (keys), NULL));
							_json_object_unref0 (define);
							__vala_JsonNode_free0 (member);
							_json_object_unref0 (object);
							__vala_JsonNode_free0 (root);
							_g_object_unref0 (parser);
							_g_free0 (filename);
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
							g_clear_error (&_inner_error_);
							return;
						}
					}
					_tmp89_ = self->priv->maps;
					_tmp90_ = key;
					_tmp91_ = gee_map_get (_tmp89_, _tmp90_);
					_tmp92_ = (GeeMap*) _tmp91_;
					_tmp93_ = member;
					_tmp94_ = json_node_get_object (_tmp93_);
					skk_map_file_load_map (self, _tmp92_, _tmp94_);
					_g_object_unref0 (_tmp92_);
				}
			}
		}
		(keys == NULL) ? NULL : (keys = (g_list_free (keys), NULL));
		_json_object_unref0 (define);
	}
	__vala_JsonNode_free0 (member);
	_json_object_unref0 (object);
	__vala_JsonNode_free0 (root);
	_g_object_unref0 (parser);
	_g_free0 (filename);
}


SkkMapFile*
skk_map_file_construct (GType object_type,
                        SkkRuleMetadata* metadata,
                        const gchar* type,
                        const gchar* name,
                        GError** error)
{
	SkkMapFile * self = NULL;
	GeeSet* included = NULL;
	GeeHashSet* _tmp0_;
	SkkRuleMetadata _tmp1_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (metadata != NULL, NULL);
	g_return_val_if_fail (type != NULL, NULL);
	g_return_val_if_fail (name != NULL, NULL);
	self = (SkkMapFile*) g_object_new (object_type, NULL);
	_tmp0_ = gee_hash_set_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL, NULL, NULL, NULL);
	included = (GeeSet*) _tmp0_;
	_tmp1_ = *metadata;
	skk_map_file_load (self, &_tmp1_, type, name, included, &_inner_error_);
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		if (_inner_error_->domain == SKK_RULE_PARSE_ERROR) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (included);
			_g_object_unref0 (self);
			return NULL;
		} else {
			_g_object_unref0 (included);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_g_object_unref0 (included);
	return self;
}


gboolean
skk_map_file_has_map (SkkMapFile* self,
                      const gchar* name)
{
	gboolean result = FALSE;
	GeeMap* _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (name != NULL, FALSE);
	_tmp0_ = self->priv->maps;
	result = gee_map_has_key (_tmp0_, name);
	return result;
}


GeeMap*
skk_map_file_get (SkkMapFile* self,
                  const gchar* name)
{
	GeeMap* result = NULL;
	GeeMap* _tmp0_;
	gpointer _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (name != NULL, NULL);
	_tmp0_ = self->priv->maps;
	_tmp1_ = gee_map_get (_tmp0_, name);
	result = (GeeMap*) _tmp1_;
	return result;
}


static void
skk_map_file_class_init (SkkMapFileClass * klass)
{
	skk_map_file_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (SkkMapFilePrivate));
	G_OBJECT_CLASS (klass)->finalize = skk_map_file_finalize;
}


static void
skk_map_file_instance_init (SkkMapFile * self)
{
	GeeHashMap* _tmp0_;
	self->priv = SKK_MAP_FILE_GET_PRIVATE (self);
	_tmp0_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, GEE_TYPE_MAP, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	self->priv->maps = (GeeMap*) _tmp0_;
}


static void
skk_map_file_finalize (GObject * obj)
{
	SkkMapFile * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SKK_TYPE_MAP_FILE, SkkMapFile);
	_g_object_unref0 (self->priv->maps);
	G_OBJECT_CLASS (skk_map_file_parent_class)->finalize (obj);
}


GType
skk_map_file_get_type (void)
{
	static volatile gsize skk_map_file_type_id__volatile = 0;
	if (g_once_init_enter (&skk_map_file_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (SkkMapFileClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) skk_map_file_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SkkMapFile), 0, (GInstanceInitFunc) skk_map_file_instance_init, NULL };
		GType skk_map_file_type_id;
		skk_map_file_type_id = g_type_register_static (G_TYPE_OBJECT, "SkkMapFile", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
		g_once_init_leave (&skk_map_file_type_id__volatile, skk_map_file_type_id);
	}
	return skk_map_file_type_id__volatile;
}



