; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 5
; RUN: llc < %s -mtriple=aarch64-- | FileCheck %s

define zeroext i32 @trunc_nuw_nsw_urem(i64 %x) nounwind {
; CHECK-LABEL: trunc_nuw_nsw_urem:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    mov w8, #5977 // =0x1759
; CHECK-NEXT:    mov w9, #10000 // =0x2710
; CHECK-NEXT:    movk w8, #53687, lsl #16
; CHECK-NEXT:    mul x8, x0, x8
; CHECK-NEXT:    lsr x8, x8, #45
; CHECK-NEXT:    msub w0, w8, w9, w0
; CHECK-NEXT:    ret
entry:
  %trunc = trunc nuw nsw i64 %x to i32
  %rem = urem i32 %trunc, 10000
  ret i32 %rem
}

define i64 @zext_nneg_udiv_trunc_nuw(i64 %x) nounwind {
; CHECK-LABEL: zext_nneg_udiv_trunc_nuw:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    mov w8, #52429 // =0xcccd
; CHECK-NEXT:    mul w8, w0, w8
; CHECK-NEXT:    lsr w0, w8, #23
; CHECK-NEXT:    ret
entry:
  %trunc = trunc nuw i64 %x to i16
  %div = udiv i16 %trunc, 160
  %ext = zext nneg i16 %div to i64
  ret i64 %ext
}

define i64 @sext_udiv_trunc_nuw(i64 %x) nounwind {
; CHECK-LABEL: sext_udiv_trunc_nuw:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    mov w8, #52429 // =0xcccd
; CHECK-NEXT:    mul w8, w0, w8
; CHECK-NEXT:    lsr w0, w8, #23
; CHECK-NEXT:    ret
entry:
  %trunc = trunc nuw i64 %x to i16
  %div = udiv i16 %trunc, 160
  %ext = sext i16 %div to i64
  ret i64 %ext
}

define ptr @gep_nusw_zext_nneg_add_trunc_nuw_nsw(ptr %p, i64 %x) nounwind {
; CHECK-LABEL: gep_nusw_zext_nneg_add_trunc_nuw_nsw:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    add w8, w1, #5
; CHECK-NEXT:    add x0, x0, w8, uxtw #2
; CHECK-NEXT:    ret
entry:
  %trunc = trunc nuw nsw i64 %x to i32
  %add = add nuw nsw i32 %trunc, 5
  %offset = zext nneg i32 %add to i64
  %gep = getelementptr nusw float, ptr %p, i64 %offset
  ret ptr %gep
}
