; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 4
; RUN: llc --disable-replace-with-vec-lib --vector-library=ArmPL < %s -o - | FileCheck --check-prefix=ARMPL %s
; RUN: llc --disable-replace-with-vec-lib --vector-library=sleefgnuabi < %s -o - | FileCheck --check-prefix=SLEEF %s

target triple = "aarch64-unknown-linux-gnu"

define <2 x double> @frem_v2f64(<2 x double> %unused, <2 x double> %a, <2 x double> %b) #0 {
; ARMPL-LABEL: frem_v2f64:
; ARMPL:       // %bb.0:
; ARMPL-NEXT:    str x30, [sp, #-16]! // 8-byte Folded Spill
; ARMPL-NEXT:    .cfi_def_cfa_offset 16
; ARMPL-NEXT:    .cfi_offset w30, -16
; ARMPL-NEXT:    mov v0.16b, v1.16b
; ARMPL-NEXT:    mov v1.16b, v2.16b
; ARMPL-NEXT:    bl armpl_vfmodq_f64
; ARMPL-NEXT:    ldr x30, [sp], #16 // 8-byte Folded Reload
; ARMPL-NEXT:    ret
;
; SLEEF-LABEL: frem_v2f64:
; SLEEF:       // %bb.0:
; SLEEF-NEXT:    str x30, [sp, #-16]! // 8-byte Folded Spill
; SLEEF-NEXT:    .cfi_def_cfa_offset 16
; SLEEF-NEXT:    .cfi_offset w30, -16
; SLEEF-NEXT:    mov v0.16b, v1.16b
; SLEEF-NEXT:    mov v1.16b, v2.16b
; SLEEF-NEXT:    bl _ZGVnN2vv_fmod
; SLEEF-NEXT:    ldr x30, [sp], #16 // 8-byte Folded Reload
; SLEEF-NEXT:    ret
  %res = frem <2 x double> %a, %b
  ret <2 x double> %res
}

define <4 x float> @frem_strict_v4f32(<4 x float> %unused, <4 x float> %a, <4 x float> %b) #1 {
; ARMPL-LABEL: frem_strict_v4f32:
; ARMPL:       // %bb.0:
; ARMPL-NEXT:    str x30, [sp, #-16]! // 8-byte Folded Spill
; ARMPL-NEXT:    .cfi_def_cfa_offset 16
; ARMPL-NEXT:    .cfi_offset w30, -16
; ARMPL-NEXT:    mov v0.16b, v1.16b
; ARMPL-NEXT:    mov v1.16b, v2.16b
; ARMPL-NEXT:    bl armpl_vfmodq_f32
; ARMPL-NEXT:    ldr x30, [sp], #16 // 8-byte Folded Reload
; ARMPL-NEXT:    ret
;
; SLEEF-LABEL: frem_strict_v4f32:
; SLEEF:       // %bb.0:
; SLEEF-NEXT:    str x30, [sp, #-16]! // 8-byte Folded Spill
; SLEEF-NEXT:    .cfi_def_cfa_offset 16
; SLEEF-NEXT:    .cfi_offset w30, -16
; SLEEF-NEXT:    mov v0.16b, v1.16b
; SLEEF-NEXT:    mov v1.16b, v2.16b
; SLEEF-NEXT:    bl _ZGVnN4vv_fmodf
; SLEEF-NEXT:    ldr x30, [sp], #16 // 8-byte Folded Reload
; SLEEF-NEXT:    ret
  %res = frem <4 x float> %a, %b
  ret <4 x float> %res
}

define <vscale x 4 x float> @frem_nxv4f32(<vscale x 4 x float> %unused, <vscale x 4 x float> %a, <vscale x 4 x float> %b) #0 {
; ARMPL-LABEL: frem_nxv4f32:
; ARMPL:       // %bb.0:
; ARMPL-NEXT:    str x30, [sp, #-16]! // 8-byte Folded Spill
; ARMPL-NEXT:    .cfi_def_cfa_offset 16
; ARMPL-NEXT:    .cfi_offset w30, -16
; ARMPL-NEXT:    mov z0.d, z1.d
; ARMPL-NEXT:    mov z1.d, z2.d
; ARMPL-NEXT:    ptrue p0.s
; ARMPL-NEXT:    bl armpl_svfmod_f32_x
; ARMPL-NEXT:    ldr x30, [sp], #16 // 8-byte Folded Reload
; ARMPL-NEXT:    ret
;
; SLEEF-LABEL: frem_nxv4f32:
; SLEEF:       // %bb.0:
; SLEEF-NEXT:    str x30, [sp, #-16]! // 8-byte Folded Spill
; SLEEF-NEXT:    .cfi_def_cfa_offset 16
; SLEEF-NEXT:    .cfi_offset w30, -16
; SLEEF-NEXT:    mov z0.d, z1.d
; SLEEF-NEXT:    mov z1.d, z2.d
; SLEEF-NEXT:    ptrue p0.s
; SLEEF-NEXT:    bl _ZGVsMxvv_fmodf
; SLEEF-NEXT:    ldr x30, [sp], #16 // 8-byte Folded Reload
; SLEEF-NEXT:    ret
  %res = frem <vscale x 4 x float> %a, %b
  ret <vscale x 4 x float> %res
}

define <vscale x 2 x double> @frem_strict_nxv2f64(<vscale x 2 x double> %unused, <vscale x 2 x double> %a, <vscale x 2 x double> %b) #1 {
; ARMPL-LABEL: frem_strict_nxv2f64:
; ARMPL:       // %bb.0:
; ARMPL-NEXT:    str x30, [sp, #-16]! // 8-byte Folded Spill
; ARMPL-NEXT:    .cfi_def_cfa_offset 16
; ARMPL-NEXT:    .cfi_offset w30, -16
; ARMPL-NEXT:    mov z0.d, z1.d
; ARMPL-NEXT:    mov z1.d, z2.d
; ARMPL-NEXT:    ptrue p0.d
; ARMPL-NEXT:    bl armpl_svfmod_f64_x
; ARMPL-NEXT:    ldr x30, [sp], #16 // 8-byte Folded Reload
; ARMPL-NEXT:    ret
;
; SLEEF-LABEL: frem_strict_nxv2f64:
; SLEEF:       // %bb.0:
; SLEEF-NEXT:    str x30, [sp, #-16]! // 8-byte Folded Spill
; SLEEF-NEXT:    .cfi_def_cfa_offset 16
; SLEEF-NEXT:    .cfi_offset w30, -16
; SLEEF-NEXT:    mov z0.d, z1.d
; SLEEF-NEXT:    mov z1.d, z2.d
; SLEEF-NEXT:    ptrue p0.d
; SLEEF-NEXT:    bl _ZGVsMxvv_fmod
; SLEEF-NEXT:    ldr x30, [sp], #16 // 8-byte Folded Reload
; SLEEF-NEXT:    ret
  %res = frem <vscale x 2 x double> %a, %b
  ret <vscale x 2 x double> %res
}

attributes #0 = { "target-features"="+sve" }
attributes #1 = { "target-features"="+sve" strictfp }
