# ===----------------------------------------------------------------------===##
#
# Part of the LLVM Project, under the Apache License v2.0 with LLVM Exceptions.
# See https://llvm.org/LICENSE.txt for license information.
# SPDX-License-Identifier: Apache-2.0 WITH LLVM-exception
#
# ===----------------------------------------------------------------------===##

# RUN: %{python} %s %{libcxx-dir}/utils %{libcxx-dir}/test/libcxx/feature_test_macro/test_data.json %t/tests
# END.

import os
import sys
import unittest

UTILS = sys.argv[1]
TEST_DATA = sys.argv[2]
OUTPUT_PATH = sys.argv[3]
del sys.argv[1:4]

sys.path.append(UTILS)
from generate_feature_test_macro_components import FeatureTestMacros


class Test(unittest.TestCase):
    def setUp(self):
        self.ftm = FeatureTestMacros(TEST_DATA, ["charconv"])
        self.maxDiff = None  # This causes the diff to be printed when the test fails

        self.expected = dict(
            {
                "algorithm": """\
//===----------------------------------------------------------------------===//
//
// Part of the LLVM Project, under the Apache License v2.0 with LLVM Exceptions.
// See https://llvm.org/LICENSE.txt for license information.
// SPDX-License-Identifier: Apache-2.0 WITH LLVM-exception
//
//===----------------------------------------------------------------------===//

// WARNING: This test was generated by generate_feature_test_macro_components.py
// and should not be edited manually.

// <algorithm>

// Test the feature test macros defined by <algorithm>

// clang-format off

#include <algorithm>
#include "test_macros.h"

#if TEST_STD_VER < 17

#  ifdef __cpp_lib_clamp
#    error "__cpp_lib_clamp should not be defined before c++17"
#  endif

#  ifdef __cpp_lib_parallel_algorithm
#    error "__cpp_lib_parallel_algorithm should not be defined before c++17"
#  endif

#elif TEST_STD_VER == 17

#  ifndef __cpp_lib_clamp
#    error "__cpp_lib_clamp should be defined in c++17"
#  endif
#  if __cpp_lib_clamp != 201603L
#    error "__cpp_lib_clamp should have the value 201603L in c++17"
#  endif

#  ifndef __cpp_lib_parallel_algorithm
#    error "__cpp_lib_parallel_algorithm should be defined in c++17"
#  endif
#  if __cpp_lib_parallel_algorithm != 201603L
#    error "__cpp_lib_parallel_algorithm should have the value 201603L in c++17"
#  endif

#elif TEST_STD_VER == 20

#  ifndef __cpp_lib_clamp
#    error "__cpp_lib_clamp should be defined in c++20"
#  endif
#  if __cpp_lib_clamp != 201603L
#    error "__cpp_lib_clamp should have the value 201603L in c++20"
#  endif

#  ifndef __cpp_lib_parallel_algorithm
#    error "__cpp_lib_parallel_algorithm should be defined in c++20"
#  endif
#  if __cpp_lib_parallel_algorithm != 201603L
#    error "__cpp_lib_parallel_algorithm should have the value 201603L in c++20"
#  endif

#elif TEST_STD_VER == 23

#  ifndef __cpp_lib_clamp
#    error "__cpp_lib_clamp should be defined in c++23"
#  endif
#  if __cpp_lib_clamp != 201603L
#    error "__cpp_lib_clamp should have the value 201603L in c++23"
#  endif

#  ifndef __cpp_lib_parallel_algorithm
#    error "__cpp_lib_parallel_algorithm should be defined in c++23"
#  endif
#  if __cpp_lib_parallel_algorithm != 201603L
#    error "__cpp_lib_parallel_algorithm should have the value 201603L in c++23"
#  endif

#elif TEST_STD_VER > 23

#  ifndef __cpp_lib_clamp
#    error "__cpp_lib_clamp should be defined in c++26"
#  endif
#  if __cpp_lib_clamp != 201603L
#    error "__cpp_lib_clamp should have the value 201603L in c++26"
#  endif

#  ifndef __cpp_lib_parallel_algorithm
#    error "__cpp_lib_parallel_algorithm should be defined in c++26"
#  endif
#  if __cpp_lib_parallel_algorithm != 201603L
#    error "__cpp_lib_parallel_algorithm should have the value 201603L in c++26"
#  endif

#endif // TEST_STD_VER > 23

// clang-format on

""",
                "any": """\
//===----------------------------------------------------------------------===//
//
// Part of the LLVM Project, under the Apache License v2.0 with LLVM Exceptions.
// See https://llvm.org/LICENSE.txt for license information.
// SPDX-License-Identifier: Apache-2.0 WITH LLVM-exception
//
//===----------------------------------------------------------------------===//

// WARNING: This test was generated by generate_feature_test_macro_components.py
// and should not be edited manually.

// <any>

// Test the feature test macros defined by <any>

// clang-format off

#include <any>
#include "test_macros.h"

#if TEST_STD_VER < 17

#  ifdef __cpp_lib_any
#    error "__cpp_lib_any should not be defined before c++17"
#  endif

#elif TEST_STD_VER == 17

#  ifndef __cpp_lib_any
#    error "__cpp_lib_any should be defined in c++17"
#  endif
#  if __cpp_lib_any != 201606L
#    error "__cpp_lib_any should have the value 201606L in c++17"
#  endif

#elif TEST_STD_VER == 20

#  ifndef __cpp_lib_any
#    error "__cpp_lib_any should be defined in c++20"
#  endif
#  if __cpp_lib_any != 201606L
#    error "__cpp_lib_any should have the value 201606L in c++20"
#  endif

#elif TEST_STD_VER == 23

#  ifndef __cpp_lib_any
#    error "__cpp_lib_any should be defined in c++23"
#  endif
#  if __cpp_lib_any != 201606L
#    error "__cpp_lib_any should have the value 201606L in c++23"
#  endif

#elif TEST_STD_VER > 23

#  ifndef __cpp_lib_any
#    error "__cpp_lib_any should be defined in c++26"
#  endif
#  if __cpp_lib_any != 201606L
#    error "__cpp_lib_any should have the value 201606L in c++26"
#  endif

#endif // TEST_STD_VER > 23

// clang-format on

""",
                "barrier": """\
//===----------------------------------------------------------------------===//
//
// Part of the LLVM Project, under the Apache License v2.0 with LLVM Exceptions.
// See https://llvm.org/LICENSE.txt for license information.
// SPDX-License-Identifier: Apache-2.0 WITH LLVM-exception
//
//===----------------------------------------------------------------------===//

// WARNING: This test was generated by generate_feature_test_macro_components.py
// and should not be edited manually.

// UNSUPPORTED: no-threads

// <barrier>

// Test the feature test macros defined by <barrier>

// clang-format off

#include <barrier>
#include "test_macros.h"

#if TEST_STD_VER < 17

#  ifdef __cpp_lib_barrier
#    error "__cpp_lib_barrier should not be defined before c++20"
#  endif

#elif TEST_STD_VER == 17

#  ifdef __cpp_lib_barrier
#    error "__cpp_lib_barrier should not be defined before c++20"
#  endif

#elif TEST_STD_VER == 20

#  if !defined(_LIBCPP_VERSION) || (_LIBCPP_HAS_THREADS && _LIBCPP_AVAILABILITY_HAS_SYNC)
#    ifndef __cpp_lib_barrier
#      error "__cpp_lib_barrier should be defined in c++20"
#    endif
#    if __cpp_lib_barrier != 201907L
#      error "__cpp_lib_barrier should have the value 201907L in c++20"
#    endif
#  else
#    ifdef __cpp_lib_barrier
#      error "__cpp_lib_barrier should not be defined when the requirement '!defined(_LIBCPP_VERSION) || (_LIBCPP_HAS_THREADS && _LIBCPP_AVAILABILITY_HAS_SYNC)' is not met!"
#    endif
#  endif

#elif TEST_STD_VER == 23

#  if !defined(_LIBCPP_VERSION) || (_LIBCPP_HAS_THREADS && _LIBCPP_AVAILABILITY_HAS_SYNC)
#    ifndef __cpp_lib_barrier
#      error "__cpp_lib_barrier should be defined in c++23"
#    endif
#    if __cpp_lib_barrier != 201907L
#      error "__cpp_lib_barrier should have the value 201907L in c++23"
#    endif
#  else
#    ifdef __cpp_lib_barrier
#      error "__cpp_lib_barrier should not be defined when the requirement '!defined(_LIBCPP_VERSION) || (_LIBCPP_HAS_THREADS && _LIBCPP_AVAILABILITY_HAS_SYNC)' is not met!"
#    endif
#  endif

#elif TEST_STD_VER > 23

#  if !defined(_LIBCPP_VERSION) || (_LIBCPP_HAS_THREADS && _LIBCPP_AVAILABILITY_HAS_SYNC)
#    ifndef __cpp_lib_barrier
#      error "__cpp_lib_barrier should be defined in c++26"
#    endif
#    if __cpp_lib_barrier != 299900L
#      error "__cpp_lib_barrier should have the value 299900L in c++26"
#    endif
#  else
#    ifdef __cpp_lib_barrier
#      error "__cpp_lib_barrier should not be defined when the requirement '!defined(_LIBCPP_VERSION) || (_LIBCPP_HAS_THREADS && _LIBCPP_AVAILABILITY_HAS_SYNC)' is not met!"
#    endif
#  endif

#endif // TEST_STD_VER > 23

// clang-format on

""",
                "charconv": """\
//===----------------------------------------------------------------------===//
//
// Part of the LLVM Project, under the Apache License v2.0 with LLVM Exceptions.
// See https://llvm.org/LICENSE.txt for license information.
// SPDX-License-Identifier: Apache-2.0 WITH LLVM-exception
//
//===----------------------------------------------------------------------===//

// WARNING: This test was generated by generate_feature_test_macro_components.py
// and should not be edited manually.

// <charconv>

// Test the feature test macros defined by <charconv>

// clang-format off

#if !defined(_WIN32) && __has_include(<charconv>)
#  include <charconv>
#endif
#include "test_macros.h"

#if TEST_STD_VER < 17

#  ifdef __cpp_lib_to_chars
#    error "__cpp_lib_to_chars should not be defined before c++17"
#  endif

#elif TEST_STD_VER == 17

#  if !defined(_LIBCPP_VERSION)
#    ifndef __cpp_lib_to_chars
#      error "__cpp_lib_to_chars should be defined in c++17"
#    endif
#    if __cpp_lib_to_chars != 201611L
#      error "__cpp_lib_to_chars should have the value 201611L in c++17"
#    endif
#  else
#    ifdef __cpp_lib_to_chars
#      error "__cpp_lib_to_chars should not be defined because it is unimplemented in libc++!"
#    endif
#  endif

#elif TEST_STD_VER == 20

#  if !defined(_LIBCPP_VERSION)
#    ifndef __cpp_lib_to_chars
#      error "__cpp_lib_to_chars should be defined in c++20"
#    endif
#    if __cpp_lib_to_chars != 201611L
#      error "__cpp_lib_to_chars should have the value 201611L in c++20"
#    endif
#  else
#    ifdef __cpp_lib_to_chars
#      error "__cpp_lib_to_chars should not be defined because it is unimplemented in libc++!"
#    endif
#  endif

#elif TEST_STD_VER == 23

#  if !defined(_LIBCPP_VERSION)
#    ifndef __cpp_lib_to_chars
#      error "__cpp_lib_to_chars should be defined in c++23"
#    endif
#    if __cpp_lib_to_chars != 201611L
#      error "__cpp_lib_to_chars should have the value 201611L in c++23"
#    endif
#  else
#    ifdef __cpp_lib_to_chars
#      error "__cpp_lib_to_chars should not be defined because it is unimplemented in libc++!"
#    endif
#  endif

#elif TEST_STD_VER > 23

#  if !defined(_LIBCPP_VERSION)
#    ifndef __cpp_lib_to_chars
#      error "__cpp_lib_to_chars should be defined in c++26"
#    endif
#    if __cpp_lib_to_chars != 201611L
#      error "__cpp_lib_to_chars should have the value 201611L in c++26"
#    endif
#  else
#    ifdef __cpp_lib_to_chars
#      error "__cpp_lib_to_chars should not be defined because it is unimplemented in libc++!"
#    endif
#  endif

#endif // TEST_STD_VER > 23

// clang-format on

""",
                "format": """\
//===----------------------------------------------------------------------===//
//
// Part of the LLVM Project, under the Apache License v2.0 with LLVM Exceptions.
// See https://llvm.org/LICENSE.txt for license information.
// SPDX-License-Identifier: Apache-2.0 WITH LLVM-exception
//
//===----------------------------------------------------------------------===//

// WARNING: This test was generated by generate_feature_test_macro_components.py
// and should not be edited manually.

// <format>

// Test the feature test macros defined by <format>

// clang-format off

#include <format>
#include "test_macros.h"

#if TEST_STD_VER < 17

#  ifdef __cpp_lib_format
#    error "__cpp_lib_format should not be defined before c++20"
#  endif

#elif TEST_STD_VER == 17

#  ifdef __cpp_lib_format
#    error "__cpp_lib_format should not be defined before c++20"
#  endif

#elif TEST_STD_VER == 20

#  if !defined(_LIBCPP_VERSION)
#    ifndef __cpp_lib_format
#      error "__cpp_lib_format should be defined in c++20"
#    endif
#    if __cpp_lib_format != 202110L
#      error "__cpp_lib_format should have the value 202110L in c++20"
#    endif
#  else
#    ifdef __cpp_lib_format
#      error "__cpp_lib_format should not be defined because it is unimplemented in libc++!"
#    endif
#  endif

#elif TEST_STD_VER == 23

#  if !defined(_LIBCPP_VERSION)
#    ifndef __cpp_lib_format
#      error "__cpp_lib_format should be defined in c++23"
#    endif
#    if __cpp_lib_format != 202207L
#      error "__cpp_lib_format should have the value 202207L in c++23"
#    endif
#  else
#    ifdef __cpp_lib_format
#      error "__cpp_lib_format should not be defined because it is unimplemented in libc++!"
#    endif
#  endif

#elif TEST_STD_VER > 23

#  if !defined(_LIBCPP_VERSION)
#    ifndef __cpp_lib_format
#      error "__cpp_lib_format should be defined in c++26"
#    endif
#    if __cpp_lib_format != 202311L
#      error "__cpp_lib_format should have the value 202311L in c++26"
#    endif
#  else
#    ifdef __cpp_lib_format
#      error "__cpp_lib_format should not be defined because it is unimplemented in libc++!"
#    endif
#  endif

#endif // TEST_STD_VER > 23

// clang-format on

""",
                "numeric": """\
//===----------------------------------------------------------------------===//
//
// Part of the LLVM Project, under the Apache License v2.0 with LLVM Exceptions.
// See https://llvm.org/LICENSE.txt for license information.
// SPDX-License-Identifier: Apache-2.0 WITH LLVM-exception
//
//===----------------------------------------------------------------------===//

// WARNING: This test was generated by generate_feature_test_macro_components.py
// and should not be edited manually.

// <numeric>

// Test the feature test macros defined by <numeric>

// clang-format off

#include <numeric>
#include "test_macros.h"

#if TEST_STD_VER < 17

#  ifdef __cpp_lib_parallel_algorithm
#    error "__cpp_lib_parallel_algorithm should not be defined before c++17"
#  endif

#elif TEST_STD_VER == 17

#  ifndef __cpp_lib_parallel_algorithm
#    error "__cpp_lib_parallel_algorithm should be defined in c++17"
#  endif
#  if __cpp_lib_parallel_algorithm != 201603L
#    error "__cpp_lib_parallel_algorithm should have the value 201603L in c++17"
#  endif

#elif TEST_STD_VER == 20

#  ifndef __cpp_lib_parallel_algorithm
#    error "__cpp_lib_parallel_algorithm should be defined in c++20"
#  endif
#  if __cpp_lib_parallel_algorithm != 201603L
#    error "__cpp_lib_parallel_algorithm should have the value 201603L in c++20"
#  endif

#elif TEST_STD_VER == 23

#  ifndef __cpp_lib_parallel_algorithm
#    error "__cpp_lib_parallel_algorithm should be defined in c++23"
#  endif
#  if __cpp_lib_parallel_algorithm != 201603L
#    error "__cpp_lib_parallel_algorithm should have the value 201603L in c++23"
#  endif

#elif TEST_STD_VER > 23

#  ifndef __cpp_lib_parallel_algorithm
#    error "__cpp_lib_parallel_algorithm should be defined in c++26"
#  endif
#  if __cpp_lib_parallel_algorithm != 201603L
#    error "__cpp_lib_parallel_algorithm should have the value 201603L in c++26"
#  endif

#endif // TEST_STD_VER > 23

// clang-format on

""",
                "variant": """\
//===----------------------------------------------------------------------===//
//
// Part of the LLVM Project, under the Apache License v2.0 with LLVM Exceptions.
// See https://llvm.org/LICENSE.txt for license information.
// SPDX-License-Identifier: Apache-2.0 WITH LLVM-exception
//
//===----------------------------------------------------------------------===//

// WARNING: This test was generated by generate_feature_test_macro_components.py
// and should not be edited manually.

// <variant>

// Test the feature test macros defined by <variant>

// clang-format off

#include <variant>
#include "test_macros.h"

#if TEST_STD_VER < 17

#  ifdef __cpp_lib_variant
#    error "__cpp_lib_variant should not be defined before c++17"
#  endif

#elif TEST_STD_VER == 17

#  ifndef __cpp_lib_variant
#    error "__cpp_lib_variant should be defined in c++17"
#  endif
#  if __cpp_lib_variant != 202102L
#    error "__cpp_lib_variant should have the value 202102L in c++17"
#  endif

#elif TEST_STD_VER == 20

#  if !defined(_LIBCPP_VERSION)
#    ifndef __cpp_lib_variant
#      error "__cpp_lib_variant should be defined in c++20"
#    endif
#    if __cpp_lib_variant != 202106L
#      error "__cpp_lib_variant should have the value 202106L in c++20"
#    endif
#  else
#    ifdef __cpp_lib_variant
#      error "__cpp_lib_variant should not be defined because it is unimplemented in libc++!"
#    endif
#  endif

#elif TEST_STD_VER == 23

#  if !defined(_LIBCPP_VERSION)
#    ifndef __cpp_lib_variant
#      error "__cpp_lib_variant should be defined in c++23"
#    endif
#    if __cpp_lib_variant != 202106L
#      error "__cpp_lib_variant should have the value 202106L in c++23"
#    endif
#  else
#    ifdef __cpp_lib_variant
#      error "__cpp_lib_variant should not be defined because it is unimplemented in libc++!"
#    endif
#  endif

#elif TEST_STD_VER > 23

#  if !defined(_LIBCPP_VERSION)
#    ifndef __cpp_lib_variant
#      error "__cpp_lib_variant should be defined in c++26"
#    endif
#    if __cpp_lib_variant != 202306L
#      error "__cpp_lib_variant should have the value 202306L in c++26"
#    endif
#  else
#    ifdef __cpp_lib_variant
#      error "__cpp_lib_variant should not be defined because it is unimplemented in libc++!"
#    endif
#  endif

#endif // TEST_STD_VER > 23

// clang-format on

""",
            }
        )

    def test_implementation(self):
        # Generate the output
        self.ftm.generate_header_test_directory(OUTPUT_PATH)

        for key, value in self.expected.items():
            # Test whether the per header generate function generates the proper output.
            self.assertEqual(self.ftm.generate_header_test_file(key), value)

            # Test whether all header generate function generates the proper output.
            with open(
                os.path.join(OUTPUT_PATH, f"{key}.version.compile.pass.cpp"),
                "r",
                newline="\n",
            ) as f:
                self.assertEqual(f.read(), value)


if __name__ == "__main__":
    unittest.main()
