; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -mtriple=thumbv8.1m.main-none-eabi -mattr=+mve --verify-machineinstrs %s -o - | FileCheck %s

declare i8 @llvm.smax.i8(i8 %a, i8 %b) readnone

define arm_aapcs_vfpcc i8 @smaxi8(i8 %a, i8 %b) {
; CHECK-LABEL: smaxi8:
; CHECK:       @ %bb.0:
; CHECK-NEXT:    sxtb r1, r1
; CHECK-NEXT:    sxtb r0, r0
; CHECK-NEXT:    cmp r0, r1
; CHECK-NEXT:    csel r0, r0, r1, gt
; CHECK-NEXT:    bx lr
  %c = call i8 @llvm.smax.i8(i8 %a, i8 %b)
  ret i8 %c
}

declare i16 @llvm.smax.i16(i16 %a, i16 %b) readnone

define arm_aapcs_vfpcc i16 @smaxi16(i16 %a, i16 %b) {
; CHECK-LABEL: smaxi16:
; CHECK:       @ %bb.0:
; CHECK-NEXT:    sxth r1, r1
; CHECK-NEXT:    sxth r0, r0
; CHECK-NEXT:    cmp r0, r1
; CHECK-NEXT:    csel r0, r0, r1, gt
; CHECK-NEXT:    bx lr
  %c = call i16 @llvm.smax.i16(i16 %a, i16 %b)
  ret i16 %c
}

declare i32 @llvm.smax.i32(i32 %a, i32 %b) readnone

define arm_aapcs_vfpcc i32 @smaxi32(i32 %a, i32 %b) {
; CHECK-LABEL: smaxi32:
; CHECK:       @ %bb.0:
; CHECK-NEXT:    cmp r0, r1
; CHECK-NEXT:    csel r0, r0, r1, gt
; CHECK-NEXT:    bx lr
  %c = call i32 @llvm.smax.i32(i32 %a, i32 %b)
  ret i32 %c
}

declare i64 @llvm.smax.i64(i64 %a, i64 %b) readnone

define arm_aapcs_vfpcc i64 @smaxi64(i64 %a, i64 %b) {
; CHECK-LABEL: smaxi64:
; CHECK:       @ %bb.0:
; CHECK-NEXT:    subs.w r12, r2, r0
; CHECK-NEXT:    sbcs.w r12, r3, r1
; CHECK-NEXT:    csel r0, r0, r2, lt
; CHECK-NEXT:    csel r1, r1, r3, lt
; CHECK-NEXT:    bx lr
  %c = call i64 @llvm.smax.i64(i64 %a, i64 %b)
  ret i64 %c
}

declare <8 x i8> @llvm.smax.v8i8(<8 x i8> %a, <8 x i8> %b) readnone

define arm_aapcs_vfpcc <8 x i8> @smax8i8(<8 x i8> %a, <8 x i8> %b) {
; CHECK-LABEL: smax8i8:
; CHECK:       @ %bb.0:
; CHECK-NEXT:    vmovlb.s8 q1, q1
; CHECK-NEXT:    vmovlb.s8 q0, q0
; CHECK-NEXT:    vmax.s16 q0, q0, q1
; CHECK-NEXT:    bx lr
  %c = call <8 x i8> @llvm.smax.v8i8(<8 x i8> %a, <8 x i8> %b)
  ret <8 x i8> %c
}

declare <16 x i8> @llvm.smax.v16i8(<16 x i8> %a, <16 x i8> %b) readnone

define arm_aapcs_vfpcc <16 x i8> @smax16i8(<16 x i8> %a, <16 x i8> %b) {
; CHECK-LABEL: smax16i8:
; CHECK:       @ %bb.0:
; CHECK-NEXT:    vmax.s8 q0, q0, q1
; CHECK-NEXT:    bx lr
  %c = call <16 x i8> @llvm.smax.v16i8(<16 x i8> %a, <16 x i8> %b)
  ret <16 x i8> %c
}

declare <32 x i8> @llvm.smax.v32i8(<32 x i8> %a, <32 x i8> %b) readnone

define arm_aapcs_vfpcc void @smax32i8(<32 x i8> %a, <32 x i8> %b, ptr %p) {
; CHECK-LABEL: smax32i8:
; CHECK:       @ %bb.0:
; CHECK-NEXT:    vmax.s8 q1, q1, q3
; CHECK-NEXT:    vmax.s8 q0, q0, q2
; CHECK-NEXT:    vstrw.32 q1, [r0, #16]
; CHECK-NEXT:    vstrw.32 q0, [r0]
; CHECK-NEXT:    bx lr
  %c = call <32 x i8> @llvm.smax.v32i8(<32 x i8> %a, <32 x i8> %b)
  store <32 x i8> %c, ptr %p
  ret void
}

declare <4 x i16> @llvm.smax.v4i16(<4 x i16> %a, <4 x i16> %b) readnone

define arm_aapcs_vfpcc <4 x i16> @smax4i16(<4 x i16> %a, <4 x i16> %b) {
; CHECK-LABEL: smax4i16:
; CHECK:       @ %bb.0:
; CHECK-NEXT:    vmovlb.s16 q1, q1
; CHECK-NEXT:    vmovlb.s16 q0, q0
; CHECK-NEXT:    vmax.s32 q0, q0, q1
; CHECK-NEXT:    bx lr
  %c = call <4 x i16> @llvm.smax.v4i16(<4 x i16> %a, <4 x i16> %b)
  ret <4 x i16> %c
}

declare <8 x i16> @llvm.smax.v8i16(<8 x i16> %a, <8 x i16> %b) readnone

define arm_aapcs_vfpcc <8 x i16> @smax8i16(<8 x i16> %a, <8 x i16> %b) {
; CHECK-LABEL: smax8i16:
; CHECK:       @ %bb.0:
; CHECK-NEXT:    vmax.s16 q0, q0, q1
; CHECK-NEXT:    bx lr
  %c = call <8 x i16> @llvm.smax.v8i16(<8 x i16> %a, <8 x i16> %b)
  ret <8 x i16> %c
}

declare <16 x i16> @llvm.smax.v16i16(<16 x i16> %a, <16 x i16> %b) readnone

define arm_aapcs_vfpcc void @smax16i16(<16 x i16> %a, <16 x i16> %b, ptr %p) {
; CHECK-LABEL: smax16i16:
; CHECK:       @ %bb.0:
; CHECK-NEXT:    vmax.s16 q1, q1, q3
; CHECK-NEXT:    vmax.s16 q0, q0, q2
; CHECK-NEXT:    vstrw.32 q1, [r0, #16]
; CHECK-NEXT:    vstrw.32 q0, [r0]
; CHECK-NEXT:    bx lr
  %c = call <16 x i16> @llvm.smax.v16i16(<16 x i16> %a, <16 x i16> %b)
  store <16 x i16> %c, ptr %p
  ret void
}

declare <2 x i32> @llvm.smax.v2i32(<2 x i32> %a, <2 x i32> %b) readnone

define arm_aapcs_vfpcc <2 x i32> @smax2i32(<2 x i32> %a, <2 x i32> %b) {
; CHECK-LABEL: smax2i32:
; CHECK:       @ %bb.0:
; CHECK-NEXT:    .save {r4, r5, r7, lr}
; CHECK-NEXT:    push {r4, r5, r7, lr}
; CHECK-NEXT:    vmov r1, s4
; CHECK-NEXT:    vmov r3, s0
; CHECK-NEXT:    vmov r0, s6
; CHECK-NEXT:    vmov r2, s2
; CHECK-NEXT:    vmov q1[2], q1[0], r1, r0
; CHECK-NEXT:    vmov q0[2], q0[0], r3, r2
; CHECK-NEXT:    asr.w lr, r1, #31
; CHECK-NEXT:    subs r1, r1, r3
; CHECK-NEXT:    sbcs.w r1, lr, r3, asr #31
; CHECK-NEXT:    asr.w r5, r3, #31
; CHECK-NEXT:    asr.w r12, r0, #31
; CHECK-NEXT:    csetm r1, lt
; CHECK-NEXT:    subs r0, r0, r2
; CHECK-NEXT:    mov.w r3, #0
; CHECK-NEXT:    sbcs.w r0, r12, r2, asr #31
; CHECK-NEXT:    bfi r3, r1, #0, #8
; CHECK-NEXT:    csetm r0, lt
; CHECK-NEXT:    asrs r4, r2, #31
; CHECK-NEXT:    bfi r3, r0, #8, #8
; CHECK-NEXT:    vmov q1[3], q1[1], lr, r12
; CHECK-NEXT:    vmov q0[3], q0[1], r5, r4
; CHECK-NEXT:    vmsr p0, r3
; CHECK-NEXT:    vpsel q0, q0, q1
; CHECK-NEXT:    pop {r4, r5, r7, pc}
  %c = call <2 x i32> @llvm.smax.v2i32(<2 x i32> %a, <2 x i32> %b)
  ret <2 x i32> %c
}

declare <4 x i32> @llvm.smax.v4i32(<4 x i32> %a, <4 x i32> %b) readnone

define arm_aapcs_vfpcc <4 x i32> @smax4i32(<4 x i32> %a, <4 x i32> %b) {
; CHECK-LABEL: smax4i32:
; CHECK:       @ %bb.0:
; CHECK-NEXT:    vmax.s32 q0, q0, q1
; CHECK-NEXT:    bx lr
  %c = call <4 x i32> @llvm.smax.v4i32(<4 x i32> %a, <4 x i32> %b)
  ret <4 x i32> %c
}

declare <8 x i32> @llvm.smax.v8i32(<8 x i32> %a, <8 x i32> %b) readnone

define arm_aapcs_vfpcc void @smax8i32(<8 x i32> %a, <8 x i32> %b, ptr %p) {
; CHECK-LABEL: smax8i32:
; CHECK:       @ %bb.0:
; CHECK-NEXT:    vmax.s32 q1, q1, q3
; CHECK-NEXT:    vmax.s32 q0, q0, q2
; CHECK-NEXT:    vstrw.32 q1, [r0, #16]
; CHECK-NEXT:    vstrw.32 q0, [r0]
; CHECK-NEXT:    bx lr
  %c = call <8 x i32>@llvm.smax.v8i32(<8 x i32> %a, <8 x i32> %b)
  store <8 x i32> %c, ptr %p
  ret void
}

declare <1 x i64> @llvm.smax.v1i64(<1 x i64> %a, <1 x i64> %b) readnone

define arm_aapcs_vfpcc <1 x i64> @smax1i64(<1 x i64> %a, <1 x i64> %b) {
; CHECK-LABEL: smax1i64:
; CHECK:       @ %bb.0:
; CHECK-NEXT:    .pad #8
; CHECK-NEXT:    sub sp, #8
; CHECK-NEXT:    subs.w r12, r2, r0
; CHECK-NEXT:    sbcs.w r12, r3, r1
; CHECK-NEXT:    csel r0, r0, r2, lt
; CHECK-NEXT:    csel r1, r1, r3, lt
; CHECK-NEXT:    add sp, #8
; CHECK-NEXT:    bx lr
  %c = call <1 x i64> @llvm.smax.v1i64(<1 x i64> %a, <1 x i64> %b)
  ret <1 x i64> %c
}

declare <2 x i64> @llvm.smax.v2i64(<2 x i64> %a, <2 x i64> %b) readnone

define arm_aapcs_vfpcc <2 x i64> @smax2i64(<2 x i64> %a, <2 x i64> %b) {
; CHECK-LABEL: smax2i64:
; CHECK:       @ %bb.0:
; CHECK-NEXT:    vmov r0, r1, d0
; CHECK-NEXT:    vmov r2, r3, d2
; CHECK-NEXT:    subs r0, r2, r0
; CHECK-NEXT:    sbcs.w r0, r3, r1
; CHECK-NEXT:    mov.w r1, #0
; CHECK-NEXT:    csetm r0, lt
; CHECK-NEXT:    vmov r3, r2, d3
; CHECK-NEXT:    bfi r1, r0, #0, #8
; CHECK-NEXT:    vmov r0, r12, d1
; CHECK-NEXT:    subs r0, r3, r0
; CHECK-NEXT:    sbcs.w r0, r2, r12
; CHECK-NEXT:    csetm r0, lt
; CHECK-NEXT:    bfi r1, r0, #8, #8
; CHECK-NEXT:    vmsr p0, r1
; CHECK-NEXT:    vpsel q0, q0, q1
; CHECK-NEXT:    bx lr
  %c = call <2 x i64> @llvm.smax.v2i64(<2 x i64> %a, <2 x i64> %b)
  ret <2 x i64> %c
}

declare <4 x i64> @llvm.smax.v4i64(<4 x i64> %a, <4 x i64> %b) readnone

define arm_aapcs_vfpcc void @smax4i64(<4 x i64> %a, <4 x i64> %b, ptr %p) {
; CHECK-LABEL: smax4i64:
; CHECK:       @ %bb.0:
; CHECK-NEXT:    .save {r4, lr}
; CHECK-NEXT:    push {r4, lr}
; CHECK-NEXT:    vmov r1, r12, d2
; CHECK-NEXT:    vmov r3, r2, d6
; CHECK-NEXT:    subs r1, r3, r1
; CHECK-NEXT:    mov.w r3, #0
; CHECK-NEXT:    sbcs.w r1, r2, r12
; CHECK-NEXT:    vmov lr, r12, d3
; CHECK-NEXT:    csetm r2, lt
; CHECK-NEXT:    movs r1, #0
; CHECK-NEXT:    bfi r3, r2, #0, #8
; CHECK-NEXT:    vmov r2, r4, d7
; CHECK-NEXT:    subs.w r2, r2, lr
; CHECK-NEXT:    sbcs.w r2, r4, r12
; CHECK-NEXT:    csetm r2, lt
; CHECK-NEXT:    bfi r3, r2, #8, #8
; CHECK-NEXT:    vmov r2, r12, d0
; CHECK-NEXT:    vmsr p0, r3
; CHECK-NEXT:    vmov r4, r3, d4
; CHECK-NEXT:    vpsel q1, q1, q3
; CHECK-NEXT:    vstrw.32 q1, [r0, #16]
; CHECK-NEXT:    subs r2, r4, r2
; CHECK-NEXT:    sbcs.w r2, r3, r12
; CHECK-NEXT:    vmov r4, r3, d5
; CHECK-NEXT:    csetm r2, lt
; CHECK-NEXT:    bfi r1, r2, #0, #8
; CHECK-NEXT:    vmov r2, r12, d1
; CHECK-NEXT:    subs r2, r4, r2
; CHECK-NEXT:    sbcs.w r2, r3, r12
; CHECK-NEXT:    csetm r2, lt
; CHECK-NEXT:    bfi r1, r2, #8, #8
; CHECK-NEXT:    vmsr p0, r1
; CHECK-NEXT:    vpsel q0, q0, q2
; CHECK-NEXT:    vstrw.32 q0, [r0]
; CHECK-NEXT:    pop {r4, pc}
  %c = call <4 x i64> @llvm.smax.v4i64(<4 x i64> %a, <4 x i64> %b)
  store <4 x i64> %c, ptr %p
  ret void
}

declare i8 @llvm.umax.i8(i8 %a, i8 %b) readnone

define arm_aapcs_vfpcc i8 @umaxi8(i8 %a, i8 %b) {
; CHECK-LABEL: umaxi8:
; CHECK:       @ %bb.0:
; CHECK-NEXT:    uxtb r1, r1
; CHECK-NEXT:    uxtb r0, r0
; CHECK-NEXT:    cmp r0, r1
; CHECK-NEXT:    csel r0, r0, r1, hi
; CHECK-NEXT:    bx lr
  %c = call i8 @llvm.umax.i8(i8 %a, i8 %b)
  ret i8 %c
}

declare i16 @llvm.umax.i16(i16 %a, i16 %b) readnone

define arm_aapcs_vfpcc i16 @umaxi16(i16 %a, i16 %b) {
; CHECK-LABEL: umaxi16:
; CHECK:       @ %bb.0:
; CHECK-NEXT:    uxth r1, r1
; CHECK-NEXT:    uxth r0, r0
; CHECK-NEXT:    cmp r0, r1
; CHECK-NEXT:    csel r0, r0, r1, hi
; CHECK-NEXT:    bx lr
  %c = call i16 @llvm.umax.i16(i16 %a, i16 %b)
  ret i16 %c
}

declare i32 @llvm.umax.i32(i32 %a, i32 %b) readnone

define arm_aapcs_vfpcc i32 @umaxi32(i32 %a, i32 %b) {
; CHECK-LABEL: umaxi32:
; CHECK:       @ %bb.0:
; CHECK-NEXT:    cmp r0, r1
; CHECK-NEXT:    csel r0, r0, r1, hi
; CHECK-NEXT:    bx lr
  %c = call i32 @llvm.umax.i32(i32 %a, i32 %b)
  ret i32 %c
}

declare i64 @llvm.umax.i64(i64 %a, i64 %b) readnone

define arm_aapcs_vfpcc i64 @umaxi64(i64 %a, i64 %b) {
; CHECK-LABEL: umaxi64:
; CHECK:       @ %bb.0:
; CHECK-NEXT:    subs.w r12, r2, r0
; CHECK-NEXT:    sbcs.w r12, r3, r1
; CHECK-NEXT:    csel r0, r0, r2, lo
; CHECK-NEXT:    csel r1, r1, r3, lo
; CHECK-NEXT:    bx lr
  %c = call i64 @llvm.umax.i64(i64 %a, i64 %b)
  ret i64 %c
}

declare <8 x i8> @llvm.umax.v8i8(<8 x i8> %a, <8 x i8> %b) readnone

define arm_aapcs_vfpcc <8 x i8> @umax8i8(<8 x i8> %a, <8 x i8> %b) {
; CHECK-LABEL: umax8i8:
; CHECK:       @ %bb.0:
; CHECK-NEXT:    vmovlb.u8 q1, q1
; CHECK-NEXT:    vmovlb.u8 q0, q0
; CHECK-NEXT:    vmax.u16 q0, q0, q1
; CHECK-NEXT:    bx lr
  %c = call <8 x i8> @llvm.umax.v8i8(<8 x i8> %a, <8 x i8> %b)
  ret <8 x i8> %c
}

declare <16 x i8> @llvm.umax.v16i8(<16 x i8> %a, <16 x i8> %b) readnone

define arm_aapcs_vfpcc <16 x i8> @umax16i8(<16 x i8> %a, <16 x i8> %b) {
; CHECK-LABEL: umax16i8:
; CHECK:       @ %bb.0:
; CHECK-NEXT:    vmax.u8 q0, q0, q1
; CHECK-NEXT:    bx lr
  %c = call <16 x i8> @llvm.umax.v16i8(<16 x i8> %a, <16 x i8> %b)
  ret <16 x i8> %c
}

declare <32 x i8> @llvm.umax.v32i8(<32 x i8> %a, <32 x i8> %b) readnone

define arm_aapcs_vfpcc void @umax32i8(<32 x i8> %a, <32 x i8> %b, ptr %p) {
; CHECK-LABEL: umax32i8:
; CHECK:       @ %bb.0:
; CHECK-NEXT:    vmax.u8 q1, q1, q3
; CHECK-NEXT:    vmax.u8 q0, q0, q2
; CHECK-NEXT:    vstrw.32 q1, [r0, #16]
; CHECK-NEXT:    vstrw.32 q0, [r0]
; CHECK-NEXT:    bx lr
  %c = call <32 x i8> @llvm.umax.v32i8(<32 x i8> %a, <32 x i8> %b)
  store <32 x i8> %c, ptr %p
  ret void
}

declare <4 x i16> @llvm.umax.v4i16(<4 x i16> %a, <4 x i16> %b) readnone

define arm_aapcs_vfpcc <4 x i16> @umax4i16(<4 x i16> %a, <4 x i16> %b) {
; CHECK-LABEL: umax4i16:
; CHECK:       @ %bb.0:
; CHECK-NEXT:    vmovlb.u16 q1, q1
; CHECK-NEXT:    vmovlb.u16 q0, q0
; CHECK-NEXT:    vmax.u32 q0, q0, q1
; CHECK-NEXT:    bx lr
  %c = call <4 x i16> @llvm.umax.v4i16(<4 x i16> %a, <4 x i16> %b)
  ret <4 x i16> %c
}

declare <8 x i16> @llvm.umax.v8i16(<8 x i16> %a, <8 x i16> %b) readnone

define arm_aapcs_vfpcc <8 x i16> @umax8i16(<8 x i16> %a, <8 x i16> %b) {
; CHECK-LABEL: umax8i16:
; CHECK:       @ %bb.0:
; CHECK-NEXT:    vmax.u16 q0, q0, q1
; CHECK-NEXT:    bx lr
  %c = call <8 x i16> @llvm.umax.v8i16(<8 x i16> %a, <8 x i16> %b)
  ret <8 x i16> %c
}

declare <16 x i16> @llvm.umax.v16i16(<16 x i16> %a, <16 x i16> %b) readnone

define arm_aapcs_vfpcc void @umax16i16(<16 x i16> %a, <16 x i16> %b, ptr %p) {
; CHECK-LABEL: umax16i16:
; CHECK:       @ %bb.0:
; CHECK-NEXT:    vmax.u16 q1, q1, q3
; CHECK-NEXT:    vmax.u16 q0, q0, q2
; CHECK-NEXT:    vstrw.32 q1, [r0, #16]
; CHECK-NEXT:    vstrw.32 q0, [r0]
; CHECK-NEXT:    bx lr
  %c = call <16 x i16> @llvm.umax.v16i16(<16 x i16> %a, <16 x i16> %b)
  store <16 x i16> %c, ptr %p
  ret void
}

declare <2 x i32> @llvm.umax.v2i32(<2 x i32> %a, <2 x i32> %b) readnone

define arm_aapcs_vfpcc <2 x i32> @umax2i32(<2 x i32> %a, <2 x i32> %b) {
; CHECK-LABEL: umax2i32:
; CHECK:       @ %bb.0:
; CHECK-NEXT:    vmov.i64 q2, #0xffffffff
; CHECK-NEXT:    vand q0, q0, q2
; CHECK-NEXT:    vand q1, q1, q2
; CHECK-NEXT:    vmov r0, r1, d0
; CHECK-NEXT:    vmov r2, r3, d2
; CHECK-NEXT:    subs r0, r2, r0
; CHECK-NEXT:    sbcs.w r0, r3, r1
; CHECK-NEXT:    mov.w r1, #0
; CHECK-NEXT:    csetm r0, lo
; CHECK-NEXT:    vmov r3, r2, d3
; CHECK-NEXT:    bfi r1, r0, #0, #8
; CHECK-NEXT:    vmov r0, r12, d1
; CHECK-NEXT:    subs r0, r3, r0
; CHECK-NEXT:    sbcs.w r0, r2, r12
; CHECK-NEXT:    csetm r0, lo
; CHECK-NEXT:    bfi r1, r0, #8, #8
; CHECK-NEXT:    vmsr p0, r1
; CHECK-NEXT:    vpsel q0, q0, q1
; CHECK-NEXT:    bx lr
  %c = call <2 x i32> @llvm.umax.v2i32(<2 x i32> %a, <2 x i32> %b)
  ret <2 x i32> %c
}

declare <4 x i32> @llvm.umax.v4i32(<4 x i32> %a, <4 x i32> %b) readnone

define arm_aapcs_vfpcc <4 x i32> @umax4i32(<4 x i32> %a, <4 x i32> %b) {
; CHECK-LABEL: umax4i32:
; CHECK:       @ %bb.0:
; CHECK-NEXT:    vmax.u32 q0, q0, q1
; CHECK-NEXT:    bx lr
  %c = call <4 x i32> @llvm.umax.v4i32(<4 x i32> %a, <4 x i32> %b)
  ret <4 x i32> %c
}

declare <8 x i32> @llvm.umax.v8i32(<8 x i32> %a, <8 x i32> %b) readnone

define arm_aapcs_vfpcc void @umax8i32(<8 x i32> %a, <8 x i32> %b, ptr %p) {
; CHECK-LABEL: umax8i32:
; CHECK:       @ %bb.0:
; CHECK-NEXT:    vmax.u32 q1, q1, q3
; CHECK-NEXT:    vmax.u32 q0, q0, q2
; CHECK-NEXT:    vstrw.32 q1, [r0, #16]
; CHECK-NEXT:    vstrw.32 q0, [r0]
; CHECK-NEXT:    bx lr
  %c = call <8 x i32>@llvm.umax.v8i32(<8 x i32> %a, <8 x i32> %b)
  store <8 x i32> %c, ptr %p
  ret void
}

declare <1 x i64> @llvm.umax.v1i64(<1 x i64> %a, <1 x i64> %b) readnone

define arm_aapcs_vfpcc <1 x i64> @umax1i64(<1 x i64> %a, <1 x i64> %b) {
; CHECK-LABEL: umax1i64:
; CHECK:       @ %bb.0:
; CHECK-NEXT:    .pad #8
; CHECK-NEXT:    sub sp, #8
; CHECK-NEXT:    subs.w r12, r2, r0
; CHECK-NEXT:    sbcs.w r12, r3, r1
; CHECK-NEXT:    csel r0, r0, r2, lo
; CHECK-NEXT:    csel r1, r1, r3, lo
; CHECK-NEXT:    add sp, #8
; CHECK-NEXT:    bx lr
  %c = call <1 x i64> @llvm.umax.v1i64(<1 x i64> %a, <1 x i64> %b)
  ret <1 x i64> %c
}

declare <2 x i64> @llvm.umax.v2i64(<2 x i64> %a, <2 x i64> %b) readnone

define arm_aapcs_vfpcc <2 x i64> @umax2i64(<2 x i64> %a, <2 x i64> %b) {
; CHECK-LABEL: umax2i64:
; CHECK:       @ %bb.0:
; CHECK-NEXT:    vmov r0, r1, d0
; CHECK-NEXT:    vmov r2, r3, d2
; CHECK-NEXT:    subs r0, r2, r0
; CHECK-NEXT:    sbcs.w r0, r3, r1
; CHECK-NEXT:    mov.w r1, #0
; CHECK-NEXT:    csetm r0, lo
; CHECK-NEXT:    vmov r3, r2, d3
; CHECK-NEXT:    bfi r1, r0, #0, #8
; CHECK-NEXT:    vmov r0, r12, d1
; CHECK-NEXT:    subs r0, r3, r0
; CHECK-NEXT:    sbcs.w r0, r2, r12
; CHECK-NEXT:    csetm r0, lo
; CHECK-NEXT:    bfi r1, r0, #8, #8
; CHECK-NEXT:    vmsr p0, r1
; CHECK-NEXT:    vpsel q0, q0, q1
; CHECK-NEXT:    bx lr
  %c = call <2 x i64> @llvm.umax.v2i64(<2 x i64> %a, <2 x i64> %b)
  ret <2 x i64> %c
}

declare <4 x i64> @llvm.umax.v4i64(<4 x i64> %a, <4 x i64> %b) readnone

define arm_aapcs_vfpcc void @umax4i64(<4 x i64> %a, <4 x i64> %b, ptr %p) {
; CHECK-LABEL: umax4i64:
; CHECK:       @ %bb.0:
; CHECK-NEXT:    .save {r4, lr}
; CHECK-NEXT:    push {r4, lr}
; CHECK-NEXT:    vmov r1, r12, d2
; CHECK-NEXT:    vmov r3, r2, d6
; CHECK-NEXT:    subs r1, r3, r1
; CHECK-NEXT:    mov.w r3, #0
; CHECK-NEXT:    sbcs.w r1, r2, r12
; CHECK-NEXT:    vmov lr, r12, d3
; CHECK-NEXT:    csetm r2, lo
; CHECK-NEXT:    movs r1, #0
; CHECK-NEXT:    bfi r3, r2, #0, #8
; CHECK-NEXT:    vmov r2, r4, d7
; CHECK-NEXT:    subs.w r2, r2, lr
; CHECK-NEXT:    sbcs.w r2, r4, r12
; CHECK-NEXT:    csetm r2, lo
; CHECK-NEXT:    bfi r3, r2, #8, #8
; CHECK-NEXT:    vmov r2, r12, d0
; CHECK-NEXT:    vmsr p0, r3
; CHECK-NEXT:    vmov r4, r3, d4
; CHECK-NEXT:    vpsel q1, q1, q3
; CHECK-NEXT:    vstrw.32 q1, [r0, #16]
; CHECK-NEXT:    subs r2, r4, r2
; CHECK-NEXT:    sbcs.w r2, r3, r12
; CHECK-NEXT:    vmov r4, r3, d5
; CHECK-NEXT:    csetm r2, lo
; CHECK-NEXT:    bfi r1, r2, #0, #8
; CHECK-NEXT:    vmov r2, r12, d1
; CHECK-NEXT:    subs r2, r4, r2
; CHECK-NEXT:    sbcs.w r2, r3, r12
; CHECK-NEXT:    csetm r2, lo
; CHECK-NEXT:    bfi r1, r2, #8, #8
; CHECK-NEXT:    vmsr p0, r1
; CHECK-NEXT:    vpsel q0, q0, q2
; CHECK-NEXT:    vstrw.32 q0, [r0]
; CHECK-NEXT:    pop {r4, pc}
  %c = call <4 x i64> @llvm.umax.v4i64(<4 x i64> %a, <4 x i64> %b)
  store <4 x i64> %c, ptr %p
  ret void
}

declare i8 @llvm.smin.i8(i8 %a, i8 %b) readnone

define arm_aapcs_vfpcc i8 @smini8(i8 %a, i8 %b) {
; CHECK-LABEL: smini8:
; CHECK:       @ %bb.0:
; CHECK-NEXT:    sxtb r1, r1
; CHECK-NEXT:    sxtb r0, r0
; CHECK-NEXT:    cmp r0, r1
; CHECK-NEXT:    csel r0, r0, r1, lt
; CHECK-NEXT:    bx lr
  %c = call i8 @llvm.smin.i8(i8 %a, i8 %b)
  ret i8 %c
}

declare i16 @llvm.smin.i16(i16 %a, i16 %b) readnone

define arm_aapcs_vfpcc i16 @smini16(i16 %a, i16 %b) {
; CHECK-LABEL: smini16:
; CHECK:       @ %bb.0:
; CHECK-NEXT:    sxth r1, r1
; CHECK-NEXT:    sxth r0, r0
; CHECK-NEXT:    cmp r0, r1
; CHECK-NEXT:    csel r0, r0, r1, lt
; CHECK-NEXT:    bx lr
  %c = call i16 @llvm.smin.i16(i16 %a, i16 %b)
  ret i16 %c
}

declare i32 @llvm.smin.i32(i32 %a, i32 %b) readnone

define arm_aapcs_vfpcc i32 @smini32(i32 %a, i32 %b) {
; CHECK-LABEL: smini32:
; CHECK:       @ %bb.0:
; CHECK-NEXT:    cmp r0, r1
; CHECK-NEXT:    csel r0, r0, r1, lt
; CHECK-NEXT:    bx lr
  %c = call i32 @llvm.smin.i32(i32 %a, i32 %b)
  ret i32 %c
}

declare i64 @llvm.smin.i64(i64 %a, i64 %b) readnone

define arm_aapcs_vfpcc i64 @smini64(i64 %a, i64 %b) {
; CHECK-LABEL: smini64:
; CHECK:       @ %bb.0:
; CHECK-NEXT:    subs.w r12, r0, r2
; CHECK-NEXT:    sbcs.w r12, r1, r3
; CHECK-NEXT:    csel r0, r0, r2, lt
; CHECK-NEXT:    csel r1, r1, r3, lt
; CHECK-NEXT:    bx lr
  %c = call i64 @llvm.smin.i64(i64 %a, i64 %b)
  ret i64 %c
}

declare <8 x i8> @llvm.smin.v8i8(<8 x i8> %a, <8 x i8> %b) readnone

define arm_aapcs_vfpcc <8 x i8> @smin8i8(<8 x i8> %a, <8 x i8> %b) {
; CHECK-LABEL: smin8i8:
; CHECK:       @ %bb.0:
; CHECK-NEXT:    vmovlb.s8 q1, q1
; CHECK-NEXT:    vmovlb.s8 q0, q0
; CHECK-NEXT:    vmin.s16 q0, q0, q1
; CHECK-NEXT:    bx lr
  %c = call <8 x i8> @llvm.smin.v8i8(<8 x i8> %a, <8 x i8> %b)
  ret <8 x i8> %c
}

declare <16 x i8> @llvm.smin.v16i8(<16 x i8> %a, <16 x i8> %b) readnone

define arm_aapcs_vfpcc <16 x i8> @smin16i8(<16 x i8> %a, <16 x i8> %b) {
; CHECK-LABEL: smin16i8:
; CHECK:       @ %bb.0:
; CHECK-NEXT:    vmin.s8 q0, q0, q1
; CHECK-NEXT:    bx lr
  %c = call <16 x i8> @llvm.smin.v16i8(<16 x i8> %a, <16 x i8> %b)
  ret <16 x i8> %c
}

declare <32 x i8> @llvm.smin.v32i8(<32 x i8> %a, <32 x i8> %b) readnone

define arm_aapcs_vfpcc void @smin32i8(<32 x i8> %a, <32 x i8> %b, ptr %p) {
; CHECK-LABEL: smin32i8:
; CHECK:       @ %bb.0:
; CHECK-NEXT:    vmin.s8 q1, q1, q3
; CHECK-NEXT:    vmin.s8 q0, q0, q2
; CHECK-NEXT:    vstrw.32 q1, [r0, #16]
; CHECK-NEXT:    vstrw.32 q0, [r0]
; CHECK-NEXT:    bx lr
  %c = call <32 x i8> @llvm.smin.v32i8(<32 x i8> %a, <32 x i8> %b)
  store <32 x i8> %c, ptr %p
  ret void
}

declare <4 x i16> @llvm.smin.v4i16(<4 x i16> %a, <4 x i16> %b) readnone

define arm_aapcs_vfpcc <4 x i16> @smin4i16(<4 x i16> %a, <4 x i16> %b) {
; CHECK-LABEL: smin4i16:
; CHECK:       @ %bb.0:
; CHECK-NEXT:    vmovlb.s16 q1, q1
; CHECK-NEXT:    vmovlb.s16 q0, q0
; CHECK-NEXT:    vmin.s32 q0, q0, q1
; CHECK-NEXT:    bx lr
  %c = call <4 x i16> @llvm.smin.v4i16(<4 x i16> %a, <4 x i16> %b)
  ret <4 x i16> %c
}

declare <8 x i16> @llvm.smin.v8i16(<8 x i16> %a, <8 x i16> %b) readnone

define arm_aapcs_vfpcc <8 x i16> @smin8i16(<8 x i16> %a, <8 x i16> %b) {
; CHECK-LABEL: smin8i16:
; CHECK:       @ %bb.0:
; CHECK-NEXT:    vmin.s16 q0, q0, q1
; CHECK-NEXT:    bx lr
  %c = call <8 x i16> @llvm.smin.v8i16(<8 x i16> %a, <8 x i16> %b)
  ret <8 x i16> %c
}

declare <16 x i16> @llvm.smin.v16i16(<16 x i16> %a, <16 x i16> %b) readnone

define arm_aapcs_vfpcc void @smin16i16(<16 x i16> %a, <16 x i16> %b, ptr %p) {
; CHECK-LABEL: smin16i16:
; CHECK:       @ %bb.0:
; CHECK-NEXT:    vmin.s16 q1, q1, q3
; CHECK-NEXT:    vmin.s16 q0, q0, q2
; CHECK-NEXT:    vstrw.32 q1, [r0, #16]
; CHECK-NEXT:    vstrw.32 q0, [r0]
; CHECK-NEXT:    bx lr
  %c = call <16 x i16> @llvm.smin.v16i16(<16 x i16> %a, <16 x i16> %b)
  store <16 x i16> %c, ptr %p
  ret void
}

declare <2 x i32> @llvm.smin.v2i32(<2 x i32> %a, <2 x i32> %b) readnone

define arm_aapcs_vfpcc <2 x i32> @smin2i32(<2 x i32> %a, <2 x i32> %b) {
; CHECK-LABEL: smin2i32:
; CHECK:       @ %bb.0:
; CHECK-NEXT:    .save {r7, lr}
; CHECK-NEXT:    push {r7, lr}
; CHECK-NEXT:    vmov r0, s6
; CHECK-NEXT:    vmov r1, s4
; CHECK-NEXT:    vmov q1[2], q1[0], r1, r0
; CHECK-NEXT:    asrs r2, r0, #31
; CHECK-NEXT:    asrs r3, r1, #31
; CHECK-NEXT:    vmov q1[3], q1[1], r3, r2
; CHECK-NEXT:    vmov r3, s0
; CHECK-NEXT:    vmov r2, s2
; CHECK-NEXT:    vmov q0[2], q0[0], r3, r2
; CHECK-NEXT:    asr.w lr, r3, #31
; CHECK-NEXT:    subs r3, r3, r1
; CHECK-NEXT:    sbcs.w r1, lr, r1, asr #31
; CHECK-NEXT:    mov.w r3, #0
; CHECK-NEXT:    csetm r1, lt
; CHECK-NEXT:    asr.w r12, r2, #31
; CHECK-NEXT:    bfi r3, r1, #0, #8
; CHECK-NEXT:    subs r1, r2, r0
; CHECK-NEXT:    sbcs.w r0, r12, r0, asr #31
; CHECK-NEXT:    vmov q0[3], q0[1], lr, r12
; CHECK-NEXT:    csetm r0, lt
; CHECK-NEXT:    bfi r3, r0, #8, #8
; CHECK-NEXT:    vmsr p0, r3
; CHECK-NEXT:    vpsel q0, q0, q1
; CHECK-NEXT:    pop {r7, pc}
  %c = call <2 x i32> @llvm.smin.v2i32(<2 x i32> %a, <2 x i32> %b)
  ret <2 x i32> %c
}

declare <4 x i32> @llvm.smin.v4i32(<4 x i32> %a, <4 x i32> %b) readnone

define arm_aapcs_vfpcc <4 x i32> @smin4i32(<4 x i32> %a, <4 x i32> %b) {
; CHECK-LABEL: smin4i32:
; CHECK:       @ %bb.0:
; CHECK-NEXT:    vmin.s32 q0, q0, q1
; CHECK-NEXT:    bx lr
  %c = call <4 x i32> @llvm.smin.v4i32(<4 x i32> %a, <4 x i32> %b)
  ret <4 x i32> %c
}

declare <8 x i32> @llvm.smin.v8i32(<8 x i32> %a, <8 x i32> %b) readnone

define arm_aapcs_vfpcc void @smin8i32(<8 x i32> %a, <8 x i32> %b, ptr %p) {
; CHECK-LABEL: smin8i32:
; CHECK:       @ %bb.0:
; CHECK-NEXT:    vmin.s32 q1, q1, q3
; CHECK-NEXT:    vmin.s32 q0, q0, q2
; CHECK-NEXT:    vstrw.32 q1, [r0, #16]
; CHECK-NEXT:    vstrw.32 q0, [r0]
; CHECK-NEXT:    bx lr
  %c = call <8 x i32>@llvm.smin.v8i32(<8 x i32> %a, <8 x i32> %b)
  store <8 x i32> %c, ptr %p
  ret void
}

declare <1 x i64> @llvm.smin.v1i64(<1 x i64> %a, <1 x i64> %b) readnone

define arm_aapcs_vfpcc <1 x i64> @smin1i64(<1 x i64> %a, <1 x i64> %b) {
; CHECK-LABEL: smin1i64:
; CHECK:       @ %bb.0:
; CHECK-NEXT:    .pad #8
; CHECK-NEXT:    sub sp, #8
; CHECK-NEXT:    subs.w r12, r0, r2
; CHECK-NEXT:    sbcs.w r12, r1, r3
; CHECK-NEXT:    csel r0, r0, r2, lt
; CHECK-NEXT:    csel r1, r1, r3, lt
; CHECK-NEXT:    add sp, #8
; CHECK-NEXT:    bx lr
  %c = call <1 x i64> @llvm.smin.v1i64(<1 x i64> %a, <1 x i64> %b)
  ret <1 x i64> %c
}

declare <2 x i64> @llvm.smin.v2i64(<2 x i64> %a, <2 x i64> %b) readnone

define arm_aapcs_vfpcc <2 x i64> @smin2i64(<2 x i64> %a, <2 x i64> %b) {
; CHECK-LABEL: smin2i64:
; CHECK:       @ %bb.0:
; CHECK-NEXT:    vmov r0, r1, d2
; CHECK-NEXT:    vmov r2, r3, d0
; CHECK-NEXT:    subs r0, r2, r0
; CHECK-NEXT:    sbcs.w r0, r3, r1
; CHECK-NEXT:    mov.w r1, #0
; CHECK-NEXT:    csetm r0, lt
; CHECK-NEXT:    vmov r3, r2, d1
; CHECK-NEXT:    bfi r1, r0, #0, #8
; CHECK-NEXT:    vmov r0, r12, d3
; CHECK-NEXT:    subs r0, r3, r0
; CHECK-NEXT:    sbcs.w r0, r2, r12
; CHECK-NEXT:    csetm r0, lt
; CHECK-NEXT:    bfi r1, r0, #8, #8
; CHECK-NEXT:    vmsr p0, r1
; CHECK-NEXT:    vpsel q0, q0, q1
; CHECK-NEXT:    bx lr
  %c = call <2 x i64> @llvm.smin.v2i64(<2 x i64> %a, <2 x i64> %b)
  ret <2 x i64> %c
}

declare <4 x i64> @llvm.smin.v4i64(<4 x i64> %a, <4 x i64> %b) readnone

define arm_aapcs_vfpcc void @smin4i64(<4 x i64> %a, <4 x i64> %b, ptr %p) {
; CHECK-LABEL: smin4i64:
; CHECK:       @ %bb.0:
; CHECK-NEXT:    .save {r4, lr}
; CHECK-NEXT:    push {r4, lr}
; CHECK-NEXT:    vmov r1, r12, d6
; CHECK-NEXT:    vmov r3, r2, d2
; CHECK-NEXT:    subs r1, r3, r1
; CHECK-NEXT:    mov.w r3, #0
; CHECK-NEXT:    sbcs.w r1, r2, r12
; CHECK-NEXT:    vmov lr, r12, d7
; CHECK-NEXT:    csetm r2, lt
; CHECK-NEXT:    movs r1, #0
; CHECK-NEXT:    bfi r3, r2, #0, #8
; CHECK-NEXT:    vmov r2, r4, d3
; CHECK-NEXT:    subs.w r2, r2, lr
; CHECK-NEXT:    sbcs.w r2, r4, r12
; CHECK-NEXT:    csetm r2, lt
; CHECK-NEXT:    bfi r3, r2, #8, #8
; CHECK-NEXT:    vmov r2, r12, d4
; CHECK-NEXT:    vmsr p0, r3
; CHECK-NEXT:    vmov r4, r3, d0
; CHECK-NEXT:    vpsel q1, q1, q3
; CHECK-NEXT:    vstrw.32 q1, [r0, #16]
; CHECK-NEXT:    subs r2, r4, r2
; CHECK-NEXT:    sbcs.w r2, r3, r12
; CHECK-NEXT:    vmov r4, r3, d1
; CHECK-NEXT:    csetm r2, lt
; CHECK-NEXT:    bfi r1, r2, #0, #8
; CHECK-NEXT:    vmov r2, r12, d5
; CHECK-NEXT:    subs r2, r4, r2
; CHECK-NEXT:    sbcs.w r2, r3, r12
; CHECK-NEXT:    csetm r2, lt
; CHECK-NEXT:    bfi r1, r2, #8, #8
; CHECK-NEXT:    vmsr p0, r1
; CHECK-NEXT:    vpsel q0, q0, q2
; CHECK-NEXT:    vstrw.32 q0, [r0]
; CHECK-NEXT:    pop {r4, pc}
  %c = call <4 x i64> @llvm.smin.v4i64(<4 x i64> %a, <4 x i64> %b)
  store <4 x i64> %c, ptr %p
  ret void
}

declare i8 @llvm.umin.i8(i8 %a, i8 %b) readnone

define arm_aapcs_vfpcc i8 @umini8(i8 %a, i8 %b) {
; CHECK-LABEL: umini8:
; CHECK:       @ %bb.0:
; CHECK-NEXT:    uxtb r1, r1
; CHECK-NEXT:    uxtb r0, r0
; CHECK-NEXT:    cmp r0, r1
; CHECK-NEXT:    csel r0, r0, r1, lo
; CHECK-NEXT:    bx lr
  %c = call i8 @llvm.umin.i8(i8 %a, i8 %b)
  ret i8 %c
}

declare i16 @llvm.umin.i16(i16 %a, i16 %b) readnone

define arm_aapcs_vfpcc i16 @umini16(i16 %a, i16 %b) {
; CHECK-LABEL: umini16:
; CHECK:       @ %bb.0:
; CHECK-NEXT:    uxth r1, r1
; CHECK-NEXT:    uxth r0, r0
; CHECK-NEXT:    cmp r0, r1
; CHECK-NEXT:    csel r0, r0, r1, lo
; CHECK-NEXT:    bx lr
  %c = call i16 @llvm.umin.i16(i16 %a, i16 %b)
  ret i16 %c
}

declare i32 @llvm.umin.i32(i32 %a, i32 %b) readnone

define arm_aapcs_vfpcc i32 @umini32(i32 %a, i32 %b) {
; CHECK-LABEL: umini32:
; CHECK:       @ %bb.0:
; CHECK-NEXT:    cmp r0, r1
; CHECK-NEXT:    csel r0, r0, r1, lo
; CHECK-NEXT:    bx lr
  %c = call i32 @llvm.umin.i32(i32 %a, i32 %b)
  ret i32 %c
}

declare i64 @llvm.umin.i64(i64 %a, i64 %b) readnone

define arm_aapcs_vfpcc i64 @umini64(i64 %a, i64 %b) {
; CHECK-LABEL: umini64:
; CHECK:       @ %bb.0:
; CHECK-NEXT:    subs.w r12, r0, r2
; CHECK-NEXT:    sbcs.w r12, r1, r3
; CHECK-NEXT:    csel r0, r0, r2, lo
; CHECK-NEXT:    csel r1, r1, r3, lo
; CHECK-NEXT:    bx lr
  %c = call i64 @llvm.umin.i64(i64 %a, i64 %b)
  ret i64 %c
}

declare <8 x i8> @llvm.umin.v8i8(<8 x i8> %a, <8 x i8> %b) readnone

define arm_aapcs_vfpcc <8 x i8> @umin8i8(<8 x i8> %a, <8 x i8> %b) {
; CHECK-LABEL: umin8i8:
; CHECK:       @ %bb.0:
; CHECK-NEXT:    vmovlb.u8 q1, q1
; CHECK-NEXT:    vmovlb.u8 q0, q0
; CHECK-NEXT:    vmin.u16 q0, q0, q1
; CHECK-NEXT:    bx lr
  %c = call <8 x i8> @llvm.umin.v8i8(<8 x i8> %a, <8 x i8> %b)
  ret <8 x i8> %c
}

declare <16 x i8> @llvm.umin.v16i8(<16 x i8> %a, <16 x i8> %b) readnone

define arm_aapcs_vfpcc <16 x i8> @umin16i8(<16 x i8> %a, <16 x i8> %b) {
; CHECK-LABEL: umin16i8:
; CHECK:       @ %bb.0:
; CHECK-NEXT:    vmin.u8 q0, q0, q1
; CHECK-NEXT:    bx lr
  %c = call <16 x i8> @llvm.umin.v16i8(<16 x i8> %a, <16 x i8> %b)
  ret <16 x i8> %c
}

declare <32 x i8> @llvm.umin.v32i8(<32 x i8> %a, <32 x i8> %b) readnone

define arm_aapcs_vfpcc void @umin32i8(<32 x i8> %a, <32 x i8> %b, ptr %p) {
; CHECK-LABEL: umin32i8:
; CHECK:       @ %bb.0:
; CHECK-NEXT:    vmin.u8 q1, q1, q3
; CHECK-NEXT:    vmin.u8 q0, q0, q2
; CHECK-NEXT:    vstrw.32 q1, [r0, #16]
; CHECK-NEXT:    vstrw.32 q0, [r0]
; CHECK-NEXT:    bx lr
  %c = call <32 x i8> @llvm.umin.v32i8(<32 x i8> %a, <32 x i8> %b)
  store <32 x i8> %c, ptr %p
  ret void
}

declare <4 x i16> @llvm.umin.v4i16(<4 x i16> %a, <4 x i16> %b) readnone

define arm_aapcs_vfpcc <4 x i16> @umin4i16(<4 x i16> %a, <4 x i16> %b) {
; CHECK-LABEL: umin4i16:
; CHECK:       @ %bb.0:
; CHECK-NEXT:    vmovlb.u16 q1, q1
; CHECK-NEXT:    vmovlb.u16 q0, q0
; CHECK-NEXT:    vmin.u32 q0, q0, q1
; CHECK-NEXT:    bx lr
  %c = call <4 x i16> @llvm.umin.v4i16(<4 x i16> %a, <4 x i16> %b)
  ret <4 x i16> %c
}

declare <8 x i16> @llvm.umin.v8i16(<8 x i16> %a, <8 x i16> %b) readnone

define arm_aapcs_vfpcc <8 x i16> @umin8i16(<8 x i16> %a, <8 x i16> %b) {
; CHECK-LABEL: umin8i16:
; CHECK:       @ %bb.0:
; CHECK-NEXT:    vmin.u16 q0, q0, q1
; CHECK-NEXT:    bx lr
  %c = call <8 x i16> @llvm.umin.v8i16(<8 x i16> %a, <8 x i16> %b)
  ret <8 x i16> %c
}

declare <16 x i16> @llvm.umin.v16i16(<16 x i16> %a, <16 x i16> %b) readnone

define arm_aapcs_vfpcc void @umin16i16(<16 x i16> %a, <16 x i16> %b, ptr %p) {
; CHECK-LABEL: umin16i16:
; CHECK:       @ %bb.0:
; CHECK-NEXT:    vmin.u16 q1, q1, q3
; CHECK-NEXT:    vmin.u16 q0, q0, q2
; CHECK-NEXT:    vstrw.32 q1, [r0, #16]
; CHECK-NEXT:    vstrw.32 q0, [r0]
; CHECK-NEXT:    bx lr
  %c = call <16 x i16> @llvm.umin.v16i16(<16 x i16> %a, <16 x i16> %b)
  store <16 x i16> %c, ptr %p
  ret void
}

declare <2 x i32> @llvm.umin.v2i32(<2 x i32> %a, <2 x i32> %b) readnone

define arm_aapcs_vfpcc <2 x i32> @umin2i32(<2 x i32> %a, <2 x i32> %b) {
; CHECK-LABEL: umin2i32:
; CHECK:       @ %bb.0:
; CHECK-NEXT:    vmov.i64 q2, #0xffffffff
; CHECK-NEXT:    vand q1, q1, q2
; CHECK-NEXT:    vand q0, q0, q2
; CHECK-NEXT:    vmov r0, r1, d2
; CHECK-NEXT:    vmov r2, r3, d0
; CHECK-NEXT:    subs r0, r2, r0
; CHECK-NEXT:    sbcs.w r0, r3, r1
; CHECK-NEXT:    mov.w r1, #0
; CHECK-NEXT:    csetm r0, lo
; CHECK-NEXT:    vmov r3, r2, d1
; CHECK-NEXT:    bfi r1, r0, #0, #8
; CHECK-NEXT:    vmov r0, r12, d3
; CHECK-NEXT:    subs r0, r3, r0
; CHECK-NEXT:    sbcs.w r0, r2, r12
; CHECK-NEXT:    csetm r0, lo
; CHECK-NEXT:    bfi r1, r0, #8, #8
; CHECK-NEXT:    vmsr p0, r1
; CHECK-NEXT:    vpsel q0, q0, q1
; CHECK-NEXT:    bx lr
  %c = call <2 x i32> @llvm.umin.v2i32(<2 x i32> %a, <2 x i32> %b)
  ret <2 x i32> %c
}

declare <4 x i32> @llvm.umin.v4i32(<4 x i32> %a, <4 x i32> %b) readnone

define arm_aapcs_vfpcc <4 x i32> @umin4i32(<4 x i32> %a, <4 x i32> %b) {
; CHECK-LABEL: umin4i32:
; CHECK:       @ %bb.0:
; CHECK-NEXT:    vmin.u32 q0, q0, q1
; CHECK-NEXT:    bx lr
  %c = call <4 x i32> @llvm.umin.v4i32(<4 x i32> %a, <4 x i32> %b)
  ret <4 x i32> %c
}

declare <8 x i32> @llvm.umin.v8i32(<8 x i32> %a, <8 x i32> %b) readnone

define arm_aapcs_vfpcc void @umin8i32(<8 x i32> %a, <8 x i32> %b, ptr %p) {
; CHECK-LABEL: umin8i32:
; CHECK:       @ %bb.0:
; CHECK-NEXT:    vmin.u32 q1, q1, q3
; CHECK-NEXT:    vmin.u32 q0, q0, q2
; CHECK-NEXT:    vstrw.32 q1, [r0, #16]
; CHECK-NEXT:    vstrw.32 q0, [r0]
; CHECK-NEXT:    bx lr
  %c = call <8 x i32>@llvm.umin.v8i32(<8 x i32> %a, <8 x i32> %b)
  store <8 x i32> %c, ptr %p
  ret void
}

declare <1 x i64> @llvm.umin.v1i64(<1 x i64> %a, <1 x i64> %b) readnone

define arm_aapcs_vfpcc <1 x i64> @umin1i64(<1 x i64> %a, <1 x i64> %b) {
; CHECK-LABEL: umin1i64:
; CHECK:       @ %bb.0:
; CHECK-NEXT:    .pad #8
; CHECK-NEXT:    sub sp, #8
; CHECK-NEXT:    subs.w r12, r0, r2
; CHECK-NEXT:    sbcs.w r12, r1, r3
; CHECK-NEXT:    csel r0, r0, r2, lo
; CHECK-NEXT:    csel r1, r1, r3, lo
; CHECK-NEXT:    add sp, #8
; CHECK-NEXT:    bx lr
  %c = call <1 x i64> @llvm.umin.v1i64(<1 x i64> %a, <1 x i64> %b)
  ret <1 x i64> %c
}

declare <2 x i64> @llvm.umin.v2i64(<2 x i64> %a, <2 x i64> %b) readnone

define arm_aapcs_vfpcc <2 x i64> @umin2i64(<2 x i64> %a, <2 x i64> %b) {
; CHECK-LABEL: umin2i64:
; CHECK:       @ %bb.0:
; CHECK-NEXT:    vmov r0, r1, d2
; CHECK-NEXT:    vmov r2, r3, d0
; CHECK-NEXT:    subs r0, r2, r0
; CHECK-NEXT:    sbcs.w r0, r3, r1
; CHECK-NEXT:    mov.w r1, #0
; CHECK-NEXT:    csetm r0, lo
; CHECK-NEXT:    vmov r3, r2, d1
; CHECK-NEXT:    bfi r1, r0, #0, #8
; CHECK-NEXT:    vmov r0, r12, d3
; CHECK-NEXT:    subs r0, r3, r0
; CHECK-NEXT:    sbcs.w r0, r2, r12
; CHECK-NEXT:    csetm r0, lo
; CHECK-NEXT:    bfi r1, r0, #8, #8
; CHECK-NEXT:    vmsr p0, r1
; CHECK-NEXT:    vpsel q0, q0, q1
; CHECK-NEXT:    bx lr
  %c = call <2 x i64> @llvm.umin.v2i64(<2 x i64> %a, <2 x i64> %b)
  ret <2 x i64> %c
}

declare <4 x i64> @llvm.umin.v4i64(<4 x i64> %a, <4 x i64> %b) readnone

define arm_aapcs_vfpcc void @umin4i64(<4 x i64> %a, <4 x i64> %b, ptr %p) {
; CHECK-LABEL: umin4i64:
; CHECK:       @ %bb.0:
; CHECK-NEXT:    .save {r4, lr}
; CHECK-NEXT:    push {r4, lr}
; CHECK-NEXT:    vmov r1, r12, d6
; CHECK-NEXT:    vmov r3, r2, d2
; CHECK-NEXT:    subs r1, r3, r1
; CHECK-NEXT:    mov.w r3, #0
; CHECK-NEXT:    sbcs.w r1, r2, r12
; CHECK-NEXT:    vmov lr, r12, d7
; CHECK-NEXT:    csetm r2, lo
; CHECK-NEXT:    movs r1, #0
; CHECK-NEXT:    bfi r3, r2, #0, #8
; CHECK-NEXT:    vmov r2, r4, d3
; CHECK-NEXT:    subs.w r2, r2, lr
; CHECK-NEXT:    sbcs.w r2, r4, r12
; CHECK-NEXT:    csetm r2, lo
; CHECK-NEXT:    bfi r3, r2, #8, #8
; CHECK-NEXT:    vmov r2, r12, d4
; CHECK-NEXT:    vmsr p0, r3
; CHECK-NEXT:    vmov r4, r3, d0
; CHECK-NEXT:    vpsel q1, q1, q3
; CHECK-NEXT:    vstrw.32 q1, [r0, #16]
; CHECK-NEXT:    subs r2, r4, r2
; CHECK-NEXT:    sbcs.w r2, r3, r12
; CHECK-NEXT:    vmov r4, r3, d1
; CHECK-NEXT:    csetm r2, lo
; CHECK-NEXT:    bfi r1, r2, #0, #8
; CHECK-NEXT:    vmov r2, r12, d5
; CHECK-NEXT:    subs r2, r4, r2
; CHECK-NEXT:    sbcs.w r2, r3, r12
; CHECK-NEXT:    csetm r2, lo
; CHECK-NEXT:    bfi r1, r2, #8, #8
; CHECK-NEXT:    vmsr p0, r1
; CHECK-NEXT:    vpsel q0, q0, q2
; CHECK-NEXT:    vstrw.32 q0, [r0]
; CHECK-NEXT:    pop {r4, pc}
  %c = call <4 x i64> @llvm.umin.v4i64(<4 x i64> %a, <4 x i64> %b)
  store <4 x i64> %c, ptr %p
  ret void
}
