/* DirHandling.c generated by valac 0.30.0, the Vala compiler
 * generated from DirHandling.vala, do not modify */

/* -*- Mode: Vala; indent-tabs-mode: nil; tab-width: 2 -*- */
/*
    This file is part of Déjà Dup.
    For copyright information, see AUTHORS.

    Déjà Dup is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    Déjà Dup is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Déjà Dup.  If not, see <http://www.gnu.org/licenses/>.
*/

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>

#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))



gchar* deja_dup_get_trash_path (void);
gchar* deja_dup_parse_keywords (const gchar* dir);
GFile* deja_dup_parse_dir (const gchar* dir);
GFile** deja_dup_parse_dir_list (const gchar** dirs, int dirs_length1, int* result_length1);
static void _vala_array_add1 (GFile*** array, int* length, int* size, GFile* value);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);


gchar* deja_dup_get_trash_path (void) {
	gchar* result = NULL;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	_tmp0_ = g_get_user_data_dir ();
	_tmp1_ = g_build_filename (_tmp0_, "Trash", NULL);
	result = _tmp1_;
	return result;
}


static gchar* string_replace (const gchar* self, const gchar* old, const gchar* replacement) {
	gchar* result = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	{
		GRegex* regex = NULL;
		const gchar* _tmp0_ = NULL;
		gchar* _tmp1_ = NULL;
		gchar* _tmp2_ = NULL;
		GRegex* _tmp3_ = NULL;
		GRegex* _tmp4_ = NULL;
		gchar* _tmp5_ = NULL;
		GRegex* _tmp6_ = NULL;
		const gchar* _tmp7_ = NULL;
		gchar* _tmp8_ = NULL;
		gchar* _tmp9_ = NULL;
		_tmp0_ = old;
		_tmp1_ = g_regex_escape_string (_tmp0_, -1);
		_tmp2_ = _tmp1_;
		_tmp3_ = g_regex_new (_tmp2_, 0, 0, &_inner_error_);
		_tmp4_ = _tmp3_;
		_g_free0 (_tmp2_);
		regex = _tmp4_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch29_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_tmp6_ = regex;
		_tmp7_ = replacement;
		_tmp8_ = g_regex_replace_literal (_tmp6_, self, (gssize) -1, 0, _tmp7_, 0, &_inner_error_);
		_tmp5_ = _tmp8_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_regex_unref0 (regex);
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch29_g_regex_error;
			}
			_g_regex_unref0 (regex);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_tmp9_ = _tmp5_;
		_tmp5_ = NULL;
		result = _tmp9_;
		_g_free0 (_tmp5_);
		_g_regex_unref0 (regex);
		return result;
	}
	goto __finally29;
	__catch29_g_regex_error:
	{
		GError* e = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		g_assert_not_reached ();
		_g_error_free0 (e);
	}
	__finally29:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
}


gchar* deja_dup_parse_keywords (const gchar* dir) {
	gchar* result = NULL;
	gchar* _result_ = NULL;
	const gchar* _tmp0_ = NULL;
	g_return_val_if_fail (dir != NULL, NULL);
	_result_ = NULL;
	_tmp0_ = dir;
	if (g_strcmp0 (_tmp0_, "$HOME") == 0) {
		const gchar* _tmp1_ = NULL;
		gchar* _tmp2_ = NULL;
		_tmp1_ = g_get_home_dir ();
		_tmp2_ = g_strdup (_tmp1_);
		_g_free0 (_result_);
		_result_ = _tmp2_;
	} else {
		const gchar* _tmp3_ = NULL;
		_tmp3_ = dir;
		if (g_strcmp0 (_tmp3_, "$DESKTOP") == 0) {
			const gchar* _tmp4_ = NULL;
			gchar* _tmp5_ = NULL;
			_tmp4_ = g_get_user_special_dir (G_USER_DIRECTORY_DESKTOP);
			_tmp5_ = g_strdup (_tmp4_);
			_g_free0 (_result_);
			_result_ = _tmp5_;
		} else {
			const gchar* _tmp6_ = NULL;
			_tmp6_ = dir;
			if (g_strcmp0 (_tmp6_, "$DOCUMENTS") == 0) {
				const gchar* _tmp7_ = NULL;
				gchar* _tmp8_ = NULL;
				_tmp7_ = g_get_user_special_dir (G_USER_DIRECTORY_DOCUMENTS);
				_tmp8_ = g_strdup (_tmp7_);
				_g_free0 (_result_);
				_result_ = _tmp8_;
			} else {
				const gchar* _tmp9_ = NULL;
				_tmp9_ = dir;
				if (g_strcmp0 (_tmp9_, "$DOWNLOAD") == 0) {
					const gchar* _tmp10_ = NULL;
					gchar* _tmp11_ = NULL;
					_tmp10_ = g_get_user_special_dir (G_USER_DIRECTORY_DOWNLOAD);
					_tmp11_ = g_strdup (_tmp10_);
					_g_free0 (_result_);
					_result_ = _tmp11_;
				} else {
					const gchar* _tmp12_ = NULL;
					_tmp12_ = dir;
					if (g_strcmp0 (_tmp12_, "$MUSIC") == 0) {
						const gchar* _tmp13_ = NULL;
						gchar* _tmp14_ = NULL;
						_tmp13_ = g_get_user_special_dir (G_USER_DIRECTORY_MUSIC);
						_tmp14_ = g_strdup (_tmp13_);
						_g_free0 (_result_);
						_result_ = _tmp14_;
					} else {
						const gchar* _tmp15_ = NULL;
						_tmp15_ = dir;
						if (g_strcmp0 (_tmp15_, "$PICTURES") == 0) {
							const gchar* _tmp16_ = NULL;
							gchar* _tmp17_ = NULL;
							_tmp16_ = g_get_user_special_dir (G_USER_DIRECTORY_PICTURES);
							_tmp17_ = g_strdup (_tmp16_);
							_g_free0 (_result_);
							_result_ = _tmp17_;
						} else {
							const gchar* _tmp18_ = NULL;
							_tmp18_ = dir;
							if (g_strcmp0 (_tmp18_, "$PUBLIC_SHARE") == 0) {
								const gchar* _tmp19_ = NULL;
								gchar* _tmp20_ = NULL;
								_tmp19_ = g_get_user_special_dir (G_USER_DIRECTORY_PUBLIC_SHARE);
								_tmp20_ = g_strdup (_tmp19_);
								_g_free0 (_result_);
								_result_ = _tmp20_;
							} else {
								const gchar* _tmp21_ = NULL;
								_tmp21_ = dir;
								if (g_strcmp0 (_tmp21_, "$TEMPLATES") == 0) {
									const gchar* _tmp22_ = NULL;
									gchar* _tmp23_ = NULL;
									_tmp22_ = g_get_user_special_dir (G_USER_DIRECTORY_TEMPLATES);
									_tmp23_ = g_strdup (_tmp22_);
									_g_free0 (_result_);
									_result_ = _tmp23_;
								} else {
									const gchar* _tmp24_ = NULL;
									_tmp24_ = dir;
									if (g_strcmp0 (_tmp24_, "$TRASH") == 0) {
										gchar* _tmp25_ = NULL;
										_tmp25_ = deja_dup_get_trash_path ();
										_g_free0 (_result_);
										_result_ = _tmp25_;
									} else {
										const gchar* _tmp26_ = NULL;
										_tmp26_ = dir;
										if (g_strcmp0 (_tmp26_, "$VIDEOS") == 0) {
											const gchar* _tmp27_ = NULL;
											gchar* _tmp28_ = NULL;
											_tmp27_ = g_get_user_special_dir (G_USER_DIRECTORY_VIDEOS);
											_tmp28_ = g_strdup (_tmp27_);
											_g_free0 (_result_);
											_result_ = _tmp28_;
										} else {
											const gchar* _tmp29_ = NULL;
											const gchar* _tmp30_ = NULL;
											gchar* _tmp31_ = NULL;
											gboolean _tmp32_ = FALSE;
											const gchar* _tmp33_ = NULL;
											gchar* _tmp34_ = NULL;
											gchar* _tmp35_ = NULL;
											gboolean _tmp36_ = FALSE;
											_tmp29_ = dir;
											_tmp30_ = g_get_user_name ();
											_tmp31_ = string_replace (_tmp29_, "$USER", _tmp30_);
											_g_free0 (_result_);
											_result_ = _tmp31_;
											_tmp33_ = _result_;
											_tmp34_ = g_uri_parse_scheme (_tmp33_);
											_tmp35_ = _tmp34_;
											_tmp36_ = _tmp35_ == NULL;
											_g_free0 (_tmp35_);
											if (_tmp36_) {
												const gchar* _tmp37_ = NULL;
												gboolean _tmp38_ = FALSE;
												_tmp37_ = _result_;
												_tmp38_ = g_path_is_absolute (_tmp37_);
												_tmp32_ = !_tmp38_;
											} else {
												_tmp32_ = FALSE;
											}
											if (_tmp32_) {
												const gchar* _tmp39_ = NULL;
												const gchar* _tmp40_ = NULL;
												gchar* _tmp41_ = NULL;
												_tmp39_ = g_get_home_dir ();
												_tmp40_ = _result_;
												_tmp41_ = g_build_filename (_tmp39_, _tmp40_, NULL);
												_g_free0 (_result_);
												_result_ = _tmp41_;
											}
										}
									}
								}
							}
						}
					}
				}
			}
		}
	}
	result = _result_;
	return result;
}


GFile* deja_dup_parse_dir (const gchar* dir) {
	GFile* result = NULL;
	gchar* _result_ = NULL;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	g_return_val_if_fail (dir != NULL, NULL);
	_tmp0_ = dir;
	_tmp1_ = deja_dup_parse_keywords (_tmp0_);
	_result_ = _tmp1_;
	_tmp2_ = _result_;
	if (_tmp2_ != NULL) {
		const gchar* _tmp3_ = NULL;
		GFile* _tmp4_ = NULL;
		_tmp3_ = _result_;
		_tmp4_ = g_file_parse_name (_tmp3_);
		result = _tmp4_;
		_g_free0 (_result_);
		return result;
	} else {
		result = NULL;
		_g_free0 (_result_);
		return result;
	}
	_g_free0 (_result_);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void _vala_array_add1 (GFile*** array, int* length, int* size, GFile* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (GFile*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


GFile** deja_dup_parse_dir_list (const gchar** dirs, int dirs_length1, int* result_length1) {
	GFile** result = NULL;
	GFile** rv = NULL;
	GFile** _tmp0_ = NULL;
	gint rv_length1 = 0;
	gint _rv_size_ = 0;
	const gchar** _tmp1_ = NULL;
	gint _tmp1__length1 = 0;
	GFile** _tmp9_ = NULL;
	gint _tmp9__length1 = 0;
	_tmp0_ = g_new0 (GFile*, 0 + 1);
	rv = _tmp0_;
	rv_length1 = 0;
	_rv_size_ = rv_length1;
	_tmp1_ = dirs;
	_tmp1__length1 = dirs_length1;
	{
		const gchar** s_collection = NULL;
		gint s_collection_length1 = 0;
		gint _s_collection_size_ = 0;
		gint s_it = 0;
		s_collection = _tmp1_;
		s_collection_length1 = _tmp1__length1;
		for (s_it = 0; s_it < _tmp1__length1; s_it = s_it + 1) {
			gchar* _tmp2_ = NULL;
			gchar* s = NULL;
			_tmp2_ = g_strdup ((gchar*) s_collection[s_it]);
			s = _tmp2_;
			{
				GFile* f = NULL;
				const gchar* _tmp3_ = NULL;
				GFile* _tmp4_ = NULL;
				GFile* _tmp5_ = NULL;
				_tmp3_ = s;
				_tmp4_ = deja_dup_parse_dir (_tmp3_);
				f = _tmp4_;
				_tmp5_ = f;
				if (_tmp5_ != NULL) {
					GFile** _tmp6_ = NULL;
					gint _tmp6__length1 = 0;
					GFile* _tmp7_ = NULL;
					GFile* _tmp8_ = NULL;
					_tmp6_ = rv;
					_tmp6__length1 = rv_length1;
					_tmp7_ = f;
					_tmp8_ = _g_object_ref0 (_tmp7_);
					_vala_array_add1 (&rv, &rv_length1, &_rv_size_, _tmp8_);
				}
				_g_object_unref0 (f);
				_g_free0 (s);
			}
		}
	}
	_tmp9_ = rv;
	_tmp9__length1 = rv_length1;
	if (result_length1) {
		*result_length1 = _tmp9__length1;
	}
	result = _tmp9_;
	return result;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



