; NOTE: Assertions have been autogenerated by utils/update_analyze_test_checks.py UTC_ARGS: --version 4
; RUN: opt -disable-output "-passes=print<scalar-evolution>" -scalar-evolution-classify-expressions=0 < %s 2>&1 | FileCheck %s


define i32 @multiple_exits_with_predicates(ptr %src1, ptr readonly %src2, i32 %end) {
; CHECK-LABEL: 'multiple_exits_with_predicates'
; CHECK-NEXT:  Determining loop execution counts for: @multiple_exits_with_predicates
; CHECK-NEXT:  Loop %for.body: <multiple exits> Unpredictable backedge-taken count.
; CHECK-NEXT:    exit count for for.body: ***COULDNOTCOMPUTE***
; CHECK-NEXT:    predicated exit count for for.body: i32 1023
; CHECK-NEXT:     Predicates:
; CHECK-NEXT:      {1,+,1}<%for.body> Added Flags: <nusw>
; CHECK-EMPTY:
; CHECK-NEXT:    exit count for for.work: ***COULDNOTCOMPUTE***
; CHECK-NEXT:    exit count for for.inc: ***COULDNOTCOMPUTE***
; CHECK-NEXT:    predicated exit count for for.inc: (-1 + (1 umax %end))
; CHECK-NEXT:     Predicates:
; CHECK-NEXT:      {1,+,1}<%for.body> Added Flags: <nusw>
; CHECK-EMPTY:
; CHECK-NEXT:  Loop %for.body: Unpredictable constant max backedge-taken count.
; CHECK-NEXT:  Loop %for.body: Unpredictable symbolic max backedge-taken count.
; CHECK-NEXT:    symbolic max exit count for for.body: ***COULDNOTCOMPUTE***
; CHECK-NEXT:    predicated symbolic max exit count for for.body: i32 1023
; CHECK-NEXT:     Predicates:
; CHECK-NEXT:      {1,+,1}<%for.body> Added Flags: <nusw>
; CHECK-EMPTY:
; CHECK-NEXT:    symbolic max exit count for for.work: ***COULDNOTCOMPUTE***
; CHECK-NEXT:    symbolic max exit count for for.inc: ***COULDNOTCOMPUTE***
; CHECK-NEXT:    predicated symbolic max exit count for for.inc: (-1 + (1 umax %end))
; CHECK-NEXT:     Predicates:
; CHECK-NEXT:      {1,+,1}<%for.body> Added Flags: <nusw>
; CHECK-EMPTY:
; CHECK-NEXT:  Loop %for.body: Predicated constant max backedge-taken count is i32 1023
; CHECK-NEXT:   Predicates:
; CHECK-NEXT:      {1,+,1}<%for.body> Added Flags: <nusw>
; CHECK-NEXT:      {1,+,1}<%for.body> Added Flags: <nusw>
; CHECK-NEXT:  Loop %for.body: Predicated symbolic max backedge-taken count is (1023 umin (-1 + (1 umax %end)))
; CHECK-NEXT:   Predicates:
; CHECK-NEXT:      {1,+,1}<%for.body> Added Flags: <nusw>
; CHECK-NEXT:      {1,+,1}<%for.body> Added Flags: <nusw>
;
entry:
  br label %for.body

for.body:
  %index = phi i8 [ %index.next, %for.inc ], [ 0, %entry ]
  %index.next = add i8 %index, 1
  %conv = zext i8 %index.next to i32
  %cmp.body = icmp ne i32 %conv, 1024
  br i1 %cmp.body, label %for.work, label %exit

for.work:
  %arrayidx = getelementptr inbounds i32, ptr %src1, i8 %index
  %0 = load i32, ptr %arrayidx, align 4
  %arrayidx3 = getelementptr inbounds i32, ptr %src2, i8 %index
  %1 = load i32, ptr %arrayidx3, align 4
  %cmp.work = icmp eq i32 %0, %1
  br i1 %cmp.work, label %found, label %for.inc

for.inc:
  %cmp.inc = icmp ult i32 %conv, %end
  br i1 %cmp.inc, label %for.body, label %exit

found:
  ret i32 1

exit:
  ret i32 0
}
