//------------------------------------------------------------------------------
// GB_mex_generic.h: testing _Generic methods
//------------------------------------------------------------------------------

// SuiteSparse:GraphBLAS, Timothy A. Davis, (c) 2017-2023, All Rights Reserved.
// SPDX-License-Identifier: Apache-2.0

//------------------------------------------------------------------------------

#ifndef GB_MEX_GENERIC_H
#define GB_MEX_GENERIC_H

#if GxB_STDC_VERSION >= 201112L

//------------------------------------------------------------------------------
// testing the _Generic versions
//------------------------------------------------------------------------------

// GrB_get:
#define GrB_Scalar_get_Scalar_(...)             GrB_get (__VA_ARGS__)
#define GrB_Scalar_get_String_(...)             GrB_get (__VA_ARGS__)
#define GrB_Scalar_get_INT32_(...)              GrB_get (__VA_ARGS__)
#define GrB_Scalar_get_SIZE_(...)               GrB_get (__VA_ARGS__)
#define GrB_Scalar_get_VOID_(...)               GrB_get (__VA_ARGS__)

#define GrB_Vector_get_Scalar_(...)             GrB_get (__VA_ARGS__)
#define GrB_Vector_get_String_(...)             GrB_get (__VA_ARGS__)
#define GrB_Vector_get_INT32_(...)              GrB_get (__VA_ARGS__)
#define GrB_Vector_get_SIZE_(...)               GrB_get (__VA_ARGS__)
#define GrB_Vector_get_VOID_(...)               GrB_get (__VA_ARGS__)

#define GrB_Matrix_get_Scalar_(...)             GrB_get (__VA_ARGS__)
#define GrB_Matrix_get_String_(...)             GrB_get (__VA_ARGS__)
#define GrB_Matrix_get_INT32_(...)              GrB_get (__VA_ARGS__)
#define GrB_Matrix_get_SIZE_(...)               GrB_get (__VA_ARGS__)
#define GrB_Matrix_get_VOID_(...)               GrB_get (__VA_ARGS__)

#define GxB_Serialized_get_Scalar_(...)         GrB_get (__VA_ARGS__)
#define GxB_Serialized_get_String_(...)         GrB_get (__VA_ARGS__)
#define GxB_Serialized_get_INT32_(...)          GrB_get (__VA_ARGS__)
#define GxB_Serialized_get_SIZE_(...)           GrB_get (__VA_ARGS__)
#define GxB_Serialized_get_VOID_(...)           GrB_get (__VA_ARGS__)

#define GrB_UnaryOp_get_Scalar_(...)            GrB_get (__VA_ARGS__)
#define GrB_UnaryOp_get_String_(...)            GrB_get (__VA_ARGS__)
#define GrB_UnaryOp_get_INT32_(...)             GrB_get (__VA_ARGS__)
#define GrB_UnaryOp_get_SIZE_(...)              GrB_get (__VA_ARGS__)
#define GrB_UnaryOp_get_VOID_(...)              GrB_get (__VA_ARGS__)

#define GrB_IndexUnaryOp_get_Scalar_(...)       GrB_get (__VA_ARGS__)
#define GrB_IndexUnaryOp_get_String_(...)       GrB_get (__VA_ARGS__)
#define GrB_IndexUnaryOp_get_INT32_(...)        GrB_get (__VA_ARGS__)
#define GrB_IndexUnaryOp_get_SIZE_(...)         GrB_get (__VA_ARGS__)
#define GrB_IndexUnaryOp_get_VOID_(...)         GrB_get (__VA_ARGS__)

#define GrB_BinaryOp_get_Scalar_(...)           GrB_get (__VA_ARGS__)
#define GrB_BinaryOp_get_String_(...)           GrB_get (__VA_ARGS__)
#define GrB_BinaryOp_get_INT32_(...)            GrB_get (__VA_ARGS__)
#define GrB_BinaryOp_get_SIZE_(...)             GrB_get (__VA_ARGS__)
#define GrB_BinaryOp_get_VOID_(...)             GrB_get (__VA_ARGS__)

#define GrB_Monoid_get_Scalar_(...)             GrB_get (__VA_ARGS__)
#define GrB_Monoid_get_String_(...)             GrB_get (__VA_ARGS__)
#define GrB_Monoid_get_INT32_(...)              GrB_get (__VA_ARGS__)
#define GrB_Monoid_get_SIZE_(...)               GrB_get (__VA_ARGS__)
#define GrB_Monoid_get_VOID_(...)               GrB_get (__VA_ARGS__)

#define GrB_Semiring_get_Scalar_(...)           GrB_get (__VA_ARGS__)
#define GrB_Semiring_get_String_(...)           GrB_get (__VA_ARGS__)
#define GrB_Semiring_get_INT32_(...)            GrB_get (__VA_ARGS__)
#define GrB_Semiring_get_SIZE_(...)             GrB_get (__VA_ARGS__)
#define GrB_Semiring_get_VOID_(...)             GrB_get (__VA_ARGS__)

#define GrB_Descriptor_get_Scalar_(...)         GrB_get (__VA_ARGS__)
#define GrB_Descriptor_get_String_(...)         GrB_get (__VA_ARGS__)
#define GrB_Descriptor_get_INT32_(...)          GrB_get (__VA_ARGS__)
#define GrB_Descriptor_get_SIZE_(...)           GrB_get (__VA_ARGS__)
#define GrB_Descriptor_get_VOID_(...)           GrB_get (__VA_ARGS__)

#define GrB_Type_get_Scalar_(...)               GrB_get (__VA_ARGS__)
#define GrB_Type_get_String_(...)               GrB_get (__VA_ARGS__)
#define GrB_Type_get_INT32_(...)                GrB_get (__VA_ARGS__)
#define GrB_Type_get_SIZE_(...)                 GrB_get (__VA_ARGS__)
#define GrB_Type_get_VOID_(...)                 GrB_get (__VA_ARGS__)

#define GrB_Global_get_Scalar_(...)             GrB_get (__VA_ARGS__)
#define GrB_Global_get_String_(...)             GrB_get (__VA_ARGS__)
#define GrB_Global_get_INT32_(...)              GrB_get (__VA_ARGS__)
#define GrB_Global_get_SIZE_(...)               GrB_get (__VA_ARGS__)
#define GrB_Global_get_VOID_(...)               GrB_get (__VA_ARGS__)

#define GxB_Context_get_Scalar_(...)            GrB_get (__VA_ARGS__)
#define GxB_Context_get_String_(...)            GrB_get (__VA_ARGS__)
#define GxB_Context_get_INT_(...)               GrB_get (__VA_ARGS__)
#define GxB_Context_get_SIZE_(...)              GrB_get (__VA_ARGS__)
#define GxB_Context_get_VOID_(...)              GrB_get (__VA_ARGS__)

// GrB_set:

#define GrB_Scalar_set_Scalar_(...)             GrB_set (__VA_ARGS__)
#define GrB_Scalar_set_String_(...)             GrB_set (__VA_ARGS__)
#define GrB_Scalar_set_INT32_(...)              GrB_set (__VA_ARGS__)
#define GrB_Scalar_set_VOID_(...)               GrB_set (__VA_ARGS__)

#define GrB_Vector_set_Scalar_(...)             GrB_set (__VA_ARGS__)
#define GrB_Vector_set_String_(...)             GrB_set (__VA_ARGS__)
#define GrB_Vector_set_INT32_(...)              GrB_set (__VA_ARGS__)
#define GrB_Vector_set_VOID_(...)               GrB_set (__VA_ARGS__)

#define GrB_Matrix_set_Scalar_(...)             GrB_set (__VA_ARGS__)
#define GrB_Matrix_set_String_(...)             GrB_set (__VA_ARGS__)
#define GrB_Matrix_set_INT32_(...)              GrB_set (__VA_ARGS__)
#define GrB_Matrix_set_VOID_(...)               GrB_set (__VA_ARGS__)

#define GrB_UnaryOp_set_Scalar_(...)            GrB_set (__VA_ARGS__)
#define GrB_UnaryOp_set_String_(...)            GrB_set (__VA_ARGS__)
#define GrB_UnaryOp_set_INT32_(...)             GrB_set (__VA_ARGS__)
#define GrB_UnaryOp_set_VOID_(...)              GrB_set (__VA_ARGS__)

#define GrB_IndexUnaryOp_set_Scalar_(...)       GrB_set (__VA_ARGS__)
#define GrB_IndexUnaryOp_set_String_(...)       GrB_set (__VA_ARGS__)
#define GrB_IndexUnaryOp_set_INT32_(...)        GrB_set (__VA_ARGS__)
#define GrB_IndexUnaryOp_set_VOID_(...)         GrB_set (__VA_ARGS__)

#define GrB_BinaryOp_set_Scalar_(...)           GrB_set (__VA_ARGS__)
#define GrB_BinaryOp_set_String_(...)           GrB_set (__VA_ARGS__)
#define GrB_BinaryOp_set_INT32_(...)            GrB_set (__VA_ARGS__)
#define GrB_BinaryOp_set_VOID_(...)             GrB_set (__VA_ARGS__)

#define GrB_Monoid_set_Scalar_(...)             GrB_set (__VA_ARGS__)
#define GrB_Monoid_set_String_(...)             GrB_set (__VA_ARGS__)
#define GrB_Monoid_set_INT32_(...)              GrB_set (__VA_ARGS__)
#define GrB_Monoid_set_VOID_(...)               GrB_set (__VA_ARGS__)

#define GrB_Semiring_set_Scalar_(...)           GrB_set (__VA_ARGS__)
#define GrB_Semiring_set_String_(...)           GrB_set (__VA_ARGS__)
#define GrB_Semiring_set_INT32_(...)            GrB_set (__VA_ARGS__)
#define GrB_Semiring_set_VOID_(...)             GrB_set (__VA_ARGS__)

#define GrB_Descriptor_set_Scalar_(...)         GrB_set (__VA_ARGS__)
#define GrB_Descriptor_set_String_(...)         GrB_set (__VA_ARGS__)
#define GrB_Descriptor_set_INT32_(...)          GrB_set (__VA_ARGS__)
#define GrB_Descriptor_set_VOID_(...)           GrB_set (__VA_ARGS__)

#define GrB_Type_set_Scalar_(...)               GrB_set (__VA_ARGS__)
#define GrB_Type_set_String_(...)               GrB_set (__VA_ARGS__)
#define GrB_Type_set_INT32_(...)                GrB_set (__VA_ARGS__)
#define GrB_Type_set_VOID_(...)                 GrB_set (__VA_ARGS__)

#define GrB_Global_set_Scalar_(...)             GrB_set (__VA_ARGS__)
#define GrB_Global_set_String_(...)             GrB_set (__VA_ARGS__)
#define GrB_Global_set_INT32_(...)              GrB_set (__VA_ARGS__)
#define GrB_Global_set_VOID_(...)               GrB_set (__VA_ARGS__)

#define GxB_Context_set_Scalar_(...)            GrB_set (__VA_ARGS__)
#define GxB_Context_set_String_(...)            GrB_set (__VA_ARGS__)
#define GxB_Context_set_INT_(...)               GrB_set (__VA_ARGS__)
#define GxB_Context_set_VOID_(...)              GrB_set (__VA_ARGS__)

// GrB_free:
#define GrB_Type_free_(...)                         GrB_free (__VA_ARGS__)
#define GrB_UnaryOp_free_(...)                      GrB_free (__VA_ARGS__)
#define GrB_BinaryOp_free_(...)                     GrB_free (__VA_ARGS__)
#define GrB_IndexUnaryOp_free_(...)                 GrB_free (__VA_ARGS__)
#define GrB_Monoid_free_(...)                       GrB_free (__VA_ARGS__)
#define GrB_Semiring_free_(...)                     GrB_free (__VA_ARGS__)
#define GrB_Scalar_free_(...)                       GrB_free (__VA_ARGS__)
#define GrB_Vector_free_(...)                       GrB_free (__VA_ARGS__)
#define GrB_Matrix_free_(...)                       GrB_free (__VA_ARGS__)
#define GrB_Descriptor_free_(...)                   GrB_free (__VA_ARGS__)

// GrB_error:
#define GrB_Type_error_(...)                        GrB_error (__VA_ARGS__)
#define GrB_UnaryOp_error_(...)                     GrB_error (__VA_ARGS__)
#define GrB_BinaryOp_error_(...)                    GrB_error (__VA_ARGS__)
#define GrB_IndexUnaryOp_error_(...)                GrB_error (__VA_ARGS__)
#define GrB_Monoid_error_(...)                      GrB_error (__VA_ARGS__)
#define GrB_Semiring_error_(...)                    GrB_error (__VA_ARGS__)
#define GrB_Scalar_error_(...)                      GrB_error (__VA_ARGS__)
#define GrB_Vector_error_(...)                      GrB_error (__VA_ARGS__)
#define GrB_Matrix_error_(...)                      GrB_error (__VA_ARGS__)
#define GrB_Descriptor_error_(...)                  GrB_error (__VA_ARGS__)

// GrB_Monoid_new:
#define GrB_Monoid_new_BOOL_(...)                   GrB_Monoid_new (__VA_ARGS__)
#define GrB_Monoid_new_INT8_(...)                   GrB_Monoid_new (__VA_ARGS__)
#define GrB_Monoid_new_INT16_(...)                  GrB_Monoid_new (__VA_ARGS__)
#define GrB_Monoid_new_INT32_(...)                  GrB_Monoid_new (__VA_ARGS__)
#define GrB_Monoid_new_INT64_(...)                  GrB_Monoid_new (__VA_ARGS__)
#define GrB_Monoid_new_UINT8_(...)                  GrB_Monoid_new (__VA_ARGS__)
#define GrB_Monoid_new_UINT16_(...)                 GrB_Monoid_new (__VA_ARGS__)
#define GrB_Monoid_new_UINT32_(...)                 GrB_Monoid_new (__VA_ARGS__)
#define GrB_Monoid_new_UINT64_(...)                 GrB_Monoid_new (__VA_ARGS__)
#define GrB_Monoid_new_FP32_(...)                   GrB_Monoid_new (__VA_ARGS__)
#define GrB_Monoid_new_FP64_(...)                   GrB_Monoid_new (__VA_ARGS__)
#define GxB_Monoid_new_FC32_(...)                   GrB_Monoid_new (__VA_ARGS__)
#define GxB_Monoid_new_FC64_(...)                   GrB_Monoid_new (__VA_ARGS__)
#define GrB_Monoid_new_UDT_(...)                    GrB_Monoid_new (__VA_ARGS__)

// GxB_Monoid_terminal_new:
#define GxB_Monoid_terminal_new_BOOL_(...)          GxB_Monoid_terminal_new (__VA_ARGS__)
#define GxB_Monoid_terminal_new_INT8_(...)          GxB_Monoid_terminal_new (__VA_ARGS__)
#define GxB_Monoid_terminal_new_INT16_(...)         GxB_Monoid_terminal_new (__VA_ARGS__)
#define GxB_Monoid_terminal_new_INT32_(...)         GxB_Monoid_terminal_new (__VA_ARGS__)
#define GxB_Monoid_terminal_new_INT64_(...)         GxB_Monoid_terminal_new (__VA_ARGS__)
#define GxB_Monoid_terminal_new_UINT8_(...)         GxB_Monoid_terminal_new (__VA_ARGS__)
#define GxB_Monoid_terminal_new_UINT16_(...)        GxB_Monoid_terminal_new (__VA_ARGS__)
#define GxB_Monoid_terminal_new_UINT32_(...)        GxB_Monoid_terminal_new (__VA_ARGS__)
#define GxB_Monoid_terminal_new_UINT64_(...)        GxB_Monoid_terminal_new (__VA_ARGS__)
#define GxB_Monoid_terminal_new_FP32_(...)          GxB_Monoid_terminal_new (__VA_ARGS__)
#define GxB_Monoid_terminal_new_FP64_(...)          GxB_Monoid_terminal_new (__VA_ARGS__)
#define GxB_Monoid_terminal_new_FC32_(...)          GxB_Monoid_terminal_new (__VA_ARGS__)
#define GxB_Monoid_terminal_new_FC64_(...)          GxB_Monoid_terminal_new (__VA_ARGS__)
#define GxB_Monoid_terminal_new_UDT_(...)           GxB_Monoid_terminal_new (__VA_ARGS__)

// GrB_Scalar_setElement:
#define GrB_Scalar_setElement_BOOL_(...)            GrB_Scalar_setElement (__VA_ARGS__)
#define GrB_Scalar_setElement_INT8_(...)            GrB_Scalar_setElement (__VA_ARGS__)
#define GrB_Scalar_setElement_INT16_(...)           GrB_Scalar_setElement (__VA_ARGS__)
#define GrB_Scalar_setElement_INT32_(...)           GrB_Scalar_setElement (__VA_ARGS__)
#define GrB_Scalar_setElement_INT64_(...)           GrB_Scalar_setElement (__VA_ARGS__)
#define GrB_Scalar_setElement_UINT8_(...)           GrB_Scalar_setElement (__VA_ARGS__)
#define GrB_Scalar_setElement_UINT16_(...)          GrB_Scalar_setElement (__VA_ARGS__)
#define GrB_Scalar_setElement_UINT32_(...)          GrB_Scalar_setElement (__VA_ARGS__)
#define GrB_Scalar_setElement_UINT64_(...)          GrB_Scalar_setElement (__VA_ARGS__)
#define GrB_Scalar_setElement_FP32_(...)            GrB_Scalar_setElement (__VA_ARGS__)
#define GrB_Scalar_setElement_FP64_(...)            GrB_Scalar_setElement (__VA_ARGS__)
#define GxB_Scalar_setElement_FC32_(...)            GrB_Scalar_setElement (__VA_ARGS__)
#define GxB_Scalar_setElement_FC64_(...)            GrB_Scalar_setElement (__VA_ARGS__)
#define GrB_Scalar_setElement_UDT_(...)             GrB_Scalar_setElement (__VA_ARGS__)

// GrB_Scalar_extractElement:
#define GrB_Scalar_extractElement_BOOL_(...)        GrB_Scalar_extractElement (__VA_ARGS__)
#define GrB_Scalar_extractElement_INT8_(...)        GrB_Scalar_extractElement (__VA_ARGS__)
#define GrB_Scalar_extractElement_INT16_(...)       GrB_Scalar_extractElement (__VA_ARGS__)
#define GrB_Scalar_extractElement_INT32_(...)       GrB_Scalar_extractElement (__VA_ARGS__)
#define GrB_Scalar_extractElement_INT64_(...)       GrB_Scalar_extractElement (__VA_ARGS__)
#define GrB_Scalar_extractElement_UINT8_(...)       GrB_Scalar_extractElement (__VA_ARGS__)
#define GrB_Scalar_extractElement_UINT16_(...)      GrB_Scalar_extractElement (__VA_ARGS__)
#define GrB_Scalar_extractElement_UINT32_(...)      GrB_Scalar_extractElement (__VA_ARGS__)
#define GrB_Scalar_extractElement_UINT64_(...)      GrB_Scalar_extractElement (__VA_ARGS__)
#define GrB_Scalar_extractElement_FP32_(...)        GrB_Scalar_extractElement (__VA_ARGS__)
#define GrB_Scalar_extractElement_FP64_(...)        GrB_Scalar_extractElement (__VA_ARGS__)
#define GxB_Scalar_extractElement_FC32_(...)        GrB_Scalar_extractElement (__VA_ARGS__)
#define GxB_Scalar_extractElement_FC64_(...)        GrB_Scalar_extractElement (__VA_ARGS__)
#define GrB_Scalar_extractElement_UDT_(...)         GrB_Scalar_extractElement (__VA_ARGS__)

// GrB_Vector_build:
#define GrB_Vector_build_BOOL_(...)                 GrB_Vector_build (__VA_ARGS__)
#define GrB_Vector_build_INT8_(...)                 GrB_Vector_build (__VA_ARGS__)
#define GrB_Vector_build_INT16_(...)                GrB_Vector_build (__VA_ARGS__)
#define GrB_Vector_build_INT32_(...)                GrB_Vector_build (__VA_ARGS__)
#define GrB_Vector_build_INT64_(...)                GrB_Vector_build (__VA_ARGS__)
#define GrB_Vector_build_UINT8_(...)                GrB_Vector_build (__VA_ARGS__)
#define GrB_Vector_build_UINT16_(...)               GrB_Vector_build (__VA_ARGS__)
#define GrB_Vector_build_UINT32_(...)               GrB_Vector_build (__VA_ARGS__)
#define GrB_Vector_build_UINT64_(...)               GrB_Vector_build (__VA_ARGS__)
#define GrB_Vector_build_FP32_(...)                 GrB_Vector_build (__VA_ARGS__)
#define GrB_Vector_build_FP64_(...)                 GrB_Vector_build (__VA_ARGS__)
#define GxB_Vector_build_FC32_(...)                 GrB_Vector_build (__VA_ARGS__)
#define GxB_Vector_build_FC64_(...)                 GrB_Vector_build (__VA_ARGS__)
#define GrB_Vector_build_UDT_(...)                  GrB_Vector_build (__VA_ARGS__)

// GrB_Vector_setElement:
#define GrB_Vector_setElement_BOOL_(...)            GrB_Vector_setElement (__VA_ARGS__)
#define GrB_Vector_setElement_INT8_(...)            GrB_Vector_setElement (__VA_ARGS__)
#define GrB_Vector_setElement_INT16_(...)           GrB_Vector_setElement (__VA_ARGS__)
#define GrB_Vector_setElement_INT32_(...)           GrB_Vector_setElement (__VA_ARGS__)
#define GrB_Vector_setElement_INT64_(...)           GrB_Vector_setElement (__VA_ARGS__)
#define GrB_Vector_setElement_UINT8_(...)           GrB_Vector_setElement (__VA_ARGS__)
#define GrB_Vector_setElement_UINT16_(...)          GrB_Vector_setElement (__VA_ARGS__)
#define GrB_Vector_setElement_UINT32_(...)          GrB_Vector_setElement (__VA_ARGS__)
#define GrB_Vector_setElement_UINT64_(...)          GrB_Vector_setElement (__VA_ARGS__)
#define GrB_Vector_setElement_FP32_(...)            GrB_Vector_setElement (__VA_ARGS__)
#define GrB_Vector_setElement_FP64_(...)            GrB_Vector_setElement (__VA_ARGS__)
#define GxB_Vector_setElement_FC32_(...)            GrB_Vector_setElement (__VA_ARGS__)
#define GxB_Vector_setElement_FC64_(...)            GrB_Vector_setElement (__VA_ARGS__)
#define GrB_Vector_setElement_UDT_(...)             GrB_Vector_setElement (__VA_ARGS__)
#define GrB_Vector_setElement_Scalar_(...)          GrB_Vector_setElement (__VA_ARGS__)

// GrB_Vector_extractElement:
#define GrB_Vector_extractElement_BOOL_(...)        GrB_Vector_extractElement (__VA_ARGS__)
#define GrB_Vector_extractElement_INT8_(...)        GrB_Vector_extractElement (__VA_ARGS__)
#define GrB_Vector_extractElement_INT16_(...)       GrB_Vector_extractElement (__VA_ARGS__)
#define GrB_Vector_extractElement_INT32_(...)       GrB_Vector_extractElement (__VA_ARGS__)
#define GrB_Vector_extractElement_INT64_(...)       GrB_Vector_extractElement (__VA_ARGS__)
#define GrB_Vector_extractElement_UINT8_(...)       GrB_Vector_extractElement (__VA_ARGS__)
#define GrB_Vector_extractElement_UINT16_(...)      GrB_Vector_extractElement (__VA_ARGS__)
#define GrB_Vector_extractElement_UINT32_(...)      GrB_Vector_extractElement (__VA_ARGS__)
#define GrB_Vector_extractElement_UINT64_(...)      GrB_Vector_extractElement (__VA_ARGS__)
#define GrB_Vector_extractElement_FP32_(...)        GrB_Vector_extractElement (__VA_ARGS__)
#define GrB_Vector_extractElement_FP64_(...)        GrB_Vector_extractElement (__VA_ARGS__)
#define GxB_Vector_extractElement_FC32_(...)        GrB_Vector_extractElement (__VA_ARGS__)
#define GxB_Vector_extractElement_FC64_(...)        GrB_Vector_extractElement (__VA_ARGS__)
#define GrB_Vector_extractElement_UDT_(...)         GrB_Vector_extractElement (__VA_ARGS__)
#define GrB_Vector_extractElement_Scalar_(...)      GrB_Vector_extractElement (__VA_ARGS__)

// GrB_Vector_extractTuples:
#define GrB_Vector_extractTuples_BOOL_(...)         GrB_Vector_extractTuples (__VA_ARGS__)
#define GrB_Vector_extractTuples_INT8_(...)         GrB_Vector_extractTuples (__VA_ARGS__)
#define GrB_Vector_extractTuples_INT16_(...)        GrB_Vector_extractTuples (__VA_ARGS__)
#define GrB_Vector_extractTuples_INT32_(...)        GrB_Vector_extractTuples (__VA_ARGS__)
#define GrB_Vector_extractTuples_INT64_(...)        GrB_Vector_extractTuples (__VA_ARGS__)
#define GrB_Vector_extractTuples_UINT8_(...)        GrB_Vector_extractTuples (__VA_ARGS__)
#define GrB_Vector_extractTuples_UINT16_(...)       GrB_Vector_extractTuples (__VA_ARGS__)
#define GrB_Vector_extractTuples_UINT32_(...)       GrB_Vector_extractTuples (__VA_ARGS__)
#define GrB_Vector_extractTuples_UINT64_(...)       GrB_Vector_extractTuples (__VA_ARGS__)
#define GrB_Vector_extractTuples_FP32_(...)         GrB_Vector_extractTuples (__VA_ARGS__)
#define GrB_Vector_extractTuples_FP64_(...)         GrB_Vector_extractTuples (__VA_ARGS__)
#define GxB_Vector_extractTuples_FC32_(...)         GrB_Vector_extractTuples (__VA_ARGS__)
#define GxB_Vector_extractTuples_FC64_(...)         GrB_Vector_extractTuples (__VA_ARGS__)
#define GrB_Vector_extractTuples_UDT_(...)          GrB_Vector_extractTuples (__VA_ARGS__)

// GrB_Matrix_build:
#define GrB_Matrix_build_BOOL_(...)                 GrB_Matrix_build (__VA_ARGS__)
#define GrB_Matrix_build_INT8_(...)                 GrB_Matrix_build (__VA_ARGS__)
#define GrB_Matrix_build_INT16_(...)                GrB_Matrix_build (__VA_ARGS__)
#define GrB_Matrix_build_INT32_(...)                GrB_Matrix_build (__VA_ARGS__)
#define GrB_Matrix_build_INT64_(...)                GrB_Matrix_build (__VA_ARGS__)
#define GrB_Matrix_build_UINT8_(...)                GrB_Matrix_build (__VA_ARGS__)
#define GrB_Matrix_build_UINT16_(...)               GrB_Matrix_build (__VA_ARGS__)
#define GrB_Matrix_build_UINT32_(...)               GrB_Matrix_build (__VA_ARGS__)
#define GrB_Matrix_build_UINT64_(...)               GrB_Matrix_build (__VA_ARGS__)
#define GrB_Matrix_build_FP32_(...)                 GrB_Matrix_build (__VA_ARGS__)
#define GrB_Matrix_build_FP64_(...)                 GrB_Matrix_build (__VA_ARGS__)
#define GxB_Matrix_build_FC32_(...)                 GrB_Matrix_build (__VA_ARGS__)
#define GxB_Matrix_build_FC64_(...)                 GrB_Matrix_build (__VA_ARGS__)
#define GrB_Matrix_build_UDT_(...)                  GrB_Matrix_build (__VA_ARGS__)

// GrB_Matrix_import:
#define GrB_Matrix_import_BOOL_(...)                GrB_Matrix_import (__VA_ARGS__)
#define GrB_Matrix_import_INT8_(...)                GrB_Matrix_import (__VA_ARGS__)
#define GrB_Matrix_import_INT16_(...)               GrB_Matrix_import (__VA_ARGS__)
#define GrB_Matrix_import_INT32_(...)               GrB_Matrix_import (__VA_ARGS__)
#define GrB_Matrix_import_INT64_(...)               GrB_Matrix_import (__VA_ARGS__)
#define GrB_Matrix_import_UINT8_(...)               GrB_Matrix_import (__VA_ARGS__)
#define GrB_Matrix_import_UINT16_(...)              GrB_Matrix_import (__VA_ARGS__)
#define GrB_Matrix_import_UINT32_(...)              GrB_Matrix_import (__VA_ARGS__)
#define GrB_Matrix_import_UINT64_(...)              GrB_Matrix_import (__VA_ARGS__)
#define GrB_Matrix_import_FP32_(...)                GrB_Matrix_import (__VA_ARGS__)
#define GrB_Matrix_import_FP64_(...)                GrB_Matrix_import (__VA_ARGS__)
#define GxB_Matrix_import_FC32_(...)                GrB_Matrix_import (__VA_ARGS__)
#define GxB_Matrix_import_FC64_(...)                GrB_Matrix_import (__VA_ARGS__)
#define GrB_Matrix_import_UDT_(...)                 GrB_Matrix_import (__VA_ARGS__)

// GrB_Matrix_export:
#define GrB_Matrix_export_BOOL_(...)                GrB_Matrix_export (__VA_ARGS__)
#define GrB_Matrix_export_INT8_(...)                GrB_Matrix_export (__VA_ARGS__)
#define GrB_Matrix_export_INT16_(...)               GrB_Matrix_export (__VA_ARGS__)
#define GrB_Matrix_export_INT32_(...)               GrB_Matrix_export (__VA_ARGS__)
#define GrB_Matrix_export_INT64_(...)               GrB_Matrix_export (__VA_ARGS__)
#define GrB_Matrix_export_UINT8_(...)               GrB_Matrix_export (__VA_ARGS__)
#define GrB_Matrix_export_UINT16_(...)              GrB_Matrix_export (__VA_ARGS__)
#define GrB_Matrix_export_UINT32_(...)              GrB_Matrix_export (__VA_ARGS__)
#define GrB_Matrix_export_UINT64_(...)              GrB_Matrix_export (__VA_ARGS__)
#define GrB_Matrix_export_FP32_(...)                GrB_Matrix_export (__VA_ARGS__)
#define GrB_Matrix_export_FP64_(...)                GrB_Matrix_export (__VA_ARGS__)
#define GxB_Matrix_export_FC32_(...)                GrB_Matrix_export (__VA_ARGS__)
#define GxB_Matrix_export_FC64_(...)                GrB_Matrix_export (__VA_ARGS__)
#define GrB_Matrix_export_UDT_(...)                 GrB_Matrix_export (__VA_ARGS__)

// GrB_Matrix_setElement:
#define GrB_Matrix_setElement_BOOL_(...)            GrB_Matrix_setElement (__VA_ARGS__)
#define GrB_Matrix_setElement_INT8_(...)            GrB_Matrix_setElement (__VA_ARGS__)
#define GrB_Matrix_setElement_INT16_(...)           GrB_Matrix_setElement (__VA_ARGS__)
#define GrB_Matrix_setElement_INT32_(...)           GrB_Matrix_setElement (__VA_ARGS__)
#define GrB_Matrix_setElement_INT64_(...)           GrB_Matrix_setElement (__VA_ARGS__)
#define GrB_Matrix_setElement_UINT8_(...)           GrB_Matrix_setElement (__VA_ARGS__)
#define GrB_Matrix_setElement_UINT16_(...)          GrB_Matrix_setElement (__VA_ARGS__)
#define GrB_Matrix_setElement_UINT32_(...)          GrB_Matrix_setElement (__VA_ARGS__)
#define GrB_Matrix_setElement_UINT64_(...)          GrB_Matrix_setElement (__VA_ARGS__)
#define GrB_Matrix_setElement_FP32_(...)            GrB_Matrix_setElement (__VA_ARGS__)
#define GrB_Matrix_setElement_FP64_(...)            GrB_Matrix_setElement (__VA_ARGS__)
#define GxB_Matrix_setElement_FC32_(...)            GrB_Matrix_setElement (__VA_ARGS__)
#define GxB_Matrix_setElement_FC64_(...)            GrB_Matrix_setElement (__VA_ARGS__)
#define GrB_Matrix_setElement_UDT_(...)             GrB_Matrix_setElement (__VA_ARGS__)
#define GrB_Matrix_setElement_Scalar_(...)          GrB_Matrix_setElement (__VA_ARGS__)

// GrB_Matrix_extractElement:
#define GrB_Matrix_extractElement_BOOL_(...)        GrB_Matrix_extractElement (__VA_ARGS__)
#define GrB_Matrix_extractElement_INT8_(...)        GrB_Matrix_extractElement (__VA_ARGS__)
#define GrB_Matrix_extractElement_INT16_(...)       GrB_Matrix_extractElement (__VA_ARGS__)
#define GrB_Matrix_extractElement_INT32_(...)       GrB_Matrix_extractElement (__VA_ARGS__)
#define GrB_Matrix_extractElement_INT64_(...)       GrB_Matrix_extractElement (__VA_ARGS__)
#define GrB_Matrix_extractElement_UINT8_(...)       GrB_Matrix_extractElement (__VA_ARGS__)
#define GrB_Matrix_extractElement_UINT16_(...)      GrB_Matrix_extractElement (__VA_ARGS__)
#define GrB_Matrix_extractElement_UINT32_(...)      GrB_Matrix_extractElement (__VA_ARGS__)
#define GrB_Matrix_extractElement_UINT64_(...)      GrB_Matrix_extractElement (__VA_ARGS__)
#define GrB_Matrix_extractElement_FP32_(...)        GrB_Matrix_extractElement (__VA_ARGS__)
#define GrB_Matrix_extractElement_FP64_(...)        GrB_Matrix_extractElement (__VA_ARGS__)
#define GxB_Matrix_extractElement_FC32_(...)        GrB_Matrix_extractElement (__VA_ARGS__)
#define GxB_Matrix_extractElement_FC64_(...)        GrB_Matrix_extractElement (__VA_ARGS__)
#define GrB_Matrix_extractElement_UDT_(...)         GrB_Matrix_extractElement (__VA_ARGS__)
#define GrB_Matrix_extractElement_Scalar_(...)      GrB_Matrix_extractElement (__VA_ARGS__)

// GrB_Matrix_extractTuples:
#define GrB_Matrix_extractTuples_BOOL_(...)         GrB_Matrix_extractTuples (__VA_ARGS__)
#define GrB_Matrix_extractTuples_INT8_(...)         GrB_Matrix_extractTuples (__VA_ARGS__)
#define GrB_Matrix_extractTuples_INT16_(...)        GrB_Matrix_extractTuples (__VA_ARGS__)
#define GrB_Matrix_extractTuples_INT32_(...)        GrB_Matrix_extractTuples (__VA_ARGS__)
#define GrB_Matrix_extractTuples_INT64_(...)        GrB_Matrix_extractTuples (__VA_ARGS__)
#define GrB_Matrix_extractTuples_UINT8_(...)        GrB_Matrix_extractTuples (__VA_ARGS__)
#define GrB_Matrix_extractTuples_UINT16_(...)       GrB_Matrix_extractTuples (__VA_ARGS__)
#define GrB_Matrix_extractTuples_UINT32_(...)       GrB_Matrix_extractTuples (__VA_ARGS__)
#define GrB_Matrix_extractTuples_UINT64_(...)       GrB_Matrix_extractTuples (__VA_ARGS__)
#define GrB_Matrix_extractTuples_FP32_(...)         GrB_Matrix_extractTuples (__VA_ARGS__)
#define GrB_Matrix_extractTuples_FP64_(...)         GrB_Matrix_extractTuples (__VA_ARGS__)
#define GxB_Matrix_extractTuples_FC32_(...)         GrB_Matrix_extractTuples (__VA_ARGS__)
#define GxB_Matrix_extractTuples_FC64_(...)         GrB_Matrix_extractTuples (__VA_ARGS__)
#define GrB_Matrix_extractTuples_UDT_(...)          GrB_Matrix_extractTuples (__VA_ARGS__)

// GxB_set:
#define GxB_Global_Option_set_(...)                 GxB_set (__VA_ARGS__)
#define GxB_Matrix_Option_set_(...)                 GxB_set (__VA_ARGS__)
#define GxB_Vector_Option_set_(...)                 GxB_set (__VA_ARGS__)
#define GrB_Descriptor_set_(...)                    GxB_set (__VA_ARGS__)
#define GxB_Desc_set_(...)                          GxB_set (__VA_ARGS__)

// GxB_get:
#define GxB_Global_Option_get_(...)                 GxB_get (__VA_ARGS__)
#define GxB_Matrix_Option_get_(...)                 GxB_get (__VA_ARGS__)
#define GxB_Vector_Option_get_(...)                 GxB_get (__VA_ARGS__)
#define GxB_Descriptor_get_(...)                    GxB_get (__VA_ARGS__)
#define GxB_Desc_get_(...)                          GxB_get (__VA_ARGS__)

// GrB_wait:
#define GrB_Type_wait_(...)                         GrB_wait (__VA_ARGS__)
#define GrB_UnaryOp_wait_(...)                      GrB_wait (__VA_ARGS__)
#define GrB_BinaryOp_wait_(...)                     GrB_wait (__VA_ARGS__)
#define GrB_IndexUnaryOp_wait_(...)                 GrB_wait (__VA_ARGS__)
#define GrB_Monoid_wait_(...)                       GrB_wait (__VA_ARGS__)
#define GrB_Semiring_wait_(...)                     GrB_wait (__VA_ARGS__)
#define GrB_Descriptor_wait_(...)                   GrB_wait (__VA_ARGS__)
#define GrB_Scalar_wait_(...)                       GrB_wait (__VA_ARGS__)
#define GrB_Vector_wait_(...)                       GrB_wait (__VA_ARGS__)
#define GrB_Matrix_wait_(...)                       GrB_wait (__VA_ARGS__)

// GrB_eWiseMult:
#define GrB_Vector_eWiseMult_Semiring_(...)         GrB_eWiseMult (__VA_ARGS__)
#define GrB_Vector_eWiseMult_Monoid_(...)           GrB_eWiseMult (__VA_ARGS__)
#define GrB_Vector_eWiseMult_BinaryOp_(...)         GrB_eWiseMult (__VA_ARGS__)
#define GrB_Matrix_eWiseMult_Semiring_(...)         GrB_eWiseMult (__VA_ARGS__)
#define GrB_Matrix_eWiseMult_Monoid_(...)           GrB_eWiseMult (__VA_ARGS__)
#define GrB_Matrix_eWiseMult_BinaryOp_(...)         GrB_eWiseMult (__VA_ARGS__)

// GrB_eWiseAdd:
#define GrB_Vector_eWiseAdd_Semiring_(...)          GrB_eWiseAdd (__VA_ARGS__)
#define GrB_Vector_eWiseAdd_Monoid_(...)            GrB_eWiseAdd (__VA_ARGS__)
#define GrB_Vector_eWiseAdd_BinaryOp_(...)          GrB_eWiseAdd (__VA_ARGS__)
#define GrB_Matrix_eWiseAdd_Semiring_(...)          GrB_eWiseAdd (__VA_ARGS__)
#define GrB_Matrix_eWiseAdd_Monoid_(...)            GrB_eWiseAdd (__VA_ARGS__)
#define GrB_Matrix_eWiseAdd_BinaryOp_(...)          GrB_eWiseAdd (__VA_ARGS__)

// GrB_extract:
#define GrB_Vector_extract_(...)                    GrB_extract (__VA_ARGS__)
#define GrB_Matrix_extract_(...)                    GrB_extract (__VA_ARGS__)
#define GrB_Col_extract_(...)                       GrB_extract (__VA_ARGS__)

// GxB_subassign:
#define GxB_Vector_subassign_(...)                  GxB_subassign (__VA_ARGS__)
#define GxB_Matrix_subassign_(...)                  GxB_subassign (__VA_ARGS__)
#define GxB_Col_subassign_(...)                     GxB_subassign (__VA_ARGS__)
#define GxB_Row_subassign_(...)                     GxB_subassign (__VA_ARGS__)
#define GxB_Vector_subassign_BOOL_(...)             GxB_subassign (__VA_ARGS__)
#define GxB_Vector_subassign_INT8_(...)             GxB_subassign (__VA_ARGS__)
#define GxB_Vector_subassign_INT16_(...)            GxB_subassign (__VA_ARGS__)
#define GxB_Vector_subassign_INT32_(...)            GxB_subassign (__VA_ARGS__)
#define GxB_Vector_subassign_INT64_(...)            GxB_subassign (__VA_ARGS__)
#define GxB_Vector_subassign_UINT8_(...)            GxB_subassign (__VA_ARGS__)
#define GxB_Vector_subassign_UINT16_(...)           GxB_subassign (__VA_ARGS__)
#define GxB_Vector_subassign_UINT32_(...)           GxB_subassign (__VA_ARGS__)
#define GxB_Vector_subassign_UINT64_(...)           GxB_subassign (__VA_ARGS__)
#define GxB_Vector_subassign_FP32_(...)             GxB_subassign (__VA_ARGS__)
#define GxB_Vector_subassign_FP64_(...)             GxB_subassign (__VA_ARGS__)
#define GxB_Vector_subassign_FC32_(...)             GxB_subassign (__VA_ARGS__)
#define GxB_Vector_subassign_FC64_(...)             GxB_subassign (__VA_ARGS__)
#define GxB_Vector_subassign_UDT_(...)              GxB_subassign (__VA_ARGS__)
#define GxB_Matrix_subassign_BOOL_(...)             GxB_subassign (__VA_ARGS__)
#define GxB_Matrix_subassign_INT8_(...)             GxB_subassign (__VA_ARGS__)
#define GxB_Matrix_subassign_INT16_(...)            GxB_subassign (__VA_ARGS__)
#define GxB_Matrix_subassign_INT32_(...)            GxB_subassign (__VA_ARGS__)
#define GxB_Matrix_subassign_INT64_(...)            GxB_subassign (__VA_ARGS__)
#define GxB_Matrix_subassign_UINT8_(...)            GxB_subassign (__VA_ARGS__)
#define GxB_Matrix_subassign_UINT16_(...)           GxB_subassign (__VA_ARGS__)
#define GxB_Matrix_subassign_UINT32_(...)           GxB_subassign (__VA_ARGS__)
#define GxB_Matrix_subassign_UINT64_(...)           GxB_subassign (__VA_ARGS__)
#define GxB_Matrix_subassign_FP32_(...)             GxB_subassign (__VA_ARGS__)
#define GxB_Matrix_subassign_FP64_(...)             GxB_subassign (__VA_ARGS__)
#define GxB_Matrix_subassign_FC32_(...)             GxB_subassign (__VA_ARGS__)
#define GxB_Matrix_subassign_FC64_(...)             GxB_subassign (__VA_ARGS__)
#define GxB_Matrix_subassign_UDT_(...)              GxB_subassign (__VA_ARGS__)

// GrB_assign:
#define GrB_Vector_assign_(...)                     GrB_assign (__VA_ARGS__)
#define GrB_Matrix_assign_(...)                     GrB_assign (__VA_ARGS__)
#define GrB_Col_assign_(...)                        GrB_assign (__VA_ARGS__)
#define GrB_Row_assign_(...)                        GrB_assign (__VA_ARGS__)
#define GrB_Vector_assign_BOOL_(...)                GrB_assign (__VA_ARGS__)
#define GrB_Vector_assign_INT8_(...)                GrB_assign (__VA_ARGS__)
#define GrB_Vector_assign_INT16_(...)               GrB_assign (__VA_ARGS__)
#define GrB_Vector_assign_INT32_(...)               GrB_assign (__VA_ARGS__)
#define GrB_Vector_assign_INT64_(...)               GrB_assign (__VA_ARGS__)
#define GrB_Vector_assign_UINT8_(...)               GrB_assign (__VA_ARGS__)
#define GrB_Vector_assign_UINT16_(...)              GrB_assign (__VA_ARGS__)
#define GrB_Vector_assign_UINT32_(...)              GrB_assign (__VA_ARGS__)
#define GrB_Vector_assign_UINT64_(...)              GrB_assign (__VA_ARGS__)
#define GrB_Vector_assign_FP32_(...)                GrB_assign (__VA_ARGS__)
#define GrB_Vector_assign_FP64_(...)                GrB_assign (__VA_ARGS__)
#define GxB_Vector_assign_FC32_(...)                GrB_assign (__VA_ARGS__)
#define GxB_Vector_assign_FC64_(...)                GrB_assign (__VA_ARGS__)
#define GrB_Vector_assign_UDT_(...)                 GrB_assign (__VA_ARGS__)
#define GrB_Matrix_assign_BOOL_(...)                GrB_assign (__VA_ARGS__)
#define GrB_Matrix_assign_INT8_(...)                GrB_assign (__VA_ARGS__)
#define GrB_Matrix_assign_INT16_(...)               GrB_assign (__VA_ARGS__)
#define GrB_Matrix_assign_INT32_(...)               GrB_assign (__VA_ARGS__)
#define GrB_Matrix_assign_INT64_(...)               GrB_assign (__VA_ARGS__)
#define GrB_Matrix_assign_UINT8_(...)               GrB_assign (__VA_ARGS__)
#define GrB_Matrix_assign_UINT16_(...)              GrB_assign (__VA_ARGS__)
#define GrB_Matrix_assign_UINT32_(...)              GrB_assign (__VA_ARGS__)
#define GrB_Matrix_assign_UINT64_(...)              GrB_assign (__VA_ARGS__)
#define GrB_Matrix_assign_FP32_(...)                GrB_assign (__VA_ARGS__)
#define GrB_Matrix_assign_FP64_(...)                GrB_assign (__VA_ARGS__)
#define GxB_Matrix_assign_FC32_(...)                GrB_assign (__VA_ARGS__)
#define GxB_Matrix_assign_FC64_(...)                GrB_assign (__VA_ARGS__)
#define GrB_Matrix_assign_UDT_(...)                 GrB_assign (__VA_ARGS__)

// GrB_apply:
#define GrB_Vector_apply_(...)                      GrB_apply (__VA_ARGS__)
#define GrB_Matrix_apply_(...)                      GrB_apply (__VA_ARGS__)
#define GxB_Vector_apply_BinaryOp1st_(...)          GrB_apply (__VA_ARGS__)
#define GrB_Vector_apply_BinaryOp1st_BOOL_(...)     GrB_apply (__VA_ARGS__)
#define GrB_Vector_apply_BinaryOp1st_INT8_(...)     GrB_apply (__VA_ARGS__)
#define GrB_Vector_apply_BinaryOp1st_INT16_(...)    GrB_apply (__VA_ARGS__)
#define GrB_Vector_apply_BinaryOp1st_INT32_(...)    GrB_apply (__VA_ARGS__)
#define GrB_Vector_apply_BinaryOp1st_INT64_(...)    GrB_apply (__VA_ARGS__)
#define GrB_Vector_apply_BinaryOp1st_UINT8_(...)    GrB_apply (__VA_ARGS__)
#define GrB_Vector_apply_BinaryOp1st_UINT16_(...)   GrB_apply (__VA_ARGS__)
#define GrB_Vector_apply_BinaryOp1st_UINT32_(...)   GrB_apply (__VA_ARGS__)
#define GrB_Vector_apply_BinaryOp1st_UINT64_(...)   GrB_apply (__VA_ARGS__)
#define GrB_Vector_apply_BinaryOp1st_FP32_(...)     GrB_apply (__VA_ARGS__)
#define GrB_Vector_apply_BinaryOp1st_FP64_(...)     GrB_apply (__VA_ARGS__)
#define GxB_Vector_apply_BinaryOp1st_FC32_(...)     GrB_apply (__VA_ARGS__)
#define GxB_Vector_apply_BinaryOp1st_FC64_(...)     GrB_apply (__VA_ARGS__)
#define GrB_Vector_apply_BinaryOp1st_UDT_(...)      GrB_apply (__VA_ARGS__)
#define GrB_Vector_apply_BinaryOp1st_Scalar_(...)   GrB_apply (__VA_ARGS__)

#define GxB_Vector_apply_BinaryOp2nd_(...)          GrB_apply (__VA_ARGS__)
#define GrB_Vector_apply_BinaryOp2nd_BOOL_(...)     GrB_apply (__VA_ARGS__)
#define GrB_Vector_apply_BinaryOp2nd_INT8_(...)     GrB_apply (__VA_ARGS__)
#define GrB_Vector_apply_BinaryOp2nd_INT16_(...)    GrB_apply (__VA_ARGS__)
#define GrB_Vector_apply_BinaryOp2nd_INT32_(...)    GrB_apply (__VA_ARGS__)
#define GrB_Vector_apply_BinaryOp2nd_INT64_(...)    GrB_apply (__VA_ARGS__)
#define GrB_Vector_apply_BinaryOp2nd_UINT8_(...)    GrB_apply (__VA_ARGS__)
#define GrB_Vector_apply_BinaryOp2nd_UINT16_(...)   GrB_apply (__VA_ARGS__)
#define GrB_Vector_apply_BinaryOp2nd_UINT32_(...)   GrB_apply (__VA_ARGS__)
#define GrB_Vector_apply_BinaryOp2nd_UINT64_(...)   GrB_apply (__VA_ARGS__)
#define GrB_Vector_apply_BinaryOp2nd_FP32_(...)     GrB_apply (__VA_ARGS__)
#define GrB_Vector_apply_BinaryOp2nd_FP64_(...)     GrB_apply (__VA_ARGS__)
#define GxB_Vector_apply_BinaryOp2nd_FC32_(...)     GrB_apply (__VA_ARGS__)
#define GxB_Vector_apply_BinaryOp2nd_FC64_(...)     GrB_apply (__VA_ARGS__)
#define GrB_Vector_apply_BinaryOp2nd_UDT_(...)      GrB_apply (__VA_ARGS__)
#define GrB_Vector_apply_BinaryOp2nd_Scalar_(...)   GrB_apply (__VA_ARGS__)

#define GxB_Vector_apply_IndexOp_(...)          GrB_apply (__VA_ARGS__)
#define GrB_Vector_apply_IndexOp_BOOL_(...)     GrB_apply (__VA_ARGS__)
#define GrB_Vector_apply_IndexOp_INT8_(...)     GrB_apply (__VA_ARGS__)
#define GrB_Vector_apply_IndexOp_INT16_(...)    GrB_apply (__VA_ARGS__)
#define GrB_Vector_apply_IndexOp_INT32_(...)    GrB_apply (__VA_ARGS__)
#define GrB_Vector_apply_IndexOp_INT64_(...)    GrB_apply (__VA_ARGS__)
#define GrB_Vector_apply_IndexOp_UINT8_(...)    GrB_apply (__VA_ARGS__)
#define GrB_Vector_apply_IndexOp_UINT16_(...)   GrB_apply (__VA_ARGS__)
#define GrB_Vector_apply_IndexOp_UINT32_(...)   GrB_apply (__VA_ARGS__)
#define GrB_Vector_apply_IndexOp_UINT64_(...)   GrB_apply (__VA_ARGS__)
#define GrB_Vector_apply_IndexOp_FP32_(...)     GrB_apply (__VA_ARGS__)
#define GrB_Vector_apply_IndexOp_FP64_(...)     GrB_apply (__VA_ARGS__)
#define GxB_Vector_apply_IndexOp_FC32_(...)     GrB_apply (__VA_ARGS__)
#define GxB_Vector_apply_IndexOp_FC64_(...)     GrB_apply (__VA_ARGS__)
#define GrB_Vector_apply_IndexOp_UDT_(...)      GrB_apply (__VA_ARGS__)
#define GrB_Vector_apply_IndexOp_Scalar_(...)   GrB_apply (__VA_ARGS__)

// GrB_select:
#define GrB_Vector_select_BOOL_(...)     GrB_select (__VA_ARGS__)
#define GrB_Vector_select_INT8_(...)     GrB_select (__VA_ARGS__)
#define GrB_Vector_select_INT16_(...)    GrB_select (__VA_ARGS__)
#define GrB_Vector_select_INT32_(...)    GrB_select (__VA_ARGS__)
#define GrB_Vector_select_INT64_(...)    GrB_select (__VA_ARGS__)
#define GrB_Vector_select_UINT8_(...)    GrB_select (__VA_ARGS__)
#define GrB_Vector_select_UINT16_(...)   GrB_select (__VA_ARGS__)
#define GrB_Vector_select_UINT32_(...)   GrB_select (__VA_ARGS__)
#define GrB_Vector_select_UINT64_(...)   GrB_select (__VA_ARGS__)
#define GrB_Vector_select_FP32_(...)     GrB_select (__VA_ARGS__)
#define GrB_Vector_select_FP64_(...)     GrB_select (__VA_ARGS__)
#define GxB_Vector_select_FC32_(...)     GrB_select (__VA_ARGS__)
#define GxB_Vector_select_FC64_(...)     GrB_select (__VA_ARGS__)
#define GrB_Vector_select_UDT_(...)      GrB_select (__VA_ARGS__)
#define GrB_Vector_select_Scalar_(...)   GrB_select (__VA_ARGS__)

// GrB_apply: binary op, bind 1st
#define GxB_Matrix_apply_BinaryOp1st_(...)          GrB_apply (__VA_ARGS__)
#define GrB_Matrix_apply_BinaryOp1st_BOOL_(...)     GrB_apply (__VA_ARGS__)
#define GrB_Matrix_apply_BinaryOp1st_INT8_(...)     GrB_apply (__VA_ARGS__)
#define GrB_Matrix_apply_BinaryOp1st_INT16_(...)    GrB_apply (__VA_ARGS__)
#define GrB_Matrix_apply_BinaryOp1st_INT32_(...)    GrB_apply (__VA_ARGS__)
#define GrB_Matrix_apply_BinaryOp1st_INT64_(...)    GrB_apply (__VA_ARGS__)
#define GrB_Matrix_apply_BinaryOp1st_UINT8_(...)    GrB_apply (__VA_ARGS__)
#define GrB_Matrix_apply_BinaryOp1st_UINT16_(...)   GrB_apply (__VA_ARGS__)
#define GrB_Matrix_apply_BinaryOp1st_UINT32_(...)   GrB_apply (__VA_ARGS__)
#define GrB_Matrix_apply_BinaryOp1st_UINT64_(...)   GrB_apply (__VA_ARGS__)
#define GrB_Matrix_apply_BinaryOp1st_FP32_(...)     GrB_apply (__VA_ARGS__)
#define GrB_Matrix_apply_BinaryOp1st_FP64_(...)     GrB_apply (__VA_ARGS__)
#define GxB_Matrix_apply_BinaryOp1st_FC32_(...)     GrB_apply (__VA_ARGS__)
#define GxB_Matrix_apply_BinaryOp1st_FC64_(...)     GrB_apply (__VA_ARGS__)
#define GrB_Matrix_apply_BinaryOp1st_UDT_(...)      GrB_apply (__VA_ARGS__)
#define GrB_Matrix_apply_BinaryOp1st_Scalar_(...)   GrB_apply (__VA_ARGS__)

// GrB_apply: binary op, bind 2nd
#define GxB_Matrix_apply_BinaryOp2nd_(...)          GrB_apply (__VA_ARGS__)
#define GrB_Matrix_apply_BinaryOp2nd_BOOL_(...)     GrB_apply (__VA_ARGS__)
#define GrB_Matrix_apply_BinaryOp2nd_INT8_(...)     GrB_apply (__VA_ARGS__)
#define GrB_Matrix_apply_BinaryOp2nd_INT16_(...)    GrB_apply (__VA_ARGS__)
#define GrB_Matrix_apply_BinaryOp2nd_INT32_(...)    GrB_apply (__VA_ARGS__)
#define GrB_Matrix_apply_BinaryOp2nd_INT64_(...)    GrB_apply (__VA_ARGS__)
#define GrB_Matrix_apply_BinaryOp2nd_UINT8_(...)    GrB_apply (__VA_ARGS__)
#define GrB_Matrix_apply_BinaryOp2nd_UINT16_(...)   GrB_apply (__VA_ARGS__)
#define GrB_Matrix_apply_BinaryOp2nd_UINT32_(...)   GrB_apply (__VA_ARGS__)
#define GrB_Matrix_apply_BinaryOp2nd_UINT64_(...)   GrB_apply (__VA_ARGS__)
#define GrB_Matrix_apply_BinaryOp2nd_FP32_(...)     GrB_apply (__VA_ARGS__)
#define GrB_Matrix_apply_BinaryOp2nd_FP64_(...)     GrB_apply (__VA_ARGS__)
#define GxB_Matrix_apply_BinaryOp2nd_FC32_(...)     GrB_apply (__VA_ARGS__)
#define GxB_Matrix_apply_BinaryOp2nd_FC64_(...)     GrB_apply (__VA_ARGS__)
#define GrB_Matrix_apply_BinaryOp2nd_UDT_(...)      GrB_apply (__VA_ARGS__)
#define GrB_Matrix_apply_BinaryOp2nd_Scalar_(...)   GrB_apply (__VA_ARGS__)

// GrB_apply: idxunop
#define GxB_Matrix_apply_IndexOp_(...)          GrB_apply (__VA_ARGS__)
#define GrB_Matrix_apply_IndexOp_BOOL_(...)     GrB_apply (__VA_ARGS__)
#define GrB_Matrix_apply_IndexOp_INT8_(...)     GrB_apply (__VA_ARGS__)
#define GrB_Matrix_apply_IndexOp_INT16_(...)    GrB_apply (__VA_ARGS__)
#define GrB_Matrix_apply_IndexOp_INT32_(...)    GrB_apply (__VA_ARGS__)
#define GrB_Matrix_apply_IndexOp_INT64_(...)    GrB_apply (__VA_ARGS__)
#define GrB_Matrix_apply_IndexOp_UINT8_(...)    GrB_apply (__VA_ARGS__)
#define GrB_Matrix_apply_IndexOp_UINT16_(...)   GrB_apply (__VA_ARGS__)
#define GrB_Matrix_apply_IndexOp_UINT32_(...)   GrB_apply (__VA_ARGS__)
#define GrB_Matrix_apply_IndexOp_UINT64_(...)   GrB_apply (__VA_ARGS__)
#define GrB_Matrix_apply_IndexOp_FP32_(...)     GrB_apply (__VA_ARGS__)
#define GrB_Matrix_apply_IndexOp_FP64_(...)     GrB_apply (__VA_ARGS__)
#define GxB_Matrix_apply_IndexOp_FC32_(...)     GrB_apply (__VA_ARGS__)
#define GxB_Matrix_apply_IndexOp_FC64_(...)     GrB_apply (__VA_ARGS__)
#define GrB_Matrix_apply_IndexOp_UDT_(...)      GrB_apply (__VA_ARGS__)
#define GrB_Matrix_apply_IndexOp_Scalar_(...)   GrB_apply (__VA_ARGS__)

// GrB_select:
#define GrB_Matrix_select_BOOL_(...)     GrB_select (__VA_ARGS__)
#define GrB_Matrix_select_INT8_(...)     GrB_select (__VA_ARGS__)
#define GrB_Matrix_select_INT16_(...)    GrB_select (__VA_ARGS__)
#define GrB_Matrix_select_INT32_(...)    GrB_select (__VA_ARGS__)
#define GrB_Matrix_select_INT64_(...)    GrB_select (__VA_ARGS__)
#define GrB_Matrix_select_UINT8_(...)    GrB_select (__VA_ARGS__)
#define GrB_Matrix_select_UINT16_(...)   GrB_select (__VA_ARGS__)
#define GrB_Matrix_select_UINT32_(...)   GrB_select (__VA_ARGS__)
#define GrB_Matrix_select_UINT64_(...)   GrB_select (__VA_ARGS__)
#define GrB_Matrix_select_FP32_(...)     GrB_select (__VA_ARGS__)
#define GrB_Matrix_select_FP64_(...)     GrB_select (__VA_ARGS__)
#define GxB_Matrix_select_FC32_(...)     GrB_select (__VA_ARGS__)
#define GxB_Matrix_select_FC64_(...)     GrB_select (__VA_ARGS__)
#define GrB_Matrix_select_UDT_(...)      GrB_select (__VA_ARGS__)
#define GrB_Matrix_select_Scalar_(...)   GrB_select (__VA_ARGS__)

// GxB_select:
#define GxB_Vector_select_(...)                     GxB_select (__VA_ARGS__)
#define GxB_Matrix_select_(...)                     GxB_select (__VA_ARGS__)

// GrB_reduce:
#define GrB_Matrix_reduce_BinaryOp_Scalar_(...)     GrB_reduce (__VA_ARGS__)
#define GrB_Vector_reduce_BinaryOp_Scalar_(...)     GrB_reduce (__VA_ARGS__)
#define GrB_Matrix_reduce_Monoid_Scalar_(...)       GrB_reduce (__VA_ARGS__)
#define GrB_Matrix_reduce_Monoid_(...)              GrB_reduce (__VA_ARGS__)
#define GrB_Matrix_reduce_BinaryOp_(...)            GrB_reduce (__VA_ARGS__)
#define GrB_Vector_reduce_Monoid_Scalar_(...)       GrB_reduce (__VA_ARGS__)
#define GrB_Vector_reduce_BOOL_(...)                GrB_reduce (__VA_ARGS__)
#define GrB_Vector_reduce_INT8_(...)                GrB_reduce (__VA_ARGS__)
#define GrB_Vector_reduce_INT16_(...)               GrB_reduce (__VA_ARGS__)
#define GrB_Vector_reduce_INT32_(...)               GrB_reduce (__VA_ARGS__)
#define GrB_Vector_reduce_INT64_(...)               GrB_reduce (__VA_ARGS__)
#define GrB_Vector_reduce_UINT8_(...)               GrB_reduce (__VA_ARGS__)
#define GrB_Vector_reduce_UINT16_(...)              GrB_reduce (__VA_ARGS__)
#define GrB_Vector_reduce_UINT32_(...)              GrB_reduce (__VA_ARGS__)
#define GrB_Vector_reduce_UINT64_(...)              GrB_reduce (__VA_ARGS__)
#define GrB_Vector_reduce_FP32_(...)                GrB_reduce (__VA_ARGS__)
#define GrB_Vector_reduce_FP64_(...)                GrB_reduce (__VA_ARGS__)
#define GxB_Vector_reduce_FC32_(...)                GrB_reduce (__VA_ARGS__)
#define GxB_Vector_reduce_FC64_(...)                GrB_reduce (__VA_ARGS__)
#define GrB_Vector_reduce_UDT_(...)                 GrB_reduce (__VA_ARGS__)
#define GrB_Matrix_reduce_BOOL_(...)                GrB_reduce (__VA_ARGS__)
#define GrB_Matrix_reduce_INT8_(...)                GrB_reduce (__VA_ARGS__)
#define GrB_Matrix_reduce_INT16_(...)               GrB_reduce (__VA_ARGS__)
#define GrB_Matrix_reduce_INT32_(...)               GrB_reduce (__VA_ARGS__)
#define GrB_Matrix_reduce_INT64_(...)               GrB_reduce (__VA_ARGS__)
#define GrB_Matrix_reduce_UINT8_(...)               GrB_reduce (__VA_ARGS__)
#define GrB_Matrix_reduce_UINT16_(...)              GrB_reduce (__VA_ARGS__)
#define GrB_Matrix_reduce_UINT32_(...)              GrB_reduce (__VA_ARGS__)
#define GrB_Matrix_reduce_UINT64_(...)              GrB_reduce (__VA_ARGS__)
#define GrB_Matrix_reduce_FP32_(...)                GrB_reduce (__VA_ARGS__)
#define GrB_Matrix_reduce_FP64_(...)                GrB_reduce (__VA_ARGS__)
#define GxB_Matrix_reduce_FC32_(...)                GrB_reduce (__VA_ARGS__)
#define GxB_Matrix_reduce_FC64_(...)                GrB_reduce (__VA_ARGS__)
#define GrB_Matrix_reduce_UDT_(...)                 GrB_reduce (__VA_ARGS__)

// GxB_resize:
#define GrB_Matrix_resize_(...)                     GxB_resize (__VA_ARGS__)
#define GrB_Vector_resize_(...)                     GxB_resize (__VA_ARGS__)

// GrB_kronecker:
#define GrB_Matrix_kronecker_BinaryOp_(...)         GrB_kronecker (__VA_ARGS__)
#define GrB_Matrix_kronecker_Monoid_(...)           GrB_kronecker (__VA_ARGS__)
#define GrB_Matrix_kronecker_Semiring_(...)         GrB_kronecker (__VA_ARGS__)

// GxB_fprint:
#define GxB_Type_fprint_(o,p,f)                     GxB_fprint (o,p,f)
#define GxB_UnaryOp_fprint_(o,p,f)                  GxB_fprint (o,p,f)
#define GxB_BinaryOp_fprint_(o,p,f)                 GxB_fprint (o,p,f)
#define GxB_SelectOp_fprint_(o,p,f)                 GxB_fprint (o,p,f)
#define GxB_Monoid_fprint_(o,p,f)                   GxB_fprint (o,p,f)
#define GxB_Semiring_fprint_(o,p,f)                 GxB_fprint (o,p,f)
#define GxB_Descriptor_fprint_(o,p,f)               GxB_fprint (o,p,f)
#define GxB_Matrix_fprint_(o,p,f)                   GxB_fprint (o,p,f)
#define GxB_Vector_fprint_(o,p,f)                   GxB_fprint (o,p,f)
#define GxB_Scalar_fprint_(o,p,f)                   GxB_fprint (o,p,f)

#else

//------------------------------------------------------------------------------
// testing the non-polymorphic versions
//------------------------------------------------------------------------------

// GrB_get:
#define GrB_Scalar_get_Scalar_(...)             GrB_Scalar_get_Scalar (__VA_ARGS__ )             
#define GrB_Scalar_get_String_(...)             GrB_Scalar_get_String (__VA_ARGS__ )             
#define GrB_Scalar_get_INT32_(...)              GrB_Scalar_get_INT32 (__VA_ARGS__ )              
#define GrB_Scalar_get_SIZE_(...)               GrB_Scalar_get_SIZE (__VA_ARGS__ )               
#define GrB_Scalar_get_VOID_(...)               GrB_Scalar_get_VOID (__VA_ARGS__ )               

#define GrB_Vector_get_Scalar_(...)             GrB_Vector_get_Scalar (__VA_ARGS__ )             
#define GrB_Vector_get_String_(...)             GrB_Vector_get_String (__VA_ARGS__ )             
#define GrB_Vector_get_INT32_(...)              GrB_Vector_get_INT32 (__VA_ARGS__ )              
#define GrB_Vector_get_SIZE_(...)               GrB_Vector_get_SIZE (__VA_ARGS__ )               
#define GrB_Vector_get_VOID_(...)               GrB_Vector_get_VOID (__VA_ARGS__ )               

#define GrB_Matrix_get_Scalar_(...)             GrB_Matrix_get_Scalar (__VA_ARGS__ )             
#define GrB_Matrix_get_String_(...)             GrB_Matrix_get_String (__VA_ARGS__ )             
#define GrB_Matrix_get_INT32_(...)              GrB_Matrix_get_INT32 (__VA_ARGS__ )              
#define GrB_Matrix_get_SIZE_(...)               GrB_Matrix_get_SIZE (__VA_ARGS__ )               
#define GrB_Matrix_get_VOID_(...)               GrB_Matrix_get_VOID (__VA_ARGS__ )               

#define GxB_Serialized_get_Scalar_(...)         GxB_Serialized_get_Scalar (__VA_ARGS__ )         
#define GxB_Serialized_get_String_(...)         GxB_Serialized_get_String (__VA_ARGS__ )         
#define GxB_Serialized_get_INT32_(...)          GxB_Serialized_get_INT32 (__VA_ARGS__ )          
#define GxB_Serialized_get_SIZE_(...)           GxB_Serialized_get_SIZE (__VA_ARGS__ )           
#define GxB_Serialized_get_VOID_(...)           GxB_Serialized_get_VOID (__VA_ARGS__ )           

#define GrB_UnaryOp_get_Scalar_(...)            GrB_UnaryOp_get_Scalar (__VA_ARGS__ )            
#define GrB_UnaryOp_get_String_(...)            GrB_UnaryOp_get_String (__VA_ARGS__ )            
#define GrB_UnaryOp_get_INT32_(...)             GrB_UnaryOp_get_INT32 (__VA_ARGS__ )             
#define GrB_UnaryOp_get_SIZE_(...)              GrB_UnaryOp_get_SIZE (__VA_ARGS__ )              
#define GrB_UnaryOp_get_VOID_(...)              GrB_UnaryOp_get_VOID (__VA_ARGS__ )              

#define GrB_IndexUnaryOp_get_Scalar_(...)       GrB_IndexUnaryOp_get_Scalar (__VA_ARGS__ )       
#define GrB_IndexUnaryOp_get_String_(...)       GrB_IndexUnaryOp_get_String (__VA_ARGS__ )       
#define GrB_IndexUnaryOp_get_INT32_(...)        GrB_IndexUnaryOp_get_INT32 (__VA_ARGS__ )        
#define GrB_IndexUnaryOp_get_SIZE_(...)         GrB_IndexUnaryOp_get_SIZE (__VA_ARGS__ )         
#define GrB_IndexUnaryOp_get_VOID_(...)         GrB_IndexUnaryOp_get_VOID (__VA_ARGS__ )         

#define GrB_BinaryOp_get_Scalar_(...)           GrB_BinaryOp_get_Scalar (__VA_ARGS__ )           
#define GrB_BinaryOp_get_String_(...)           GrB_BinaryOp_get_String (__VA_ARGS__ )           
#define GrB_BinaryOp_get_INT32_(...)            GrB_BinaryOp_get_INT32 (__VA_ARGS__ )            
#define GrB_BinaryOp_get_SIZE_(...)             GrB_BinaryOp_get_SIZE (__VA_ARGS__ )             
#define GrB_BinaryOp_get_VOID_(...)             GrB_BinaryOp_get_VOID (__VA_ARGS__ )             

#define GrB_Monoid_get_Scalar_(...)             GrB_Monoid_get_Scalar (__VA_ARGS__ )             
#define GrB_Monoid_get_String_(...)             GrB_Monoid_get_String (__VA_ARGS__ )             
#define GrB_Monoid_get_INT32_(...)              GrB_Monoid_get_INT32 (__VA_ARGS__ )              
#define GrB_Monoid_get_SIZE_(...)               GrB_Monoid_get_SIZE (__VA_ARGS__ )               
#define GrB_Monoid_get_VOID_(...)               GrB_Monoid_get_VOID (__VA_ARGS__ )               

#define GrB_Semiring_get_Scalar_(...)           GrB_Semiring_get_Scalar (__VA_ARGS__ )           
#define GrB_Semiring_get_String_(...)           GrB_Semiring_get_String (__VA_ARGS__ )           
#define GrB_Semiring_get_INT32_(...)            GrB_Semiring_get_INT32 (__VA_ARGS__ )            
#define GrB_Semiring_get_SIZE_(...)             GrB_Semiring_get_SIZE (__VA_ARGS__ )             
#define GrB_Semiring_get_VOID_(...)             GrB_Semiring_get_VOID (__VA_ARGS__ )             

#define GrB_Descriptor_get_Scalar_(...)         GrB_Descriptor_get_Scalar (__VA_ARGS__ )         
#define GrB_Descriptor_get_String_(...)         GrB_Descriptor_get_String (__VA_ARGS__ )         
#define GrB_Descriptor_get_INT32_(...)          GrB_Descriptor_get_INT32 (__VA_ARGS__ )          
#define GrB_Descriptor_get_SIZE_(...)           GrB_Descriptor_get_SIZE (__VA_ARGS__ )           
#define GrB_Descriptor_get_VOID_(...)           GrB_Descriptor_get_VOID (__VA_ARGS__ )           

#define GrB_Type_get_Scalar_(...)               GrB_Type_get_Scalar (__VA_ARGS__ )               
#define GrB_Type_get_String_(...)               GrB_Type_get_String (__VA_ARGS__ )               
#define GrB_Type_get_INT32_(...)                GrB_Type_get_INT32 (__VA_ARGS__ )                
#define GrB_Type_get_SIZE_(...)                 GrB_Type_get_SIZE (__VA_ARGS__ )                 
#define GrB_Type_get_VOID_(...)                 GrB_Type_get_VOID (__VA_ARGS__ )                 

#define GrB_Global_get_Scalar_(...)             GrB_Global_get_Scalar (__VA_ARGS__ )             
#define GrB_Global_get_String_(...)             GrB_Global_get_String (__VA_ARGS__ )             
#define GrB_Global_get_INT32_(...)              GrB_Global_get_INT32 (__VA_ARGS__ )              
#define GrB_Global_get_SIZE_(...)               GrB_Global_get_SIZE (__VA_ARGS__ )               
#define GrB_Global_get_VOID_(...)               GrB_Global_get_VOID (__VA_ARGS__ )               

#define GxB_Context_get_Scalar_(...)            GxB_Context_get_Scalar (__VA_ARGS__ )            
#define GxB_Context_get_String_(...)            GxB_Context_get_String (__VA_ARGS__ )            
#define GxB_Context_get_INT_(...)               GxB_Context_get_INT (__VA_ARGS__ )               
#define GxB_Context_get_SIZE_(...)              GxB_Context_get_SIZE (__VA_ARGS__ )              
#define GxB_Context_get_VOID_(...)              GxB_Context_get_VOID (__VA_ARGS__ )              

// GrB_set:

#define GrB_Scalar_set_Scalar_(...)             GrB_Scalar_set_Scalar (__VA_ARGS__ )             
#define GrB_Scalar_set_String_(...)             GrB_Scalar_set_String (__VA_ARGS__ )             
#define GrB_Scalar_set_INT32_(...)              GrB_Scalar_set_INT32 (__VA_ARGS__ )              
#define GrB_Scalar_set_VOID_(...)               GrB_Scalar_set_VOID (__VA_ARGS__ )               

#define GrB_Vector_set_Scalar_(...)             GrB_Vector_set_Scalar (__VA_ARGS__ )             
#define GrB_Vector_set_String_(...)             GrB_Vector_set_String (__VA_ARGS__ )             
#define GrB_Vector_set_INT32_(...)              GrB_Vector_set_INT32 (__VA_ARGS__ )              
#define GrB_Vector_set_VOID_(...)               GrB_Vector_set_VOID (__VA_ARGS__ )               

#define GrB_Matrix_set_Scalar_(...)             GrB_Matrix_set_Scalar (__VA_ARGS__ )             
#define GrB_Matrix_set_String_(...)             GrB_Matrix_set_String (__VA_ARGS__ )             
#define GrB_Matrix_set_INT32_(...)              GrB_Matrix_set_INT32 (__VA_ARGS__ )              
#define GrB_Matrix_set_VOID_(...)               GrB_Matrix_set_VOID (__VA_ARGS__ )               

#define GrB_UnaryOp_set_Scalar_(...)            GrB_UnaryOp_set_Scalar (__VA_ARGS__ )            
#define GrB_UnaryOp_set_String_(...)            GrB_UnaryOp_set_String (__VA_ARGS__ )            
#define GrB_UnaryOp_set_INT32_(...)             GrB_UnaryOp_set_INT32 (__VA_ARGS__ )             
#define GrB_UnaryOp_set_VOID_(...)              GrB_UnaryOp_set_VOID (__VA_ARGS__ )              

#define GrB_IndexUnaryOp_set_Scalar_(...)       GrB_IndexUnaryOp_set_Scalar (__VA_ARGS__ )       
#define GrB_IndexUnaryOp_set_String_(...)       GrB_IndexUnaryOp_set_String (__VA_ARGS__ )       
#define GrB_IndexUnaryOp_set_INT32_(...)        GrB_IndexUnaryOp_set_INT32 (__VA_ARGS__ )        
#define GrB_IndexUnaryOp_set_VOID_(...)         GrB_IndexUnaryOp_set_VOID (__VA_ARGS__ )         

#define GrB_BinaryOp_set_Scalar_(...)           GrB_BinaryOp_set_Scalar (__VA_ARGS__ )           
#define GrB_BinaryOp_set_String_(...)           GrB_BinaryOp_set_String (__VA_ARGS__ )           
#define GrB_BinaryOp_set_INT32_(...)            GrB_BinaryOp_set_INT32 (__VA_ARGS__ )            
#define GrB_BinaryOp_set_VOID_(...)             GrB_BinaryOp_set_VOID (__VA_ARGS__ )             

#define GrB_Monoid_set_Scalar_(...)             GrB_Monoid_set_Scalar (__VA_ARGS__ )             
#define GrB_Monoid_set_String_(...)             GrB_Monoid_set_String (__VA_ARGS__ )             
#define GrB_Monoid_set_INT32_(...)              GrB_Monoid_set_INT32 (__VA_ARGS__ )              
#define GrB_Monoid_set_VOID_(...)               GrB_Monoid_set_VOID (__VA_ARGS__ )               

#define GrB_Semiring_set_Scalar_(...)           GrB_Semiring_set_Scalar (__VA_ARGS__ )           
#define GrB_Semiring_set_String_(...)           GrB_Semiring_set_String (__VA_ARGS__ )           
#define GrB_Semiring_set_INT32_(...)            GrB_Semiring_set_INT32 (__VA_ARGS__ )            
#define GrB_Semiring_set_VOID_(...)             GrB_Semiring_set_VOID (__VA_ARGS__ )             

#define GrB_Descriptor_set_Scalar_(...)         GrB_Descriptor_set_Scalar (__VA_ARGS__ )         
#define GrB_Descriptor_set_String_(...)         GrB_Descriptor_set_String (__VA_ARGS__ )         
#define GrB_Descriptor_set_INT32_(...)          GrB_Descriptor_set_INT32 (__VA_ARGS__ )          
#define GrB_Descriptor_set_VOID_(...)           GrB_Descriptor_set_VOID (__VA_ARGS__ )           

#define GrB_Type_set_Scalar_(...)               GrB_Type_set_Scalar (__VA_ARGS__ )               
#define GrB_Type_set_String_(...)               GrB_Type_set_String (__VA_ARGS__ )               
#define GrB_Type_set_INT32_(...)                GrB_Type_set_INT32 (__VA_ARGS__ )                
#define GrB_Type_set_VOID_(...)                 GrB_Type_set_VOID (__VA_ARGS__ )                 

#define GrB_Global_set_Scalar_(...)             GrB_Global_set_Scalar (__VA_ARGS__ )             
#define GrB_Global_set_String_(...)             GrB_Global_set_String (__VA_ARGS__ )             
#define GrB_Global_set_INT32_(...)              GrB_Global_set_INT32 (__VA_ARGS__ )              
#define GrB_Global_set_VOID_(...)               GrB_Global_set_VOID (__VA_ARGS__ )               

#define GxB_Context_set_Scalar_(...)            GxB_Context_set_Scalar (__VA_ARGS__ )            
#define GxB_Context_set_String_(...)            GxB_Context_set_String (__VA_ARGS__ )            
#define GxB_Context_set_INT_(...)               GxB_Context_set_INT (__VA_ARGS__ )               
#define GxB_Context_set_VOID_(...)              GxB_Context_set_VOID (__VA_ARGS__ )              

// GrB_free:
#define GrB_Type_free_(...)                         GrB_Type_free (__VA_ARGS__)
#define GrB_UnaryOp_free_(...)                      GrB_UnaryOp_free (__VA_ARGS__)
#define GrB_BinaryOp_free_(...)                     GrB_BinaryOp_free (__VA_ARGS__)
#define GrB_IndexUnaryOp_free_(...)                 GrB_IndexUnaryOp_free (__VA_ARGS__)
#define GrB_Monoid_free_(...)                       GrB_Monoid_free (__VA_ARGS__)
#define GrB_Semiring_free_(...)                     GrB_Semiring_free (__VA_ARGS__)
#define GrB_Scalar_free_(...)                       GrB_Scalar_free (__VA_ARGS__)
#define GrB_Vector_free_(...)                       GrB_Vector_free (__VA_ARGS__)
#define GrB_Matrix_free_(...)                       GrB_Matrix_free (__VA_ARGS__)
#define GrB_Descriptor_free_(...)                   GrB_Descriptor_free (__VA_ARGS__)

// GrB_error:
#define GrB_Type_error_(...)                        GrB_Type_error (__VA_ARGS__)
#define GrB_UnaryOp_error_(...)                     GrB_UnaryOp_error (__VA_ARGS__)
#define GrB_BinaryOp_error_(...)                    GrB_BinaryOp_error (__VA_ARGS__)
#define GrB_IndexUnaryOp_error_(...)                GrB_IndexUnaryOp_error (__VA_ARGS__)
#define GrB_Monoid_error_(...)                      GrB_Monoid_error (__VA_ARGS__)
#define GrB_Semiring_error_(...)                    GrB_Semiring_error (__VA_ARGS__)
#define GrB_Scalar_error_(...)                      GrB_Scalar_error (__VA_ARGS__)
#define GrB_Vector_error_(...)                      GrB_Vector_error (__VA_ARGS__)
#define GrB_Matrix_error_(...)                      GrB_Matrix_error (__VA_ARGS__)
#define GrB_Descriptor_error_(...)                  GrB_Descriptor_error (__VA_ARGS__)

// GrB_Monoid_new:
#define GrB_Monoid_new_BOOL_(...)                   GrB_Monoid_new_BOOL (__VA_ARGS__)
#define GrB_Monoid_new_INT8_(...)                   GrB_Monoid_new_INT8 (__VA_ARGS__)
#define GrB_Monoid_new_INT16_(...)                  GrB_Monoid_new_INT16 (__VA_ARGS__)
#define GrB_Monoid_new_INT32_(...)                  GrB_Monoid_new_INT32 (__VA_ARGS__)
#define GrB_Monoid_new_INT64_(...)                  GrB_Monoid_new_INT64 (__VA_ARGS__)
#define GrB_Monoid_new_UINT8_(...)                  GrB_Monoid_new_UINT8 (__VA_ARGS__)
#define GrB_Monoid_new_UINT16_(...)                 GrB_Monoid_new_UINT16 (__VA_ARGS__)
#define GrB_Monoid_new_UINT32_(...)                 GrB_Monoid_new_UINT32 (__VA_ARGS__)
#define GrB_Monoid_new_UINT64_(...)                 GrB_Monoid_new_UINT64 (__VA_ARGS__)
#define GrB_Monoid_new_FP32_(...)                   GrB_Monoid_new_FP32 (__VA_ARGS__)
#define GrB_Monoid_new_FP64_(...)                   GrB_Monoid_new_FP64 (__VA_ARGS__)
#define GxB_Monoid_new_FC32_(...)                   GxB_Monoid_new_FC32 (__VA_ARGS__)
#define GxB_Monoid_new_FC64_(...)                   GxB_Monoid_new_FC64 (__VA_ARGS__)
#define GrB_Monoid_new_UDT_(...)                    GrB_Monoid_new_UDT (__VA_ARGS__)

// GxB_Monoid_terminal_new:
#define GxB_Monoid_terminal_new_BOOL_(...)          GxB_Monoid_terminal_new_BOOL (__VA_ARGS__)
#define GxB_Monoid_terminal_new_INT8_(...)          GxB_Monoid_terminal_new_INT8 (__VA_ARGS__)
#define GxB_Monoid_terminal_new_INT16_(...)         GxB_Monoid_terminal_new_INT16 (__VA_ARGS__)
#define GxB_Monoid_terminal_new_INT32_(...)         GxB_Monoid_terminal_new_INT32 (__VA_ARGS__)
#define GxB_Monoid_terminal_new_INT64_(...)         GxB_Monoid_terminal_new_INT64 (__VA_ARGS__)
#define GxB_Monoid_terminal_new_UINT8_(...)         GxB_Monoid_terminal_new_UINT8 (__VA_ARGS__)
#define GxB_Monoid_terminal_new_UINT16_(...)        GxB_Monoid_terminal_new_UINT16 (__VA_ARGS__)
#define GxB_Monoid_terminal_new_UINT32_(...)        GxB_Monoid_terminal_new_UINT32 (__VA_ARGS__)
#define GxB_Monoid_terminal_new_UINT64_(...)        GxB_Monoid_terminal_new_UINT64 (__VA_ARGS__)
#define GxB_Monoid_terminal_new_FP32_(...)          GxB_Monoid_terminal_new_FP32 (__VA_ARGS__)
#define GxB_Monoid_terminal_new_FP64_(...)          GxB_Monoid_terminal_new_FP64 (__VA_ARGS__)
#define GxB_Monoid_terminal_new_FC32_(...)          GxB_Monoid_terminal_new_FC32 (__VA_ARGS__)
#define GxB_Monoid_terminal_new_FC64_(...)          GxB_Monoid_terminal_new_FC64 (__VA_ARGS__)
#define GxB_Monoid_terminal_new_UDT_(...)           GxB_Monoid_terminal_new_UDT (__VA_ARGS__)

// GrB_Scalar_setElement:
#define GrB_Scalar_setElement_BOOL_(...)            GrB_Scalar_setElement_BOOL (__VA_ARGS__)
#define GrB_Scalar_setElement_INT8_(...)            GrB_Scalar_setElement_INT8 (__VA_ARGS__)
#define GrB_Scalar_setElement_INT16_(...)           GrB_Scalar_setElement_INT16 (__VA_ARGS__)
#define GrB_Scalar_setElement_INT32_(...)           GrB_Scalar_setElement_INT32 (__VA_ARGS__)
#define GrB_Scalar_setElement_INT64_(...)           GrB_Scalar_setElement_INT64 (__VA_ARGS__)
#define GrB_Scalar_setElement_UINT8_(...)           GrB_Scalar_setElement_UINT8 (__VA_ARGS__)
#define GrB_Scalar_setElement_UINT16_(...)          GrB_Scalar_setElement_UINT16 (__VA_ARGS__)
#define GrB_Scalar_setElement_UINT32_(...)          GrB_Scalar_setElement_UINT32 (__VA_ARGS__)
#define GrB_Scalar_setElement_UINT64_(...)          GrB_Scalar_setElement_UINT64 (__VA_ARGS__)
#define GrB_Scalar_setElement_FP32_(...)            GrB_Scalar_setElement_FP32 (__VA_ARGS__)
#define GrB_Scalar_setElement_FP64_(...)            GrB_Scalar_setElement_FP64 (__VA_ARGS__)
#define GxB_Scalar_setElement_FC32_(...)            GxB_Scalar_setElement_FC32 (__VA_ARGS__)
#define GxB_Scalar_setElement_FC64_(...)            GxB_Scalar_setElement_FC64 (__VA_ARGS__)
#define GrB_Scalar_setElement_UDT_(...)             GrB_Scalar_setElement_UDT (__VA_ARGS__)

// GrB_Scalar_extractElement:
#define GrB_Scalar_extractElement_BOOL_(...)        GrB_Scalar_extractElement_BOOL (__VA_ARGS__)
#define GrB_Scalar_extractElement_INT8_(...)        GrB_Scalar_extractElement_INT8 (__VA_ARGS__)
#define GrB_Scalar_extractElement_INT16_(...)       GrB_Scalar_extractElement_INT16 (__VA_ARGS__)
#define GrB_Scalar_extractElement_INT32_(...)       GrB_Scalar_extractElement_INT32 (__VA_ARGS__)
#define GrB_Scalar_extractElement_INT64_(...)       GrB_Scalar_extractElement_INT64 (__VA_ARGS__)
#define GrB_Scalar_extractElement_UINT8_(...)       GrB_Scalar_extractElement_UINT8 (__VA_ARGS__)
#define GrB_Scalar_extractElement_UINT16_(...)      GrB_Scalar_extractElement_UINT16 (__VA_ARGS__)
#define GrB_Scalar_extractElement_UINT32_(...)      GrB_Scalar_extractElement_UINT32 (__VA_ARGS__)
#define GrB_Scalar_extractElement_UINT64_(...)      GrB_Scalar_extractElement_UINT64 (__VA_ARGS__)
#define GrB_Scalar_extractElement_FP32_(...)        GrB_Scalar_extractElement_FP32 (__VA_ARGS__)
#define GrB_Scalar_extractElement_FP64_(...)        GrB_Scalar_extractElement_FP64 (__VA_ARGS__)
#define GxB_Scalar_extractElement_FC32_(...)        GxB_Scalar_extractElement_FC32 (__VA_ARGS__)
#define GxB_Scalar_extractElement_FC64_(...)        GxB_Scalar_extractElement_FC64 (__VA_ARGS__)
#define GrB_Scalar_extractElement_UDT_(...)         GrB_Scalar_extractElement_UDT (__VA_ARGS__)

// GrB_Vector_build:
#define GrB_Vector_build_BOOL_(...)                 GrB_Vector_build_BOOL (__VA_ARGS__)
#define GrB_Vector_build_INT8_(...)                 GrB_Vector_build_INT8 (__VA_ARGS__)
#define GrB_Vector_build_INT16_(...)                GrB_Vector_build_INT16 (__VA_ARGS__)
#define GrB_Vector_build_INT32_(...)                GrB_Vector_build_INT32 (__VA_ARGS__)
#define GrB_Vector_build_INT64_(...)                GrB_Vector_build_INT64 (__VA_ARGS__)
#define GrB_Vector_build_UINT8_(...)                GrB_Vector_build_UINT8 (__VA_ARGS__)
#define GrB_Vector_build_UINT16_(...)               GrB_Vector_build_UINT16 (__VA_ARGS__)
#define GrB_Vector_build_UINT32_(...)               GrB_Vector_build_UINT32 (__VA_ARGS__)
#define GrB_Vector_build_UINT64_(...)               GrB_Vector_build_UINT64 (__VA_ARGS__)
#define GrB_Vector_build_FP32_(...)                 GrB_Vector_build_FP32 (__VA_ARGS__)
#define GrB_Vector_build_FP64_(...)                 GrB_Vector_build_FP64 (__VA_ARGS__)
#define GxB_Vector_build_FC32_(...)                 GxB_Vector_build_FC32 (__VA_ARGS__)
#define GxB_Vector_build_FC64_(...)                 GxB_Vector_build_FC64 (__VA_ARGS__)
#define GrB_Vector_build_UDT_(...)                  GrB_Vector_build_UDT (__VA_ARGS__)

// GrB_Vector_setElement:
#define GrB_Vector_setElement_BOOL_(...)            GrB_Vector_setElement_BOOL (__VA_ARGS__)
#define GrB_Vector_setElement_INT8_(...)            GrB_Vector_setElement_INT8 (__VA_ARGS__)
#define GrB_Vector_setElement_INT16_(...)           GrB_Vector_setElement_INT16 (__VA_ARGS__)
#define GrB_Vector_setElement_INT32_(...)           GrB_Vector_setElement_INT32 (__VA_ARGS__)
#define GrB_Vector_setElement_INT64_(...)           GrB_Vector_setElement_INT64 (__VA_ARGS__)
#define GrB_Vector_setElement_UINT8_(...)           GrB_Vector_setElement_UINT8 (__VA_ARGS__)
#define GrB_Vector_setElement_UINT16_(...)          GrB_Vector_setElement_UINT16 (__VA_ARGS__)
#define GrB_Vector_setElement_UINT32_(...)          GrB_Vector_setElement_UINT32 (__VA_ARGS__)
#define GrB_Vector_setElement_UINT64_(...)          GrB_Vector_setElement_UINT64 (__VA_ARGS__)
#define GrB_Vector_setElement_FP32_(...)            GrB_Vector_setElement_FP32 (__VA_ARGS__)
#define GrB_Vector_setElement_FP64_(...)            GrB_Vector_setElement_FP64 (__VA_ARGS__)
#define GxB_Vector_setElement_FC32_(...)            GxB_Vector_setElement_FC32 (__VA_ARGS__)
#define GxB_Vector_setElement_FC64_(...)            GxB_Vector_setElement_FC64 (__VA_ARGS__)
#define GrB_Vector_setElement_UDT_(...)             GrB_Vector_setElement_UDT (__VA_ARGS__)
#define GrB_Vector_setElement_Scalar_(...)          GrB_Vector_setElement_Scalar (__VA_ARGS__)

// GrB_Vector_extractElement:
#define GrB_Vector_extractElement_BOOL_(...)        GrB_Vector_extractElement_BOOL (__VA_ARGS__)
#define GrB_Vector_extractElement_INT8_(...)        GrB_Vector_extractElement_INT8 (__VA_ARGS__)
#define GrB_Vector_extractElement_INT16_(...)       GrB_Vector_extractElement_INT16 (__VA_ARGS__)
#define GrB_Vector_extractElement_INT32_(...)       GrB_Vector_extractElement_INT32 (__VA_ARGS__)
#define GrB_Vector_extractElement_INT64_(...)       GrB_Vector_extractElement_INT64 (__VA_ARGS__)
#define GrB_Vector_extractElement_UINT8_(...)       GrB_Vector_extractElement_UINT8 (__VA_ARGS__)
#define GrB_Vector_extractElement_UINT16_(...)      GrB_Vector_extractElement_UINT16 (__VA_ARGS__)
#define GrB_Vector_extractElement_UINT32_(...)      GrB_Vector_extractElement_UINT32 (__VA_ARGS__)
#define GrB_Vector_extractElement_UINT64_(...)      GrB_Vector_extractElement_UINT64 (__VA_ARGS__)
#define GrB_Vector_extractElement_FP32_(...)        GrB_Vector_extractElement_FP32 (__VA_ARGS__)
#define GrB_Vector_extractElement_FP64_(...)        GrB_Vector_extractElement_FP64 (__VA_ARGS__)
#define GxB_Vector_extractElement_FC32_(...)        GxB_Vector_extractElement_FC32 (__VA_ARGS__)
#define GxB_Vector_extractElement_FC64_(...)        GxB_Vector_extractElement_FC64 (__VA_ARGS__)
#define GrB_Vector_extractElement_UDT_(...)         GrB_Vector_extractElement_UDT (__VA_ARGS__)
#define GrB_Vector_extractElement_Scalar_(...)      GrB_Vector_extractElement_Scalar (__VA_ARGS__)

// GrB_Vector_extractTuples:
#define GrB_Vector_extractTuples_BOOL_(...)         GrB_Vector_extractTuples_BOOL (__VA_ARGS__)
#define GrB_Vector_extractTuples_INT8_(...)         GrB_Vector_extractTuples_INT8 (__VA_ARGS__)
#define GrB_Vector_extractTuples_INT16_(...)        GrB_Vector_extractTuples_INT16 (__VA_ARGS__)
#define GrB_Vector_extractTuples_INT32_(...)        GrB_Vector_extractTuples_INT32 (__VA_ARGS__)
#define GrB_Vector_extractTuples_INT64_(...)        GrB_Vector_extractTuples_INT64 (__VA_ARGS__)
#define GrB_Vector_extractTuples_UINT8_(...)        GrB_Vector_extractTuples_UINT8 (__VA_ARGS__)
#define GrB_Vector_extractTuples_UINT16_(...)       GrB_Vector_extractTuples_UINT16 (__VA_ARGS__)
#define GrB_Vector_extractTuples_UINT32_(...)       GrB_Vector_extractTuples_UINT32 (__VA_ARGS__)
#define GrB_Vector_extractTuples_UINT64_(...)       GrB_Vector_extractTuples_UINT64 (__VA_ARGS__)
#define GrB_Vector_extractTuples_FP32_(...)         GrB_Vector_extractTuples_FP32 (__VA_ARGS__)
#define GrB_Vector_extractTuples_FP64_(...)         GrB_Vector_extractTuples_FP64 (__VA_ARGS__)
#define GxB_Vector_extractTuples_FC32_(...)         GxB_Vector_extractTuples_FC32 (__VA_ARGS__)
#define GxB_Vector_extractTuples_FC64_(...)         GxB_Vector_extractTuples_FC64 (__VA_ARGS__)
#define GrB_Vector_extractTuples_UDT_(...)          GrB_Vector_extractTuples_UDT (__VA_ARGS__)

// GrB_Matrix_build:
#define GrB_Matrix_build_BOOL_(...)                 GrB_Matrix_build_BOOL (__VA_ARGS__)
#define GrB_Matrix_build_INT8_(...)                 GrB_Matrix_build_INT8 (__VA_ARGS__)
#define GrB_Matrix_build_INT16_(...)                GrB_Matrix_build_INT16 (__VA_ARGS__)
#define GrB_Matrix_build_INT32_(...)                GrB_Matrix_build_INT32 (__VA_ARGS__)
#define GrB_Matrix_build_INT64_(...)                GrB_Matrix_build_INT64 (__VA_ARGS__)
#define GrB_Matrix_build_UINT8_(...)                GrB_Matrix_build_UINT8 (__VA_ARGS__)
#define GrB_Matrix_build_UINT16_(...)               GrB_Matrix_build_UINT16 (__VA_ARGS__)
#define GrB_Matrix_build_UINT32_(...)               GrB_Matrix_build_UINT32 (__VA_ARGS__)
#define GrB_Matrix_build_UINT64_(...)               GrB_Matrix_build_UINT64 (__VA_ARGS__)
#define GrB_Matrix_build_FP32_(...)                 GrB_Matrix_build_FP32 (__VA_ARGS__)
#define GrB_Matrix_build_FP64_(...)                 GrB_Matrix_build_FP64 (__VA_ARGS__)
#define GxB_Matrix_build_FC32_(...)                 GxB_Matrix_build_FC32 (__VA_ARGS__)
#define GxB_Matrix_build_FC64_(...)                 GxB_Matrix_build_FC64 (__VA_ARGS__)
#define GrB_Matrix_build_UDT_(...)                  GrB_Matrix_build_UDT (__VA_ARGS__)

// GrB_Matrix_import:
#define GrB_Matrix_import_BOOL_(...)                GrB_Matrix_import_BOOL (__VA_ARGS__)
#define GrB_Matrix_import_INT8_(...)                GrB_Matrix_import_INT8 (__VA_ARGS__)
#define GrB_Matrix_import_INT16_(...)               GrB_Matrix_import_INT16 (__VA_ARGS__)
#define GrB_Matrix_import_INT32_(...)               GrB_Matrix_import_INT32 (__VA_ARGS__)
#define GrB_Matrix_import_INT64_(...)               GrB_Matrix_import_INT64 (__VA_ARGS__)
#define GrB_Matrix_import_UINT8_(...)               GrB_Matrix_import_UINT8 (__VA_ARGS__)
#define GrB_Matrix_import_UINT16_(...)              GrB_Matrix_import_UINT16 (__VA_ARGS__)
#define GrB_Matrix_import_UINT32_(...)              GrB_Matrix_import_UINT32 (__VA_ARGS__)
#define GrB_Matrix_import_UINT64_(...)              GrB_Matrix_import_UINT64 (__VA_ARGS__)
#define GrB_Matrix_import_FP32_(...)                GrB_Matrix_import_FP32 (__VA_ARGS__)
#define GrB_Matrix_import_FP64_(...)                GrB_Matrix_import_FP64 (__VA_ARGS__)
#define GxB_Matrix_import_FC32_(...)                GxB_Matrix_import_FC32 (__VA_ARGS__)
#define GxB_Matrix_import_FC64_(...)                GxB_Matrix_import_FC64 (__VA_ARGS__)
#define GrB_Matrix_import_UDT_(...)                 GrB_Matrix_import_UDT (__VA_ARGS__)

// GrB_Matrix_export:
#define GrB_Matrix_export_BOOL_(...)                 GrB_Matrix_export_BOOL (__VA_ARGS__)
#define GrB_Matrix_export_INT8_(...)                 GrB_Matrix_export_INT8 (__VA_ARGS__)
#define GrB_Matrix_export_INT16_(...)                GrB_Matrix_export_INT16 (__VA_ARGS__)
#define GrB_Matrix_export_INT32_(...)                GrB_Matrix_export_INT32 (__VA_ARGS__)
#define GrB_Matrix_export_INT64_(...)                GrB_Matrix_export_INT64 (__VA_ARGS__)
#define GrB_Matrix_export_UINT8_(...)                GrB_Matrix_export_UINT8 (__VA_ARGS__)
#define GrB_Matrix_export_UINT16_(...)               GrB_Matrix_export_UINT16 (__VA_ARGS__)
#define GrB_Matrix_export_UINT32_(...)               GrB_Matrix_export_UINT32 (__VA_ARGS__)
#define GrB_Matrix_export_UINT64_(...)               GrB_Matrix_export_UINT64 (__VA_ARGS__)
#define GrB_Matrix_export_FP32_(...)                 GrB_Matrix_export_FP32 (__VA_ARGS__)
#define GrB_Matrix_export_FP64_(...)                 GrB_Matrix_export_FP64 (__VA_ARGS__)
#define GxB_Matrix_export_FC32_(...)                 GxB_Matrix_export_FC32 (__VA_ARGS__)
#define GxB_Matrix_export_FC64_(...)                 GxB_Matrix_export_FC64 (__VA_ARGS__)
#define GrB_Matrix_export_UDT_(...)                  GrB_Matrix_export_UDT (__VA_ARGS__)

// GrB_Matrix_setElement:
#define GrB_Matrix_setElement_BOOL_(...)            GrB_Matrix_setElement_BOOL (__VA_ARGS__)
#define GrB_Matrix_setElement_INT8_(...)            GrB_Matrix_setElement_INT8 (__VA_ARGS__)
#define GrB_Matrix_setElement_INT16_(...)           GrB_Matrix_setElement_INT16 (__VA_ARGS__)
#define GrB_Matrix_setElement_INT32_(...)           GrB_Matrix_setElement_INT32 (__VA_ARGS__)
#define GrB_Matrix_setElement_INT64_(...)           GrB_Matrix_setElement_INT64 (__VA_ARGS__)
#define GrB_Matrix_setElement_UINT8_(...)           GrB_Matrix_setElement_UINT8 (__VA_ARGS__)
#define GrB_Matrix_setElement_UINT16_(...)          GrB_Matrix_setElement_UINT16 (__VA_ARGS__)
#define GrB_Matrix_setElement_UINT32_(...)          GrB_Matrix_setElement_UINT32 (__VA_ARGS__)
#define GrB_Matrix_setElement_UINT64_(...)          GrB_Matrix_setElement_UINT64 (__VA_ARGS__)
#define GrB_Matrix_setElement_FP32_(...)            GrB_Matrix_setElement_FP32 (__VA_ARGS__)
#define GrB_Matrix_setElement_FP64_(...)            GrB_Matrix_setElement_FP64 (__VA_ARGS__)
#define GxB_Matrix_setElement_FC32_(...)            GxB_Matrix_setElement_FC32 (__VA_ARGS__)
#define GxB_Matrix_setElement_FC64_(...)            GxB_Matrix_setElement_FC64 (__VA_ARGS__)
#define GrB_Matrix_setElement_UDT_(...)             GrB_Matrix_setElement_UDT (__VA_ARGS__)
#define GrB_Matrix_setElement_Scalar_(...)          GrB_Matrix_setElement_Scalar (__VA_ARGS__)

// GrB_Matrix_extractElement:
#define GrB_Matrix_extractElement_BOOL_(...)        GrB_Matrix_extractElement_BOOL (__VA_ARGS__)
#define GrB_Matrix_extractElement_INT8_(...)        GrB_Matrix_extractElement_INT8 (__VA_ARGS__)
#define GrB_Matrix_extractElement_INT16_(...)       GrB_Matrix_extractElement_INT16 (__VA_ARGS__)
#define GrB_Matrix_extractElement_INT32_(...)       GrB_Matrix_extractElement_INT32 (__VA_ARGS__)
#define GrB_Matrix_extractElement_INT64_(...)       GrB_Matrix_extractElement_INT64 (__VA_ARGS__)
#define GrB_Matrix_extractElement_UINT8_(...)       GrB_Matrix_extractElement_UINT8 (__VA_ARGS__)
#define GrB_Matrix_extractElement_UINT16_(...)      GrB_Matrix_extractElement_UINT16 (__VA_ARGS__)
#define GrB_Matrix_extractElement_UINT32_(...)      GrB_Matrix_extractElement_UINT32 (__VA_ARGS__)
#define GrB_Matrix_extractElement_UINT64_(...)      GrB_Matrix_extractElement_UINT64 (__VA_ARGS__)
#define GrB_Matrix_extractElement_FP32_(...)        GrB_Matrix_extractElement_FP32 (__VA_ARGS__)
#define GrB_Matrix_extractElement_FP64_(...)        GrB_Matrix_extractElement_FP64 (__VA_ARGS__)
#define GxB_Matrix_extractElement_FC32_(...)        GxB_Matrix_extractElement_FC32 (__VA_ARGS__)
#define GxB_Matrix_extractElement_FC64_(...)        GxB_Matrix_extractElement_FC64 (__VA_ARGS__)
#define GrB_Matrix_extractElement_UDT_(...)         GrB_Matrix_extractElement_UDT (__VA_ARGS__)
#define GrB_Matrix_extractElement_Scalar_(...)      GrB_Matrix_extractElement_Scalar (__VA_ARGS__)

// GrB_Matrix_extractTuples:
#define GrB_Matrix_extractTuples_BOOL_(...)         GrB_Matrix_extractTuples_BOOL (__VA_ARGS__)
#define GrB_Matrix_extractTuples_INT8_(...)         GrB_Matrix_extractTuples_INT8 (__VA_ARGS__)
#define GrB_Matrix_extractTuples_INT16_(...)        GrB_Matrix_extractTuples_INT16 (__VA_ARGS__)
#define GrB_Matrix_extractTuples_INT32_(...)        GrB_Matrix_extractTuples_INT32 (__VA_ARGS__)
#define GrB_Matrix_extractTuples_INT64_(...)        GrB_Matrix_extractTuples_INT64 (__VA_ARGS__)
#define GrB_Matrix_extractTuples_UINT8_(...)        GrB_Matrix_extractTuples_UINT8 (__VA_ARGS__)
#define GrB_Matrix_extractTuples_UINT16_(...)       GrB_Matrix_extractTuples_UINT16 (__VA_ARGS__)
#define GrB_Matrix_extractTuples_UINT32_(...)       GrB_Matrix_extractTuples_UINT32 (__VA_ARGS__)
#define GrB_Matrix_extractTuples_UINT64_(...)       GrB_Matrix_extractTuples_UINT64 (__VA_ARGS__)
#define GrB_Matrix_extractTuples_FP32_(...)         GrB_Matrix_extractTuples_FP32 (__VA_ARGS__)
#define GrB_Matrix_extractTuples_FP64_(...)         GrB_Matrix_extractTuples_FP64 (__VA_ARGS__)
#define GxB_Matrix_extractTuples_FC32_(...)         GxB_Matrix_extractTuples_FC32 (__VA_ARGS__)
#define GxB_Matrix_extractTuples_FC64_(...)         GxB_Matrix_extractTuples_FC64 (__VA_ARGS__)
#define GrB_Matrix_extractTuples_UDT_(...)          GrB_Matrix_extractTuples_UDT (__VA_ARGS__)

// GxB_Desc_set:
#define GxB_Global_Option_set_(...)                 GxB_Global_Option_set (__VA_ARGS__)
#define GxB_Matrix_Option_set_(...)                 GxB_Matrix_Option_set (__VA_ARGS__)
#define GxB_Vector_Option_set_(...)                 GxB_Vector_Option_set (__VA_ARGS__)
#define GrB_Descriptor_set_(...)                    GrB_Descriptor_set (__VA_ARGS__)

// GxB_Desc_get:
#define GxB_Global_Option_get_(...)                 GxB_Global_Option_get (__VA_ARGS__)
#define GxB_Matrix_Option_get_(...)                 GxB_Matrix_Option_get (__VA_ARGS__)
#define GxB_Vector_Option_get_(...)                 GxB_Vector_Option_get (__VA_ARGS__)
#define GxB_Descriptor_get_(...)                    GxB_Descriptor_get (__VA_ARGS__)

// GrB_wait:
#define GrB_Type_wait_(...)                         GrB_Type_wait (__VA_ARGS__)
#define GrB_UnaryOp_wait_(...)                      GrB_UnaryOp_wait (__VA_ARGS__)
#define GrB_BinaryOp_wait_(...)                     GrB_BinaryOp_wait (__VA_ARGS__)
#define GrB_IndexUnaryOp_wait_(...)                 GrB_IndexUnaryOp_wait (__VA_ARGS__)
#define GrB_Monoid_wait_(...)                       GrB_Monoid_wait (__VA_ARGS__)
#define GrB_Semiring_wait_(...)                     GrB_Semiring_wait (__VA_ARGS__)
#define GrB_Descriptor_wait_(...)                   GrB_Descriptor_wait (__VA_ARGS__)
#define GrB_Scalar_wait_(...)                       GrB_Scalar_wait (__VA_ARGS__)
#define GrB_Vector_wait_(...)                       GrB_Vector_wait (__VA_ARGS__)
#define GrB_Matrix_wait_(...)                       GrB_Matrix_wait (__VA_ARGS__)

// GrB_eWiseMult:
#define GrB_Vector_eWiseMult_Semiring_(...)         GrB_Vector_eWiseMult_Semiring (__VA_ARGS__)
#define GrB_Vector_eWiseMult_Monoid_(...)           GrB_Vector_eWiseMult_Monoid (__VA_ARGS__)
#define GrB_Vector_eWiseMult_BinaryOp_(...)         GrB_Vector_eWiseMult_BinaryOp (__VA_ARGS__)
#define GrB_Matrix_eWiseMult_Semiring_(...)         GrB_Matrix_eWiseMult_Semiring (__VA_ARGS__)
#define GrB_Matrix_eWiseMult_Monoid_(...)           GrB_Matrix_eWiseMult_Monoid (__VA_ARGS__)
#define GrB_Matrix_eWiseMult_BinaryOp_(...)         GrB_Matrix_eWiseMult_BinaryOp (__VA_ARGS__)

// GrB_eWiseAdd:
#define GrB_Vector_eWiseAdd_Semiring_(...)          GrB_Vector_eWiseAdd_Semiring (__VA_ARGS__)
#define GrB_Vector_eWiseAdd_Monoid_(...)            GrB_Vector_eWiseAdd_Monoid (__VA_ARGS__)
#define GrB_Vector_eWiseAdd_BinaryOp_(...)          GrB_Vector_eWiseAdd_BinaryOp (__VA_ARGS__)
#define GrB_Matrix_eWiseAdd_Semiring_(...)          GrB_Matrix_eWiseAdd_Semiring (__VA_ARGS__)
#define GrB_Matrix_eWiseAdd_Monoid_(...)            GrB_Matrix_eWiseAdd_Monoid (__VA_ARGS__)
#define GrB_Matrix_eWiseAdd_BinaryOp_(...)          GrB_Matrix_eWiseAdd_BinaryOp (__VA_ARGS__)

// GrB_extract:
#define GrB_Vector_extract_(...)                    GrB_Vector_extract (__VA_ARGS__)
#define GrB_Matrix_extract_(...)                    GrB_Matrix_extract (__VA_ARGS__)
#define GrB_Col_extract_(...)                       GrB_Col_extract (__VA_ARGS__)

// GxB_subassign:
#define GxB_Vector_subassign_(...)                  GxB_Vector_subassign (__VA_ARGS__)
#define GxB_Matrix_subassign_(...)                  GxB_Matrix_subassign (__VA_ARGS__)
#define GxB_Col_subassign_(...)                     GxB_Col_subassign (__VA_ARGS__)
#define GxB_Row_subassign_(...)                     GxB_Row_subassign (__VA_ARGS__)
#define GxB_Vector_subassign_BOOL_(...)             GxB_Vector_subassign_BOOL (__VA_ARGS__)
#define GxB_Vector_subassign_INT8_(...)             GxB_Vector_subassign_INT8 (__VA_ARGS__)
#define GxB_Vector_subassign_INT16_(...)            GxB_Vector_subassign_INT16 (__VA_ARGS__)
#define GxB_Vector_subassign_INT32_(...)            GxB_Vector_subassign_INT32 (__VA_ARGS__)
#define GxB_Vector_subassign_INT64_(...)            GxB_Vector_subassign_INT64 (__VA_ARGS__)
#define GxB_Vector_subassign_UINT8_(...)            GxB_Vector_subassign_UINT8 (__VA_ARGS__)
#define GxB_Vector_subassign_UINT16_(...)           GxB_Vector_subassign_UINT16 (__VA_ARGS__)
#define GxB_Vector_subassign_UINT32_(...)           GxB_Vector_subassign_UINT32 (__VA_ARGS__)
#define GxB_Vector_subassign_UINT64_(...)           GxB_Vector_subassign_UINT64 (__VA_ARGS__)
#define GxB_Vector_subassign_FP32_(...)             GxB_Vector_subassign_FP32 (__VA_ARGS__)
#define GxB_Vector_subassign_FP64_(...)             GxB_Vector_subassign_FP64 (__VA_ARGS__)
#define GxB_Vector_subassign_FC32_(...)             GxB_Vector_subassign_FC32 (__VA_ARGS__)
#define GxB_Vector_subassign_FC64_(...)             GxB_Vector_subassign_FC64 (__VA_ARGS__)
#define GxB_Vector_subassign_UDT_(...)              GxB_Vector_subassign_UDT (__VA_ARGS__)
#define GxB_Matrix_subassign_BOOL_(...)             GxB_Matrix_subassign_BOOL (__VA_ARGS__)
#define GxB_Matrix_subassign_INT8_(...)             GxB_Matrix_subassign_INT8 (__VA_ARGS__)
#define GxB_Matrix_subassign_INT16_(...)            GxB_Matrix_subassign_INT16 (__VA_ARGS__)
#define GxB_Matrix_subassign_INT32_(...)            GxB_Matrix_subassign_INT32 (__VA_ARGS__)
#define GxB_Matrix_subassign_INT64_(...)            GxB_Matrix_subassign_INT64 (__VA_ARGS__)
#define GxB_Matrix_subassign_UINT8_(...)            GxB_Matrix_subassign_UINT8 (__VA_ARGS__)
#define GxB_Matrix_subassign_UINT16_(...)           GxB_Matrix_subassign_UINT16 (__VA_ARGS__)
#define GxB_Matrix_subassign_UINT32_(...)           GxB_Matrix_subassign_UINT32 (__VA_ARGS__)
#define GxB_Matrix_subassign_UINT64_(...)           GxB_Matrix_subassign_UINT64 (__VA_ARGS__)
#define GxB_Matrix_subassign_FP32_(...)             GxB_Matrix_subassign_FP32 (__VA_ARGS__)
#define GxB_Matrix_subassign_FP64_(...)             GxB_Matrix_subassign_FP64 (__VA_ARGS__)
#define GxB_Matrix_subassign_FC32_(...)             GxB_Matrix_subassign_FC32 (__VA_ARGS__)
#define GxB_Matrix_subassign_FC64_(...)             GxB_Matrix_subassign_FC64 (__VA_ARGS__)
#define GxB_Matrix_subassign_UDT_(...)              GxB_Matrix_subassign_UDT (__VA_ARGS__)

// GrB_assign:
#define GrB_Vector_assign_(...)                     GrB_Vector_assign (__VA_ARGS__)
#define GrB_Matrix_assign_(...)                     GrB_Matrix_assign (__VA_ARGS__)
#define GrB_Col_assign_(...)                        GrB_Col_assign (__VA_ARGS__)
#define GrB_Row_assign_(...)                        GrB_Row_assign (__VA_ARGS__)
#define GrB_Vector_assign_BOOL_(...)                GrB_Vector_assign_BOOL (__VA_ARGS__)
#define GrB_Vector_assign_INT8_(...)                GrB_Vector_assign_INT8 (__VA_ARGS__)
#define GrB_Vector_assign_INT16_(...)               GrB_Vector_assign_INT16 (__VA_ARGS__)
#define GrB_Vector_assign_INT32_(...)               GrB_Vector_assign_INT32 (__VA_ARGS__)
#define GrB_Vector_assign_INT64_(...)               GrB_Vector_assign_INT64 (__VA_ARGS__)
#define GrB_Vector_assign_UINT8_(...)               GrB_Vector_assign_UINT8 (__VA_ARGS__)
#define GrB_Vector_assign_UINT16_(...)              GrB_Vector_assign_UINT16 (__VA_ARGS__)
#define GrB_Vector_assign_UINT32_(...)              GrB_Vector_assign_UINT32 (__VA_ARGS__)
#define GrB_Vector_assign_UINT64_(...)              GrB_Vector_assign_UINT64 (__VA_ARGS__)
#define GrB_Vector_assign_FP32_(...)                GrB_Vector_assign_FP32 (__VA_ARGS__)
#define GrB_Vector_assign_FP64_(...)                GrB_Vector_assign_FP64 (__VA_ARGS__)
#define GxB_Vector_assign_FC32_(...)                GxB_Vector_assign_FC32 (__VA_ARGS__)
#define GxB_Vector_assign_FC64_(...)                GxB_Vector_assign_FC64 (__VA_ARGS__)
#define GrB_Vector_assign_UDT_(...)                 GrB_Vector_assign_UDT (__VA_ARGS__)
#define GrB_Matrix_assign_BOOL_(...)                GrB_Matrix_assign_BOOL (__VA_ARGS__)
#define GrB_Matrix_assign_INT8_(...)                GrB_Matrix_assign_INT8 (__VA_ARGS__)
#define GrB_Matrix_assign_INT16_(...)               GrB_Matrix_assign_INT16 (__VA_ARGS__)
#define GrB_Matrix_assign_INT32_(...)               GrB_Matrix_assign_INT32 (__VA_ARGS__)
#define GrB_Matrix_assign_INT64_(...)               GrB_Matrix_assign_INT64 (__VA_ARGS__)
#define GrB_Matrix_assign_UINT8_(...)               GrB_Matrix_assign_UINT8 (__VA_ARGS__)
#define GrB_Matrix_assign_UINT16_(...)              GrB_Matrix_assign_UINT16 (__VA_ARGS__)
#define GrB_Matrix_assign_UINT32_(...)              GrB_Matrix_assign_UINT32 (__VA_ARGS__)
#define GrB_Matrix_assign_UINT64_(...)              GrB_Matrix_assign_UINT64 (__VA_ARGS__)
#define GrB_Matrix_assign_FP32_(...)                GrB_Matrix_assign_FP32 (__VA_ARGS__)
#define GrB_Matrix_assign_FP64_(...)                GrB_Matrix_assign_FP64 (__VA_ARGS__)
#define GxB_Matrix_assign_FC32_(...)                GxB_Matrix_assign_FC32 (__VA_ARGS__)
#define GxB_Matrix_assign_FC64_(...)                GxB_Matrix_assign_FC64 (__VA_ARGS__)
#define GrB_Matrix_assign_UDT_(...)                 GrB_Matrix_assign_UDT (__VA_ARGS__)

// GrB_apply:
#define GrB_Vector_apply_(...)                      GrB_Vector_apply (__VA_ARGS__)
#define GrB_Matrix_apply_(...)                      GrB_Matrix_apply (__VA_ARGS__)
#define GxB_Vector_apply_BinaryOp1st_(...)          GxB_Vector_apply_BinaryOp1st (__VA_ARGS__)
#define GrB_Vector_apply_BinaryOp1st_BOOL_(...)     GrB_Vector_apply_BinaryOp1st_BOOL (__VA_ARGS__)
#define GrB_Vector_apply_BinaryOp1st_INT8_(...)     GrB_Vector_apply_BinaryOp1st_INT8 (__VA_ARGS__)
#define GrB_Vector_apply_BinaryOp1st_INT16_(...)    GrB_Vector_apply_BinaryOp1st_INT16 (__VA_ARGS__)
#define GrB_Vector_apply_BinaryOp1st_INT32_(...)    GrB_Vector_apply_BinaryOp1st_INT32 (__VA_ARGS__)
#define GrB_Vector_apply_BinaryOp1st_INT64_(...)    GrB_Vector_apply_BinaryOp1st_INT64 (__VA_ARGS__)
#define GrB_Vector_apply_BinaryOp1st_UINT8_(...)    GrB_Vector_apply_BinaryOp1st_UINT8 (__VA_ARGS__)
#define GrB_Vector_apply_BinaryOp1st_UINT16_(...)   GrB_Vector_apply_BinaryOp1st_UINT16 (__VA_ARGS__)
#define GrB_Vector_apply_BinaryOp1st_UINT32_(...)   GrB_Vector_apply_BinaryOp1st_UINT32 (__VA_ARGS__)
#define GrB_Vector_apply_BinaryOp1st_UINT64_(...)   GrB_Vector_apply_BinaryOp1st_UINT64 (__VA_ARGS__)
#define GrB_Vector_apply_BinaryOp1st_FP32_(...)     GrB_Vector_apply_BinaryOp1st_FP32 (__VA_ARGS__)
#define GrB_Vector_apply_BinaryOp1st_FP64_(...)     GrB_Vector_apply_BinaryOp1st_FP64 (__VA_ARGS__)
#define GxB_Vector_apply_BinaryOp1st_FC32_(...)     GxB_Vector_apply_BinaryOp1st_FC32 (__VA_ARGS__)
#define GxB_Vector_apply_BinaryOp1st_FC64_(...)     GxB_Vector_apply_BinaryOp1st_FC64 (__VA_ARGS__)
#define GrB_Vector_apply_BinaryOp1st_UDT_(...)      GrB_Vector_apply_BinaryOp1st_UDT (__VA_ARGS__)
#define GrB_Vector_apply_BinaryOp1st_Scalar_(...)   GrB_Vector_apply_BinaryOp1st_Scalar (__VA_ARGS__)

#define GxB_Vector_apply_BinaryOp2nd_(...)          GxB_Vector_apply_BinaryOp2nd (__VA_ARGS__)
#define GrB_Vector_apply_BinaryOp2nd_BOOL_(...)     GrB_Vector_apply_BinaryOp2nd_BOOL (__VA_ARGS__)
#define GrB_Vector_apply_BinaryOp2nd_INT8_(...)     GrB_Vector_apply_BinaryOp2nd_INT8 (__VA_ARGS__)
#define GrB_Vector_apply_BinaryOp2nd_INT16_(...)    GrB_Vector_apply_BinaryOp2nd_INT16 (__VA_ARGS__)
#define GrB_Vector_apply_BinaryOp2nd_INT32_(...)    GrB_Vector_apply_BinaryOp2nd_INT32 (__VA_ARGS__)
#define GrB_Vector_apply_BinaryOp2nd_INT64_(...)    GrB_Vector_apply_BinaryOp2nd_INT64 (__VA_ARGS__)
#define GrB_Vector_apply_BinaryOp2nd_UINT8_(...)    GrB_Vector_apply_BinaryOp2nd_UINT8 (__VA_ARGS__)
#define GrB_Vector_apply_BinaryOp2nd_UINT16_(...)   GrB_Vector_apply_BinaryOp2nd_UINT16 (__VA_ARGS__)
#define GrB_Vector_apply_BinaryOp2nd_UINT32_(...)   GrB_Vector_apply_BinaryOp2nd_UINT32 (__VA_ARGS__)
#define GrB_Vector_apply_BinaryOp2nd_UINT64_(...)   GrB_Vector_apply_BinaryOp2nd_UINT64 (__VA_ARGS__)
#define GrB_Vector_apply_BinaryOp2nd_FP32_(...)     GrB_Vector_apply_BinaryOp2nd_FP32 (__VA_ARGS__)
#define GrB_Vector_apply_BinaryOp2nd_FP64_(...)     GrB_Vector_apply_BinaryOp2nd_FP64 (__VA_ARGS__)
#define GxB_Vector_apply_BinaryOp2nd_FC32_(...)     GxB_Vector_apply_BinaryOp2nd_FC32 (__VA_ARGS__)
#define GxB_Vector_apply_BinaryOp2nd_FC64_(...)     GxB_Vector_apply_BinaryOp2nd_FC64 (__VA_ARGS__)
#define GrB_Vector_apply_BinaryOp2nd_UDT_(...)      GrB_Vector_apply_BinaryOp2nd_UDT (__VA_ARGS__)
#define GrB_Vector_apply_BinaryOp2nd_Scalar_(...)   GrB_Vector_apply_BinaryOp2nd_Scalar (__VA_ARGS__)

#define GxB_Vector_apply_IndexOp_(...)          GxB_Vector_apply_IndexOp (__VA_ARGS__)
#define GrB_Vector_apply_IndexOp_BOOL_(...)     GrB_Vector_apply_IndexOp_BOOL (__VA_ARGS__)
#define GrB_Vector_apply_IndexOp_INT8_(...)     GrB_Vector_apply_IndexOp_INT8 (__VA_ARGS__)
#define GrB_Vector_apply_IndexOp_INT16_(...)    GrB_Vector_apply_IndexOp_INT16 (__VA_ARGS__)
#define GrB_Vector_apply_IndexOp_INT32_(...)    GrB_Vector_apply_IndexOp_INT32 (__VA_ARGS__)
#define GrB_Vector_apply_IndexOp_INT64_(...)    GrB_Vector_apply_IndexOp_INT64 (__VA_ARGS__)
#define GrB_Vector_apply_IndexOp_UINT8_(...)    GrB_Vector_apply_IndexOp_UINT8 (__VA_ARGS__)
#define GrB_Vector_apply_IndexOp_UINT16_(...)   GrB_Vector_apply_IndexOp_UINT16 (__VA_ARGS__)
#define GrB_Vector_apply_IndexOp_UINT32_(...)   GrB_Vector_apply_IndexOp_UINT32 (__VA_ARGS__)
#define GrB_Vector_apply_IndexOp_UINT64_(...)   GrB_Vector_apply_IndexOp_UINT64 (__VA_ARGS__)
#define GrB_Vector_apply_IndexOp_FP32_(...)     GrB_Vector_apply_IndexOp_FP32 (__VA_ARGS__)
#define GrB_Vector_apply_IndexOp_FP64_(...)     GrB_Vector_apply_IndexOp_FP64 (__VA_ARGS__)
#define GxB_Vector_apply_IndexOp_FC32_(...)     GxB_Vector_apply_IndexOp_FC32 (__VA_ARGS__)
#define GxB_Vector_apply_IndexOp_FC64_(...)     GxB_Vector_apply_IndexOp_FC64 (__VA_ARGS__)
#define GrB_Vector_apply_IndexOp_UDT_(...)      GrB_Vector_apply_IndexOp_UDT (__VA_ARGS__)
#define GrB_Vector_apply_IndexOp_Scalar_(...)   GrB_Vector_apply_IndexOp_Scalar (__VA_ARGS__)

#define GrB_Vector_select_BOOL_(...)     GrB_Vector_select_BOOL (__VA_ARGS__)
#define GrB_Vector_select_INT8_(...)     GrB_Vector_select_INT8 (__VA_ARGS__)
#define GrB_Vector_select_INT16_(...)    GrB_Vector_select_INT16 (__VA_ARGS__)
#define GrB_Vector_select_INT32_(...)    GrB_Vector_select_INT32 (__VA_ARGS__)
#define GrB_Vector_select_INT64_(...)    GrB_Vector_select_INT64 (__VA_ARGS__)
#define GrB_Vector_select_UINT8_(...)    GrB_Vector_select_UINT8 (__VA_ARGS__)
#define GrB_Vector_select_UINT16_(...)   GrB_Vector_select_UINT16 (__VA_ARGS__)
#define GrB_Vector_select_UINT32_(...)   GrB_Vector_select_UINT32 (__VA_ARGS__)
#define GrB_Vector_select_UINT64_(...)   GrB_Vector_select_UINT64 (__VA_ARGS__)
#define GrB_Vector_select_FP32_(...)     GrB_Vector_select_FP32 (__VA_ARGS__)
#define GrB_Vector_select_FP64_(...)     GrB_Vector_select_FP64 (__VA_ARGS__)
#define GxB_Vector_select_FC32_(...)     GxB_Vector_select_FC32 (__VA_ARGS__)
#define GxB_Vector_select_FC64_(...)     GxB_Vector_select_FC64 (__VA_ARGS__)
#define GrB_Vector_select_UDT_(...)      GrB_Vector_select_UDT (__VA_ARGS__)
#define GrB_Vector_select_Scalar_(...)   GrB_Vector_select_Scalar (__VA_ARGS__)

#define GxB_Matrix_apply_BinaryOp1st_(...)          GxB_Matrix_apply_BinaryOp1st (__VA_ARGS__)
#define GrB_Matrix_apply_BinaryOp1st_BOOL_(...)     GrB_Matrix_apply_BinaryOp1st_BOOL (__VA_ARGS__)
#define GrB_Matrix_apply_BinaryOp1st_INT8_(...)     GrB_Matrix_apply_BinaryOp1st_INT8 (__VA_ARGS__)
#define GrB_Matrix_apply_BinaryOp1st_INT16_(...)    GrB_Matrix_apply_BinaryOp1st_INT16 (__VA_ARGS__)
#define GrB_Matrix_apply_BinaryOp1st_INT32_(...)    GrB_Matrix_apply_BinaryOp1st_INT32 (__VA_ARGS__)
#define GrB_Matrix_apply_BinaryOp1st_INT64_(...)    GrB_Matrix_apply_BinaryOp1st_INT64 (__VA_ARGS__)
#define GrB_Matrix_apply_BinaryOp1st_UINT8_(...)    GrB_Matrix_apply_BinaryOp1st_UINT8 (__VA_ARGS__)
#define GrB_Matrix_apply_BinaryOp1st_UINT16_(...)   GrB_Matrix_apply_BinaryOp1st_UINT16 (__VA_ARGS__)
#define GrB_Matrix_apply_BinaryOp1st_UINT32_(...)   GrB_Matrix_apply_BinaryOp1st_UINT32 (__VA_ARGS__)
#define GrB_Matrix_apply_BinaryOp1st_UINT64_(...)   GrB_Matrix_apply_BinaryOp1st_UINT64 (__VA_ARGS__)
#define GrB_Matrix_apply_BinaryOp1st_FP32_(...)     GrB_Matrix_apply_BinaryOp1st_FP32 (__VA_ARGS__)
#define GrB_Matrix_apply_BinaryOp1st_FP64_(...)     GrB_Matrix_apply_BinaryOp1st_FP64 (__VA_ARGS__)
#define GxB_Matrix_apply_BinaryOp1st_FC32_(...)     GxB_Matrix_apply_BinaryOp1st_FC32 (__VA_ARGS__)
#define GxB_Matrix_apply_BinaryOp1st_FC64_(...)     GxB_Matrix_apply_BinaryOp1st_FC64 (__VA_ARGS__)
#define GrB_Matrix_apply_BinaryOp1st_UDT_(...)      GrB_Matrix_apply_BinaryOp1st_UDT (__VA_ARGS__)
#define GrB_Matrix_apply_BinaryOp1st_Scalar_(...)   GrB_Matrix_apply_BinaryOp1st_Scalar (__VA_ARGS__)

#define GxB_Matrix_apply_BinaryOp2nd_(...)          GxB_Matrix_apply_BinaryOp2nd (__VA_ARGS__)
#define GrB_Matrix_apply_BinaryOp2nd_BOOL_(...)     GrB_Matrix_apply_BinaryOp2nd_BOOL (__VA_ARGS__)
#define GrB_Matrix_apply_BinaryOp2nd_INT8_(...)     GrB_Matrix_apply_BinaryOp2nd_INT8 (__VA_ARGS__)
#define GrB_Matrix_apply_BinaryOp2nd_INT16_(...)    GrB_Matrix_apply_BinaryOp2nd_INT16 (__VA_ARGS__)
#define GrB_Matrix_apply_BinaryOp2nd_INT32_(...)    GrB_Matrix_apply_BinaryOp2nd_INT32 (__VA_ARGS__)
#define GrB_Matrix_apply_BinaryOp2nd_INT64_(...)    GrB_Matrix_apply_BinaryOp2nd_INT64 (__VA_ARGS__)
#define GrB_Matrix_apply_BinaryOp2nd_UINT8_(...)    GrB_Matrix_apply_BinaryOp2nd_UINT8 (__VA_ARGS__)
#define GrB_Matrix_apply_BinaryOp2nd_UINT16_(...)   GrB_Matrix_apply_BinaryOp2nd_UINT16 (__VA_ARGS__)
#define GrB_Matrix_apply_BinaryOp2nd_UINT32_(...)   GrB_Matrix_apply_BinaryOp2nd_UINT32 (__VA_ARGS__)
#define GrB_Matrix_apply_BinaryOp2nd_UINT64_(...)   GrB_Matrix_apply_BinaryOp2nd_UINT64 (__VA_ARGS__)
#define GrB_Matrix_apply_BinaryOp2nd_FP32_(...)     GrB_Matrix_apply_BinaryOp2nd_FP32 (__VA_ARGS__)
#define GrB_Matrix_apply_BinaryOp2nd_FP64_(...)     GrB_Matrix_apply_BinaryOp2nd_FP64 (__VA_ARGS__)
#define GxB_Matrix_apply_BinaryOp2nd_FC32_(...)     GxB_Matrix_apply_BinaryOp2nd_FC32 (__VA_ARGS__)
#define GxB_Matrix_apply_BinaryOp2nd_FC64_(...)     GxB_Matrix_apply_BinaryOp2nd_FC64 (__VA_ARGS__)
#define GrB_Matrix_apply_BinaryOp2nd_UDT_(...)      GrB_Matrix_apply_BinaryOp2nd_UDT (__VA_ARGS__)
#define GrB_Matrix_apply_BinaryOp2nd_Scalar_(...)   GrB_Matrix_apply_BinaryOp2nd_Scalar (__VA_ARGS__)

#define GxB_Matrix_apply_IndexOp_(...)          GxB_Matrix_apply_IndexOp (__VA_ARGS__)
#define GrB_Matrix_apply_IndexOp_BOOL_(...)     GrB_Matrix_apply_IndexOp_BOOL (__VA_ARGS__)
#define GrB_Matrix_apply_IndexOp_INT8_(...)     GrB_Matrix_apply_IndexOp_INT8 (__VA_ARGS__)
#define GrB_Matrix_apply_IndexOp_INT16_(...)    GrB_Matrix_apply_IndexOp_INT16 (__VA_ARGS__)
#define GrB_Matrix_apply_IndexOp_INT32_(...)    GrB_Matrix_apply_IndexOp_INT32 (__VA_ARGS__)
#define GrB_Matrix_apply_IndexOp_INT64_(...)    GrB_Matrix_apply_IndexOp_INT64 (__VA_ARGS__)
#define GrB_Matrix_apply_IndexOp_UINT8_(...)    GrB_Matrix_apply_IndexOp_UINT8 (__VA_ARGS__)
#define GrB_Matrix_apply_IndexOp_UINT16_(...)   GrB_Matrix_apply_IndexOp_UINT16 (__VA_ARGS__)
#define GrB_Matrix_apply_IndexOp_UINT32_(...)   GrB_Matrix_apply_IndexOp_UINT32 (__VA_ARGS__)
#define GrB_Matrix_apply_IndexOp_UINT64_(...)   GrB_Matrix_apply_IndexOp_UINT64 (__VA_ARGS__)
#define GrB_Matrix_apply_IndexOp_FP32_(...)     GrB_Matrix_apply_IndexOp_FP32 (__VA_ARGS__)
#define GrB_Matrix_apply_IndexOp_FP64_(...)     GrB_Matrix_apply_IndexOp_FP64 (__VA_ARGS__)
#define GxB_Matrix_apply_IndexOp_FC32_(...)     GxB_Matrix_apply_IndexOp_FC32 (__VA_ARGS__)
#define GxB_Matrix_apply_IndexOp_FC64_(...)     GxB_Matrix_apply_IndexOp_FC64 (__VA_ARGS__)
#define GrB_Matrix_apply_IndexOp_UDT_(...)      GrB_Matrix_apply_IndexOp_UDT (__VA_ARGS__)
#define GrB_Matrix_apply_IndexOp_Scalar_(...)   GrB_Matrix_apply_IndexOp_Scalar (__VA_ARGS__)

#define GrB_Matrix_select_BOOL_(...)     GrB_Matrix_select_BOOL (__VA_ARGS__)
#define GrB_Matrix_select_INT8_(...)     GrB_Matrix_select_INT8 (__VA_ARGS__)
#define GrB_Matrix_select_INT16_(...)    GrB_Matrix_select_INT16 (__VA_ARGS__)
#define GrB_Matrix_select_INT32_(...)    GrB_Matrix_select_INT32 (__VA_ARGS__)
#define GrB_Matrix_select_INT64_(...)    GrB_Matrix_select_INT64 (__VA_ARGS__)
#define GrB_Matrix_select_UINT8_(...)    GrB_Matrix_select_UINT8 (__VA_ARGS__)
#define GrB_Matrix_select_UINT16_(...)   GrB_Matrix_select_UINT16 (__VA_ARGS__)
#define GrB_Matrix_select_UINT32_(...)   GrB_Matrix_select_UINT32 (__VA_ARGS__)
#define GrB_Matrix_select_UINT64_(...)   GrB_Matrix_select_UINT64 (__VA_ARGS__)
#define GrB_Matrix_select_FP32_(...)     GrB_Matrix_select_FP32 (__VA_ARGS__)
#define GrB_Matrix_select_FP64_(...)     GrB_Matrix_select_FP64 (__VA_ARGS__)
#define GxB_Matrix_select_FC32_(...)     GxB_Matrix_select_FC32 (__VA_ARGS__)
#define GxB_Matrix_select_FC64_(...)     GxB_Matrix_select_FC64 (__VA_ARGS__)
#define GrB_Matrix_select_UDT_(...)      GrB_Matrix_select_UDT (__VA_ARGS__)
#define GrB_Matrix_select_Scalar_(...)   GrB_Matrix_select_Scalar (__VA_ARGS__)

// GxB_select:
#define GxB_Vector_select_(...)                     GxB_Vector_select (__VA_ARGS__)
#define GxB_Matrix_select_(...)                     GxB_Matrix_select (__VA_ARGS__)

// GrB_reduce:
#define GrB_Matrix_reduce_BinaryOp_Scalar_(...)     GrB_Matrix_reduce_BinaryOp_Scalar (__VA_ARGS__)
#define GrB_Vector_reduce_BinaryOp_Scalar_(...)     GrB_Vector_reduce_BinaryOp_Scalar (__VA_ARGS__)
#define GrB_Matrix_reduce_Monoid_Scalar_(...)       GrB_Matrix_reduce_Monoid_Scalar (__VA_ARGS__)
#define GrB_Matrix_reduce_Monoid_(...)              GrB_Matrix_reduce_Monoid (__VA_ARGS__)
#define GrB_Matrix_reduce_BinaryOp_(...)            GrB_Matrix_reduce_BinaryOp (__VA_ARGS__)
#define GrB_Vector_reduce_Monoid_Scalar_(...)       GrB_Vector_reduce_Monoid_Scalar (__VA_ARGS__)
#define GrB_Vector_reduce_BOOL_(...)                GrB_Vector_reduce_BOOL (__VA_ARGS__)
#define GrB_Vector_reduce_INT8_(...)                GrB_Vector_reduce_INT8 (__VA_ARGS__)
#define GrB_Vector_reduce_INT16_(...)               GrB_Vector_reduce_INT16 (__VA_ARGS__)
#define GrB_Vector_reduce_INT32_(...)               GrB_Vector_reduce_INT32 (__VA_ARGS__)
#define GrB_Vector_reduce_INT64_(...)               GrB_Vector_reduce_INT64 (__VA_ARGS__)
#define GrB_Vector_reduce_UINT8_(...)               GrB_Vector_reduce_UINT8 (__VA_ARGS__)
#define GrB_Vector_reduce_UINT16_(...)              GrB_Vector_reduce_UINT16 (__VA_ARGS__)
#define GrB_Vector_reduce_UINT32_(...)              GrB_Vector_reduce_UINT32 (__VA_ARGS__)
#define GrB_Vector_reduce_UINT64_(...)              GrB_Vector_reduce_UINT64 (__VA_ARGS__)
#define GrB_Vector_reduce_FP32_(...)                GrB_Vector_reduce_FP32 (__VA_ARGS__)
#define GrB_Vector_reduce_FP64_(...)                GrB_Vector_reduce_FP64 (__VA_ARGS__)
#define GxB_Vector_reduce_FC32_(...)                GxB_Vector_reduce_FC32 (__VA_ARGS__)
#define GxB_Vector_reduce_FC64_(...)                GxB_Vector_reduce_FC64 (__VA_ARGS__)
#define GrB_Vector_reduce_UDT_(...)                 GrB_Vector_reduce_UDT (__VA_ARGS__)
#define GrB_Matrix_reduce_BOOL_(...)                GrB_Matrix_reduce_BOOL (__VA_ARGS__)
#define GrB_Matrix_reduce_INT8_(...)                GrB_Matrix_reduce_INT8 (__VA_ARGS__)
#define GrB_Matrix_reduce_INT16_(...)               GrB_Matrix_reduce_INT16 (__VA_ARGS__)
#define GrB_Matrix_reduce_INT32_(...)               GrB_Matrix_reduce_INT32 (__VA_ARGS__)
#define GrB_Matrix_reduce_INT64_(...)               GrB_Matrix_reduce_INT64 (__VA_ARGS__)
#define GrB_Matrix_reduce_UINT8_(...)               GrB_Matrix_reduce_UINT8 (__VA_ARGS__)
#define GrB_Matrix_reduce_UINT16_(...)              GrB_Matrix_reduce_UINT16 (__VA_ARGS__)
#define GrB_Matrix_reduce_UINT32_(...)              GrB_Matrix_reduce_UINT32 (__VA_ARGS__)
#define GrB_Matrix_reduce_UINT64_(...)              GrB_Matrix_reduce_UINT64 (__VA_ARGS__)
#define GrB_Matrix_reduce_FP32_(...)                GrB_Matrix_reduce_FP32 (__VA_ARGS__)
#define GrB_Matrix_reduce_FP64_(...)                GrB_Matrix_reduce_FP64 (__VA_ARGS__)
#define GxB_Matrix_reduce_FC32_(...)                GxB_Matrix_reduce_FC32 (__VA_ARGS__)
#define GxB_Matrix_reduce_FC64_(...)                GxB_Matrix_reduce_FC64 (__VA_ARGS__)
#define GrB_Matrix_reduce_UDT_(...)                 GrB_Matrix_reduce_UDT (__VA_ARGS__)

// GxB_resize:
#define GrB_Matrix_resize_(...)                     GrB_Matrix_resize (__VA_ARGS__)
#define GrB_Vector_resize_(...)                     GrB_Vector_resize (__VA_ARGS__)

// GrB_kronecker:
#define GrB_Matrix_kronecker_BinaryOp_(...)         GrB_Matrix_kronecker_BinaryOp (__VA_ARGS__)
#define GrB_Matrix_kronecker_Monoid_(...)           GrB_Matrix_kronecker_Monoid (__VA_ARGS__)
#define GrB_Matrix_kronecker_Semiring_(...)         GrB_Matrix_kronecker_Semiring (__VA_ARGS__)

// GxB_fprint:
#define GxB_Type_fprint_(o,p,f)                     GxB_Type_fprint (o, GB_STR(o), p, f)
#define GxB_UnaryOp_fprint_(o,p,f)                  GxB_UnaryOp_fprint (o, GB_STR(o), p, f)
#define GxB_BinaryOp_fprint_(o,p,f)                 GxB_BinaryOp_fprint (o, GB_STR(o), p, f)
#define GxB_SelectOp_fprint_(o,p,f)                 GxB_SelectOp_fprint (o, GB_STR(o), p, f)
#define GxB_Monoid_fprint_(o,p,f)                   GxB_Monoid_fprint (o, GB_STR(o), p, f)
#define GxB_Semiring_fprint_(o,p,f)                 GxB_Semiring_fprint (o, GB_STR(o), p, f)
#define GxB_Descriptor_fprint_(o,p,f)               GxB_Descriptor_fprint (o, GB_STR(o), p, f)
#define GxB_Matrix_fprint_(o,p,f)                   GxB_Matrix_fprint (o, GB_STR(o), p, f)
#define GxB_Vector_fprint_(o,p,f)                   GxB_Vector_fprint (o, GB_STR(o), p, f)
#define GxB_Scalar_fprint_(o,p,f)                   GxB_Scalar_fprint (o, GB_STR(o), p, f)

#endif
#endif

