
complete -c astyle -l style -xa 'allman java kr stroustrup whitesmith vtk ratliff gnu linux horstmann 1tbs google mozilla webkit pico lisp' -d 'Set a formatting and indenting style'
complete -c astyle -l indent -xa 'spaces tab force-tab force-tab-x' -d 'Set indentation option'
complete -c astyle -l attach-namespaces -d 'Attach braces to a namespace statement'
complete -c astyle -l attach-classes -d 'Attach braces to a class statement'
complete -c astyle -l attach-inlines -d 'Attach braces to class inline function definitions'
complete -c astyle -l attach-extern-c -d 'Attach braces to an extern C statement'
complete -c astyle -l attach-closing-while -d 'Attach closing while of do-while to the closing brace'
complete -c astyle -l indent-classes -d 'Indent \'class\' blocks so that the entire block is indented'
complete -c astyle -l indent-modifiers -d 'Indent \'class\' access modifiers, \'public:\', \'protected:\' or \'private:\', one half indent'
complete -c astyle -l indent-switches -d 'Indent \'switch\' blocks, so that the inner \'case XXX:\'  headers are indented in relation to the switch block'
complete -c astyle -l indent-cases -d 'Indent case blocks from the \'case XXX:\' headers'
complete -c astyle -l indent-namespaces -d 'Indent the contents of namespace blocks'
complete -c astyle -l indent-after-parens -d 'Indent, instead of align, continuation lines following lines that contain an opening paren \'(\' or an assignment \'=\''
complete -c astyle -l indent-continuation -xa '0 1 2 3 4' -d 'Indent continuation lines an additional indents'
complete -c astyle -l indent-labels -d 'Indent labels so that they appear one indent less than the current indentation level, rather than being flushed completely to the left'
complete -c astyle -l indent-preproc-block -d 'Indent preprocessor blocks at brace level 0'
complete -c astyle -l indent-preproc-cond -d 'Indent preprocessor conditional statements #if/#else/#endif to the same level as the source code'
complete -c astyle -l indent-preproc-define -d 'Indent multi-line preprocessor #define statements'
complete -c astyle -l indent-col1-comments -d 'Indent line comments that start in column one'
complete -c astyle -l min-conditional-indent -xa '0 1 2 3' -d 'Indent a minimal # spaces in a continuous conditional belonging to a conditional header'
complete -c astyle -l max-continuation-indent -r -d 'Indent a maximal # spaces in a continuation line, relative to the previous line'
complete -c astyle -l break-blocks -xa 'all' -d 'Insert empty lines around unrelated blocks, labels, classes, ..'
complete -c astyle -l pad-oper -d 'Insert space padding around operators'
complete -c astyle -l pad-comma -d 'Insert space padding after commas'
complete -c astyle -l pad-paren -d 'Insert space padding around parenthesis on both the outside and the inside'
complete -c astyle -l pad-paren-out -d 'Insert space padding around parenthesis on the outside only'
complete -c astyle -l pad-first-paren-out -d 'Insert space padding around first parenthesis in a series on the outside only'
complete -c astyle -l pad-paren-in -d 'Insert space padding around parenthesis on the inside only'
complete -c astyle -l pad-header -d 'Insert space padding after paren headers (e.g'
complete -c astyle -l unpad-paren -d 'Remove unnecessary space padding around parenthesis'
complete -c astyle -l pad-empty-paren -d 'Apply padding to empty pairs of parentheses'
complete -c astyle -l pad-brackets -d 'Insert space padding around square brackets on both the outside and the inside (experimental)'
complete -c astyle -l unpad-brackets -d 'Remove unnecessary space padding around square brackets (experimental)'
complete -c astyle -l delete-empty-lines -d 'Delete empty lines within a function or method'
complete -c astyle -l fill-empty-lines -d 'Fill empty lines with the white space of their previous lines'
complete -c astyle -l align-pointer -xa 'type middle name' -d 'Attach a pointer or reference operator (*, &, or ^) to either the operator type (left), middle, or operator name (right)'
complete -c astyle -l align-reference -xa 'none type middle name' -d 'Attach a reference operator (&) to either the operator type (left), middle, or operator name (right)'
complete -c astyle -l break-closing-braces -d 'Break braces before closing headers (e.g'
complete -c astyle -l break-elseifs -d 'Break \'else if()\' statements into two different lines'
complete -c astyle -l break-one-line-headers -d 'Break one line headers (e.g'
complete -c astyle -l add-braces -d 'Add braces to unbraced one line conditional statements'
complete -c astyle -l add-one-line-braces -d 'Add one line braces to unbraced one line conditional statements'
complete -c astyle -l remove-braces -d 'Remove braces from a braced one line conditional statements'
complete -c astyle -l break-return-type -d 'Break the return type from the function name definitions'
complete -c astyle -l attach-return-type-decl -d 'Break the return type from the function name declarations'
complete -c astyle -l keep-one-line-blocks -d 'Don\'t break blocks residing completely on one line'
complete -c astyle -l keep-one-line-statements -d 'Don\'t break lines containing multiple statements into multiple single-statement lines'
complete -c astyle -l convert-tabs -d 'Convert tabs to the appropriate number of spaces'
complete -c astyle -l close-templates -d 'Close ending angle brackets on template definitions'
complete -c astyle -l remove-comment-prefix -d 'Remove the leading \'*\' prefix on multi-line comments and indent the comment text one indent'
complete -c astyle -l max-code-length -r -d 'Break the line if it exceeds more than # characters'
complete -c astyle -l break-after-logical -d 'After break line using --max-code-length, place logical conditional last on the previous line'
complete -c astyle -xa 'c java cs objc js' -d 'Set input syntax mode'
complete -c astyle -l pad-method-prefix -d 'Insert space padding after the \'-\' or \'+\' Objective-C method prefix'
complete -c astyle -l unpad-method-prefix -d 'Remove all space padding after the \'-\' or \'+\' Objective-C method prefix'
complete -c astyle -l pad-return-type -d 'Insert space padding after the Objective-C return type'
complete -c astyle -l unpad-return-type -d 'Remove all space padding after the Objective-C return type'
complete -c astyle -l pad-param-type -d 'Insert space padding after the Objective-C param type'
complete -c astyle -l unpad-param-type -d 'Remove all space padding after the Objective-C param type'
complete -c astyle -l align-method-colon -d 'Align the colons in an Objective-C method definition'
complete -c astyle -l pad-method-colon -xa 'none all after before' -d 'Add or remove space padding before or after the colons in an Objective-C method call'
complete -c astyle -l suffix -r -d 'Append the suffix #### instead of \'.orig\' to original filename or do not retain a backup of the original file if set to none'
complete -c astyle -l recursive -d 'Process subdirectories recursively'
complete -c astyle -l dry-run -d 'Perform a trial run with no changes made to check for formatting'
complete -c astyle -l exclude -r -d 'Specify a file or directory #### to be excluded from processing'
complete -c astyle -l ignore-exclude-errors -d 'Allow processing to continue if there are errors in the --exclude options'
complete -c astyle -l ignore-exclude-errors-x -d 'Allow processing to continue if there are errors in the --exclude options'
complete -c astyle -l errors-to-stdout -d 'Print errors and help information to standard-output rather than to standard-error'
complete -c astyle -l preserve-date -d 'Preserve the original file\'s date and time modified'
complete -c astyle -l verbose -d 'Extra informational messages will be displayed'
complete -c astyle -l formatted -d 'Display only the files that have been formatted'
complete -c astyle -l quiet -d 'Suppress all output except error messages'
complete -c astyle -l lineend -xa 'windows linux macold' -d 'Force use of the specified line end style'
complete -c astyle -l options -r -d 'Specify a default option file to read and use'
complete -c astyle -l project -r -d 'Specify a project option file to read and use'
complete -c astyle -l ascii -d 'The displayed output will be ASCII characters only'
complete -c astyle -l version -d 'Print version number'
complete -c astyle -l help -d 'Print help message'
complete -c astyle -l html -d 'Open the HTML help file astyle.html in the default browser'
complete -c astyle -l stdin -r -d 'Use the file path as input to single file formatting'
complete -c astyle -l stdout -r -d 'Use the file path as output from single file formatting'
complete -c astyle -l squeeze-lines -r -d 'Remove superfluous empty lines exceeding the given number'
complete -c astyle -l squeeze-ws -d 'Remove superfluous whitespace'
