


          GFTODVI(1)           INTERACTIVE UNIX System           GFTODVI(1)



          NAME
               gftodvi - make proofsheets from generic font files

          SYNOPSIS
               ggggffffttttooooddddvvvviiii [gf_file_name]

          DESCRIPTION
               The _g_f_t_o_d_v_i program converts a generic font (GF) file output
               by, for example, mmmmffff(1), to a device independent (DVI) file
               that can be typeset using the same software as for TeX out-
               put. The characters in the GF file will appear one per page,
               with labels, titles, and annotations as specified in Appen-
               dix H (Hardcopy Proofs) of _T_h_e _M_E_T_A_F_O_N_T_b_o_o_k.

               _G_F_t_o_D_V_I uses other fonts in addition to the main GF file.  A
               `gray' font is used to typeset the pixels that actually make
               up the character. (We wouldn't want all the pixels to be
               simply black, since then labels, key points, and other
               information would be lost.) A `title' font is used for the
               information at the top of the page. A `label' font is used
               for the labels on key points of the figure. A `slant' font
               is used to typeset diagonal lines, which otherwise have to
               be simulated using horizontal and vertical rules.  The
               default gray, title, and label fonts are _g_r_a_y, _c_m_r_8, and
               _c_m_t_t_1_0, respectively; there is no default slant font.

               To change the default fonts, you can give ssssppppeeeecccciiiiaaaallll commands
               in your Metafont source file, or you can change the fonts
               online. An online dialog ensues if you end the _g_f__f_i_l_e__n_a_m_e
               with a `/'. For example,
                 gftodvi io.300gf/
                 Special font substitution: grayfont black
                 OK; any more? grayfontarea /home/art/don/
                 OK; any more? slantfont /home/fonts/slantimagen6
                 OK; any more? <RET>
               will use ////hhhhoooommmmeeee////aaaarrrrtttt////ddddoooonnnn////bbbbllllaaaacccckkkk as the `gray' font and
               ////hhhhoooommmmeeee////ffffoooonnnnttttssss////ssssllllaaaannnnttttiiiimmmmaaaaggggeeeennnn6666 as the `slant' font (this name
               indicates a font for lines with slope 1/6 at the resolution
               of an Imagen printer).

               The _g_f__f_i_l_e__n_a_m_e on the command line must be complete. (The
               program prompts you for it if you don't give it.) Because
               the resolution is part of the extension, it would not make
               sense to add on a default extension as is done with TeX or
               DVI-reading software. The output file name defaults to the
               same root as the gf file, with the `dvi' extension added.
               For example, the input file _i_o._2_6_0_2_g_f would become _i_o._d_v_i.

          ENVIRONMENT VARIABLES
               _g_f_t_o_d_v_i uses the environment variable GFFONTS to search for
               the GF file.  If GFFONTS is not set, it uses the variable
               TEXFONTS.  If TEXFONTS is not set, it uses the system
               default:  ....::::////uuuussssrrrr////llllooooccccaaaallll////lllliiiibbbb////tttteeeexxxx////ffffoooonnnnttttssss////ttttffffmmmm.


          Rev. 8/8/90                                                Page 1






          GFTODVI(1)           INTERACTIVE UNIX System           GFTODVI(1)



               The TEXFONTS environment variable is used to find the TFM
               files that the program needs. If TEXFONTS is not set, the
               system default above is used.  See tttteeeexxxx(1) for the details of
               the searching.

          FILES
               /usr/local/lib/tex/fonts/{gray.tfm,...} the default fonts

               /usr/local/lib/mf/inputs/{gray.mf,...}  the Metafont sources
                                                       (perhaps)

          SEE ALSO
               tex(1), mf(1)
               Donald Knuth, _T_h_e _M_E_T_A_F_O_N_T_b_o_o_k
               Donald Knuth et al., _M_E_T_A_F_O_N_T_w_a_r_e

          AUTHORS
               Donald Knuth wrote the program. It was published as part of
               the _M_E_T_A_F_O_N_T_w_a_r_e technical report, available from the TeX
               Users Group.  Paul Richards originally ported it to Unix.



































          Rev. 8/8/90                                                Page 2



