/* Portions Copyright (C) 2001 artofcode LLC.
   Portions Copyright (C) 1996, 2001 Artifex Software Inc.
   Portions Copyright (C) 1988, 2000 Aladdin Enterprises.
   This software is based in part on the work of the Independent JPEG Group.
   All Rights Reserved.

   This software is distributed under license and may not be copied, modified
   or distributed except as expressly authorized under the terms of that
   license.  Refer to licensing information at http://www.artifex.com/ or
   contact Artifex Software, Inc., 101 Lucas Valley Road #110,
   San Rafael, CA  94903, (415)492-9861, for further information. */
/*$Id: pcht.c,v 1.33 2005/01/02 18:54:02 stefan Exp $ */

/* pcht.c - PCL halftone/rendering object implementation */
#include "gx.h"
#include "math_.h"
#include "gsmemory.h"
#include "gsstruct.h"
#include "gsrefct.h"
#include "gsdevice.h"
#include "gsparam.h"
#include "gxdevice.h"
#include "pcommand.h"
#include "pcstate.h"
#include "pcdither.h"
#include "pcht.h"
#include "pcpalet.h"
#include "pcindxed.h"
#include "plht.h"

/*
 * GC routines
 */
private
ENUM_PTRS_BEGIN(ht_dither_enum_ptrs)

        return 0;

      case 1:
        {
            pcl_ht_builtin_dither_t * pdither = (pcl_ht_builtin_dither_t *)vptr;

            if (pdither->type == pcl_halftone_Threshold)
                ENUM_RETURN(pdither->u.thresh.pdata);
            else if (pdither->type == pcl_halftone_Table_Dither)
                ENUM_RETURN(pdither->u.tdither.pdata);
            else
                return 0;
        }
ENUM_PTRS_END

private
RELOC_PTRS_BEGIN(ht_dither_reloc_ptrs)
    pcl_ht_builtin_dither_t *   pdither = (pcl_ht_builtin_dither_t *)vptr;

    if (pdither->type == pcl_halftone_Threshold)
        RELOC_VAR(pdither->u.thresh.pdata);
    else if (pdither->type == pcl_halftone_Table_Dither)
        RELOC_VAR(pdither->u.tdither.pdata);
RELOC_PTRS_END

private_st_ht_builtin_dither_t();


private
ENUM_PTRS_BEGIN(ht_enum_ptrs)
        return 0;
      ENUM_PTR(0, pcl_ht_t, client_data[0].plktbl);
      ENUM_PTR(1, pcl_ht_t, client_data[1].plktbl);
      ENUM_PTR(2, pcl_ht_t, client_data[2].plktbl);
      ENUM_PTR(3, pcl_ht_t, pdither);
      ENUM_STRING_PTR(4, pcl_ht_t, thresholds[0]);
      ENUM_STRING_PTR(5, pcl_ht_t, thresholds[1]);
      ENUM_STRING_PTR(6, pcl_ht_t, thresholds[2]);
      ENUM_PTR(7, pcl_ht_t, pfg_ht);
      ENUM_PTR(8, pcl_ht_t, pim_ht);
ENUM_PTRS_END

private
RELOC_PTRS_BEGIN(ht_reloc_ptrs)
    RELOC_PTR(pcl_ht_t, client_data[0].plktbl);
    RELOC_PTR(pcl_ht_t, client_data[1].plktbl);
    RELOC_PTR(pcl_ht_t, client_data[2].plktbl);
    RELOC_PTR(pcl_ht_t, pdither);
    RELOC_STRING_PTR(pcl_ht_t, thresholds[0]);
    RELOC_STRING_PTR(pcl_ht_t, thresholds[1]);
    RELOC_STRING_PTR(pcl_ht_t, thresholds[2]);
    RELOC_PTR(pcl_ht_t, pfg_ht);
    RELOC_PTR(pcl_ht_t, pim_ht);
RELOC_PTRS_END

private_st_ht_t();

/*
 * Built-in dither information. The ordered and clustered-ordered dither
 * matrices are fixed so as to give predictable results when used in combination
 * with logical operations (raster-ops).
 */
private const byte  ordered_dither_data[16 * 16] = {
  142, 46, 174, 6, 134, 38, 166, 12, 140, 44, 172, 4, 132, 36, 164, 14, 
  78, 238, 110, 198, 70, 230, 102, 204, 76, 236, 108, 196, 68, 228, 100, 206, 
  190, 30, 158, 54, 182, 22, 150, 60, 188, 28, 156, 52, 180, 20, 148, 62, 
  126, 222, 94, 246, 118, 214, 86, 252, 124, 220, 92, 244, 116, 212, 84, 254, 
  129, 33, 161, 9, 137, 41, 169, 3, 131, 35, 163, 11, 139, 43, 171, 1, 
  65, 225, 97, 201, 73, 233, 105, 195, 67, 227, 99, 203, 75, 235, 107, 193, 
  177, 17, 145, 57, 185, 25, 153, 51, 179, 19, 147, 59, 187, 27, 155, 49, 
  113, 209, 81, 249, 121, 217, 89, 243, 115, 211, 83, 251, 123, 219, 91, 241, 
  141, 45, 173, 5, 133, 37, 165, 15, 143, 47, 175, 7, 135, 39, 167, 13, 
  77, 237, 109, 197, 69, 229, 101, 207, 79, 239, 111, 199, 71, 231, 103, 205, 
  189, 29, 157, 53, 181, 21, 149, 63, 191, 31, 159, 55, 183, 23, 151, 61, 
  125, 221, 93, 245, 117, 213, 85, 255, 127, 223, 95, 247, 119, 215, 87, 253, 
  130, 34, 162, 10, 138, 42, 170, 1, 128, 32, 160, 8, 136, 40, 168, 2, 
  66, 226, 98, 202, 74, 234, 106, 192, 64, 224, 96, 200, 72, 232, 104, 194, 
  178, 18, 146, 58, 186, 26, 154, 48, 176, 16, 144, 56, 184, 24, 152, 50, 
  114, 210, 82, 250, 122, 218, 90, 240, 112, 208, 80, 248, 120, 216, 88, 242
};

private const byte  clustered_dither_data[16 * 16] = {
  228, 164, 40, 8, 24, 152, 199, 247, 231, 167, 43, 11, 27, 155, 196, 244, 
  116, 52, 96, 176, 80, 64, 135, 215, 119, 55, 99, 179, 83, 67, 132, 212, 
  20, 148, 192, 240, 224, 160, 39, 7, 23, 151, 195, 243, 227, 163, 36, 4, 
  94, 78, 128, 208, 112, 48, 109, 189, 93, 77, 131, 211, 115, 51, 111, 190, 
  238, 174, 32, 1, 16, 144, 205, 253, 237, 173, 35, 3, 19, 147, 206, 254, 
  126, 62, 106, 186, 90, 74, 141, 221, 125, 61, 105, 185, 89, 73, 142, 222, 
  30, 158, 202, 250, 234, 170, 45, 13, 29, 157, 201, 249, 233, 169, 46, 14, 
  86, 70, 138, 218, 122, 58, 101, 181, 85, 69, 137, 217, 121, 57, 102, 182, 
  230, 166, 42, 10, 26, 154, 197, 245, 229, 165, 41, 9, 25, 153, 198, 246, 
  118, 54, 98, 178, 82, 66, 133, 213, 117, 53, 97, 177, 81, 65, 134, 214, 
  22, 150, 194, 242, 226, 162, 37, 5, 21, 149, 193, 241, 225, 161, 38, 6, 
  92, 76, 130, 210, 114, 50, 111, 191, 95, 79, 129, 209, 113, 49, 108, 188, 
  236, 172, 34, 2, 18, 146, 207, 255, 239, 175, 33, 1, 17, 145, 204, 252, 
  124, 60, 104, 184, 88, 72, 143, 223, 127, 63, 107, 187, 91, 75, 140, 220, 
  28, 156, 200, 248, 232, 168, 47, 15, 31, 159, 203, 251, 235, 171, 44, 12, 
  84, 68, 136, 216, 120, 56, 103, 183, 87, 71, 139, 219, 123, 59, 100, 180
};

private const byte  noise_dither_data[128 * 128] = {
  112, 122, 183, 239, 27, 78, 115, 52, 204, 212, 6, 114, 72, 134, 205, 61,
  1, 38, 91, 107, 30, 206, 115, 168, 184, 7, 148, 32, 16, 195, 103, 191,
  15, 121, 109, 64, 246, 184, 48, 208, 245, 220, 34, 187, 216, 30, 35, 148,
  30, 167, 189, 158, 38, 9, 209, 51, 114, 133, 82, 29, 137, 240, 245, 73,
  196, 27, 97, 54, 28, 9, 62, 201, 80, 202, 253, 183, 50, 6, 47, 92,
  152, 73, 47, 81, 91, 10, 46, 191, 55, 119, 199, 188, 39, 178, 122, 212,
  230, 16, 151, 203, 178, 96, 176, 62, 172, 50, 102, 148, 190, 117, 85, 105,
  183, 85, 107, 222, 88, 181, 171, 47, 82, 106, 58, 240, 46, 142, 195, 214,
  1, 223, 24, 174, 203, 89, 151, 99, 154, 184, 138, 80, 238, 31, 186, 148,
  51, 132, 166, 183, 216, 63, 231, 10, 214, 105, 82, 120, 74, 27, 62, 146,
  194, 182, 129, 171, 49, 119, 160, 122, 90, 27, 101, 128, 105, 243, 115, 9,
  1, 59, 210, 129, 190, 99, 207, 140, 53, 68, 159, 33, 195, 118, 148, 94,
  244, 75, 40, 187, 94, 41, 71, 163, 37, 25, 112, 129, 115, 72, 148, 190,
  177, 124, 32, 34, 101, 52, 137, 249, 150, 164, 135, 233, 140, 145, 93, 246,
  43, 215, 98, 242, 144, 2, 124, 252, 18, 71, 126, 207, 64, 195, 161, 48,
  160, 114, 201, 115, 182, 129, 6, 118, 48, 126, 206, 184, 55, 16, 210, 108,
  57, 70, 201, 45, 169, 10, 240, 46, 166, 98, 92, 251, 13, 127, 175, 245,
  118, 158, 239, 18, 155, 254, 106, 72, 237, 70, 204, 48, 24, 245, 145, 236,
  212, 244, 44, 22, 86, 3, 76, 110, 10, 170, 133, 52, 179, 84, 174, 237,
  85, 98, 74, 35, 17, 115, 145, 246, 215, 72, 229, 181, 63, 171, 2, 32,
  96, 122, 13, 149, 234, 254, 221, 191, 85, 217, 174, 56, 168, 247, 225, 107,
  209, 204, 108, 243, 120, 173, 218, 74, 43, 64, 28, 90, 59, 77, 165, 200,
  53, 28, 107, 186, 240, 37, 202, 30, 95, 246, 224, 6, 20, 237, 154, 217,
  166, 18, 75, 11, 230, 80, 156, 62, 20, 72, 239, 2, 22, 169, 95, 148,
  254, 94, 147, 139, 249, 198, 161, 124, 226, 47, 59, 28, 210, 106, 95, 44,
  243, 203, 73, 209, 35, 143, 96, 164, 141, 162, 57, 255, 223, 84, 123, 130,
  240, 73, 147, 95, 234, 165, 209, 21, 196, 138, 79, 222, 204, 135, 53, 69,
  113, 202, 231, 244, 163, 70, 212, 87, 168, 203, 243, 14, 106, 172, 37, 217,
  131, 209, 176, 239, 105, 136, 120, 154, 227, 125, 147, 7, 144, 220, 206, 19,
  162, 240, 133, 6, 155, 22, 207, 236, 223, 104, 2, 210, 227, 26, 11, 98,
  89, 173, 132, 66, 201, 79, 104, 150, 38, 221, 134, 184, 4, 73, 254, 133,
  237, 34, 253, 50, 112, 219, 241, 23, 211, 172, 143, 146, 74, 177, 252, 119,
  214, 54, 176, 97, 242, 213, 32, 178, 107, 55, 69, 219, 102, 194, 221, 140,
  139, 61, 39, 192, 205, 86, 1, 170, 169, 129, 227, 4, 14, 201, 110, 113,
  78, 232, 143, 217, 16, 231, 221, 152, 201, 151, 94, 57, 181, 12, 172, 63,
  188, 149, 116, 16, 48, 160, 6, 78, 218, 255, 54, 193, 228, 192, 100, 156,
  236, 167, 53, 134, 23, 177, 1, 235, 135, 109, 68, 10, 22, 173, 180, 1,
  58, 44, 237, 89, 68, 193, 149, 35, 95, 203, 7, 156, 139, 187, 197, 33,
  159, 110, 243, 93, 32, 235, 84, 244, 122, 45, 27, 57, 12, 116, 228, 223,
  87, 7, 223, 111, 212, 247, 155, 120, 109, 174, 32, 41, 208, 36, 77, 232,
  33, 182, 128, 206, 14, 135, 86, 157, 189, 229, 88, 228, 77, 120, 81, 7,
  233, 2, 121, 252, 69, 212, 182, 22, 36, 235, 153, 47, 232, 135, 41, 165,
  167, 104, 157, 242, 175, 136, 29, 42, 26, 163, 180, 239, 100, 223, 156, 200,
  138, 223, 235, 75, 230, 84, 251, 62, 23, 127, 96, 155, 1, 76, 19, 226,
  74, 3, 91, 155, 78, 132, 116, 204, 219, 207, 81, 251, 121, 143, 212, 237,
  224, 27, 186, 141, 94, 5, 115, 189, 16, 181, 245, 117, 170, 222, 234, 49,
  231, 192, 125, 166, 182, 127, 80, 51, 77, 14, 156, 83, 141, 189, 101, 21,
  19, 116, 53, 249, 84, 9, 5, 204, 215, 136, 228, 13, 251, 3, 164, 28,
  131, 67, 146, 1, 105, 68, 177, 43, 170, 25, 197, 15, 21, 233, 173, 152,
  152, 29, 80, 218, 251, 228, 160, 59, 71, 12, 179, 88, 157, 92, 75, 23,
  38, 82, 50, 198, 107, 203, 77, 254, 214, 68, 98, 250, 85, 25, 40, 124,
  254, 60, 206, 111, 200, 125, 134, 185, 164, 104, 191, 3, 126, 166, 83, 220,
  29, 197, 250, 103, 243, 158, 152, 218, 228, 153, 170, 42, 248, 198, 150, 104,
  169, 9, 146, 99, 53, 231, 172, 19, 238, 61, 110, 114, 253, 113, 88, 158,
  65, 200, 24, 1, 44, 219, 129, 205, 138, 220, 162, 233, 68, 171, 61, 131,
  150, 70, 193, 192, 38, 141, 73, 190, 203, 43, 130, 65, 137, 66, 64, 103,
  225, 30, 247, 84, 62, 116, 156, 236, 121, 153, 137, 38, 255, 64, 179, 39,
  174, 78, 181, 111, 122, 97, 137, 46, 194, 224, 101, 117, 242, 220, 53, 177,
  2, 178, 31, 120, 192, 116, 91, 51, 126, 36, 7, 142, 227, 255, 70, 134,
  21, 95, 40, 165, 211, 24, 175, 102, 80, 227, 22, 141, 143, 64, 197, 34,
  44, 192, 216, 123, 101, 87, 35, 60, 51, 118, 24, 164, 30, 43, 63, 70,
  121, 254, 69, 206, 242, 106, 134, 213, 71, 167, 216, 37, 1, 107, 24, 75,
  33, 222, 136, 59, 7, 169, 106, 158, 248, 198, 100, 187, 199, 36, 236, 88,
  227, 170, 133, 45, 229, 167, 110, 61, 123, 90, 248, 163, 213, 121, 153, 188,
  42, 93, 136, 16, 191, 56, 19, 199, 150, 227, 208, 216, 195, 224, 132, 215,
  200, 151, 247, 94, 79, 50, 125, 198, 207, 58, 68, 250, 193, 49, 33, 171,
  149, 252, 111, 59, 39, 229, 19, 249, 45, 43, 211, 56, 202, 72, 125, 191,
  183, 105, 233, 150, 219, 186, 45, 15, 39, 224, 139, 4, 43, 28, 208, 131,
  179, 83, 17, 90, 31, 117, 141, 69, 64, 159, 110, 240, 194, 142, 252, 185,
  252, 130, 226, 54, 219, 80, 163, 230, 248, 48, 109, 166, 12, 85, 143, 148,
  26, 174, 35, 188, 157, 113, 46, 81, 145, 177, 5, 142, 209, 149, 39, 193,
  149, 125, 33, 99, 187, 76, 89, 217, 51, 194, 168, 35, 1, 205, 176, 178,
  187, 58, 158, 22, 12, 103, 172, 82, 65, 8, 130, 40, 129, 100, 168, 41,
  140, 175, 222, 230, 241, 136, 238, 126, 109, 150, 144, 172, 114, 67, 138, 249,
  218, 207, 140, 14, 164, 118, 193, 215, 251, 137, 117, 226, 13, 205, 233, 60,
  20, 47, 196, 69, 90, 194, 239, 79, 198, 25, 93, 238, 56, 182, 50, 157,
  226, 151, 203, 67, 59, 100, 182, 2, 66, 139, 166, 205, 36, 12, 102, 79,
  65, 23, 202, 128, 63, 208, 144, 180, 62, 201, 125, 87, 184, 228, 205, 168,
  120, 86, 1, 56, 10, 214, 245, 114, 123, 103, 92, 76, 140, 232, 108, 180,
  54, 94, 135, 173, 234, 152, 101, 122, 134, 81, 24, 104, 238, 250, 147, 144,
  83, 193, 74, 165, 141, 71, 248, 209, 167, 126, 37, 246, 87, 192, 253, 125,
  15, 66, 108, 187, 8, 176, 180, 87, 185, 9, 226, 43, 89, 147, 98, 188,
  150, 17, 123, 93, 102, 6, 58, 190, 186, 87, 145, 108, 20, 33, 83, 146,
  173, 204, 57, 249, 5, 153, 241, 174, 154, 184, 77, 97, 81, 250, 169, 7,
  39, 133, 113, 255, 178, 214, 86, 162, 188, 26, 14, 242, 233, 161, 145, 4,
  220, 131, 76, 42, 36, 160, 29, 86, 175, 132, 214, 154, 79, 126, 100, 20,
  210, 238, 60, 99, 229, 208, 74, 40, 163, 34, 225, 23, 67, 8, 170, 54,
  67, 179, 244, 1, 30, 158, 42, 52, 233, 246, 117, 8, 56, 96, 92, 17,
  222, 118, 232, 252, 48, 159, 231, 109, 51, 111, 188, 9, 11, 26, 75, 50,
  116, 44, 21, 60, 37, 100, 215, 17, 213, 20, 81, 124, 211, 234, 6, 26,
  230, 183, 18, 66, 80, 131, 88, 153, 195, 169, 4, 32, 97, 139, 166, 248,
  91, 117, 142, 8, 103, 123, 132, 58, 170, 248, 55, 107, 120, 237, 216, 112,
  58, 172, 222, 11, 241, 48, 238, 146, 95, 127, 34, 199, 114, 55, 93, 210,
  179, 82, 147, 13, 118, 1, 250, 112, 66, 3, 31, 225, 247, 50, 21, 211,
  197, 139, 249, 160, 91, 164, 181, 19, 241, 147, 211, 52, 69, 253, 118, 13,
  200, 224, 29, 231, 199, 12, 131, 243, 154, 79, 191, 209, 68, 44, 97, 196,
  211, 20, 190, 113, 234, 35, 202, 155, 144, 250, 63, 217, 96, 123, 104, 18,
  202, 19, 56, 244, 42, 149, 189, 13, 128, 90, 40, 199, 65, 208, 159, 85,
  106, 155, 161, 23, 185, 176, 158, 81, 92, 112, 235, 144, 132, 188, 75, 89,
  26, 108, 12, 214, 13, 110, 27, 71, 124, 213, 61, 86, 89, 41, 232, 152,
  8, 119, 57, 45, 108, 77, 137, 46, 195, 230, 98, 213, 65, 16, 232, 128,
  185, 56, 40, 229, 136, 60, 190, 153, 123, 161, 159, 215, 116, 129, 30, 96,
  47, 58, 25, 155, 135, 75, 153, 49, 179, 137, 22, 72, 82, 11, 255, 41,
  26, 4, 226, 102, 165, 124, 221, 39, 189, 254, 140, 105, 100, 37, 138, 161,
  5, 34, 237, 163, 143, 119, 164, 220, 2, 101, 36, 180, 145, 142, 79, 230,
  34, 76, 197, 5, 83, 64, 229, 161, 167, 95, 133, 55, 3, 142, 221, 173,
  247, 141, 1, 228, 41, 71, 65, 11, 197, 55, 241, 189, 238, 37, 99, 8,
  88, 146, 205, 234, 221, 151, 161, 199, 177, 11, 121, 179, 242, 130, 201, 147,
  246, 200, 175, 156, 215, 189, 89, 208, 61, 157, 33, 106, 165, 20, 193, 186,
  251, 127, 183, 72, 15, 103, 241, 105, 41, 195, 192, 8, 232, 102, 198, 151,
  239, 204, 216, 165, 183, 97, 251, 226, 111, 196, 175, 234, 167, 185, 213, 227,
  71, 159, 132, 186, 98, 63, 197, 180, 162, 93, 151, 127, 185, 157, 91, 235,
  110, 90, 49, 133, 108, 4, 29, 85, 73, 235, 23, 196, 181, 60, 244, 218,
  156, 112, 163, 127, 102, 77, 248, 31, 154, 219, 246, 240, 253, 45, 178, 225,
  96, 47, 213, 61, 62, 130, 1, 224, 168, 24, 46, 127, 159, 28, 199, 54,
  135, 46, 119, 253, 92, 247, 225, 144, 236, 44, 252, 136, 31, 65, 10, 180,
  184, 82, 124, 224, 138, 211, 126, 171, 169, 130, 229, 181, 140, 52, 223, 160,
  221, 174, 25, 157, 18, 84, 45, 194, 83, 111, 78, 239, 14, 38, 255, 217,
  128, 3, 90, 191, 168, 42, 218, 206, 247, 63, 212, 115, 194, 146, 70, 112,
  216, 21, 113, 255, 145, 25, 78, 83, 202, 57, 15, 225, 128, 242, 220, 14,
  76, 207, 149, 243, 185, 53, 241, 66, 91, 117, 162, 160, 171, 17, 3, 200,
  210, 93, 190, 131, 217, 196, 134, 119, 11, 25, 186, 54, 104, 28, 99, 52,
  74, 103, 177, 162, 225, 236, 206, 114, 154, 5, 67, 210, 253, 219, 113, 173,
  176, 42, 67, 187, 52, 36, 178, 122, 162, 66, 109, 18, 101, 128, 222, 49,
  99, 231, 18, 73, 5, 245, 21, 49, 15, 76, 88, 32, 38, 249, 84, 111,
  97, 138, 92, 4, 235, 176, 67, 196, 142, 17, 244, 51, 57, 70, 182, 171,
  130, 250, 78, 109, 94, 119, 29, 15, 9, 152, 87, 17, 143, 31, 121, 55,
  49, 198, 86, 175, 139, 245, 236, 10, 218, 59, 40, 31, 60, 207, 27, 69,
  8, 91, 169, 180, 237, 88, 156, 197, 170, 95, 70, 33, 45, 209, 155, 125,
  102, 175, 32, 206, 187, 83, 223, 1, 137, 250, 79, 132, 173, 197, 159, 231,
  4, 205, 84, 71, 231, 93, 203, 157, 130, 202, 251, 165, 222, 139, 85, 39,
  207, 181, 78, 245, 161, 217, 156, 251, 36, 81, 149, 200, 130, 249, 9, 69,
  126, 62, 171, 178, 61, 250, 141, 156, 79, 82, 184, 157, 144, 72, 41, 148,
  232, 20, 79, 220, 75, 255, 137, 15, 236, 139, 199, 243, 104, 159, 168, 229,
  123, 154, 57, 242, 138, 248, 45, 236, 246, 160, 8, 218, 113, 225, 135, 112,
  119, 170, 221, 58, 195, 153, 192, 237, 245, 136, 99, 86, 82, 63, 210, 32,
  101, 127, 232, 251, 10, 247, 100, 79, 121, 227, 136, 158, 201, 17, 87, 254,
  72, 14, 243, 150, 237, 103, 198, 106, 186, 191, 89, 229, 64, 177, 26, 81,
  228, 34, 50, 170, 224, 59, 15, 67, 17, 110, 151, 87, 164, 119, 41, 148,
  115, 97, 60, 5, 136, 112, 190, 13, 234, 139, 183, 246, 187, 22, 94, 55,
  4, 212, 253, 136, 185, 101, 215, 65, 175, 139, 47, 90, 174, 114, 107, 225,
  56, 242, 119, 90, 36, 192, 148, 47, 179, 23, 149, 35, 202, 76, 212, 248,
  118, 211, 232, 26, 189, 223, 153, 73, 103, 81, 237, 167, 7, 197, 49, 165,
  231, 77, 156, 90, 166, 18, 219, 116, 27, 36, 142, 209, 145, 252, 69, 13,
  205, 147, 223, 32, 63, 157, 167, 113, 22, 249, 58, 219, 11, 173, 104, 236,
  144, 48, 214, 227, 242, 158, 21, 142, 163, 108, 13, 118, 128, 35, 201, 6,
  126, 141, 98, 210, 105, 254, 169, 123, 187, 65, 43, 223, 3, 49, 190, 20,
  165, 129, 228, 15, 30, 38, 88, 53, 163, 56, 21, 109, 227, 158, 121, 170,
  237, 109, 93, 43, 120, 166, 32, 7, 201, 29, 115, 49, 20, 55, 13, 214,
  133, 1, 145, 204, 171, 87, 223, 18, 107, 200, 114, 53, 123, 59, 135, 24,
  202, 108, 179, 171, 114, 162, 100, 14, 20, 207, 143, 182, 224, 80, 147, 184,
  34, 187, 11, 193, 255, 52, 76, 102, 78, 151, 2, 114, 130, 238, 128, 39,
  54, 46, 75, 142, 139, 42, 211, 28, 1, 108, 181, 199, 47, 131, 186, 71,
  55, 94, 124, 190, 38, 164, 54, 68, 212, 59, 30, 47, 78, 101, 130, 246,
  146, 132, 253, 22, 138, 21, 37, 186, 103, 56, 12, 234, 204, 255, 238, 107,
  206, 113, 39, 68, 239, 73, 194, 119, 80, 122, 8, 214, 223, 43, 82, 197,
  30, 131, 66, 198, 94, 206, 48, 239, 6, 248, 221, 227, 189, 197, 241, 54,
  173, 102, 178, 42, 100, 194, 127, 230, 66, 10, 170, 89, 7, 85, 45, 189,
  34, 66, 1, 70, 203, 90, 61, 1, 38, 124, 47, 74, 25, 87, 48, 245,
  100, 246, 134, 21, 94, 38, 5, 131, 203, 230, 49, 181, 178, 111, 173, 207,
  250, 50, 15, 200, 141, 235, 102, 165, 74, 143, 198, 106, 129, 97, 221, 13,
  234, 138, 58, 33, 119, 160, 219, 42, 82, 218, 230, 181, 91, 20, 97, 170,
  28, 160, 44, 246, 177, 36, 158, 116, 243, 181, 155, 161, 218, 201, 127, 145,
  198, 255, 216, 173, 154, 204, 92, 243, 93, 48, 49, 180, 114, 224, 193, 240,
  80, 18, 199, 240, 21, 142, 76, 87, 78, 89, 27, 226, 42, 238, 172, 128,
  130, 195, 33, 150, 77, 52, 210, 131, 95, 201, 147, 177, 193, 142, 88, 49,
  29, 156, 133, 51, 209, 210, 77, 227, 69, 126, 41, 163, 50, 84, 128, 169,
  122, 208, 92, 217, 53, 1, 20, 188, 115, 154, 239, 242, 226, 223, 31, 68,
  68, 174, 82, 98, 203, 246, 185, 1, 118, 52, 183, 94, 128, 207, 76, 233,
  153, 86, 109, 241, 254, 80, 17, 188, 16, 145, 90, 162, 253, 43, 213, 189,
  162, 72, 191, 193, 239, 136, 112, 214, 82, 66, 226, 142, 40, 23, 252, 8,
  50, 6, 87, 218, 172, 71, 135, 238, 166, 141, 29, 247, 101, 11, 70, 177,
  143, 40, 155, 192, 200, 63, 176, 152, 64, 246, 162, 117, 179, 96, 251, 105,
  166, 28, 99, 213, 185, 197, 6, 82, 111, 239, 25, 169, 109, 157, 69, 183,
  79, 95, 174, 98, 22, 42, 173, 104, 9, 214, 31, 230, 188, 249, 16, 131,
  161, 66, 55, 249, 196, 157, 233, 65, 33, 103, 1, 214, 4, 109, 42, 159,
  134, 234, 220, 149, 212, 64, 83, 40, 6, 44, 172, 230, 56, 162, 80, 248,
  23, 208, 1, 117, 205, 56, 96, 236, 62, 73, 127, 245, 195, 235, 51, 15,
  86, 113, 209, 111, 74, 172, 54, 92, 109, 7, 19, 194, 144, 173, 73, 60,
  66, 116, 132, 104, 52, 7, 17, 117, 145, 79, 233, 12, 96, 140, 155, 24,
  254, 119, 165, 220, 243, 10, 183, 234, 207, 11, 39, 110, 5, 132, 147, 205,
  51, 65, 240, 254, 160, 41, 115, 216, 68, 12, 128, 37, 175, 21, 215, 235,
  215, 190, 116, 235, 94, 64, 152, 194, 92, 52, 146, 82, 99, 17, 136, 40,
  28, 16, 171, 160, 98, 35, 164, 117, 93, 200, 59, 189, 124, 132, 190, 81,
  190, 20, 29, 114, 146, 73, 27, 124, 214, 23, 229, 159, 48, 189, 137, 19,
  178, 77, 211, 168, 133, 172, 3, 98, 131, 36, 18, 203, 113, 65, 143, 146,
  184, 13, 133, 64, 16, 247, 27, 207, 47, 124, 62, 211, 83, 99, 182, 237,
  148, 25, 42, 184, 18, 211, 108, 185, 103, 100, 213, 179, 254, 40, 176, 57,
  108, 1, 81, 44, 222, 35, 125, 98, 223, 191, 138, 154, 22, 73, 218, 51,
  96, 3, 121, 188, 161, 26, 101, 247, 246, 132, 54, 217, 39, 122, 1, 245,
  10, 27, 252, 183, 130, 120, 3, 180, 129, 244, 204, 186, 228, 196, 58, 220,
  137, 110, 232, 44, 216, 140, 80, 247, 113, 37, 175, 15, 206, 174, 251, 62,
  57, 107, 241, 151, 67, 9, 96, 253, 18, 164, 217, 179, 216, 116, 213, 55,
  12, 248, 232, 70, 179, 114, 207, 240, 154, 60, 107, 161, 104, 217, 40, 4,
  143, 46, 80, 58, 131, 212, 117, 76, 96, 120, 30, 196, 149, 106, 77, 53,
  35, 188, 196, 175, 133, 106, 41, 65, 150, 1, 98, 47, 126, 230, 157, 201,
  97, 167, 204, 149, 86, 14, 124, 228, 247, 181, 224, 36, 137, 230, 91, 74,
  55, 73, 5, 140, 205, 125, 61, 30, 93, 153, 32, 234, 117, 206, 9, 19,
  178, 12, 60, 119, 97, 121, 161, 144, 11, 62, 19, 229, 72, 213, 247, 134,
  197, 57, 108, 228, 70, 12, 125, 201, 85, 202, 41, 213, 48, 138, 184, 205,
  240, 122, 78, 171, 41, 191, 239, 12, 110, 119, 84, 35, 206, 177, 140, 152,
  183, 100, 165, 215, 85, 29, 8, 148, 180, 238, 224, 134, 247, 204, 228, 92,
  90, 225, 118, 180, 250, 25, 51, 179, 178, 101, 244, 154, 232, 220, 91, 185,
  134, 31, 152, 248, 124, 208, 23, 241, 203, 72, 27, 89, 192, 26, 33, 212,
  202, 25, 121, 235, 196, 133, 168, 17, 50, 233, 28, 92, 182, 169, 252, 15,
  152, 58, 219, 120, 113, 86, 8, 72, 207, 224, 105, 136, 176, 83, 227, 14,
  166, 158, 231, 254, 177, 88, 195, 37, 105, 168, 191, 125, 33, 115, 23, 155,
  248, 176, 73, 26, 167, 243, 152, 88, 168, 141, 74, 7, 118, 61, 250, 212,
  133, 38, 26, 16, 176, 51, 204, 150, 154, 255, 120, 61, 25, 166, 243, 65,
  88, 37, 115, 24, 209, 123, 49, 166, 126, 255, 44, 9, 28, 76, 156, 50,
  229, 195, 219, 1, 14, 208, 236, 89, 134, 38, 70, 1, 200, 24, 6, 114,
  86, 54, 110, 74, 178, 209, 235, 160, 59, 210, 225, 226, 10, 111, 162, 84,
  229, 130, 70, 177, 103, 75, 188, 46, 104, 159, 99, 164, 100, 12, 53, 122,
  226, 196, 167, 92, 48, 155, 112, 172, 78, 63, 40, 4, 98, 221, 74, 144,
  24, 39, 212, 96, 145, 59, 217, 251, 255, 36, 85, 76, 13, 91, 193, 172,
  129, 30, 123, 95, 17, 185, 54, 107, 235, 104, 180, 51, 14, 169, 149, 91,
  202, 182, 92, 210, 130, 193, 123, 85, 49, 2, 208, 226, 112, 14, 86, 43,
  157, 202, 129, 52, 249, 53, 99, 46, 200, 87, 31, 74, 169, 167, 120, 141,
  100, 176, 150, 11, 29, 163, 88, 156, 221, 52, 168, 230, 174, 115, 45, 248,
  1, 128, 232, 215, 62, 169, 16, 85, 174, 189, 143, 120, 77, 63, 242, 142,
  38, 2, 56, 85, 209, 151, 52, 244, 77, 193, 113, 9, 219, 194, 160, 34,
  22, 34, 250, 164, 233, 225, 222, 190, 182, 251, 163, 118, 146, 64, 244, 181,
  137, 67, 107, 208, 239, 75, 18, 4, 205, 200, 139, 159, 56, 102, 234, 148,
  198, 9, 147, 182, 234, 143, 224, 43, 254, 24, 121, 155, 211, 106, 72, 19,
  81, 7, 194, 138, 184, 196, 62, 109, 228, 99, 161, 89, 72, 178, 4, 93,
  95, 174, 22, 226, 125, 71, 182, 93, 7, 184, 105, 152, 121, 27, 233, 220,
  33, 183, 26, 240, 63, 121, 81, 102, 61, 97, 166, 199, 233, 167, 159, 57,
  19, 195, 244, 105, 20, 253, 137, 58, 102, 51, 229, 76, 236, 131, 32, 202,
  145, 67, 24, 211, 217, 231, 134, 59, 106, 146, 127, 60, 31, 71, 216, 150,
  124, 162, 110, 27, 94, 187, 71, 16, 228, 50, 151, 165, 143, 11, 17, 180,
  122, 201, 192, 28, 164, 142, 181, 219, 109, 21, 93, 5, 43, 68, 176, 199,
  127, 22, 89, 150, 199, 84, 101, 215, 3, 133, 148, 96, 162, 83, 120, 45,
  77, 21, 105, 60, 34, 168, 252, 5, 153, 69, 36, 224, 160, 132, 24, 244,
  57, 151, 75, 225, 135, 155, 239, 34, 171, 67, 10, 116, 66, 39, 61, 251,
  94, 147, 55, 69, 171, 32, 215, 242, 140, 249, 48, 79, 217, 68, 189, 245,
  95, 147, 221, 37, 205, 125, 219, 46, 28, 83, 220, 146, 182, 90, 61, 3,
  95, 195, 123, 255, 187, 88, 118, 23, 163, 186, 140, 213, 8, 58, 153, 83,
  81, 57, 154, 186, 231, 249, 46, 126, 134, 29, 116, 44, 67, 141, 43, 97,
  2, 106, 240, 89, 117, 243, 83, 65, 187, 198, 150, 111, 238, 86, 30, 141,
  220, 244, 79, 64, 60, 225, 67, 6, 29, 97, 179, 194, 50, 253, 204, 105,
  242, 117, 148, 163, 31, 222, 126, 238, 3, 245, 30, 195, 37, 218, 188, 53,
  45, 185, 111, 122, 199, 252, 63, 176, 221, 19, 222, 84, 194, 140, 192, 69,
  10, 241, 135, 206, 137, 78, 227, 42, 125, 188, 216, 31, 108, 35, 129, 128,
  151, 191, 127, 45, 231, 14, 64, 168, 144, 167, 252, 44, 67, 171, 153, 123,
  135, 210, 1, 173, 3, 111, 242, 170, 26, 68, 203, 84, 245, 208, 116, 129,
  209, 38, 191, 129, 31, 218, 62, 156, 108, 80, 184, 203, 60, 106, 174, 214,
  54, 241, 175, 132, 110, 206, 53, 226, 170, 140, 216, 233, 250, 221, 101, 127,
  10, 40, 87, 135, 241, 47, 139, 25, 172, 75, 218, 229, 146, 8, 23, 222,
  215, 39, 225, 192, 66, 145, 144, 90, 103, 187, 59, 135, 175, 115, 231, 111,
  5, 193, 139, 216, 11, 110, 25, 210, 41, 244, 136, 196, 147, 112, 2, 149,
  122, 175, 213, 104, 197, 192, 153, 9, 235, 5, 152, 75, 198, 2, 95, 18,
  4, 237, 75, 138, 159, 91, 107, 164, 186, 118, 2, 199, 222, 99, 34, 250,
  57, 190, 19, 102, 158, 37, 69, 180, 16, 249, 33, 236, 232, 161, 45, 112,
  13, 252, 237, 70, 208, 103, 138, 158, 211, 2, 241, 84, 91, 198, 253, 238,
  71, 222, 149, 35, 32, 6, 151, 46, 44, 78, 253, 55, 15, 157, 63, 185,
  165, 186, 183, 227, 126, 163, 177, 158, 240, 112, 46, 56, 236, 191, 144, 71,
  218, 246, 113, 150, 245, 97, 33, 117, 252, 36, 9, 210, 5, 14, 83, 139,
  248, 187, 83, 25, 196, 115, 156, 49, 21, 4, 41, 147, 191, 52, 210, 146,
  112, 30, 166, 200, 40, 49, 70, 141, 104, 215, 144, 228, 110, 92, 43, 168,
  195, 237, 54, 104, 66, 53, 236, 193, 228, 241, 57, 48, 234, 99, 215, 242,
  113, 240, 51, 190, 45, 11, 237, 206, 212, 62, 228, 150, 245, 47, 103, 200,
  72, 113, 226, 222, 1, 156, 27, 118, 177, 88, 49, 116, 175, 240, 150, 109,
  157, 52, 139, 181, 252, 6, 151, 135, 164, 94, 193, 232, 192, 116, 85, 202,
  133, 192, 117, 99, 151, 248, 123, 162, 107, 167, 223, 155, 9, 69, 39, 210,
  171, 27, 230, 108, 228, 195, 15, 20, 208, 209, 128, 102, 169, 202, 43, 254,
  63, 205, 45, 2, 240, 33, 105, 17, 110, 93, 250, 134, 38, 230, 22, 78,
  38, 88, 253, 224, 185, 8, 81, 219, 76, 186, 173, 32, 114, 62, 153, 227,
  246, 42, 68, 211, 40, 203, 254, 144, 108, 149, 115, 196, 177, 50, 125, 201,
  32, 112, 204, 172, 182, 84, 152, 66, 72, 196, 149, 246, 186, 14, 122, 138,
  253, 165, 138, 202, 111, 59, 179, 234, 18, 137, 237, 160, 139, 254, 192, 117,
  72, 235, 227, 121, 60, 169, 19, 166, 11, 97, 54, 152, 16, 239, 160, 209,
  160, 25, 221, 255, 45, 75, 83, 56, 181, 203, 6, 101, 23, 136, 112, 50,
  11, 45, 141, 76, 148, 185, 53, 133, 25, 159, 78, 187, 220, 103, 178, 52,
  149, 172, 144, 216, 167, 243, 218, 132, 61, 174, 219, 204, 202, 127, 244, 135,
  14, 240, 137, 67, 115, 174, 255, 28, 134, 183, 52, 84, 199, 252, 27, 78,
  26, 179, 145, 96, 81, 151, 183, 118, 138, 187, 84, 56, 90, 23, 34, 173,
  93, 70, 159, 248, 133, 29, 59, 170, 102, 124, 75, 31, 58, 148, 68, 225,
  33, 52, 24, 2, 77, 135, 45, 252, 112, 169, 14, 208, 56, 20, 93, 70,
  201, 4, 10, 172, 112, 115, 88, 36, 178, 26, 141, 99, 176, 76, 22, 110,
  164, 228, 73, 195, 197, 240, 217, 4, 27, 53, 85, 242, 120, 163, 87, 152,
  181, 81, 49, 203, 60, 223, 161, 93, 95, 162, 56, 134, 123, 229, 70, 156,
  72, 117, 107, 179, 183, 91, 70, 8, 192, 67, 225, 113, 106, 166, 1, 87,
  116, 177, 158, 33, 196, 231, 156, 69, 124, 39, 4, 235, 16, 189, 210, 143,
  131, 124, 174, 11, 163, 112, 8, 28, 168, 221, 2, 18, 7, 156, 140, 78,
  142, 34, 3, 219, 100, 236, 120, 218, 117, 176, 4, 40, 94, 210, 169, 28,
  106, 188, 92, 110, 215, 204, 75, 166, 61, 22, 224, 251, 206, 214, 10, 36,
  84, 103, 212, 44, 196, 67, 211, 226, 66, 34, 215, 247, 254, 119, 63, 18,
  89, 46, 52, 12, 109, 134, 19, 166, 198, 142, 47, 72, 188, 205, 234, 245,
  41, 84, 219, 145, 16, 19, 96, 152, 217, 7, 164, 147, 39, 226, 37, 112,
  19, 162, 9, 160, 129, 203, 186, 168, 99, 48, 118, 60, 143, 54, 84, 40,
  249, 184, 95, 60, 101, 142, 35, 205, 37, 17, 94, 179, 182, 20, 3, 154,
  89, 44, 51, 128, 247, 166, 159, 43, 109, 154, 226, 63, 3, 32, 148, 171,
  195, 252, 52, 98, 131, 41, 184, 220, 173, 50, 146, 187, 42, 6, 53, 20,
  134, 83, 28, 128, 124, 162, 143, 79, 209, 216, 167, 42, 178, 73, 8, 43,
  174, 80, 9, 236, 129, 91, 251, 98, 150, 195, 5, 48, 243, 130, 224, 8,
  8, 20, 124, 121, 54, 94, 178, 111, 40, 200, 10, 140, 218, 7, 18, 60,
  61, 180, 165, 79, 239, 72, 177, 138, 132, 18, 126, 100, 80, 200, 174, 244,
  44, 161, 208, 125, 253, 232, 50, 65, 242, 199, 58, 236, 151, 119, 108, 215,
  25, 45, 209, 160, 128, 147, 1, 29, 123, 208, 155, 99, 86, 107, 204, 139,
  143, 182, 248, 101, 238, 97, 76, 200, 197, 67, 119, 92, 198, 122, 47, 250,
  154, 119, 18, 140, 254, 26, 92, 157, 222, 235, 69, 101, 251, 160, 161, 132,
  105, 63, 154, 232, 31, 203, 38, 238, 47, 153, 186, 32, 140, 185, 152, 19,
  33, 46, 220, 114, 2, 65, 126, 180, 140, 189, 90, 53, 51, 71, 78, 198,
  183, 185, 215, 36, 15, 193, 122, 43, 82, 64, 115, 3, 168, 230, 157, 236,
  255, 17, 237, 98, 120, 46, 63, 249, 201, 241, 42, 89, 30, 1, 149, 191,
  112, 209, 95, 137, 214, 154, 98, 37, 221, 159, 24, 139, 234, 249, 69, 207,
  193, 165, 108, 132, 192, 167, 221, 93, 140, 61, 66, 1, 225, 73, 163, 223,
  69, 239, 6, 191, 110, 91, 5, 49, 142, 217, 41, 252, 58, 188, 129, 214,
  89, 33, 165, 227, 16, 121, 174, 64, 48, 137, 194, 115, 114, 233, 85, 217,
  196, 16, 161, 44, 91, 163, 230, 1, 200, 13, 243, 131, 119, 245, 219, 228,
  107, 199, 244, 143, 64, 221, 28, 41, 122, 101, 255, 30, 42, 133, 89, 182,
  232, 147, 249, 66, 250, 24, 225, 148, 159, 247, 212, 165, 90, 204, 141, 97,
  142, 194, 10, 106, 170, 166, 216, 109, 75, 231, 192, 50, 135, 118, 86, 215,
  231, 251, 53, 73, 75, 28, 128, 10, 184, 94, 11, 170, 5, 163, 18, 177,
  222, 15, 65, 120, 247, 53, 239, 75, 243, 232, 216, 171, 246, 63, 41, 117,
  172, 19, 150, 222, 161, 212, 16, 116, 31, 178, 169, 9, 220, 77, 94, 100,
  15, 181, 74, 221, 205, 65, 231, 99, 17, 1, 88, 244, 191, 178, 105, 54,
  247, 217, 181, 68, 220, 55, 103, 149, 78, 120, 85, 82, 54, 104, 95, 147,
  148, 29, 82, 186, 155, 168, 197, 231, 170, 217, 228, 70, 156, 25, 225, 118,
  61, 86, 173, 65, 144, 67, 169, 219, 239, 104, 55, 186, 37, 127, 182, 68,
  22, 122, 38, 94, 205, 57, 243, 26, 235, 12, 110, 82, 225, 251, 40, 130,
  254, 181, 59, 109, 223, 126, 81, 136, 239, 120, 104, 3, 20, 103, 62, 15,
  87, 55, 56, 148, 229, 90, 46, 10, 13, 105, 149, 130, 72, 97, 5, 50,
  98, 86, 123, 243, 233, 121, 186, 45, 120, 93, 225, 4, 62, 206, 244, 20,
  207, 129, 5, 109, 87, 163, 208, 44, 39, 175, 95, 143, 234, 91, 141, 57,
  249, 86, 115, 67, 142, 164, 255, 87, 121, 145, 81, 76, 171, 193, 246, 212,
  234, 20, 92, 55, 105, 95, 73, 35, 93, 213, 79, 14, 138, 74, 194, 187,
  202, 71, 95, 190, 105, 177, 128, 28, 29, 114, 35, 241, 38, 143, 93, 30,
  160, 232, 101, 199, 158, 238, 74, 124, 207, 224, 153, 114, 92, 121, 66, 146,
  193, 43, 131, 212, 6, 30, 252, 155, 241, 35, 194, 158, 228, 86, 140, 152,
  195, 236, 6, 136, 22, 197, 172, 175, 96, 211, 203, 51, 145, 207, 113, 226,
  204, 30, 38, 61, 153, 137, 1, 202, 175, 27, 75, 147, 29, 189, 82, 223,
  21, 180, 238, 242, 209, 79, 155, 179, 127, 130, 71, 198, 167, 214, 185, 250,
  176, 15, 148, 141, 205, 108, 183, 5, 182, 144, 37, 170, 159, 236, 46, 26,
  146, 132, 190, 127, 171, 158, 31, 253, 131, 237, 163, 128, 216, 240, 96, 106,
  103, 254, 172, 153, 58, 149, 2, 129, 98, 84, 145, 224, 49, 150, 244, 174,
  168, 222, 55, 131, 35, 85, 4, 213, 71, 116, 54, 21, 190, 167, 32, 204,
  233, 31, 123, 171, 237, 74, 51, 169, 133, 57, 27, 89, 182, 211, 201, 229,
  23, 212, 180, 164, 109, 254, 126, 58, 34, 127, 79, 241, 18, 220, 102, 83,
  73, 1, 216, 155, 64, 87, 25, 70, 139, 59, 213, 181, 240, 133, 114, 74,
  224, 56, 19, 81, 24, 108, 134, 60, 61, 12, 215, 232, 76, 82, 201, 147,
  189, 197, 210, 30, 39, 198, 6, 80, 250, 58, 221, 7, 133, 66, 107, 4,
  68, 214, 167, 45, 125, 238, 219, 185, 23, 38, 241, 179, 17, 120, 162, 145,
  26, 16, 41, 132, 235, 78, 175, 194, 137, 77, 11, 237, 1, 70, 110, 191,
  242, 6, 182, 77, 184, 105, 144, 172, 250, 129, 34, 179, 64, 8, 221, 67,
  153, 13, 79, 92, 197, 85, 178, 42, 217, 80, 165, 185, 34, 176, 122, 68,
  48, 98, 242, 118, 133, 213, 159, 74, 170, 188, 2, 238, 44, 162, 190, 248,
  165, 184, 135, 235, 245, 160, 80, 210, 230, 107, 33, 208, 15, 164, 103, 158,
  123, 156, 171, 73, 10, 107, 241, 226, 255, 25, 192, 111, 23, 118, 8, 38,
  98, 231, 64, 40, 57, 126, 158, 233, 225, 195, 21, 99, 53, 127, 89, 191,
  204, 109, 7, 249, 49, 1, 144, 183, 102, 56, 147, 206, 245, 62, 12, 43,
  118, 44, 216, 226, 91, 251, 17, 214, 57, 158, 187, 196, 209, 207, 125, 227,
  28, 3, 48, 65, 62, 31, 188, 211, 176, 59, 140, 197, 24, 136, 183, 44,
  189, 32, 1, 213, 71, 245, 46, 227, 175, 180, 36, 76, 29, 235, 47, 96,
  11, 157, 36, 119, 176, 68, 187, 234, 245, 12, 201, 100, 82, 251, 191, 161,
  72, 55, 227, 167, 224, 37, 117, 192, 157, 180, 255, 162, 105, 232, 170, 152,
  135, 223, 189, 116, 247, 63, 144, 2, 90, 188, 27, 49, 13, 164, 229, 197,
  190, 96, 213, 174, 235, 248, 71, 223, 239, 94, 184, 130, 50, 41, 199, 173,
  246, 32, 203, 159, 175, 248, 61, 153, 154, 27, 77, 108, 113, 205, 86, 149,
  76, 246, 213, 59, 113, 42, 199, 229, 1, 135, 48, 189, 13, 208, 211, 33,
  186, 212, 247, 91, 175, 1, 107, 137, 189, 47, 87, 227, 51, 125, 214, 151,
  16, 64, 246, 238, 121, 164, 206, 130, 102, 247, 226, 23, 141, 255, 148, 188,
  250, 237, 218, 131, 64, 91, 42, 244, 54, 125, 85, 152, 202, 26, 121, 214,
  17, 12, 209, 111, 102, 52, 205, 10, 85, 127, 65, 13, 251, 36, 79, 14,
  153, 36, 110, 243, 193, 77, 230, 104, 162, 136, 43, 249, 96, 253, 183, 22,
  125, 97, 62, 146, 172, 122, 201, 34, 25, 242, 101, 60, 151, 123, 136, 65,
  40, 57, 81, 117, 24, 75, 230, 104, 229, 47, 87, 124, 21, 39, 3, 223,
  116, 88, 131, 154, 108, 184, 21, 130, 92, 233, 138, 126, 74, 139, 179, 96,
  58, 119, 143, 240, 236, 69, 193, 115, 253, 29, 154, 68, 88, 163, 73, 206,
  195, 82, 145, 111, 220, 138, 55, 97, 116, 224, 39, 157, 7, 173, 101, 198,
  103, 71, 169, 178, 7, 150, 194, 24, 146, 47, 19, 230, 151, 57, 31, 129,
  113, 88, 39, 253, 231, 132, 141, 95, 46, 130, 24, 218, 194, 190, 219, 126,
  83, 30, 203, 9, 177, 1, 86, 151, 97, 67, 199, 216, 125, 145, 80, 106,
  132, 227, 29, 194, 100, 12, 23, 187, 168, 35, 155, 3, 102, 211, 84, 229,
  208, 59, 100, 1, 123, 137, 200, 222, 242, 218, 13, 58, 69, 233, 134, 111,
  31, 201, 161, 180, 222, 171, 14, 81, 220, 63, 243, 106, 102, 62, 170, 252,
  198, 173, 99, 155, 23, 234, 90, 157, 127, 111, 2, 196, 104, 13, 233, 248,
  114, 150, 66, 142, 26, 12, 190, 88, 200, 14, 100, 90, 56, 124, 222, 77,
  206, 21, 59, 89, 138, 106, 122, 198, 181, 135, 217, 80, 9, 77, 111, 233,
  185, 146, 199, 134, 71, 249, 21, 176, 60, 106, 207, 229, 136, 35, 22, 83,
  37, 168, 239, 78, 128, 46, 202, 166, 158, 7, 211, 126, 35, 213, 139, 55,
  74, 48, 9, 241, 129, 157, 51, 90, 207, 114, 218, 69, 17, 244, 180, 11,
  142, 165, 191, 210, 83, 188, 15, 37, 207, 161, 184, 136, 50, 250, 177, 173,
  231, 34, 100, 5, 253, 51, 156, 80, 79, 206, 176, 22, 238, 32, 146, 119,
  198, 111, 188, 54, 24, 135, 229, 13, 102, 202, 215, 120, 141, 106, 94, 193,
  111, 64, 237, 46, 38, 168, 192, 115, 122, 167, 191, 198, 66, 231, 9, 219,
  116, 244, 9, 227, 104, 123, 250, 4, 166, 237, 74, 52, 118, 23, 249, 109,
  76, 193, 59, 212, 54, 254, 238, 93, 136, 225, 88, 187, 45, 120, 255, 153,
  11, 215, 158, 25, 181, 116, 170, 201, 55, 183, 232, 136, 109, 35, 79, 119,
  146, 246, 44, 224, 53, 188, 148, 97, 231, 78, 135, 12, 242, 7, 90, 226,
  238, 164, 28, 160, 126, 214, 49, 4, 151, 17, 201, 241, 148, 142, 247, 5,
  183, 173, 214, 24, 223, 127, 74, 171, 35, 216, 149, 227, 59, 232, 123, 207,
  246, 219, 26, 235, 182, 163, 184, 156, 62, 67, 251, 166, 250, 101, 183, 231,
  21, 181, 153, 15, 5, 90, 81, 76, 112, 17, 86, 145, 92, 194, 120, 25,
  97, 193, 55, 91, 200, 132, 140, 203, 101, 98, 46, 5, 179, 3, 63, 171,
  99, 44, 222, 74, 100, 210, 9, 23, 167, 248, 118, 49, 130, 234, 176, 103,
  251, 44, 227, 101, 255, 139, 46, 58, 175, 9, 124, 27, 187, 223, 253, 205,
  71, 192, 51, 143, 32, 38, 15, 82, 42, 199, 105, 116, 35, 158, 99, 182,
  54, 249, 114, 1, 132, 161, 239, 163, 76, 218, 131, 190, 121, 166, 63, 180,
  119, 147, 133, 1, 14, 32, 103, 249, 125, 199, 172, 187, 203, 9, 190, 43,
  77, 140, 7, 58, 118, 224, 253, 45, 191, 41, 17, 83, 171, 30, 1, 53,
  140, 175, 89, 69, 152, 29, 207, 210, 1, 254, 60, 65, 50, 157, 245, 134,
  158, 135, 187, 42, 218, 13, 87, 176, 154, 27, 206, 136, 153, 88, 144, 201,
  137, 81, 1, 232, 126, 47, 201, 169, 105, 134, 7, 214, 91, 8, 207, 78,
  177, 39, 202, 137, 106, 26, 77, 84, 156, 96, 71, 31, 150, 32, 167, 6,
  204, 127, 29, 147, 165, 227, 131, 103, 214, 52, 241, 30, 72, 140, 128, 58,
  189, 65, 222, 37, 246, 157, 42, 83, 9, 95, 51, 227, 66, 194, 193, 19,
  197, 101, 39, 235, 186, 146, 36, 229, 76, 5, 57, 251, 86, 19, 167, 155,
  153, 160, 125, 42, 51, 85, 100, 66, 129, 154, 16, 230, 69, 137, 218, 43,
  118, 224, 241, 201, 137, 36, 250, 240, 37, 218, 129, 234, 43, 187, 100, 166,
  22, 174, 222, 66, 62, 186, 45, 68, 189, 95, 212, 255, 239, 221, 48, 80,
  162, 180, 31, 154, 50, 156, 140, 184, 65, 33, 199, 28, 185, 29, 213, 56,
  92, 65, 117, 145, 238, 216, 149, 1, 204, 211, 239, 112, 138, 62, 95, 233,
  101, 2, 237, 87, 50, 244, 216, 194, 189, 151, 175, 96, 171, 26, 198, 220,
  141, 106, 204, 90, 100, 186, 29, 72, 105, 48, 115, 165, 41, 231, 104, 91,
  83, 58, 244, 78, 51, 93, 137, 194, 129, 102, 96, 18, 138, 70, 109, 247,
  65, 200, 59, 29, 165, 143, 223, 61, 130, 52, 238, 204, 195, 70, 186, 5,
  170, 51, 142, 193, 246, 84, 156, 189, 33, 106, 55, 249, 14, 35, 253, 61,
  173, 77, 205, 110, 106, 49, 84, 121, 162, 107, 14, 75, 124, 214, 51, 234,
  18, 113, 101, 196, 27, 79, 197, 124, 131, 150, 102, 41, 181, 128, 80, 164,
  200, 93, 218, 157, 20, 2, 249, 206, 134, 192, 51, 28, 166, 99, 37, 199,
  17, 170, 121, 75, 138, 48, 109, 213, 94, 33, 187, 210, 195, 80, 160, 36,
  94, 221, 12, 169, 23, 7, 175, 73, 162, 192, 219, 77, 13, 39, 251, 18,
  255, 88, 16, 23, 177, 253, 41, 150, 181, 12, 63, 164, 225, 20, 72, 245,
  104, 187, 225, 220, 47, 71, 122, 248, 222, 11, 241, 175, 87, 32, 228, 60,
  19, 209, 147, 230, 24, 138, 103, 73, 93, 13, 214, 117, 161, 18, 183, 132,
  148, 183, 10, 120, 29, 6, 57, 160, 139, 185, 21, 197, 102, 251, 143, 39,
  144, 170, 96, 209, 244, 16, 85, 141, 84, 230, 242, 3, 132, 82, 253, 4,
  8, 163, 228, 24, 67, 85, 48, 140, 82, 155, 97, 174, 60, 126, 61, 22,
  234, 61, 179, 223, 19, 79, 228, 207, 155, 100, 162, 68, 249, 168, 114, 236,
  232, 109, 143, 199, 178, 70, 64, 154, 56, 235, 96, 98, 128, 118, 206, 211,
  99, 61, 224, 200, 120, 174, 28, 130, 112, 228, 117, 29, 192, 81, 49, 148,
  126, 92, 2, 167, 159, 21, 12, 236, 97, 33, 76, 124, 146, 112, 217, 38,
  107, 82, 127, 1, 206, 104, 57, 6, 53, 233, 158, 178, 196, 126, 236, 102,
  253, 220, 228, 89, 248, 190, 163, 233, 126, 149, 236, 216, 177, 194, 78, 165,
  186, 58, 11, 21, 38, 166, 55, 110, 163, 219, 125, 60, 208, 34, 152, 237,
  242, 107, 98, 191, 194, 213, 179, 100, 254, 195, 66, 42, 94, 5, 250, 190,
  129, 6, 45, 157, 130, 56, 169, 117, 124, 9, 205, 27, 54, 110, 21, 191,
  31, 187, 116, 145, 102, 117, 233, 253, 35, 158, 20, 200, 182, 92, 69, 236,
  160, 48, 179, 231, 10, 206, 68, 91, 204, 134, 80, 246, 166, 217, 15, 42,
  152, 37, 233, 113, 180, 206, 86, 110, 155, 31, 90, 181, 123, 144, 252, 174,
  177, 23, 244, 70, 212, 173, 39, 235, 144, 32, 208, 172, 222, 151, 67, 94,
  141, 19, 35, 33, 40, 196, 137, 210, 93, 50, 47, 240, 156, 96, 1, 30,
  249, 157, 236, 77, 155, 235, 217, 178, 19, 190, 198, 68, 218, 62, 97, 30,
  63, 34, 144, 73, 49, 153, 165, 114, 230, 121, 15, 210, 143, 133, 229, 219,
  201, 112, 253, 83, 245, 186, 10, 89, 141, 252, 203, 55, 85, 211, 16, 136,
  40, 50, 225, 59, 209, 43, 198, 133, 1, 248, 127, 139, 173, 103, 146, 53,
  67, 132, 121, 176, 219, 236, 94, 50, 156, 73, 221, 38, 208, 98, 113, 100,
  177, 201, 148, 114, 1, 216, 115, 39, 127, 96, 189, 176, 173, 81, 44, 128,
  146, 226, 98, 136, 160, 11, 42, 119, 242, 121, 49, 78, 97, 41, 182, 248,
  53, 83, 69, 181, 81, 76, 157, 115, 169, 108, 54, 26, 17, 86, 145, 56,
  127, 216, 172, 251, 220, 75, 133, 87, 171, 109, 72, 233, 246, 114, 108, 200,
  74, 247, 7, 168, 245, 125, 83, 164, 178, 52, 81, 4, 17, 193, 241, 127,
  208, 251, 118, 232, 126, 137, 31, 172, 41, 218, 149, 240, 25, 177, 239, 139,
  36, 21, 228, 125, 234, 71, 196, 30, 120, 202, 10, 134, 220, 45, 207, 252,
  202, 25, 139, 158, 110, 195, 175, 7, 241, 52, 198, 89, 11, 239, 71, 170,
  93, 234, 133, 205, 3, 134, 169, 179, 9, 213, 75, 244, 190, 78, 203, 63,
  96, 131, 123, 217, 83, 202, 27, 162, 95, 221, 108, 195, 227, 30, 80, 2,
  134, 25, 103, 150, 223, 131, 28, 38, 243, 71, 211, 152, 99, 138, 65, 125,
  107, 61, 92, 148, 52, 39, 106, 247, 139, 241, 32, 64, 66, 51, 36, 182,
  54, 131, 162, 90, 142, 21, 151, 189, 171, 41, 110, 248, 104, 169, 3, 76,
  102, 64, 86, 167, 229, 1, 46, 154, 92, 144, 57, 67, 70, 11, 145, 120,
  86, 140, 25, 242, 217, 159, 33, 87, 88, 47, 172, 78, 130, 68, 82, 240,
  218, 163, 69, 27, 21, 222, 144, 40, 135, 211, 234, 185, 152, 178, 53, 136,
  161, 55, 19, 48, 196, 227, 91, 150, 197, 36, 142, 28, 239, 8, 20, 212,
  68, 180, 22, 54, 56, 114, 247, 101, 174, 3, 31, 135, 200, 155, 62, 141,
  1, 219, 43, 113, 191, 254, 105, 235, 36, 7, 161, 92, 2, 41, 232, 184,
  73, 191, 43, 13, 5, 24, 158, 147, 121, 90, 160, 10, 211, 94, 143, 240,
  69, 38, 197, 13, 188, 80, 53, 240, 203, 115, 148, 78, 217, 45, 152, 225,
  37, 152, 133, 20, 74, 247, 217, 95, 4, 174, 8, 250, 77, 163, 107, 63,
  191, 212, 75, 15, 188, 144, 52, 97, 213, 243, 177, 26, 60, 108, 113, 185,
  56, 3, 188, 90, 180, 62, 95, 237, 131, 108, 8, 169, 45, 118, 26, 106,
  80, 245, 88, 15, 72, 98, 254, 35, 237, 64, 157, 105, 255, 131, 145, 103,
  45, 12, 205, 238, 74, 211, 229, 188, 159, 190, 213, 44, 171, 128, 75, 223,
  168, 241, 202, 238, 61, 170, 8, 198, 129, 199, 225, 114, 151, 252, 217, 207,
  138, 203, 226, 6, 115, 228, 183, 206, 188, 195, 42, 223, 1, 175, 26, 149,
  235, 159, 120, 222, 33, 214, 105, 10, 30, 113, 212, 226, 91, 59, 130, 185,
  183, 65, 222, 13, 59, 108, 181, 197, 111, 123, 206, 185, 255, 39, 212, 196,
  99, 155, 195, 167, 254, 124, 2, 171, 84, 224, 61, 147, 6, 32, 174, 152,
  215, 122, 233, 111, 116, 145, 75, 243, 124, 44, 77, 31, 92, 252, 212, 161,
  84, 208, 56, 211, 73, 149, 243, 4, 121, 82, 6, 168, 147, 74, 108, 194,
  48, 8, 105, 72, 110, 87, 125, 184, 148, 186, 116, 20, 163, 232, 216, 88,
  31, 59, 209, 188, 44, 245, 213, 58, 20, 192, 224, 204, 60, 208, 130, 79,
  2, 25, 63, 111, 46, 231, 250, 67, 20, 98, 179, 146, 135, 37, 161, 192,
  87, 57, 123, 221, 234, 208, 68, 182, 16, 111, 196, 220, 246, 43, 236, 154,
  18, 219, 14, 161, 142, 73, 5, 60, 28, 238, 47, 84, 23, 164, 62, 230,
  110, 62, 122, 16, 8, 93, 46, 27, 179, 67, 129, 150, 181, 156, 107, 229,
  240, 126, 105, 85, 151, 97, 2, 210, 82, 165, 107, 230, 115, 79, 46, 226,
  79, 107, 209, 172, 99, 136, 226, 57, 25, 199, 109, 210, 242, 162, 18, 50,
  113, 203, 149, 165, 251, 176, 154, 228, 99, 40, 164, 71, 150, 124, 179, 243,
  15, 229, 167, 73, 32, 85, 226, 128, 231, 12, 242, 159, 122, 90, 215, 24,
  122, 117, 243, 177, 15, 189, 95, 194, 205, 83, 165, 252, 224, 245, 204, 227,
  237, 180, 147, 207, 243, 56, 224, 86, 29, 160, 50, 122, 19, 198, 103, 12,
  193, 69, 178, 150, 125, 93, 190, 34, 66, 49, 221, 3, 106, 113, 134, 76,
  203, 81, 216, 80, 244, 184, 237, 223, 89, 101, 119, 215, 22, 58, 34, 210,
  159, 22, 66, 254, 238, 87, 193, 157, 242, 6, 37, 191, 13, 154, 220, 143,
  46, 14, 138, 117, 95, 221, 119, 207, 240, 132, 34, 158, 139, 10, 214, 170,
  197, 4, 58, 239, 220, 63, 77, 130, 16, 143, 59, 85, 185, 139, 47, 52,
  133, 70, 178, 117, 11, 67, 100, 142, 37, 64, 127, 82, 172, 182, 112, 246,
  173, 35, 89, 215, 123, 174, 57, 142, 53, 229, 71, 116, 145, 119, 40, 12,
  40, 108, 75, 252, 146, 141, 1, 102, 231, 88, 184, 173, 209, 70, 89, 128,
  22, 225, 88, 235, 243, 166, 176, 156, 122, 159, 98, 115, 153, 1, 180, 248,
  255, 183, 24, 176, 74, 111, 137, 138, 250, 38, 230, 14, 149, 85, 3, 205,
  162, 182, 1, 213, 30, 250, 184, 128, 65, 17, 64, 114, 189, 55, 248, 84,
  151, 192, 23, 249, 27, 164, 178, 40, 49, 68, 247, 185, 22, 116, 89, 232,
  169, 252, 91, 133, 26, 10, 34, 199, 225, 204, 255, 215, 7, 28, 109, 79,
  111, 34, 147, 247, 146, 175, 195, 180, 94, 119, 164, 72, 230, 18, 155, 16,
  239, 159, 168, 69, 104, 22, 202, 151, 129, 48, 14, 221, 86, 17, 70, 112,
  14, 132, 172, 18, 23, 118, 47, 161, 72, 129, 36, 244, 176, 135, 64, 186,
  91, 132, 43, 119, 24, 209, 233, 104, 173, 200, 184, 254, 40, 215, 202, 81,
  153, 136, 44, 226, 170, 55, 208, 123, 57, 168, 197, 11, 112, 79, 245, 135,
  60, 47, 140, 201, 142, 54, 34, 33, 209, 153, 205, 141, 196, 104, 168, 4,
  246, 93, 50, 169, 83, 136, 243, 207, 15, 143, 54, 68, 1, 106, 45, 188,
  37, 11, 139, 87, 117, 7, 229, 103, 138, 22, 249, 57, 68, 169, 186, 13,
  163, 60, 250, 85, 179, 95, 247, 100, 32, 147, 188, 50, 37, 173, 255, 221,
  220, 35, 16, 116, 218, 112, 253, 56, 178, 12, 77, 142, 36, 136, 82, 85,
  247, 185, 164, 118, 12, 215, 127, 45, 145, 252, 62, 21, 173, 69, 139, 108,
  47, 220, 225, 178, 161, 194, 17, 141, 81, 126, 102, 164, 105, 217, 232, 185,
  208, 67, 240, 162, 254, 54, 187, 84, 172, 98, 58, 220, 151, 103, 63, 207,
  181, 39, 19, 192, 47, 143, 72, 3, 199, 69, 94, 214, 31, 175, 34, 155,
  231, 67, 144, 113, 121, 63, 8, 218, 226, 156, 98, 186, 165, 215, 255, 195,
  110, 243, 172, 223, 21, 189, 164, 41, 214, 98, 47, 119, 85, 134, 81, 200,
  78, 182, 224, 138, 49, 211, 117, 140, 47, 113, 248, 219, 1, 71, 160, 96,
  181, 87, 243, 70, 235, 208, 29, 177, 37, 196, 252, 119, 118, 172, 21, 13,
  37, 76, 102, 63, 133, 197, 242, 3, 106, 222, 43, 162, 220, 104, 154, 205,
  37, 19, 241, 83, 216, 252, 35, 98, 193, 42, 240, 244, 104, 245, 53, 4,
  209, 184, 91, 99, 44, 210, 110, 29, 243, 139, 228, 18, 227, 70, 213, 40,
  11, 172, 236, 230, 213, 122, 153, 244, 4, 131, 18, 170, 206, 99, 238, 5,
  151, 36, 31, 201, 44, 232, 11, 158, 252, 163, 128, 39, 120, 225, 159, 75,
  239, 124, 203, 156, 75, 242, 135, 55, 177, 230, 197, 74, 226, 36, 196, 155,
  14, 17, 236, 198, 176, 41, 181, 228, 235, 69, 205, 144, 21, 115, 190, 103,
  59, 200, 108, 155, 2, 154, 168, 69, 169, 231, 84, 173, 38, 210, 153, 246,
  138, 32, 7, 155, 59, 86, 142, 166, 233, 79, 201, 6, 17, 89, 44, 244,
  5, 144, 169, 200, 50, 124, 91, 184, 67, 180, 11, 18, 95, 154, 152, 136,
  52, 7, 118, 36, 4, 128, 153, 170, 155, 28, 108, 68, 131, 23, 11, 177,
  71, 83, 210, 145, 197, 191, 150, 61, 64, 35, 154, 249, 224, 254, 54, 113,
  220, 178, 100, 12, 168, 104, 180, 65, 25, 197, 91, 224, 37, 22, 85, 116,
  24, 50, 79, 183, 92, 201, 129, 217, 161, 71, 3, 152, 26, 250, 56, 123,
  101, 40, 153, 119, 6, 18, 70, 152, 112, 10, 93, 165, 133, 196, 232, 58,
  165, 233, 137, 17, 115, 114, 47, 54, 51, 97, 14, 147, 188, 232, 202, 72,
  218, 231, 194, 83, 180, 58, 101, 239, 114, 113, 153, 74, 9, 204, 54, 188,
  118, 146, 65, 84, 16, 147, 237, 71, 142, 54, 224, 153, 207, 38, 76, 26,
  138, 249, 26, 117, 136, 230, 202, 76, 14, 186, 194, 94, 82, 251, 122, 161,
  108, 130, 49, 124, 12, 103, 86, 226, 180, 240, 109, 120, 95, 177, 138, 76,
  71, 152, 46, 132, 38, 16, 112, 236, 175, 202, 92, 10, 177, 155, 28, 217,
  108, 179, 38, 88, 255, 120, 171, 70, 76, 240, 14, 45, 101, 181, 224, 17,
  57, 192, 72, 148, 16, 108, 52, 30, 208, 174, 240, 212, 118, 74, 89, 137,
  184, 207, 126, 145, 49, 198, 180, 20, 39, 50, 234, 179, 247, 170, 55, 143,
  246, 123, 191, 81, 55, 217, 198, 95, 60, 116, 206, 11, 13, 255, 18, 207,
  253, 12, 48, 206, 213, 247, 111, 46, 233, 226, 120, 208, 49, 1, 254, 170,
  92, 3, 215, 31, 1, 203, 81, 56, 174, 48, 216, 51, 85, 21, 15, 113,
  237, 13, 157, 218, 40, 219, 229, 164, 70, 25, 139, 151, 179, 66, 251, 82,
  229, 203, 115, 254, 89, 253, 29, 127, 138, 26, 34, 230, 114, 129, 78, 96,
  1, 136, 127, 202, 132, 209, 106, 59, 122, 107, 25, 159, 142, 19, 97, 62,
  167, 33, 114, 2, 146, 66, 243, 38, 109, 44, 178, 7, 5, 164, 245, 207,
  33, 86, 103, 249, 132, 83, 106, 240, 214, 1, 104, 139, 211, 109, 204, 192,
  1, 131, 66, 214, 122, 161, 30, 141, 251, 229, 168, 149, 212, 52, 128, 68,
  221, 151, 143, 191, 239, 115, 177, 148, 89, 2, 135, 218, 97, 219, 199, 28,
  135, 106, 169, 160, 12, 75, 211, 178, 97, 132, 24, 180, 38, 226, 168, 217,
  202, 73, 127, 97, 137, 125, 105, 92, 183, 209, 57, 116, 220, 44, 98, 163,
  60, 184, 13, 79, 70, 149, 154, 161, 241, 105, 125, 59, 240, 166, 7, 55,
  149, 228, 63, 168, 185, 43, 206, 150, 208, 83, 252, 130, 5, 89, 80, 247,
  218, 201, 237, 254, 142, 180, 229, 200, 75, 251, 94, 131, 46, 216, 53, 97,
  215, 148, 11, 22, 121, 6, 250, 80, 242, 201, 96, 66, 123, 26, 156, 239,
  174, 202, 35, 160, 109, 65, 181, 241, 31, 94, 72, 192, 46, 134, 238, 163,
  125, 231, 62, 86, 52, 96, 78, 163, 9, 172, 112, 36, 34, 192, 87, 80,
  231, 55, 119, 66, 121, 159, 248, 234, 200, 13, 245, 238, 152, 201, 225, 62,
  178, 30, 33, 89, 147, 185, 207, 7, 100, 65, 171, 16, 234, 198, 53, 1,
  214, 170, 103, 30, 223, 57, 134, 193, 73, 212, 182, 160, 227, 35, 102, 196,
  244, 69, 213, 31, 91, 238, 27, 10, 175, 49, 219, 180, 174, 234, 147, 178,
  132, 25, 98, 65, 209, 162, 92, 121, 156, 110, 29, 36, 239, 185, 23, 157,
  131, 238, 68, 64, 129, 40, 209, 176, 124, 27, 174, 150, 89, 71, 4, 45,
  61, 27, 236, 112, 15, 47, 156, 226, 41, 99, 223, 129, 88, 111, 150, 182,
  107, 31, 69, 175, 138, 203, 32, 15, 189, 51, 61, 159, 134, 230, 156, 119,
  198, 241, 39, 185, 33, 105, 164, 140, 50, 79, 158, 124, 144, 182, 109, 72,
  52, 243, 168, 140, 250, 80, 29, 62, 239, 42, 193, 246, 126, 136, 24, 146,
  99, 88, 153, 179, 249, 204, 123, 69, 101, 23, 49, 157, 219, 131, 95, 248,
  23, 163, 116, 58, 121, 211, 220, 192, 218, 114, 236, 53, 162, 145, 35, 93,
  54, 158, 9, 102, 155, 26, 124, 242, 67, 15, 184, 168, 244, 55, 104, 3,
  254, 34, 161, 117, 251, 151, 236, 128, 187, 164, 157, 110, 99, 18, 65, 206,
  130, 179, 250, 40, 70, 64, 209, 103, 176, 57, 249, 137, 125, 151, 221, 136,
  106, 130, 73, 235, 229, 176, 197, 45, 211, 20, 64, 183, 25, 190, 33, 121,
  69, 114, 27, 37, 32, 195, 115, 250, 45, 49, 223, 244, 16, 221, 80, 123,
  107, 159, 68, 50, 165, 189, 104, 255, 204, 221, 241, 85, 132, 101, 212, 235,
  72, 209, 41, 86, 133, 110, 210, 185, 221, 74, 82, 24, 198, 9, 183, 176,
  39, 194, 154, 8, 167, 102, 131, 205, 109, 176, 182, 86, 113, 133, 32, 184,
  90, 252, 122, 204, 195, 43, 183, 210, 246, 64, 123, 107, 125, 82, 186, 175,
  152, 30, 7, 228, 182, 73, 42, 101, 194, 113, 62, 223, 229, 167, 15, 183,
  158, 26, 82, 53, 228, 245, 29, 93, 237, 199, 115, 48, 28, 71, 38, 16,
  27, 248, 215, 166, 68, 222, 59, 23, 99, 93, 187, 10, 167, 139, 90, 57,
  104, 41, 87, 193, 101, 163, 78, 6, 93, 150, 65, 167, 232, 242, 179, 96,
  135, 228, 87, 15, 51, 225, 20, 38, 110, 123, 28, 169, 36, 8, 252, 203,
  228, 206, 3, 51, 53, 47, 2, 208, 237, 187, 141, 244, 18, 58, 146, 107,
  137, 170, 78, 212, 4, 30, 34, 66, 248, 199, 160, 48, 111, 251, 237, 210,
  189, 143, 77, 161, 172, 68, 84, 62, 225, 213, 86, 139, 31, 220, 199, 80,
  74, 191, 93, 144, 130, 23, 199, 216, 241, 88, 46, 25, 219, 149, 245, 92,
  121, 75, 213, 8, 5, 177, 117, 196, 78, 189, 14, 23, 178, 56, 170, 97,
  13, 123, 129, 43, 181, 113, 108, 140, 72, 44, 133, 128, 157, 210, 79, 234,
  253, 142, 5, 176, 89, 130, 196, 235, 133, 20, 100, 229, 22, 90, 143, 42,
  176, 216, 201, 46, 74, 10, 88, 114, 141, 161, 148, 79, 162, 27, 184, 84,
  21, 139, 251, 173, 130, 84, 27, 164, 14, 171, 122, 205, 233, 66, 119, 43,
  99, 235, 241, 90, 153, 51, 95, 246, 115, 2, 77, 1, 54, 198, 6, 73,
  217, 35, 19, 202, 134, 4, 230, 91, 48, 206, 13, 151, 149, 42, 130, 231,
  100, 203, 224, 60, 163, 9, 61, 81, 10, 75, 140, 225, 52, 98, 134, 32,
  200, 169, 230, 105, 147, 140, 175, 33, 146, 92, 100, 219, 96, 254, 227, 195,
  75, 204, 165, 56, 145, 1, 94, 255, 238, 158, 251, 174, 3, 205, 101, 250,
  189, 157, 218, 236, 46, 64, 191, 149, 206, 188, 126, 8, 53, 146, 199, 165,
  187, 23, 247, 118, 195, 211, 158, 81, 43, 45, 6, 200, 77, 119, 156, 60,
  192, 247, 108, 162, 56, 194, 87, 33, 97, 213, 52, 48, 150, 77, 19, 61,
  195, 40, 28, 216, 233, 215, 33, 118, 141, 15, 151, 204, 12, 173, 46, 94,
  171, 22, 215, 159, 11, 76, 154, 227, 1, 241, 191, 214, 238, 81, 120, 111,
  175, 222, 227, 57, 135, 43, 146, 255, 111, 48, 190, 125, 102, 31, 160, 127,
  42, 187, 20, 110, 148, 77, 135, 24, 87, 85, 159, 143, 167, 34, 2, 73,
  100, 40, 149, 122, 63, 74, 162, 82, 24, 137, 29, 223, 131, 179, 227, 6,
  77, 102, 183, 252, 154, 73, 219, 222, 74, 129, 25, 255, 239, 30, 86, 156,
  59, 115, 67, 231, 75, 245, 215, 152, 128, 2, 90, 78, 26, 121, 208, 186,
  199, 42, 17, 118, 174, 234, 145, 216, 126, 167, 200, 181, 81, 242, 190, 6,
  232, 245, 16, 166, 143, 84, 187, 72, 128, 188, 67, 112, 29, 61, 191, 52,
  136, 99, 127, 8, 223, 170, 59, 28, 56, 45, 20, 87, 61, 222, 177, 27,
  185, 24, 107, 226, 19, 105, 217, 122, 138, 78, 248, 90, 67, 205, 41, 141,
  171, 144, 80, 90, 190, 25, 208, 119, 216, 1, 183, 36, 98, 235, 51, 248,
  127, 14, 85, 168, 8, 155, 30, 132, 228, 88, 171, 103, 110, 41, 198, 173,
  148, 34, 137, 17, 88, 134, 247, 181, 83, 1, 166, 145, 127, 205, 173, 71,
  41, 134, 22, 205, 233, 129, 194, 173, 48, 223, 149, 190, 166, 56, 21, 55,
  147, 137, 64, 238, 142, 245, 1, 117, 250, 62, 32, 5, 191, 222, 239, 172,
  82, 65, 105, 144, 227, 193, 20, 104, 96, 231, 18, 165, 253, 100, 225, 125,
  253, 51, 34, 83, 126, 135, 226, 88, 166, 234, 203, 105, 194, 145, 116, 12,
  120, 159, 133, 79, 193, 63, 3, 189, 1, 158, 58, 171, 53, 237, 5, 91,
  225, 193, 50, 157, 4, 211, 172, 243, 165, 120, 234, 232, 224, 152, 84, 184,
  77, 214, 201, 182, 114, 236, 109, 243, 186, 7, 202, 150, 209, 92, 242, 70,
  95, 57, 171, 125, 60, 116, 19, 2, 59, 107, 147, 120, 43, 141, 61, 9,
  188, 14, 106, 242, 37, 117, 111, 96, 112, 142, 227, 196, 232, 93, 144, 102,
  4, 211, 80, 94, 109, 20, 189, 76, 90, 235, 135, 148, 40, 140, 111, 124,
  42, 126, 146, 190, 60, 9, 158, 148, 254, 44, 222, 64, 157, 221, 140, 207,
  193, 79, 233, 187, 106, 169, 24, 197, 150, 141, 128, 73, 63, 129, 249, 39,
  44, 8, 195, 94, 221, 162, 95, 76, 28, 230, 213, 197, 244, 212, 186, 166,
  210, 253, 124, 10, 91, 240, 107, 39, 67, 49, 203, 22, 126, 186, 19, 132,
  212, 21, 246, 58, 196, 39, 188, 195, 66, 117, 249, 60, 160, 55, 22, 116,
  237, 10, 190, 212, 47, 175, 112, 204, 35, 197, 233, 224, 192, 246, 111, 214,
  133, 174, 91, 217, 58, 182, 9, 32, 167, 248, 17, 63, 222, 1, 160, 253,
  105, 81, 202, 191, 117, 168, 34, 24, 55, 179, 200, 214, 15, 42, 28, 102,
  165, 107, 143, 150, 220, 13, 189, 174, 234, 85, 185, 16, 182, 68, 24, 132,
  241, 56, 75, 188, 203, 104, 17, 237, 242, 74, 103, 170, 131, 58, 79, 23,
  232, 236, 59, 188, 179, 160, 4, 105, 167, 46, 187, 64, 228, 102, 140, 66,
  40, 145, 220, 132, 165, 161, 222, 34, 94, 169, 60, 209, 200, 228, 147, 75,
  222, 120, 21, 11, 18, 241, 144, 76, 236, 138, 146, 166, 30, 15, 217, 69,
  138, 68, 239, 83, 101, 124, 14, 232, 250, 73, 227, 127, 212, 186, 133, 72,
  95, 125, 79, 160, 12, 247, 109, 165, 51, 101, 142, 152, 105, 136, 254, 190,
  3, 211, 31, 244, 194, 233, 18, 99, 241, 159, 103, 212, 189, 74, 157, 232,
  96, 198, 35, 122, 54, 208, 226, 136, 37, 102, 59, 216, 214, 45, 251, 7,
  209, 33, 232, 137, 243, 162, 215, 92, 159, 133, 223, 6, 236, 4, 115, 196,
  112, 77, 199, 219, 210, 212, 51, 83, 222, 30, 193, 226, 180, 29, 164, 45,
  55, 126, 178, 12, 127, 70, 97, 193, 128, 39, 4, 109, 122, 250, 218, 10,
  199, 77, 110, 240, 7, 238, 204, 213, 189, 8, 45, 62, 232, 203, 141, 250,
  216, 171, 20, 200, 174, 147, 254, 203, 195, 32, 142, 149, 15, 59, 114, 43,
  137, 186, 212, 215, 78, 232, 130, 115, 18, 214, 126, 158, 128, 218, 74, 59,
  129, 71, 124, 172, 143, 220, 243, 154, 69, 134, 23, 116, 125, 227, 215, 83,
  191, 25, 228, 1, 100, 235, 128, 84, 242, 160, 140, 168, 83, 156, 194, 120,
  205, 128, 2, 129, 138, 43, 7, 72, 225, 9, 52, 94, 109, 70, 149, 216,
  94, 1, 163, 154, 28, 174, 195, 244, 73, 115, 132, 16, 126, 8, 213, 245,
  92, 29, 162, 225, 87, 129, 62, 242, 231, 177, 138, 249, 102, 151, 120, 189,
  248, 143, 165, 192, 172, 186, 94, 107, 80, 244, 205, 84, 152, 178, 96, 115,
  58, 37, 4, 141, 210, 95, 181, 57, 182, 78, 1, 62, 153, 236, 241, 31,
  13, 246, 167, 32, 184, 48, 217, 201, 73, 88, 177, 35, 90, 200, 175, 39,
  44, 226, 155, 60, 7, 95, 181, 49, 41, 165, 93, 2, 121, 205, 171, 50,
  74, 205, 53, 249, 40, 79, 30, 159, 206, 32, 69, 116, 63, 111, 237, 172,
  105, 172, 18, 95, 63, 161, 117, 150, 186, 38, 206, 119, 47, 180, 175, 254,
  122, 143, 37, 20, 74, 47, 123, 129, 152, 85, 107, 254, 96, 49, 203, 141,
  73, 247, 98, 203, 28, 235, 7, 149, 144, 201, 19, 78, 37, 25, 90, 54,
  89, 46, 61, 159, 64, 145, 119, 40, 27, 104, 208, 127, 112, 53, 162, 36,
  185, 251, 123, 108, 19, 129, 38, 69, 109, 29, 176, 218, 97, 94, 167, 207,
  36, 205, 64, 108, 147, 34, 19, 93, 5, 238, 163, 252, 10, 27, 148, 240,
  78, 20, 185, 38, 230, 91, 58, 122, 208, 174, 133, 145, 245, 163, 43, 152,
  202, 126, 134, 163, 41, 183, 133, 252, 158, 27, 106, 229, 108, 135, 10, 201,
  66, 240, 199, 250, 249, 20, 73, 132, 12, 251, 24, 220, 193, 60, 65, 42,
  38, 136, 196, 116, 119, 169, 101, 208, 124, 23, 91, 55, 21, 217, 172, 253,
  188, 27, 248, 196, 47, 148, 30, 58, 24, 105, 141, 36, 5, 84, 236, 59,
  148, 108, 87, 175, 43, 75, 13, 183, 160, 227, 24, 242, 135, 206, 174, 71,
  184, 152, 71, 47, 131, 89, 76, 120, 247, 201, 99, 116, 102, 163, 199, 21,
  224, 150, 102, 231, 25, 234, 161, 211, 104, 2, 208, 77, 146, 129, 44, 14,
  195, 219, 10, 173, 213, 147, 206, 253, 22, 53, 218, 239, 94, 217, 178, 138,
  49, 58, 187, 46, 221, 227, 118, 52, 127, 67, 12, 250, 179, 162, 60, 87,
  83, 98, 218, 140, 219, 116, 96, 200, 77, 99, 153, 204, 21, 127, 139, 10,
  209, 186, 99, 225, 144, 88, 218, 181, 197, 12, 75, 192, 128, 159, 61, 185,
  239, 100, 85, 163, 241, 195, 71, 99, 229, 16, 185, 159, 114, 155, 181, 31,
  44, 136, 14, 126, 63, 22, 226, 168, 182, 167, 111, 55, 125, 12, 93, 37,
  211, 10, 140, 194, 205, 23, 49, 249, 220, 3, 82, 42, 70, 190, 40, 92,
  22, 70, 249, 117, 85, 8, 156, 38, 248, 178, 221, 56, 23, 58, 84, 116,
  96, 151, 242, 231, 14, 109, 142, 79, 82, 16, 120, 247, 110, 228, 70, 9,
  28, 222, 244, 104, 80, 14, 29, 184, 167, 42, 190, 193, 20, 243, 210, 65,
  123, 145, 178, 40, 34, 53, 190, 1, 30, 185, 86, 176, 89, 148, 179, 252,
  155, 25, 7, 251, 230, 35, 247, 78, 162, 142, 237, 242, 104, 39, 15, 227,
  197, 1, 63, 33, 179, 224, 11, 167, 221, 82, 252, 41, 245, 48, 214, 76,
  65, 234, 1, 164, 82, 194, 239, 101, 202, 86, 223, 118, 158, 99, 52, 28,
  111, 86, 115, 27, 213, 237, 104, 160, 157, 162, 17, 173, 135, 52, 98, 233,
  162, 87, 143, 9, 49, 192, 100, 71, 11, 123, 134, 229, 76, 164, 181, 209,
  80, 144, 57, 118, 17, 47, 161, 183, 66, 36, 104, 187, 25, 196, 64, 127,
  70, 11, 124, 236, 173, 94, 151, 103, 51, 215, 129, 88, 148, 39, 209, 115,
  13, 62, 151, 31, 210, 100, 155, 163, 234, 141, 57, 126, 228, 167, 177, 111,
  168, 92, 53, 71, 31, 33, 153, 3, 150, 103, 36, 220, 79, 202, 89, 134,
  80, 130, 153, 119, 240, 83, 131, 123, 207, 67, 174, 115, 204, 176, 139, 106,
  247, 49, 215, 198, 130, 153, 117, 214, 132, 39, 68, 6, 255, 221, 229, 188,
  170, 253, 197, 61, 44, 188, 12, 172, 67, 134, 34, 225, 228, 223, 7, 158,
  204, 63, 41, 180, 195, 144, 120, 253, 168, 159, 43, 86, 245, 196, 111, 239,
  141, 255, 216, 33, 188, 209, 176, 249, 235, 182, 164, 92, 89, 67, 250, 39,
  207, 81, 64, 26, 114, 91, 152, 97, 57, 17, 6, 82, 161, 101, 19, 218,
  120, 208, 187, 222, 248, 168, 213, 239, 195, 160, 88, 26, 202, 142, 49, 217,
  13, 148, 72, 138, 69, 65, 5, 26, 62, 158, 10, 90, 67, 149, 161, 48,
  156, 183, 142, 243, 50, 52, 238, 194, 17, 61, 108, 150, 49, 26, 68, 96,
  56, 73, 190, 41, 32, 50, 155, 180, 97, 179, 35, 92, 251, 54, 33, 147,
  229, 166, 215, 106, 113, 11, 214, 110, 35, 151, 13, 175, 80, 100, 18, 169,
  139, 118, 99, 179, 236, 30, 169, 33, 6, 50, 230, 89, 203, 121, 174, 17,
  85, 166, 130, 76, 193, 46, 61, 132, 139, 56, 65, 101, 199, 52, 123, 5,
  245, 145, 240, 212, 18, 61, 217, 239, 1, 225, 139, 192, 200, 73, 43, 230,
  64, 8, 144, 158, 135, 183, 207, 106, 244, 114, 46, 192, 45, 91, 101, 227,
  60, 19, 81, 97, 87, 207, 146, 58, 249, 233, 100, 68, 130, 2, 189, 248,
  124, 104, 217, 205, 137, 113, 89, 173, 77, 184, 43, 255, 226, 186, 160, 206,
  253, 74, 105, 124, 5, 230, 245, 81, 151, 235, 51, 252, 42, 137, 88, 122,
  128, 90, 33, 243, 187, 77, 234, 39, 244, 26, 209, 93, 117, 219, 51, 125,
  47, 194, 213, 244, 206, 155, 69, 98, 176, 133, 251, 187, 97, 7, 237, 191,
  63, 236, 197, 112, 106, 119, 4, 150, 204, 223, 126, 153, 30, 238, 184, 222,
  8, 138, 78, 98, 246, 48, 3, 177, 72, 157, 213, 253, 131, 56, 90, 146,
  164, 85, 253, 67, 93, 37, 157, 35, 230, 224, 108, 80, 173, 245, 55, 15,
  166, 241, 41, 127, 243, 118, 44, 133, 11, 198, 108, 40, 224, 231, 120, 86,
  79, 21, 175, 15, 253, 187, 211, 107, 212, 91, 121, 234, 215, 22, 135, 2,
  26, 140, 231, 150, 83, 116, 201, 123, 142, 23, 211, 10, 177, 31, 4, 233,
  193, 177, 75, 137, 252, 178, 150, 136, 74, 231, 103, 60, 191, 235, 156, 85,
  154, 65, 227, 16, 235, 1, 57, 122, 199, 114, 157, 53, 60, 243, 67, 94,
  13, 190, 128, 21, 240, 27, 72, 88, 48, 1, 26, 246, 140, 97, 175, 148,
  123, 186, 44, 170, 130, 164, 77, 197, 166, 196, 89, 119, 147, 255, 110, 2,
  28, 238, 44, 90, 124, 16, 19, 69, 1, 51, 169, 102, 22, 121, 181, 156,
  204, 211, 238, 145, 194, 183, 171, 229, 173, 139, 214, 177, 98, 63, 27, 200,
  93, 46, 56, 227, 32, 1, 157, 45, 166, 13, 140, 199, 101, 81, 168, 219,
  9, 216, 176, 195, 156, 38, 72, 224, 170, 207, 78, 121, 171, 103, 209, 197,
  22, 155, 63, 5, 9, 161, 64, 87, 202, 121, 189, 132, 255, 8, 204, 46,
  61, 83, 31, 172, 220, 183, 131, 81, 72, 20, 42, 202, 46, 151, 210, 135,
  115, 6, 167, 8, 68, 1, 86, 100, 198, 32, 77, 146, 192, 87, 210, 251,
  181, 99, 47, 137, 178, 34, 121, 223, 66, 22, 142, 219, 31, 86, 109, 180,
  97, 27, 50, 136, 48, 113, 246, 134, 125, 11, 36, 255, 41, 154, 212, 82,
  70, 239, 137, 14, 175, 113, 80, 32, 121, 18, 190, 6, 42, 156, 84, 17,
  111, 38, 8, 213, 230, 42, 191, 208, 172, 74, 112, 202, 65, 95, 44, 182,
  67, 131, 254, 163, 95, 243, 114, 133, 48, 3, 134, 225, 1, 249, 19, 58,
  41, 105, 54, 91, 24, 154, 16, 217, 122, 148, 180, 30, 53, 221, 118, 196,
  1, 250, 185, 40, 29, 222, 166, 132, 37, 119, 4, 141, 171, 107, 110, 145,
  75, 180, 254, 136, 45, 149, 169, 160, 59, 84, 221, 229, 111, 158, 203, 131,
  38, 233, 149, 224, 141, 92, 199, 254, 50, 5, 247, 204, 113, 211, 33, 176,
  118, 147, 214, 166, 165, 78, 235, 107, 194, 221, 130, 110, 229, 25, 14, 76,
  178, 106, 201, 43, 57, 93, 221, 205, 215, 252, 56, 95, 182, 110, 176, 255,
  125, 88, 143, 146, 51, 69, 103, 170, 3, 216, 251, 233, 133, 152, 198, 232,
  228, 106, 20, 60, 57, 185, 173, 219, 79, 246, 184, 25, 113, 98, 181, 169,
  146, 65, 183, 240, 230, 246, 66, 144, 84, 55, 248, 206, 79, 45, 242, 28,
  54, 106, 28, 80, 103, 15, 188, 55, 62, 92, 255, 68, 26, 52, 21, 182,
  90, 156, 37, 201, 177, 19, 98, 237, 114, 135, 170, 186, 73, 225, 51, 12,
  93, 15, 203, 248, 155, 4, 231, 112, 238, 36, 125, 95, 241, 144, 9, 232,
  247, 81, 39, 5, 211, 32, 146, 182, 84, 152, 226, 59, 198, 122, 143, 233,
  250, 54, 170, 114, 1, 131, 184, 157, 191, 240, 109, 76, 52, 50, 9, 135,
  64, 180, 192, 66, 86, 20, 9, 117, 14, 136, 158, 53, 116, 6, 110, 254,
  128, 85, 191, 16, 196, 66, 220, 157, 90, 129, 109, 218, 212, 70, 149, 200,
  126, 145, 208, 245, 168, 179, 119, 107, 222, 48, 6, 81, 143, 192, 96, 164,
  140, 225, 153, 219, 82, 242, 75, 127, 24, 173, 112, 233, 223, 228, 193, 66,
  234, 207, 108, 54, 137, 62, 224, 248, 107, 11, 252, 40, 113, 162, 35, 29,
  117, 169, 23, 71, 76, 21, 171, 55, 175, 188, 105, 154, 195, 153, 75, 62,
  201, 68, 189, 231, 3, 197, 61, 87, 29, 71, 174, 191, 184, 171, 54, 112,
  147, 223, 82, 24, 34, 234, 111, 246, 165, 22, 125, 151, 216, 206, 235, 117,
  237, 23, 164, 244, 134, 246, 223, 154, 190, 35, 72, 118, 171, 18, 57, 210,
  154, 210, 17, 193, 2, 34, 29, 100, 161, 59, 187, 102, 91, 237, 47, 139,
  25, 1, 224, 130, 198, 88, 36, 50, 238, 56, 165, 139, 2, 159, 112, 226,
  207, 124, 170, 91, 226, 149, 45, 198, 197, 138, 216, 189, 241, 113, 96, 3,
  114, 196, 58, 164, 40, 178, 39, 250, 23, 42, 140, 145, 155, 44, 119, 130,
  254, 79, 22, 94, 65, 241, 28, 175, 9, 69, 179, 42, 126, 76, 88, 27,
  219, 36, 62, 241, 92, 165, 154, 45, 136, 60, 88, 37, 5, 169, 48, 177,
  209, 163, 227, 12, 203, 33, 237, 130, 102, 168, 228, 254, 122, 108, 67, 250,
  235, 159, 80, 37, 147, 78, 184, 230, 169, 122, 21, 2, 106, 58, 128, 14,
  45, 162, 137, 185, 81, 156, 203, 238, 186, 125, 42, 12, 82, 214, 173, 80,
  69, 21, 128, 162, 230, 84, 138, 146, 52, 122, 174, 245, 119, 166, 67, 40,
  98, 138, 245, 32, 111, 252, 228, 220, 246, 126, 5, 45, 21, 77, 46, 56,
  212, 143, 33, 148, 70, 168, 127, 32, 238, 217, 186, 115, 98, 176, 181, 255,
  100, 82, 129, 5, 145, 15, 43, 197, 234, 18, 246, 96, 160, 168, 98, 202,
  14, 79, 199, 202, 116, 7, 193, 188, 160, 252, 163, 198, 244, 104, 30, 70,
  69, 149, 141, 206, 73, 159, 249, 29, 151, 25, 79, 48, 46, 133, 199, 240,
  254, 206, 163, 94, 64, 244, 200, 210, 149, 112, 140, 205, 87, 134, 245, 31,
  248, 97, 89, 235, 191, 2, 98, 107, 170, 51, 239, 134, 145, 233, 108, 119,
  254, 217, 235, 2, 6, 216, 35, 193, 99, 187, 209, 152, 145, 59, 8, 213,
  116, 54, 148, 164, 66, 16, 17, 191, 209, 52, 153, 93, 248, 201, 176, 82,
  180, 72, 93, 28, 11, 87, 133, 218, 7, 50, 100, 79, 71, 26, 232, 3,
  211, 178, 59, 193, 63, 239, 103, 116, 99, 123, 148, 203, 58, 255, 137, 221,
  127, 148, 137, 95, 251, 130, 53, 68, 214, 85, 240, 32, 224, 98, 59, 134,
  90, 119, 100, 60, 121, 175, 75, 218, 182, 94, 54, 113, 174, 180, 95, 15,
  20, 39, 100, 132, 139, 115, 9, 93, 66, 189, 224, 12, 181, 203, 152, 162,
  127, 224, 79, 64, 139, 22, 215, 175, 244, 219, 27, 129, 138, 200, 3, 17,
  181, 109, 205, 141, 9, 164, 70, 251, 73, 240, 87, 4, 94, 201, 17, 246,
  178, 230, 12, 49, 169, 140, 43, 70, 76, 195, 108, 165, 13, 104, 184, 226,
  245, 197, 1, 97, 160, 94, 205, 236, 82, 183, 150, 244, 209, 83, 62, 207,
  237, 45, 173, 136, 60, 215, 141, 183, 143, 150, 51, 219, 238, 16, 169, 39,
  175, 192, 109, 22, 222, 227, 19, 100, 66, 126, 181, 8, 233, 178, 157, 81,
  186, 40, 26, 243, 61, 105, 178, 3, 223, 194, 8, 143, 49, 24, 154, 213,
  125, 187, 3, 215, 165, 34, 107, 17, 70, 252, 60, 240, 68, 228, 220, 35,
  152, 30, 16, 204, 252, 56, 34, 66, 78, 103, 184, 87, 49, 254, 47, 177,
  58, 136, 96, 41, 191, 62, 106, 126, 32, 203, 47, 132, 229, 105, 130, 188,
  42, 212, 196, 88, 147, 202, 86, 53, 135, 239, 31, 181, 159, 129, 199, 121,
  229, 153, 88, 128, 147, 234, 175, 116, 166, 237, 8, 194, 233, 163, 220, 67,
  206, 231, 108, 93, 196, 83, 118, 120, 161, 119, 236, 97, 247, 57, 87, 198,
  223, 55, 77, 18, 4, 150, 242, 39, 2, 253, 82, 167, 215, 135, 207, 152,
  17, 161, 255, 97, 9, 134, 239, 165, 253, 30, 126, 110, 116, 193, 183, 144,
  89, 195, 48, 85, 95, 216, 111, 18, 41, 11, 144, 236, 83, 157, 194, 209,
  220, 160, 143, 90, 187, 77, 199, 216, 63, 242, 205, 155, 243, 148, 217, 48,
  234, 195, 12, 81, 172, 182, 31, 243, 90, 10, 60, 131, 255, 114, 227, 80,
  249, 139, 194, 145, 179, 113, 247, 130, 143, 187, 28, 106, 81, 213, 234, 161,
  252, 112, 47, 224, 52, 90, 129, 29, 35, 158, 110, 21, 199, 2, 107, 36,
  243, 134, 66, 23, 104, 70, 252, 157, 29, 184, 200, 36, 21, 48, 228, 156,
  102, 231, 124, 3, 28, 105, 120, 94, 168, 29, 122, 74, 225, 164, 180, 33,
  230, 150, 219, 38, 123, 217, 43, 181, 34, 235, 13, 215, 62, 172, 88, 251,
  72, 164, 97, 4, 69, 238, 119, 166, 91, 73, 180, 51, 248, 179, 110, 171,
  29, 15, 106, 122, 104, 151, 8, 176, 140, 14, 195, 25, 93, 111, 178, 76,
  23, 117, 108, 154, 236, 127, 101, 37, 75, 156, 202, 228, 88, 158, 5, 103,
  57, 11, 74, 97, 62, 41, 65, 132, 235, 206, 10, 216, 141, 1, 55, 152,
  55, 53, 192, 144, 184, 73, 201, 223, 64, 253, 121, 214, 49, 146, 249, 22,
  176, 61, 127, 1, 165, 192, 226, 217, 249, 149, 216, 50, 140, 78, 167, 102,
  155, 90, 139, 161, 162, 185, 117, 234, 44, 143, 49, 138, 31, 71, 93, 1,
  140, 36, 80, 96, 64, 22, 104, 158, 162, 129, 68, 160, 103, 70, 37, 6,
  150, 221, 49, 246, 124, 13, 50, 42, 213, 160, 103, 250, 54, 118, 136, 33,
  229, 179, 60, 43, 116, 246, 38, 135, 182, 124, 37, 75, 113, 207, 11, 136,
  149, 86, 44, 244, 1, 139, 160, 78, 22, 231, 39, 100, 171, 56, 200, 135,
  37, 170, 27, 91, 3, 173, 221, 96, 71, 48, 149, 95, 69, 180, 203, 18,
  203, 162, 1, 18, 48, 106, 251, 10, 182, 95, 142, 66, 120, 134, 65, 190,
  181, 38, 152, 220, 7, 34, 24, 49, 130, 13, 67, 85, 8, 115, 218, 191,
  16, 190, 243, 204, 201, 58, 73, 220, 103, 209, 239, 206, 101, 247, 118, 63,
  114, 11, 201, 189, 197, 71, 246, 84, 58, 81, 200, 156, 152, 211, 28, 187,
  237, 190, 129, 25, 151, 198, 178, 218, 32, 207, 120, 174, 1, 231, 65, 23,
  171, 193, 251, 58, 240, 19, 74, 44, 100, 91, 166, 225, 23, 172, 50, 210,
  218, 66, 185, 63, 206, 222, 92, 50, 115, 168, 184, 210, 165, 18, 219, 26,
  236, 124, 163, 210, 30, 107, 208, 229, 123, 64, 168, 225, 112, 39, 243, 125,
  254, 92, 235, 69, 59, 20, 222, 125, 240, 13, 17, 243, 19, 185, 45, 74,
  109, 52, 162, 146, 84, 213, 47, 80, 209, 1, 144, 64, 248, 89, 153, 111,
  13, 69, 173, 229, 83, 230, 24, 51, 110, 158, 11, 212, 129, 151, 78, 187,
  112, 44, 244, 214, 65, 188, 10, 221, 191, 229, 66, 173, 212, 164, 35, 146,
  170, 61, 5, 47, 233, 40, 242, 138, 71, 131, 16, 104, 53, 143, 241, 98,
  36, 131, 181, 226, 92, 128, 69, 46, 72, 183, 141, 95, 109, 9, 169, 218,
  192, 104, 241, 120, 183, 163, 198, 226, 1, 133, 20, 83, 189, 238, 15, 173,
  100, 207, 83, 144, 174, 20, 190, 51, 193, 99, 157, 90, 25, 75, 222, 160,
  173, 38, 208, 61, 231, 200, 139, 109, 108, 111, 68, 191, 91, 246, 6, 156,
  201, 74, 188, 214, 105, 131, 114, 14, 204, 147, 110, 180, 32, 138, 172, 222,
  65, 184, 217, 108, 159, 213, 128, 15, 56, 250, 131, 41, 114, 52, 21, 40,
  202, 63, 145, 7, 167, 106, 137, 47, 131, 42, 120, 98, 195, 107, 83, 177,
  222, 137, 185, 145, 15, 105, 219, 208, 46, 226, 197, 167, 79, 126, 146, 86,
  71, 247, 59, 167, 249, 234, 194, 165, 227, 126, 245, 163, 189, 28, 73, 83,
  157, 38, 71, 214, 24, 76, 137, 248, 167, 150, 110, 186, 25, 77, 36, 207,
  167, 61, 19, 150, 227, 94, 146, 136, 162, 253, 40, 78, 47, 224, 59, 197,
  126, 30, 136, 105, 37, 75, 171, 226, 135, 174, 27, 131, 138, 63, 123, 169,
  20, 10, 19, 125, 26, 182, 233, 208, 33, 253, 30, 73, 235, 11, 53, 72,
  34, 140, 17, 205, 142, 195, 171, 186, 170, 123, 75, 228, 97, 197, 156, 91,
  135, 225, 31, 171, 238, 245, 93, 59, 153, 86, 16, 32, 2, 136, 241, 128,
  253, 82, 113, 77, 123, 19, 192, 62, 251, 121, 155, 183, 22, 191, 8, 158,
  117, 102, 157, 1, 84, 57, 7, 120, 147, 223, 105, 6, 61, 144, 250, 153,
  197, 176, 30, 55, 151, 13, 124, 48, 43, 215, 199, 250, 93, 212, 51, 140,
  38, 215, 238, 2, 1, 128, 110, 241, 58, 9, 182, 218, 120, 89, 137, 244,
  210, 16, 188, 151, 9, 161, 154, 84, 86, 54, 213, 193, 215, 195, 225, 102,
  139, 229, 225, 86, 151, 250, 54, 170, 163, 92, 122, 210, 113, 185, 37, 207,
  246, 64, 145, 113, 50, 107, 248, 43, 27, 179, 194, 87, 238, 254, 12, 216,
  192, 77, 82, 101, 142, 27, 204, 127, 252, 56, 196, 216, 52, 55, 232, 20,
  225, 102, 188, 28, 172, 63, 81, 153, 55, 211, 30, 96, 212, 38, 202, 239,
  206, 5, 211, 85, 21, 221, 158, 188, 24, 196, 39, 55, 115, 197, 236, 33,
  82, 11, 239, 144, 85, 211, 64, 111, 237, 53, 123, 79, 112, 118, 252, 155,
  242, 119, 80, 185, 223, 205, 68, 34, 114, 142, 26, 240, 102, 192, 6, 155,
  206, 80, 103, 228, 157, 141, 187, 96, 241, 159, 179, 34, 5, 89, 4, 132,
  177, 244, 124, 41, 164, 132, 90, 62, 107, 166, 232, 199, 106, 117, 227, 194,
  237, 153, 26, 111, 10, 89, 35, 112, 208, 47, 86, 236, 46, 106, 245, 232,
  139, 170, 236, 220, 57, 109, 132, 169, 111, 208, 23, 76, 198, 179, 51, 117,
  84, 52, 116, 182, 154, 127, 177, 243, 24, 161, 199, 114, 227, 27, 176, 186,
  180, 231, 154, 118, 255, 123, 159, 32, 237, 198, 190, 209, 110, 18, 161, 20,
  89, 34, 179, 223, 74, 95, 19, 232, 68, 170, 129, 247, 91, 54, 142, 29,
  63, 251, 211, 24, 73, 133, 85, 151, 127, 8, 60, 250, 4, 255, 67, 23,
  137, 177, 85, 31, 216, 198, 99, 172, 57, 124, 81, 15, 60, 152, 242, 211,
  101, 81, 240, 158, 195, 112, 189, 6, 133, 154, 40, 77, 212, 44, 56, 187,
  218, 72, 191, 141, 149, 189, 235, 196, 20, 182, 249, 9, 42, 172, 84, 1,
  148, 124, 4, 99, 1, 72, 248, 190, 91, 184, 115, 138, 19, 147, 87, 234,
  7, 232, 36, 29, 234, 92, 59, 141, 130, 57, 75, 229, 247, 108, 88, 156,
  202, 133, 230, 112, 88, 54, 70, 10, 96, 253, 31, 52, 149, 86, 4, 208,
  221, 249, 194, 14, 113, 148, 33, 107, 116, 3, 147, 61, 125, 204, 102, 159,
  44, 175, 188, 131, 15, 231, 103, 117, 177, 156, 233, 214, 158, 217, 237, 171,
  56, 122, 12, 221, 14, 77, 247, 24, 101, 113, 219, 230, 118, 189, 239, 204,
  3, 4, 46, 75, 159, 68, 251, 128, 25, 190, 95, 223, 71, 91, 31, 242,
  203, 6, 38, 174, 54, 121, 23, 176, 99, 57, 211, 166, 25, 183, 221, 67,
  205, 45, 74, 50, 207, 222, 85, 18, 210, 53, 41, 166, 39, 78, 118, 176,
  109, 173, 223, 148, 26, 67, 6, 217, 99, 175, 90, 44, 56, 117, 193, 142,
  40, 53, 168, 13, 174, 192, 41, 232, 1, 164, 101, 65, 146, 241, 213, 132,
  121, 28, 97, 143, 7, 169, 134, 57, 98, 196, 27, 225, 175, 72, 190, 220,
  101, 198, 87, 232, 50, 204, 36, 254, 33, 105, 84, 115, 35, 22, 92, 109,
  248, 149, 170, 41, 51, 227, 117, 43, 167, 25, 78, 202, 165, 46, 104, 76,
  135, 174, 224, 205, 17, 35, 230, 186, 2, 245, 121, 55, 142, 171, 12, 155,
  119, 61, 96, 226, 255, 210, 133, 80, 76, 115, 146, 144, 147, 200, 132, 125,
  92, 21, 185, 233, 157, 125, 226, 1, 14, 155, 231, 247, 5, 89, 224, 242,
  76, 204, 249, 133, 45, 168, 101, 201, 10, 255, 135, 214, 43, 1, 196, 74,
  26, 94, 222, 68, 201, 130, 99, 212, 150, 142, 35, 121, 114, 228, 67, 62,
  161, 153, 42, 49, 224, 208, 177, 253, 65, 180, 178, 46, 242, 45, 233, 16,
  154, 72, 122, 7, 29, 189, 219, 172, 186, 166, 14, 79, 200, 118, 183, 134,
  232, 128, 147, 178, 153, 173, 198, 96, 84, 219, 47, 228, 69, 244, 52, 1,
  143, 209, 29, 188, 104, 49, 31, 238, 106, 75, 169, 28, 197, 233, 178, 124,
  11, 245, 120, 213, 166, 160, 71, 203, 59, 89, 75, 152, 38, 31, 247, 112,
  83, 108, 197, 121, 67, 153, 30, 217, 206, 82, 171, 216, 134, 245, 116, 192,
  122, 211, 87, 238, 52, 121, 149, 195, 36, 196, 15, 134, 82, 177, 7, 114,
  90, 43, 249, 51, 85, 227, 67, 248, 18, 255, 81, 174, 212, 142, 228, 253,
  2, 150, 179, 252, 12, 65, 240, 192, 239, 13, 117, 140, 180, 85, 131, 59,
  233, 60, 120, 255, 53, 13, 73, 221, 176, 148, 1, 67, 104, 136, 41, 7,
  67, 199, 242, 40, 102, 80, 51, 35, 162, 226, 54, 75, 182, 86, 160, 48,
  149, 7, 120, 77, 223, 180, 39, 13, 221, 56, 194, 15, 78, 64, 129, 36,
  84, 228, 19, 194, 22, 41, 10, 95, 126, 172, 250, 155, 135, 186, 82, 159,
  48, 176, 179, 254, 56, 186, 165, 81, 164, 236, 74, 2, 145, 91, 229, 151,
  245, 135, 173, 40, 34, 106, 3, 165, 229, 182, 125, 30, 244, 147, 45, 109,
  117, 72, 22, 225, 49, 151, 167, 26, 6, 220, 150, 86, 152, 186, 126, 164,
  238, 224, 100, 111, 200, 113, 82, 130, 211, 176, 71, 201, 156, 81, 28, 116,
  180, 99, 14, 224, 46, 196, 177, 96, 223, 106, 91, 117, 18, 59, 150, 195,
  50, 176, 17, 12, 137, 185, 8, 254, 6, 126, 204, 101, 115, 170, 135, 110,
  95, 30, 247, 55, 138, 243, 118, 203, 119, 184, 234, 248, 220, 27, 94, 158,
  85, 164, 97, 57, 104, 55, 121, 225, 46, 231, 202, 1, 117, 179, 50, 232,
  147, 139, 19, 49, 26, 195, 1, 253, 27, 143, 130, 33, 73, 112, 220, 8,
  152, 72, 66, 23, 93, 26, 243, 189, 91, 254, 172, 79, 202, 50, 167, 28,
  101, 200, 188, 2, 48, 136, 198, 108, 80, 187, 38, 115, 109, 57, 75, 197,
  66, 163, 49, 127, 44, 234, 61, 153, 90, 148, 27, 64, 165, 196, 243, 219,
  36, 134, 88, 71, 250, 94, 124, 151, 208, 28, 123, 228, 128, 149, 189, 194,
  103, 202, 142, 70, 118, 225, 210, 18, 14, 151, 180, 131, 203, 209, 231, 31,
  199, 111, 175, 205, 83, 150, 165, 69, 89, 145, 48, 141, 1, 242, 168, 91,
  153, 178, 42, 80, 222, 255, 131, 177, 29, 210, 102, 133, 195, 175, 5, 72,
  72, 177, 13, 228, 234, 123, 138, 92, 118, 252, 110, 54, 39, 31, 55, 196,
  6, 186, 62, 207, 74, 138, 227, 214, 155, 57, 209, 102, 68, 144, 212, 240,
  154, 217, 176, 132, 191, 123, 223, 11, 63, 237, 140, 208, 8, 23, 27, 82,
  91, 37, 30, 205, 161, 98, 20, 168, 245, 25, 188, 97, 45, 4, 237, 68,
  130, 173, 27, 207, 172, 141, 21, 235, 40, 184, 251, 54, 248, 76, 89, 211,
  155, 23, 127, 193, 201, 138, 152, 29, 60, 130, 224, 121, 88, 129, 157, 41,
  8, 159, 219, 208, 14, 66, 137, 110, 32, 152, 172, 239, 229, 47, 252, 192,
  238, 94, 129, 168, 167, 244, 137, 227, 149, 215, 140, 18, 44, 77, 171, 132,
  226, 113, 133, 181, 45, 129, 148, 80, 71, 57, 201, 88, 65, 24, 89, 167,
  117, 160, 58, 86, 44, 178, 98, 210, 242, 136, 14, 181, 60, 255, 184, 200,
  251, 118, 50, 185, 157, 135, 163, 213, 137, 42, 165, 93, 12, 60, 69, 128,
  110, 118, 213, 244, 70, 14, 39, 22, 154, 72, 232, 9, 50, 207, 247, 171,
  90, 110, 32, 170, 229, 57, 61, 107, 64, 97, 153, 45, 113, 167, 35, 205,
  55, 250, 15, 100, 177, 211, 163, 98, 150, 229, 187, 82, 194, 243, 63, 66,
  21, 82, 114, 76, 63, 126, 255, 154, 185, 250, 108, 144, 176, 9, 87, 146,
  9, 254, 134, 101, 67, 87, 150, 107, 204, 240, 162, 34, 86, 17, 14, 211,
  53, 36, 76, 198, 59, 29, 221, 84, 162, 40, 247, 211, 185, 213, 15, 208,
  236, 31, 9, 216, 157, 215, 19, 96, 104, 222, 43, 83, 150, 85, 78, 27,
  170, 24, 139, 106, 102, 254, 10, 120, 107, 158, 45, 113, 41, 153, 89, 218,
  169, 34, 184, 55, 251, 105, 126, 183, 167, 194, 135, 221, 92, 147, 109, 215,
  33, 162, 213, 17, 25, 118, 164, 69, 203, 138, 114, 220, 78, 100, 62, 146,
  44, 73, 192, 215, 124, 34, 79, 83, 106, 26, 200, 164, 181, 172, 111, 217,
  98, 38, 254, 226, 19, 189, 162, 224, 6, 122, 59, 86, 207, 134, 22, 222,
  73, 15, 113, 197, 123, 205, 51, 188, 81, 251, 69, 60, 191, 62, 98, 234,
  25, 90, 210, 7, 103, 172, 241, 182, 189, 131, 107, 3, 240, 244, 144, 160,
  48, 73, 198, 139, 53, 77, 5, 120, 169, 126, 21, 145, 17, 194, 99, 4,
  68, 159, 233, 84, 65, 194, 236, 37, 216, 54, 25, 196, 195, 28, 172, 189,
  208, 155, 233, 8, 57, 172, 218, 228, 106, 189, 38, 86, 190, 229, 78, 36,
  143, 145, 230, 11, 140, 185, 42, 214, 22, 161, 238, 253, 231, 222, 81, 241,
  94, 236, 166, 143, 252, 9, 61, 230, 245, 22, 72, 11, 13, 233, 125, 28,
  173, 43, 113, 187, 34, 195, 92, 235, 217, 206, 46, 71, 128, 53, 112, 80,
  36, 54, 221, 189, 8, 212, 39, 25, 114, 181, 7, 109, 246, 208, 147, 122,
  150, 170, 101, 243, 207, 231, 12, 100, 157, 21, 119, 235, 63, 44, 99, 120,
  248, 192, 163, 100, 232, 166, 130, 193, 237, 56, 70, 197, 226, 103, 162, 113,
  3, 193, 47, 221, 92, 180, 52, 7, 252, 231, 14, 181, 129, 98, 240, 250,
  21, 141, 79, 88, 95, 198, 159, 144, 253, 33, 19, 122, 133, 115, 7, 31,
  122, 66, 204, 252, 199, 244, 8, 159, 6, 72, 191, 95, 133, 26, 188, 3,
  7, 113, 78, 184, 123, 168, 3, 222, 148, 16, 255, 175, 171, 235, 46, 213,
  227, 62, 251, 103, 139, 225, 1, 54, 153, 85, 16, 73, 177, 44, 123, 105,
  206, 145, 64, 66, 157, 43, 182, 161, 23, 158, 128, 130, 58, 218, 3, 198,
  38, 215, 212, 105, 219, 96, 42, 70, 168, 104, 233, 23, 10, 251, 43, 64,
  16, 190, 51, 148, 127, 221, 1, 239, 233, 101, 41, 140, 32, 146, 161, 13,
  199, 242, 207, 29, 206, 162, 70, 1, 245, 239, 211, 31, 146, 222, 166, 4,
  84, 204, 16, 214, 128, 1, 227, 54, 222, 121, 76, 250, 1, 231, 246, 104,
  112, 225, 16, 23, 20, 80, 137, 154, 186, 144, 158, 166, 169, 5, 182, 212,
  165, 216, 136, 90, 227, 95, 122, 179, 97, 39, 238, 132, 246, 4, 53, 76,
  117, 198, 23, 74, 164, 244, 68, 200, 179, 215, 60, 101, 93, 174, 17, 11,
  163, 223, 138, 184, 236, 65, 253, 196, 63, 83, 224, 76, 243, 143, 45, 56,
  242, 200, 61, 175, 47, 155, 97, 6, 50, 156, 250, 115, 149, 114, 194, 95,
  203, 228, 107, 37, 18, 131, 69, 39, 253, 142, 187, 12, 81, 111, 241, 124,
  5, 160, 130, 110, 61, 244, 99, 95, 125, 55, 97, 74, 59, 71, 177, 96,
  181, 74, 158, 254, 145, 210, 137, 80, 206, 226, 3, 99, 142, 46, 199, 93,
  92, 52, 34, 201, 165, 236, 243, 85, 108, 247, 210, 12, 65, 109, 254, 131,
  107, 25, 45, 253, 59, 33, 65, 104, 27, 49, 223, 189, 109, 20, 156, 149,
  216, 190, 5, 156, 3, 181, 90, 130, 245, 25, 201, 228, 72, 183, 57, 232,
  47, 27, 108, 16, 68, 141, 24, 49, 100, 6, 192, 226, 106, 93, 124, 209,
  75, 9, 154, 32, 142, 239, 173, 191, 69, 136, 202, 68, 174, 66, 102, 178,
  129, 250, 220, 24, 55, 185, 151, 249, 61, 208, 88, 20, 133, 64, 67, 204,
  175, 56, 83, 78, 35, 230, 156, 214, 15, 171, 87, 148, 247, 122, 46, 205,
  41, 53, 173, 138, 107, 42, 241, 193, 187, 160, 164, 26, 69, 123, 151, 11,
  190, 242, 155, 216, 183, 102, 58, 202, 63, 206, 37, 74, 47, 87, 56, 237,
  56, 140, 214, 195, 32, 154, 241, 196, 197, 119, 91, 74, 120, 208, 87, 139,
  167, 88, 33, 135, 99, 115, 42, 213, 37, 127, 148, 133, 160, 218, 142, 241,
  119, 239, 90, 249, 110, 1, 127, 219, 252, 201, 170, 35, 20, 183, 165, 146,
  187, 128, 94, 132, 125, 205, 20, 249, 11, 34, 222, 183, 140, 17, 232, 218,
  76, 118, 84, 168, 199, 97, 89, 175, 128, 171, 80, 217, 153, 38, 231, 219,
  36, 121, 173, 215, 21, 100, 133, 178, 182, 144, 204, 39, 112, 32, 234, 134,
  103, 230, 29, 119, 17, 73, 177, 139, 136, 43, 87, 60, 191, 162, 209, 58,
  135, 79, 126, 175, 217, 116, 38, 1, 227, 115, 19, 93, 198, 29, 101, 160,
  24, 37, 133, 10, 141, 183, 57, 5, 218, 206, 30, 159, 81, 158, 221, 248,
  191, 79, 131, 12, 4, 136, 51, 61, 236, 116, 84, 70, 96, 125, 202, 140,
  96, 26, 230, 4, 103, 70, 118, 28, 193, 136, 53, 125, 12, 217, 116, 92,
  204, 58, 106, 122, 146, 62, 230, 5, 93, 203, 141, 77, 137, 161, 46, 188,
  8, 230, 59, 90, 188, 94, 213, 54, 137, 206, 46, 35, 159, 25, 71, 223,
  219, 203, 40, 155, 79, 241, 179, 127, 143, 13, 58, 119, 111, 235, 184, 210,
  67, 40, 124, 96, 32, 120, 56, 175, 203, 6, 114, 132, 35, 63, 149, 23,
  121, 193, 98, 9, 70, 219, 2, 156, 125, 48, 50, 86, 103, 55, 246, 132,
  212, 85, 89, 174, 220, 19, 186, 92, 62, 249, 114, 38, 169, 134, 191, 205,
  155, 20, 45, 163, 211, 161, 121, 109, 212, 10, 166, 170, 210, 2, 186, 231,
  187, 78, 169, 111, 91, 241, 40, 185, 174, 105, 13, 48, 33, 79, 52, 180,
  163, 255, 135, 190, 184, 111, 1, 78, 180, 4, 169, 209, 14, 124, 52, 18,
  108, 176, 75, 247, 252, 235, 1, 170, 174, 123, 29, 246, 115, 225, 42, 205,
  73, 9, 19, 229, 238, 145, 192, 105, 76, 34, 246, 88, 243, 64, 44, 66,
  5, 170, 129, 24, 157, 10, 236, 52, 223, 101, 225, 48, 220, 15, 134, 235,
  129, 49, 24, 192, 249, 30, 142, 111, 234, 240, 187, 105, 127, 215, 84, 77,
  251, 64, 99, 190, 234, 43, 117, 108, 1, 188, 161, 36, 21, 42, 116, 71,
  58, 100, 193, 97, 151, 240, 41, 196, 204, 147, 50, 107, 18, 102, 157, 230,
  220, 144, 115, 37, 61, 216, 207, 139, 233, 32, 214, 88, 148, 242, 173, 142,
  225, 41, 223, 28, 248, 86, 199, 166, 159, 22, 37, 238, 193, 224, 79, 98,
  33, 158, 10, 191, 65, 143, 47, 179, 218, 110, 95, 49, 2, 180, 141, 112,
  53, 77, 103, 149, 224, 1, 62, 30, 147, 20, 201, 232, 131, 168, 91, 16,
  217, 51, 212, 146, 255, 202, 143, 178, 248, 18, 182, 152, 83, 75, 102, 125,
  232, 68, 245, 44, 51, 163, 43, 200, 218, 197, 174, 4, 31, 226, 168, 178,
  146, 207, 237, 77, 145, 68, 167, 247, 144, 93, 105, 239, 240, 2, 112, 58,
  81, 214, 253, 237, 246, 182, 24, 67, 132, 35, 249, 26, 171, 65, 52, 40,
  248, 199, 154, 21, 176, 151, 237, 2, 74, 235, 156, 190, 99, 30, 229, 200,
  152, 16, 87, 60, 127, 126, 35, 214, 109, 51, 227, 117, 158, 85, 246, 237,
  116, 132, 224, 201, 105, 22, 119, 154, 156, 234, 183, 11, 63, 92, 164, 251,
  226, 124, 183, 138, 161, 141, 33, 94, 169, 104, 190, 209, 202, 114, 17, 116,
  195, 242, 112, 185, 89, 216, 108, 47, 77, 62, 94, 174, 166, 249, 197, 186,
  209, 147, 171, 82, 181, 119, 239, 83, 75, 139, 10, 152, 39, 15, 179, 157
};

private const pcl_ht_builtin_threshold_t    ordered_dither_thresh = {
    1,          /* all planes the same */
    16, 16,     /* 16 x 16 pixels */
    ordered_dither_data
};

private const pcl_ht_builtin_threshold_t    clustered_dither_thresh = {
    1,          /* all planes the same */
    16, 16,     /* 16 x 16 pixels */
    clustered_dither_data
};

private const pcl_ht_builtin_threshold_t    noise_dither_thresh = {

    1,          /* all planes the same */
    128, 128,   /* 128 x 128 pixels */
    noise_dither_data
};

/* table used to map color rendering modes into monochrome 
 */
static  const byte  monochrome_remap[20] = {  5,  5,  2,  5,
					      6,  5,  6,  8,
					      8, 10, 10, 12,
					      12, 14, 14, 17,
					      16, 17, 19, 19  };

/* if true an all gray palette will automatically map
 *    itself to a monochrome rendering mode using the monochrome_remap 
 * if false all render algorithms are are left alone
 * 
 * This is an optimization that if only gray is used on a page the page is printed with
 * only the K plane.  This is a work around for PCL not having a gray colorspace.
 * Should match the behavior of hp clj 4500, 4550 printers.
 */
static const bool ENABLE_AUTO_GRAY_RENDER_METHODS = false;

/*
 * Update built-in rendering information. Attempts to changed fixed rendering
 * infomration are ignored.
 */
private void
pcl_ht_update_rendering_info(
    pcl_state_t *                     pcs,
    int                               method,
    const pcl_ht_builtin_dither_t *   pbidither
)
{
    if ( (method > 0)                                          &&
         (method < countof(pcs->rendering_info))               &&
         ((pcs->rendering_info[method].flags & HT_FIXED) == 0) &&
         (pbidither->type >= pcl_halftone_Threshold)           &&
         (pbidither->type < pcl_halftone_num)               )
        pcs->rendering_info[method].pbidither = pbidither;
}

/*
 * Read dither information from a parameter dictionary held by the device.
 */
private void
read_dither(
    pcl_state_t *               pcs,
    int                         method,
    gs_param_list *             plist,
    gs_memory_t *               pmem
)
{
    pcl_ht_builtin_dither_t *   pdt = 0;
    int                         itype;
    int                         height, width;
    int                         nplanes = 1, nlevels = 1;
    uint                        req_size = 0;
    gs_param_string             dstring;

    /* gather the common parameters */
    if ( (param_read_int(plist, "Type", &itype) != 0)       ||
         (param_read_int(plist, "NumPlanes", &nplanes) < 0) ||
         (param_read_int(plist, "Height", &height) != 0)    ||
         (param_read_int(plist, "Width", &width) != 0)      ||
         (param_read_string(plist, "Data", &dstring) != 0)    )
        return;

    /* check for a recognized type, and number of levels for table dither */
    if (itype == pcl_halftone_Threshold)
        req_size = width * height;
    else if ( (itype == pcl_halftone_Table_Dither)               &&
              (param_read_int(plist, "NumLevels", &nlevels) == 0)  )
        req_size = ((width + 7) / 8) * height;
    else
        return;

    /* check that the data is large enough; copy it if necessary */
    req_size *= nplanes * nlevels;
    if (dstring.size < req_size)
        return;

    pdt = gs_alloc_struct( pmem,
                           pcl_ht_builtin_dither_t,
                           &st_ht_builtin_dither_t,
                           "read device dither"
                           );
    if (pdt == 0)
        return;

    if (!dstring.persistent) {
        byte *  pdata = gs_alloc_bytes(pmem, req_size, "read device dither");

        if (pdata == 0) {
            gs_free_object(pmem, pdt, "read device dither");
            return;
        }
        memcpy(pdata, dstring.data, req_size);
        dstring.data = pdata;
        dstring.persistent = true;
    }

    /* update rendering information */
    pdt->type = (pcl_halftone_type_t)itype;
    if (itype == pcl_halftone_Threshold) {
        pdt->u.thresh.nplanes = nplanes;
        pdt->u.thresh.height = height;
        pdt->u.thresh.width = width;
        pdt->u.thresh.pdata = dstring.data;
    } else {
        pdt->u.tdither.nplanes = nplanes;
        pdt->u.tdither.height = height;
        pdt->u.tdither.width = width;
        pdt->u.tdither.nlevels = nlevels;
        pdt->u.tdither.pdata = dstring.data;
    }
    pcl_ht_update_rendering_info(pcs, method, pdt);
}

/*
 * Modify the rendering remap table. Note that the change will not take
 * effect until the next time the print mode is reset.
 */
private void
pcl_ht_update_rendering_remap(
    pcl_state_t *   pcs,
    const byte *    map
)
{
    memcpy(pcs->dflt_rendering_remap, map, sizeof(pcs->dflt_rendering_remap));
}

/*
 * Read a re-mapping array for rendering methods.
 */
private void
read_remap_array(
    pcl_state_t *pcs,
    gs_param_list * plist,
    gs_memory_t *   pmem
)
{
    gs_param_string dstring;
    int             i;

    if ( (param_read_string(plist, "RenderRemap", &dstring) != 0) ||
         (dstring.size < countof(pcs->dflt_rendering_remap))             )
        return;
    for (i = 0; i < countof(pcs->dflt_rendering_remap); i++) {
        if (dstring.data[i] >= countof(pcs->dflt_rendering_remap))
            return;
    }
    pcl_ht_update_rendering_remap(pcs, dstring.data);
}

/*
 * Initialize the default rendering information.
 */
void
pcl_ht_init_render_methods(
    pcl_state_t *   pcs,
    gs_memory_t *   pmem
)
{
    int             i;
    gx_device *     pcur_dev = gs_currentdevice(pcs->pgs);
    gs_c_param_list list;

    if (pcs->pdflt_ht) return; /* init_render_methods should happen once */

    pcs->ordered_dither.type = pcl_halftone_Threshold;
    pcs->ordered_dither.u.thresh = ordered_dither_thresh;
    pcs->clustered_dither.type =  pcl_halftone_Threshold;
    pcs->clustered_dither.u.thresh =  clustered_dither_thresh;
    pcs->noise_dither.type = pcl_halftone_Threshold;
    pcs->noise_dither.u.thresh = noise_dither_thresh;

    /* 0 */
    pcs->rendering_info[0].flags     = HT_NONE;

    pcs->rendering_info[0].pbidither = &pcs->ordered_dither;

    /* 1 - dither doesn't matter */                                       
    pcs->rendering_info[1].flags     = HT_FIXED | HT_DEVCSPACE;
    pcs->rendering_info[1].pbidither = &pcs->ordered_dither;

    /* 2 - dither doesn't matter */
    pcs->rendering_info[2].flags     = HT_FIXED | HT_DEVCSPACE;
    pcs->rendering_info[2].pbidither = &pcs->ordered_dither;

    /* 3 - the default */
    pcs->rendering_info[3].flags     = HT_NONE;
    pcs->rendering_info[3].pbidither = &pcs->ordered_dither;

    /* 4 - currently not supported */
    pcs->rendering_info[4].flags     = HT_FIXED | HT_IMONLY;
    pcs->rendering_info[4].pbidither = 0;

    /* 5 - monochrome version of 3 */
    pcs->rendering_info[5].flags     = HT_NONE;
    pcs->rendering_info[5].pbidither = &pcs->ordered_dither;

    /* 6 - currently not supported */
    pcs->rendering_info[6].flags     = HT_FIXED | HT_IMONLY;
    pcs->rendering_info[6].pbidither = 0;

    /* 7 */
    pcs->rendering_info[7].flags     = HT_FIXED;
    pcs->rendering_info[7].pbidither = &pcs->clustered_dither;

    /* 8 */
    pcs->rendering_info[8].flags     = HT_FIXED;
    pcs->rendering_info[8].pbidither = &pcs->clustered_dither;

    /* 9 - dither comes from user */
    pcs->rendering_info[9].flags     = HT_FIXED | HT_USERDEF | HT_DEVCSPACE;
    pcs->rendering_info[9].pbidither = 0;

    pcs->rendering_info[10].flags     = HT_FIXED | HT_USERDEF | HT_DEVCSPACE;
    pcs->rendering_info[10].pbidither = 0;

    /* 11 */
    pcs->rendering_info[11].flags     = HT_FIXED | HT_USERDEF | HT_DEVCSPACE;
    pcs->rendering_info[11].pbidither = &pcs->ordered_dither;

    /* 12 */
    pcs->rendering_info[12].flags     = HT_FIXED;
    pcs->rendering_info[12].pbidither = &pcs->ordered_dither;
    
    /* 13 - device should override */
    pcs->rendering_info[13].flags     = HT_NONE;
    pcs->rendering_info[13].pbidither = &pcs->noise_dither;

    /* 14 - device should override */
    pcs->rendering_info[14].flags     = HT_NONE;
    pcs->rendering_info[14].pbidither = &pcs->noise_dither;
    
    /* 15 - device should override */
    pcs->rendering_info[15].flags     = HT_NONE;
    pcs->rendering_info[15].pbidither = &pcs->ordered_dither;

    /* 16 - device should override */
    pcs->rendering_info[16].flags     = HT_NONE;
    pcs->rendering_info[16].pbidither = &pcs->ordered_dither;

    /* 17 - device should override */
    pcs->rendering_info[17].flags     = HT_NONE;
    pcs->rendering_info[17].pbidither = &pcs->ordered_dither;

    /* 18 - device should override */
    pcs->rendering_info[18].flags     = HT_NONE;
    pcs->rendering_info[18].pbidither = &pcs->ordered_dither;

    /* 19 - device should override */
    pcs->rendering_info[19].flags     = HT_NONE;
    pcs->rendering_info[19].pbidither = &pcs->ordered_dither;

    { 
	/*
	 * Remap the the rendering methods. This will generally be
	 * selected from the device; the default value provided below
	 * maps all methods to ones that are supported in the default
	 * system.  
	 */
	private const byte  rendering_remap[20] = {
	    0,  1,  2,  3,  /*  0 -  3 */
	    3,  5,  5,  7,  /*  4 -  7 */
	    8,  9, 10, 11,  /*  8 - 11 */
	    12, 13, 14,  3,  /* 12 - 15 */
	    5,  5,  3,  5   /* 16 - 19 */
	};
	for ( i = 0; i < countof(rendering_remap); i++ )
	    pcs->dflt_rendering_remap[i] = 
		pcs->rendering_remap[i]  = rendering_remap[i];
    }

    /* get any dither information from the current device */
    for (i = 0; i < countof(pcs->rendering_info); i++) {
        char            nbuff[12];

        if ((pcs->rendering_info[i].flags & HT_FIXED) != 0)
            continue;
        gs_c_param_list_write(&list, pmem);
        sprintf(nbuff, "Dither_%d", i);
        if ( (param_request((gs_param_list *)&list, nbuff) >= 0)        && 
             (gs_getdeviceparams(pcur_dev, (gs_param_list *)&list) >= 0)  ) {
            gs_param_dict   dict;

            gs_c_param_list_read(&list);
            if ( param_begin_read_dict( (gs_param_list *)&list,
                                        nbuff,
                                        &dict,
                                        false
                                        ) == 0 )
                read_dither(pcs, i, dict.list, pmem);
            param_end_read_dict((gs_param_list *)&list, nbuff, &dict);
        }

        gs_c_param_list_release(&list);
    }
    gs_c_param_list_release(&list);

    /* read in a new remapping array (if any) */
    gs_c_param_list_write(&list, pmem);
    if ( (param_request((gs_param_list *)&list, "RenderRemap") >= 0) &&
         (gs_getdeviceparams(pcur_dev, (gs_param_list *)&list) >= 0)   ) {
        gs_c_param_list_read(&list);
        read_remap_array(pcs, (gs_param_list *)&list, pmem);
    }
    gs_c_param_list_release(&list);
}

/*
 * Set up normal or monochrome print mode. The latter is accomplished by
 * remapping each of the rendering algorithms to its monochrome equivalent.
 * The handling of the snap-to-primaries rendering method (1) is almost
 * certianly wrong, but it is the best that can be done with the current
 * scheme.
 *
 * Note that the current rendering method must be set before this change
 * will take effect.
 */

void
pcl_ht_set_print_mode(
    pcl_state_t *       pcs,
    bool                monochrome
)
{
    memcpy(pcs->rendering_remap, pcs->dflt_rendering_remap, sizeof(pcs->rendering_remap));
    if (monochrome) {
        int     i;
        for (i = 0; i < countof(pcs->rendering_remap); i++) 
            pcs->rendering_remap[i] = monochrome_remap[pcs->rendering_remap[i]];
    }
}


/*
 * Report if a rendering method is a monochrome method. The evaluation is made
 * with considering the remapping array.
 */
private bool
is_monochrome(
    pcl_state_t *   pcs,
    int             method
)
{
    return (method > 4 && !(method & 1) ); /* greater than 4 and even */
}


/*
 * Free the graphic library halftone objects associated with a PCL halftone
 * object.
 *
 * Note that freeing of the halftone strings is legitimate, as graphic library
 * halftones are never shared among PCL halftone objects.
 */
private void
free_gs_hts(
    pcl_ht_t *  pht
)
{
    int         i;

    if (pht->pfg_ht != 0)
        gs_ht_release(pht->rc.memory, pht->pfg_ht);
    if (pht->pim_ht != 0)
        gs_ht_release(pht->rc.memory, pht->pim_ht);
    pht->pfg_ht = 0;
    pht->pim_ht = 0;

    for (i = 0; i < countof(pht->thresholds); i++) {
        gs_string * pstr = &(pht->thresholds[i]);

        if (pstr->data != 0)
            gs_free_string( pht->rc.memory,
                            pstr->data,
                            pstr->size,
                            "free_gs_hts"
                            );
        pstr->size = 0;
        pstr->data = 0;
    }
}

/*
 * Free a PCL halftone object.
 *
 * Note that the pointers in the three string constants are ignored by this
 * code: all three refer to the same dither object, which is either statically
 * allocated or also refered to by the pudither field. The string pointers
 * exist only because they are required by the graphic library halftone
 * structures.
 */
private void
free_pcl_ht(
    gs_memory_t *   pmem,
    void *          pvht,
    client_name_t   cname
)
{
    pcl_ht_t *      pht = (pcl_ht_t *)pvht;

    if (pht->client_data[0].plktbl != 0)
        rc_adjust(pmem, pht->client_data[0].plktbl, -3, cname);
    pcl_udither_release(pmem, pht->pdither);

    /* free_gs_hts frees the string pointers */
    free_gs_hts(pht);

    gs_free_object(pmem, pvht, cname);
}

/*
 * Allocate a PCL halftone object.
 *
 * Note that this allocates only the PCL halftone object, not the associated
 * graphic library halftone object.
 *
 * Returns 0 on success, < 0 in event of an error.
 */
private int
alloc_pcl_ht(
    pcl_ht_t **   ppht,
    gs_memory_t * pmem
)
{
    pcl_ht_t *    pht = 0;
    int           i;

    rc_alloc_struct_1( pht,
                       pcl_ht_t,
                       &st_ht_t,
                       pmem,
                       return e_Memory,
                       "allocate pcl halftone object"
                       );
    pht->rc.free = free_pcl_ht;

    pht->pdither = 0;
    pht->render_method = 3;     /* HP specified default value */
    pht->orig_render_method = 3;    
    pht->is_gray_render_method = false; 
    pht->pfg_ht = 0;
    pht->pim_ht = 0;

    for (i = 0; i < 3; i++) {
        pht->client_data[i].comp_indx = i;
        pht->client_data[i].inv_gamma = 1.0;
        pht->client_data[i].plktbl = 0;

        /* don't need the threshold string pointers yet */
        pht->thresholds[i].data = 0;
        pht->thresholds[i].size = 0;
    }

    *ppht = pht;
    return 0;
}


/*
 * Make a unique copy of a PCL halftone object.
 *
 * Because the graphic library does not provide a "make unique" feature for
 * the its halftone objects, it is necessary to keep the PCL halftone object
 * and the associated graphic library halftone object in a one-to-one
 * relationship. Hence, two of PCL objects will never share a grahpic library
 * halftone object, and so the "unshared" PCL halftone object will always
 * start without any associated graphic library halftone objects.
 *
 * To simplify the other code in this module, "unshared" halftones are always
 * given new identifiers, even if the unshare operation itself does not
 * change anything.
 *
 * Returns 0 on success, < 0 in the event of an error.
 */
private int
unshare_pcl_ht(
    pcl_ht_t ** ppht
)
{
    pcl_ht_t *  pht = *ppht;
    pcl_ht_t *  pnew = 0;
    int         code = 0;
    int         i;

    /* check if there is anything to do */
    if (pht->rc.ref_count == 1) {
        free_gs_hts(pht);
        return 0;
    }
    rc_decrement(pht->rc.memory, pht, "unshare pcl halftone object");

    if ((code = alloc_pcl_ht(ppht, pht->rc.memory)) < 0)
        return code;
    pnew = *ppht;

    if (pht->pdither != 0)
        pcl_udither_init_from(pht->rc.memory, pnew->pdither, pht->pdither);
    pnew->render_method = pht->render_method;
    pnew->orig_render_method = pht->orig_render_method;
    pnew->is_gray_render_method = pht->is_gray_render_method;

    for (i = 0; i < 3; i++) {
        pnew->client_data[i].comp_indx = pht->client_data[i].comp_indx;
        pnew->client_data[i].inv_gamma = pht->client_data[i].inv_gamma;
        if (pht->client_data[i].plktbl != 0)
            pcl_lookup_tbl_copy_from( pht->rc.memory, pnew->client_data[i].plktbl,
                                      pht->client_data[i].plktbl
                                      );
    }

    /* all other fields are left "null" until needed */

    return 0;
}

/* return true if all palette entries are gray
 * return false if any entry is color 
 * checks the entire palette
 * all gray palette ONLY has meaning if ENABLE_AUTO_GRAY_RENDER_METHODS is true
 * otherwise this is a NOP that always returns false.
 */
bool 
pcl_ht_is_all_gray_palette(pcl_state_t *pcs)
{
    if ( pcs->monochrome_mode ) 
        return true;
    if ( ENABLE_AUTO_GRAY_RENDER_METHODS ) {

        bool is_gray = true;    
	const char *pb = 0;
	pcl_palette_t *     ppalet = pcs->ppalet;
	pcl_cs_indexed_t *  pindexed = ppalet->pindexed;
	int i;

	for ( i = 0; i < pindexed->num_entries; i++ ) {
	    pb = pindexed->palette.data + (3 * i);
	    if (  pb[0] == pb[1] && pb[0] == pb[2] ) {
		continue;
	    }
	    else {
		is_gray = false;
		break;
	    }
	}
	return is_gray;
    }
    return false; /* feature disabled, concider it color */
}

/*
 * Set the render method.
 *
 * Returns 0 on success, < 0 in the event of an error.
 */
int
pcl_ht_set_render_method(
    pcl_state_t * pcs,
    pcl_ht_t **   ppht,
    uint          render_method
)
{
    int         code = 0;
    uint        color_render_method;

    if (render_method >= countof(pcs->rendering_info))
        return 0;

    /* normal rendering remap */
    color_render_method = pcs->rendering_remap[render_method];	
  
    if (color_render_method == (*ppht)->orig_render_method)
        return 0;
    
    if ((code = unshare_pcl_ht(ppht)) < 0)
        return code;

    /* use color render method by default */
    (*ppht)->orig_render_method = (*ppht)->render_method = color_render_method;
    (*ppht)->is_gray_render_method = false;

    /* remap render algo based on is the palette gray palette check */
    return pcl_ht_remap_render_method(pcs, 
				      &(pcs->ppalet->pht), 
				      pcl_ht_is_all_gray_palette(pcs));
}

/* if the palette is gray remap the render_algorithm to a gray algo
 * if the palette is color use the original "color" render_algorithm
 * degenerates to NOP if ENABLE_AUTO_GRAY_RENDER_METHODS is false
 */ 
int
pcl_ht_remap_render_method(
    pcl_state_t * pcs,
    pcl_ht_t **   ppht,
    bool          is_gray
    )
{
    if ( ENABLE_AUTO_GRAY_RENDER_METHODS ) {
        uint render_method = (*ppht)->orig_render_method;
	int code = 0;
	if (is_gray != (*ppht)->is_gray_render_method ) {

	    /* gray may be forced, -dForceMono=1 */ 
            //	    is_gray = gx_set_cmap_procs_to_gray(pcs->pgs, 
            //                                  gs_currentdevice(pcs->pgs),
            //				is_gray);

	    if( is_gray ) {
	        render_method = monochrome_remap[pcs->rendering_remap[render_method]];
		(*ppht)->is_gray_render_method = is_gray; 	        
		/* What's desired is K only gray dithering vs 
		 * cmy+k which looks good in color images containing gray. 
		 */ 
	    }
	    else {
		render_method = (*ppht)->orig_render_method;
	    }
	    
	    if ((code = unshare_pcl_ht(ppht)) < 0)
		return code;     
	    
	    (*ppht)->render_method = render_method;
	}
    }
    /* else feature disabled NOP */
    return 0;
}

/*
 * Update the gamma parameter.
 *
 * Returns 0 on success, < 0 in the event of an error.
 */
int
pcl_ht_set_gamma(
    pcl_ht_t ** ppht,
    float       gamma
)
{
    pcl_ht_t *  pht = *ppht;
    float       inv_gamma = (gamma == 0.0 ? 1.0 : 1.0 / gamma);
    int         code = 0;
    int         i;

    /* 
     * All of the gamma correction factors and lookup table pointers are the
     * same, so just check the first of these. If nothing has changed, just
     * return.
     */
    if ( (pht->client_data[0].inv_gamma == inv_gamma) &&
         (pht->client_data[0].plktbl == 0)              )
        return 0;

    /* get a unique copy of the halftone object */
    if ((code = unshare_pcl_ht(ppht)) < 0)
        return code;
    pht = *ppht;

    /* discard the device specific color lookup table, if present */
    for (i = 0; i < 3; i++) {
        pht->client_data[i].inv_gamma = inv_gamma;
        pcl_lookup_tbl_release(pht->rc.memory, pht->client_data[i].plktbl);
        pht->client_data[i].plktbl = 0;
    }

    return 0;
}

/*
 * Update the color lookup table information. This takes action only for lookup
 * tables associated with device-dependent color spaces; other lookup tables
 * are handled via color spaces.
 *
 * Returns 0 on success, < 0 in the event of an error.
 */
int
pcl_ht_set_lookup_tbl(
    pcl_ht_t **         ppht,
    pcl_lookup_tbl_t *  plktbl
)
{
    pcl_ht_t *  pht = *ppht;
    int         code = 0;
    int         i;

    /* check if this is a nop clear lookup table command */
    if ((plktbl == 0) && (pht->client_data[0].plktbl == 0))
        return 0;

    /* check that the table is for a device-specific color space */
    if ((plktbl != 0) && (pcl_lookup_tbl_get_cspace(plktbl) > pcl_cspace_CMY))
        return 0;

    /* get a unique copy of the halftone object */
    if ((code = unshare_pcl_ht(ppht)) < 0)
        return code;
    pht = *ppht;

    for (i = 0; i < 3; i++)
        pcl_lookup_tbl_copy_from(pht->rc.memory, pht->client_data[i].plktbl, plktbl);
    return 0;
}

/*
 * Set the user-defined dither matrix for a halftone object.
 *
 * Returns 0 on success, < 0 in the event of an error.
 */
int
pcl_ht_set_udither(
    pcl_ht_t **     ppht,
    pcl_udither_t * pdither
)
{
    pcl_ht_t *  pht = *ppht;
    int         code = 0;

    /* get a unique copy of the halftone object */
    if ((code = unshare_pcl_ht(ppht)) < 0)
        return code;
    pht = *ppht;

    pcl_udither_copy_from(pht->rc.memory, pht->pdither, pdither);
    return 0;
}

/*
 * Update the current halftone for a change in the color space.
 *
 * The color space usually does not affect the halftone, but it can in cases
 * in which a device-independent color space is used with a rendering method
 * that is not compatible with device-independent color spaces.
 */
int
pcl_ht_update_cspace(
    pcl_state_t *       pcs,
    pcl_ht_t **         ppht,
    pcl_cspace_type_t   cstype_old,
    pcl_cspace_type_t   cstype_new
)
{
    pcl_ht_t *          pht = *ppht;
    uint                i = pht->render_method;
    uint                flags = pcs->rendering_info[i].flags;

    if ( ((pht->pfg_ht == 0) && (pht->pim_ht == 0))                         ||
         ((flags & HT_DEVCSPACE) == 0)                                      ||
         ((cstype_old <= pcl_cspace_CMY) && (cstype_new <= pcl_cspace_CMY)) ||
         ((cstype_old > pcl_cspace_CMY) && (cstype_new > pcl_cspace_CMY))     )
        return 0;

    /* get a unique copy of the halftone object */
    return unshare_pcl_ht(ppht);
}

/*
 * Create the default halftone, releasing the current halftone if it exists.
 *
 * Returns 0 on success, < 0 in the event of an error.
 */
int
pcl_ht_build_default_ht(
    pcl_state_t *       pcs,
    pcl_ht_t **         ppht,
    gs_memory_t *       pmem
)
{
    int                 code = 0;

    if ((pcs->pdflt_ht == 0) && ((code = alloc_pcl_ht(&pcs->pdflt_ht, pmem)) < 0))
        return code;
    pcl_ht_copy_from(pmem, *ppht, pcs->pdflt_ht);
    return 0;
}

/*
 * Procedure to be used for transfer functions.
 *
 * Unlike the color space code, in this code the procedure is the same for all
 * components, but the client data differs.
 */
private float
transfer_proc(
    floatp                          val,
    const gx_transfer_map *         pmap,   /* ignored */
    const void *                    pvdata
)
{
    const pcl_ht_client_data_t *    pdata = (pcl_ht_client_data_t *)pvdata;
    const byte *                    ptbl;

    if (pdata->plktbl == 0)
        return pow(val, pdata->inv_gamma);
    ptbl = pcl_lookup_tbl_get_tbl(pdata->plktbl, pdata->comp_indx);
    return (float)(ptbl[(int)floor(255.0 * val + 0.5)]) / 255.0;
}

/*
 * Special transfer function for use with the K component. We always want
 * this component to have the default (identity) transfer function when
 * operating in normal (colored) mode.
 */
private float
dflt_transfer_proc(
    floatp                          val,
    const gx_transfer_map *         pmap,   /* ignored */
    const void *                    pvdata  /* ignored */
)
{ 
    return val;
}

/* Define a transfer function without gamma correction. */
private float
identity_transfer(floatp tint, const gx_transfer_map *ignore_map)
{	return tint;
}


/*
 * Get the rendering information corresponding to a given rendering method.
 * This takes into account the restriction that certain rendering methods may
 * not be used with device-independent color spaces. Also considers whether
 * or not the rendering is processing PCL rasters (the for_image operand).
 */
private const pcl_rend_info_t *
get_rendering_info(
    pcl_state_t *       pcs,
    uint                sel_method,
    pcl_cspace_type_t   cstype,
    bool                for_image
)
{
    pcl_rend_info_t *   pinfo = &(pcs->rendering_info[sel_method]);
    uint                flags = pinfo->flags;
 
    /* check for methods that require device-dependent color spaces */
    if ( (((flags & HT_DEVCSPACE) != 0) && (cstype > pcl_cspace_CMY)) ||
         (((flags & HT_IMONLY) != 0) && !for_image)                     )
        pinfo = &pcs->rendering_info[3];

    return pinfo;
}
/*
 * Set the halftone component 
 *
 * Currently, only threshold halftones are supported.
 *
 * The relocation properties of the memory manager require that dither
 * matrices, whether built-in or user-defined, must be copied to strings to
 * fit into the format required by the graphic library halftone machiner.
 *
 * For lack of a better alternative, the monochrome threshold is set to be the
 * same as the first component.
 *
 * The separation names employed are not accurate, but the graphic library
 * insists that 4-color spaces uses the subtractive names (there is a way
 * around this, using the halftone type ht_typ_multiple_colorscreen, but that
 * did not seem to work with normal CMYK devices). Providing only three color
 * screens is not an option, as then the fourth component of a CMYK devices
 * will use the transfer function provided by one of the other components. If
 * this transfer function is inverting, the output will be very black.
 *
 * Returns 0 on success, < 0 in the event of an error.
 */
private int
set_threshold_ht(
    pcl_state_t *               pcs,
    pcl_ht_t *                  pht,
    gs_ht *                     pgsht,
    const pcl_rend_info_t *     pinfo,
    int                         comp
    /*    const gs_ht_separation_name sepname */
)
{
    int                         icomp = (comp == 3 ? 0 : comp);
    pcl_ht_builtin_dither_t     dt;
    float                       (*proc)( floatp,
                                         const gx_transfer_map *,
                                         const void *
                                         ) = transfer_proc;

    /* if not in monochrome print mode, make sure K has default transfer */
    if ((comp == 3) && !is_monochrome(pcs, pht->render_method))
        proc = dflt_transfer_proc;

    /* set the array threshold pointers */
    if ((pinfo->flags & HT_USERDEF) != 0) {
        if (pht->pdither != 0) {
            dt.type = pcl_halftone_Threshold;
            dt.u.thresh.nplanes = pcl_udither_get_nplanes(pht->pdither);
            dt.u.thresh.width = pcl_udither_get_width(pht->pdither);
            dt.u.thresh.height = pcl_udither_get_height(pht->pdither);
            dt.u.thresh.pdata = pcl_udither_get_threshold(pht->pdither, 0);
        } else 
            dt = pcs->ordered_dither;
    } else if (pinfo->pbidither != 0)
        dt = *(pinfo->pbidither);
    else
        return e_Unimplemented;

    if (dt.type == pcl_halftone_Threshold) {
        ulong           size = dt.u.thresh.width * dt.u.thresh.height;
        const byte *    pdata = ( dt.u.thresh.nplanes == 1
                                    ? dt.u.thresh.pdata
                                    : dt.u.thresh.pdata + icomp * size );

        /* don't create a separate threshold array for the K component */
        if (comp != 3) {
            byte *  pb = gs_alloc_string( pht->rc.memory,
                                          size,
                                          "set_threshold_ht"
                                          );

            if (pb == 0)
                return e_Memory;
            memcpy(pb, pdata, size);
            pht->thresholds[comp].size = size;
            pht->thresholds[comp].data = pb;
        }

        return gs_ht_set_threshold_comp( pht->rc.memory, 
					 pgsht,
                                         comp,
                                         /* sepname, */
                                         dt.u.thresh.width,
                                         dt.u.thresh.height,
                                         (gs_const_string *)
                                             &(pht->thresholds[icomp]),
                                         proc,
                                         &(pht->client_data[icomp])
                                         );

    } else if (dt.type == pcl_halftone_Table_Dither) {
        ulong           size = ((dt.u.tdither.width + 7) / 8)
                                 * dt.u.tdither.height * dt.u.tdither.nlevels;
        const byte *    pdata = ( dt.u.thresh.nplanes == 1
                                    ? dt.u.thresh.pdata
                                    : dt.u.thresh.pdata + icomp * size );

        return gs_ht_set_mask_comp( pht->rc.memory, 
				    pgsht,
                                    comp,
                                    // NB                                    sepname,
                                    dt.u.tdither.width,
                                    dt.u.tdither.height,
                                    dt.u.tdither.nlevels,
                                    pdata,
                                    proc,
                                    &(pht->client_data[icomp])
                                    );

    } else
       return e_Unimplemented;
}

/*
 * Color plane separation names for the three standard "concrete" color spaces.
 * The RGB space uses four components so as to provide a default component
 * (which is required by the graphic library code).
 */
// NB private const gs_ht_separation_name sepnames_cmyk[4] = {
// NB    gs_ht_separation_Cyan,
// NB    gs_ht_separation_Magenta,
// NB    gs_ht_separation_Yellow,
// NB    gs_ht_separation_Default    /* Cyan is arbitrarily made the default */
// NB };

// NB private const gs_ht_separation_name sepnames_rgb[4] = {
// NB     gs_ht_separation_Red,
// NB     gs_ht_separation_Green,
// NB     gs_ht_separation_Blue,
// NB     gs_ht_separation_Default,   /* Red is arbitrarily made the default */
// NB };
// NB 
// NB private const gs_ht_separation_name sepnames_gray[1] = {
// NB     gs_ht_separation_Default
// NB };
// NB 
// NB 
/*
 * Create the graphic library halftone objects corresponding to a PCL halftone
 * object.
 *
 * The color space is provided as an operand, because certain rendering
 * mehtods are only usuable with device-specific color spaces.
 *
 * Returns 0 on success, < 0 in the event of an error.
 */
private int
create_gs_halftones(
    pcl_state_t *        pcs,
    pcl_ht_t *           pht,
    pcl_cspace_type_t    cstype,
    int                  ncomps     /* # device components */
)
{
    int                             code = 0;
    const pcl_rend_info_t *         pinfo = 0;
    int                             i;
    // NB  const gs_ht_separation_name *   sepnames = 0;

    /* see if there is anything to do */
    if ( (pht->pfg_ht != 0) && (pht->pim_ht != 0))
        return 0;
    free_gs_hts(pht);

    /* get the rendering information for geometric objects */
    pinfo = get_rendering_info(pcs, pht->render_method, cstype, false);

    /* make the typical assumption concerning the color space */
// NB     if (ncomps == 4)
// NB         sepnames = sepnames_cmyk;
// NB     else if (ncomps == 3) {
// NB         sepnames = sepnames_rgb;
// NB         ncomps = 4;
// NB     } else if (ncomps == 1)
// NB        sepnames = sepnames_gray;
// NB    else
    return e_Range;

    /* create the top-level halftone graphic object */
    if ((code = gs_ht_build(&(pht->pfg_ht), ncomps, pht->rc.memory)) < 0)
        return code;

    /* create the halftone components (allow for 4-color device) */
    for (i = 0; i < ncomps; i++) {
        code = set_threshold_ht(pcs, pht, pht->pfg_ht, pinfo, i /*, NB NB sepnames[i] */);
        if (code < 0)
            break;
    }

    /* currently the foreground and image halftone objects must be the same */
    if (code == 0) {
        if (pinfo != get_rendering_info(pcs, pht->render_method, cstype, true))
            code = e_Unimplemented;
        else 
	  gs_ht_init_ptr(pht->rc.memory, pht->pim_ht, pht->pfg_ht);
    }

    if (code < 0)
        free_gs_hts(pht);
    return code;
}

/*
 * Set the given halftone into the graphic state. If the halftone doesn't
 * exist yet, create a default halftone and set it into the graphic state.
 *
 * Returns 0 on success, < 0 in the event of an error.
 */
int
pcl_ht_set_halftone(
    pcl_state_t *        pcs,
    pcl_ht_t **          ppht,
    pcl_cspace_type_t    cstype,
    bool                 for_image
)
{
    pcl_ht_t *           pht = *ppht;
    int                  ncomps = 0;
    gs_ht *              pgsht = 0;
    int                  code = 0;

    gs_string thresh;
    thresh.data = (byte *)ordered_dither_data;
    thresh.size = 256;
    return pl_set_pcl_halftone(pcs->pgs,
                               /* set transfer */ identity_transfer,
                               /* width */ 16, /*height */ 16,
                               /* dither data */ thresh,
                               /* x phase */ 0,
                               /* y phase */ 0);


    //dprintf( "NB halftone installation\n" );
    return 0;
    /* if no halftone yet, create one */
    if (pht == 0) {
        if ((code = pcl_ht_build_default_ht(pcs, ppht, pcs->memory)) < 0)
            return code;
        pht = *ppht;
    }

    /* see if the halftone is already set */
    if (pcs->pids->pht == pht)
        return 0;

    /* 
     * Check if the color mapping has changed. If it has, re-initialize the
     * the mapping device, so that it will pick up any changes in the target
     * device. Be sure to preserve the reference count when doing so (unless
     * it is 0).
     */
    if (pcs->pids->pht != 0) {
        const pcl_rend_info_t *  pinfo_old;

        pinfo_old = get_rendering_info( pcs,
					pcs->pids->pht->render_method,
                                        cstype,     /* irrelevant */
                                        for_image   /* irrelevant */
                                        );
    }

    /* NB - fix me device fields should not be accessed */
    ncomps = gs_currentdevice(pcs->pgs)->color_info.num_components;

    /* see if we need to create a halftone object */
    if ( ((pgsht = (for_image ? pht->pim_ht : pht->pfg_ht)) == 0) &&
         ((code = create_gs_halftones(pcs, pht, cstype, ncomps)) < 0)    )
        return code;
    pgsht = (for_image ? pht->pim_ht : pht->pfg_ht);

    /* install the halftone object */
    if ((code = gs_ht_install(pcs->pgs, pgsht)) < 0)
        return code;

    pcl_ht_copy_from(pht->rc.memory, pcs->pids->pht, pht);
    return code;
}

