/* Portions Copyright (C) 2001 artofcode LLC.
   Portions Copyright (C) 1996, 2001 Artifex Software Inc.
   Portions Copyright (C) 1988, 2000 Aladdin Enterprises.
   This software is based in part on the work of the Independent JPEG Group.
   All Rights Reserved.

   This software is distributed under license and may not be copied, modified
   or distributed except as expressly authorized under the terms of that
   license.  Refer to licensing information at http://www.artifex.com/ or
   contact Artifex Software, Inc., 101 Lucas Valley Road #110,
   San Rafael, CA  94903, (415)492-9861, for further information. */
/*$Id: plvocab.c,v 1.3 2001/03/23 01:50:50 stefan Exp $ */

/* plvocab.c */
/* Maps between glyph vocabularies */
#include "stdpre.h"
#include "plvocab.h"

/* Define an entry in a glyph mapping table. */
/* Glyph mapping tables are sorted by key. */
typedef struct pl_glyph_mapping_s {
  ushort key;
  ushort value;
} pl_glyph_mapping_t;

/* Map from MSL to Unicode. */
private const pl_glyph_mapping_t pl_map_m2u[] = {
  /*{0, 0x0020},*/		/* MSL space semantics are different */
  {1, 0x0021},
  {2, 0x0022},
  {3, 0x0023},
  {4, 0x0024},
  {5, 0x0025},
  {6, 0x0026},
  {8, 0x2019},
  {9, 0x0028},
  {10, 0x0029},
  {11, 0x002A},
  {12, 0x002B},
  {13, 0x002C},
  {14, 0x002D},
  {15, 0x002E},
  {16, 0x002F},
  {17, 0x0030},
  {18, 0x0031},
  {19, 0x0032},
  {20, 0x0033},
  {21, 0x0034},
  {22, 0x0035},
  {23, 0x0036},
  {24, 0x0037},
  {25, 0x0038},
  {26, 0x0039},
  {27, 0x003A},
  {28, 0x003B},
  {29, 0x003C},
  {30, 0x003D},
  {31, 0x003E},
  {32, 0x003F},
  {33, 0x0040},
  {34, 0x0041},
  {35, 0x0042},
  {36, 0x0043},
  {37, 0x0044},
  {38, 0x0045},
  {39, 0x0046},
  {40, 0x0047},
  {41, 0x0048},
  {42, 0x0049},
  {43, 0x004A},
  {44, 0x004B},
  {45, 0x004C},
  {46, 0x004D},
  {47, 0x004E},
  {48, 0x004F},
  {49, 0x0050},
  {50, 0x0051},
  {51, 0x0052},
  {52, 0x0053},
  {53, 0x0054},
  {54, 0x0055},
  {55, 0x0056},
  {56, 0x0057},
  {57, 0x0058},
  {58, 0x0059},
  {59, 0x005A},
  {60, 0x005B},
  {61, 0x005C},
  {62, 0x005D},
  {64, 0x005F},
  {66, 0x2018},
  {67, 0x0061},
  {68, 0x0062},
  {69, 0x0063},
  {70, 0x0064},
  {71, 0x0065},
  {72, 0x0066},
  {73, 0x0067},
  {74, 0x0068},
  {75, 0x0069},
  {76, 0x006A},
  {77, 0x006B},
  {78, 0x006C},
  {79, 0x006D},
  {80, 0x006E},
  {81, 0x006F},
  {82, 0x0070},
  {83, 0x0071},
  {84, 0x0072},
  {85, 0x0073},
  {86, 0x0074},
  {87, 0x0075},
  {88, 0x0076},
  {89, 0x0077},
  {90, 0x0078},
  {91, 0x0079},
  {92, 0x007A},
  {93, 0x005B},
  {94, 0x007C},
  {95, 0x007D},
  {96, 0x007E},
  {97, 0x2592},
  {99, 0x00C0},
  {100, 0x00C2},
  {101, 0x00C8},
  {102, 0x00CA},
  {103, 0x00CB},
  {104, 0x00CE},
  {105, 0x00CF},
  {106, 0x00B4},
  {107, 0x0060},
  {108, 0x005E},		/* (PC), 0x02C6 (other) */
  {109, 0x00A8},
  {110, 0x007E},		/* (PC), 0x02DC (other) */
  {111, 0x00D9},
  {112, 0x00DB},
  {113, 0x00AF},
  {114, 0x00DD},
  {115, 0x00FD},
  {116, 0x00B0},
  {117, 0x00C7},
  {118, 0x00E7},
  {119, 0x00D1},
  {120, 0x00F1},
  {121, 0x00A1},
  {122, 0x00BF},
  {123, 0x00A4},
  {124, 0x00A3},
  {125, 0x00A5},
  {126, 0x00A7},
  {127, 0x0192},
  {128, 0x00A2},
  {129, 0x00E2},
  {130, 0x00EA},
  {131, 0x00F4},
  {132, 0x00FB},
  {133, 0x00E1},
  {134, 0x00E9},
  {135, 0x00F3},
  {136, 0x00FA},
  {137, 0x00E0},
  {138, 0x00E8},
  {139, 0x00F2},
  {140, 0x00F9},
  {141, 0x00E4},
  {142, 0x00EB},
  {143, 0x00F6},
  {144, 0x00FC},
  {145, 0x00C5},
  {146, 0x00EE},
  {147, 0x00D8},
  {148, 0x00C6},
  {149, 0x00E5},
  {150, 0x00ED},
  {151, 0x00F8},
  {152, 0x00E6},
  {153, 0x00C4},
  {154, 0x00EC},
  {155, 0x00D6},
  {156, 0x00DC},
  {157, 0x00C9},
  {158, 0x00EF},
  {159, 0x00DF},
  {160, 0x00D4},
  {161, 0x00C1},
  {162, 0x00C3},
  {163, 0x00E3},
  {164, 0x00D0},		/* (Latin-1), 0x0110 (Latin-2) */
  {165, 0x00F0},
  {166, 0x00CD},
  {167, 0x00CC},
  {168, 0x00D3},
  {169, 0x00D2},
  {170, 0x00D5},
  {171, 0x00F5},
  {172, 0x0160},
  {173, 0x0161},
  {174, 0x00DA},
  {175, 0x0178},
  {176, 0x00FF},
  {177, 0x00DE},
  {178, 0x00FE},
  {179, 0x00B7},
  {180, 0x00B5},
  {181, 0x00B6},
  {182, 0x00BE},
  {183, 0x2212},
  {184, 0x00BC},
  {185, 0x00BD},
  {186, 0x00AA},
  {187, 0x00BA},
  {188, 0x00AB},
  {189, 0x25A0},
  {190, 0x00BB},
  {191, 0x00B1},
  {192, 0x00A6},
  {193, 0x00A9},
  {194, 0x00AC},
  {195, 0x00AD},
  {196, 0x00AE},
  {197, 0x00B2},
  {198, 0x00B3},
  {199, 0x00B8},
  {200, 0x00B9},
  {201, 0x00D7},
  {202, 0x00F7},
  {203, 0x263A},
  {204, 0x263B},
  {205, 0x2665},
  {206, 0x2666},
  {207, 0x2663},
  {208, 0x2660},
  {209, 0x2022},		/* (PC), 0x25CF (other) */
  {210, 0x25DB},
  {211, 0x25CB},		/* (PC only) */
  {212, 0x25D9},
  {213, 0x2642},
  {214, 0x2640},
  {215, 0x266A},
  {216, 0x266B},
  {217, 0x263C},
  {218, 0x25BA},
  {219, 0x25C4},
  {220, 0x2195},
  {221, 0x203C},
  {222, 0x25AC},
  {223, 0x21A8},
  {224, 0x2191},
  {225, 0x2193},
  {226, 0x2192},
  {227, 0x2190},
  {228, 0x221F},
  {229, 0x2194},
  {230, 0x25B2},
  {231, 0x25BC},
  {232, 0x20A7},
  {233, 0x2310},
  {234, 0x2591},
  {235, 0x2593},
  {236, 0x2502},
  {237, 0x2524},
  {238, 0x2561},
  {239, 0x2562},
  {240, 0x2556},
  {241, 0x2555},
  {242, 0x2563},
  {243, 0x2551},
  {244, 0x2557},
  {245, 0x255d},
  {246, 0x255c},
  {247, 0x255b},
  {248, 0x2510},
  {249, 0x2514},
  {250, 0x2534},
  {251, 0x252c},
  {252, 0x251c},
  {253, 0x2500},
  {254, 0x253c},
  {255, 0x255e},
  {256, 0x255f},
  {257, 0x255a},
  {258, 0x2554},
  {259, 0x2569},
  {260, 0x2566},
  {261, 0x2560},
  {262, 0x2550},
  {263, 0x256c},
  {264, 0x2567},
  {265, 0x2568},
  {266, 0x2564},
  {267, 0x2565},
  {268, 0x2559},
  {269, 0x2558},
  {270, 0x2552},
  {271, 0x2553},
  {272, 0x256b},
  {273, 0x256a},
  {274, 0x2518},
  {275, 0x250c},
  {276, 0x2588},
  {277, 0x2584},
  {278, 0x258c},
  {279, 0x2590},
  {280, 0x2580},
  {281, 0x03B1},
  {283, 0x0393},
  {284, 0x03C0},
  {285, 0x2211},		/* (PC only) */
  {286, 0x03C3},
  {287, 0x03C4},
  {288, 0x03A6},
  {289, 0x0398},
  {290, 0x2126},
  {291, 0x03B4},
  {292, 0x221E},
  {293, 0x03C6},
  {294, 0x03B5},
  {295, 0x2229},
  {296, 0x2261},
  {297, 0x2265},
  {298, 0x2264},
  {299, 0x2320},
  {300, 0x2321},
  {301, 0x2248},
  {302, 0x2219},
  {303, 0x221A},
  {305, 0x25A0},		/* (PC), 0x25AA (other) */
  {306, 0x013F},
  {307, 0x0140},
  {308, 0x2113},
  {309, 0x0149},
  {310, 0x2032},
  {311, 0x2033},
  {312, 0x2020},
  {313, 0x2122},
  {314, 0x2017},
  {315, 0x02C7},
  {316, 0x02DA},
/**************** 317-323 are not in the Book ****************/
  {317, 0x02CA},
  {318, 0x02CB},
  {319, 0x02C6},
  {320, 0x00A8},
  {321, 0x02DC},
  {322, 0x02C7},
  {323, 0x02DA},
  {324, 0x2215},
  {325, 0x2014},
  {326, 0x2013},
  {327, 0x2021},
  {328, 0x0131},
  {329, 0x0027},
/**************** 330 is not in the Book ****************/
  {330, 0x00B8},
  {331, 0x2022},
  {332, 0x207F},
  {333, 0x2302},
  {342, 0x0111},
  {400, 0x0102},
  {401, 0x0103},
  {404, 0x0104},
  {405, 0x0105},
  {406, 0x0106},
  {407, 0x0107},
  {410, 0x010C},
  {411, 0x010D},
  {414, 0x010E},
  {415, 0x010F},
  {416, 0x011A},
  {417, 0x011B},
  {422, 0x0118},
  {423, 0x0119},
  {440, 0x0139},
  {441, 0x013A},
  {442, 0x013D},
  {443, 0x013E},
  {446, 0x0143},
  {447, 0x0144},
  {448, 0x0147},
  {449, 0x0148},
  {452, 0x0150},
  {453, 0x0151},
  {456, 0x0154},
  {457, 0x0155},
  {458, 0x0158},
  {459, 0x0159},
  {462, 0x015A},
  {463, 0x015B},
  {466, 0x0164},
  {467, 0x0165},
  {468, 0x0162},
  {469, 0x0163},
  {474, 0x0170},
  {475, 0x0171},
  {476, 0x016E},
  {477, 0x016F},
  {482, 0x0179},
  {483, 0x017A},
  {484, 0x017B},
  {485, 0x017C},
/**************** 500-505 are not in the Book ****************/
  {500, 0x221A},
  {501, 0x221D},
  {502, 0x212F},
  {504, 0x22C5},
  {505, 0x0393},
  {506, 0x2206},
  {517, 0x2202},
  {519, 0x2260},
/**************** 522-582 are not in the Book ****************/
  {522, 0x03B1},
  {525, 0x03B4},
  {526, 0x03B5},
  {533, 0x00B5},
  {537, 0x03C0},
  {539, 0x03C3},
  {540, 0x03C4},
  {542, 0x03C6},
  {547, 0x03C6},
  {549, 0x2243},
  {550, 0x2262},
  {552, 0x21D2},
  {553, 0x21D3},
  {554, 0x21D0},
  {555, 0x21D5},
  {556, 0x21D4},
  {557, 0x21C4},
  {558, 0x21C6},
  {561, 0x2200},
  {565, 0x222A},
  {566, 0x2208},
  {567, 0x220B},
  {568, 0x2209},
  {569, 0x2282},
  {570, 0x2283},
  {571, 0x2284},
  {572, 0x2285},
  {573, 0x2286},
  {574, 0x2287},
  {575, 0x2295},
  {576, 0x2299},
  {577, 0x2297},
  {578, 0x2296},
  {579, 0x2298},
  {580, 0x2227},
  {581, 0x2228},
  {582, 0x22BB},
  {587, 0x222B},
/**************** 588-641 are not in the Book ****************/
  {588, 0x222E},
  {589, 0x2220},
  {590, 0x2205},
  {591, 0x05D0},
  {592, 0x05D1},
  {605, 0x2016},
  {624, 0x2245},
  {625, 0x2197},
  {626, 0x2198},
  {627, 0x2199},
  {628, 0x2196},
  {635, 0x2237},
  {638, 0x210F},
  {639, 0x2112},
  {641, 0x2118},
  {642, 0x2211},
  {654, 0x25CA},
  {658, 0x220F},
/**************** 663-664 are not in the Book ****************/
  {663, 0x220B},
  {664, 0x2217},
  {1017, 0x201C},
  {1018, 0x201D},
  {1019, 0x201E},
/**************** 1020-1023 are not in the Book ****************/
  {1020, 0x2003},
  {1021, 0x2002},
  {1023, 0x2009},
  {1028, 0x2026},
/**************** 1030 is not in the Book ****************/
  {1030, 0x02DB},
  {1031, 0x017E},
/**************** 1036 is not in the Book ****************/
  {1036, 0x211E},
  {1040, 0xF001},		/* UGL, not Unicode */
  {1041, 0xF002},		/* UGL, not Unicode */
/**************** 1045 is not in the Book ****************/
  {1045, 0x02DD},
  {1047, 0x0133},
  {1060, 0x2105},
  {1061, 0x011E},
  {1062, 0x011F},
  {1063, 0x015E},
  {1064, 0x015F},
  {1065, 0x0130},
  {1067, 0x201A},
  {1068, 0x2030},
  {1084, 0x02C9},
  {1086, 0x02D8},
  {1088, 0x02D9},
  {1090, 0x0153},
  {1091, 0x0152},
  {1092, 0x2039},
  {1093, 0x203A},
  {1094, 0x25A1},
  {1095, 0x0141},
  {1097, 0x02DD},
  {1098, 0x02DB},
/**************** 1099-1101 are not in the Book ****************/
  {1099, 0x21B5},
  {1101, 0x00A9},
  {1106, 0x017D},
  {1107, 0x0132},
  {1108, 0x25AB},
  {1109, 0x25E6},
  {1110, 0x25CB},
/**************** 1111-2515 are not in the Book ****************/
  {1111, 0x25CF},
  {2010, 0x2713},
  {2011, 0x2727},
  {2014, 0x2722},
  {2027, 0x2717},
  {2030, 0x00A7},
  {2032, 0x272C},
  {2044, 0x271D},
  {2046, 0x2734},
  {2047, 0x272B},
  {2048, 0x25B2},
  {2050, 0x2020},
  {2052, 0x272A},
  {2058, 0x2730},
  {2059, 0x25EF},
  {2060, 0x272D},
  {2064, 0x2606},
  {2072, 0x2749},
  {2076, 0x271E},
  {2077, 0x2718},
  {2078, 0x272E},
  {2080, 0x2533},
  {2083, 0x2605},
  {2088, 0x2729},
  {2090, 0x2737},
  {2091, 0x25A0},
  {2092, 0x272F},
  {2096, 0x2702},
  {2116, 0x274D},
  {2120, 0x2703},
  {2121, 0x2712},
  {2210, 0x2714},
  {2230, 0x2720},
  {2232, 0x274B},
  {2240, 0x2738},
  {2248, 0x25BC},
  {2249, 0x25D6},
  {2250, 0x274F},
  {2252, 0x2732},
  {2256, 0x2731},
  {2258, 0x2743},
  {2259, 0x2610},
  {2260, 0x2747},
  {2263, 0x00A9},
  {2264, 0x273B},
  {2265, 0x27B4},
  {2272, 0x2739},
  {2279, 0x273B},
  {2280, 0x25BD},
  {2282, 0x2751},
  {2283, 0x2733},
  {2286, 0x2715},
  {2287, 0x27B5},
  {2288, 0x2741},
  {2290, 0x273E},
  {2292, 0x2748},
  {2293, 0x00AE},
  {2295, 0x261E},
  {2307, 0x270F},
  {2308, 0x2752},
  {2312, 0x261B},
  {2315, 0x2706},
  {2324, 0x2711},
  {2325, 0x2750},
  {2327, 0x27B6},
  {2411, 0x2721},
  {2432, 0x2746},
  {2436, 0x007B},
  {2444, 0x2719},
  {2448, 0x2726},
  {2451, 0x273F},
  {2452, 0x273A},
  {2454, 0x275A},
  {2460, 0x2740},
  {2464, 0x2744},
  {2468, 0x0079},
  {2472, 0x2723},
  {2476, 0x211F},
  {2478, 0x2724},
  {2479, 0x2735},
  {2480, 0x2758},
  {2483, 0x273C},
  {2486, 0x2759},
  {2488, 0x271B},
  {2490, 0x2742},
  {2492, 0x2745},
  {2493, 0x0040},
  {2497, 0x2704},
  {2498, 0x260E},
  {2499, 0x270E},
  {2500, 0x2761},
  {2502, 0x2725},
  {2509, 0x2710},
  {2513, 0x0023},
  {2514, 0x260F},
  {2515, 0x270D},
  {3812, 0xF000}		/* UGL, not Unicode */
};
#define pl_map_m2u_size countof(pl_map_m2u)

/* Map a MSL glyph code to a Unicode character code. */
/* Note that the symbol set is required, because some characters map */
/* differently in different symbol sets. */
uint
pl_map_MSL_to_Unicode(uint msl, uint symbol_set)
{	/* We should use binary search, but we don't.  This is VERY SLOW. */
	int i;
	for ( i = 0; i < pl_map_m2u_size; ++i )
	  if ( pl_map_m2u[i].key == msl )
	    return pl_map_m2u[i].value;
	return 0xffff;
}

/* Map a Unicode character code to a MSL glyph code similarly. */
uint
pl_map_Unicode_to_MSL(uint unicode, uint symbol_set)
{	/* Search the entire MSL to Unicode map.  This is VERY SLOW. */
	int i;
	for ( i = 0; i < pl_map_m2u_size; ++i )
	  if ( pl_map_m2u[i].value == unicode )
	    return pl_map_m2u[i].key;
	return 0xffff;
}
