% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hamming_logical_joins.R
\name{hamming_inner_join}
\alias{hamming_inner_join}
\alias{hamming_anti_join}
\alias{hamming_left_join}
\alias{hamming_right_join}
\alias{hamming_full_join}
\title{Fuzzy joins for Hamming distance using Locality Sensitive Hashing}
\usage{
hamming_inner_join(
  a,
  b,
  by = NULL,
  n_bands = 100,
  band_width = 8,
  threshold = 2,
  progress = FALSE,
  clean = FALSE,
  similarity_column = NULL,
  nthread = NULL
)

hamming_anti_join(
  a,
  b,
  by = NULL,
  n_bands = 100,
  band_width = 100,
  threshold = 2,
  progress = FALSE,
  clean = FALSE,
  similarity_column = NULL,
  nthread = NULL
)

hamming_left_join(
  a,
  b,
  by = NULL,
  n_bands = 100,
  band_width = 100,
  threshold = 2,
  progress = FALSE,
  clean = FALSE,
  similarity_column = NULL,
  nthread = NULL
)

hamming_right_join(
  a,
  b,
  by = NULL,
  n_bands = 100,
  band_width = 100,
  threshold = 2,
  progress = FALSE,
  clean = FALSE,
  similarity_column = NULL,
  nthread = NULL
)

hamming_full_join(
  a,
  b,
  by = NULL,
  n_bands = 100,
  band_width = 100,
  threshold = 2,
  progress = FALSE,
  clean = FALSE,
  similarity_column = NULL,
  nthread = NULL
)
}
\arguments{
\item{a, b}{The two dataframes to join.}

\item{by}{A named vector indicating which columns to join on. Format should
be the same as dplyr: \code{by = c("column_name_in_df_a" = "column_name_in_df_b")}, but two columns must be specified in each dataset
(x column and y column). Specification made with \code{dplyr::join_by()} are
also accepted.}

\item{n_bands}{The number of bands used in the locality sensitive hashing
algorithm (default is 100). Use this in conjunction with the
\code{band_width} to determine the performance of the hashing. Generally
speaking, a higher number of bands leads to greater recall at the cost of
higher runtime.}

\item{band_width}{The length of each band used in the minihashing algorithm
(default is 8). Use this in conjunction with the \code{n_bands} to
determine the performance of the hashing. Generally speaking a wider number
of bands decreases the number of false positives, decreasing runtime at the
cost of lower sensitivity (true matches are less likely to be found).}

\item{threshold}{The Hamming distance threshold below which two strings
should be considered a match. A distance of zero corresponds to complete
equality between strings, while a distance of 'x' between two strings means
that 'x' substitutions must be made to transform one string into the other.}

\item{progress}{Set to \code{TRUE} to print progress.}

\item{clean}{Should the strings that you fuzzy join on be cleaned (coerced to
lower-case, stripped of punctuation and spaces)? Default is \code{FALSE}.}

\item{similarity_column}{An optional character vector. If provided, the data
frame will contain a column with this name giving the Hamming distance
between the two fields. Extra column will not be present if anti-joining.}

\item{nthread}{Maximum number of threads to use. If \code{NULL} (default),
Rayon's global thread pool is used, which typically uses all logical
CPU cores available.}
}
\value{
A tibble fuzzily-joined on the basis of the variables in \code{by.} Tries
to adhere to the same standards as the dplyr-joins, and uses the same
logical joining patterns (i.e. inner-join joins and keeps only observations
in both datasets).
}
\description{
Find similar rows between two tables using the hamming distance. The hamming
distance is equal to the number characters two strings differ by, or is equal
to infinity if two strings are of different lengths
}
\examples{
if (requireNamespace("babynames", quietly = TRUE)) {
  baby_names <- data.frame(
    name = tolower(unique(babynames::babynames$name))[1:500]
  )

  baby_names_mispelled <- data.frame(
    name_mispelled = gsub("[aeiouy]", "x", baby_names$name)
  )

  hamming_inner_join(
    baby_names,
    baby_names_mispelled,
    by = c("name" = "name_mispelled"),
    threshold = 3,
    n_bands = 150,
    band_width = 10,
    clean = FALSE
  )

  hamming_left_join(
    baby_names,
    baby_names_mispelled,
    by = c("name" = "name_mispelled"),
    threshold = 3,
    n_bands = 150,
    band_width = 10
  )
}
}
