







use std::ptr::NonNull;

use crate::imp_prelude::*;


impl<A, S> ArrayBase<S, Ix1>
where S: RawData<Elem = A>
{
    
    
    
    /// ## Safety
    
    
    
    
    #[inline]
    pub(crate) unsafe fn from_data_ptr(data: S, ptr: NonNull<A>) -> Self
    {
        let array = ArrayBase {
            data,
            ptr,
            dim: Ix1(0),
            strides: Ix1(1),
        };
        debug_assert!(array.pointer_is_inbounds());
        array
    }
}


impl<A, S, D> ArrayBase<S, D>
where
    S: RawData<Elem = A>,
    D: Dimension,
{
    
    
    
    
    
    /// ## Safety
    
    
    
    #[inline]
    pub(crate) unsafe fn with_strides_dim<E>(self, strides: E, dim: E) -> ArrayBase<S, E>
    where E: Dimension
    {
        debug_assert_eq!(strides.ndim(), dim.ndim());
        ArrayBase {
            data: self.data,
            ptr: self.ptr,
            dim,
            strides,
        }
    }
}
