use std::cell::Cell;
use std::mem::MaybeUninit;

use crate::math_cell::MathCell;


pub trait AssignElem<T>
{
    
    fn assign_elem(self, input: T);
}


impl<'a, T> AssignElem<T> for &'a mut T
{
    fn assign_elem(self, input: T)
    {
        *self = input;
    }
}


impl<'a, T> AssignElem<T> for &'a Cell<T>
{
    fn assign_elem(self, input: T)
    {
        self.set(input);
    }
}


impl<'a, T> AssignElem<T> for &'a MathCell<T>
{
    fn assign_elem(self, input: T)
    {
        self.set(input);
    }
}



impl<'a, T> AssignElem<T> for &'a mut MaybeUninit<T>
{
    fn assign_elem(self, input: T)
    {
        *self = MaybeUninit::new(input);
    }
}
