use core::fmt;
use core::mem;

use crate::atomic::Shared;
use crate::collector::Collector;
use crate::deferred::Deferred;
use crate::internal::Local;



/// # Pinning













/// # Pointers on the stack





















/// # unsafe { drop(a.into_owned()); } // avoid leak


/// # Multiple guards


















pub struct Guard {
    pub(crate) local: *const Local,
}

impl Guard {
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    pub fn defer<F, R>(&self, f: F)
    where
        F: FnOnce() -> R,
        F: Send + 'static,
    {
        unsafe {
            self.defer_unchecked(f);
        }
    }

    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    /// # Safety
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    /// # Examples
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    /// # unsafe { drop(a.into_owned()); } // avoid leak
    
    pub unsafe fn defer_unchecked<F, R>(&self, f: F)
    where
        F: FnOnce() -> R,
    {
        if let Some(local) = self.local.as_ref() {
            local.defer(Deferred::new(move || drop(f())), self);
        } else {
            drop(f());
        }
    }

    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    /// # Safety
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    /// # Examples
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    /// # unsafe { drop(a.into_owned()); } // avoid leak
    
    pub unsafe fn defer_destroy<T>(&self, ptr: Shared<'_, T>) {
        self.defer_unchecked(move || ptr.into_owned());
    }

    
    
    
    
    
    
    
    
    
    /// # Examples
    
    
    
    
    
    
    
    
    
    
    pub fn flush(&self) {
        if let Some(local) = unsafe { self.local.as_ref() } {
            local.flush(self);
        }
    }

    
    
    
    
    
    
    
    
    
    /// # Examples
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    /// # unsafe { drop(a.into_owned()); } // avoid leak
    
    pub fn repin(&mut self) {
        if let Some(local) = unsafe { self.local.as_ref() } {
            local.repin();
        }
    }

    
    
    
    
    
    
    
    
    
    
    /// # Examples
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    /// # unsafe { drop(a.into_owned()); } // avoid leak
    
    pub fn repin_after<F, R>(&mut self, f: F) -> R
    where
        F: FnOnce() -> R,
    {
        
        struct ScopeGuard(*const Local);
        impl Drop for ScopeGuard {
            fn drop(&mut self) {
                if let Some(local) = unsafe { self.0.as_ref() } {
                    mem::forget(local.pin());
                    local.release_handle();
                }
            }
        }

        if let Some(local) = unsafe { self.local.as_ref() } {
            
            
            local.acquire_handle();
            local.unpin();
        }

        let _guard = ScopeGuard(self.local);

        f()
    }

    
    
    
    
    
    
    
    /// # Examples
    
    
    
    
    
    
    
    
    pub fn collector(&self) -> Option<&Collector> {
        unsafe { self.local.as_ref().map(|local| local.collector()) }
    }
}

impl Drop for Guard {
    #[inline]
    fn drop(&mut self) {
        if let Some(local) = unsafe { self.local.as_ref() } {
            local.unpin();
        }
    }
}

impl fmt::Debug for Guard {
    fn fmt(&self, f: &mut fmt::Formatter<'_>) -> fmt::Result {
        f.pad("Guard { .. }")
    }
}











/// # Safety




/// # Examples




















/// # unsafe { drop(a.into_owned()); } // avoid leak

















































#[inline]
pub unsafe fn unprotected() -> &'static Guard {
    
    
    
    struct GuardWrapper(Guard);
    unsafe impl Sync for GuardWrapper {}
    static UNPROTECTED: GuardWrapper = GuardWrapper(Guard {
        local: core::ptr::null(),
    });
    &UNPROTECTED.0
}
