% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{export_table}
\alias{export_table}
\title{Export results to LaTeX or CSV}
\usage{
export_table(object, file, format = "csv", equation = "both")
}
\arguments{
\item{object}{An object of class "xtvfreg"}

\item{file}{Character; output file name}

\item{format}{Character; "latex" or "csv"}

\item{equation}{Character; "mean", "variance", or "both"}
}
\value{
Invisibly returns NULL; called for side effects
}
\description{
Export results to LaTeX or CSV
}
\examples{
\donttest{
# Create temporary file
set.seed(456)
n_id <- 30
n_time <- 4
panel_data <- data.frame(
  id = rep(1:n_id, each = n_time),
  group = rep(c("A", "B"), length.out = n_id * n_time),
  x = rnorm(n_id * n_time)
)
panel_data$m_x <- ave(panel_data$x, panel_data$id, FUN = mean)
panel_data$d_x <- panel_data$x - panel_data$m_x
panel_data$y <- 1 + panel_data$m_x + rnorm(n_id * n_time)

result <- xtvfreg(
  formula = y ~ 1,
  data = panel_data,
  group = "group",
  panel_id = "id",
  mean_vars = c("m_x", "d_x"),
  var_vars = "m_x",
  verbose = FALSE
)

# Export to CSV
temp_file <- tempfile(fileext = ".csv")
export_table(result, file = temp_file, format = "csv", equation = "mean")

# Clean up
unlink(temp_file)
}
}
