% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/selectGene.R
\name{SelectTopK}
\alias{SelectTopK}
\title{The best k genes are selected.}
\usage{
SelectTopK(fit, lF, size = 1)
}
\arguments{
\item{fit}{Fitness vector.}

\item{lF}{Local configuration.}

\item{size}{Size of return vector (default: 1).}
}
\value{
The index vector of selected genes.
}
\description{
\code{SelectTopK} implements the selection
     of the top K genes.
}
\details{
For implementing migration in island models 
         and  best differential evolution operators.
}
\examples{
fit<-sample(10, 15, replace=TRUE)
fit
SelectTopK(fit, NewlFselectGenes()) 
SelectTopK(fit, NewlFselectGenes(), size=3) 
SelectTopK((-1)*fit, NewlFselectGenes(), size=length(fit)) 
}
\seealso{
Other Selection Functions: 
\code{\link{SelectDuel}()},
\code{\link{SelectLRSelective}()},
\code{\link{SelectLinearRankTSR}()},
\code{\link{SelectPropFit}()},
\code{\link{SelectPropFitDiff}()},
\code{\link{SelectPropFitDiffM}()},
\code{\link{SelectPropFitDiffOnln}()},
\code{\link{SelectPropFitM}()},
\code{\link{SelectPropFitOnln}()},
\code{\link{SelectSTournament}()},
\code{\link{SelectSUS}()},
\code{\link{SelectTournament}()},
\code{\link{SelectUniform}()},
\code{\link{SelectUniformP}()}
}
\concept{Selection Functions}
