% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/selectGene.R
\name{SelectPropFitDiff}
\alias{SelectPropFitDiff}
\title{Selection proportional to fitness differences.}
\usage{
SelectPropFitDiff(fit, lF, size = 1)
}
\arguments{
\item{fit}{Fitness vector.}

\item{lF}{Local configuration.}

\item{size}{Number of selected genes. Default: 1.}
}
\value{
The index vector of the selected genes.
}
\description{
\code{SelectPropFitDiff()} implements selection
             proportional to fitness differences.
             It selects a gene out of the population
             with a probability proportional to the fitness
             difference to the gene with minimal fitness.
             The default of the function \code{lF$Offset()} is \code{1}. 
             The fitness of survival of the gene with 
             minimal fitness is set by \code{lF$Eps()} 
             to \code{0.01} per default.
             See equation (7.45) Andreas Geyer-Schulz (1997), p. 205.
}
\section{Note}{
 
       \code{SelectPropFitDiff()} is a dynamic scaling function.
       Complexity: \eqn{O(n^2)}.
}

\examples{
fit<-sample(10, 15, replace=TRUE)
SelectPropFitDiff(fit, NewlFselectGenes()) 
SelectPropFitDiff(fit, NewlFselectGenes(), length(fit)) 
}
\references{
Geyer-Schulz, Andreas (1997):
     \emph{Fuzzy Rule-Based Expert Systems and Genetic Machine Learning},
     Physica, Heidelberg.
     (ISBN:978-3-7908-0830-X)
}
\seealso{
Other Selection Functions: 
\code{\link{SelectDuel}()},
\code{\link{SelectLRSelective}()},
\code{\link{SelectLinearRankTSR}()},
\code{\link{SelectPropFit}()},
\code{\link{SelectPropFitDiffM}()},
\code{\link{SelectPropFitDiffOnln}()},
\code{\link{SelectPropFitM}()},
\code{\link{SelectPropFitOnln}()},
\code{\link{SelectSTournament}()},
\code{\link{SelectSUS}()},
\code{\link{SelectTopK}()},
\code{\link{SelectTournament}()},
\code{\link{SelectUniform}()},
\code{\link{SelectUniformP}()}
}
\concept{Selection Functions}
