% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/acceptance.R
\name{AcceptBest}
\alias{AcceptBest}
\title{Accepts only genes with equal or better fitness.}
\usage{
AcceptBest(OperatorPipeline, gene, lF)
}
\arguments{
\item{OperatorPipeline}{Genetic operator pipeline.}

\item{gene}{Gene.}

\item{lF}{Local configuration.}
}
\value{
The new gene, if it is at least as fit as \code{gene} else
        the old gene \code{gene}.
}
\description{
Change the gene by a genetic operator pipeline 
             and return the new gene only if the new gene 
             has at least the same fitness as the gene.
}
\details{
The fitness of genes never decreases.
          New genes with inferior fitness do not survive.
}
\examples{
OPpipe1<-function(g, lF){InitGene(lF)}
g1<-lFxegaGaGene$EvalGene(InitGene(lFxegaGaGene), lFxegaGaGene)
g2<-AcceptBest(OPpipe1, g1, lFxegaGaGene)
identical(g1, g2)
}
\seealso{
Other Acceptance Rule: 
\code{\link{AcceptIVMetropolis}()},
\code{\link{AcceptMetropolis}()},
\code{\link{AcceptNewGene}()}
}
\concept{Acceptance Rule}
