% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/xegaGaReplicate.R
\name{xegaGaReplicateGenePipeline}
\alias{xegaGaReplicateGenePipeline}
\title{Replicates a gene by generating a pipeline with a crossover operator returning a single kid.}
\usage{
xegaGaReplicateGenePipeline(pop, fit, lF)
}
\arguments{
\item{pop}{Population of binary genes.}

\item{fit}{Fitness vector.}

\item{lF}{Local configuration of the genetic algorithm.}
}
\value{
A list of a function closure with the operator pipeline.
}
\description{
\code{xegaGaReplicateGenePipeline()} returns
             a gene reproduction pipeline 
             which is represented as a closure with crossover and
             mutation and an acceptance rule together with the 
             necessary genes.
             The control flow starts
             by selecting a gene from the population
             followed by the case distinction:
             \itemize{
              \item
             Check if the mutation operation should be applied.
             (\code{mut} is \code{TRUE} with a probability of \code{lF$MutationRate()}).
             \item
             Check if the crossover operation should be applied.
             (\code{cross} is \code{TRUE} with a probability of \code{lF$CrossRate()}).
             }
             The state distinction determines which genetic operator pipeline
             is returned.
}
\details{
\code{xegaGaReplicateGenePipeline()} returns an operator 
         pipeline with the steps crossover, mutate, accept, and evaluate. 
          generated by a pipeline constructor depending
         on the random choices for mutation and crossover:
\enumerate{
  \item The genes \code{g}, \code{g1} are selected 
        and the boolean variables \code{mut}
        and \code{cross} are set to \code{runif(1)<rate}. 
  \item The local function for the operator pipeline \code{OPpip(g, lF)}
        is generated by the pipeline constructor selected by 
        the truth values of \code{cross} and \code{mut}:
  \enumerate{      
  \item \code{(cross==FALSE) & (mut==FALSE)}: 
        Pipeline constructor  \code{newPipeline(g, lF)}. 
  \item \code{(cross==TRUE) & (mut==TRUE)}: 
        Pipeline constructor  \code{newCrossMutPipeline(g, g1, lF)}. 
  \item \code{(cross==TRUE) & (mut==FALSE)}: 
        Pipeline constructor  \code{newCrossPipeline(g, g1, lF)}. 
  \item \code{(cross==FALSE) & (mut==TRUE)}: 
        Pipeline constructor  \code{newMutPipeline(g, lF)}. 
  }
  }
}
\examples{
lFxegaGaGene$CrossGene<-xegaGaCrossGene
lFxegaGaGene$MutationRate<-function(fit, lF) {0.5}
lFxegaGaGene$CrossRate<-function(fit, lF) {0.5}
lFxegaGaGene$Accept<-function(OperatorPipeline, gene, lF) {gene}
pop10<-lapply(rep(0,10), function(x) xegaGaInitGene(lFxegaGaGene))
epop10<-lapply(pop10, lFxegaGaGene$EvalGene, lF=lFxegaGaGene)
fit10<-unlist(lapply(epop10, function(x) {x$fit}))
newgenes<-xegaGaReplicateGenePipeline(pop10, fit10, lFxegaGaGene)
}
\seealso{
Other Replication: 
\code{\link{xegaGaReplicate2Gene}()},
\code{\link{xegaGaReplicate2GenePipeline}()},
\code{\link{xegaGaReplicate2GenePipelineG}()},
\code{\link{xegaGaReplicateGene}()},
\code{\link{xegaGaReplicateGenePipelineG}()}
}
\concept{Replication}
