% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/xegaOperatorPipelinesInGene.R
\name{newMutPipelineG}
\alias{newMutPipelineG}
\title{Converts a gene into a genetic operator pipeline embedded in a gene with mutation.}
\usage{
newMutPipelineG(g)
}
\arguments{
\item{g}{A gene.}
}
\value{
A gene with embedded genetic operator pipeline 
        with mutation only.
        The argument \code{lF} of the function \code{$Pipeline}
        configures the behavior of the pipeline.
}
\description{
The embedded pipeline is \code{evaluate(accept(mutate, gene))}.
}
\examples{
lFxegaGaGene$MutationRate<-function(fit, lF) {0.5}
lFxegaGaGene$BitMutationRate1<-function(fit, lF) {0.5}
lFxegaGaGene$CrossRate<-function(fit, lF) {0.5}
lFxegaGaGene$Accept<-function(OperatorPipeline, gene, lF) {OperatorPipeline(gene, lF)}
g<-xegaGaInitGene(lFxegaGaGene)
print((lFxegaGaGene$EvalGene(g, lFxegaGaGene))$gene1)
a<-newMutPipelineG(g)
print(a)
b<-a$Pipeline(a, lFxegaGaGene)
}
\seealso{
Other Genetic Operator Pipelines in Gene: 
\code{\link{newCross2Mut1PipelineG}()},
\code{\link{newCross2Mut2PipelineG}()},
\code{\link{newCross2PipelineG}()},
\code{\link{newCrossMut2PipelineG}()},
\code{\link{newCrossMutPipelineG}()},
\code{\link{newCrossPipelineG}()},
\code{\link{newPipelineG}()}
}
\concept{Genetic Operator Pipelines in Gene}
