% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/xegaOperatorPipelinesInGene.R
\name{newCross2Mut1PipelineG}
\alias{newCross2Mut1PipelineG}
\title{Converts two genes into a pipeline with crossover (2 kids) and mutation for first kid.}
\usage{
newCross2Mut1PipelineG(g, g1)
}
\arguments{
\item{g}{A gene.}

\item{g1}{A gene.}
}
\value{
Closure of genetic operator pipeline 
        with crossover with 2 kids and mutation on the first kid only.
        The argument of the closure \code{lF} 
        configures the behavior of the pipeline.
}
\description{
The pipeline is \code{evaluate(accept((crossover o mutation), gene, gene1))}.
             Mutation is applied to the first kid.
}
\examples{
lFxegaGaGene$CrossGene<-xegaGaCross2Gene
lFxegaGaGene$MutationRate<-function(fit, lF) {0.5}
lFxegaGaGene$CrossRate<-function(fit, lF) {0.5}
lFxegaGaGene$Accept<-function(OpPipeline, gene, lF) {OpPipeline(gene, lF)}
g<-xegaGaInitGene(lFxegaGaGene)
g1<-xegaGaInitGene(lFxegaGaGene)
a<-newCross2Mut1PipelineG(g, g1)
print(a)
a$Pipeline(a, lFxegaGaGene)
}
\seealso{
Other Genetic Operator Pipelines in Gene: 
\code{\link{newCross2Mut2PipelineG}()},
\code{\link{newCross2PipelineG}()},
\code{\link{newCrossMut2PipelineG}()},
\code{\link{newCrossMutPipelineG}()},
\code{\link{newCrossPipelineG}()},
\code{\link{newMutPipelineG}()},
\code{\link{newPipelineG}()}
}
\concept{Genetic Operator Pipelines in Gene}
