% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/xegaOperatorPipelines.R
\name{newMutPipeline}
\alias{newMutPipeline}
\title{Converts a gene into a genetic operator pipeline with mutation (a function closure).}
\usage{
newMutPipeline(g, lF)
}
\arguments{
\item{g}{A gene.}

\item{lF}{The local function configuration.}
}
\value{
Closure of genetic operator pipeline 
        with mutation only.
        The argument of the closure \code{lF} 
        configures the behavior of the pipeline.
}
\description{
The pipeline is \code{evaluate(accept(mutate, gene))}.
}
\examples{
lFxegaGaGene$CrossGene<-xegaGaCrossGene
lFxegaGaGene$MutationRate<-function(fit, lF) {0.5}
lFxegaGaGene$CrossRate<-function(fit, lF) {0.5}
lFxegaGaGene$Accept<-function(OperatorPipeline, gene, lF) {gene}
g<-xegaGaInitGene(lFxegaGaGene)
a<-newMutPipeline(g, lFxegaGaGene)
print(a)
a(lFxegaGaGene)
}
\seealso{
Other Genetic Operator Pipelines: 
\code{\link{newCross2Mut1Pipeline}()},
\code{\link{newCross2Mut2Pipeline}()},
\code{\link{newCross2Pipeline}()},
\code{\link{newCrossMut2Pipeline}()},
\code{\link{newCrossMutPipeline}()},
\code{\link{newCrossPipeline}()},
\code{\link{newPipeline}()}
}
\concept{Genetic Operator Pipelines}
