% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dirnames_filenames.R
\name{worcs_path}
\alias{worcs_path}
\title{Specify File Path Relative to WORCS Project Directory}
\usage{
worcs_path(..., worcs_directory = ".", fsep = .Platform$file.sep)
}
\arguments{
\item{...}{Character vectors, indicating directory- or file names.}

\item{worcs_directory}{The project directory (or one of its subdirectories,
in which case the project directory is determined via
\link[worcs]{worcs_root}), Default: '.' (current directory).}

\item{fsep}{Path separator to use.}
}
\value{
Normalized path to file.
}
\description{
Construct the path to a file inside a \code{worcs} project directory
in a platform-independent way, see \link[base]{file.path}.
}
\examples{
if(requireNamespace("withr", quietly = TRUE)){
withr::with_tempdir({
writeLines("", ".worcs")
writeLines("hello world", "myfile.txt")
file.exists(worcs_path("myfile.txt"))
})
}
}
