% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stray.R
\name{stray_anomalies}
\alias{stray_anomalies}
\title{Stray anomalies}
\usage{
stray_anomalies(y, ...)
}
\arguments{
\item{y}{A vector, matrix, or data frame consisting of numerical variables.}

\item{...}{Other arguments are passed to \code{\link[stray]{find_HDoutliers}}.}
}
\value{
Numerical vector containing logical values indicating if the
observation is identified as an anomaly using the stray algorithm.
}
\description{
Test if observations are anomalies according to the stray algorithm.
}
\examples{
# Univariate data
y <- c(6, rnorm(49))
stray_anomalies(y)
# Bivariate data
y <- cbind(rnorm(50), c(5, rnorm(49)))
stray_anomalies(y)
}
\references{
P D Talagala, R J Hyndman and K Smith-Miles (2021) Anomaly detection
in high-dimensional data, \emph{Journal of Computational and Graphical Statistics}, \strong{30}(2), 360-374.
}
\author{
Rob J Hyndman
}
