% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summarize.R
\name{summarize_results_by_group}
\alias{summarize_results_by_group}
\title{Summarize Results by Group}
\usage{
summarize_results_by_group(
  df,
  vars,
  group_vars,
  weight_col = NULL,
  id_col = NULL,
  strata_col = NULL,
  label = NULL
)
}
\arguments{
\item{df}{data.frame with sample and weights (if using a survey design)}

\item{vars}{string vector of variables to calculate prevalences for}

\item{group_vars}{string vector of variables to group by}

\item{weight_col}{string specifying the column with weights, "nhis" or nhis survey design, or NULL for unweighted}

\item{id_col}{string specifying the column with IDs for cluster-aware standard error (SE) calculations}

\item{strata_col}{string specifying the column with strata for cluster-aware SE calculations}

\item{label}{string label for weighting method}
}
\value{
data.frame with totals, means, and standard errors (if using a survey design)
}
\description{
Get adjusted totals and prevalences for provided variables, grouped by specified variables.
}
\details{
TODO: Merge into regular summarize_results function
}
\examples{
# Prepare the NHIS data
calVars <- c(
  "SEX_A_R", "AGEP_A_R", "HISPALLP_A_R", "ORIENT_A_R", "HICOV_A_R", "EDUCP_A_R", "REGION_R",
  "EMPLASTWK_A_R", "HOUTENURE_A_R", "MARITAL_A_R"
)
stuVars <- "DIBTYPE_A_R"
vars_dummies <- c("AGEP_A_R","HISPALLP_A_R","EDUCP_A_R","REGION_R")
nhis_keep_vars <- c("PPSU","PSTRAT","WTFA_A")
nhis_imputed <- impute_data(nhis_processed, c(calVars, stuVars), nhis_keep_vars)
nhis_dummied <- dummies(nhis_imputed, vars=paste0(vars_dummies, '_I'))
factor_vars <- setdiff(names(nhis_dummied), nhis_keep_vars)
nhis_dummied[factor_vars] <- lapply(nhis_dummied[factor_vars], as.factor)

# Prepare the synthetic All of Us data
aou_imputed <- impute_data(aou_synthetic, c(calVars, stuVars))
aou_dummied <- dummies(aou_imputed, vars=paste0(vars_dummies, '_I'))
aou_dummied[] <- lapply(aou_dummied, as.factor)

# Calculate IPW weights using NHIS data and applied to All of Us
weights_df <- calculate_weights(
  nhis_dummied, 
  aou_dummied, 
  'ipw',
  paste0(calVars, '_I'), 
  paste0(stuVars, '_I'), 
  weight='WTFA_A',
  strata='PSTRAT',
  psu='PPSU'
)

# Get IPW results by group
ipw_outcome_df <- summarize_results_by_group(
  weights_df, 
  paste0(stuVars, '_I'), 
  paste0(calVars, '_I'), 
  weight_col='ipw_weight', 
  label='AoU: IPW'
)

}
