% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/upload_folder_file.R
\name{upload_folder_file}
\alias{upload_folder_file}
\title{Uploads a file to a specific folder.}
\usage{
upload_folder_file(canvas, folder_id, file_name, generate_message = TRUE)
}
\arguments{
\item{canvas}{An object containing the Canvas API key and base URL,
obtained through the \code{canvas_authenticate} function.}

\item{folder_id}{The ID of the folder to which the file is uploaded.}

\item{file_name}{The path to the local file that should be uploaded.}

\item{generate_message}{A logical expressing whether a message should
be shown after a succesful upload; defaults to \code{TRUE}.}
}
\value{
If \code{generate_message} is \code{TRUE}, a confirmation message indicating
that the file has been successfully uploaded.
}
\description{
This function uploads a specific file to a specific folder.
}
\details{
Note that the user should have rights to access the folder.
}
\seealso{
\code{\link[=get_course_root_folder]{get_course_root_folder()}} and \code{\link[=get_user_folders]{get_user_folders()}}
}
