% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geom_encircle.R
\name{geom_encircle_vivi}
\alias{geom_encircle_vivi}
\title{Automatically enclose points in a polygon}
\usage{
geom_encircle_vivi(
  mapping = NULL,
  data = NULL,
  stat = "identity",
  position = "identity",
  na.rm = FALSE,
  show.legend = NA,
  inherit.aes = TRUE,
  ...
)
}
\arguments{
\item{mapping}{mapping}

\item{data}{data}

\item{stat}{stat}

\item{position}{position}

\item{na.rm}{na.rm}

\item{show.legend}{show.legend}

\item{inherit.aes}{inherit.aes}

\item{...}{dots}
}
\value{
adds a circle around the specified points
}
\description{
Automatically enclose points in a polygon
}
\details{
This function adds a polygon around a set of points, to highlight them.
}
\examples{
library(ggplot2)
d <- data.frame(x=c(1,1,2),y=c(1,2,2)*100)

gg <- ggplot2::ggplot(d,aes(x,y))
gg <- gg + scale_x_continuous(expand=c(0.5,1))
gg <- gg + scale_y_continuous(expand=c(0.5,1))

gg + geom_encircle_vivi(s_shape=1, expand=0) + geom_point()

gg + geom_encircle_vivi(s_shape=1, expand=0.1, colour="red") + geom_point()
}
