% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generate.R
\name{generate.mdl_vtl_df}
\alias{generate.mdl_vtl_df}
\title{Generate responses from a mable}
\usage{
\method{generate}{mdl_vtl_df}(x, new_data = NULL, h = NULL, bootstrap = FALSE, times = 1, ...)
}
\arguments{
\item{x}{A mable.}

\item{new_data}{Future data needed for generation (should include the time index and exogenous regressors)}

\item{h}{The simulation horizon (can be used instead of \code{new_data} for regular time series with no exogenous regressors).}

\item{bootstrap}{If \code{TRUE}, then forecast distributions are computed using simulation with resampled errors.}

\item{times}{The number of replications.}

\item{...}{Additional arguments}
}
\value{
A vital object with simulated values.
}
\description{
Use a fitted model to simulate future data with similar
behaviour to the response.
}
\details{
Innovations are sampled by the model's assumed error distribution.
If \code{bootstrap} is \code{TRUE}, innovations will be sampled from the model's residuals.
}
\examples{
norway_mortality |>
  model(lc = LC(Mortality)) |>
  generate(times = 3, bootstrap = TRUE)

}
\author{
Rob J Hyndman and Mitchell O'Hara-Wild
}
