% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pedmatrix.R
\name{summary_pedmat}
\alias{summary_pedmat}
\title{Summary Statistics for Pedigree Matrices}
\usage{
summary_pedmat(x)
}
\arguments{
\item{x}{A pedmat object from \code{\link{pedmat}}.}
}
\value{
An object of class \code{"summary.pedmat"} with statistics including
  method, dimensions, compression ratio (if compact), mean relationship, 
  and matrix density.
}
\description{
Computes and displays summary statistics for a pedmat object.
}
\details{
Since pedmat objects are often S4 sparse matrices with custom attributes,
use this function instead of the generic \code{summary()} to ensure proper
display of pedigree matrix statistics.
}
\examples{
tped <- tidyped(small_ped)
A <- pedmat(tped, method = "A")
summary_pedmat(A)

}
\seealso{
\code{\link{pedmat}}
}
