% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/url_report.R
\name{url_report}
\alias{url_report}
\title{Get URL Report}
\usage{
url_report(url_id = NULL, ...)
}
\arguments{
\item{url_id}{URL or URL ID from VirusTotal. String. Required.}

\item{\dots}{Additional arguments passed to \code{\link{virustotal_GET}}.}
}
\value{
list containing URL analysis results including scan details,
detection information, and metadata
}
\description{
Retrieve a scan report for a given URL or URL ID from VirusTotal.
}
\examples{
\dontrun{

# Before calling the function, set the API key using set_key('api_key_here')

# Get report using URL
url_report("http://www.google.com")

# Get report using URL ID (base64 encoded URL without padding)
url_report("687474703a2f2f7777772e676f6f676c652e636f6d2f")
}
}
\references{
\url{https://docs.virustotal.com/reference}
}
\seealso{
\code{\link{set_key}} for setting the API key, \code{\link{scan_url}} for submitting URLs
}
