% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dt_parquet.R
\name{dt_parquet}
\alias{dt_parquet}
\title{Read parquet and convert to data.table}
\usage{
dt_parquet(path_base, name = NULL, ext = ".parquet", in_memory = TRUE)
}
\arguments{
\item{path_base}{A character string, providing the path to read from.}

\item{name}{Optional. A character string. The file name (if absent from \code{path_base}).}

\item{ext}{Optional. A character string. The file extension.}

\item{in_memory}{Logical, should data be loaded in memory?}
}
\value{
A data.table if \code{in_memory} is set to \code{TRUE},
a parquet Table if \code{in_memory} is set to \code{FALSE}.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}} Load data IN- our OUT- of memory.
File extension can be omitted.
}
\details{
Output is a data.table.
For meddra and whodrug tables, it is still a good option to load data in-memory.
This function is wrapping \code{arrow::read_parquet()}, \code{dplyr::collect()} and
\code{data.table::as.data.table()} altogether.
If you want to load \strong{OUT} of memory, set arg \code{in_memory} to FALSE.
\strong{Be careful that doing so will change the function output format}.
For this latter case, the output is not a data.table, so there is no practical
benefit as compared to using \code{arrow::read_parquet()} directly, with
\code{as_data_frame} = FALSE.
}
\examples{

# Say you have a data.frame stored in a parquet format, such as this one
demo <-
  data.table::data.table(
    UMCReportId = c(1, 2, 3, 4),
    AgeGroup = c(1, 7, 7, 8)
  ) |>
  arrow::as_arrow_table()

tmp_folder <- paste0(tempdir(), "/dtparquetex")
dir.create(tmp_folder)
path_data <- paste0(tmp_folder, "/")

arrow::write_parquet(demo,
                     sink = paste0(path_data, "demo.parquet")
)

# Now you have a new session without demo
rm(demo)

# You may import the file directly to data.table format with dt_parquet
demo <-
  dt_parquet(path_data, "demo")

# Clean up (required for CRAN checks)
unlink(tmp_folder, recursive = TRUE)
}
\seealso{
\code{\link[=tb_vigibase]{tb_vigibase()}}, \code{\link[=tb_who]{tb_who()}}, \code{\link[=tb_meddra]{tb_meddra()}}
}
\keyword{import}
