% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FileComparator.R
\name{FileComparator}
\alias{FileComparator}
\title{FileComparator.R}
\description{
FileComparator.R

FileComparator.R
}
\details{
Comparator 'abstract' class containing the generic comparison methods and
handling for high level checks (like file existence). This class should never
be instantiated - doing that and calling the comparison methods will lead to
error.
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{file1}}{file1}

\item{\code{file2}}{file2}

\item{\code{file1_contents_list}}{file1 contents}

\item{\code{file2_contents_list}}{file2 contents}

\item{\code{summary_comparison}}{summary comparison result}

\item{\code{details_comparison}}{details comparison result}

\item{\code{debugger}}{debugger instance}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-FileComparator-new}{\code{FileComparator$new()}}
\item \href{#method-FileComparator-vrf_summary}{\code{FileComparator$vrf_summary()}}
\item \href{#method-FileComparator-vrf_details}{\code{FileComparator$vrf_details()}}
\item \href{#method-FileComparator-vrf_summary_inner}{\code{FileComparator$vrf_summary_inner()}}
\item \href{#method-FileComparator-vrf_details_inner}{\code{FileComparator$vrf_details_inner()}}
\item \href{#method-FileComparator-vrf_details_supported}{\code{FileComparator$vrf_details_supported()}}
\item \href{#method-FileComparator-vrf_option_value}{\code{FileComparator$vrf_option_value()}}
\item \href{#method-FileComparator-vrf_open_debug}{\code{FileComparator$vrf_open_debug()}}
\item \href{#method-FileComparator-vrf_add_debug}{\code{FileComparator$vrf_add_debug()}}
\item \href{#method-FileComparator-vrf_add_debug_files}{\code{FileComparator$vrf_add_debug_files()}}
\item \href{#method-FileComparator-vrf_close_debug}{\code{FileComparator$vrf_close_debug()}}
\item \href{#method-FileComparator-clone}{\code{FileComparator$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-FileComparator-new"></a>}}
\if{latex}{\out{\hypertarget{method-FileComparator-new}{}}}
\subsection{Method \code{new()}}{
Initialize a FileComparator instance
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{FileComparator$new(file1 = NULL, file2 = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{file1}}{First file to compare.}

\item{\code{file2}}{Second file to compare.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-FileComparator-vrf_summary"></a>}}
\if{latex}{\out{\hypertarget{method-FileComparator-vrf_summary}{}}}
\subsection{Method \code{vrf_summary()}}{
Method for comparing the file summary information. This method is
intended to be implemented only this class level. For comparator
specific rules, the internal method vrf_summary_inner should be
customized on lower levels instead.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{FileComparator$vrf_summary(config, omit = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{config}}{configuration values}

\item{\code{omit}}{string pattern to omit from the comparison}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-FileComparator-vrf_details"></a>}}
\if{latex}{\out{\hypertarget{method-FileComparator-vrf_details}{}}}
\subsection{Method \code{vrf_details()}}{
Method for comparing the file details information. This method is
intended to be implemented only this class level. For comparator
specific rules, the internal method vrf_summary_inner should be
customized on lower levels instead.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{FileComparator$vrf_details(config, omit = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{config}}{configuration values}

\item{\code{omit}}{string pattern to omit from the comparison}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-FileComparator-vrf_summary_inner"></a>}}
\if{latex}{\out{\hypertarget{method-FileComparator-vrf_summary_inner}{}}}
\subsection{Method \code{vrf_summary_inner()}}{
"Abstract" method for comparing the inner part for the summary. This
method has to be overwritten by more specialized comparator classes. This
method is intended to be called only by the comparator classes in the
processing and shouldn't be called directly by the user.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{FileComparator$vrf_summary_inner(config, omit)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{config}}{configuration values}

\item{\code{omit}}{string pattern to omit from the comparison}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-FileComparator-vrf_details_inner"></a>}}
\if{latex}{\out{\hypertarget{method-FileComparator-vrf_details_inner}{}}}
\subsection{Method \code{vrf_details_inner()}}{
"Abstract" method for comparing the inner part for the detailsThis method
has to be overwritten by more specialized comparator classes. This method
is intended to be called only by the comparator classes in the processing
and shouldn't be called directly by the user.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{FileComparator$vrf_details_inner(config, omit)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{config}}{configuration values}

\item{\code{omit}}{string pattern to omit from the comparison}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-FileComparator-vrf_details_supported"></a>}}
\if{latex}{\out{\hypertarget{method-FileComparator-vrf_details_supported}{}}}
\subsection{Method \code{vrf_details_supported()}}{
Inherited method for indicating whether detailed comparison is available
with the current comparator. Returns an empty string if the comparator is
is supported, otherwise a string that will be concatenated with the
summary string.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{FileComparator$vrf_details_supported(config)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{config}}{configuration values}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-FileComparator-vrf_option_value"></a>}}
\if{latex}{\out{\hypertarget{method-FileComparator-vrf_option_value}{}}}
\subsection{Method \code{vrf_option_value()}}{
Method for getting specific value from the config In the initial
version, returns 'NA' if null con is passed.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{FileComparator$vrf_option_value(config, key)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{config}}{configuration values}

\item{\code{key}}{key to search from the parameters}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-FileComparator-vrf_open_debug"></a>}}
\if{latex}{\out{\hypertarget{method-FileComparator-vrf_open_debug}{}}}
\subsection{Method \code{vrf_open_debug()}}{
Wrapper method for the opening a new debugging instance with Debugger
class if debugging is enabled in config class. Creates the used
debugger instance if needed.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{FileComparator$vrf_open_debug(message, config)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{message}}{message to debug to console}

\item{\code{config}}{configuration values}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-FileComparator-vrf_add_debug"></a>}}
\if{latex}{\out{\hypertarget{method-FileComparator-vrf_add_debug}{}}}
\subsection{Method \code{vrf_add_debug()}}{
Wrapper method for the adding a new debugging message with Debugger
class.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{FileComparator$vrf_add_debug(message)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{message}}{message to debug to console}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-FileComparator-vrf_add_debug_files"></a>}}
\if{latex}{\out{\hypertarget{method-FileComparator-vrf_add_debug_files}{}}}
\subsection{Method \code{vrf_add_debug_files()}}{
Special method for adding the compared files into debugger stack.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{FileComparator$vrf_add_debug_files()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-FileComparator-vrf_close_debug"></a>}}
\if{latex}{\out{\hypertarget{method-FileComparator-vrf_close_debug}{}}}
\subsection{Method \code{vrf_close_debug()}}{
Wrapper method for the stopping (closing) current debugging instance with
Debugger class.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{FileComparator$vrf_close_debug()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-FileComparator-clone"></a>}}
\if{latex}{\out{\hypertarget{method-FileComparator-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{FileComparator$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
