% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/raster-info.R
\name{vapour_raster_gcp}
\alias{vapour_raster_gcp}
\title{Raster ground control points}
\usage{
vapour_raster_gcp(x, ...)
}
\arguments{
\item{x}{data source string (i.e. file name or URL or database connection string)}

\item{...}{ignored currently}
}
\value{
list with
\itemize{
\item \code{Pixel} the pixel coordinate
\item \code{Line} the line coordinate
\item \code{X} the X coordinate of the GCP
\item \code{Y} the Y coordinate of the GCP
\item \code{Z} the Z coordinate of the GCP (usually zero)
}
}
\description{
Return any ground control points for a raster data set, if they exist.
}
\details{
Pixel and Line coordinates do not correspond to cells in the underlying raster grid, they
refer to the index space of that array in 0, ncols and 0, nrows. They are usually a subsample of
the grid and may not align with the grid spacing itself (though they often do in satellite remote sensing products).

The coordinate system of the GCPs is currently not read.
}
\examples{
## this file has no ground control points
## they are rare, and tend to be in large files
f <- system.file("extdata", "sst.tif", package = "vapour")
vapour_raster_gcp(f)

## a very made-up example with no real use
f1 <- system.file("extdata/gcps", "volcano_gcp.tif", package = "vapour")
vapour_raster_gcp(f1)

}
