% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ba_methods.R
\name{print.ba_analysis}
\alias{print.ba_analysis}
\title{Print method for ba_analysis objects}
\usage{
\method{print}{ba_analysis}(x, digits = 3, ...)
}
\arguments{
\item{x}{An object of class \code{ba_analysis}.}

\item{digits}{Number of significant digits to display (default: 3).}

\item{...}{Additional arguments (currently ignored).}
}
\value{
Invisibly returns the input object \code{x}.
}
\description{
Displays a concise summary of Bland-Altman analysis results.
}
\examples{
set.seed(42)
method_a <- rnorm(50, mean = 100, sd = 15)
method_b <- method_a + rnorm(50, mean = 2, sd = 5)
ba <- ba_analysis(method_a, method_b)
print(ba)

}
