% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/undid_stage_three.r
\name{undid_stage_three}
\alias{undid_stage_three}
\title{Computes UNDID results}
\usage{
undid_stage_three(
  dir_path,
  agg = "g",
  weights = "both",
  covariates = FALSE,
  notyet = FALSE,
  nperm = 999,
  verbose = 100,
  check_anon_size = FALSE,
  hc = "hc3",
  only = NULL,
  omit = NULL,
  max_attempts = 100
)
}
\arguments{
\item{dir_path}{A character specifying the filepath to the folder containing
all of the filled diff df CSV files.}

\item{agg}{A character which specifies the aggregation methodology for
computing the aggregate ATT in the case of staggered adoption.
Options are: \code{"silo"}, \code{"g"}, \code{"gt"}, \code{"sgt"}, \code{"time"}, \code{"none"}.
Defaults to \code{"g"}. \code{"silo"} computes a subaggregate ATT for each silo,
\code{"g"} computes a subaggregate ATT for each unique treatment time,
\code{"gt"} computes a subaggregate ATT for each unique treatment time
& post-treatment period pair, \code{"sgt"} computes a subaggregate ATT
for each treatment time & post-treatment pair, separated by silo, \code{"time"}
computes subaggregate ATTs for grouped by time since treatment, and \code{"none"}
does not compute any subaggregate ATTs, but rather computes an aggregate ATT
directly from the differences.}

\item{weights}{A string, determines which of the weighting methodologies
should be used. Options are: \code{"none"}, \code{"diff"}, \code{"att"}, or \code{"both"}.
Defaults to the weighting choice specified in the filled diff CSV files.}

\item{covariates}{A logical value (either \code{TRUE} or \code{FALSE}) which specifies
whether to use the \code{diff_estimate} column or the \code{diff_estimate_covariates}
column from the filled diff df CSV files when computing ATTs.}

\item{notyet}{A logical value which declares if the not-yet-treated
differences from treated silos should be used as controls when computing
relevant sub-aggregate ATTs. Defaults to \code{FALSE}.}

\item{nperm}{Number of random permutations of treatment assignment to use
when calculating the randomization inference p-value. Defaults to \code{999}.}

\item{verbose}{A numeric value (or \code{NULL}) which toggles messages showing
the progress of the randomization inference once every \code{verbose} iterations.
Defaults to \code{100}.}

\item{check_anon_size}{A logical value, which if \code{TRUE} displays which
silos enabled the \code{anonymize_weights} argument in stage two, and their
respective \code{anonymize_size} values. Defaults to \code{FALSE}.}

\item{hc}{Specify which heteroskedasticity-consistent covariance matrix
estimator (HCCME) should be used. Options are \code{0}, \code{1}, \code{2}, \code{3}, and
\code{4} (or \code{"hc0"}, \code{"hc1"}, \code{"hc2"}, \code{"hc3"}, \code{"hc4"}).}

\item{only}{A character vector of silos to include. Defaults to \code{NULL}.}

\item{omit}{A character vector of silos to omit. Defaults to \code{NULL}.}

\item{max_attempts}{A numeric value. Sets the maximum number of attempts
to find a new unique random permutations during the randomization
inference procedure. Defaults to \code{100}.}
}
\value{
An UnDiDObj with S3 methods of \code{summary()}, \code{plot()},
\code{print()}, and \code{coef()}.
}
\description{
Takes in all of the filled diff df CSV files and uses them to compute
group level ATTs as well as the aggregate ATT and its standard errors
and p-values. Also takes in the trends data CSV files and uses them
to produce parallel trends and event study plots.
}
\examples{

# Execute `undid_stage_three()`
dir <- system.file("extdata/staggered", package = "undidR")
\donttest{
   # Recommended: nperm >= 399 for reasonable precision
   # (~15 seconds on typical hardware)
   result <- undid_stage_three(dir, agg = "g", nperm = 399, verbose = NULL)

   # View the summary of results
   summary(result)

   # View the parallel trends plot
   plot(result)

   # View the event study plot
   plot(result, event = TRUE)
}
}
