% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/analyze.R
\name{analyze}
\alias{analyze}
\title{Runs an appropriate workflow based on the parameters passed in.}
\usage{
analyze(
  ts,
  windows = NULL,
  query = NULL,
  sample_pct = 1,
  threshold = 0.98,
  n_jobs = 1L
)
}
\arguments{
\item{ts}{a \code{matrix} or a \code{vector}. The time series to analyze.}

\item{windows}{an \code{int} or a \code{vector}. The window(s) to compute the Matrix Profile. Note that it may be an \code{int}
for a single matrix profile computation or a \code{vector} of \code{int} for computing the Pan-Matrix Profile.}

\item{query}{a \code{matrix} or a \code{vector}. Optional The query to analyze. Note that when computing the Pan-Matrix Profile
the query is ignored!}

\item{sample_pct}{a \code{numeric}. A number between 0 and 1 representing how many samples to compute for
the Matrix Profile or Pan-Matrix Profile. When it is 1, the exact algorithm is used. (default is \code{1.0}).}

\item{threshold}{a \code{numeric}. Correlation threshold. See details.  (Default is \code{0.98}).}

\item{n_jobs}{an \code{int}. The number of cpu cores to use when computing the MatrixProfile. (default is \code{1}).}
}
\value{
The appropriate Matrix Profile or Pan-Matrix Profile profile object and also plots the graphics.
}
\description{
The goal of this function is to compute all fundamental algorithms on the provided
time series data. See details for more information.
}
\details{
For now the following is computed:
\enumerate{
\item Matrix Profile - exact or approximate based on \code{sample_pct} given that a single \code{windows} is provided. By default
is the exact algorithm;
\item Top 3 Motifs;
\item Top 3 Discords;
\item Plot Matrix Profile, Motifs and Discords.
}

When \code{windows} is not provided or more than a single window is provided,
the Pan-Matrix Profile is computed:
\enumerate{
\item Compute the upper bound when a \code{threshold} is provided (it is, by default);
\item Compute Pan-Matrix Profile for all \code{windows} provided, below the upper bound, or a default range when no \code{windows}
is provided;
\item Top Motifs;
\item Top Discords;
\item Plot Pan-Matrix Profile, motifs and discords.
}
}
\examples{

# Matrix Profile
result <- analyze(mp_toy_data$data[, 1], 80)
\donttest{
# Pan Matrix Profile
result <- analyze(mp_toy_data$data[, 1])
}
}
\references{
Website: \url{http://www.cs.ucr.edu/~eamonn/MatrixProfile.html}
}
\seealso{
Other Main API: 
\code{\link{compute}()},
\code{\link{discords}()},
\code{\link{motifs}()},
\code{\link{visualize}()}
}
\concept{Main API}
