% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/explore_continuous_trend.R
\encoding{UTF-8}
\name{explore_continuous_trend}
\alias{explore_continuous_trend}
\title{Explore linear and GLM trends for continuous data with automatic model selection /
Analyse linearer und GLM-Trends fuer kontinuierliche Daten mit automatischer Modellauswahl}
\usage{
explore_continuous_trend(
  data,
  datum_col,
  value_col,
  group_col = NULL,
  df_spline = 2,
  family = c("auto", "gaussian", "gamma"),
  return_formula = FALSE,
  verbose = FALSE
)
}
\arguments{
\item{data}{Dataframe with time series continuous data. / Dataframe mit Zeitreihen-kontinuierlichen Daten.}

\item{datum_col}{Name of the time column (usually Date). / Name der Zeitspalte (normalerweise Date).}

\item{value_col}{Name of the continuous value column (dependent variable). / Name der Spalte mit kontinuierlichen Werten (abhaengige Variable).}

\item{group_col}{Optional. Name of grouping column for interaction. / Optional. Name der Gruppierungsspalte fuer Interaktion.}

\item{df_spline}{Degrees of freedom for spline (default = 2). Set to 1 for linear trend. / Freiheitsgrade fuer den Spline (Standard = 2). Setze auf 1 fuer linearen Trend.}

\item{family}{Specifies the GLM family: "auto" (default), "gaussian", or "gamma". / Gibt die GLM-Familie an: "auto" (Standard), "gaussian" oder "gamma".}

\item{return_formula}{If TRUE, returns the model formula instead of fitting. / Wenn TRUE, wird nur die Modellformel zurueckgegeben.}

\item{verbose}{Logical. Whether to print model fitting messages. / Ob Anpassungsmeldungen ausgegeben werden sollen.}
}
\value{
A list containing fitted model, formula, summary, plot, and model diagnostics. /
Eine Liste mit Modell, Formel, Zusammenfassung, Plot und Diagnosen:
\describe{
  \item{model}{The fitted GLM object. / Das angepasste GLM-Objekt.}
  \item{summary}{Model summary. / Zusammenfassung des Modells.}
  \item{plot}{ggplot2 visualization of the trend. / ggplot2-Visualisierung des Trends.}
  \item{dispersion_parameter}{Estimated dispersion. / Geschaetzter Dispersionsparameter.}
  \item{model_family_used}{Family used for final model. / Verwendete Modellfamilie.}
  \item{model_selection_info}{Information about family selection (if auto). / Hinweise zur Modellauswahl (bei auto).}
  \item{aic_comparison}{Optional AIC comparison table (if auto and gamma used). / Optionale AIC-Vergleichstabelle (bei auto mit Gamma).}
  \item{messages}{Concatenated messages from model fitting. / Konsolidierte Anpassungsmeldungen.}
}
}
\description{
Fits linear models or GLMs (Gaussian or Gamma) to continuous time series data, optionally using natural cubic splines. /
Passt lineare Modelle oder GLMs (Gaussian oder Gamma) an kontinuierliche Zeitreihendaten an, optional mit natuerlichen kubischen Splines.
}
\examples{
# Basic Gaussian GLM on continuous data
df <- data.frame(
  datum = seq.Date(from = as.Date("2023-01-01"), by = "day", length.out = 100),
  value = 5 + sin(1:100 / 10) + rnorm(100)
)
explore_continuous_trend(df, datum_col = "datum", value_col = "value", df_spline = 1)

# Automatische Auswahl zwischen Gaussian und Gamma
df2 <- data.frame(
  datum = seq.Date(from = as.Date("2023-01-01"), by = "day", length.out = 100),
  value = exp(seq(-1, 1, length.out = 100)) + rnorm(100, sd = 0.2)
)
explore_continuous_trend(df2,
                         datum_col = "datum",
                         value_col = "value",
                         df_spline = 2, family = "auto")

}
\seealso{
[explore_trend_auto()]
}
